var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { inBrowser, hasProxy } from '@kui-shell/core';
import doExecWithStdout from './exec';
import { doHelpIfRequested } from './help';
import commandPrefix from '../command-prefix';
const isHelm = (str) => /^helm$/.test(str);
export default (registrar) => {
    if (inBrowser() && !hasProxy()) {
        return;
    }
    registrar.catchall((argv) => {
        return isHelm(argv[0]) || (argv[0] === commandPrefix && isHelm(argv[1]));
    }, (args) => __awaiter(void 0, void 0, void 0, function* () {
        return doHelpIfRequested(args, yield doExecWithStdout(args));
    }), 1, { inBrowserOk: true });
};
//# sourceMappingURL=catchall.js.map