var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import doExecWithStdout from './exec';
import apiVersion from './apiVersion';
import commandPrefix from '../command-prefix';
import { doHelpIfRequested } from './help';
function doGet(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const { command, argvNoOptions } = args;
        const projIdx = argvNoOptions.indexOf('get') + 1;
        const releaseIdx = argvNoOptions.length - 1;
        const projection = projIdx < releaseIdx ? argvNoOptions[projIdx] : undefined;
        const releaseName = argvNoOptions[releaseIdx];
        const basic = /REVISION:\s+(\S+)[\n\r]+RELEASED:\s+([^\n\r]+)[\n\r]+CHART:\s+(\S+)/;
        const response = yield doExecWithStdout(args);
        if (projection) {
            return response;
        }
        const match = response.match(basic);
        if (!match) {
            return doHelpIfRequested(args, response);
        }
        const revision = match[1];
        const creationTimestamp = match[2];
        const chart = match[3];
        const endOfBasicSection = Math.min(response.indexOf('USER-SUPPLIED VALUES'), response.indexOf('COMPUTED VALUES'));
        return {
            apiVersion,
            kind: 'HelmRelease',
            metadata: {
                name: releaseName,
                generation: revision,
                creationTimestamp
            },
            summary: {
                content: response.substring(0, endOfBasicSection).trim(),
                contentType: 'yaml'
            },
            isSimulacrum: true,
            originatingCommand: command,
            data: response,
            modes: []
        };
    });
}
export default (registrar) => {
    registrar.listen(`/${commandPrefix}/helm/get`, doGet, {
        inBrowserOk: true
    });
};
//# sourceMappingURL=get.js.map