import { Common, CLI, ReplExpect } from '@kui-shell/test';
const synonyms = ['helm'];
describe(`helm repo add and search ${process.env.MOCHA_RUN_TARGET}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(helm => {
        const addRepo = () => {
            it('should add a helm repo', () => {
                return CLI.command(`${helm} repo add bitnami https://charts.bitnami.com/bitnami`, this.app)
                    .then(ReplExpect.okWithAny)
                    .catch(Common.oops(this));
            });
        };
        const listRepos = () => {
            it('should list helm repos', () => {
                return CLI.command(`${helm} repo list`, this.app)
                    .then(ReplExpect.okWith('bitnami'))
                    .catch(Common.oops(this));
            });
        };
        const searchRepo = (desiredImage) => {
            it(`should search for ${desiredImage}`, () => {
                return CLI.command(`${helm} search ${desiredImage}`, this.app)
                    .then(ReplExpect.okWith(desiredImage))
                    .catch(Common.oops(this));
            });
        };
        const deleteRepo = () => {
            it('should remove a helm repo', () => {
                return CLI.command(`${helm} repo remove bitnami`, this.app)
                    .then(ReplExpect.okWithAny)
                    .catch(Common.oops(this));
            });
        };
        addRepo();
        listRepos();
        searchRepo('nginx');
        deleteRepo();
    });
});
//# sourceMappingURL=helm-repo-add-and-search.js.map