"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const flags_1 = require("./flags");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const states_1 = require("../../lib/model/states");
function prepareArgsForDelete(args) {
    if (!Object.prototype.hasOwnProperty.call(args.parsedOptions, 'wait')) {
        return args.command + ' --wait=false';
    }
    else {
        return args.command;
    }
}
exports.doDelete = (command = 'kubectl') => exec_1.doExecWithStatus('delete', states_1.FinalState.OfflineLike, command, prepareArgsForDelete);
exports.default = (registrar) => {
    const handler = exports.doDelete();
    registrar.listen(`/${command_prefix_1.default}/kubectl/delete`, handler, flags_1.default);
    registrar.listen(`/${command_prefix_1.default}/k/delete`, handler, flags_1.default);
};
//# sourceMappingURL=delete.js.map