"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const flags_1 = require("./flags");
const exec_1 = require("./exec");
const command_prefix_1 = require("../command-prefix");
const get_1 = require("./get");
const util_1 = require("../../lib/util/util");
function prepareArgsForDescribe(args) {
    return `${args.command.replace(/(k|kubectl|oc)(\s+)describe(\s+)/, '$1$2get$3')} -o yaml`;
}
exports.doDescribe = (command = 'kubectl') => function (args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (exec_1.isUsage(args) || util_1.commandWithoutResource(args)) {
            return exec_1.exec(args, undefined, command);
        }
        else {
            const response = yield exec_1.exec(args, prepareArgsForDescribe, command);
            return get_1.doGetAsEntity(args, response);
        }
    });
};
exports.default = (registrar) => {
    const handler = exports.doDescribe();
    registrar.listen(`/${command_prefix_1.default}/kubectl/describe`, handler, flags_1.default);
    registrar.listen(`/${command_prefix_1.default}/k/describe`, handler, flags_1.default);
};
//# sourceMappingURL=describe.js.map