"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const command_prefix_1 = require("../command-prefix");
const options_1 = require("./options");
const help_1 = require("../../lib/util/help");
const util_1 = require("../../lib/util/util");
const formatTable_1 = require("../../lib/view/formatTable");
const strings = core_1.i18n('plugin-kubeui');
const NoPrepare = (args) => args.command;
function DefaultPrepareForStatus(cmd, args) {
    const rest = args.argvNoOptions.slice(args.argvNoOptions.indexOf(cmd) + 1).join(' ');
    const file = options_1.fileOf(args);
    return file ? `-f ${options_1.fileOf(args)} ${rest}` : rest;
}
function doExecWithoutPty(args, prepare = NoPrepare, exec = 'kubectl') {
    const raw = `_${exec}$1`;
    const command = prepare(args)
        .replace(new RegExp(`^${exec}(\\s)?`), raw)
        .replace(/^k(\s)?/, raw);
    const dbl = new RegExp(`_${exec}(\\s)?`);
    const doubleCheck = dbl.test(command) ? command : `_${exec} ${command}`;
    return args.REPL.qexec(doubleCheck, undefined, undefined, args.execOptions).catch((err) => {
        if (err.code === 500 || err.statusCode === 500) {
            err.code = err.statusCode = 500;
        }
        throw err;
    });
}
function doExecWithStdout(args, prepare = NoPrepare, exec) {
    return doExecWithoutPty(args, prepare, exec).then(_ => _.content.stdout);
}
exports.doExecWithStdout = doExecWithStdout;
const isKubectl = (args) => (args.argvNoOptions.length === 1 && /^k(ubectl)?$/.test(args.argvNoOptions[0])) ||
    (args.argvNoOptions.length === 2 &&
        args.argvNoOptions[0] === command_prefix_1.default &&
        /^k(ubectl)?$/.test(args.argvNoOptions[1]));
exports.isUsage = (args) => options_1.isHelpRequest(args) || isKubectl(args);
function doHelp(args, response) {
    const verb = args.argvNoOptions.length >= 2 ? args.argvNoOptions[1] : '';
    const command = util_1.getCommandFromArgs(args);
    throw help_1.renderHelp(response.content.stdout, command === 'k' ? 'kubectl' : command, verb, response.content.code);
}
function doExecWithPty(args, prepare = NoPrepare) {
    return __awaiter(this, void 0, void 0, function* () {
        if (core_1.isHeadless() || (!core_1.inBrowser() && args.execOptions.raw)) {
            return doExecWithStdout(args, prepare);
        }
        else {
            if (exports.isUsage(args)) {
                const response = yield doExecWithoutPty(args, prepare);
                doHelp(args, response);
            }
            else {
                const commandToPTY = args.command.replace(/^k(\s)/, 'kubectl$1');
                return args.REPL.qexec(`sendtopty ${commandToPTY}`, args.block, undefined, args.execOptions.onInit
                    ? args.execOptions
                    : Object.assign({}, args.execOptions, {
                        rawResponse: true,
                        quiet: args.execOptions.quiet === undefined
                            ? args.execOptions.type === core_1.ExecType.TopLevel
                                ? false
                                : undefined
                            : args.execOptions.quiet
                    })).catch((err) => {
                    if (err.code === 500 || err.statusCode === 500) {
                        err.code = err.statusCode = 500;
                    }
                    throw err;
                });
            }
        }
    });
}
exports.doExecWithPty = doExecWithPty;
function exec(args, prepare = NoPrepare, exec = 'kubectl') {
    return __awaiter(this, void 0, void 0, function* () {
        if (args.argvNoOptions.includes('|')) {
            return Promise.resolve({
                content: {
                    code: 0,
                    stdout: yield doExecWithPty(args, prepare),
                    stderr: '',
                    wasSentToPty: true
                }
            });
        }
        else {
            const response = yield doExecWithoutPty(args, prepare, exec);
            if (exports.isUsage(args)) {
                doHelp(args, response);
            }
            else {
                return response;
            }
        }
    });
}
exports.exec = exec;
function doExecWithTable(args, prepare = NoPrepare) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield doExecWithoutPty(args, prepare);
        const table = formatTable_1.stringToTable(response.content.stdout, response.content.stderr, args);
        if (typeof table === 'string') {
            throw new Error(strings('Unable to parse table'));
        }
        else {
            return table;
        }
    });
}
exports.doExecWithTable = doExecWithTable;
exports.doExecWithStatus = (cmd, finalState, command = 'kubectl', prepareForExec = NoPrepare, prepareForStatus = DefaultPrepareForStatus) => (args) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield exec(args, prepareForExec, command);
    if (response.content.code !== 0) {
        const err = new Error(response.content.stderr);
        err.code = response.content.code;
        throw err;
    }
    else if (core_1.isHeadless()) {
        return response.content.stdout;
    }
    else {
        const contextArgs = `${options_1.getNamespaceForArgv(args)} ${options_1.getContextForArgv(args)}`;
        const watchArgs = `--final-state ${finalState} --watch`;
        const errorReportingArgs = `--response "${response.content.stdout}"`;
        const statusArgs = prepareForStatus(cmd, args);
        const commandArgs = `--command ${command}`;
        const statusCmd = `${command_prefix_1.default} status ${statusArgs} ${watchArgs} ${contextArgs} ${errorReportingArgs} ${commandArgs}`;
        return args.REPL.qexec(statusCmd, args.block);
    }
});
exports.default = exec;
//# sourceMappingURL=exec.js.map