"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const strings = core_1.i18n('plugin-kubeui');
const formatTimestamp = (timestamp) => {
    if (!timestamp) {
        return '';
    }
    else {
        return new Date(timestamp).toLocaleString();
    }
};
exports.renderConditions = (tab, resource) => __awaiter(void 0, void 0, void 0, function* () {
    const anyProbeTimes = resource.status.conditions.some(_ => !!_.lastProbeTime);
    const probeHeader = anyProbeTimes
        ? [{ value: 'LAST PROBE', outerCSS: 'header-cell min-width-date-like' }]
        : [];
    const probeBody = (condition) => {
        if (anyProbeTimes) {
            return [
                {
                    key: 'lastProbeTime',
                    value: formatTimestamp(condition.lastProbeTime),
                    outerCSS: 'min-width-date-like smaller-text'
                }
            ];
        }
        else {
            return [];
        }
    };
    const anyMessages = resource.status.conditions.some(_ => !!_.message);
    const messageHeader = anyMessages ? [{ value: 'MESSAGE' }] : [];
    const messageBody = (condition) => {
        if (anyMessages) {
            return [
                {
                    key: 'message',
                    value: condition.message,
                    css: 'pre-wrap'
                }
            ];
        }
        else {
            return [];
        }
    };
    const standardHeaderCells = [
        { value: 'TRANSITION TIME' },
        { value: 'STATUS', outerCSS: 'very-narrow text-center' }
    ];
    const headerModel = {
        type: 'condition',
        name: 'CONDITION',
        outerCSS: 'header-cell',
        attributes: probeHeader.concat(standardHeaderCells).concat(messageHeader)
    };
    resource.status.conditions.sort((a, b) => {
        if (!a.lastTransitionTime && b.lastTransitionTime) {
            return 1;
        }
        else if (!b.lastTransitionTime && a.lastTransitionTime) {
            return -1;
        }
        else if (!a.lastTransitionTime && !b.lastTransitionTime) {
            return 0;
        }
        else {
            return new Date(b.lastTransitionTime).getTime() - new Date(a.lastTransitionTime).getTime();
        }
    });
    const bodyModel = resource.status.conditions.map(condition => {
        const success = condition.status === 'True' || /Succeed/i.test(condition.reason);
        const failure = condition.status === 'False' || /Failed/i.test(condition.reason);
        const standardBodyCells = [
            {
                key: 'lastTransitionTime',
                value: formatTimestamp(condition.lastTransitionTime),
                outerCSS: 'min-width-date-like smaller-text'
            },
            {
                key: 'status',
                value: (condition.status || condition.reason).toString(),
                outerCSS: 'text-center',
                fontawesome: success ? 'fas fa-check-circle' : failure ? 'fas fa-times-circle' : 'fas fa-question-circle',
                css: 'larger-text ' + (success ? 'green-text' : failure ? 'red-text' : 'yellow-text')
            }
        ];
        return {
            type: 'condition',
            name: condition.type || condition.reason,
            outerCSS: 'entity-name-group-narrow',
            onclick: false,
            attributes: probeBody(condition)
                .concat(standardBodyCells)
                .concat(messageBody(condition))
        };
    });
    const tableModel = {
        header: headerModel,
        body: bodyModel,
        noSort: true,
        title: 'Conditions'
    };
    return tableModel;
});
exports.default = {
    when: (resource) => {
        return !!(resource.status && resource.status.conditions);
    },
    mode: {
        mode: 'conditions',
        label: strings('conditions'),
        content: exports.renderConditions
    }
};
//# sourceMappingURL=conditions.js.map