"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const table_to_map_1 = require("./table-to-map");
const fqn_1 = require("../../../controller/kubectl/fqn");
const resource_1 = require("../../model/resource");
const util_1 = require("../../util/util");
const strings = core_1.i18n('plugin-kubeui');
function renderSummary(tab, resource, args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (resource_1.isKubeResourceWithItsOwnSummary(resource)) {
            return resource.summary;
        }
        const cmd = `${util_1.getCommandFromArgs(args)} get ${fqn_1.fqnOf(resource)} -o wide`;
        const [map, { safeDump }] = yield Promise.all([tab.REPL.qexec(cmd).then(table_to_map_1.default), Promise.resolve().then(() => require('js-yaml'))]);
        return {
            content: safeDump(map),
            contentType: 'yaml'
        };
    });
}
const summaryMode = {
    when: resource_1.isSummarizableKubeResource,
    mode: {
        mode: 'summary',
        label: strings('summary'),
        content: renderSummary,
        defaultMode: true,
        order: -999
    }
};
exports.default = summaryMode;
//# sourceMappingURL=summary.js.map