"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('plugins/kubeui/preload');
debug('loading');
const core_1 = require("@kui-shell/core");
exports.default = (registrar) => __awaiter(void 0, void 0, void 0, function* () {
    if (!core_1.isHeadless()) {
        const preloader = (yield Promise.resolve().then(() => require('./non-headless-preload'))).default;
        yield preloader(registrar);
        const [{ default: currentContextUI }, { default: currentNamespaceUI }] = yield Promise.all([
            Promise.resolve().then(() => require('./lib/view/status-stripe/current-context')),
            Promise.resolve().then(() => require('./lib/view/status-stripe/current-namespace'))
        ]);
        registrar.registerContext(currentContextUI());
        registrar.registerContext(currentNamespaceUI());
    }
});
debug('finished loading');
//# sourceMappingURL=preload.js.map