export function versionOf(apiVersion) {
    const [group, version] = apiVersion.split('/');
    if (!version) {
        return { group: '', version: '' };
    }
    else {
        return { group, version };
    }
}
function versionString(apiVersion) {
    const { group, version } = versionOf(apiVersion);
    return group.length > 0 ? `.${version}.${group}` : '';
}
export function fqn(apiVersion, kind, name, namespace) {
    return `${kind}${versionString(apiVersion)} ${namespace === '<none>' ? '' : `-n ${namespace}`} ${name}`;
}
export function fqnOf(resource) {
    return fqn(resource.apiVersion, resource.kind, resource.metadata.name, resource.metadata.namespace);
}
export function fqnOfRef({ group, version, kind, name, namespace }) {
    return `${kind}${group ? `.${version}.${group}` : ''} ${namespace === '<none>' ? '' : `-n ${namespace}`} ${name}`;
}
export default fqn;
//# sourceMappingURL=fqn.js.map