import { Arguments, ExecOptions, ParsedOptions } from '@kui-shell/core';
import { FinalState } from '../../lib/model/states';
declare type EntityFormat = 'yaml' | 'json';
declare type TableFormat = 'wide' | string;
declare type CustomFormat = string;
declare type OutputFormat = EntityFormat | TableFormat | CustomFormat;
export declare function fileOf(args: Arguments<KubeOptions>): string;
export declare function formatOf(args: Arguments<KubeOptions>): OutputFormat;
export declare function isEntityFormat(format: OutputFormat): format is EntityFormat;
export declare function isEntityRequest(args: Arguments<KubeOptions>): boolean;
export declare function isHelpRequest(args: Arguments<KubeOptions>): boolean;
export declare function isTableRequest(args: Arguments<KubeOptions>): boolean;
export declare function isWatchRequest(args: Arguments<KubeOptions>): boolean;
export declare function isTableWatchRequest(args: Arguments<KubeOptions>): boolean;
export declare function getLabel(args: Arguments<KubeOptions>): string;
export declare function getLabelForArgv(args: Arguments<KubeOptions>): string;
export declare function hasLabel(args: Arguments<KubeOptions>): boolean;
export declare function getNamespace(args: Arguments<KubeOptions>): string;
export declare function getNamespaceForArgv(args: Arguments<KubeOptions>): string;
export declare function getContext(args: Arguments<KubeOptions>): string;
export declare function getContextForArgv(args: Arguments<KubeOptions>): string;
export interface KubeExecOptions extends ExecOptions {
    finalState: FinalState;
    nResourcesToWaitFor: number;
    initialResponse: string;
}
export interface KubeOptions extends ParsedOptions {
    A?: boolean;
    'all-namespaces'?: boolean;
    context?: string;
    n?: string;
    namespace?: string;
    o?: OutputFormat;
    output?: OutputFormat;
    w?: boolean;
    watch?: boolean;
    'watch-only'?: boolean;
    wait?: boolean;
    l?: string;
    label?: string;
    f?: string;
    filename?: string;
    h?: boolean;
    help?: boolean;
}
export declare function isForAllNamespaces(args: Arguments<KubeOptions>): boolean;
export default KubeOptions;
