export function fileOf(args) {
    return args.parsedOptions.f || args.parsedOptions.filename;
}
export function formatOf(args) {
    return args.parsedOptions.o || args.parsedOptions.output;
}
export function isEntityFormat(format) {
    return format === 'yaml' || format === 'json';
}
export function isEntityRequest(args) {
    return isEntityFormat(formatOf(args));
}
function isTableFormat(format) {
    return !format || format === 'wide' || /^custom-columns=/.test(format) || /^custom-columns-file=/.test(format);
}
export function isHelpRequest(args) {
    return args.parsedOptions.help || args.parsedOptions.h;
}
export function isTableRequest(args) {
    return isTableFormat(formatOf(args));
}
export function isWatchRequest(args) {
    return args.parsedOptions.w || args.parsedOptions.watch || args.parsedOptions['watch-only'];
}
export function isTableWatchRequest(args) {
    return isWatchRequest(args) && isTableRequest(args);
}
export function getLabel(args) {
    return args.parsedOptions.l || args.parsedOptions.label;
}
export function getLabelForArgv(args) {
    const label = getLabel(args);
    if (label) {
        return `-l ${label}`;
    }
    else {
        return '';
    }
}
export function hasLabel(args) {
    if (args.parsedOptions.l || args.parsedOptions.label) {
        return true;
    }
    for (const key in args.parsedOptions) {
        if (/^l/.test(key)) {
            return true;
        }
    }
    return false;
}
export function getNamespace(args) {
    return args.parsedOptions.n || args.parsedOptions.namespace;
}
export function getNamespaceForArgv(args) {
    const ns = getNamespace(args);
    if (ns) {
        return `-n ${ns}`;
    }
    else {
        return '';
    }
}
export function getContext(args) {
    return args.parsedOptions.context;
}
export function getContextForArgv(args) {
    const context = getContext(args);
    if (context) {
        return `--context ${context}`;
    }
    else {
        return '';
    }
}
export function isForAllNamespaces(args) {
    return args.parsedOptions.A || args.parsedOptions['all-namespaces'];
}
//# sourceMappingURL=options.js.map