import kubeuiApiVersion from '../../controller/kubectl/apiVersion';
export class DefaultKubeStatus {
    constructor() {
        this.message = undefined;
    }
}
export class DefaultKubeMetadata {
    constructor() {
        this.kind = undefined;
        this.name = undefined;
    }
}
export function hasRawData(resource) {
    const withData = resource;
    return typeof withData.data === 'string';
}
export function isNamespaced(resource) {
    return resource.metadata !== undefined && resource.metadata.namespace !== undefined;
}
export function isKubeResource(entity) {
    const kube = entity;
    return kube.apiVersion !== undefined && kube.apiVersion !== kubeuiApiVersion && kube.kind !== undefined;
}
export function isCrudableKubeResource(entity) {
    return isKubeResource(entity) && !entity.isSimulacrum;
}
export function isKubeResourceWithItsOwnSummary(resource) {
    return resource !== undefined && resource.summary !== undefined;
}
export function isSummarizableKubeResource(resource) {
    return (isKubeResource(resource) &&
        (isKubeResourceWithItsOwnSummary(resource) ||
            (resource.kind !== undefined && resource.kind !== 'List' && resource.kind !== 'CustomResourceDefinition')));
}
export function isRole(resource) {
    const role = resource;
    return role.rules !== undefined;
}
export function isRoleBinding(resource) {
    const rb = resource;
    return rb.roleRef !== undefined && rb.subjects !== undefined;
}
export function isServiceAccount(resource) {
    const sa = resource;
    return sa.secrets !== undefined;
}
export function isPod(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'Pod';
}
export function isNamespace(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'Namespace';
}
export function isJob(resource) {
    return resource.apiVersion === 'batch/v1' && resource.kind === 'Job';
}
export function isDeployment(resource) {
    return resource.apiVersion === 'extensions/v1beta1' && resource.kind === 'Deployment';
}
export function hasInvolvedObject(resource) {
    const io = resource;
    return (io.involvedObject !== undefined &&
        typeof io.involvedObject.apiVersion === 'string' &&
        typeof io.involvedObject.kind === 'string' &&
        typeof io.involvedObject.name === 'string');
}
export function isEvent(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'Event';
}
export function isKubeItems(resource) {
    return resource.apiVersion === 'v1' && resource.kind === 'List';
}
export function isCustomResourceDefinition(resource) {
    return ((resource.apiVersion === 'apiextensions.k8s.io/v1' || resource.apiVersion === 'apiextensions.k8s.io/v1beta1') &&
        resource.kind === 'CustomResourceDefinition');
}
//# sourceMappingURL=resource.js.map