var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import { inBrowser, isHeadless, hasProxy, i18n } from '@kui-shell/core';
const strings = i18n('plugin-kubeui');
const debug = Debug('plugin-kubeui/util/fetch-file');
function needle(tab, method, url) {
    return __awaiter(this, void 0, void 0, function* () {
        if (isHeadless()) {
            const needle = yield import('needle');
            debug('fetch via needle', needle);
            return needle(method, url, { follow_max: 10 }).then(_ => ({ statusCode: _.statusCode, body: _.body }));
        }
        else if (inBrowser()) {
            if (!hasProxy()) {
                throw new Error(strings('Unable to fetch remote file'));
            }
            else {
                debug('fetch via proxy');
                const body = yield tab.REPL.qexec(`_fetchfile ${url}`);
                debug('fetched via proxy', body);
                return {
                    statusCode: 200,
                    body
                };
            }
        }
        else {
            debug('fetch via electron.net');
            const { net } = (yield import('electron')).remote;
            return new Promise((resolve, reject) => {
                const request = net.request({
                    method,
                    url,
                    redirect: 'follow'
                });
                request.on('response', response => {
                    const statusCode = response.statusCode;
                    debug('got response', statusCode);
                    let body = '';
                    response.on('end', () => {
                        debug('got end');
                        if (response.statusCode < 300) {
                            resolve({ statusCode, body });
                        }
                        else {
                            const error = new Error(body);
                            error.statusCode = statusCode;
                            reject(error);
                        }
                    });
                    response.on('data', chunk => {
                        debug('got chunk', chunk.toString());
                        body += chunk.toString();
                    });
                });
                request.end();
            });
        }
    });
}
export function fetchFile(tab, url) {
    debug('fetchFile', url);
    const urls = url.split(/,/);
    return Promise.all(urls.map((url) => __awaiter(this, void 0, void 0, function* () {
        if (url.match(/http(s)?:\/\//)) {
            debug('fetch remote', url);
            const fetchOnce = () => needle(tab, 'get', url).then(_ => _.body);
            const retry = (delay) => (err) => __awaiter(this, void 0, void 0, function* () {
                if (/timeout/.test(err.message) || /hang up/.test(err.message) || /hangup/.test(err.message)) {
                    debug('retrying', err);
                    yield new Promise(resolve => setTimeout(resolve, delay));
                    return fetchOnce();
                }
                else {
                    throw err;
                }
            });
            return fetchOnce()
                .catch(retry(500))
                .catch(retry(1000))
                .catch(retry(5000));
        }
        else {
            const filepath = url;
            debug('fetch local', filepath);
            const stats = (yield tab.REPL.rexec(`fstat ${tab.REPL.encodeComponent(filepath)} --with-data`)).content;
            return stats.data;
        }
    })));
}
export function fetchFileString(tab, url) {
    return __awaiter(this, void 0, void 0, function* () {
        const files = yield fetchFile(tab, url);
        return files.map(_ => _.toString());
    });
}
export default fetchFileString;
//# sourceMappingURL=fetch-file.js.map