var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
const debug = Debug('k8s/util/retry');
export const withRetryOnCode = (code) => (fn, cmd) => new Promise((resolve, reject) => {
    const iter = () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            resolve(yield fn());
        }
        catch (err) {
            if (err.code === code) {
                debug('retrying', cmd);
                setTimeout(iter, 5000);
            }
            else {
                debug('rejecting', err.code, err);
                reject(err);
            }
        }
    });
    iter();
});
export const withOkOnCode = (code) => (fn, cmd) => fn().catch((err) => {
    if (err.code === code) {
        debug('404 ok', cmd);
    }
    else {
        throw err;
    }
});
export const withOkOn404 = withOkOnCode(404);
export const withRetryOn404 = withRetryOnCode(404);
//# sourceMappingURL=retry.js.map