import Debug from 'debug';
const debug = Debug('k8s/view/util/selectors');
export const selectorToString = (selector) => {
    if (selector.matchLabels) {
        return selectorToString(selector.matchLabels);
    }
    else if (selector.matchExpressions) {
        return '';
    }
    const stringified = Object.keys(selector)
        .map(key => `-l ${key}=${selector[key]}`)
        .join(' ');
    debug('selectorToString', stringified, selector);
    return stringified;
};
//# sourceMappingURL=selectors.js.map