import { i18n } from '@kui-shell/core';
import { isNamespace } from '../../model/resource';
import { doSummarizeNamedNamespace } from '../../../controller/kubectl/get-namespaces';
const mode = 'resources';
const label = i18n('plugin-kubeui')(mode);
function content(tab, resource) {
    return doSummarizeNamedNamespace(tab, resource.metadata.name);
}
const summaryMode = {
    when: isNamespace,
    mode: {
        mode,
        label,
        content
    }
};
export default summaryMode;
//# sourceMappingURL=namespace-summary.js.map