var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { selectorToString } from '../../util/selectors';
import { getCommandFromArgs } from '../../util/util';
function renderPods(tab, resource, args) {
    return __awaiter(this, void 0, void 0, function* () {
        const { selector } = resource.spec;
        const getPods = selector
            ? `${getCommandFromArgs(args)} get pods ${selectorToString(selector)} -n "${resource.metadata.namespace}"`
            : `${getCommandFromArgs(args)} get pods ${resource.status.podName} -n "${resource.metadata.namespace}"`;
        const tableModel = tab.REPL.qexec(getPods);
        return tableModel;
    });
}
function hasPods(resource) {
    return resource.kind === 'Deployment' || (resource.status !== undefined && resource.status.podName !== undefined);
}
export const podMode = {
    when: hasPods,
    mode: {
        mode: 'pods',
        content: renderPods
    }
};
export default podMode;
//# sourceMappingURL=pods.js.map