var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n } from '@kui-shell/core';
import toMap from './table-to-map';
import { fqnOf } from '../../../controller/kubectl/fqn';
import { isSummarizableKubeResource, isKubeResourceWithItsOwnSummary } from '../../model/resource';
import { getCommandFromArgs } from '../../util/util';
const strings = i18n('plugin-kubeui');
function renderSummary(tab, resource, args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (isKubeResourceWithItsOwnSummary(resource)) {
            return resource.summary;
        }
        const cmd = `${getCommandFromArgs(args)} get ${fqnOf(resource)} -o wide`;
        const [map, { safeDump }] = yield Promise.all([tab.REPL.qexec(cmd).then(toMap), import('js-yaml')]);
        return {
            content: safeDump(map),
            contentType: 'yaml'
        };
    });
}
const summaryMode = {
    when: isSummarizableKubeResource,
    mode: {
        mode: 'summary',
        label: strings('summary'),
        content: renderSummary,
        defaultMode: true,
        order: -999
    }
};
export default summaryMode;
//# sourceMappingURL=summary.js.map