var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors, SidecarExpect, Util } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS, allocateNS, deleteNS, waitTillNone } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const synonyms = ['kubectl'];
describe(`kubectl configmap ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        const getText = () => {
            return this.app.client
                .execute(() => {
                return document.querySelector('.monaco-editor-wrapper')['editor'].getValue();
            })
                .then(res => res.value);
        };
        const expectContent = (content) => {
            return this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const ok = yield getText().then(Util.expectYAMLSubset(content, false));
                return ok;
            }));
        };
        const listAndClick = (name, content) => {
            it(`should list configmaps via ${kubectl} then click on ${name}`, () => __awaiter(this, void 0, void 0, function* () {
                try {
                    const selector = yield CLI.command(`${kubectl} get cm ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }));
                    yield this.app.client.click(`${selector} .clickable`);
                    yield SidecarExpect.open(this.app)
                        .then(SidecarExpect.mode(defaultModeForGet))
                        .then(SidecarExpect.showing(name));
                    if (content) {
                        yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('raw'));
                        yield expectContent(content);
                    }
                }
                catch (err) {
                    return Common.oops(this)(err);
                }
            }));
        };
        const deleteIt = (name) => {
            it(`should delete the configmap ${name} via ${kubectl} `, () => {
                return CLI.command(`${kubectl} delete cm ${name} ${inNamespace}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }))
                    .then(selector => waitForRed(this.app, selector))
                    .then(() => waitTillNone('configmap', undefined, name, undefined, inNamespace))
                    .catch(Common.oops(this));
            });
        };
        const createIt = (name, literals = '') => {
            it(`should create a configmap ${name} via ${kubectl}`, () => {
                return CLI.command(`${kubectl} create configmap ${name} ${literals} ${inNamespace}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this));
            });
        };
        allocateNS(this, ns);
        createIt('yoyo');
        createIt('momo', '--from-literal hello=world');
        listAndClick('yoyo');
        listAndClick('momo', {
            data: {
                hello: 'world'
            }
        });
        deleteIt('yoyo');
        deleteIt('momo');
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=config-map.js.map