var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const synonyms = ['kubectl'];
describe(`kubectl apply deployment against redirecting URL ${process.env.MOCHA_RUN_TARGET ||
    ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns);
        it(`should apply with a redirecting URL via ${kubectl}`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`${kubectl} apply -f https://k8s.io/examples/controllers/nginx-deployment.yaml ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({
                    selector: Selectors.BY_NAME('nginx-deployment')
                }));
                yield waitForGreen(this.app, selector);
                yield this.app.client.click(`${selector} .clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('nginx-deployment'));
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
        it(`should delete the deployment from redirecting URL via ${kubectl}`, () => {
            return CLI.command(`${kubectl} delete -f https://k8s.io/examples/controllers/nginx-deployment.yaml ${inNamespace}`, this.app)
                .then(ReplExpect.okWithCustom({
                selector: Selectors.BY_NAME('nginx-deployment')
            }))
                .then(selector => waitForRed(this.app, selector))
                .catch(Common.oops(this, true));
        });
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=redirects.js.map