var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, createNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const ns1 = createNS();
const ns2 = createNS();
const kubectl = 'kubectl';
const waitForDelete = function ({ name }) {
    it(`should wait for deletion of resource named ${name}`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield waitForRed(this.app, Selectors.BY_NAME(name));
        }
        catch (err) {
            return Common.oops(this)(err);
        }
    }));
};
const verifyTextExists = function (expectedSubstring) {
    return __awaiter(this, void 0, void 0, function* () {
        yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            const actualText = yield this.app.client.getText(`${Selectors.SIDECAR} .monaco-editor .view-lines`);
            return actualText.indexOf(expectedSubstring) >= 0;
        }));
    });
};
const waitForCreate = function (spec) {
    const { name, kind, ns } = spec;
    it(`should wait for creation of resource named ${name} in namespace ${ns}`, () => __awaiter(this, void 0, void 0, function* () {
        const textExists = verifyTextExists.bind(this);
        const waitForIcon = () => __awaiter(this, void 0, void 0, function* () {
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const iconText = yield this.app.client.getText(`${Selectors.SIDECAR} .sidecar-header-icon`);
                return new RegExp(kind, 'i').test(iconText);
            }));
        });
        const waitForDescribeContent = () => __awaiter(this, void 0, void 0, function* () {
            yield waitForIcon();
            const textExists = (key, value) => __awaiter(this, void 0, void 0, function* () {
                return this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                    const actualText = yield this.app.client.getText(`${Selectors.SIDECAR} .monaco-editor .view-lines`);
                    return new RegExp(`${key.toUpperCase()}:\\s+${value}`).test(actualText);
                }));
            });
            return Promise.all([textExists('Name', name), textExists('Status', spec.status)]);
        });
        const waitForRawContent = () => __awaiter(this, void 0, void 0, function* () {
            yield waitForIcon();
            yield textExists(`apiVersion: v1`);
            yield textExists(`kind: ${kind}`);
        });
        try {
            yield waitForGreen(this.app, Selectors.BY_NAME(name));
            yield this.app.client.click(`${Selectors.BY_NAME(name)} .clickable`);
            yield waitForDescribeContent();
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield waitForRawContent();
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('summary'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('summary'));
            yield waitForDescribeContent();
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('raw'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('raw'));
        }
        catch (err) {
            return Common.oops(this, true)(err);
        }
    }));
};
const pod = 'nginx';
Common.localDescribe(`popup create pod creating namespace ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'create', 'ns', ns1] }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: ns1, kind: 'Namespace', status: 'Active' });
});
Common.localDescribe(`popup create pod creating pod in ${ns1}`, function () {
    before(Common.before(this, {
        popup: [
            kubectl,
            'create',
            '-f',
            'https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod',
            '-n',
            ns1
        ]
    }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: pod, kind: 'Pod', ns: ns1, status: 'Running' });
});
Common.localDescribe(`popup create pod creating namespace ${ns2}`, function () {
    before(Common.before(this, { popup: [kubectl, 'create', 'ns', ns2] }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: ns2, kind: 'Namespace', status: 'Active' });
});
Common.localDescribe(`popup create pod creating pod in ${ns2}`, function () {
    before(Common.before(this, {
        popup: [
            kubectl,
            'create',
            '-f',
            'https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod',
            '-n',
            ns2
        ]
    }));
    after(Common.after(this));
    waitForCreate.bind(this)({ name: pod, kind: 'Pod', ns: ns2, status: 'Running' });
});
Common.localDescribe(`popup create pod deleting pod in ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'pod', pod, '-n', ns1] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: pod });
});
Common.localDescribe(`popup create pod deleting pod in ${ns2}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'pod', pod, '-n', ns2] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: pod });
});
Common.localDescribe(`popup create pod deleting namespace ${ns1}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'ns', ns1] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: ns1 });
});
Common.localDescribe(`popup create pod deleting namespace ${ns2}`, function () {
    before(Common.before(this, { popup: [kubectl, 'delete', 'ns', ns2] }));
    after(Common.after(this));
    waitForDelete.bind(this)({ name: ns2 });
});
//# sourceMappingURL=create-pod-popup.js.map