var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import { readFileSync } from 'fs';
import { dirname, join } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const inputBuffer = readFileSync(join(ROOT, 'data/k8s/event-generator.yaml'));
const inputEncoded = inputBuffer.toString('base64');
const podName = 'eventgen';
const sleepTime = 10;
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
function sleep(N) {
    return new Promise(resolve => setTimeout(resolve, N * 1000));
}
commands.forEach(command => {
    describe(`${command} get events ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        allocateNS(this, ns);
        it('should create pod that generates events', () => CLI.command(`echo ${inputEncoded} | base64 --decode | kubectl create -f - -n ${ns}`, this.app)
            .then(ReplExpect.okWithString(podName))
            .catch(Common.oops(this, true)));
        it('should open pod in sidecar, then click on events button', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const res = yield CLI.command(`${command} get pod ${podName} -n ${ns} -o yaml`, this.app);
                yield Promise.resolve(res)
                    .then(ReplExpect.justOK)
                    .then(SidecarExpect.open)
                    .then(SidecarExpect.showing(podName))
                    .catch(Common.oops(this, true));
                yield sleep(sleepTime);
                yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('events'));
                yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('events'));
                yield Promise.resolve({ app: this.app, count: res.count + 1 }).then(ReplExpect.okWithAny);
                const table = `${Selectors.OUTPUT_N(res.count + 1)} .result-table`;
                const header = ['TYPE', 'REASON', 'LAST SEEN', 'FIRST SEEN', 'MESSAGE'];
                yield Promise.all(header.map((_header) => __awaiter(this, void 0, void 0, function* () {
                    yield this.app.client.waitForExist(`${table} .header-row .header-cell .cell-inner[data-key="${_header}"]`);
                })));
                yield this.app.client.click(`${table} tr:first-child .clickable`);
                yield SidecarExpect.open(this.app).then(SidecarExpect.kind('EVENT'));
            }
            catch (err) {
                yield SidecarExpect.open(this.app).then(SidecarExpect.kind('EVENT'));
                yield Common.oops(this, true);
            }
        }));
        it('should click on Show Involved Object', () => __awaiter(this, void 0, void 0, function* () {
            yield this.app.client.waitForVisible(Selectors.SIDECAR_MODE_BUTTON('involvedObject'));
            yield this.app.client.click(Selectors.SIDECAR_MODE_BUTTON('involvedObject'));
            yield SidecarExpect.open(this.app)
                .then(SidecarExpect.showing(podName))
                .then(SidecarExpect.kind('POD'));
        }));
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=events.js.map