var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import * as assert from 'assert';
const podName = 'nginx';
const url = 'https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod';
var Status;
(function (Status) {
    Status["Offline"] = "red-background";
    Status["Online"] = "green-background";
})(Status || (Status = {}));
const waitForStatus = function (status, res) {
    return __awaiter(this, void 0, void 0, function* () {
        const selector = yield ReplExpect.okWithCustom({
            selector: Selectors.BY_NAME(podName)
        })(res);
        if (status === Status.Offline) {
            return waitForRed(this.app, selector);
        }
        else {
            return waitForGreen(this.app, selector);
        }
    });
};
const createAndDeletePod = function (kubectl, ns) {
    it(`should create then delete sample pod from URL via ${kubectl}`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const waitForOnline = waitForStatus.bind(this, Status.Online);
            const waitForOffline = waitForStatus.bind(this, Status.Offline);
            const selector1 = yield waitForOnline(yield CLI.command(`${kubectl} create -f ${url} -n ${ns}`, this.app));
            const selector2 = yield waitForOffline(yield CLI.command(`${kubectl} delete -f ${url} -n ${ns}`, this.app));
            yield this.app.client.waitForExist(selector1);
            const selector3 = yield waitForOnline(yield CLI.command(`${kubectl} create -f ${url} -n ${ns}`, this.app));
            yield this.app.client.waitForExist(selector2);
            yield waitForOffline(yield CLI.command(`${kubectl} delete -f ${url} -n ${ns}`, this.app));
            yield this.app.client.waitForExist(selector1);
            yield this.app.client.waitForExist(selector2);
            yield this.app.client.waitForExist(selector3);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
};
const watchPods = function (kubectl, ns) {
    it(`should watch pods via ${kubectl} get pods -w`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const waitForOnline = waitForStatus.bind(this, Status.Online);
            const waitForOffline = waitForStatus.bind(this, Status.Offline);
            const selector1 = yield waitForOnline(yield CLI.command(`${kubectl} create -f ${url} -n ${ns}`, this.app));
            const selector2 = yield waitForOnline(yield CLI.command(`${kubectl} get pods -w -n ${ns}`, this.app));
            const selector2ButOffline = selector2.replace(Status.Online, Status.Offline);
            const selector3 = yield waitForOffline(yield CLI.command(`${kubectl} delete -f ${url} -n ${ns}`, this.app));
            yield this.app.client.waitForExist(selector1);
            yield this.app.client.waitForExist(selector3);
            yield this.app.client.waitForExist(selector2, 20000, true);
            yield this.app.client.waitForExist(selector2ButOffline);
            yield waitForOnline(yield CLI.command(`${kubectl} create -f ${url} -n ${ns}`, this.app));
            yield this.app.client.waitForExist(selector2);
            yield this.app.client.waitForExist(selector2ButOffline, 20000, true);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
};
const checkWatchableJobs = function (kubectl, ns, jobCount = 0, createResource = false) {
    if (createResource) {
        it(`should create a watchable job via ${kubectl} get pods -w`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const waitForOnline = waitForStatus.bind(this, Status.Online);
                yield waitForOnline(yield CLI.command(`${kubectl} get pods -w -n ${ns}`, this.app));
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
    }
    it(`should have ${jobCount} watchable jobs in the tab`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const watchableJobsRaw = yield this.app.client.execute(() => {
                return document.querySelector('tab.visible')['state'].jobs;
            });
            const actualJobCount = watchableJobsRaw.value;
            assert.strictEqual(actualJobCount, jobCount);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
};
const synonyms = ['k'];
xdescribe(`kubectl watch pod ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const ns = createNS();
        const createAndDeleteIt = createAndDeletePod.bind(this, kubectl, ns);
        const watchIt = watchPods.bind(this, kubectl, ns);
        const checkJob = checkWatchableJobs.bind(this, kubectl, ns);
        allocateNS(this, ns);
        createAndDeleteIt();
        checkJob(0, false);
        watchIt();
        checkJob(1, false);
        checkJob(2, true);
        checkJob(3, true);
        checkJob(4, true);
        checkJob(5, true);
        checkJob(6, true);
        checkJob(6, true);
        checkJob(6, true);
        checkJob(6, true);
        checkJob(6, true);
        it('should add new tab via command', () => CLI.command('tab new', this.app)
            .then(() => this.app.client.waitForVisible(Selectors.TAB_SELECTED_N(2)))
            .then(() => CLI.waitForSession(this))
            .catch(Common.oops(this, true)));
        checkJob(undefined, false);
        it(`should switch back to first tab via command`, () => CLI.command('tab switch 1', this.app).catch(Common.oops(this, true)));
        checkJob(6, false);
        it('should close tab via "tab close" command', () => CLI.command('tab close', this.app)
            .then(() => this.app.client.waitForExist(Selectors.TAB_N(2), 20000, true))
            .then(() => this.app.client.waitForExist(Selectors.TAB_SELECTED_N(1)))
            .then(() => CLI.waitForRepl(this.app))
            .catch(Common.oops(this, true)));
        checkJob(undefined, false);
        checkJob(1, true);
        it('should clear the console', () => CLI.command('clear', this.app)
            .then(() => ReplExpect.consoleToBeClear(this.app))
            .catch(Common.oops(this, true)));
        checkJob(0, false);
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=get-pods-with-watch.js.map