var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import PrettyPrintAnsiString from 'ansi_up';
import * as colors from 'colors/safe';
import { doExecWithPty, defaultFlags as flags, isHelpRequest } from '@kui-shell/plugin-kubeui';
import commandPrefix from '../command-prefix';
const debug = Debug('plugin-logui/controller/kubectl/logs');
const literal = (match, p1, p2) => `${p1}${colors.blue(p2)}`;
const literal2 = (match, p1, p2) => `${p1}${colors.cyan(p2)}`;
const deemphasize = (match, p1, p2) => `${p1}${colors.gray(p2)}`;
const deemphasize2 = (match, p1, p2, p3, p4) => `${deemphasize(match, p1, p2)}${p4}`;
function decorateLogLines(lines) {
    return (lines
        .replace(/(\[.*?\])/g, (match, p1) => colors.gray(p1))
        .replace(/(\s+|=|:o)("([^\\"]|\\")*")/g, literal)
        .replace(/(\s+|=|:)('([^\\']|\\')*')/g, literal)
        .replace(/(=)(\d+(.\d+)?(ms)?)/g, literal)
        .replace(/(\s+|=)(true|false)/g, literal2)
        .replace(/(\s+)(\S+.go\s\d+:)/g, deemphasize)
        .replace(/(\s+)(\S+.go:\d+\])/g, deemphasize)
        .replace(/(\w{3}\s+\d\d?\s+\d{2}:\d{2}:\d{2}|\d{2}:\d{2}:\d{2}.\d{6}|\w{3}\s+\w{3}\s+\d\d?\s+\d{2}:\d{2}:\d{2}\s+\d{4}|\[(\d{2}\/\w{3}\/\d{4}:\d{2}:\d{2}:\d{2} [+-]\d{4})\]|\w{3},\s+\d{2}\s+\w{3}\s+\d{4}\s+\d{2}:\d{2}:\d{2}\s+\w{3}|\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z|\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}(.\d{3}?)|\d{4}\/\d{2}\/\d{2}\s+\d{2}:\d{2}:\d{2}(.\d+)?)/g, (match, p1) => colors.cyan(p1))
        .replace(/(success|succeeded|starting|started|restarting|restarted)/gi, (match, p1) => colors.green(p1))
        .replace(/^(E\d+)/gm, (match, p1) => colors.red(p1))
        .replace(/^(I\d+)/gm, (match, p1) => colors.gray(p1))
        .replace(/^(W\d+)/gm, (match, p1) => colors.yellow(p1))
        .replace(/^(Failed|Failure|Error)/gm, (match, p1) => colors.red(p1))
        .replace(/([^_])(failed|error|timeout:?)/gi, (match, p1, p2) => `${p1}${colors.red(p2)}`)
        .replace(/((deleted|exit|warn)(ing)?:?)/gi, (match, p1) => colors.yellow(p1))
        .replace(/(\s+)([a-zA-Z]+:[a-zA-Z]+(:[a-zA-Z]+)?)(\s+)/g, deemphasize2));
}
function doLogs(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const streamed = args.parsedOptions.follow || args.parsedOptions.f;
        if (streamed && !args.parsedOptions.since) {
            const since = '10s';
            args.parsedOptions.since = since;
            args.argv.push('--since=since');
            args.command = args.command + ' --since=10s';
        }
        if (!streamed && !args.parsedOptions.tail) {
            const tail = 30;
            args.parsedOptions.tail = tail;
            args.argv.push('--tail=' + tail);
            args.command = args.command + ' --tail=' + tail;
        }
        const stdout = yield args.createOutputStream();
        const myExecOptions = Object.assign({}, args.execOptions, {
            rethrowErrors: true,
            quiet: true,
            replSilence: true,
            echo: false,
            onInit: (ptyJob) => {
                let curLine;
                return (_) => {
                    if (args.block['isCancelled']) {
                        ptyJob.abort();
                    }
                    else if (typeof _ === 'string') {
                        if (/\n$/.test(_)) {
                            const joined = curLine ? curLine + _ : _;
                            const fullLine = /\x1b/.test(joined) ? joined : decorateLogLines(joined);
                            const lineDom = document.createElement('pre');
                            lineDom.classList.add('pre-wrap', 'kubeui--logs');
                            const formatter = new PrettyPrintAnsiString();
                            formatter.use_classes = true;
                            lineDom.innerHTML = formatter.ansi_to_html(fullLine);
                            curLine = undefined;
                            stdout(lineDom);
                        }
                        else if (curLine) {
                            curLine = curLine + _;
                        }
                        else {
                            curLine = _;
                        }
                    }
                };
            }
        });
        const myArgs = Object.assign({}, args, { execOptions: myExecOptions });
        return doExecWithPty(myArgs).catch(err => {
            if (isHelpRequest(args)) {
                return err;
            }
            else {
                debug(err);
                return true;
            }
        });
    });
}
export default (registrar) => {
    registrar.listen(`/${commandPrefix}/kubectl/logs`, doLogs, flags);
    registrar.listen(`/${commandPrefix}/k/logs`, doLogs, flags);
};
//# sourceMappingURL=logs.js.map