import { KubeResource, KubeResourceWithSummary, InvolvedObject } from '@kui-shell/plugin-kubeui';
import { LogEntry } from './entry';
import apiVersion from '../controller/kubectl/apiVersion';
export { apiVersion };
export declare const kind = "LogEntry";
interface LogEntryOverrides extends KubeResourceWithSummary {
    apiVersion: any;
    kind: any;
    isSimulacrum: true;
    originatingCommand: undefined;
    spec: {
        displayName?: string;
        entry: LogEntry;
    };
}
export declare type LogEntryResource = LogEntryOverrides & InvolvedObject;
export declare function isLogEntryResource(resource: KubeResource): resource is LogEntryResource;
export declare function resourceFromLogEntry(logLine: LogEntry, { involvedObject }: InvolvedObject): Promise<LogEntryResource>;
