import { i18n } from '@kui-shell/core';
import { isJob, isDeployment, isPod, getCommandFromArgs } from '@kui-shell/plugin-kubeui';
const strings = i18n('plugin-logui');
function deploymentLogs(tab, resource, args) {
    return `${getCommandFromArgs(args)} logs deployment/${resource.metadata.name} -n ${resource.metadata.namespace} --all-containers --tail 20`;
}
function jobLogs(tab, resource, args) {
    return `${getCommandFromArgs(args)} logs job/${resource.metadata.name} -n ${resource.metadata.namespace} --tail 20`;
}
function podLogs(tab, resource, args) {
    return `${getCommandFromArgs(args)} logs ${resource.metadata.name} -n ${resource.metadata.namespace} --all-containers --tail 20`;
}
function hasLogs(resource) {
    return isPod(resource) || isDeployment(resource) || isJob(resource);
}
const renderLogs = (tab, resource, args) => {
    if (isDeployment(resource)) {
        return deploymentLogs(tab, resource, args);
    }
    else if (isPod(resource)) {
        return podLogs(tab, resource, args);
    }
    else if (isJob(resource)) {
        return jobLogs(tab, resource, args);
    }
    else {
        return '';
    }
};
export default {
    when: hasLogs,
    mode: {
        mode: 'logs',
        label: strings('Show Logs'),
        command: renderLogs,
        kind: 'drilldown'
    }
};
//# sourceMappingURL=show-logs.js.map