var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n } from '@kui-shell/core';
import { TrafficLight } from '@kui-shell/plugin-kubeui';
import { resourceFromLogEntry } from '../models/resource';
import json from '../formats/json';
import nginx from '../formats/nginx';
import express from '../formats/express';
import webrick from '../formats/webrick';
import zapr from '../formats/zapr';
import plain from '../formats/plain';
const strings = i18n('plugin-logui');
function isPatternLogParser(parser) {
    return parser.pattern !== undefined;
}
const formats = [nginx, express, webrick, zapr, json, plain];
const tryParse = (raw) => (fmt) => {
    if (isPatternLogParser(fmt)) {
        const logLines = raw.trim().split(fmt.pattern);
        const nLines = logLines.length / fmt.nColumns;
        if (nLines >= 1) {
            const entries = [];
            for (let idx = 0; idx < nLines; idx++) {
                const slice = logLines.slice(idx * fmt.nColumns, (idx + 1) * fmt.nColumns);
                if (slice.length === fmt.nColumns) {
                    entries.push(fmt.entry(slice));
                }
            }
            return entries.filter(_ => _);
        }
    }
    else {
        return raw
            .split(plain.pattern)
            .map(fmt.entry)
            .filter(_ => _);
    }
};
function formatLevel(entry) {
    if (entry.level === 'ERROR') {
        return TrafficLight.Red;
    }
    else if (entry.level === 'WARN') {
        return TrafficLight.Yellow;
    }
    else if (entry.level === 'INFO') {
    }
    else {
    }
}
function showLogEntry(logLine, involvedObject) {
    return __awaiter(this, void 0, void 0, function* () {
        const modes = [];
        return Object.assign(yield resourceFromLogEntry(logLine, involvedObject), {
            toolbarText: {
                type: 'info',
                text: strings('Occurred at', logLine.timestamp)
            },
            modes
        });
    });
}
export function formatAsTable(raw, metadata) {
    return __awaiter(this, void 0, void 0, function* () {
        if (raw.length === 0) {
            return {
                body: []
            };
        }
        const { name, namespace = 'default' } = metadata;
        const kindMatch = name ? name.match(/(\w+)\//) : undefined;
        const kindOfInvolved = kindMatch ? kindMatch[1] : 'pod';
        const apiVersionOfInvolved = /^deploy/i.test(kindOfInvolved)
            ? 'extensions/v1beta1'
            : /^job/i.test(kindOfInvolved)
                ? 'batch/v1'
                : 'v1';
        const involvedObject = {
            apiVersion: apiVersionOfInvolved,
            kind: kindOfInvolved,
            name,
            namespace
        };
        const logLines = formats.map(tryParse(raw)).filter(_ => _ && _.length > 0)[0];
        const anyStructure = !!logLines.find(_ => _.timestamp);
        const level = [{ value: strings('Level') }];
        const aDetail1 = logLines.find(_ => _.detail1);
        const detail1 = aDetail1 ? [{ value: aDetail1.detail1Key || strings('Details') }] : [];
        const aDetail2 = logLines.find(_ => _.detail2);
        const detail2 = aDetail2 ? [{ value: aDetail2.detail2Key || strings('More Details') }] : [];
        const message = [{ value: strings('Message'), css: 'hide-with-sidecar' }];
        const header = !anyStructure
            ? {
                name: strings('Message'),
                attributes: level.concat(detail1).concat(detail2)
            }
            : {
                name: strings('Timestamp'),
                attributes: level
                    .concat(detail1)
                    .concat(detail2)
                    .concat(message)
            };
        return {
            header,
            noSort: true,
            body: yield Promise.all(logLines.map((logLine) => __awaiter(this, void 0, void 0, function* () {
                const attributes = [];
                attributes.push({
                    tag: 'badge',
                    value: logLine.level,
                    css: formatLevel(logLine)
                });
                if (logLine.detail1) {
                    attributes.push({ value: logLine.detail1 });
                }
                if (logLine.detail2) {
                    attributes.push({ value: logLine.detail2 });
                }
                if (logLine.timestamp) {
                    attributes.push({
                        value: logLine.message,
                        css: 'somewhat-smaller-text pre-wrap slightly-deemphasize hide-with-sidecar'
                    });
                }
                return {
                    name: logLine.timestamp || logLine.message,
                    outerCSS: 'not-a-name',
                    onclick: (logLine.messageDetail || logLine.detail1 || logLine.detail2) &&
                        (yield showLogEntry(logLine, { involvedObject })),
                    tag: 'div',
                    attributes
                };
            })))
        };
    });
}
export default function renderLogs(tab, resource) {
    return formatAsTable(resource.data, resource.metadata);
}
//# sourceMappingURL=table.js.map