var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as assert from 'assert';
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
import { readFileSync } from 'fs';
import { dirname, join } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubeui/tests/package.json'));
const inputBuffer = readFileSync(join(ROOT, 'data/k8s/kubectl-exec.yaml'));
const inputEncoded = inputBuffer.toString('base64');
describe(`kubectl logs getty ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const ns = createNS();
    const inputs = [
        {
            podName: 'vim',
            containerName: 'alpine',
            hasLogs: true,
            cmdline: `echo ${inputEncoded} | base64 --decode | kubectl create -f - -n ${ns}`
        },
        {
            podName: 'nginx',
            containerName: 'nginx',
            label: 'name=nginx',
            hasLogs: false,
            cmdline: `kubectl create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod -n ${ns}`
        }
    ];
    const createPod = (podName, cmdline) => {
        it(`should create ${podName} pod`, () => {
            return CLI.command(cmdline, this.app)
                .then(ReplExpect.okWithString(podName))
                .catch(Common.oops(this, true));
        });
    };
    const waitForPod = (podName) => {
        it(`should wait for the pod ${podName} to come up`, () => {
            return CLI.command(`kubectl get pod ${podName} -n ${ns} -w`, this.app)
                .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(podName) }))
                .then(selector => waitForGreen(this.app, selector))
                .catch(Common.oops(this, true));
        });
    };
    const showLogs = (podName, containerName, label, hasLogs) => {
        const checkLogs = (res) => __awaiter(this, void 0, void 0, function* () {
            if (hasLogs) {
                yield Promise.resolve(res)
                    .then(ReplExpect.okWithCustom({ passthrough: true }))
                    .then(N => this.app.client.getText(Selectors.OUTPUT_N_STREAMING(N)))
                    .then(txt => assert.ok(txt.length > 0));
            }
            else {
                yield Promise.resolve(res).then(ReplExpect.justOK);
            }
        });
        it(`should show logs for pod ${podName} container ${containerName}`, () => {
            return CLI.command(`kubectl logs ${podName} ${containerName} -n ${ns}`, this.app)
                .then(checkLogs)
                .catch(Common.oops(this, true));
        });
        if (label) {
            it(`should show logs for label selector ${label}`, () => {
                return CLI.command(`kubectl logs -l${label} -n ${ns}`, this.app)
                    .then(checkLogs)
                    .catch(Common.oops(this, true));
            });
        }
    };
    allocateNS(this, ns);
    inputs.forEach(_ => {
        createPod(_.podName, _.cmdline);
        waitForPod(_.podName);
        showLogs(_.podName, _.containerName, _.label, _.hasLogs);
    });
    inputs.forEach(_ => {
        showLogs(_.podName, _.containerName, _.label, _.hasLogs);
    });
    deleteNS(this, ns);
});
//# sourceMappingURL=logs.js.map