import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
describe('k8s usage', function () {
    before(Common.before(this));
    after(Common.after(this));
    it('should give help for known outer command: kubectl logs -h', () => CLI.command('kubectl logs -h', this.app)
        .then(ReplExpect.errorWithPassthrough(500))
        .then(N => Promise.all([
        this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} h4.usage-error-title[data-title="Options:"]`),
        this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} h4.usage-error-title[data-title="Examples"]`),
        this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} .bx--breadcrumb-item .bx--no-link[data-label="logs"]`),
        this.app.client.waitForExist(`${Selectors.OUTPUT_N(N)} .bx--breadcrumb-item .bx--link[data-label="kubectl"]`)
    ]))
        .catch(Common.oops(this)));
});
//# sourceMappingURL=usage.js.map