"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const proxy_json_1 = require("@kui-shell/client/config.d/proxy.json");
const config_1 = require("./lib/config");
const debug = debug_1.default('plugins/proxy-support/preload');
exports.registerCapability = () => __awaiter(void 0, void 0, void 0, function* () {
    if (core_1.inBrowser()) {
        debug('config', proxy_json_1.proxyServer);
        if (!config_1.isDisabled(proxy_json_1.proxyServer)) {
            core_1.assertHasProxy();
            core_1.assertLocalAccess();
        }
    }
});
exports.default = () => __awaiter(void 0, void 0, void 0, function* () {
    if (core_1.inBrowser()) {
        debug('config', proxy_json_1.proxyServer);
        if (!config_1.isDisabled(proxy_json_1.proxyServer)) {
            const ProxyEvaluator = (yield Promise.resolve().then(() => require('./lib/proxy-executor'))).default;
            debug('attempting to establish our proxy executor');
            core_1.setEvaluatorImpl(new ProxyEvaluator());
        }
    }
});
//# sourceMappingURL=preload.js.map