// make sure to keep this as 'var'
// we don't want block scoping

var dartNodePreambleSelf = typeof global !== "undefined" ? global : window;

var self = Object.create(dartNodePreambleSelf);

self.scheduleImmediate = self.setImmediate
    ? function (cb) {
        dartNodePreambleSelf.setImmediate(cb);
      }
    : function(cb) {
        setTimeout(cb, 0);
      };

// CommonJS globals.
self.exports = exports;

// Node.js specific exports, check to see if they exist & or polyfilled

if (typeof process !== "undefined") {
  self.process = process;
}

if (typeof __dirname !== "undefined") {
  self.__dirname = __dirname;
}

if (typeof __filename !== "undefined") {
  self.__filename = __filename;
}

// if we're running in a browser, Dart supports most of this out of box
// make sure we only run these in Node.js environment
if (!dartNodePreambleSelf.window) {
  // This line is to:
  // 1) Prevent Webpack from bundling.
  // 2) In Webpack on Node.js, make sure we're using the native Node.js require, which is available via __non_webpack_require__
  // https://github.com/mbullington/node_preamble.dart/issues/18#issuecomment-527305561
  var url = ("undefined" !== typeof __webpack_require__ ? __non_webpack_require__ : require)("url");

  self.location = {
    get href() {
      if (url.pathToFileURL) {
        return url.pathToFileURL(process.cwd()).href + "/";
      } else {
        // This isn't really a correct transformation, but it's the best we have
        // for versions of Node <10.12.0 which introduced `url.pathToFileURL()`.
        // For example, it will fail for paths that contain characters that need
        // to be escaped in URLs.
        return "file://" + (function() {
          var cwd = process.cwd();
          if (process.platform != "win32") return cwd;
          return "/" + cwd.replace(/\\/g, "/");
        })() + "/"
      }
    }
  };

  (function() {
    function computeCurrentScript() {
      try {
        throw new Error();
      } catch(e) {
        var stack = e.stack;
        var re = new RegExp("^ *at [^(]*\\((.*):[0-9]*:[0-9]*\\)$", "mg");
        var lastMatch = null;
        do {
          var match = re.exec(stack);
          if (match != null) lastMatch = match;
        } while (match != null);
        return lastMatch[1];
      }
    }

    var cachedCurrentScript = null;
    self.document = {
      get currentScript() {
        if (cachedCurrentScript == null) {
          cachedCurrentScript = {src: computeCurrentScript()};
        }
        return cachedCurrentScript;
      }
    };
  })();

  self.dartDeferredLibraryLoader = function(uri, successCallback, errorCallback) {
    try {
     load(uri);
      successCallback();
    } catch (error) {
      errorCallback(error);
    }
  };
}

self.fs = require("fs");
self.chokidar = require("chokidar");
self.readline = require("readline");
// Generated by dart2js (fast startup emitter, strong, trust primitives, omit checks, lax runtime type), the Dart to JavaScript compiler version: 2.7.0.
// The code supports the following hooks:
// dartPrint(message):
//    if this function is defined it is called instead of the Dart [print]
//    method.
//
// dartMainRunner(main, args):
//    if this function is defined, the Dart [main] method will not be invoked
//    directly. Instead, a closure that will invoke [main], and its arguments
//    [args] is passed to [dartMainRunner].
//
// dartDeferredLibraryLoader(uri, successCallback, errorCallback):
//    if this function is defined, it will be called when a deferred library
//    is loaded. It should load and eval the javascript of `uri`, and call
//    successCallback. If it fails to do so, it should call errorCallback with
//    an error.
//
// dartCallInstrumentation(id, qualifiedName):
//    if this function is defined, it will be called at each entry of a
//    method or constructor. Used only when compiling programs with
//    --experiment-call-instrumentation.
{
}
(function dartProgram() {
  function copyProperties(from, to) {
    var keys = Object.keys(from);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      to[key] = from[key];
    }
  }
  var supportsDirectProtoAccess = function() {
    var cls = function() {
    };
    cls.prototype = {p: {}};
    var object = new cls();
    if (!(object.__proto__ && object.__proto__.p === cls.prototype.p))
      return false;
    try {
      if (typeof navigator != "undefined" && typeof navigator.userAgent == "string" && navigator.userAgent.indexOf("Chrome/") >= 0)
        return true;
      if (typeof version == "function" && version.length == 0) {
        var v = version();
        if (/^\d+\.\d+\.\d+\.\d+$/.test(v))
          return true;
      }
    } catch (_) {
    }
    return false;
  }();
  function setFunctionNamesIfNecessary(holders) {
    function t() {
    }
    ;
    if (typeof t.name == "string")
      return;
    for (var i = 0; i < holders.length; i++) {
      var holder = holders[i];
      var keys = Object.keys(holder);
      for (var j = 0; j < keys.length; j++) {
        var key = keys[j];
        var f = holder[key];
        if (typeof f == 'function')
          f.name = key;
      }
    }
  }
  function inherit(cls, sup) {
    cls.prototype.constructor = cls;
    cls.prototype["$is" + cls.name] = cls;
    if (sup != null) {
      if (supportsDirectProtoAccess) {
        cls.prototype.__proto__ = sup.prototype;
        return;
      }
      var clsPrototype = Object.create(sup.prototype);
      copyProperties(cls.prototype, clsPrototype);
      cls.prototype = clsPrototype;
    }
  }
  function inheritMany(sup, classes) {
    for (var i = 0; i < classes.length; i++)
      inherit(classes[i], sup);
  }
  function mixin(cls, mixin) {
    copyProperties(mixin.prototype, cls.prototype);
    cls.prototype.constructor = cls;
  }
  function lazy(holder, name, getterName, initializer) {
    var uninitializedSentinel = holder;
    holder[name] = uninitializedSentinel;
    holder[getterName] = function() {
      holder[getterName] = function() {
        H.throwCyclicInit(name);
      };
      var result;
      var sentinelInProgress = initializer;
      try {
        if (holder[name] === uninitializedSentinel) {
          result = holder[name] = sentinelInProgress;
          result = holder[name] = initializer();
        } else
          result = holder[name];
      } finally {
        if (result === sentinelInProgress)
          holder[name] = null;
        holder[getterName] = function() {
          return this[name];
        };
      }
      return result;
    };
  }
  function makeConstList(list) {
    list.immutable$list = Array;
    list.fixed$length = Array;
    return list;
  }
  function convertToFastObject(properties) {
    function t() {
    }
    t.prototype = properties;
    new t();
    return properties;
  }
  function convertAllToFastObject(arrayOfObjects) {
    for (var i = 0; i < arrayOfObjects.length; ++i)
      convertToFastObject(arrayOfObjects[i]);
  }
  var functionCounter = 0;
  function tearOffGetter(funcs, applyTrampolineIndex, reflectionInfo, name, isIntercepted) {
    return isIntercepted ? new Function("funcs", "applyTrampolineIndex", "reflectionInfo", "name", "H", "c", "return function tearOff_" + name + functionCounter++ + "(receiver) {" + "if (c === null) c = " + "H.closureFromTearOff" + "(" + "this, funcs, applyTrampolineIndex, reflectionInfo, false, true, name);" + "return new c(this, funcs[0], receiver, name);" + "}")(funcs, applyTrampolineIndex, reflectionInfo, name, H, null) : new Function("funcs", "applyTrampolineIndex", "reflectionInfo", "name", "H", "c", "return function tearOff_" + name + functionCounter++ + "() {" + "if (c === null) c = " + "H.closureFromTearOff" + "(" + "this, funcs, applyTrampolineIndex, reflectionInfo, false, false, name);" + "return new c(this, funcs[0], null, name);" + "}")(funcs, applyTrampolineIndex, reflectionInfo, name, H, null);
  }
  function tearOff(funcs, applyTrampolineIndex, reflectionInfo, isStatic, name, isIntercepted) {
    var cache = null;
    return isStatic ? function() {
      if (cache === null)
        cache = H.closureFromTearOff(this, funcs, applyTrampolineIndex, reflectionInfo, true, false, name).prototype;
      return cache;
    } : tearOffGetter(funcs, applyTrampolineIndex, reflectionInfo, name, isIntercepted);
  }
  var typesOffset = 0;
  function installTearOff(container, getterName, isStatic, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex) {
    var funs = [];
    for (var i = 0; i < funsOrNames.length; i++) {
      var fun = funsOrNames[i];
      if (typeof fun == 'string')
        fun = container[fun];
      fun.$callName = callNames[i];
      funs.push(fun);
    }
    var fun = funs[0];
    fun.$requiredArgCount = requiredParameterCount;
    fun.$defaultValues = optionalParameterDefaultValues;
    var reflectionInfo = funType;
    if (typeof reflectionInfo == "number")
      reflectionInfo += typesOffset;
    var name = funsOrNames[0];
    fun.$stubName = name;
    var getterFunction = tearOff(funs, applyIndex || 0, reflectionInfo, isStatic, name, isIntercepted);
    container[getterName] = getterFunction;
    if (isStatic)
      fun.$tearOff = getterFunction;
  }
  function installStaticTearOff(container, getterName, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex) {
    return installTearOff(container, getterName, true, false, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex);
  }
  function installInstanceTearOff(container, getterName, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex) {
    return installTearOff(container, getterName, false, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, funsOrNames, funType, applyIndex);
  }
  function setOrUpdateInterceptorsByTag(newTags) {
    var tags = init.interceptorsByTag;
    if (!tags) {
      init.interceptorsByTag = newTags;
      return;
    }
    copyProperties(newTags, tags);
  }
  function setOrUpdateLeafTags(newTags) {
    var tags = init.leafTags;
    if (!tags) {
      init.leafTags = newTags;
      return;
    }
    copyProperties(newTags, tags);
  }
  function updateTypes(newTypes) {
    var types = init.types;
    var length = types.length;
    types.push.apply(types, newTypes);
    return length;
  }
  function updateHolder(holder, newHolder) {
    copyProperties(newHolder, holder);
    return holder;
  }
  var hunkHelpers = function() {
    var mkInstance = function(isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, applyIndex) {
        return function(container, getterName, name, funType) {
          return installInstanceTearOff(container, getterName, isIntercepted, requiredParameterCount, optionalParameterDefaultValues, callNames, [name], funType, applyIndex);
        };
      },
      mkStatic = function(requiredParameterCount, optionalParameterDefaultValues, callNames, applyIndex) {
        return function(container, getterName, name, funType) {
          return installStaticTearOff(container, getterName, requiredParameterCount, optionalParameterDefaultValues, callNames, [name], funType, applyIndex);
        };
      };
    return {inherit: inherit, inheritMany: inheritMany, mixin: mixin, installStaticTearOff: installStaticTearOff, installInstanceTearOff: installInstanceTearOff, _instance_0u: mkInstance(0, 0, null, ["call$0"], 0), _instance_1u: mkInstance(0, 1, null, ["call$1"], 0), _instance_2u: mkInstance(0, 2, null, ["call$2"], 0), _instance_0i: mkInstance(1, 0, null, ["call$0"], 0), _instance_1i: mkInstance(1, 1, null, ["call$1"], 0), _instance_2i: mkInstance(1, 2, null, ["call$2"], 0), _static_0: mkStatic(0, null, ["call$0"], 0), _static_1: mkStatic(1, null, ["call$1"], 0), _static_2: mkStatic(2, null, ["call$2"], 0), makeConstList: makeConstList, lazy: lazy, updateHolder: updateHolder, convertToFastObject: convertToFastObject, setFunctionNamesIfNecessary: setFunctionNamesIfNecessary, updateTypes: updateTypes, setOrUpdateInterceptorsByTag: setOrUpdateInterceptorsByTag, setOrUpdateLeafTags: setOrUpdateLeafTags};
  }();
  function initializeDeferredHunk(hunk) {
    typesOffset = init.types.length;
    hunk(hunkHelpers, init, holders, $);
  }
  function getGlobalFromName(name) {
    for (var i = 0; i < holders.length; i++) {
      if (holders[i] == C)
        continue;
      if (holders[i][name])
        return holders[i][name];
    }
  }
  var C = {},
  H = {JS_CONST: function JS_CONST() {
    },
    CastIterable_CastIterable: function(source, $S, $T) {
      if (H.checkSubtype(source, "$isEfficientLengthIterable", [$S], "$asEfficientLengthIterable"))
        return new H._EfficientLengthCastIterable(source, [$S, $T]);
      return new H.CastIterable(source, [$S, $T]);
    },
    hexDigitValue: function(char) {
      var letter,
        digit = char ^ 48;
      if (digit <= 9)
        return digit;
      letter = char | 32;
      if (97 <= letter && letter <= 102)
        return letter - 87;
      return -1;
    },
    SubListIterable$: function(_iterable, _start, _endOrLength, $E) {
      P.RangeError_checkNotNegative(_start, "start");
      if (_endOrLength != null) {
        P.RangeError_checkNotNegative(_endOrLength, "end");
        if (_start > _endOrLength)
          H.throwExpression(P.RangeError$range(_start, 0, _endOrLength, "start", null));
      }
      return new H.SubListIterable(_iterable, _start, _endOrLength, [$E]);
    },
    MappedIterable_MappedIterable: function(iterable, $function, $S, $T) {
      if (!!J.getInterceptor$(iterable).$isEfficientLengthIterable)
        return new H.EfficientLengthMappedIterable(iterable, $function, [$S, $T]);
      return new H.MappedIterable(iterable, $function, [$S, $T]);
    },
    TakeIterable_TakeIterable: function(iterable, takeCount, $E) {
      P.RangeError_checkNotNegative(takeCount, "takeCount");
      if (!!J.getInterceptor$(iterable).$isEfficientLengthIterable)
        return new H.EfficientLengthTakeIterable(iterable, takeCount, [$E]);
      return new H.TakeIterable(iterable, takeCount, [$E]);
    },
    SkipIterable_SkipIterable: function(iterable, count, $E) {
      var _s5_ = "count";
      if (!!J.getInterceptor$(iterable).$isEfficientLengthIterable) {
        if (count == null)
          H.throwExpression(P.ArgumentError$notNull(_s5_));
        P.RangeError_checkNotNegative(count, _s5_);
        return new H.EfficientLengthSkipIterable(iterable, count, [$E]);
      }
      if (count == null)
        H.throwExpression(P.ArgumentError$notNull(_s5_));
      P.RangeError_checkNotNegative(count, _s5_);
      return new H.SkipIterable(iterable, count, [$E]);
    },
    FollowedByIterable_FollowedByIterable$firstEfficient: function(first, second, $E) {
      if (H.checkSubtype(second, "$isEfficientLengthIterable", [$E], "$asEfficientLengthIterable"))
        return new H.EfficientLengthFollowedByIterable(first, second, [$E]);
      return new H.FollowedByIterable(first, second, [$E]);
    },
    IterableElementError_noElement: function() {
      return new P.StateError("No element");
    },
    IterableElementError_tooMany: function() {
      return new P.StateError("Too many elements");
    },
    IterableElementError_tooFew: function() {
      return new P.StateError("Too few elements");
    },
    Sort_sort: function(a, compare) {
      H.Sort__doSort(a, 0, J.get$length$asx(a) - 1, compare);
    },
    Sort__doSort: function(a, left, right, compare) {
      if (right - left <= 32)
        H.Sort__insertionSort(a, left, right, compare);
      else
        H.Sort__dualPivotQuicksort(a, left, right, compare);
    },
    Sort__insertionSort: function(a, left, right, compare) {
      var i, t1, el, j, j0;
      for (i = left + 1, t1 = J.getInterceptor$asx(a); i <= right; ++i) {
        el = t1.$index(a, i);
        j = i;
        while (true) {
          if (!(j > left && compare.call$2(t1.$index(a, j - 1), el) > 0))
            break;
          j0 = j - 1;
          t1.$indexSet(a, j, t1.$index(a, j0));
          j = j0;
        }
        t1.$indexSet(a, j, el);
      }
    },
    Sort__dualPivotQuicksort: function(a, left, right, compare) {
      var t0, less, great, k, ak, comp, great0, less0, pivots_are_equal, t2,
        sixth = C.JSInt_methods._tdivFast$1(right - left + 1, 6),
        index1 = left + sixth,
        index5 = right - sixth,
        index3 = C.JSInt_methods._tdivFast$1(left + right, 2),
        index2 = index3 - sixth,
        index4 = index3 + sixth,
        t1 = J.getInterceptor$asx(a),
        el1 = t1.$index(a, index1),
        el2 = t1.$index(a, index2),
        el3 = t1.$index(a, index3),
        el4 = t1.$index(a, index4),
        el5 = t1.$index(a, index5);
      if (compare.call$2(el1, el2) > 0) {
        t0 = el2;
        el2 = el1;
        el1 = t0;
      }
      if (compare.call$2(el4, el5) > 0) {
        t0 = el5;
        el5 = el4;
        el4 = t0;
      }
      if (compare.call$2(el1, el3) > 0) {
        t0 = el3;
        el3 = el1;
        el1 = t0;
      }
      if (compare.call$2(el2, el3) > 0) {
        t0 = el3;
        el3 = el2;
        el2 = t0;
      }
      if (compare.call$2(el1, el4) > 0) {
        t0 = el4;
        el4 = el1;
        el1 = t0;
      }
      if (compare.call$2(el3, el4) > 0) {
        t0 = el4;
        el4 = el3;
        el3 = t0;
      }
      if (compare.call$2(el2, el5) > 0) {
        t0 = el5;
        el5 = el2;
        el2 = t0;
      }
      if (compare.call$2(el2, el3) > 0) {
        t0 = el3;
        el3 = el2;
        el2 = t0;
      }
      if (compare.call$2(el4, el5) > 0) {
        t0 = el5;
        el5 = el4;
        el4 = t0;
      }
      t1.$indexSet(a, index1, el1);
      t1.$indexSet(a, index3, el3);
      t1.$indexSet(a, index5, el5);
      t1.$indexSet(a, index2, t1.$index(a, left));
      t1.$indexSet(a, index4, t1.$index(a, right));
      less = left + 1;
      great = right - 1;
      if (J.$eq$(compare.call$2(el2, el4), 0)) {
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          comp = compare.call$2(ak, el2);
          if (comp === 0)
            continue;
          if (comp < 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else
            for (; true;) {
              comp = compare.call$2(t1.$index(a, great), el2);
              if (comp > 0) {
                --great;
                continue;
              } else {
                great0 = great - 1;
                if (comp < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  great = great0;
                  less = less0;
                  break;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  great = great0;
                  break;
                }
              }
            }
        }
        pivots_are_equal = true;
      } else {
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          if (compare.call$2(ak, el2) < 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else if (compare.call$2(ak, el4) > 0)
            for (; true;)
              if (compare.call$2(t1.$index(a, great), el4) > 0) {
                --great;
                if (great < k)
                  break;
                continue;
              } else {
                great0 = great - 1;
                if (compare.call$2(t1.$index(a, great), el2) < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  less = less0;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                }
                great = great0;
                break;
              }
        }
        pivots_are_equal = false;
      }
      t2 = less - 1;
      t1.$indexSet(a, left, t1.$index(a, t2));
      t1.$indexSet(a, t2, el2);
      t2 = great + 1;
      t1.$indexSet(a, right, t1.$index(a, t2));
      t1.$indexSet(a, t2, el4);
      H.Sort__doSort(a, left, less - 2, compare);
      H.Sort__doSort(a, great + 2, right, compare);
      if (pivots_are_equal)
        return;
      if (less < index1 && great > index5) {
        for (; J.$eq$(compare.call$2(t1.$index(a, less), el2), 0);)
          ++less;
        for (; J.$eq$(compare.call$2(t1.$index(a, great), el4), 0);)
          --great;
        for (k = less; k <= great; ++k) {
          ak = t1.$index(a, k);
          if (compare.call$2(ak, el2) === 0) {
            if (k !== less) {
              t1.$indexSet(a, k, t1.$index(a, less));
              t1.$indexSet(a, less, ak);
            }
            ++less;
          } else if (compare.call$2(ak, el4) === 0)
            for (; true;)
              if (compare.call$2(t1.$index(a, great), el4) === 0) {
                --great;
                if (great < k)
                  break;
                continue;
              } else {
                great0 = great - 1;
                if (compare.call$2(t1.$index(a, great), el2) < 0) {
                  t1.$indexSet(a, k, t1.$index(a, less));
                  less0 = less + 1;
                  t1.$indexSet(a, less, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                  less = less0;
                } else {
                  t1.$indexSet(a, k, t1.$index(a, great));
                  t1.$indexSet(a, great, ak);
                }
                great = great0;
                break;
              }
        }
        H.Sort__doSort(a, less, great, compare);
      } else
        H.Sort__doSort(a, less, great, compare);
    },
    _CastIterableBase: function _CastIterableBase() {
    },
    CastIterator: function CastIterator(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastIterable: function CastIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    _EfficientLengthCastIterable: function _EfficientLengthCastIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    _CastListBase: function _CastListBase() {
    },
    CastList: function CastList(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CastSet: function CastSet(t0, t1, t2) {
      this._source = t0;
      this._emptySet = t1;
      this.$ti = t2;
    },
    CastQueue: function CastQueue(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    CodeUnits: function CodeUnits(t0) {
      this.__internal$_string = t0;
    },
    EfficientLengthIterable: function EfficientLengthIterable() {
    },
    ListIterable: function ListIterable() {
    },
    SubListIterable: function SubListIterable(t0, t1, t2, t3) {
      var _ = this;
      _.__internal$_iterable = t0;
      _.__internal$_start = t1;
      _._endOrLength = t2;
      _.$ti = t3;
    },
    ListIterator: function ListIterator(t0, t1) {
      var _ = this;
      _.__internal$_iterable = t0;
      _.__internal$_length = t1;
      _.__internal$_index = 0;
      _.__internal$_current = null;
    },
    MappedIterable: function MappedIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    EfficientLengthMappedIterable: function EfficientLengthMappedIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    MappedIterator: function MappedIterator(t0, t1) {
      this.__internal$_current = null;
      this._iterator = t0;
      this._f = t1;
    },
    MappedListIterable: function MappedListIterable(t0, t1, t2) {
      this._source = t0;
      this._f = t1;
      this.$ti = t2;
    },
    WhereIterable: function WhereIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    WhereIterator: function WhereIterator(t0, t1) {
      this._iterator = t0;
      this._f = t1;
    },
    ExpandIterable: function ExpandIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    ExpandIterator: function ExpandIterator(t0, t1, t2) {
      var _ = this;
      _._iterator = t0;
      _._f = t1;
      _._currentExpansion = t2;
      _.__internal$_current = null;
    },
    TakeIterable: function TakeIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._takeCount = t1;
      this.$ti = t2;
    },
    EfficientLengthTakeIterable: function EfficientLengthTakeIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._takeCount = t1;
      this.$ti = t2;
    },
    TakeIterator: function TakeIterator(t0, t1) {
      this._iterator = t0;
      this._remaining = t1;
    },
    SkipIterable: function SkipIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._skipCount = t1;
      this.$ti = t2;
    },
    EfficientLengthSkipIterable: function EfficientLengthSkipIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._skipCount = t1;
      this.$ti = t2;
    },
    SkipIterator: function SkipIterator(t0, t1) {
      this._iterator = t0;
      this._skipCount = t1;
    },
    SkipWhileIterable: function SkipWhileIterable(t0, t1, t2) {
      this.__internal$_iterable = t0;
      this._f = t1;
      this.$ti = t2;
    },
    SkipWhileIterator: function SkipWhileIterator(t0, t1) {
      this._iterator = t0;
      this._f = t1;
      this._hasSkipped = false;
    },
    EmptyIterable: function EmptyIterable(t0) {
      this.$ti = t0;
    },
    EmptyIterator: function EmptyIterator() {
    },
    FollowedByIterable: function FollowedByIterable(t0, t1, t2) {
      this.__internal$_first = t0;
      this._second = t1;
      this.$ti = t2;
    },
    EfficientLengthFollowedByIterable: function EfficientLengthFollowedByIterable(t0, t1, t2) {
      this.__internal$_first = t0;
      this._second = t1;
      this.$ti = t2;
    },
    FollowedByIterator: function FollowedByIterator(t0, t1) {
      this._currentIterator = t0;
      this._nextIterable = t1;
    },
    WhereTypeIterable: function WhereTypeIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    WhereTypeIterator: function WhereTypeIterator(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    FixedLengthListMixin: function FixedLengthListMixin() {
    },
    UnmodifiableListMixin: function UnmodifiableListMixin() {
    },
    UnmodifiableListBase: function UnmodifiableListBase() {
    },
    ReversedListIterable: function ReversedListIterable(t0, t1) {
      this._source = t0;
      this.$ti = t1;
    },
    Symbol: function Symbol(t0) {
      this.__internal$_name = t0;
    },
    __CastListBase__CastIterableBase_ListMixin: function __CastListBase__CastIterableBase_ListMixin() {
    },
    ConstantMap_ConstantMap$from: function(other, $K, $V) {
      var allStrings, k, object, containsProto, protoValue, $length, v,
        keys = P.List_List$from(other.get$keys(), true, $K),
        t1 = keys.length,
        _i = 0;
      while (true) {
        if (!(_i < t1)) {
          allStrings = true;
          break;
        }
        k = keys[_i];
        if (typeof k !== "string") {
          allStrings = false;
          break;
        }
        ++_i;
      }
      if (allStrings) {
        object = {};
        for (containsProto = false, protoValue = null, $length = 0, _i = 0; _i < keys.length; keys.length === t1 || (0, H.throwConcurrentModificationError)(keys), ++_i) {
          k = keys[_i];
          v = other.$index(0, k);
          if (!J.$eq$(k, "__proto__")) {
            if (!object.hasOwnProperty(k))
              ++$length;
            object[k] = v;
          } else {
            protoValue = v;
            containsProto = true;
          }
        }
        if (containsProto)
          return new H.ConstantProtoMap(protoValue, $length + 1, object, keys, [$K, $V]);
        return new H.ConstantStringMap($length, object, keys, [$K, $V]);
      }
      return new H.ConstantMapView(P.LinkedHashMap_LinkedHashMap$from(other, $K, $V), [$K, $V]);
    },
    ConstantMap__throwUnmodifiable: function() {
      throw H.wrapException(P.UnsupportedError$("Cannot modify unmodifiable Map"));
    },
    instantiate1: function(f, T1) {
      var t1 = new H.Instantiation1(f, [T1]);
      t1.Instantiation$1(f);
      return t1;
    },
    unminifyOrTag: function(rawClassName) {
      var preserved = H.unmangleGlobalNameIfPreservedAnyways(rawClassName);
      if (typeof preserved === "string")
        return preserved;
      return rawClassName;
    },
    getType: function(index) {
      return init.types[index];
    },
    isJsIndexable: function(object, record) {
      var result;
      if (record != null) {
        result = record.x;
        if (result != null)
          return result;
      }
      return !!J.getInterceptor$(object).$isJavaScriptIndexingBehavior;
    },
    S: function(value) {
      var res;
      if (typeof value === "string")
        return value;
      if (typeof value === "number") {
        if (value !== 0)
          return "" + value;
      } else if (true === value)
        return "true";
      else if (false === value)
        return "false";
      else if (value == null)
        return "null";
      res = J.toString$0$(value);
      if (typeof res !== "string")
        throw H.wrapException(H.argumentErrorValue(value));
      return res;
    },
    Primitives_objectHashCode: function(object) {
      var hash = object.$identityHash;
      if (hash == null) {
        hash = Math.random() * 0x3fffffff | 0;
        object.$identityHash = hash;
      }
      return hash;
    },
    Primitives_parseInt: function(source, radix) {
      var match, decimalMatch, maxCharCode, digitsPart, t1, i;
      if (typeof source !== "string")
        H.throwExpression(H.argumentErrorValue(source));
      match = /^\s*[+-]?((0x[a-f0-9]+)|(\d+)|([a-z0-9]+))\s*$/i.exec(source);
      if (match == null)
        return;
      decimalMatch = match[3];
      if (radix == null) {
        if (decimalMatch != null)
          return parseInt(source, 10);
        if (match[2] != null)
          return parseInt(source, 16);
        return;
      }
      if (radix < 2 || radix > 36)
        throw H.wrapException(P.RangeError$range(radix, 2, 36, "radix", null));
      if (radix === 10 && decimalMatch != null)
        return parseInt(source, 10);
      if (radix < 10 || decimalMatch == null) {
        maxCharCode = radix <= 10 ? 47 + radix : 86 + radix;
        digitsPart = match[1];
        for (t1 = digitsPart.length, i = 0; i < t1; ++i)
          if ((C.JSString_methods._codeUnitAt$1(digitsPart, i) | 32) > maxCharCode)
            return;
      }
      return parseInt(source, radix);
    },
    Primitives_parseDouble: function(source) {
      var result, trimmed;
      if (!/^\s*[+-]?(?:Infinity|NaN|(?:\.\d+|\d+(?:\.\d*)?)(?:[eE][+-]?\d+)?)\s*$/.test(source))
        return;
      result = parseFloat(source);
      if (isNaN(result)) {
        trimmed = C.JSString_methods.trim$0(source);
        if (trimmed === "NaN" || trimmed === "+NaN" || trimmed === "-NaN")
          return result;
        return;
      }
      return result;
    },
    Primitives_objectTypeName: function(object) {
      return H.Primitives__objectClassName(object) + H._joinArguments(H.getRuntimeTypeInfo(object), 0, null);
    },
    Primitives__objectClassName: function(object) {
      var interceptorConstructorName, $name, t1, dispatchName, objectConstructor, match, decompiledName,
        interceptor = J.getInterceptor$(object),
        interceptorConstructor = interceptor.constructor;
      if (typeof interceptorConstructor == "function") {
        interceptorConstructorName = interceptorConstructor.name;
        $name = typeof interceptorConstructorName === "string" ? interceptorConstructorName : null;
      } else
        $name = null;
      t1 = $name == null;
      if (t1 || interceptor === C.Interceptor_methods || !!interceptor.$isUnknownJavaScriptObject) {
        dispatchName = C.C_JS_CONST(object);
        if (t1)
          $name = dispatchName;
        if (dispatchName === "Object") {
          objectConstructor = object.constructor;
          if (typeof objectConstructor == "function") {
            match = String(objectConstructor).match(/^\s*function\s*([\w$]*)\s*\(/);
            decompiledName = match == null ? null : match[1];
            if (typeof decompiledName === "string" && /^\w+$/.test(decompiledName))
              $name = decompiledName;
          }
        }
        return $name;
      }
      $name = $name;
      return H.unminifyOrTag($name.length > 1 && C.JSString_methods._codeUnitAt$1($name, 0) === 36 ? C.JSString_methods.substring$1($name, 1) : $name);
    },
    Primitives_currentUri: function() {
      if (!!self.location)
        return self.location.href;
      return;
    },
    Primitives__fromCharCodeApply: function(array) {
      var result, i, i0, chunkEnd,
        end = J.get$length$asx(array);
      if (end <= 500)
        return String.fromCharCode.apply(null, array);
      for (result = "", i = 0; i < end; i = i0) {
        i0 = i + 500;
        chunkEnd = i0 < end ? i0 : end;
        result += String.fromCharCode.apply(null, array.slice(i, chunkEnd));
      }
      return result;
    },
    Primitives_stringFromCodePoints: function(codePoints) {
      var t1, i,
        a = H.setRuntimeTypeInfo([], [P.int]);
      for (t1 = J.get$iterator$ax(codePoints); t1.moveNext$0();) {
        i = t1.get$current(t1);
        if (typeof i !== "number" || Math.floor(i) !== i)
          throw H.wrapException(H.argumentErrorValue(i));
        if (i <= 65535)
          a.push(i);
        else if (i <= 1114111) {
          a.push(55296 + (C.JSInt_methods._shrOtherPositive$1(i - 65536, 10) & 1023));
          a.push(56320 + (i & 1023));
        } else
          throw H.wrapException(H.argumentErrorValue(i));
      }
      return H.Primitives__fromCharCodeApply(a);
    },
    Primitives_stringFromCharCodes: function(charCodes) {
      var t1, i;
      for (t1 = J.get$iterator$ax(charCodes); t1.moveNext$0();) {
        i = t1.get$current(t1);
        if (typeof i !== "number" || Math.floor(i) !== i)
          throw H.wrapException(H.argumentErrorValue(i));
        if (i < 0)
          throw H.wrapException(H.argumentErrorValue(i));
        if (i > 65535)
          return H.Primitives_stringFromCodePoints(charCodes);
      }
      return H.Primitives__fromCharCodeApply(charCodes);
    },
    Primitives_stringFromNativeUint8List: function(charCodes, start, end) {
      var i, result, i0, chunkEnd;
      if (end <= 500 && start === 0 && end === charCodes.length)
        return String.fromCharCode.apply(null, charCodes);
      for (i = start, result = ""; i < end; i = i0) {
        i0 = i + 500;
        chunkEnd = i0 < end ? i0 : end;
        result += String.fromCharCode.apply(null, charCodes.subarray(i, chunkEnd));
      }
      return result;
    },
    Primitives_stringFromCharCode: function(charCode) {
      var bits;
      if (0 <= charCode) {
        if (charCode <= 65535)
          return String.fromCharCode(charCode);
        if (charCode <= 1114111) {
          bits = charCode - 65536;
          return String.fromCharCode((55296 | C.JSInt_methods._shrOtherPositive$1(bits, 10)) >>> 0, 56320 | bits & 1023);
        }
      }
      throw H.wrapException(P.RangeError$range(charCode, 0, 1114111, null, null));
    },
    Primitives_lazyAsJsDate: function(receiver) {
      if (receiver.date === void 0)
        receiver.date = new Date(receiver._value);
      return receiver.date;
    },
    Primitives_getYear: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getFullYear() + 0;
      return t1;
    },
    Primitives_getMonth: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getMonth() + 1;
      return t1;
    },
    Primitives_getDay: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getDate() + 0;
      return t1;
    },
    Primitives_getHours: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getHours() + 0;
      return t1;
    },
    Primitives_getMinutes: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getMinutes() + 0;
      return t1;
    },
    Primitives_getSeconds: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getSeconds() + 0;
      return t1;
    },
    Primitives_getMilliseconds: function(receiver) {
      var t1 = H.Primitives_lazyAsJsDate(receiver).getMilliseconds() + 0;
      return t1;
    },
    Primitives_functionNoSuchMethod: function($function, positionalArguments, namedArguments) {
      var $arguments, namedArgumentList, t1 = {};
      t1.argumentCount = 0;
      $arguments = [];
      namedArgumentList = [];
      t1.argumentCount = positionalArguments.length;
      C.JSArray_methods.addAll$1($arguments, positionalArguments);
      t1.names = "";
      if (namedArguments != null && !namedArguments.get$isEmpty(namedArguments))
        namedArguments.forEach$1(0, new H.Primitives_functionNoSuchMethod_closure(t1, namedArgumentList, $arguments));
      "" + t1.argumentCount;
      return J.noSuchMethod$1$($function, new H.JSInvocationMirror(C.Symbol_call, 0, $arguments, namedArgumentList, 0));
    },
    Primitives_applyFunction: function($function, positionalArguments, namedArguments) {
      var t1, $arguments, argumentCount, jsStub;
      if (positionalArguments instanceof Array)
        t1 = namedArguments == null || namedArguments.get$isEmpty(namedArguments);
      else
        t1 = false;
      if (t1) {
        $arguments = positionalArguments;
        argumentCount = $arguments.length;
        if (argumentCount === 0) {
          if (!!$function.call$0)
            return $function.call$0();
        } else if (argumentCount === 1) {
          if (!!$function.call$1)
            return $function.call$1($arguments[0]);
        } else if (argumentCount === 2) {
          if (!!$function.call$2)
            return $function.call$2($arguments[0], $arguments[1]);
        } else if (argumentCount === 3) {
          if (!!$function.call$3)
            return $function.call$3($arguments[0], $arguments[1], $arguments[2]);
        } else if (argumentCount === 4) {
          if (!!$function.call$4)
            return $function.call$4($arguments[0], $arguments[1], $arguments[2], $arguments[3]);
        } else if (argumentCount === 5)
          if (!!$function.call$5)
            return $function.call$5($arguments[0], $arguments[1], $arguments[2], $arguments[3], $arguments[4]);
        jsStub = $function["call" + "$" + argumentCount];
        if (jsStub != null)
          return jsStub.apply($function, $arguments);
      }
      return H.Primitives__genericApplyFunction2($function, positionalArguments, namedArguments);
    },
    Primitives__genericApplyFunction2: function($function, positionalArguments, namedArguments) {
      var $arguments, argumentCount, requiredParameterCount, defaultValuesClosure, t1, defaultValues, interceptor, jsFunction, keys, _i, used, t2;
      if (positionalArguments != null)
        $arguments = positionalArguments instanceof Array ? positionalArguments : P.List_List$from(positionalArguments, true, null);
      else
        $arguments = [];
      argumentCount = $arguments.length;
      requiredParameterCount = $function.$requiredArgCount;
      if (argumentCount < requiredParameterCount)
        return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
      defaultValuesClosure = $function.$defaultValues;
      t1 = defaultValuesClosure == null;
      defaultValues = !t1 ? defaultValuesClosure() : null;
      interceptor = J.getInterceptor$($function);
      jsFunction = interceptor["call*"];
      if (typeof jsFunction === "string")
        jsFunction = interceptor[jsFunction];
      if (t1) {
        if (namedArguments != null && namedArguments.get$isNotEmpty(namedArguments))
          return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        if (argumentCount === requiredParameterCount)
          return jsFunction.apply($function, $arguments);
        return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
      }
      if (defaultValues instanceof Array) {
        if (namedArguments != null && namedArguments.get$isNotEmpty(namedArguments))
          return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        if (argumentCount > requiredParameterCount + defaultValues.length)
          return H.Primitives_functionNoSuchMethod($function, $arguments, null);
        C.JSArray_methods.addAll$1($arguments, defaultValues.slice(argumentCount - requiredParameterCount));
        return jsFunction.apply($function, $arguments);
      } else {
        if (argumentCount > requiredParameterCount)
          return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        keys = Object.keys(defaultValues);
        if (namedArguments == null)
          for (t1 = keys.length, _i = 0; _i < keys.length; keys.length === t1 || (0, H.throwConcurrentModificationError)(keys), ++_i)
            C.JSArray_methods.add$1($arguments, defaultValues[keys[_i]]);
        else {
          for (t1 = keys.length, used = 0, _i = 0; _i < keys.length; keys.length === t1 || (0, H.throwConcurrentModificationError)(keys), ++_i) {
            t2 = keys[_i];
            if (namedArguments.containsKey$1(t2)) {
              ++used;
              C.JSArray_methods.add$1($arguments, namedArguments.$index(0, t2));
            } else
              C.JSArray_methods.add$1($arguments, defaultValues[t2]);
          }
          if (used !== namedArguments.get$length(namedArguments))
            return H.Primitives_functionNoSuchMethod($function, $arguments, namedArguments);
        }
        return jsFunction.apply($function, $arguments);
      }
    },
    diagnoseIndexError: function(indexable, index) {
      var $length, _s5_ = "index";
      if (typeof index !== "number" || Math.floor(index) !== index)
        return new P.ArgumentError(true, index, _s5_, null);
      $length = J.get$length$asx(indexable);
      if (index < 0 || index >= $length)
        return P.IndexError$(index, indexable, _s5_, null, $length);
      return P.RangeError$value(index, _s5_, null);
    },
    diagnoseRangeError: function(start, end, $length) {
      var _s13_ = "Invalid value";
      if (typeof start !== "number" || Math.floor(start) !== start)
        return new P.ArgumentError(true, start, "start", null);
      if (start < 0 || start > $length)
        return new P.RangeError(0, $length, true, start, "start", _s13_);
      if (end != null)
        if (end < start || end > $length)
          return new P.RangeError(start, $length, true, end, "end", _s13_);
      return new P.ArgumentError(true, end, "end", null);
    },
    argumentErrorValue: function(object) {
      return new P.ArgumentError(true, object, null, null);
    },
    checkNum: function(value) {
      if (typeof value !== "number")
        throw H.wrapException(H.argumentErrorValue(value));
      return value;
    },
    wrapException: function(ex) {
      var wrapper;
      if (ex == null)
        ex = new P.NullThrownError();
      wrapper = new Error();
      wrapper.dartException = ex;
      if ("defineProperty" in Object) {
        Object.defineProperty(wrapper, "message", {get: H.toStringWrapper});
        wrapper.name = "";
      } else
        wrapper.toString = H.toStringWrapper;
      return wrapper;
    },
    toStringWrapper: function() {
      return J.toString$0$(this.dartException);
    },
    throwExpression: function(ex) {
      throw H.wrapException(ex);
    },
    throwConcurrentModificationError: function(collection) {
      throw H.wrapException(P.ConcurrentModificationError$(collection));
    },
    TypeErrorDecoder_extractPattern: function(message) {
      var match, $arguments, argumentsExpr, expr, method, receiver;
      message = H.quoteStringForRegExp(message.replace(String({}), '$receiver$'));
      match = message.match(/\\\$[a-zA-Z]+\\\$/g);
      if (match == null)
        match = H.setRuntimeTypeInfo([], [P.String]);
      $arguments = match.indexOf("\\$arguments\\$");
      argumentsExpr = match.indexOf("\\$argumentsExpr\\$");
      expr = match.indexOf("\\$expr\\$");
      method = match.indexOf("\\$method\\$");
      receiver = match.indexOf("\\$receiver\\$");
      return new H.TypeErrorDecoder(message.replace(new RegExp('\\\\\\$arguments\\\\\\$', 'g'), '((?:x|[^x])*)').replace(new RegExp('\\\\\\$argumentsExpr\\\\\\$', 'g'), '((?:x|[^x])*)').replace(new RegExp('\\\\\\$expr\\\\\\$', 'g'), '((?:x|[^x])*)').replace(new RegExp('\\\\\\$method\\\\\\$', 'g'), '((?:x|[^x])*)').replace(new RegExp('\\\\\\$receiver\\\\\\$', 'g'), '((?:x|[^x])*)'), $arguments, argumentsExpr, expr, method, receiver);
    },
    TypeErrorDecoder_provokeCallErrorOn: function(expression) {
      return function($expr$) {
        var $argumentsExpr$ = '$arguments$';
        try {
          $expr$.$method$($argumentsExpr$);
        } catch (e) {
          return e.message;
        }
      }(expression);
    },
    TypeErrorDecoder_provokePropertyErrorOn: function(expression) {
      return function($expr$) {
        try {
          $expr$.$method$;
        } catch (e) {
          return e.message;
        }
      }(expression);
    },
    NullError$: function(_message, match) {
      return new H.NullError(_message, match == null ? null : match.method);
    },
    JsNoSuchMethodError$: function(_message, match) {
      var t1 = match == null,
        t2 = t1 ? null : match.method;
      return new H.JsNoSuchMethodError(_message, t2, t1 ? null : match.receiver);
    },
    unwrapException: function(ex) {
      var message, number, ieErrorCode, nsme, notClosure, nullCall, nullLiteralCall, undefCall, undefLiteralCall, nullProperty, undefProperty, undefLiteralProperty, match, t2, _null = null,
        t1 = new H.unwrapException_saveStackTrace(ex);
      if (ex == null)
        return;
      if (ex instanceof H.ExceptionAndStackTrace)
        return t1.call$1(ex.dartException);
      if (typeof ex !== "object")
        return ex;
      if ("dartException" in ex)
        return t1.call$1(ex.dartException);
      else if (!("message" in ex))
        return ex;
      message = ex.message;
      if ("number" in ex && typeof ex.number == "number") {
        number = ex.number;
        ieErrorCode = number & 65535;
        if ((C.JSInt_methods._shrOtherPositive$1(number, 16) & 8191) === 10)
          switch (ieErrorCode) {
            case 438:
              return t1.call$1(H.JsNoSuchMethodError$(H.S(message) + " (Error " + ieErrorCode + ")", _null));
            case 445:
            case 5007:
              return t1.call$1(H.NullError$(H.S(message) + " (Error " + ieErrorCode + ")", _null));
          }
      }
      if (ex instanceof TypeError) {
        nsme = $.$get$TypeErrorDecoder_noSuchMethodPattern();
        notClosure = $.$get$TypeErrorDecoder_notClosurePattern();
        nullCall = $.$get$TypeErrorDecoder_nullCallPattern();
        nullLiteralCall = $.$get$TypeErrorDecoder_nullLiteralCallPattern();
        undefCall = $.$get$TypeErrorDecoder_undefinedCallPattern();
        undefLiteralCall = $.$get$TypeErrorDecoder_undefinedLiteralCallPattern();
        nullProperty = $.$get$TypeErrorDecoder_nullPropertyPattern();
        $.$get$TypeErrorDecoder_nullLiteralPropertyPattern();
        undefProperty = $.$get$TypeErrorDecoder_undefinedPropertyPattern();
        undefLiteralProperty = $.$get$TypeErrorDecoder_undefinedLiteralPropertyPattern();
        match = nsme.matchTypeError$1(message);
        if (match != null)
          return t1.call$1(H.JsNoSuchMethodError$(message, match));
        else {
          match = notClosure.matchTypeError$1(message);
          if (match != null) {
            match.method = "call";
            return t1.call$1(H.JsNoSuchMethodError$(message, match));
          } else {
            match = nullCall.matchTypeError$1(message);
            if (match == null) {
              match = nullLiteralCall.matchTypeError$1(message);
              if (match == null) {
                match = undefCall.matchTypeError$1(message);
                if (match == null) {
                  match = undefLiteralCall.matchTypeError$1(message);
                  if (match == null) {
                    match = nullProperty.matchTypeError$1(message);
                    if (match == null) {
                      match = nullLiteralCall.matchTypeError$1(message);
                      if (match == null) {
                        match = undefProperty.matchTypeError$1(message);
                        if (match == null) {
                          match = undefLiteralProperty.matchTypeError$1(message);
                          t2 = match != null;
                        } else
                          t2 = true;
                      } else
                        t2 = true;
                    } else
                      t2 = true;
                  } else
                    t2 = true;
                } else
                  t2 = true;
              } else
                t2 = true;
            } else
              t2 = true;
            if (t2)
              return t1.call$1(H.NullError$(message, match));
          }
        }
        return t1.call$1(new H.UnknownJsTypeError(typeof message === "string" ? message : ""));
      }
      if (ex instanceof RangeError) {
        if (typeof message === "string" && message.indexOf("call stack") !== -1)
          return new P.StackOverflowError();
        message = function(ex) {
          try {
            return String(ex);
          } catch (e) {
          }
          return null;
        }(ex);
        return t1.call$1(new P.ArgumentError(false, _null, _null, typeof message === "string" ? message.replace(/^RangeError:\s*/, "") : message));
      }
      if (typeof InternalError == "function" && ex instanceof InternalError)
        if (typeof message === "string" && message === "too much recursion")
          return new P.StackOverflowError();
      return ex;
    },
    getTraceFromException: function(exception) {
      var trace;
      if (exception instanceof H.ExceptionAndStackTrace)
        return exception.stackTrace;
      if (exception == null)
        return new H._StackTrace(exception);
      trace = exception.$cachedTrace;
      if (trace != null)
        return trace;
      return exception.$cachedTrace = new H._StackTrace(exception);
    },
    objectHashCode: function(object) {
      if (object == null || typeof object != 'object')
        return J.get$hashCode$(object);
      else
        return H.Primitives_objectHashCode(object);
    },
    fillLiteralMap: function(keyValuePairs, result) {
      var index, index0, index1,
        $length = keyValuePairs.length;
      for (index = 0; index < $length; index = index1) {
        index0 = index + 1;
        index1 = index0 + 1;
        result.$indexSet(0, keyValuePairs[index], keyValuePairs[index0]);
      }
      return result;
    },
    fillLiteralSet: function(values, result) {
      var index,
        $length = values.length;
      for (index = 0; index < $length; ++index)
        result.add$1(0, values[index]);
      return result;
    },
    invokeClosure: function(closure, numberOfArguments, arg1, arg2, arg3, arg4) {
      switch (numberOfArguments) {
        case 0:
          return closure.call$0();
        case 1:
          return closure.call$1(arg1);
        case 2:
          return closure.call$2(arg1, arg2);
        case 3:
          return closure.call$3(arg1, arg2, arg3);
        case 4:
          return closure.call$4(arg1, arg2, arg3, arg4);
      }
      throw H.wrapException(new P._Exception("Unsupported number of arguments for wrapped closure"));
    },
    convertDartClosureToJS: function(closure, arity) {
      var $function;
      if (closure == null)
        return;
      $function = closure.$identity;
      if (!!$function)
        return $function;
      $function = function(closure, arity, invoke) {
        return function(a1, a2, a3, a4) {
          return invoke(closure, arity, a1, a2, a3, a4);
        };
      }(closure, arity, H.invokeClosure);
      closure.$identity = $function;
      return $function;
    },
    Closure_fromTearOff: function(receiver, functions, applyTrampolineIndex, reflectionInfo, isStatic, isIntercepted, propertyName) {
      var $constructor, t1, trampoline, signatureFunction, applyTrampoline, i, stub, stubCallName, _null = null,
        $function = functions[0],
        callName = $function.$callName,
        $prototype = isStatic ? Object.create(new H.StaticClosure().constructor.prototype) : Object.create(new H.BoundClosure(_null, _null, _null, _null).constructor.prototype);
      $prototype.$initialize = $prototype.constructor;
      if (isStatic)
        $constructor = function static_tear_off() {
          this.$initialize();
        };
      else {
        t1 = $.Closure_functionCounter;
        $.Closure_functionCounter = t1 + 1;
        t1 = new Function("a,b,c,d" + t1, "this.$initialize(a,b,c,d" + t1 + ")");
        $constructor = t1;
      }
      $prototype.constructor = $constructor;
      $constructor.prototype = $prototype;
      if (!isStatic) {
        trampoline = H.Closure_forwardCallTo(receiver, $function, isIntercepted);
        trampoline.$reflectionInfo = reflectionInfo;
      } else {
        $prototype.$static_name = propertyName;
        trampoline = $function;
      }
      signatureFunction = H.Closure__computeSignatureFunctionLegacy(reflectionInfo, isStatic, isIntercepted);
      $prototype.$signature = signatureFunction;
      $prototype[callName] = trampoline;
      for (applyTrampoline = trampoline, i = 1; i < functions.length; ++i) {
        stub = functions[i];
        stubCallName = stub.$callName;
        if (stubCallName != null) {
          stub = isStatic ? stub : H.Closure_forwardCallTo(receiver, stub, isIntercepted);
          $prototype[stubCallName] = stub;
        }
        if (i === applyTrampolineIndex) {
          stub.$reflectionInfo = reflectionInfo;
          applyTrampoline = stub;
        }
      }
      $prototype["call*"] = applyTrampoline;
      $prototype.$requiredArgCount = $function.$requiredArgCount;
      $prototype.$defaultValues = $function.$defaultValues;
      return $constructor;
    },
    Closure__computeSignatureFunctionLegacy: function(functionType, isStatic, isIntercepted) {
      var getReceiver;
      if (typeof functionType == "number")
        return function(getType, t) {
          return function() {
            return getType(t);
          };
        }(H.getType, functionType);
      if (typeof functionType == "function")
        if (isStatic)
          return functionType;
        else {
          getReceiver = isIntercepted ? H.BoundClosure_receiverOf : H.BoundClosure_selfOf;
          return function(f, r) {
            return function() {
              return f.apply({$receiver: r(this)}, arguments);
            };
          }(functionType, getReceiver);
        }
      throw H.wrapException("Error in functionType of tearoff");
    },
    Closure_cspForwardCall: function(arity, isSuperCall, stubName, $function) {
      var getSelf = H.BoundClosure_selfOf;
      switch (isSuperCall ? -1 : arity) {
        case 0:
          return function(n, S) {
            return function() {
              return S(this)[n]();
            };
          }(stubName, getSelf);
        case 1:
          return function(n, S) {
            return function(a) {
              return S(this)[n](a);
            };
          }(stubName, getSelf);
        case 2:
          return function(n, S) {
            return function(a, b) {
              return S(this)[n](a, b);
            };
          }(stubName, getSelf);
        case 3:
          return function(n, S) {
            return function(a, b, c) {
              return S(this)[n](a, b, c);
            };
          }(stubName, getSelf);
        case 4:
          return function(n, S) {
            return function(a, b, c, d) {
              return S(this)[n](a, b, c, d);
            };
          }(stubName, getSelf);
        case 5:
          return function(n, S) {
            return function(a, b, c, d, e) {
              return S(this)[n](a, b, c, d, e);
            };
          }(stubName, getSelf);
        default:
          return function(f, s) {
            return function() {
              return f.apply(s(this), arguments);
            };
          }($function, getSelf);
      }
    },
    Closure_forwardCallTo: function(receiver, $function, isIntercepted) {
      var stubName, arity, lookedUpFunction, t1, t2, selfName, $arguments;
      if (isIntercepted)
        return H.Closure_forwardInterceptedCallTo(receiver, $function);
      stubName = $function.$stubName;
      arity = $function.length;
      lookedUpFunction = receiver[stubName];
      t1 = $function == null ? lookedUpFunction == null : $function === lookedUpFunction;
      t2 = !t1 || arity >= 27;
      if (t2)
        return H.Closure_cspForwardCall(arity, !t1, stubName, $function);
      if (arity === 0) {
        t1 = $.Closure_functionCounter;
        $.Closure_functionCounter = t1 + 1;
        selfName = "self" + H.S(t1);
        t1 = "return function(){var " + selfName + " = this.";
        t2 = $.BoundClosure_selfFieldNameCache;
        return new Function(t1 + H.S(t2 == null ? $.BoundClosure_selfFieldNameCache = H.BoundClosure_computeFieldNamed("self") : t2) + ";return " + selfName + "." + H.S(stubName) + "();}")();
      }
      $arguments = "abcdefghijklmnopqrstuvwxyz".split("").splice(0, arity).join(",");
      t1 = $.Closure_functionCounter;
      $.Closure_functionCounter = t1 + 1;
      $arguments += H.S(t1);
      t1 = "return function(" + $arguments + "){return this.";
      t2 = $.BoundClosure_selfFieldNameCache;
      return new Function(t1 + H.S(t2 == null ? $.BoundClosure_selfFieldNameCache = H.BoundClosure_computeFieldNamed("self") : t2) + "." + H.S(stubName) + "(" + $arguments + ");}")();
    },
    Closure_cspForwardInterceptedCall: function(arity, isSuperCall, $name, $function) {
      var getSelf = H.BoundClosure_selfOf,
        getReceiver = H.BoundClosure_receiverOf;
      switch (isSuperCall ? -1 : arity) {
        case 0:
          throw H.wrapException(H.RuntimeError$("Intercepted function with no arguments."));
        case 1:
          return function(n, s, r) {
            return function() {
              return s(this)[n](r(this));
            };
          }($name, getSelf, getReceiver);
        case 2:
          return function(n, s, r) {
            return function(a) {
              return s(this)[n](r(this), a);
            };
          }($name, getSelf, getReceiver);
        case 3:
          return function(n, s, r) {
            return function(a, b) {
              return s(this)[n](r(this), a, b);
            };
          }($name, getSelf, getReceiver);
        case 4:
          return function(n, s, r) {
            return function(a, b, c) {
              return s(this)[n](r(this), a, b, c);
            };
          }($name, getSelf, getReceiver);
        case 5:
          return function(n, s, r) {
            return function(a, b, c, d) {
              return s(this)[n](r(this), a, b, c, d);
            };
          }($name, getSelf, getReceiver);
        case 6:
          return function(n, s, r) {
            return function(a, b, c, d, e) {
              return s(this)[n](r(this), a, b, c, d, e);
            };
          }($name, getSelf, getReceiver);
        default:
          return function(f, s, r, a) {
            return function() {
              a = [r(this)];
              Array.prototype.push.apply(a, arguments);
              return f.apply(s(this), a);
            };
          }($function, getSelf, getReceiver);
      }
    },
    Closure_forwardInterceptedCallTo: function(receiver, $function) {
      var t2, stubName, arity, lookedUpFunction, t3, t4, $arguments,
        t1 = $.BoundClosure_selfFieldNameCache;
      if (t1 == null)
        t1 = $.BoundClosure_selfFieldNameCache = H.BoundClosure_computeFieldNamed("self");
      t2 = $.BoundClosure_receiverFieldNameCache;
      if (t2 == null)
        t2 = $.BoundClosure_receiverFieldNameCache = H.BoundClosure_computeFieldNamed("receiver");
      stubName = $function.$stubName;
      arity = $function.length;
      lookedUpFunction = receiver[stubName];
      t3 = $function == null ? lookedUpFunction == null : $function === lookedUpFunction;
      t4 = !t3 || arity >= 28;
      if (t4)
        return H.Closure_cspForwardInterceptedCall(arity, !t3, stubName, $function);
      if (arity === 1) {
        t1 = "return function(){return this." + H.S(t1) + "." + H.S(stubName) + "(this." + H.S(t2) + ");";
        t2 = $.Closure_functionCounter;
        $.Closure_functionCounter = t2 + 1;
        return new Function(t1 + H.S(t2) + "}")();
      }
      $arguments = "abcdefghijklmnopqrstuvwxyz".split("").splice(0, arity - 1).join(",");
      t1 = "return function(" + $arguments + "){return this." + H.S(t1) + "." + H.S(stubName) + "(this." + H.S(t2) + ", " + $arguments + ");";
      t2 = $.Closure_functionCounter;
      $.Closure_functionCounter = t2 + 1;
      return new Function(t1 + H.S(t2) + "}")();
    },
    closureFromTearOff: function(receiver, functions, applyTrampolineIndex, reflectionInfo, isStatic, isIntercepted, $name) {
      return H.Closure_fromTearOff(receiver, functions, applyTrampolineIndex, reflectionInfo, !!isStatic, !!isIntercepted, $name);
    },
    BoundClosure_selfOf: function(closure) {
      return closure._self;
    },
    BoundClosure_receiverOf: function(closure) {
      return closure._receiver;
    },
    BoundClosure_computeFieldNamed: function(fieldName) {
      var t1, i, $name,
        template = new H.BoundClosure("self", "target", "receiver", "name"),
        names = J.JSArray_markFixedList(Object.getOwnPropertyNames(template));
      for (t1 = names.length, i = 0; i < t1; ++i) {
        $name = names[i];
        if (template[$name] === fieldName)
          return $name;
      }
    },
    stringTypeCast: function(value) {
      if (typeof value === "string" || value == null)
        return value;
      throw H.wrapException(H.CastErrorImplementation$(value, "String"));
    },
    boolTypeCast: function(value) {
      if (typeof value === "boolean" || value == null)
        return value;
      throw H.wrapException(H.CastErrorImplementation$(value, "bool"));
    },
    intTypeCast: function(value) {
      if (typeof value === "number" && Math.floor(value) === value || value == null)
        return value;
      throw H.wrapException(H.CastErrorImplementation$(value, "int"));
    },
    propertyTypeCastError: function(value, property) {
      throw H.wrapException(H.CastErrorImplementation$(value, H.unminifyOrTag(property.substring(3))));
    },
    interceptedTypeCast: function(value, property) {
      var t1;
      if (value != null)
        t1 = (typeof value === "object" || typeof value === "function") && J.getInterceptor$(value)[property];
      else
        t1 = true;
      if (t1)
        return value;
      H.propertyTypeCastError(value, property);
    },
    numberOrStringSuperNativeTypeCast: function(value, property) {
      if (value == null)
        return value;
      if (typeof value === "string")
        return value;
      if (typeof value === "number")
        return value;
      if (J.getInterceptor$(value)[property])
        return value;
      H.propertyTypeCastError(value, property);
    },
    extractFunctionTypeObjectFromInternal: function(o) {
      var signature;
      if ("$signature" in o) {
        signature = o.$signature;
        if (typeof signature == "number")
          return init.types[signature];
        else
          return o.$signature();
      }
      return;
    },
    functionTypeTest: function(value, functionTypeRti) {
      var functionTypeObject;
      if (typeof value == "function")
        return true;
      functionTypeObject = H.extractFunctionTypeObjectFromInternal(J.getInterceptor$(value));
      if (functionTypeObject == null)
        return false;
      return H._isFunctionSubtype(functionTypeObject, null, functionTypeRti, null);
    },
    CastErrorImplementation$: function(value, type) {
      return new H.CastErrorImplementation("CastError: " + P.Error_safeToString(value) + ": type '" + H.S(H._typeDescription(value)) + "' is not a subtype of type '" + type + "'");
    },
    _typeDescription: function(value) {
      var functionTypeObject,
        t1 = J.getInterceptor$(value);
      if (!!t1.$isClosure) {
        functionTypeObject = H.extractFunctionTypeObjectFromInternal(t1);
        if (functionTypeObject != null)
          return H.runtimeTypeToString(functionTypeObject);
        return "Closure";
      }
      return H.Primitives_objectTypeName(value);
    },
    throwCyclicInit: function(staticName) {
      throw H.wrapException(new P.CyclicInitializationError(staticName));
    },
    RuntimeError$: function(message) {
      return new H.RuntimeError(message);
    },
    getIsolateAffinityTag: function($name) {
      return init.getIsolateTag($name);
    },
    setRuntimeTypeInfo: function(target, rti) {
      target.$ti = rti;
      return target;
    },
    getRuntimeTypeInfo: function(target) {
      if (target == null)
        return;
      return target.$ti;
    },
    getRuntimeTypeArguments: function(interceptor, object, substitutionName) {
      return H.substitute(interceptor["$as" + H.S(substitutionName)], H.getRuntimeTypeInfo(object));
    },
    getRuntimeTypeArgumentIntercepted: function(interceptor, target, substitutionName, index) {
      var $arguments = H.substitute(interceptor["$as" + H.S(substitutionName)], H.getRuntimeTypeInfo(target));
      return $arguments == null ? null : $arguments[index];
    },
    getRuntimeTypeArgument: function(target, substitutionName, index) {
      var $arguments = H.substitute(target["$as" + H.S(substitutionName)], H.getRuntimeTypeInfo(target));
      return $arguments == null ? null : $arguments[index];
    },
    getTypeArgumentByIndex: function(target, index) {
      var rti = H.getRuntimeTypeInfo(target);
      return rti == null ? null : rti[index];
    },
    runtimeTypeToString: function(rti) {
      return H._runtimeTypeToString(rti, null);
    },
    _runtimeTypeToString: function(rti, genericContext) {
      if (rti == null)
        return "dynamic";
      if (rti === -1)
        return "void";
      if (typeof rti === "object" && rti !== null && rti.constructor === Array)
        return H.unminifyOrTag(rti[0].name) + H._joinArguments(rti, 1, genericContext);
      if (typeof rti == "function")
        return H.unminifyOrTag(rti.name);
      if (rti === -2)
        return "dynamic";
      if (typeof rti === "number") {
        if (genericContext == null || rti < 0 || rti >= genericContext.length)
          return "unexpected-generic-index:" + H.S(rti);
        return H.S(genericContext[genericContext.length - rti - 1]);
      }
      if ('func' in rti)
        return H._functionRtiToString(rti, genericContext);
      if ('futureOr' in rti)
        return "FutureOr<" + H._runtimeTypeToString("type" in rti ? rti.type : null, genericContext) + ">";
      return "unknown-reified-type";
    },
    _functionRtiToString: function(rti, genericContext) {
      var boundsRti, outerContextLength, offset, i, i0, typeParameters, typeSep, boundRti, returnTypeText, $arguments, t1, argumentsText, sep, _i, argument, optionalArguments, namedArguments, t2, t3, _s2_ = ", ";
      if ("bounds" in rti) {
        boundsRti = rti.bounds;
        if (genericContext == null) {
          genericContext = H.setRuntimeTypeInfo([], [P.String]);
          outerContextLength = null;
        } else
          outerContextLength = genericContext.length;
        offset = genericContext.length;
        for (i = boundsRti.length, i0 = i; i0 > 0; --i0)
          genericContext.push("T" + (offset + i0));
        for (typeParameters = "<", typeSep = "", i0 = 0; i0 < i; ++i0, typeSep = _s2_) {
          typeParameters = C.JSString_methods.$add(typeParameters + typeSep, genericContext[genericContext.length - i0 - 1]);
          boundRti = boundsRti[i0];
          if (boundRti != null && boundRti !== P.Object)
            typeParameters += " extends " + H._runtimeTypeToString(boundRti, genericContext);
        }
        typeParameters += ">";
      } else {
        typeParameters = "";
        outerContextLength = null;
      }
      returnTypeText = !!rti.v ? "void" : H._runtimeTypeToString(rti.ret, genericContext);
      if ("args" in rti) {
        $arguments = rti.args;
        for (t1 = $arguments.length, argumentsText = "", sep = "", _i = 0; _i < t1; ++_i, sep = _s2_) {
          argument = $arguments[_i];
          argumentsText = argumentsText + sep + H._runtimeTypeToString(argument, genericContext);
        }
      } else {
        argumentsText = "";
        sep = "";
      }
      if ("opt" in rti) {
        optionalArguments = rti.opt;
        argumentsText += sep + "[";
        for (t1 = optionalArguments.length, sep = "", _i = 0; _i < t1; ++_i, sep = _s2_) {
          argument = optionalArguments[_i];
          argumentsText = argumentsText + sep + H._runtimeTypeToString(argument, genericContext);
        }
        argumentsText += "]";
      }
      if ("named" in rti) {
        namedArguments = rti.named;
        argumentsText += sep + "{";
        for (t1 = H.extractKeys(namedArguments), t2 = t1.length, sep = "", _i = 0; _i < t2; ++_i, sep = _s2_) {
          t3 = t1[_i];
          argumentsText = argumentsText + sep + H._runtimeTypeToString(namedArguments[t3], genericContext) + (" " + H.S(t3));
        }
        argumentsText += "}";
      }
      if (outerContextLength != null)
        genericContext.length = outerContextLength;
      return typeParameters + "(" + argumentsText + ") => " + returnTypeText;
    },
    _joinArguments: function(types, startIndex, genericContext) {
      var buffer, index, separator, allDynamic, t1, argument;
      if (types == null)
        return "";
      buffer = new P.StringBuffer("");
      for (index = startIndex, separator = "", allDynamic = true, t1 = ""; index < types.length; ++index, separator = ", ") {
        buffer._contents = t1 + separator;
        argument = types[index];
        if (argument != null)
          allDynamic = false;
        t1 = buffer._contents += H._runtimeTypeToString(argument, genericContext);
      }
      return "<" + buffer.toString$0(0) + ">";
    },
    getRti: function(o) {
      var functionRti, type, rti,
        t1 = J.getInterceptor$(o);
      if (!!t1.$isClosure) {
        functionRti = H.extractFunctionTypeObjectFromInternal(t1);
        if (functionRti != null)
          return functionRti;
      }
      type = t1.constructor;
      if (typeof o != "object")
        return type;
      rti = H.getRuntimeTypeInfo(o);
      if (rti != null) {
        rti = rti.slice();
        rti.splice(0, 0, type);
        type = rti;
      }
      return type;
    },
    getRuntimeType: function(object) {
      return new H.TypeImpl(H.getRti(object));
    },
    substitute: function(substitution, $arguments) {
      if (substitution == null)
        return $arguments;
      substitution = substitution.apply(null, $arguments);
      if (substitution == null)
        return;
      if (typeof substitution === "object" && substitution !== null && substitution.constructor === Array)
        return substitution;
      if (typeof substitution == "function")
        return substitution.apply(null, $arguments);
      return $arguments;
    },
    checkSubtype: function(object, isField, checks, asField) {
      var $arguments, interceptor;
      if (object == null)
        return false;
      $arguments = H.getRuntimeTypeInfo(object);
      interceptor = J.getInterceptor$(object);
      if (interceptor[isField] == null)
        return false;
      return H.areSubtypes(H.substitute(interceptor[asField], $arguments), null, checks, null);
    },
    subtypeCast: function(object, isField, checks, asField) {
      if (object == null)
        return object;
      if (H.checkSubtype(object, isField, checks, asField))
        return object;
      throw H.wrapException(H.CastErrorImplementation$(object, function(str, names) {
        return str.replace(/[^<,> ]+/g, function(m) {
          return names[m] || m;
        });
      }(H.unminifyOrTag(isField.substring(3)) + H._joinArguments(checks, 0, null), init.mangledGlobalNames)));
    },
    areSubtypes: function(s, sEnv, t, tEnv) {
      var len, i;
      if (t == null)
        return true;
      if (s == null) {
        len = t.length;
        for (i = 0; i < len; ++i)
          if (!H._isSubtype(null, null, t[i], tEnv))
            return false;
        return true;
      }
      len = s.length;
      for (i = 0; i < len; ++i)
        if (!H._isSubtype(s[i], sEnv, t[i], tEnv))
          return false;
      return true;
    },
    computeSignature: function(signature, context, contextName) {
      return signature.apply(context, H.substitute(J.getInterceptor$(context)["$as" + H.S(contextName)], H.getRuntimeTypeInfo(context)));
    },
    isSupertypeOfNullRecursive: function(type) {
      var typeArgument;
      if (typeof type === "number")
        return false;
      if ('futureOr' in type) {
        typeArgument = "type" in type ? type.type : null;
        return type == null || type.name === "Object" || type.name === "Null" || type === -1 || type === -2 || H.isSupertypeOfNullRecursive(typeArgument);
      }
      return false;
    },
    checkSubtypeOfRuntimeType: function(o, t) {
      var type, rti;
      if (o == null)
        return t == null || t.name === "Object" || t.name === "Null" || t === -1 || t === -2 || H.isSupertypeOfNullRecursive(t);
      if (t == null || t === -1 || t.name === "Object" || t === -2)
        return true;
      if (typeof t == "object") {
        if ('futureOr' in t)
          if (H.checkSubtypeOfRuntimeType(o, "type" in t ? t.type : null))
            return true;
        if ('func' in t)
          return H.functionTypeTest(o, t);
      }
      type = J.getInterceptor$(o).constructor;
      rti = H.getRuntimeTypeInfo(o);
      if (rti != null) {
        rti = rti.slice();
        rti.splice(0, 0, type);
        type = rti;
      }
      return H._isSubtype(type, null, t, null);
    },
    subtypeOfRuntimeTypeCast: function(object, type) {
      if (object != null && !H.checkSubtypeOfRuntimeType(object, type))
        throw H.wrapException(H.CastErrorImplementation$(object, H.runtimeTypeToString(type)));
      return object;
    },
    _isSubtype: function(s, sEnv, t, tEnv) {
      var t1, typeOfS, tTypeArgument, futureSubstitution, futureArguments, t2, typeOfT, typeOfTString, substitution, _null = null;
      if (s === t)
        return true;
      if (t == null || t === -1 || t.name === "Object" || t === -2)
        return true;
      if (s === -2)
        return true;
      if (s == null || s === -1 || s.name === "Object" || s === -2) {
        if (typeof t === "number")
          return false;
        if ('futureOr' in t)
          return H._isSubtype(s, sEnv, "type" in t ? t.type : _null, tEnv);
        return false;
      }
      if (typeof s === "number")
        return H._isSubtype(sEnv[s], sEnv, t, tEnv);
      if (typeof t === "number")
        return false;
      if (s.name === "Null")
        return true;
      t1 = typeof s === "object" && s !== null && s.constructor === Array;
      typeOfS = t1 ? s[0] : s;
      if ('futureOr' in t) {
        tTypeArgument = "type" in t ? t.type : _null;
        if ('futureOr' in s)
          return H._isSubtype("type" in s ? s.type : _null, sEnv, tTypeArgument, tEnv);
        else if (H._isSubtype(s, sEnv, tTypeArgument, tEnv))
          return true;
        else {
          if (!('$is' + "Future" in typeOfS.prototype))
            return false;
          futureSubstitution = typeOfS.prototype["$as" + "Future"];
          futureArguments = H.substitute(futureSubstitution, t1 ? s.slice(1) : _null);
          return H._isSubtype(typeof futureArguments === "object" && futureArguments !== null && futureArguments.constructor === Array ? futureArguments[0] : _null, sEnv, tTypeArgument, tEnv);
        }
      }
      if ('func' in t)
        return H._isFunctionSubtype(s, sEnv, t, tEnv);
      if ('func' in s)
        return t.name === "Function";
      t2 = typeof t === "object" && t !== null && t.constructor === Array;
      typeOfT = t2 ? t[0] : t;
      if (typeOfT !== typeOfS) {
        typeOfTString = typeOfT.name;
        if (!('$is' + typeOfTString in typeOfS.prototype))
          return false;
        substitution = typeOfS.prototype["$as" + typeOfTString];
      } else
        substitution = _null;
      if (!t2)
        return true;
      t1 = t1 ? s.slice(1) : _null;
      t2 = t.slice(1);
      return H.areSubtypes(H.substitute(substitution, t1), sEnv, t2, tEnv);
    },
    _isFunctionSubtype: function(s, sEnv, t, tEnv) {
      var sBounds, tBounds, sParameterTypes, tParameterTypes, sOptionalParameterTypes, tOptionalParameterTypes, sParametersLen, tParametersLen, sOptionalParametersLen, tOptionalParametersLen, pos, tPos, sPos, sNamedParameters, tNamedParameters;
      if (!('func' in s))
        return false;
      if ("bounds" in s) {
        if (!("bounds" in t))
          return false;
        sBounds = s.bounds;
        tBounds = t.bounds;
        if (sBounds.length !== tBounds.length)
          return false;
        sEnv = sEnv == null ? sBounds : sBounds.concat(sEnv);
        tEnv = tEnv == null ? tBounds : tBounds.concat(tEnv);
      } else if ("bounds" in t)
        return false;
      if (!H._isSubtype(s.ret, sEnv, t.ret, tEnv))
        return false;
      sParameterTypes = s.args;
      tParameterTypes = t.args;
      sOptionalParameterTypes = s.opt;
      tOptionalParameterTypes = t.opt;
      sParametersLen = sParameterTypes != null ? sParameterTypes.length : 0;
      tParametersLen = tParameterTypes != null ? tParameterTypes.length : 0;
      sOptionalParametersLen = sOptionalParameterTypes != null ? sOptionalParameterTypes.length : 0;
      tOptionalParametersLen = tOptionalParameterTypes != null ? tOptionalParameterTypes.length : 0;
      if (sParametersLen > tParametersLen)
        return false;
      if (sParametersLen + sOptionalParametersLen < tParametersLen + tOptionalParametersLen)
        return false;
      for (pos = 0; pos < sParametersLen; ++pos)
        if (!H._isSubtype(tParameterTypes[pos], tEnv, sParameterTypes[pos], sEnv))
          return false;
      for (tPos = pos, sPos = 0; tPos < tParametersLen; ++sPos, ++tPos)
        if (!H._isSubtype(tParameterTypes[tPos], tEnv, sOptionalParameterTypes[sPos], sEnv))
          return false;
      for (tPos = 0; tPos < tOptionalParametersLen; ++sPos, ++tPos)
        if (!H._isSubtype(tOptionalParameterTypes[tPos], tEnv, sOptionalParameterTypes[sPos], sEnv))
          return false;
      sNamedParameters = s.named;
      tNamedParameters = t.named;
      if (tNamedParameters == null)
        return true;
      if (sNamedParameters == null)
        return false;
      return H.namedParametersSubtypeCheck(sNamedParameters, sEnv, tNamedParameters, tEnv);
    },
    namedParametersSubtypeCheck: function(s, sEnv, t, tEnv) {
      var t1, i, $name,
        names = Object.getOwnPropertyNames(t);
      for (t1 = names.length, i = 0; i < t1; ++i) {
        $name = names[i];
        if (!Object.hasOwnProperty.call(s, $name))
          return false;
        if (!H._isSubtype(t[$name], tEnv, s[$name], sEnv))
          return false;
      }
      return true;
    },
    instantiatedGenericFunctionType: function(genericFunctionRti, parameters) {
      if (genericFunctionRti == null)
        return;
      return H.finishBindInstantiatedFunctionType(genericFunctionRti, {func: 1}, parameters, 0);
    },
    finishBindInstantiatedFunctionType: function(rti, result, parameters, depth) {
      var namedParameters, boundNamed, names, t1, _i, $name;
      if ("v" in rti)
        result.v = rti.v;
      else if ("ret" in rti)
        result.ret = H.bindInstantiatedType(rti.ret, parameters, depth);
      if ("args" in rti)
        result.args = H.bindInstantiatedTypes(rti.args, parameters, depth);
      if ("opt" in rti)
        result.opt = H.bindInstantiatedTypes(rti.opt, parameters, depth);
      if ("named" in rti) {
        namedParameters = rti.named;
        boundNamed = {};
        names = Object.keys(namedParameters);
        for (t1 = names.length, _i = 0; _i < t1; ++_i) {
          $name = names[_i];
          boundNamed[$name] = H.bindInstantiatedType(namedParameters[$name], parameters, depth);
        }
        result.named = boundNamed;
      }
      return result;
    },
    bindInstantiatedType: function(rti, parameters, depth) {
      var result, bounds;
      if (rti == null)
        return rti;
      if (rti === -1)
        return rti;
      if (typeof rti == "function")
        return rti;
      if (typeof rti === "number") {
        if (rti < depth)
          return rti;
        return parameters[rti - depth];
      }
      if (typeof rti === "object" && rti !== null && rti.constructor === Array)
        return H.bindInstantiatedTypes(rti, parameters, depth);
      if ('func' in rti) {
        result = {func: 1};
        if ("bounds" in rti) {
          bounds = rti.bounds;
          depth += bounds.length;
          result.bounds = H.bindInstantiatedTypes(bounds, parameters, depth);
        }
        return H.finishBindInstantiatedFunctionType(rti, result, parameters, depth);
      }
      throw H.wrapException(P.ArgumentError$("Unknown RTI format in bindInstantiatedType."));
    },
    bindInstantiatedTypes: function(rti, parameters, depth) {
      var t1, i,
        array = rti.slice();
      for (t1 = array.length, i = 0; i < t1; ++i)
        array[i] = H.bindInstantiatedType(array[i], parameters, depth);
      return array;
    },
    defineProperty: function(obj, property, value) {
      Object.defineProperty(obj, property, {value: value, enumerable: false, writable: true, configurable: true});
    },
    lookupAndCacheInterceptor: function(obj) {
      var interceptor, interceptorClass, mark, t1,
        tag = $.getTagFunction.call$1(obj),
        record = $.dispatchRecordsForInstanceTags[tag];
      if (record != null) {
        Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
        return record.i;
      }
      interceptor = $.interceptorsForUncacheableTags[tag];
      if (interceptor != null)
        return interceptor;
      interceptorClass = init.interceptorsByTag[tag];
      if (interceptorClass == null) {
        tag = $.alternateTagFunction.call$2(obj, tag);
        if (tag != null) {
          record = $.dispatchRecordsForInstanceTags[tag];
          if (record != null) {
            Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
            return record.i;
          }
          interceptor = $.interceptorsForUncacheableTags[tag];
          if (interceptor != null)
            return interceptor;
          interceptorClass = init.interceptorsByTag[tag];
        }
      }
      if (interceptorClass == null)
        return;
      interceptor = interceptorClass.prototype;
      mark = tag[0];
      if (mark === "!") {
        record = H.makeLeafDispatchRecord(interceptor);
        $.dispatchRecordsForInstanceTags[tag] = record;
        Object.defineProperty(obj, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
        return record.i;
      }
      if (mark === "~") {
        $.interceptorsForUncacheableTags[tag] = interceptor;
        return interceptor;
      }
      if (mark === "-") {
        t1 = H.makeLeafDispatchRecord(interceptor);
        Object.defineProperty(Object.getPrototypeOf(obj), init.dispatchPropertyName, {value: t1, enumerable: false, writable: true, configurable: true});
        return t1.i;
      }
      if (mark === "+")
        return H.patchInteriorProto(obj, interceptor);
      if (mark === "*")
        throw H.wrapException(P.UnimplementedError$(tag));
      if (init.leafTags[tag] === true) {
        t1 = H.makeLeafDispatchRecord(interceptor);
        Object.defineProperty(Object.getPrototypeOf(obj), init.dispatchPropertyName, {value: t1, enumerable: false, writable: true, configurable: true});
        return t1.i;
      } else
        return H.patchInteriorProto(obj, interceptor);
    },
    patchInteriorProto: function(obj, interceptor) {
      var proto = Object.getPrototypeOf(obj);
      Object.defineProperty(proto, init.dispatchPropertyName, {value: J.makeDispatchRecord(interceptor, proto, null, null), enumerable: false, writable: true, configurable: true});
      return interceptor;
    },
    makeLeafDispatchRecord: function(interceptor) {
      return J.makeDispatchRecord(interceptor, false, null, !!interceptor.$isJavaScriptIndexingBehavior);
    },
    makeDefaultDispatchRecord: function(tag, interceptorClass, proto) {
      var interceptor = interceptorClass.prototype;
      if (init.leafTags[tag] === true)
        return H.makeLeafDispatchRecord(interceptor);
      else
        return J.makeDispatchRecord(interceptor, proto, null, null);
    },
    initNativeDispatch: function() {
      if (true === $.initNativeDispatchFlag)
        return;
      $.initNativeDispatchFlag = true;
      H.initNativeDispatchContinue();
    },
    initNativeDispatchContinue: function() {
      var map, tags, fun, i, tag, proto, record, interceptorClass;
      $.dispatchRecordsForInstanceTags = Object.create(null);
      $.interceptorsForUncacheableTags = Object.create(null);
      H.initHooks();
      map = init.interceptorsByTag;
      tags = Object.getOwnPropertyNames(map);
      if (typeof window != "undefined") {
        window;
        fun = function() {
        };
        for (i = 0; i < tags.length; ++i) {
          tag = tags[i];
          proto = $.prototypeForTagFunction.call$1(tag);
          if (proto != null) {
            record = H.makeDefaultDispatchRecord(tag, map[tag], proto);
            if (record != null) {
              Object.defineProperty(proto, init.dispatchPropertyName, {value: record, enumerable: false, writable: true, configurable: true});
              fun.prototype = proto;
            }
          }
        }
      }
      for (i = 0; i < tags.length; ++i) {
        tag = tags[i];
        if (/^[A-Za-z_]/.test(tag)) {
          interceptorClass = map[tag];
          map["!" + tag] = interceptorClass;
          map["~" + tag] = interceptorClass;
          map["-" + tag] = interceptorClass;
          map["+" + tag] = interceptorClass;
          map["*" + tag] = interceptorClass;
        }
      }
    },
    initHooks: function() {
      var transformers, i, transformer, getTag, getUnknownTag, prototypeForTag,
        hooks = C.C_JS_CONST0();
      hooks = H.applyHooksTransformer(C.C_JS_CONST1, H.applyHooksTransformer(C.C_JS_CONST2, H.applyHooksTransformer(C.C_JS_CONST3, H.applyHooksTransformer(C.C_JS_CONST3, H.applyHooksTransformer(C.C_JS_CONST4, H.applyHooksTransformer(C.C_JS_CONST5, H.applyHooksTransformer(C.C_JS_CONST6(C.C_JS_CONST), hooks)))))));
      if (typeof dartNativeDispatchHooksTransformer != "undefined") {
        transformers = dartNativeDispatchHooksTransformer;
        if (typeof transformers == "function")
          transformers = [transformers];
        if (transformers.constructor == Array)
          for (i = 0; i < transformers.length; ++i) {
            transformer = transformers[i];
            if (typeof transformer == "function")
              hooks = transformer(hooks) || hooks;
          }
      }
      getTag = hooks.getTag;
      getUnknownTag = hooks.getUnknownTag;
      prototypeForTag = hooks.prototypeForTag;
      $.getTagFunction = new H.initHooks_closure(getTag);
      $.alternateTagFunction = new H.initHooks_closure0(getUnknownTag);
      $.prototypeForTagFunction = new H.initHooks_closure1(prototypeForTag);
    },
    applyHooksTransformer: function(transformer, hooks) {
      return transformer(hooks) || hooks;
    },
    JSSyntaxRegExp_makeNative: function(source, multiLine, caseSensitive, unicode, dotAll, global) {
      var m = multiLine ? "m" : "",
        i = caseSensitive ? "" : "i",
        u = unicode ? "u" : "",
        s = dotAll ? "s" : "",
        g = global ? "g" : "",
        regexp = function(source, modifiers) {
          try {
            return new RegExp(source, modifiers);
          } catch (e) {
            return e;
          }
        }(source, m + i + u + s + g);
      if (regexp instanceof RegExp)
        return regexp;
      throw H.wrapException(P.FormatException$("Illegal RegExp pattern (" + String(regexp) + ")", source, null));
    },
    stringContainsUnchecked: function(receiver, other, startIndex) {
      var t1, t2;
      if (typeof other === "string")
        return receiver.indexOf(other, startIndex) >= 0;
      else {
        t1 = J.getInterceptor$(other);
        if (!!t1.$isJSSyntaxRegExp) {
          t1 = C.JSString_methods.substring$1(receiver, startIndex);
          t2 = other._nativeRegExp;
          return t2.test(t1);
        } else {
          t1 = t1.allMatches$1(other, C.JSString_methods.substring$1(receiver, startIndex));
          return !t1.get$isEmpty(t1);
        }
      }
    },
    escapeReplacement: function(replacement) {
      if (replacement.indexOf("$", 0) >= 0)
        return replacement.replace(/\$/g, "$$$$");
      return replacement;
    },
    stringReplaceFirstRE: function(receiver, regexp, replacement, startIndex) {
      var match = regexp._execGlobal$2(receiver, startIndex);
      if (match == null)
        return receiver;
      return H.stringReplaceRangeUnchecked(receiver, match._match.index, match.get$end(match), replacement);
    },
    quoteStringForRegExp: function(string) {
      if (/[[\]{}()*+?.\\^$|]/.test(string))
        return string.replace(/[[\]{}()*+?.\\^$|]/g, "\\$&");
      return string;
    },
    stringReplaceAllUnchecked: function(receiver, pattern, replacement) {
      var nativeRegexp;
      if (typeof pattern === "string")
        return H.stringReplaceAllUncheckedString(receiver, pattern, replacement);
      if (pattern instanceof H.JSSyntaxRegExp) {
        nativeRegexp = pattern.get$_nativeGlobalVersion();
        nativeRegexp.lastIndex = 0;
        return receiver.replace(nativeRegexp, H.escapeReplacement(replacement));
      }
      if (pattern == null)
        H.throwExpression(H.argumentErrorValue(pattern));
      throw H.wrapException("String.replaceAll(Pattern) UNIMPLEMENTED");
    },
    stringReplaceAllUncheckedString: function(receiver, pattern, replacement) {
      var $length, t1, i, index;
      if (pattern === "") {
        if (receiver === "")
          return replacement;
        $length = receiver.length;
        for (t1 = replacement, i = 0; i < $length; ++i)
          t1 = t1 + receiver[i] + replacement;
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      }
      index = receiver.indexOf(pattern, 0);
      if (index < 0)
        return receiver;
      if (receiver.length < 500 || replacement.indexOf("$", 0) >= 0)
        return receiver.split(pattern).join(replacement);
      return receiver.replace(new RegExp(H.quoteStringForRegExp(pattern), 'g'), H.escapeReplacement(replacement));
    },
    stringReplaceFirstUnchecked: function(receiver, pattern, replacement, startIndex) {
      var index, t1, matches, match;
      if (typeof pattern === "string") {
        index = receiver.indexOf(pattern, startIndex);
        if (index < 0)
          return receiver;
        return H.stringReplaceRangeUnchecked(receiver, index, index + pattern.length, replacement);
      }
      t1 = J.getInterceptor$(pattern);
      if (!!t1.$isJSSyntaxRegExp)
        return startIndex === 0 ? receiver.replace(pattern._nativeRegExp, H.escapeReplacement(replacement)) : H.stringReplaceFirstRE(receiver, pattern, replacement, startIndex);
      if (pattern == null)
        H.throwExpression(H.argumentErrorValue(pattern));
      t1 = t1.allMatches$2(pattern, receiver, startIndex);
      matches = t1.get$iterator(t1);
      if (!matches.moveNext$0())
        return receiver;
      match = matches.get$current(matches);
      return C.JSString_methods.replaceRange$3(receiver, match.get$start(match), match.get$end(match), replacement);
    },
    stringReplaceRangeUnchecked: function(receiver, start, end, replacement) {
      var prefix = receiver.substring(0, start),
        suffix = receiver.substring(end);
      return prefix + H.S(replacement) + suffix;
    },
    ConstantMapView: function ConstantMapView(t0, t1) {
      this._collection$_map = t0;
      this.$ti = t1;
    },
    ConstantMap: function ConstantMap() {
    },
    ConstantStringMap: function ConstantStringMap(t0, t1, t2, t3) {
      var _ = this;
      _.__js_helper$_length = t0;
      _._jsObject = t1;
      _._keys = t2;
      _.$ti = t3;
    },
    ConstantStringMap_values_closure: function ConstantStringMap_values_closure(t0) {
      this.$this = t0;
    },
    ConstantProtoMap: function ConstantProtoMap(t0, t1, t2, t3, t4) {
      var _ = this;
      _._protoValue = t0;
      _.__js_helper$_length = t1;
      _._jsObject = t2;
      _._keys = t3;
      _.$ti = t4;
    },
    _ConstantMapKeyIterable: function _ConstantMapKeyIterable(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    Instantiation: function Instantiation() {
    },
    Instantiation1: function Instantiation1(t0, t1) {
      this._genericClosure = t0;
      this.$ti = t1;
    },
    JSInvocationMirror: function JSInvocationMirror(t0, t1, t2, t3, t4) {
      var _ = this;
      _.__js_helper$_memberName = t0;
      _._kind = t1;
      _._arguments = t2;
      _._namedArgumentNames = t3;
      _._typeArgumentCount = t4;
    },
    Primitives_functionNoSuchMethod_closure: function Primitives_functionNoSuchMethod_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.namedArgumentList = t1;
      this.$arguments = t2;
    },
    TypeErrorDecoder: function TypeErrorDecoder(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._pattern = t0;
      _._arguments = t1;
      _._argumentsExpr = t2;
      _._expr = t3;
      _._method = t4;
      _._receiver = t5;
    },
    NullError: function NullError(t0, t1) {
      this._message = t0;
      this._method = t1;
    },
    JsNoSuchMethodError: function JsNoSuchMethodError(t0, t1, t2) {
      this._message = t0;
      this._method = t1;
      this._receiver = t2;
    },
    UnknownJsTypeError: function UnknownJsTypeError(t0) {
      this._message = t0;
    },
    ExceptionAndStackTrace: function ExceptionAndStackTrace(t0, t1) {
      this.dartException = t0;
      this.stackTrace = t1;
    },
    unwrapException_saveStackTrace: function unwrapException_saveStackTrace(t0) {
      this.ex = t0;
    },
    _StackTrace: function _StackTrace(t0) {
      this._exception = t0;
      this._trace = null;
    },
    Closure: function Closure() {
    },
    TearOffClosure: function TearOffClosure() {
    },
    StaticClosure: function StaticClosure() {
    },
    BoundClosure: function BoundClosure(t0, t1, t2, t3) {
      var _ = this;
      _._self = t0;
      _._target = t1;
      _._receiver = t2;
      _.__js_helper$_name = t3;
    },
    CastErrorImplementation: function CastErrorImplementation(t0) {
      this.message = t0;
    },
    RuntimeError: function RuntimeError(t0) {
      this.message = t0;
    },
    TypeImpl: function TypeImpl(t0) {
      this._rti = t0;
      this._hashCode = this.__typeName = null;
    },
    JsLinkedHashMap: function JsLinkedHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _._last = _._first = _._rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t0;
    },
    JsLinkedHashMap_values_closure: function JsLinkedHashMap_values_closure(t0) {
      this.$this = t0;
    },
    JsLinkedHashMap_addAll_closure: function JsLinkedHashMap_addAll_closure(t0) {
      this.$this = t0;
    },
    LinkedHashMapCell: function LinkedHashMapCell(t0, t1) {
      var _ = this;
      _.hashMapCellKey = t0;
      _.hashMapCellValue = t1;
      _._previous = _._next = null;
    },
    LinkedHashMapKeyIterable: function LinkedHashMapKeyIterable(t0, t1) {
      this._map = t0;
      this.$ti = t1;
    },
    LinkedHashMapKeyIterator: function LinkedHashMapKeyIterator(t0, t1) {
      var _ = this;
      _._map = t0;
      _._modifications = t1;
      _.__js_helper$_current = _._cell = null;
    },
    initHooks_closure: function initHooks_closure(t0) {
      this.getTag = t0;
    },
    initHooks_closure0: function initHooks_closure0(t0) {
      this.getUnknownTag = t0;
    },
    initHooks_closure1: function initHooks_closure1(t0) {
      this.prototypeForTag = t0;
    },
    JSSyntaxRegExp: function JSSyntaxRegExp(t0, t1) {
      var _ = this;
      _.pattern = t0;
      _._nativeRegExp = t1;
      _._nativeAnchoredRegExp = _._nativeGlobalRegExp = null;
    },
    _MatchImplementation: function _MatchImplementation(t0) {
      this._match = t0;
    },
    _AllMatchesIterable: function _AllMatchesIterable(t0, t1, t2) {
      this._re = t0;
      this._string = t1;
      this.__js_helper$_start = t2;
    },
    _AllMatchesIterator: function _AllMatchesIterator(t0, t1, t2) {
      var _ = this;
      _._regExp = t0;
      _._string = t1;
      _._nextIndex = t2;
      _.__js_helper$_current = null;
    },
    StringMatch: function StringMatch(t0, t1) {
      this.start = t0;
      this.pattern = t1;
    },
    _StringAllMatchesIterable: function _StringAllMatchesIterable(t0, t1, t2) {
      this._input = t0;
      this._pattern = t1;
      this.__js_helper$_index = t2;
    },
    _StringAllMatchesIterator: function _StringAllMatchesIterator(t0, t1, t2) {
      var _ = this;
      _._input = t0;
      _._pattern = t1;
      _.__js_helper$_index = t2;
      _.__js_helper$_current = null;
    },
    _ensureNativeList: function(list) {
      return list;
    },
    NativeInt8List__create1: function(arg) {
      return new Int8Array(arg);
    },
    NativeUint8List_NativeUint8List$view: function(buffer, offsetInBytes, $length) {
      var t1 = new Uint8Array(buffer, offsetInBytes, $length);
      return t1;
    },
    _checkValidIndex: function(index, list, $length) {
      if (index >>> 0 !== index || index >= $length)
        throw H.wrapException(H.diagnoseIndexError(list, index));
    },
    _checkValidRange: function(start, end, $length) {
      var t1;
      if (!(start >>> 0 !== start))
        if (end == null)
          t1 = start > $length;
        else
          t1 = end >>> 0 !== end || start > end || end > $length;
      else
        t1 = true;
      if (t1)
        throw H.wrapException(H.diagnoseRangeError(start, end, $length));
      if (end == null)
        return $length;
      return end;
    },
    NativeTypedData: function NativeTypedData() {
    },
    NativeTypedArray: function NativeTypedArray() {
    },
    NativeTypedArrayOfDouble: function NativeTypedArrayOfDouble() {
    },
    NativeTypedArrayOfInt: function NativeTypedArrayOfInt() {
    },
    NativeFloat32List: function NativeFloat32List() {
    },
    NativeFloat64List: function NativeFloat64List() {
    },
    NativeInt16List: function NativeInt16List() {
    },
    NativeInt32List: function NativeInt32List() {
    },
    NativeInt8List: function NativeInt8List() {
    },
    NativeUint16List: function NativeUint16List() {
    },
    NativeUint32List: function NativeUint32List() {
    },
    NativeUint8ClampedList: function NativeUint8ClampedList() {
    },
    NativeUint8List: function NativeUint8List() {
    },
    _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin: function _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin() {
    },
    _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin: function _NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin() {
    },
    _NativeTypedArrayOfInt_NativeTypedArray_ListMixin: function _NativeTypedArrayOfInt_NativeTypedArray_ListMixin() {
    },
    _NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin: function _NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin() {
    },
    extractKeys: function(victim) {
      return J.JSArray_JSArray$markFixed(victim ? Object.keys(victim) : [], null);
    },
    unmangleGlobalNameIfPreservedAnyways: function($name) {
      return init.mangledGlobalNames[$name];
    },
    printString: function(string) {
      if (typeof dartPrint == "function") {
        dartPrint(string);
        return;
      }
      if (typeof console == "object" && typeof console.log != "undefined") {
        console.log(string);
        return;
      }
      if (typeof window == "object")
        return;
      if (typeof print == "function") {
        print(string);
        return;
      }
      throw "Unable to print message: " + String(string);
    }
  },
  J = {
    makeDispatchRecord: function(interceptor, proto, extension, indexability) {
      return {i: interceptor, p: proto, e: extension, x: indexability};
    },
    getNativeInterceptor: function(object) {
      var proto, objectProto, $constructor, interceptor,
        record = object[init.dispatchPropertyName];
      if (record == null)
        if ($.initNativeDispatchFlag == null) {
          H.initNativeDispatch();
          record = object[init.dispatchPropertyName];
        }
      if (record != null) {
        proto = record.p;
        if (false === proto)
          return record.i;
        if (true === proto)
          return object;
        objectProto = Object.getPrototypeOf(object);
        if (proto === objectProto)
          return record.i;
        if (record.e === objectProto)
          throw H.wrapException(P.UnimplementedError$("Return interceptor for " + H.S(proto(object, record))));
      }
      $constructor = object.constructor;
      interceptor = $constructor == null ? null : $constructor[$.$get$JS_INTEROP_INTERCEPTOR_TAG()];
      if (interceptor != null)
        return interceptor;
      interceptor = H.lookupAndCacheInterceptor(object);
      if (interceptor != null)
        return interceptor;
      if (typeof object == "function")
        return C.JavaScriptFunction_methods;
      proto = Object.getPrototypeOf(object);
      if (proto == null)
        return C.PlainJavaScriptObject_methods;
      if (proto === Object.prototype)
        return C.PlainJavaScriptObject_methods;
      if (typeof $constructor == "function") {
        Object.defineProperty($constructor, $.$get$JS_INTEROP_INTERCEPTOR_TAG(), {value: C.UnknownJavaScriptObject_methods, enumerable: false, writable: true, configurable: true});
        return C.UnknownJavaScriptObject_methods;
      }
      return C.UnknownJavaScriptObject_methods;
    },
    JSArray_JSArray$fixed: function($length, $E) {
      if (typeof $length !== "number" || Math.floor($length) !== $length)
        throw H.wrapException(P.ArgumentError$value($length, "length", "is not an integer"));
      if ($length < 0 || $length > 4294967295)
        throw H.wrapException(P.RangeError$range($length, 0, 4294967295, "length", null));
      return J.JSArray_JSArray$markFixed(new Array($length), $E);
    },
    JSArray_JSArray$markFixed: function(allocation, $E) {
      return J.JSArray_markFixedList(H.setRuntimeTypeInfo(allocation, [$E]));
    },
    JSArray_markFixedList: function(list) {
      list.fixed$length = Array;
      return list;
    },
    JSArray_markUnmodifiableList: function(list) {
      list.fixed$length = Array;
      list.immutable$list = Array;
      return list;
    },
    JSArray__compareAny: function(a, b) {
      return J.compareTo$1$ns(a, b);
    },
    JSString__isWhitespace: function(codeUnit) {
      if (codeUnit < 256)
        switch (codeUnit) {
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
          case 32:
          case 133:
          case 160:
            return true;
          default:
            return false;
        }
      switch (codeUnit) {
        case 5760:
        case 8192:
        case 8193:
        case 8194:
        case 8195:
        case 8196:
        case 8197:
        case 8198:
        case 8199:
        case 8200:
        case 8201:
        case 8202:
        case 8232:
        case 8233:
        case 8239:
        case 8287:
        case 12288:
        case 65279:
          return true;
        default:
          return false;
      }
    },
    JSString__skipLeadingWhitespace: function(string, index) {
      var t1, codeUnit;
      for (t1 = string.length; index < t1;) {
        codeUnit = C.JSString_methods._codeUnitAt$1(string, index);
        if (codeUnit !== 32 && codeUnit !== 13 && !J.JSString__isWhitespace(codeUnit))
          break;
        ++index;
      }
      return index;
    },
    JSString__skipTrailingWhitespace: function(string, index) {
      var index0, codeUnit;
      for (; index > 0; index = index0) {
        index0 = index - 1;
        codeUnit = C.JSString_methods.codeUnitAt$1(string, index0);
        if (codeUnit !== 32 && codeUnit !== 13 && !J.JSString__isWhitespace(codeUnit))
          break;
      }
      return index;
    },
    getInterceptor$: function(receiver) {
      if (typeof receiver == "number") {
        if (Math.floor(receiver) == receiver)
          return J.JSInt.prototype;
        return J.JSDouble.prototype;
      }
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return J.JSNull.prototype;
      if (typeof receiver == "boolean")
        return J.JSBool.prototype;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$ansx: function(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$asx: function(receiver) {
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$ax: function(receiver) {
      if (receiver == null)
        return receiver;
      if (receiver.constructor == Array)
        return J.JSArray.prototype;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    getInterceptor$n: function(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$ns: function(receiver) {
      if (typeof receiver == "number")
        return J.JSNumber.prototype;
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$s: function(receiver) {
      if (typeof receiver == "string")
        return J.JSString.prototype;
      if (receiver == null)
        return receiver;
      if (!(receiver instanceof P.Object))
        return J.UnknownJavaScriptObject.prototype;
      return receiver;
    },
    getInterceptor$x: function(receiver) {
      if (receiver == null)
        return receiver;
      if (typeof receiver != "object") {
        if (typeof receiver == "function")
          return J.JavaScriptFunction.prototype;
        return receiver;
      }
      if (receiver instanceof P.Object)
        return receiver;
      return J.getNativeInterceptor(receiver);
    },
    set$context$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$context(receiver, value);
    },
    set$dartValue$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$dartValue(receiver, value);
    },
    set$info$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$info(receiver, value);
    },
    set$length$asx: function(receiver, value) {
      return J.getInterceptor$asx(receiver).set$length(receiver, value);
    },
    set$render$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$render(receiver, value);
    },
    set$renderSync$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$renderSync(receiver, value);
    },
    set$run_$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$run_(receiver, value);
    },
    set$types$x: function(receiver, value) {
      return J.getInterceptor$x(receiver).set$types(receiver, value);
    },
    get$code$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$code(receiver);
    },
    get$current$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$current(receiver);
    },
    get$dartValue$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$dartValue(receiver);
    },
    get$end$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$end(receiver);
    },
    get$env$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$env(receiver);
    },
    get$fiber$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$fiber(receiver);
    },
    get$file$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$file(receiver);
    },
    get$first$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).get$first(receiver);
    },
    get$functions$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$functions(receiver);
    },
    get$hashCode$: function(receiver) {
      return J.getInterceptor$(receiver).get$hashCode(receiver);
    },
    get$isEmpty$asx: function(receiver) {
      return J.getInterceptor$asx(receiver).get$isEmpty(receiver);
    },
    get$isNotEmpty$asx: function(receiver) {
      return J.getInterceptor$asx(receiver).get$isNotEmpty(receiver);
    },
    get$isTTY$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$isTTY(receiver);
    },
    get$iterator$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).get$iterator(receiver);
    },
    get$last$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).get$last(receiver);
    },
    get$length$asx: function(receiver) {
      return J.getInterceptor$asx(receiver).get$length(receiver);
    },
    get$message$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$message(receiver);
    },
    get$mtime$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$mtime(receiver);
    },
    get$options$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$options(receiver);
    },
    get$path$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$path(receiver);
    },
    get$platform$x: function(receiver) {
      return J.getInterceptor$x(receiver).get$platform(receiver);
    },
    get$reversed$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).get$reversed(receiver);
    },
    get$single$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).get$single(receiver);
    },
    $add$ansx: function(receiver, a0) {
      if (typeof receiver == "number" && typeof a0 == "number")
        return receiver + a0;
      return J.getInterceptor$ansx(receiver).$add(receiver, a0);
    },
    $eq$: function(receiver, a0) {
      if (receiver == null)
        return a0 == null;
      if (typeof receiver != "object")
        return a0 != null && receiver === a0;
      return J.getInterceptor$(receiver).$eq(receiver, a0);
    },
    $index$asx: function(receiver, a0) {
      if (typeof a0 === "number")
        if (receiver.constructor == Array || typeof receiver == "string" || H.isJsIndexable(receiver, receiver[init.dispatchPropertyName]))
          if (a0 >>> 0 === a0 && a0 < receiver.length)
            return receiver[a0];
      return J.getInterceptor$asx(receiver).$index(receiver, a0);
    },
    $indexSet$ax: function(receiver, a0, a1) {
      if (typeof a0 === "number")
        if ((receiver.constructor == Array || H.isJsIndexable(receiver, receiver[init.dispatchPropertyName])) && !receiver.immutable$list && a0 >>> 0 === a0 && a0 < receiver.length)
          return receiver[a0] = a1;
      return J.getInterceptor$ax(receiver).$indexSet(receiver, a0, a1);
    },
    _codeUnitAt$1$s: function(receiver, a0) {
      return J.getInterceptor$s(receiver)._codeUnitAt$1(receiver, a0);
    },
    add$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).add$1(receiver, a0);
    },
    addAll$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).addAll$1(receiver, a0);
    },
    any$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).any$1(receiver, a0);
    },
    apply$2$x: function(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).apply$2(receiver, a0, a1);
    },
    cast$1$0$ax: function(receiver, $T1) {
      return J.getInterceptor$ax(receiver).cast$1$0(receiver, $T1);
    },
    ceil$0$n: function(receiver) {
      return J.getInterceptor$n(receiver).ceil$0(receiver);
    },
    clamp$2$n: function(receiver, a0, a1) {
      return J.getInterceptor$n(receiver).clamp$2(receiver, a0, a1);
    },
    close$0$x: function(receiver) {
      return J.getInterceptor$x(receiver).close$0(receiver);
    },
    codeUnitAt$1$s: function(receiver, a0) {
      return J.getInterceptor$s(receiver).codeUnitAt$1(receiver, a0);
    },
    compareTo$1$ns: function(receiver, a0) {
      return J.getInterceptor$ns(receiver).compareTo$1(receiver, a0);
    },
    contains$1$asx: function(receiver, a0) {
      return J.getInterceptor$asx(receiver).contains$1(receiver, a0);
    },
    createInterface$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).createInterface$1(receiver, a0);
    },
    elementAt$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).elementAt$1(receiver, a0);
    },
    endsWith$1$s: function(receiver, a0) {
      return J.getInterceptor$s(receiver).endsWith$1(receiver, a0);
    },
    every$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).every$1(receiver, a0);
    },
    existsSync$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).existsSync$1(receiver, a0);
    },
    expand$1$1$ax: function(receiver, a0, $T1) {
      return J.getInterceptor$ax(receiver).expand$1$1(receiver, a0, $T1);
    },
    fillRange$3$ax: function(receiver, a0, a1, a2) {
      return J.getInterceptor$ax(receiver).fillRange$3(receiver, a0, a1, a2);
    },
    floor$0$n: function(receiver) {
      return J.getInterceptor$n(receiver).floor$0(receiver);
    },
    fold$2$ax: function(receiver, a0, a1) {
      return J.getInterceptor$ax(receiver).fold$2(receiver, a0, a1);
    },
    getTime$0$x: function(receiver) {
      return J.getInterceptor$x(receiver).getTime$0(receiver);
    },
    indexOf$1$asx: function(receiver, a0) {
      return J.getInterceptor$asx(receiver).indexOf$1(receiver, a0);
    },
    isDirectory$0$x: function(receiver) {
      return J.getInterceptor$x(receiver).isDirectory$0(receiver);
    },
    isFile$0$x: function(receiver) {
      return J.getInterceptor$x(receiver).isFile$0(receiver);
    },
    join$0$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).join$0(receiver);
    },
    join$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).join$1(receiver, a0);
    },
    map$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).map$1(receiver, a0);
    },
    map$1$1$ax: function(receiver, a0, $T1) {
      return J.getInterceptor$ax(receiver).map$1$1(receiver, a0, $T1);
    },
    matchAsPrefix$2$s: function(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).matchAsPrefix$2(receiver, a0, a1);
    },
    mkdirSync$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).mkdirSync$1(receiver, a0);
    },
    noSuchMethod$1$: function(receiver, a0) {
      return J.getInterceptor$(receiver).noSuchMethod$1(receiver, a0);
    },
    on$2$x: function(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).on$2(receiver, a0, a1);
    },
    padRight$1$s: function(receiver, a0) {
      return J.getInterceptor$s(receiver).padRight$1(receiver, a0);
    },
    readFileSync$2$x: function(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).readFileSync$2(receiver, a0, a1);
    },
    readdirSync$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).readdirSync$1(receiver, a0);
    },
    remove$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).remove$1(receiver, a0);
    },
    replaceRange$3$asx: function(receiver, a0, a1, a2) {
      return J.getInterceptor$asx(receiver).replaceRange$3(receiver, a0, a1, a2);
    },
    round$0$n: function(receiver) {
      return J.getInterceptor$n(receiver).round$0(receiver);
    },
    run$0$x: function(receiver) {
      return J.getInterceptor$x(receiver).run$0(receiver);
    },
    run$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).run$1(receiver, a0);
    },
    setPrompt$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).setPrompt$1(receiver, a0);
    },
    setRange$4$ax: function(receiver, a0, a1, a2, a3) {
      return J.getInterceptor$ax(receiver).setRange$4(receiver, a0, a1, a2, a3);
    },
    skip$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).skip$1(receiver, a0);
    },
    startsWith$1$s: function(receiver, a0) {
      return J.getInterceptor$s(receiver).startsWith$1(receiver, a0);
    },
    startsWith$2$s: function(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).startsWith$2(receiver, a0, a1);
    },
    statSync$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).statSync$1(receiver, a0);
    },
    substring$1$s: function(receiver, a0) {
      return J.getInterceptor$s(receiver).substring$1(receiver, a0);
    },
    substring$2$s: function(receiver, a0, a1) {
      return J.getInterceptor$s(receiver).substring$2(receiver, a0, a1);
    },
    take$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).take$1(receiver, a0);
    },
    toList$0$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).toList$0(receiver);
    },
    toList$1$growable$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).toList$1$growable(receiver, a0);
    },
    toRadixString$1$n: function(receiver, a0) {
      return J.getInterceptor$n(receiver).toRadixString$1(receiver, a0);
    },
    toSet$0$ax: function(receiver) {
      return J.getInterceptor$ax(receiver).toSet$0(receiver);
    },
    toString$0$: function(receiver) {
      return J.getInterceptor$(receiver).toString$0(receiver);
    },
    toString$1$color$: function(receiver, a0) {
      return J.getInterceptor$(receiver).toString$1$color(receiver, a0);
    },
    trim$0$s: function(receiver) {
      return J.getInterceptor$s(receiver).trim$0(receiver);
    },
    unlinkSync$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).unlinkSync$1(receiver, a0);
    },
    watch$2$x: function(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).watch$2(receiver, a0, a1);
    },
    where$1$ax: function(receiver, a0) {
      return J.getInterceptor$ax(receiver).where$1(receiver, a0);
    },
    write$1$x: function(receiver, a0) {
      return J.getInterceptor$x(receiver).write$1(receiver, a0);
    },
    writeFileSync$2$x: function(receiver, a0, a1) {
      return J.getInterceptor$x(receiver).writeFileSync$2(receiver, a0, a1);
    },
    yield$0$x: function(receiver) {
      return J.getInterceptor$x(receiver).yield$0(receiver);
    },
    Interceptor: function Interceptor() {
    },
    JSBool: function JSBool() {
    },
    JSNull: function JSNull() {
    },
    JavaScriptObject: function JavaScriptObject() {
    },
    PlainJavaScriptObject: function PlainJavaScriptObject() {
    },
    UnknownJavaScriptObject: function UnknownJavaScriptObject() {
    },
    JavaScriptFunction: function JavaScriptFunction() {
    },
    JSArray: function JSArray(t0) {
      this.$ti = t0;
    },
    JSUnmodifiableArray: function JSUnmodifiableArray(t0) {
      this.$ti = t0;
    },
    ArrayIterator: function ArrayIterator(t0, t1) {
      var _ = this;
      _._iterable = t0;
      _._length = t1;
      _._index = 0;
      _._current = null;
    },
    JSNumber: function JSNumber() {
    },
    JSInt: function JSInt() {
    },
    JSDouble: function JSDouble() {
    },
    JSString: function JSString() {
    }
  },
  P = {
    _AsyncRun__initializeScheduleImmediate: function() {
      var div, span, t1 = {};
      if (self.scheduleImmediate != null)
        return P.async__AsyncRun__scheduleImmediateJsOverride$closure();
      if (self.MutationObserver != null && self.document != null) {
        div = self.document.createElement("div");
        span = self.document.createElement("span");
        t1.storedCallback = null;
        new self.MutationObserver(H.convertDartClosureToJS(new P._AsyncRun__initializeScheduleImmediate_internalCallback(t1), 1)).observe(div, {childList: true});
        return new P._AsyncRun__initializeScheduleImmediate_closure(t1, div, span);
      } else if (self.setImmediate != null)
        return P.async__AsyncRun__scheduleImmediateWithSetImmediate$closure();
      return P.async__AsyncRun__scheduleImmediateWithTimer$closure();
    },
    _AsyncRun__scheduleImmediateJsOverride: function(callback) {
      self.scheduleImmediate(H.convertDartClosureToJS(new P._AsyncRun__scheduleImmediateJsOverride_internalCallback(callback), 0));
    },
    _AsyncRun__scheduleImmediateWithSetImmediate: function(callback) {
      self.setImmediate(H.convertDartClosureToJS(new P._AsyncRun__scheduleImmediateWithSetImmediate_internalCallback(callback), 0));
    },
    _AsyncRun__scheduleImmediateWithTimer: function(callback) {
      P.Timer__createTimer(C.Duration_0, callback);
    },
    Timer__createTimer: function(duration, callback) {
      var milliseconds = C.JSInt_methods._tdivFast$1(duration._duration, 1000);
      return P._TimerImpl$(milliseconds < 0 ? 0 : milliseconds, callback);
    },
    _TimerImpl$: function(milliseconds, callback) {
      var t1 = new P._TimerImpl(true);
      t1._TimerImpl$2(milliseconds, callback);
      return t1;
    },
    _TimerImpl$periodic: function(milliseconds, callback) {
      var t1 = new P._TimerImpl(false);
      t1._TimerImpl$periodic$2(milliseconds, callback);
      return t1;
    },
    _makeAsyncAwaitCompleter: function($T) {
      return new P._AsyncAwaitCompleter(new P._Future($.Zone__current, [$T]), [$T]);
    },
    _asyncStartSync: function(bodyFunction, completer) {
      bodyFunction.call$2(0, null);
      completer.isSync = true;
      return completer._future;
    },
    _asyncAwait: function(object, bodyFunction) {
      P._awaitOnObject(object, bodyFunction);
    },
    _asyncReturn: function(object, completer) {
      completer.complete$1(object);
    },
    _asyncRethrow: function(object, completer) {
      completer.completeError$2(H.unwrapException(object), H.getTraceFromException(object));
    },
    _awaitOnObject: function(object, bodyFunction) {
      var future, _null = null,
        thenCallback = new P._awaitOnObject_closure(bodyFunction),
        errorCallback = new P._awaitOnObject_closure0(bodyFunction),
        t1 = J.getInterceptor$(object);
      if (!!t1.$is_Future)
        object._thenAwait$1$2(thenCallback, errorCallback, _null);
      else if (!!t1.$isFuture)
        object.then$1$2$onError(thenCallback, errorCallback, _null);
      else {
        future = new P._Future($.Zone__current, [null]);
        future._async$_state = 4;
        future._resultOrListeners = object;
        future._thenAwait$1$2(thenCallback, _null, _null);
      }
    },
    _wrapJsFunctionForAsync: function($function) {
      var $protected = function(fn, ERROR) {
        return function(errorCode, result) {
          while (true)
            try {
              fn(errorCode, result);
              break;
            } catch (error) {
              result = error;
              errorCode = ERROR;
            }
        };
      }($function, 1);
      return $.Zone__current.registerBinaryCallback$1(new P._wrapJsFunctionForAsync_closure($protected));
    },
    _asyncStarHelper: function(object, bodyFunctionOrErrorCode, controller) {
      var t1, t2, stream;
      if (bodyFunctionOrErrorCode === 0) {
        t1 = controller.cancelationFuture;
        if (t1 != null)
          t1._completeWithValue$1(null);
        else
          controller.controller.close$0(0);
        return;
      } else if (bodyFunctionOrErrorCode === 1) {
        t1 = controller.cancelationFuture;
        if (t1 != null)
          t1._completeError$2(H.unwrapException(object), H.getTraceFromException(object));
        else {
          t1 = H.unwrapException(object);
          t2 = H.getTraceFromException(object);
          controller.controller.addError$2(t1, t2);
          controller.controller.close$0(0);
        }
        return;
      }
      if (object instanceof P._IterationMarker) {
        if (controller.cancelationFuture != null) {
          bodyFunctionOrErrorCode.call$2(2, null);
          return;
        }
        t1 = object.state;
        if (t1 === 0) {
          t1 = object.value;
          controller.controller.add$1(0, t1);
          P.scheduleMicrotask(new P._asyncStarHelper_closure(controller, bodyFunctionOrErrorCode));
          return;
        } else if (t1 === 1) {
          stream = object.value;
          controller.controller.addStream$2$cancelOnError(stream, false).then$1(new P._asyncStarHelper_closure0(controller, bodyFunctionOrErrorCode));
          return;
        }
      }
      P._awaitOnObject(object, bodyFunctionOrErrorCode);
    },
    _streamOfController: function(controller) {
      var t1 = controller.controller;
      t1.toString;
      return new P._ControllerStream(t1, [H.getTypeArgumentByIndex(t1, 0)]);
    },
    _AsyncStarStreamController$: function(body, $T) {
      var t1 = new P._AsyncStarStreamController([$T]);
      t1._AsyncStarStreamController$1(body, $T);
      return t1;
    },
    _makeAsyncStarStreamController: function(body, $T) {
      return P._AsyncStarStreamController$(body, $T);
    },
    _IterationMarker_yieldStar: function(values) {
      return new P._IterationMarker(values, 1);
    },
    _IterationMarker_endOfIteration: function() {
      return C._IterationMarker_null_2;
    },
    _IterationMarker_yieldSingle: function(value) {
      return new P._IterationMarker(value, 0);
    },
    _IterationMarker_uncaughtError: function(error) {
      return new P._IterationMarker(error, 3);
    },
    _makeSyncStarIterable: function(body, $T) {
      return new P._SyncStarIterable(body, [$T]);
    },
    Future_Future$error: function(error, stackTrace, $T) {
      var t1, replacement;
      if (error == null)
        error = new P.NullThrownError();
      t1 = $.Zone__current;
      if (t1 !== C.C__RootZone) {
        replacement = t1.errorCallback$2(error, stackTrace);
        if (replacement != null) {
          error = replacement.error;
          if (error == null)
            error = new P.NullThrownError();
          stackTrace = replacement.stackTrace;
        }
      }
      t1 = new P._Future($.Zone__current, [$T]);
      t1._asyncCompleteError$2(error, stackTrace);
      return t1;
    },
    Future_wait: function(futures, $T) {
      var handleError, future, pos, e, st, t3, t4, exception, _box_0 = {}, cleanUp = null,
        eagerError = false,
        t1 = [P.List, $T],
        t2 = [t1],
        result = new P._Future($.Zone__current, t2);
      _box_0.values = null;
      _box_0.remaining = 0;
      _box_0.stackTrace = _box_0.error = null;
      handleError = new P.Future_wait_handleError(_box_0, cleanUp, eagerError, result);
      try {
        for (t3 = J.get$iterator$ax(futures), t4 = P.Null; t3.moveNext$0();) {
          future = t3.get$current(t3);
          pos = _box_0.remaining;
          future.then$1$2$onError(new P.Future_wait_closure(_box_0, pos, result, cleanUp, eagerError, $T), handleError, t4);
          ++_box_0.remaining;
        }
        t3 = _box_0.remaining;
        if (t3 === 0) {
          t2 = new P._Future($.Zone__current, t2);
          t2._asyncComplete$1(C.List_empty15);
          return t2;
        }
        t2 = new Array(t3);
        t2.fixed$length = Array;
        _box_0.values = H.setRuntimeTypeInfo(t2, [$T]);
      } catch (exception) {
        e = H.unwrapException(exception);
        st = H.getTraceFromException(exception);
        if (_box_0.remaining === 0 || eagerError)
          return P.Future_Future$error(e, st, t1);
        else {
          _box_0.error = e;
          _box_0.stackTrace = st;
        }
      }
      return result;
    },
    _Future$zoneValue: function(value, _zone, $T) {
      var t1 = new P._Future(_zone, [$T]);
      t1._async$_state = 4;
      t1._resultOrListeners = value;
      return t1;
    },
    _Future__chainForeignFuture: function(source, target) {
      var e, s, exception;
      target._async$_state = 1;
      try {
        source.then$1$2$onError(new P._Future__chainForeignFuture_closure(target), new P._Future__chainForeignFuture_closure0(target), P.Null);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        P.scheduleMicrotask(new P._Future__chainForeignFuture_closure1(target, e, s));
      }
    },
    _Future__chainCoreFuture: function(source, target) {
      var t1, listeners;
      for (; t1 = source._async$_state, t1 === 2;)
        source = source._resultOrListeners;
      if (t1 >= 4) {
        listeners = target._removeListeners$0();
        target._async$_state = source._async$_state;
        target._resultOrListeners = source._resultOrListeners;
        P._Future__propagateToListeners(target, listeners);
      } else {
        listeners = target._resultOrListeners;
        target._async$_state = 2;
        target._resultOrListeners = source;
        source._prependListeners$1(listeners);
      }
    },
    _Future__propagateToListeners: function(source, listeners) {
      var _box_0, hasError, t2, listeners0, sourceResult, t3, zone, oldZone, current, result, _box_1 = {},
        t1 = _box_1.source = source;
      for (; true;) {
        _box_0 = {};
        hasError = t1._async$_state === 8;
        if (listeners == null) {
          if (hasError) {
            t2 = t1._resultOrListeners;
            t1._zone.handleUncaughtError$2(t2.error, t2.stackTrace);
          }
          return;
        }
        for (; listeners0 = listeners._nextListener, listeners0 != null; listeners = listeners0) {
          listeners._nextListener = null;
          P._Future__propagateToListeners(_box_1.source, listeners);
        }
        t1 = _box_1.source;
        sourceResult = t1._resultOrListeners;
        _box_0.listenerHasError = hasError;
        _box_0.listenerValueOrError = sourceResult;
        t2 = !hasError;
        if (t2) {
          t3 = listeners.state;
          t3 = (t3 & 1) !== 0 || (t3 & 15) === 8;
        } else
          t3 = true;
        if (t3) {
          t3 = listeners.result;
          zone = t3._zone;
          if (hasError) {
            t1 = t1._zone;
            t1.toString;
            t1 = !(t1 == zone || t1.get$errorZone() === zone.get$errorZone());
          } else
            t1 = false;
          if (t1) {
            t1 = _box_1.source;
            t2 = t1._resultOrListeners;
            t1._zone.handleUncaughtError$2(t2.error, t2.stackTrace);
            return;
          }
          oldZone = $.Zone__current;
          if (oldZone != zone)
            $.Zone__current = zone;
          else
            oldZone = null;
          t1 = listeners.state;
          if ((t1 & 15) === 8)
            new P._Future__propagateToListeners_handleWhenCompleteCallback(_box_1, _box_0, listeners, hasError).call$0();
          else if (t2) {
            if ((t1 & 1) !== 0)
              new P._Future__propagateToListeners_handleValueCallback(_box_0, listeners, sourceResult).call$0();
          } else if ((t1 & 2) !== 0)
            new P._Future__propagateToListeners_handleError(_box_1, _box_0, listeners).call$0();
          if (oldZone != null)
            $.Zone__current = oldZone;
          t1 = _box_0.listenerValueOrError;
          if (!!J.getInterceptor$(t1).$isFuture) {
            if (t1._async$_state >= 4) {
              current = t3._resultOrListeners;
              t3._resultOrListeners = null;
              listeners = t3._reverseListeners$1(current);
              t3._async$_state = t1._async$_state;
              t3._resultOrListeners = t1._resultOrListeners;
              _box_1.source = t1;
              continue;
            } else
              P._Future__chainCoreFuture(t1, t3);
            return;
          }
        }
        result = listeners.result;
        current = result._resultOrListeners;
        result._resultOrListeners = null;
        listeners = result._reverseListeners$1(current);
        t1 = _box_0.listenerHasError;
        t2 = _box_0.listenerValueOrError;
        if (!t1) {
          result._async$_state = 4;
          result._resultOrListeners = t2;
        } else {
          result._async$_state = 8;
          result._resultOrListeners = t2;
        }
        _box_1.source = result;
        t1 = result;
      }
    },
    _registerErrorHandler: function(errorHandler, zone) {
      if (H.functionTypeTest(errorHandler, {func: 1, args: [P.Object, P.StackTrace]}))
        return zone.registerBinaryCallback$1(errorHandler);
      if (H.functionTypeTest(errorHandler, {func: 1, args: [P.Object]}))
        return zone.registerUnaryCallback$1(errorHandler);
      throw H.wrapException(P.ArgumentError$value(errorHandler, "onError", "Error handler must accept one Object or one Object and a StackTrace as arguments, and return a a valid result"));
    },
    _microtaskLoop: function() {
      var t1, t2;
      for (; t1 = $._nextCallback, t1 != null;) {
        $._lastPriorityCallback = null;
        t2 = t1.next;
        $._nextCallback = t2;
        if (t2 == null)
          $._lastCallback = null;
        t1.callback.call$0();
      }
    },
    _startMicrotaskLoop: function() {
      $._isInCallbackLoop = true;
      try {
        P._microtaskLoop();
      } finally {
        $._lastPriorityCallback = null;
        $._isInCallbackLoop = false;
        if ($._nextCallback != null)
          $.$get$_AsyncRun__scheduleImmediateClosure().call$1(P.async___startMicrotaskLoop$closure());
      }
    },
    _scheduleAsyncCallback: function(callback) {
      var newEntry = new P._AsyncCallbackEntry(callback);
      if ($._nextCallback == null) {
        $._nextCallback = $._lastCallback = newEntry;
        if (!$._isInCallbackLoop)
          $.$get$_AsyncRun__scheduleImmediateClosure().call$1(P.async___startMicrotaskLoop$closure());
      } else
        $._lastCallback = $._lastCallback.next = newEntry;
    },
    _schedulePriorityAsyncCallback: function(callback) {
      var entry, t2,
        t1 = $._nextCallback;
      if (t1 == null) {
        P._scheduleAsyncCallback(callback);
        $._lastPriorityCallback = $._lastCallback;
        return;
      }
      entry = new P._AsyncCallbackEntry(callback);
      t2 = $._lastPriorityCallback;
      if (t2 == null) {
        entry.next = t1;
        $._nextCallback = $._lastPriorityCallback = entry;
      } else {
        entry.next = t2.next;
        $._lastPriorityCallback = t2.next = entry;
        if (entry.next == null)
          $._lastCallback = entry;
      }
    },
    scheduleMicrotask: function(callback) {
      var t1, _null = null,
        currentZone = $.Zone__current;
      if (C.C__RootZone === currentZone) {
        P._rootScheduleMicrotask(_null, _null, C.C__RootZone, callback);
        return;
      }
      if (C.C__RootZone === currentZone.get$_scheduleMicrotask().zone)
        t1 = C.C__RootZone.get$errorZone() === currentZone.get$errorZone();
      else
        t1 = false;
      if (t1) {
        P._rootScheduleMicrotask(_null, _null, currentZone, currentZone.registerCallback$1(callback));
        return;
      }
      t1 = $.Zone__current;
      t1.scheduleMicrotask$1(t1.bindCallbackGuarded$1(callback));
    },
    Stream_Stream$fromFuture: function(future, $T) {
      var _null = null,
        controller = new P._SyncStreamController(_null, _null, _null, _null, [$T]);
      future.then$1$2$onError(new P.Stream_Stream$fromFuture_closure(controller, $T), new P.Stream_Stream$fromFuture_closure0(controller), P.Null);
      return new P._ControllerStream(controller, [$T]);
    },
    StreamIterator_StreamIterator: function(stream) {
      return new P._StreamIterator(stream == null ? H.throwExpression(P.ArgumentError$notNull("stream")) : stream);
    },
    StreamController_StreamController: function(onCancel, onListen, onPause, onResume, sync, $T) {
      return sync ? new P._SyncStreamController(onListen, onPause, onResume, onCancel, [$T]) : new P._AsyncStreamController(onListen, onPause, onResume, onCancel, [$T]);
    },
    _runGuarded: function(notificationHandler) {
      var e, s, exception;
      if (notificationHandler == null)
        return;
      try {
        notificationHandler.call$0();
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        $.Zone__current.handleUncaughtError$2(e, s);
      }
    },
    _nullDataHandler: function(value) {
    },
    _nullErrorHandler: function(error, stackTrace) {
      $.Zone__current.handleUncaughtError$2(error, stackTrace);
    },
    _nullDoneHandler: function() {
    },
    _StreamIterator$: function(stream) {
      return new P._StreamIterator(stream == null ? H.throwExpression(P.ArgumentError$notNull("stream")) : stream);
    },
    _addErrorWithReplacement: function(sink, error, stackTrace) {
      var replacement = $.Zone__current.errorCallback$2(error, stackTrace);
      if (replacement != null) {
        error = replacement.error;
        if (error == null)
          error = new P.NullThrownError();
        stackTrace = replacement.stackTrace;
      }
      sink._addError$2(error, stackTrace);
    },
    Timer_Timer: function(duration, callback) {
      var t1 = $.Zone__current;
      if (t1 === C.C__RootZone)
        return t1.createTimer$2(duration, callback);
      return t1.createTimer$2(duration, t1.bindCallbackGuarded$1(callback));
    },
    _parentDelegate: function(zone) {
      if (zone.get$parent() == null)
        return;
      return zone.get$parent().get$_delegate();
    },
    _rootHandleUncaughtError: function($self, $parent, zone, error, stackTrace) {
      var t1 = {};
      t1.error = error;
      P._schedulePriorityAsyncCallback(new P._rootHandleUncaughtError_closure(t1, stackTrace));
    },
    _rootRun: function($self, $parent, zone, f) {
      var old,
        t1 = $.Zone__current;
      if (t1 == zone)
        return f.call$0();
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$0();
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRunUnary: function($self, $parent, zone, f, arg) {
      var old,
        t1 = $.Zone__current;
      if (t1 == zone)
        return f.call$1(arg);
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$1(arg);
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRunBinary: function($self, $parent, zone, f, arg1, arg2) {
      var old,
        t1 = $.Zone__current;
      if (t1 == zone)
        return f.call$2(arg1, arg2);
      $.Zone__current = zone;
      old = t1;
      try {
        t1 = f.call$2(arg1, arg2);
        return t1;
      } finally {
        $.Zone__current = old;
      }
    },
    _rootRegisterCallback: function($self, $parent, zone, f) {
      return f;
    },
    _rootRegisterUnaryCallback: function($self, $parent, zone, f) {
      return f;
    },
    _rootRegisterBinaryCallback: function($self, $parent, zone, f) {
      return f;
    },
    _rootErrorCallback: function($self, $parent, zone, error, stackTrace) {
      return;
    },
    _rootScheduleMicrotask: function($self, $parent, zone, f) {
      var t1 = C.C__RootZone !== zone;
      if (t1)
        f = !(!t1 || C.C__RootZone.get$errorZone() === zone.get$errorZone()) ? zone.bindCallbackGuarded$1(f) : zone.bindCallback$1(f);
      P._scheduleAsyncCallback(f);
    },
    _rootCreateTimer: function($self, $parent, zone, duration, callback) {
      callback = zone.bindCallback$1(callback);
      return P.Timer__createTimer(duration, callback);
    },
    _rootCreatePeriodicTimer: function($self, $parent, zone, duration, callback) {
      var milliseconds;
      callback = zone.bindUnaryCallback$2$1(callback, null, P.Timer);
      milliseconds = C.JSInt_methods._tdivFast$1(duration._duration, 1000);
      return P._TimerImpl$periodic(milliseconds < 0 ? 0 : milliseconds, callback);
    },
    _rootPrint: function($self, $parent, zone, line) {
      H.printString(line);
    },
    _printToZone: function(line) {
      $.Zone__current.print$1(line);
    },
    _rootFork: function($self, $parent, zone, specification, zoneValues) {
      var valueMap, t1, t2;
      $.printToZone = P.async___printToZone$closure();
      if (specification == null)
        specification = C._ZoneSpecification_ALf;
      if (zoneValues == null)
        valueMap = zone.get$_async$_map();
      else
        valueMap = P.HashMap_HashMap$from(zoneValues, null, null);
      t1 = new P._CustomZone(zone, valueMap);
      t2 = zone.get$_run();
      t1._run = t2;
      t2 = zone.get$_runUnary();
      t1._runUnary = t2;
      t2 = zone.get$_runBinary();
      t1._runBinary = t2;
      t2 = zone.get$_registerCallback();
      t1._registerCallback = t2;
      t2 = zone.get$_registerUnaryCallback();
      t1._registerUnaryCallback = t2;
      t2 = zone.get$_registerBinaryCallback();
      t1._registerBinaryCallback = t2;
      t2 = zone.get$_errorCallback();
      t1._errorCallback = t2;
      t2 = zone.get$_scheduleMicrotask();
      t1._scheduleMicrotask = t2;
      t2 = zone.get$_createTimer();
      t1._createTimer = t2;
      t2 = zone.get$_createPeriodicTimer();
      t1._createPeriodicTimer = t2;
      t2 = zone.get$_print();
      t1._print = t2;
      t2 = zone.get$_fork();
      t1._fork = t2;
      t2 = specification.handleUncaughtError;
      t1._handleUncaughtError = t2 != null ? new P._ZoneFunction(t1, t2) : zone.get$_handleUncaughtError();
      return t1;
    },
    runZoned: function(body, zoneValues) {
      var zoneSpecification = null,
        t1 = P._runZoned(body, zoneValues, zoneSpecification);
      return t1;
    },
    _runZoned: function(body, zoneValues, specification) {
      return $.Zone__current.fork$2$specification$zoneValues(specification, zoneValues).run$1(0, body);
    },
    _AsyncRun__initializeScheduleImmediate_internalCallback: function _AsyncRun__initializeScheduleImmediate_internalCallback(t0) {
      this._box_0 = t0;
    },
    _AsyncRun__initializeScheduleImmediate_closure: function _AsyncRun__initializeScheduleImmediate_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.div = t1;
      this.span = t2;
    },
    _AsyncRun__scheduleImmediateJsOverride_internalCallback: function _AsyncRun__scheduleImmediateJsOverride_internalCallback(t0) {
      this.callback = t0;
    },
    _AsyncRun__scheduleImmediateWithSetImmediate_internalCallback: function _AsyncRun__scheduleImmediateWithSetImmediate_internalCallback(t0) {
      this.callback = t0;
    },
    _TimerImpl: function _TimerImpl(t0) {
      this._once = t0;
      this._handle = null;
      this._tick = 0;
    },
    _TimerImpl_internalCallback: function _TimerImpl_internalCallback(t0, t1) {
      this.$this = t0;
      this.callback = t1;
    },
    _TimerImpl$periodic_closure: function _TimerImpl$periodic_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.milliseconds = t1;
      _.start = t2;
      _.callback = t3;
    },
    _AsyncAwaitCompleter: function _AsyncAwaitCompleter(t0, t1) {
      this._future = t0;
      this.isSync = false;
      this.$ti = t1;
    },
    _awaitOnObject_closure: function _awaitOnObject_closure(t0) {
      this.bodyFunction = t0;
    },
    _awaitOnObject_closure0: function _awaitOnObject_closure0(t0) {
      this.bodyFunction = t0;
    },
    _wrapJsFunctionForAsync_closure: function _wrapJsFunctionForAsync_closure(t0) {
      this.$protected = t0;
    },
    _asyncStarHelper_closure: function _asyncStarHelper_closure(t0, t1) {
      this.controller = t0;
      this.bodyFunctionOrErrorCode = t1;
    },
    _asyncStarHelper_closure0: function _asyncStarHelper_closure0(t0, t1) {
      this.controller = t0;
      this.bodyFunctionOrErrorCode = t1;
    },
    _AsyncStarStreamController: function _AsyncStarStreamController(t0) {
      var _ = this;
      _.controller = null;
      _.isSuspended = false;
      _.cancelationFuture = null;
      _.$ti = t0;
    },
    _AsyncStarStreamController__resumeBody: function _AsyncStarStreamController__resumeBody(t0) {
      this.body = t0;
    },
    _AsyncStarStreamController__resumeBody_closure: function _AsyncStarStreamController__resumeBody_closure(t0) {
      this.body = t0;
    },
    _AsyncStarStreamController_closure0: function _AsyncStarStreamController_closure0(t0) {
      this._resumeBody = t0;
    },
    _AsyncStarStreamController_closure1: function _AsyncStarStreamController_closure1(t0, t1) {
      this.$this = t0;
      this._resumeBody = t1;
    },
    _AsyncStarStreamController_closure: function _AsyncStarStreamController_closure(t0, t1) {
      this.$this = t0;
      this.body = t1;
    },
    _AsyncStarStreamController__closure: function _AsyncStarStreamController__closure(t0) {
      this.body = t0;
    },
    _IterationMarker: function _IterationMarker(t0, t1) {
      this.value = t0;
      this.state = t1;
    },
    _SyncStarIterator: function _SyncStarIterator(t0) {
      var _ = this;
      _._body = t0;
      _._suspendedBodies = _._nestedIterator = _._async$_current = null;
    },
    _SyncStarIterable: function _SyncStarIterable(t0, t1) {
      this._outerHelper = t0;
      this.$ti = t1;
    },
    _BroadcastStream: function _BroadcastStream(t0, t1) {
      this._async$_controller = t0;
      this.$ti = t1;
    },
    _BroadcastSubscription: function _BroadcastSubscription(t0, t1, t2, t3) {
      var _ = this;
      _._eventState = 0;
      _._async$_previous = _._async$_next = null;
      _._async$_controller = t0;
      _._onDone = _._onError = _._onData = null;
      _._zone = t1;
      _._async$_state = t2;
      _._pending = _._cancelFuture = null;
      _.$ti = t3;
    },
    _BroadcastStreamController: function _BroadcastStreamController() {
    },
    _SyncBroadcastStreamController: function _SyncBroadcastStreamController(t0, t1, t2) {
      var _ = this;
      _.onListen = t0;
      _.onCancel = t1;
      _._async$_state = 0;
      _._doneFuture = _._addStreamState = _._lastSubscription = _._firstSubscription = null;
      _.$ti = t2;
    },
    _SyncBroadcastStreamController__sendData_closure: function _SyncBroadcastStreamController__sendData_closure(t0) {
      this.data = t0;
    },
    _SyncBroadcastStreamController__sendError_closure: function _SyncBroadcastStreamController__sendError_closure(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    _SyncBroadcastStreamController__sendDone_closure: function _SyncBroadcastStreamController__sendDone_closure() {
    },
    Future: function Future() {
    },
    Future_wait_handleError: function Future_wait_handleError(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.cleanUp = t1;
      _.eagerError = t2;
      _.result = t3;
    },
    Future_wait_closure: function Future_wait_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.pos = t1;
      _.result = t2;
      _.cleanUp = t3;
      _.eagerError = t4;
      _.T = t5;
    },
    _Completer: function _Completer() {
    },
    _AsyncCompleter: function _AsyncCompleter(t0, t1) {
      this.future = t0;
      this.$ti = t1;
    },
    _FutureListener: function _FutureListener(t0, t1, t2, t3) {
      var _ = this;
      _._nextListener = null;
      _.result = t0;
      _.state = t1;
      _.callback = t2;
      _.errorCallback = t3;
    },
    _Future: function _Future(t0, t1) {
      var _ = this;
      _._async$_state = 0;
      _._zone = t0;
      _._resultOrListeners = null;
      _.$ti = t1;
    },
    _Future__addListener_closure: function _Future__addListener_closure(t0, t1) {
      this.$this = t0;
      this.listener = t1;
    },
    _Future__prependListeners_closure: function _Future__prependListeners_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _Future__chainForeignFuture_closure: function _Future__chainForeignFuture_closure(t0) {
      this.target = t0;
    },
    _Future__chainForeignFuture_closure0: function _Future__chainForeignFuture_closure0(t0) {
      this.target = t0;
    },
    _Future__chainForeignFuture_closure1: function _Future__chainForeignFuture_closure1(t0, t1, t2) {
      this.target = t0;
      this.e = t1;
      this.s = t2;
    },
    _Future__asyncComplete_closure: function _Future__asyncComplete_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _Future__chainFuture_closure: function _Future__chainFuture_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _Future__asyncCompleteError_closure: function _Future__asyncCompleteError_closure(t0, t1, t2) {
      this.$this = t0;
      this.error = t1;
      this.stackTrace = t2;
    },
    _Future__propagateToListeners_handleWhenCompleteCallback: function _Future__propagateToListeners_handleWhenCompleteCallback(t0, t1, t2, t3) {
      var _ = this;
      _._box_1 = t0;
      _._box_0 = t1;
      _.listener = t2;
      _.hasError = t3;
    },
    _Future__propagateToListeners_handleWhenCompleteCallback_closure: function _Future__propagateToListeners_handleWhenCompleteCallback_closure(t0) {
      this.originalSource = t0;
    },
    _Future__propagateToListeners_handleValueCallback: function _Future__propagateToListeners_handleValueCallback(t0, t1, t2) {
      this._box_0 = t0;
      this.listener = t1;
      this.sourceResult = t2;
    },
    _Future__propagateToListeners_handleError: function _Future__propagateToListeners_handleError(t0, t1, t2) {
      this._box_1 = t0;
      this._box_0 = t1;
      this.listener = t2;
    },
    _AsyncCallbackEntry: function _AsyncCallbackEntry(t0) {
      this.callback = t0;
      this.next = null;
    },
    Stream: function Stream() {
    },
    Stream_Stream$fromFuture_closure: function Stream_Stream$fromFuture_closure(t0, t1) {
      this.controller = t0;
      this.T = t1;
    },
    Stream_Stream$fromFuture_closure0: function Stream_Stream$fromFuture_closure0(t0) {
      this.controller = t0;
    },
    Stream_length_closure: function Stream_length_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Stream_length_closure0: function Stream_length_closure0(t0, t1) {
      this._box_0 = t0;
      this.future = t1;
    },
    StreamSubscription: function StreamSubscription() {
    },
    EventSink: function EventSink() {
    },
    StreamTransformerBase: function StreamTransformerBase() {
    },
    _StreamController: function _StreamController() {
    },
    _StreamController__subscribe_closure: function _StreamController__subscribe_closure(t0) {
      this.$this = t0;
    },
    _StreamController__recordCancel_complete: function _StreamController__recordCancel_complete(t0) {
      this.$this = t0;
    },
    _SyncStreamControllerDispatch: function _SyncStreamControllerDispatch() {
    },
    _AsyncStreamControllerDispatch: function _AsyncStreamControllerDispatch() {
    },
    _AsyncStreamController: function _AsyncStreamController(t0, t1, t2, t3, t4) {
      var _ = this;
      _._varData = null;
      _._async$_state = 0;
      _._doneFuture = null;
      _.onListen = t0;
      _.onPause = t1;
      _.onResume = t2;
      _.onCancel = t3;
      _.$ti = t4;
    },
    _SyncStreamController: function _SyncStreamController(t0, t1, t2, t3, t4) {
      var _ = this;
      _._varData = null;
      _._async$_state = 0;
      _._doneFuture = null;
      _.onListen = t0;
      _.onPause = t1;
      _.onResume = t2;
      _.onCancel = t3;
      _.$ti = t4;
    },
    _ControllerStream: function _ControllerStream(t0, t1) {
      this._async$_controller = t0;
      this.$ti = t1;
    },
    _ControllerSubscription: function _ControllerSubscription(t0, t1, t2, t3) {
      var _ = this;
      _._async$_controller = t0;
      _._onDone = _._onError = _._onData = null;
      _._zone = t1;
      _._async$_state = t2;
      _._pending = _._cancelFuture = null;
      _.$ti = t3;
    },
    _AddStreamState: function _AddStreamState() {
    },
    _AddStreamState_cancel_closure: function _AddStreamState_cancel_closure(t0) {
      this.$this = t0;
    },
    _StreamControllerAddStreamState: function _StreamControllerAddStreamState(t0, t1, t2) {
      this.varData = t0;
      this.addStreamFuture = t1;
      this.addSubscription = t2;
    },
    _BufferingStreamSubscription: function _BufferingStreamSubscription() {
    },
    _BufferingStreamSubscription__sendError_sendError: function _BufferingStreamSubscription__sendError_sendError(t0, t1, t2) {
      this.$this = t0;
      this.error = t1;
      this.stackTrace = t2;
    },
    _BufferingStreamSubscription__sendDone_sendDone: function _BufferingStreamSubscription__sendDone_sendDone(t0) {
      this.$this = t0;
    },
    _StreamImpl: function _StreamImpl() {
    },
    _DelayedEvent: function _DelayedEvent() {
    },
    _DelayedData: function _DelayedData(t0) {
      this.value = t0;
      this.next = null;
    },
    _DelayedError: function _DelayedError(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
      this.next = null;
    },
    _DelayedDone: function _DelayedDone() {
    },
    _PendingEvents: function _PendingEvents() {
    },
    _PendingEvents_schedule_closure: function _PendingEvents_schedule_closure(t0, t1) {
      this.$this = t0;
      this.dispatch = t1;
    },
    _StreamImplEvents: function _StreamImplEvents() {
      this.lastPendingEvent = this.firstPendingEvent = null;
      this._async$_state = 0;
    },
    _DoneStreamSubscription: function _DoneStreamSubscription(t0, t1, t2) {
      var _ = this;
      _._zone = t0;
      _._async$_state = 0;
      _._onDone = t1;
      _.$ti = t2;
    },
    _StreamIterator: function _StreamIterator(t0) {
      this._subscription = null;
      this._stateData = t0;
      this._isPaused = false;
    },
    _ForwardingStream: function _ForwardingStream() {
    },
    _ForwardingStreamSubscription: function _ForwardingStreamSubscription(t0, t1, t2, t3) {
      var _ = this;
      _._stream = t0;
      _._onDone = _._onError = _._onData = _._subscription = null;
      _._zone = t1;
      _._async$_state = t2;
      _._pending = _._cancelFuture = null;
      _.$ti = t3;
    },
    _ExpandStream: function _ExpandStream(t0, t1, t2) {
      this._expand = t0;
      this._async$_source = t1;
      this.$ti = t2;
    },
    Timer: function Timer() {
    },
    AsyncError: function AsyncError(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    _ZoneFunction: function _ZoneFunction(t0, t1) {
      this.zone = t0;
      this.$function = t1;
    },
    ZoneSpecification: function ZoneSpecification() {
    },
    _ZoneSpecification: function _ZoneSpecification(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _.handleUncaughtError = t0;
      _.run = t1;
      _.runUnary = t2;
      _.runBinary = t3;
      _.registerCallback = t4;
      _.registerUnaryCallback = t5;
      _.registerBinaryCallback = t6;
      _.errorCallback = t7;
      _.scheduleMicrotask = t8;
      _.createTimer = t9;
      _.createPeriodicTimer = t10;
      _.print = t11;
      _.fork = t12;
    },
    ZoneDelegate: function ZoneDelegate() {
    },
    Zone: function Zone() {
    },
    _ZoneDelegate: function _ZoneDelegate(t0) {
      this._delegationTarget = t0;
    },
    _Zone: function _Zone() {
    },
    _CustomZone: function _CustomZone(t0, t1) {
      var _ = this;
      _._delegateCache = _._handleUncaughtError = _._fork = _._print = _._createPeriodicTimer = _._createTimer = _._scheduleMicrotask = _._errorCallback = _._registerBinaryCallback = _._registerUnaryCallback = _._registerCallback = _._runBinary = _._runUnary = _._run = null;
      _.parent = t0;
      _._async$_map = t1;
    },
    _CustomZone_bindCallback_closure: function _CustomZone_bindCallback_closure(t0, t1) {
      this.$this = t0;
      this.registered = t1;
    },
    _CustomZone_bindUnaryCallback_closure: function _CustomZone_bindUnaryCallback_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.registered = t1;
      _.T = t2;
      _.R = t3;
    },
    _CustomZone_bindCallbackGuarded_closure: function _CustomZone_bindCallbackGuarded_closure(t0, t1) {
      this.$this = t0;
      this.registered = t1;
    },
    _rootHandleUncaughtError_closure: function _rootHandleUncaughtError_closure(t0, t1) {
      this._box_0 = t0;
      this.stackTrace = t1;
    },
    _RootZone: function _RootZone() {
    },
    _RootZone_bindCallback_closure: function _RootZone_bindCallback_closure(t0, t1) {
      this.$this = t0;
      this.f = t1;
    },
    _RootZone_bindCallbackGuarded_closure: function _RootZone_bindCallbackGuarded_closure(t0, t1) {
      this.$this = t0;
      this.f = t1;
    },
    HashMap_HashMap: function($K, $V) {
      return new P._HashMap([$K, $V]);
    },
    _HashMap__getTableEntry: function(table, key) {
      var entry = table[key];
      return entry === table ? null : entry;
    },
    _HashMap__setTableEntry: function(table, key, value) {
      if (value == null)
        table[key] = table;
      else
        table[key] = value;
    },
    _HashMap__newHashTable: function() {
      var table = Object.create(null);
      P._HashMap__setTableEntry(table, "<non-identifier-key>", table);
      delete table["<non-identifier-key>"];
      return table;
    },
    LinkedHashMap_LinkedHashMap: function(equals, hashCode, isValidKey, $K, $V) {
      if (isValidKey == null)
        if (hashCode == null) {
          if (equals == null)
            return new H.JsLinkedHashMap([$K, $V]);
          hashCode = P.collection___defaultHashCode$closure();
        } else {
          if (P.core__identityHashCode$closure() === hashCode && P.core__identical$closure() === equals)
            return P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6($K, $V);
          if (equals == null)
            equals = P.collection___defaultEquals$closure();
        }
      else {
        if (hashCode == null)
          hashCode = P.collection___defaultHashCode$closure();
        if (equals == null)
          equals = P.collection___defaultEquals$closure();
      }
      return P._LinkedCustomHashMap$(equals, hashCode, isValidKey, $K, $V);
    },
    LinkedHashMap_LinkedHashMap$_literal: function(keyValuePairs, $K, $V) {
      return H.fillLiteralMap(keyValuePairs, new H.JsLinkedHashMap([$K, $V]));
    },
    LinkedHashMap_LinkedHashMap$_empty: function($K, $V) {
      return new H.JsLinkedHashMap([$K, $V]);
    },
    LinkedHashMap__makeLiteral: function(keyValuePairs) {
      return H.fillLiteralMap(keyValuePairs, new H.JsLinkedHashMap([null, null]));
    },
    _LinkedIdentityHashMap__LinkedIdentityHashMap$es6: function($K, $V) {
      return new P._LinkedIdentityHashMap([$K, $V]);
    },
    _LinkedCustomHashMap$: function(_equals, _hashCode, validKey, $K, $V) {
      var t1 = validKey != null ? validKey : new P._LinkedCustomHashMap_closure($K);
      return new P._LinkedCustomHashMap(_equals, _hashCode, t1, [$K, $V]);
    },
    LinkedHashSet_LinkedHashSet: function($E) {
      return new P._LinkedHashSet([$E]);
    },
    LinkedHashSet_LinkedHashSet$_empty: function($E) {
      return new P._LinkedHashSet([$E]);
    },
    LinkedHashSet_LinkedHashSet$_literal: function(values, $E) {
      return H.fillLiteralSet(values, new P._LinkedHashSet([$E]));
    },
    _LinkedHashSet__newHashTable: function() {
      var table = Object.create(null);
      table["<non-identifier-key>"] = table;
      delete table["<non-identifier-key>"];
      return table;
    },
    _LinkedHashSetIterator$: function(_set, _modifications) {
      var t1 = new P._LinkedHashSetIterator(_set, _modifications);
      t1._collection$_cell = _set._collection$_first;
      return t1;
    },
    UnmodifiableListView$: function(source, $E) {
      return new P.UnmodifiableListView(source, [$E]);
    },
    _defaultEquals: function(a, b) {
      return J.$eq$(a, b);
    },
    _defaultHashCode: function(a) {
      return J.get$hashCode$(a);
    },
    HashMap_HashMap$from: function(other, $K, $V) {
      var result = P.HashMap_HashMap($K, $V);
      other.forEach$1(0, new P.HashMap_HashMap$from_closure(result));
      return result;
    },
    IterableBase_iterableToShortString: function(iterable, leftDelimiter, rightDelimiter) {
      var parts, t1;
      if (P._isToStringVisiting(iterable)) {
        if (leftDelimiter === "(" && rightDelimiter === ")")
          return "(...)";
        return leftDelimiter + "..." + rightDelimiter;
      }
      parts = H.setRuntimeTypeInfo([], [P.String]);
      $._toStringVisiting.push(iterable);
      try {
        P._iterablePartsToStrings(iterable, parts);
      } finally {
        $._toStringVisiting.pop();
      }
      t1 = P.StringBuffer__writeAll(leftDelimiter, parts, ", ") + rightDelimiter;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    IterableBase_iterableToFullString: function(iterable, leftDelimiter, rightDelimiter) {
      var buffer, t1;
      if (P._isToStringVisiting(iterable))
        return leftDelimiter + "..." + rightDelimiter;
      buffer = new P.StringBuffer(leftDelimiter);
      $._toStringVisiting.push(iterable);
      try {
        t1 = buffer;
        t1._contents = P.StringBuffer__writeAll(t1._contents, iterable, ", ");
      } finally {
        $._toStringVisiting.pop();
      }
      buffer._contents += rightDelimiter;
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _isToStringVisiting: function(o) {
      var t1, i;
      for (t1 = $._toStringVisiting.length, i = 0; i < t1; ++i)
        if (o === $._toStringVisiting[i])
          return true;
      return false;
    },
    _iterablePartsToStrings: function(iterable, parts) {
      var next, ultimateString, penultimateString, penultimate, ultimate, ultimate0, elision,
        it = iterable.get$iterator(iterable),
        $length = 0, count = 0;
      while (true) {
        if (!($length < 80 || count < 3))
          break;
        if (!it.moveNext$0())
          return;
        next = H.S(it.get$current(it));
        parts.push(next);
        $length += next.length + 2;
        ++count;
      }
      if (!it.moveNext$0()) {
        if (count <= 5)
          return;
        ultimateString = parts.pop();
        penultimateString = parts.pop();
      } else {
        penultimate = it.get$current(it);
        ++count;
        if (!it.moveNext$0()) {
          if (count <= 4) {
            parts.push(H.S(penultimate));
            return;
          }
          ultimateString = H.S(penultimate);
          penultimateString = parts.pop();
          $length += ultimateString.length + 2;
        } else {
          ultimate = it.get$current(it);
          ++count;
          for (; it.moveNext$0(); penultimate = ultimate, ultimate = ultimate0) {
            ultimate0 = it.get$current(it);
            ++count;
            if (count > 100) {
              while (true) {
                if (!($length > 75 && count > 3))
                  break;
                $length -= parts.pop().length + 2;
                --count;
              }
              parts.push("...");
              return;
            }
          }
          penultimateString = H.S(penultimate);
          ultimateString = H.S(ultimate);
          $length += ultimateString.length + penultimateString.length + 4;
        }
      }
      if (count > parts.length + 2) {
        $length += 5;
        elision = "...";
      } else
        elision = null;
      while (true) {
        if (!($length > 80 && parts.length > 3))
          break;
        $length -= parts.pop().length + 2;
        if (elision == null) {
          $length += 5;
          elision = "...";
        }
      }
      if (elision != null)
        parts.push(elision);
      parts.push(penultimateString);
      parts.push(ultimateString);
    },
    LinkedHashMap_LinkedHashMap$from: function(other, $K, $V) {
      var result = P.LinkedHashMap_LinkedHashMap(null, null, null, $K, $V);
      other.forEach$1(0, new P.LinkedHashMap_LinkedHashMap$from_closure(result));
      return result;
    },
    LinkedHashMap_LinkedHashMap$of: function(other, $K, $V) {
      var t1 = P.LinkedHashMap_LinkedHashMap(null, null, null, $K, $V);
      t1.addAll$1(0, other);
      return t1;
    },
    LinkedHashSet_LinkedHashSet$from: function(elements, $E) {
      var t1,
        result = P.LinkedHashSet_LinkedHashSet($E);
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        result.add$1(0, t1.get$current(t1));
      return result;
    },
    LinkedHashSet_LinkedHashSet$of: function(elements, $E) {
      var t1 = P.LinkedHashSet_LinkedHashSet($E);
      t1.addAll$1(0, elements);
      return t1;
    },
    MapBase_mapToString: function(m) {
      var result, t1 = {};
      if (P._isToStringVisiting(m))
        return "{...}";
      result = new P.StringBuffer("");
      try {
        $._toStringVisiting.push(m);
        result._contents += "{";
        t1.first = true;
        m.forEach$1(0, new P.MapBase_mapToString_closure(t1, result));
        result._contents += "}";
      } finally {
        $._toStringVisiting.pop();
      }
      t1 = result._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    MapBase__id: function(x) {
      return x;
    },
    MapBase__fillMapWithMappedIterable: function(map, iterable, key, value) {
      var t1, _i, element;
      for (t1 = iterable.length, _i = 0; _i < t1; ++_i) {
        element = iterable[_i];
        map.$indexSet(0, P.MapBase__id(element), value.call$1(element));
      }
    },
    MapBase__fillMapWithIterables: function(map, keys, values) {
      var keyIterator = keys.get$iterator(keys),
        valueIterator = values.get$iterator(values),
        hasNextKey = keyIterator.moveNext$0(),
        hasNextValue = valueIterator.moveNext$0();
      while (true) {
        if (!(hasNextKey && hasNextValue))
          break;
        map.$indexSet(0, keyIterator.get$current(keyIterator), valueIterator.get$current(valueIterator));
        hasNextKey = keyIterator.moveNext$0();
        hasNextValue = valueIterator.moveNext$0();
      }
      if (hasNextKey || hasNextValue)
        throw H.wrapException(P.ArgumentError$("Iterables do not have same length."));
    },
    ListQueue$: function($E) {
      var t1 = new P.ListQueue([$E]),
        t2 = new Array(8);
      t2.fixed$length = Array;
      t1._collection$_table = H.setRuntimeTypeInfo(t2, [$E]);
      return t1;
    },
    ListQueue_ListQueue$of: function(elements, $E) {
      var t1 = P.ListQueue$($E);
      t1.addAll$1(0, elements);
      return t1;
    },
    ListQueue__nextPowerOf2: function(number) {
      var nextNumber;
      number = (number << 1 >>> 0) - 1;
      for (; true; number = nextNumber) {
        nextNumber = (number & number - 1) >>> 0;
        if (nextNumber === 0)
          return number;
      }
    },
    _ListQueueIterator$: function(queue) {
      return new P._ListQueueIterator(queue, queue._collection$_tail, queue._modificationCount, queue._collection$_head);
    },
    _HashMap: function _HashMap(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_keys = _._collection$_rest = _._collection$_nums = _._collection$_strings = null;
      _.$ti = t0;
    },
    _HashMap_values_closure: function _HashMap_values_closure(t0) {
      this.$this = t0;
    },
    _HashMap_addAll_closure: function _HashMap_addAll_closure(t0) {
      this.$this = t0;
    },
    _HashMapKeyIterable: function _HashMapKeyIterable(t0, t1) {
      this._collection$_map = t0;
      this.$ti = t1;
    },
    _HashMapKeyIterator: function _HashMapKeyIterator(t0, t1) {
      var _ = this;
      _._collection$_map = t0;
      _._collection$_keys = t1;
      _._offset = 0;
      _._collection$_current = null;
    },
    _LinkedIdentityHashMap: function _LinkedIdentityHashMap(t0) {
      var _ = this;
      _.__js_helper$_length = 0;
      _._last = _._first = _._rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t0;
    },
    _LinkedCustomHashMap: function _LinkedCustomHashMap(t0, t1, t2, t3) {
      var _ = this;
      _._equals = t0;
      _._collection$_hashCode = t1;
      _._validKey = t2;
      _.__js_helper$_length = 0;
      _._last = _._first = _._rest = _._nums = _._strings = null;
      _._modifications = 0;
      _.$ti = t3;
    },
    _LinkedCustomHashMap_closure: function _LinkedCustomHashMap_closure(t0) {
      this.K = t0;
    },
    _LinkedHashSet: function _LinkedHashSet(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_last = _._collection$_first = _._collection$_rest = _._collection$_nums = _._collection$_strings = null;
      _._collection$_modifications = 0;
      _.$ti = t0;
    },
    _LinkedIdentityHashSet: function _LinkedIdentityHashSet(t0) {
      var _ = this;
      _._collection$_length = 0;
      _._collection$_last = _._collection$_first = _._collection$_rest = _._collection$_nums = _._collection$_strings = null;
      _._collection$_modifications = 0;
      _.$ti = t0;
    },
    _LinkedHashSetCell: function _LinkedHashSetCell(t0) {
      this._element = t0;
      this._collection$_previous = this._collection$_next = null;
    },
    _LinkedHashSetIterator: function _LinkedHashSetIterator(t0, t1) {
      var _ = this;
      _._set = t0;
      _._collection$_modifications = t1;
      _._collection$_current = _._collection$_cell = null;
    },
    UnmodifiableListView: function UnmodifiableListView(t0, t1) {
      this._collection$_source = t0;
      this.$ti = t1;
    },
    HashMap_HashMap$from_closure: function HashMap_HashMap$from_closure(t0) {
      this.result = t0;
    },
    IterableBase: function IterableBase() {
    },
    LinkedHashMap_LinkedHashMap$from_closure: function LinkedHashMap_LinkedHashMap$from_closure(t0) {
      this.result = t0;
    },
    ListBase: function ListBase() {
    },
    ListMixin: function ListMixin() {
    },
    MapBase: function MapBase() {
    },
    MapBase_mapToString_closure: function MapBase_mapToString_closure(t0, t1) {
      this._box_0 = t0;
      this.result = t1;
    },
    MapMixin: function MapMixin() {
    },
    MapMixin_entries_closure: function MapMixin_entries_closure(t0) {
      this.$this = t0;
    },
    UnmodifiableMapBase: function UnmodifiableMapBase() {
    },
    _MapBaseValueIterable: function _MapBaseValueIterable(t0, t1) {
      this._collection$_map = t0;
      this.$ti = t1;
    },
    _MapBaseValueIterator: function _MapBaseValueIterator(t0, t1) {
      this._collection$_keys = t0;
      this._collection$_map = t1;
      this._collection$_current = null;
    },
    _UnmodifiableMapMixin: function _UnmodifiableMapMixin() {
    },
    MapView: function MapView() {
    },
    UnmodifiableMapView: function UnmodifiableMapView(t0, t1) {
      this._collection$_map = t0;
      this.$ti = t1;
    },
    Queue: function Queue() {
    },
    ListQueue: function ListQueue(t0) {
      var _ = this;
      _._collection$_table = null;
      _._modificationCount = _._collection$_tail = _._collection$_head = 0;
      _.$ti = t0;
    },
    _ListQueueIterator: function _ListQueueIterator(t0, t1, t2, t3) {
      var _ = this;
      _._queue = t0;
      _._end = t1;
      _._modificationCount = t2;
      _._position = t3;
      _._collection$_current = null;
    },
    _SetBase: function _SetBase() {
    },
    _ListBase_Object_ListMixin: function _ListBase_Object_ListMixin() {
    },
    _UnmodifiableMapView_MapView__UnmodifiableMapMixin: function _UnmodifiableMapView_MapView__UnmodifiableMapMixin() {
    },
    Utf8Decoder__convertIntercepted: function(allowMalformed, codeUnits, start, end) {
      if (codeUnits instanceof Uint8Array)
        return P.Utf8Decoder__convertInterceptedUint8List(false, codeUnits, start, end);
      return;
    },
    Utf8Decoder__convertInterceptedUint8List: function(allowMalformed, codeUnits, start, end) {
      var t1, $length,
        decoder = $.$get$Utf8Decoder__decoder();
      if (decoder == null)
        return;
      t1 = 0 === start;
      if (t1 && true)
        return P.Utf8Decoder__useTextDecoderChecked(decoder, codeUnits);
      $length = codeUnits.length;
      end = P.RangeError_checkValidRange(start, end, $length);
      if (t1 && end === $length)
        return P.Utf8Decoder__useTextDecoderChecked(decoder, codeUnits);
      return P.Utf8Decoder__useTextDecoderChecked(decoder, codeUnits.subarray(start, end));
    },
    Utf8Decoder__useTextDecoderChecked: function(decoder, codeUnits) {
      if (P.Utf8Decoder__unsafe(codeUnits))
        return;
      return P.Utf8Decoder__useTextDecoderUnchecked(decoder, codeUnits);
    },
    Utf8Decoder__useTextDecoderUnchecked: function(decoder, codeUnits) {
      var t1, exception;
      try {
        t1 = decoder.decode(codeUnits);
        return t1;
      } catch (exception) {
        H.unwrapException(exception);
      }
      return;
    },
    Utf8Decoder__unsafe: function(codeUnits) {
      var i,
        limit = codeUnits.length - 2;
      for (i = 0; i < limit; ++i)
        if (codeUnits[i] === 237)
          if ((codeUnits[i + 1] & 224) === 160)
            return true;
      return false;
    },
    Utf8Decoder__makeDecoder: function() {
      var t1, exception;
      try {
        t1 = new TextDecoder("utf-8", {fatal: true});
        return t1;
      } catch (exception) {
        H.unwrapException(exception);
      }
      return;
    },
    _scanOneByteCharacters: function(units, from, endIndex) {
      var t1, i, unit;
      for (t1 = J.getInterceptor$asx(units), i = from; i < endIndex; ++i) {
        unit = t1.$index(units, i);
        if ((unit & 127) !== unit)
          return i - from;
      }
      return endIndex - from;
    },
    Base64Codec__checkPadding: function(source, sourceIndex, sourceEnd, firstPadding, paddingCount, $length) {
      if (C.JSInt_methods.$mod($length, 4) !== 0)
        throw H.wrapException(P.FormatException$("Invalid base64 padding, padded length must be multiple of four, is " + $length, source, sourceEnd));
      if (firstPadding + paddingCount !== $length)
        throw H.wrapException(P.FormatException$("Invalid base64 padding, '=' not at the end", source, sourceIndex));
      if (paddingCount > 2)
        throw H.wrapException(P.FormatException$("Invalid base64 padding, more than two '=' characters", source, sourceIndex));
    },
    _Base64Encoder_encodeChunk: function(alphabet, bytes, start, end, isLast, output, outputIndex, state) {
      var t1, i, byteOr, byte, outputIndex0, outputIndex1,
        bits = state >>> 2,
        expectedChars = 3 - (state & 3);
      for (t1 = J.getInterceptor$asx(bytes), i = start, byteOr = 0; i < end; ++i) {
        byte = t1.$index(bytes, i);
        byteOr = (byteOr | byte) >>> 0;
        bits = (bits << 8 | byte) & 16777215;
        --expectedChars;
        if (expectedChars === 0) {
          outputIndex0 = outputIndex + 1;
          output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 18 & 63);
          outputIndex = outputIndex0 + 1;
          output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 12 & 63);
          outputIndex0 = outputIndex + 1;
          output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 6 & 63);
          outputIndex = outputIndex0 + 1;
          output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits & 63);
          bits = 0;
          expectedChars = 3;
        }
      }
      if (byteOr >= 0 && byteOr <= 255) {
        if (isLast && expectedChars < 3) {
          outputIndex0 = outputIndex + 1;
          outputIndex1 = outputIndex0 + 1;
          if (3 - expectedChars === 1) {
            output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 2 & 63);
            output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits << 4 & 63);
            output[outputIndex1] = 61;
            output[outputIndex1 + 1] = 61;
          } else {
            output[outputIndex] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 10 & 63);
            output[outputIndex0] = C.JSString_methods._codeUnitAt$1(alphabet, bits >>> 4 & 63);
            output[outputIndex1] = C.JSString_methods._codeUnitAt$1(alphabet, bits << 2 & 63);
            output[outputIndex1 + 1] = 61;
          }
          return 0;
        }
        return (bits << 2 | 3 - expectedChars) >>> 0;
      }
      for (i = start; i < end;) {
        byte = t1.$index(bytes, i);
        if (byte < 0 || byte > 255)
          break;
        ++i;
      }
      throw H.wrapException(P.ArgumentError$value(bytes, "Not a byte value at index " + i + ": 0x" + J.toRadixString$1$n(t1.$index(bytes, i), 16), null));
    },
    JsonUnsupportedObjectError$: function(unsupportedObject, cause, partialResult) {
      return new P.JsonUnsupportedObjectError(unsupportedObject, cause);
    },
    _defaultToEncodable: function(object) {
      return object.toJson$0();
    },
    _JsonStringStringifier_stringify: function(object, toEncodable, indent) {
      var t1,
        output = new P.StringBuffer("");
      P._JsonStringStringifier_printOn(object, output, toEncodable, indent);
      t1 = output._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _JsonStringStringifier_printOn: function(object, output, toEncodable, indent) {
      var stringifier = new P._JsonStringStringifier(output, [], P.convert___defaultToEncodable$closure());
      stringifier.writeObject$1(object);
    },
    AsciiCodec: function AsciiCodec() {
    },
    _UnicodeSubsetEncoder: function _UnicodeSubsetEncoder() {
    },
    AsciiEncoder: function AsciiEncoder(t0) {
      this._subsetMask = t0;
    },
    Base64Codec: function Base64Codec() {
    },
    Base64Encoder: function Base64Encoder() {
    },
    _Base64Encoder: function _Base64Encoder(t0) {
      this._state = 0;
      this._alphabet = t0;
    },
    _BufferCachingBase64Encoder: function _BufferCachingBase64Encoder(t0) {
      this.bufferCache = null;
      this._state = 0;
      this._alphabet = t0;
    },
    _Base64EncoderSink: function _Base64EncoderSink() {
    },
    _AsciiBase64EncoderSink: function _AsciiBase64EncoderSink(t0, t1) {
      this._sink = t0;
      this._encoder = t1;
    },
    _Utf8Base64EncoderSink: function _Utf8Base64EncoderSink(t0, t1) {
      this._sink = t0;
      this._encoder = t1;
    },
    ByteConversionSink: function ByteConversionSink() {
    },
    ByteConversionSinkBase: function ByteConversionSinkBase() {
    },
    ChunkedConversionSink: function ChunkedConversionSink() {
    },
    Codec: function Codec() {
    },
    Converter: function Converter() {
    },
    Encoding: function Encoding() {
    },
    JsonUnsupportedObjectError: function JsonUnsupportedObjectError(t0, t1) {
      this.unsupportedObject = t0;
      this.cause = t1;
    },
    JsonCyclicError: function JsonCyclicError(t0, t1) {
      this.unsupportedObject = t0;
      this.cause = t1;
    },
    JsonCodec: function JsonCodec() {
    },
    JsonEncoder: function JsonEncoder(t0) {
      this._toEncodable = t0;
    },
    _JsonStringifier: function _JsonStringifier() {
    },
    _JsonStringifier_writeMap_closure: function _JsonStringifier_writeMap_closure(t0, t1) {
      this._box_0 = t0;
      this.keyValueList = t1;
    },
    _JsonStringStringifier: function _JsonStringStringifier(t0, t1, t2) {
      this._sink = t0;
      this._seen = t1;
      this._toEncodable = t2;
    },
    StringConversionSinkBase: function StringConversionSinkBase() {
    },
    StringConversionSinkMixin: function StringConversionSinkMixin() {
    },
    _StringSinkConversionSink: function _StringSinkConversionSink(t0) {
      this._stringSink = t0;
    },
    _StringCallbackSink: function _StringCallbackSink(t0, t1) {
      this._callback = t0;
      this._stringSink = t1;
    },
    _StringAdapterSink: function _StringAdapterSink(t0) {
      this._sink = t0;
    },
    _Utf8StringSinkAdapter: function _Utf8StringSinkAdapter(t0, t1) {
      this._decoder = t0;
      this._sink = t1;
    },
    _Utf8ConversionSink: function _Utf8ConversionSink(t0, t1, t2) {
      this._decoder = t0;
      this._chunkedSink = t1;
      this._buffer = t2;
    },
    Utf8Codec: function Utf8Codec() {
    },
    Utf8Encoder: function Utf8Encoder() {
    },
    _Utf8Encoder: function _Utf8Encoder(t0) {
      this._bufferIndex = this._carry = 0;
      this._buffer = t0;
    },
    Utf8Decoder: function Utf8Decoder(t0) {
      this._allowMalformed = t0;
    },
    _Utf8Decoder: function _Utf8Decoder(t0, t1) {
      var _ = this;
      _._allowMalformed = t0;
      _._stringSink = t1;
      _._isFirstCharacter = true;
      _._extraUnits = _._expectedUnits = _._convert$_value = 0;
    },
    identityHashCode: function(object) {
      return H.objectHashCode(object);
    },
    Function_apply: function($function, positionalArguments) {
      return H.Primitives_applyFunction($function, positionalArguments, null);
    },
    int_parse: function(source, onError, radix) {
      var value = H.Primitives_parseInt(source, radix);
      if (value != null)
        return value;
      if (onError != null)
        return onError.call$1(source);
      throw H.wrapException(P.FormatException$(source, null, null));
    },
    double_parse: function(source) {
      var value = H.Primitives_parseDouble(source);
      if (value != null)
        return value;
      throw H.wrapException(P.FormatException$("Invalid double", source, null));
    },
    Error__objectToString: function(object) {
      if (object instanceof H.Closure)
        return object.toString$0(0);
      return "Instance of '" + H.S(H.Primitives_objectTypeName(object)) + "'";
    },
    List_List$filled: function($length, fill, $E) {
      var t1, i,
        result = J.JSArray_JSArray$fixed($length, $E);
      if ($length !== 0 && fill != null)
        for (t1 = result.length, i = 0; i < t1; ++i)
          result[i] = fill;
      return result;
    },
    List_List$from: function(elements, growable, $E) {
      var t1,
        list = H.setRuntimeTypeInfo([], [$E]);
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        list.push(t1.get$current(t1));
      if (growable)
        return list;
      return J.JSArray_markFixedList(list);
    },
    List_List$unmodifiable: function(elements, $E) {
      return J.JSArray_markUnmodifiableList(P.List_List$from(elements, false, $E));
    },
    String_String$fromCharCodes: function(charCodes, start, end) {
      var len;
      if (typeof charCodes === "object" && charCodes !== null && charCodes.constructor === Array) {
        len = charCodes.length;
        end = P.RangeError_checkValidRange(start, end, len);
        return H.Primitives_stringFromCharCodes(start > 0 || end < len ? C.JSArray_methods.sublist$2(charCodes, start, end) : charCodes);
      }
      if (!!J.getInterceptor$(charCodes).$isNativeUint8List)
        return H.Primitives_stringFromNativeUint8List(charCodes, start, P.RangeError_checkValidRange(start, end, charCodes.length));
      return P.String__stringFromIterable(charCodes, start, end);
    },
    String_String$fromCharCode: function(charCode) {
      return H.Primitives_stringFromCharCode(charCode);
    },
    String__stringFromIterable: function(charCodes, start, end) {
      var t1, it, i, list, _null = null;
      if (start < 0)
        throw H.wrapException(P.RangeError$range(start, 0, J.get$length$asx(charCodes), _null, _null));
      t1 = end == null;
      if (!t1 && end < start)
        throw H.wrapException(P.RangeError$range(end, start, J.get$length$asx(charCodes), _null, _null));
      it = J.get$iterator$ax(charCodes);
      for (i = 0; i < start; ++i)
        if (!it.moveNext$0())
          throw H.wrapException(P.RangeError$range(start, 0, i, _null, _null));
      list = [];
      if (t1)
        for (; it.moveNext$0();)
          list.push(it.get$current(it));
      else
        for (i = start; i < end; ++i) {
          if (!it.moveNext$0())
            throw H.wrapException(P.RangeError$range(end, start, i, _null, _null));
          list.push(it.get$current(it));
        }
      return H.Primitives_stringFromCharCodes(list);
    },
    RegExp_RegExp: function(source, multiLine) {
      return new H.JSSyntaxRegExp(source, H.JSSyntaxRegExp_makeNative(source, multiLine, true, false, false, false));
    },
    identical: function(a, b) {
      return a == null ? b == null : a === b;
    },
    StringBuffer__writeAll: function(string, objects, separator) {
      var iterator = J.get$iterator$ax(objects);
      if (!iterator.moveNext$0())
        return string;
      if (separator.length === 0) {
        do
          string += H.S(iterator.get$current(iterator));
        while (iterator.moveNext$0());
      } else {
        string += H.S(iterator.get$current(iterator));
        for (; iterator.moveNext$0();)
          string = string + separator + H.S(iterator.get$current(iterator));
      }
      return string;
    },
    NoSuchMethodError$: function(receiver, memberName, positionalArguments, namedArguments) {
      return new P.NoSuchMethodError(receiver, memberName, positionalArguments, namedArguments);
    },
    Uri_base: function() {
      var uri = H.Primitives_currentUri();
      if (uri != null)
        return P.Uri_parse(uri);
      throw H.wrapException(P.UnsupportedError$("'Uri.base' is not supported"));
    },
    _Uri__uriEncode: function(canonicalTable, text, encoding, spaceToPlus) {
      var t1, bytes, i, t2, byte,
        _s16_ = "0123456789ABCDEF";
      if (encoding === C.C_Utf8Codec) {
        t1 = $.$get$_Uri__needsNoEncoding()._nativeRegExp;
        if (typeof text !== "string")
          H.throwExpression(H.argumentErrorValue(text));
        t1 = t1.test(text);
      } else
        t1 = false;
      if (t1)
        return text;
      bytes = encoding.get$encoder().convert$1(text);
      for (t1 = bytes.length, i = 0, t2 = ""; i < t1; ++i) {
        byte = bytes[i];
        if (byte < 128 && (canonicalTable[byte >>> 4] & 1 << (byte & 15)) !== 0)
          t2 += H.Primitives_stringFromCharCode(byte);
        else
          t2 = spaceToPlus && byte === 32 ? t2 + "+" : t2 + "%" + _s16_[byte >>> 4 & 15] + _s16_[byte & 15];
      }
      return t2.charCodeAt(0) == 0 ? t2 : t2;
    },
    StackTrace_current: function() {
      var stackTrace, exception;
      if ($.$get$_hasErrorStackProperty())
        return H.getTraceFromException(new Error());
      try {
        throw H.wrapException("");
      } catch (exception) {
        H.unwrapException(exception);
        stackTrace = H.getTraceFromException(exception);
        return stackTrace;
      }
    },
    DateTime$_withValue: function(_value, isUtc) {
      var t1;
      if (Math.abs(_value) <= 864e13)
        t1 = false;
      else
        t1 = true;
      if (t1)
        H.throwExpression(P.ArgumentError$("DateTime is outside valid range: " + _value));
      return new P.DateTime(_value, false);
    },
    DateTime__fourDigits: function(n) {
      var absN = Math.abs(n),
        sign = n < 0 ? "-" : "";
      if (absN >= 1000)
        return "" + n;
      if (absN >= 100)
        return sign + "0" + absN;
      if (absN >= 10)
        return sign + "00" + absN;
      return sign + "000" + absN;
    },
    DateTime__threeDigits: function(n) {
      if (n >= 100)
        return "" + n;
      if (n >= 10)
        return "0" + n;
      return "00" + n;
    },
    DateTime__twoDigits: function(n) {
      if (n >= 10)
        return "" + n;
      return "0" + n;
    },
    Duration$: function(milliseconds) {
      return new P.Duration(1000 * milliseconds);
    },
    Error_safeToString: function(object) {
      if (typeof object === "number" || typeof object === "boolean" || null == object)
        return J.toString$0$(object);
      if (typeof object === "string")
        return JSON.stringify(object);
      return P.Error__objectToString(object);
    },
    ArgumentError$: function(message) {
      return new P.ArgumentError(false, null, null, message);
    },
    ArgumentError$value: function(value, $name, message) {
      return new P.ArgumentError(true, value, $name, message);
    },
    ArgumentError$notNull: function($name) {
      return new P.ArgumentError(false, null, $name, "Must not be null");
    },
    RangeError$: function(message) {
      var _null = null;
      return new P.RangeError(_null, _null, false, _null, _null, message);
    },
    RangeError$value: function(value, $name, message) {
      return new P.RangeError(null, null, true, value, $name, message != null ? message : "Value not in range");
    },
    RangeError$range: function(invalidValue, minValue, maxValue, $name, message) {
      return new P.RangeError(minValue, maxValue, true, invalidValue, $name, "Invalid value");
    },
    RangeError_checkValueInInterval: function(value, minValue, maxValue, $name) {
      if (value < minValue || value > maxValue)
        throw H.wrapException(P.RangeError$range(value, minValue, maxValue, $name, null));
    },
    RangeError_checkValidIndex: function(index, indexable, $name) {
      var $length = indexable.get$length(indexable);
      if (0 > index || index >= $length)
        throw H.wrapException(P.IndexError$(index, indexable, $name == null ? "index" : $name, null, $length));
    },
    RangeError_checkValidRange: function(start, end, $length) {
      if (0 > start || start > $length)
        throw H.wrapException(P.RangeError$range(start, 0, $length, "start", null));
      if (end != null) {
        if (start > end || end > $length)
          throw H.wrapException(P.RangeError$range(end, start, $length, "end", null));
        return end;
      }
      return $length;
    },
    RangeError_checkNotNegative: function(value, $name) {
      if (value < 0)
        throw H.wrapException(P.RangeError$range(value, 0, null, $name, null));
    },
    IndexError$: function(invalidValue, indexable, $name, message, $length) {
      var t1 = $length == null ? J.get$length$asx(indexable) : $length;
      return new P.IndexError(t1, true, invalidValue, $name, "Index out of range");
    },
    UnsupportedError$: function(message) {
      return new P.UnsupportedError(message);
    },
    UnimplementedError$: function(message) {
      return new P.UnimplementedError(message);
    },
    StateError$: function(message) {
      return new P.StateError(message);
    },
    ConcurrentModificationError$: function(modifiedObject) {
      return new P.ConcurrentModificationError(modifiedObject);
    },
    FormatException$: function(message, source, offset) {
      return new P.FormatException(message, source, offset);
    },
    Iterable_Iterable$generate: function(count, generator, $E) {
      if (count <= 0)
        return new H.EmptyIterable([$E]);
      return new P._GeneratorIterable(count, generator, [$E]);
    },
    List_List$generate: function($length, generator, growable, $E) {
      var result, t1, i;
      if (growable) {
        result = H.setRuntimeTypeInfo([], [$E]);
        C.JSArray_methods.set$length(result, $length);
      } else {
        t1 = new Array($length);
        t1.fixed$length = Array;
        result = H.setRuntimeTypeInfo(t1, [$E]);
      }
      for (i = 0; i < $length; ++i)
        result[i] = generator.call$1(i);
      return result;
    },
    print: function(object) {
      var line = H.S(object),
        t1 = $.printToZone;
      if (t1 == null)
        H.printString(line);
      else
        t1.call$1(line);
    },
    Set_castFrom: function(source, newSet, $S, $T) {
      return new H.CastSet(source, newSet, [$S, $T]);
    },
    _combineSurrogatePair: function(start, end) {
      return 65536 + ((start & 1023) << 10) + (end & 1023);
    },
    Uri_Uri$dataFromString: function($content, encoding, mimeType) {
      var encodingName, t1,
        buffer = new P.StringBuffer(""),
        indices = H.setRuntimeTypeInfo([-1], [P.int]);
      if (encoding == null)
        encodingName = null;
      else
        encodingName = "utf-8";
      if (encoding == null)
        encoding = C.C_AsciiCodec;
      P.UriData__writeUri(mimeType, encodingName, null, buffer, indices);
      indices.push(buffer._contents.length);
      buffer._contents += ",";
      P.UriData__uriEncodeBytes(C.List_CVk, encoding.encode$1($content), buffer);
      t1 = buffer._contents;
      return new P.UriData(t1.charCodeAt(0) == 0 ? t1 : t1, indices, null).get$uri();
    },
    Uri_parse: function(uri) {
      var delta, t1, indices, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, isSimple, scheme, t2, schemeAuth, queryStart0, pathStart0, _null = null,
        end = uri.length;
      if (end >= 5) {
        delta = ((J._codeUnitAt$1$s(uri, 4) ^ 58) * 3 | C.JSString_methods._codeUnitAt$1(uri, 0) ^ 100 | C.JSString_methods._codeUnitAt$1(uri, 1) ^ 97 | C.JSString_methods._codeUnitAt$1(uri, 2) ^ 116 | C.JSString_methods._codeUnitAt$1(uri, 3) ^ 97) >>> 0;
        if (delta === 0)
          return P.UriData__parse(end < end ? C.JSString_methods.substring$2(uri, 0, end) : uri, 5, _null).get$uri();
        else if (delta === 32)
          return P.UriData__parse(C.JSString_methods.substring$2(uri, 5, end), 0, _null).get$uri();
      }
      t1 = new Array(8);
      t1.fixed$length = Array;
      indices = H.setRuntimeTypeInfo(t1, [P.int]);
      indices[0] = 0;
      indices[1] = -1;
      indices[2] = -1;
      indices[7] = -1;
      indices[3] = 0;
      indices[4] = 0;
      indices[5] = end;
      indices[6] = end;
      if (P._scan(uri, 0, end, 0, indices) >= 14)
        indices[7] = end;
      schemeEnd = indices[1];
      if (schemeEnd >= 0)
        if (P._scan(uri, 0, schemeEnd, 20, indices) === 20)
          indices[7] = schemeEnd;
      hostStart = indices[2] + 1;
      portStart = indices[3];
      pathStart = indices[4];
      queryStart = indices[5];
      fragmentStart = indices[6];
      if (fragmentStart < queryStart)
        queryStart = fragmentStart;
      if (pathStart < hostStart)
        pathStart = queryStart;
      else if (pathStart <= schemeEnd)
        pathStart = schemeEnd + 1;
      if (portStart < hostStart)
        portStart = pathStart;
      isSimple = indices[7] < 0;
      if (isSimple)
        if (hostStart > schemeEnd + 3) {
          scheme = _null;
          isSimple = false;
        } else {
          t1 = portStart > 0;
          if (t1 && portStart + 1 === pathStart) {
            scheme = _null;
            isSimple = false;
          } else {
            if (!(queryStart < end && queryStart === pathStart + 2 && J.startsWith$2$s(uri, "..", pathStart)))
              t2 = queryStart > pathStart + 2 && J.startsWith$2$s(uri, "/..", queryStart - 3);
            else
              t2 = true;
            if (t2) {
              scheme = _null;
              isSimple = false;
            } else {
              if (schemeEnd === 4)
                if (J.startsWith$2$s(uri, "file", 0)) {
                  if (hostStart <= 0) {
                    if (!C.JSString_methods.startsWith$2(uri, "/", pathStart)) {
                      schemeAuth = "file:///";
                      delta = 3;
                    } else {
                      schemeAuth = "file://";
                      delta = 2;
                    }
                    uri = schemeAuth + C.JSString_methods.substring$2(uri, pathStart, end);
                    schemeEnd -= 0;
                    t1 = delta - 0;
                    queryStart += t1;
                    fragmentStart += t1;
                    end = uri.length;
                    hostStart = 7;
                    portStart = 7;
                    pathStart = 7;
                  } else if (pathStart === queryStart) {
                    queryStart0 = queryStart + 1;
                    ++fragmentStart;
                    uri = C.JSString_methods.replaceRange$3(uri, pathStart, queryStart, "/");
                    ++end;
                    queryStart = queryStart0;
                  }
                  scheme = "file";
                } else if (C.JSString_methods.startsWith$2(uri, "http", 0)) {
                  if (t1 && portStart + 3 === pathStart && C.JSString_methods.startsWith$2(uri, "80", portStart + 1)) {
                    pathStart0 = pathStart - 3;
                    queryStart -= 3;
                    fragmentStart -= 3;
                    uri = C.JSString_methods.replaceRange$3(uri, portStart, pathStart, "");
                    end -= 3;
                    pathStart = pathStart0;
                  }
                  scheme = "http";
                } else
                  scheme = _null;
              else if (schemeEnd === 5 && J.startsWith$2$s(uri, "https", 0)) {
                if (t1 && portStart + 4 === pathStart && J.startsWith$2$s(uri, "443", portStart + 1)) {
                  pathStart0 = pathStart - 4;
                  queryStart -= 4;
                  fragmentStart -= 4;
                  uri = J.replaceRange$3$asx(uri, portStart, pathStart, "");
                  end -= 3;
                  pathStart = pathStart0;
                }
                scheme = "https";
              } else
                scheme = _null;
              isSimple = true;
            }
          }
        }
      else
        scheme = _null;
      if (isSimple) {
        t1 = uri.length;
        if (end < t1) {
          uri = J.substring$2$s(uri, 0, end);
          schemeEnd -= 0;
          hostStart -= 0;
          portStart -= 0;
          pathStart -= 0;
          queryStart -= 0;
          fragmentStart -= 0;
        }
        return new P._SimpleUri(uri, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, scheme);
      }
      return P._Uri__Uri$notSimple(uri, 0, end, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, scheme);
    },
    Uri_decodeComponent: function(encodedComponent) {
      return P._Uri__uriDecode(encodedComponent, 0, encodedComponent.length, C.C_Utf8Codec, false);
    },
    Uri__parseIPv4Address: function(host, start, end) {
      var i, partStart, partIndex, char, part, partIndex0, _null = null,
        _s43_ = "IPv4 address should contain exactly 4 parts",
        _s37_ = "each part must be in the range 0..255",
        error = new P.Uri__parseIPv4Address_error(host),
        result = new Uint8Array(4);
      for (i = start, partStart = i, partIndex = 0; i < end; ++i) {
        char = C.JSString_methods.codeUnitAt$1(host, i);
        if (char !== 46) {
          if ((char ^ 48) > 9)
            error.call$2("invalid character", i);
        } else {
          if (partIndex === 3)
            error.call$2(_s43_, i);
          part = P.int_parse(C.JSString_methods.substring$2(host, partStart, i), _null, _null);
          if (part > 255)
            error.call$2(_s37_, partStart);
          partIndex0 = partIndex + 1;
          result[partIndex] = part;
          partStart = i + 1;
          partIndex = partIndex0;
        }
      }
      if (partIndex !== 3)
        error.call$2(_s43_, end);
      part = P.int_parse(C.JSString_methods.substring$2(host, partStart, end), _null, _null);
      if (part > 255)
        error.call$2(_s37_, partStart);
      result[partIndex] = part;
      return result;
    },
    Uri_parseIPv6Address: function(host, start, end) {
      var parts, i, partStart, wildcardSeen, seenDot, char, atEnd, t1, last, bytes, wildCardLength, index, value, j,
        error = new P.Uri_parseIPv6Address_error(host),
        parseHex = new P.Uri_parseIPv6Address_parseHex(error, host);
      if (host.length < 2)
        error.call$1("address is too short");
      parts = H.setRuntimeTypeInfo([], [P.int]);
      for (i = start, partStart = i, wildcardSeen = false, seenDot = false; i < end; ++i) {
        char = C.JSString_methods.codeUnitAt$1(host, i);
        if (char === 58) {
          if (i === start) {
            ++i;
            if (C.JSString_methods.codeUnitAt$1(host, i) !== 58)
              error.call$2("invalid start colon.", i);
            partStart = i;
          }
          if (i === partStart) {
            if (wildcardSeen)
              error.call$2("only one wildcard `::` is allowed", i);
            parts.push(-1);
            wildcardSeen = true;
          } else
            parts.push(parseHex.call$2(partStart, i));
          partStart = i + 1;
        } else if (char === 46)
          seenDot = true;
      }
      if (parts.length === 0)
        error.call$1("too few parts");
      atEnd = partStart === end;
      t1 = C.JSArray_methods.get$last(parts);
      if (atEnd && t1 !== -1)
        error.call$2("expected a part after last `:`", end);
      if (!atEnd)
        if (!seenDot)
          parts.push(parseHex.call$2(partStart, end));
        else {
          last = P.Uri__parseIPv4Address(host, partStart, end);
          parts.push((last[0] << 8 | last[1]) >>> 0);
          parts.push((last[2] << 8 | last[3]) >>> 0);
        }
      if (wildcardSeen) {
        if (parts.length > 7)
          error.call$1("an address with a wildcard must have less than 7 parts");
      } else if (parts.length !== 8)
        error.call$1("an address without a wildcard must contain exactly 8 parts");
      bytes = new Uint8Array(16);
      for (t1 = parts.length, wildCardLength = 9 - t1, i = 0, index = 0; i < t1; ++i) {
        value = parts[i];
        if (value === -1)
          for (j = 0; j < wildCardLength; ++j) {
            bytes[index] = 0;
            bytes[index + 1] = 0;
            index += 2;
          }
        else {
          bytes[index] = C.JSInt_methods._shrOtherPositive$1(value, 8);
          bytes[index + 1] = value & 255;
          index += 2;
        }
      }
      return bytes;
    },
    _Uri__Uri$notSimple: function(uri, start, end, schemeEnd, hostStart, portStart, pathStart, queryStart, fragmentStart, scheme) {
      var userInfoStart, userInfo, host, t1, port, path, query, _null = null;
      if (scheme == null)
        if (schemeEnd > start)
          scheme = P._Uri__makeScheme(uri, start, schemeEnd);
        else {
          if (schemeEnd === start)
            P._Uri__fail(uri, start, "Invalid empty scheme");
          scheme = "";
        }
      if (hostStart > start) {
        userInfoStart = schemeEnd + 3;
        userInfo = userInfoStart < hostStart ? P._Uri__makeUserInfo(uri, userInfoStart, hostStart - 1) : "";
        host = P._Uri__makeHost(uri, hostStart, portStart, false);
        t1 = portStart + 1;
        port = t1 < pathStart ? P._Uri__makePort(P.int_parse(J.substring$2$s(uri, t1, pathStart), new P._Uri__Uri$notSimple_closure(uri, portStart), _null), scheme) : _null;
      } else {
        port = _null;
        host = port;
        userInfo = "";
      }
      path = P._Uri__makePath(uri, pathStart, queryStart, _null, scheme, host != null);
      query = queryStart < fragmentStart ? P._Uri__makeQuery(uri, queryStart + 1, fragmentStart, _null) : _null;
      return new P._Uri(scheme, userInfo, host, port, path, query, fragmentStart < end ? P._Uri__makeFragment(uri, fragmentStart + 1, end) : _null);
    },
    _Uri__Uri: function(host, path, pathSegments, scheme) {
      var userInfo, query, fragment, port, isFile, t1, hasAuthority, t2, _null = null;
      scheme = P._Uri__makeScheme(scheme, 0, scheme == null ? 0 : scheme.length);
      userInfo = P._Uri__makeUserInfo(_null, 0, 0);
      host = P._Uri__makeHost(host, 0, host == null ? 0 : host.length, false);
      query = P._Uri__makeQuery(_null, 0, 0, _null);
      fragment = P._Uri__makeFragment(_null, 0, 0);
      port = P._Uri__makePort(_null, scheme);
      isFile = scheme === "file";
      if (host == null)
        t1 = userInfo.length !== 0 || port != null || isFile;
      else
        t1 = false;
      if (t1)
        host = "";
      t1 = host == null;
      hasAuthority = !t1;
      path = P._Uri__makePath(path, 0, path == null ? 0 : path.length, pathSegments, scheme, hasAuthority);
      t2 = scheme.length === 0;
      if (t2 && t1 && !C.JSString_methods.startsWith$1(path, "/"))
        path = P._Uri__normalizeRelativePath(path, !t2 || hasAuthority);
      else
        path = P._Uri__removeDotSegments(path);
      return new P._Uri(scheme, userInfo, t1 && C.JSString_methods.startsWith$1(path, "//") ? "" : host, port, path, query, fragment);
    },
    _Uri__defaultPort: function(scheme) {
      if (scheme === "http")
        return 80;
      if (scheme === "https")
        return 443;
      return 0;
    },
    _Uri__fail: function(uri, index, message) {
      throw H.wrapException(P.FormatException$(message, uri, index));
    },
    _Uri__Uri$file: function(path, windows) {
      return windows ? P._Uri__makeWindowsFileUrl(path, false) : P._Uri__makeFileUri(path, false);
    },
    _Uri__checkNonWindowsPathReservedCharacters: function(segments, argumentError) {
      C.JSArray_methods.forEach$1(segments, new P._Uri__checkNonWindowsPathReservedCharacters_closure(false));
    },
    _Uri__checkWindowsPathReservedCharacters: function(segments, argumentError, firstSegment) {
      var t1, t2, t3;
      for (t1 = H.SubListIterable$(segments, firstSegment, null, H.getTypeArgumentByIndex(segments, 0)), t1 = new H.ListIterator(t1, t1.get$length(t1)); t1.moveNext$0();) {
        t2 = t1.__internal$_current;
        t3 = P.RegExp_RegExp('["*/:<>?\\\\|]', false);
        t2.length;
        if (H.stringContainsUnchecked(t2, t3, 0))
          if (argumentError)
            throw H.wrapException(P.ArgumentError$("Illegal character in path"));
          else
            throw H.wrapException(P.UnsupportedError$("Illegal character in path: " + H.S(t2)));
      }
    },
    _Uri__checkWindowsDriveLetter: function(charCode, argumentError) {
      var t1,
        _s21_ = "Illegal drive letter ";
      if (!(65 <= charCode && charCode <= 90))
        t1 = 97 <= charCode && charCode <= 122;
      else
        t1 = true;
      if (t1)
        return;
      if (argumentError)
        throw H.wrapException(P.ArgumentError$(_s21_ + P.String_String$fromCharCode(charCode)));
      else
        throw H.wrapException(P.UnsupportedError$(_s21_ + P.String_String$fromCharCode(charCode)));
    },
    _Uri__makeFileUri: function(path, slashTerminated) {
      var _null = null,
        segments = H.setRuntimeTypeInfo(path.split("/"), [P.String]);
      if (C.JSString_methods.startsWith$1(path, "/"))
        return P._Uri__Uri(_null, _null, segments, "file");
      else
        return P._Uri__Uri(_null, _null, segments, _null);
    },
    _Uri__makeWindowsFileUrl: function(path, slashTerminated) {
      var t1, pathSegments, pathStart, hostPart, _s1_ = "\\", _null = null, _s4_ = "file";
      if (C.JSString_methods.startsWith$1(path, "\\\\?\\"))
        if (C.JSString_methods.startsWith$2(path, "UNC\\", 4))
          path = C.JSString_methods.replaceRange$3(path, 0, 7, _s1_);
        else {
          path = C.JSString_methods.substring$1(path, 4);
          if (path.length < 3 || C.JSString_methods._codeUnitAt$1(path, 1) !== 58 || C.JSString_methods._codeUnitAt$1(path, 2) !== 92)
            throw H.wrapException(P.ArgumentError$("Windows paths with \\\\?\\ prefix must be absolute"));
        }
      else
        path = H.stringReplaceAllUnchecked(path, "/", _s1_);
      t1 = path.length;
      if (t1 > 1 && C.JSString_methods._codeUnitAt$1(path, 1) === 58) {
        P._Uri__checkWindowsDriveLetter(C.JSString_methods._codeUnitAt$1(path, 0), true);
        if (t1 === 2 || C.JSString_methods._codeUnitAt$1(path, 2) !== 92)
          throw H.wrapException(P.ArgumentError$("Windows paths with drive letter must be absolute"));
        pathSegments = H.setRuntimeTypeInfo(path.split(_s1_), [P.String]);
        P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 1);
        return P._Uri__Uri(_null, _null, pathSegments, _s4_);
      }
      if (C.JSString_methods.startsWith$1(path, _s1_))
        if (C.JSString_methods.startsWith$2(path, _s1_, 1)) {
          pathStart = C.JSString_methods.indexOf$2(path, _s1_, 2);
          t1 = pathStart < 0;
          hostPart = t1 ? C.JSString_methods.substring$1(path, 2) : C.JSString_methods.substring$2(path, 2, pathStart);
          pathSegments = H.setRuntimeTypeInfo((t1 ? "" : C.JSString_methods.substring$1(path, pathStart + 1)).split(_s1_), [P.String]);
          P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
          return P._Uri__Uri(hostPart, _null, pathSegments, _s4_);
        } else {
          pathSegments = H.setRuntimeTypeInfo(path.split(_s1_), [P.String]);
          P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
          return P._Uri__Uri(_null, _null, pathSegments, _s4_);
        }
      else {
        pathSegments = H.setRuntimeTypeInfo(path.split(_s1_), [P.String]);
        P._Uri__checkWindowsPathReservedCharacters(pathSegments, true, 0);
        return P._Uri__Uri(_null, _null, pathSegments, _null);
      }
    },
    _Uri__makePort: function(port, scheme) {
      if (port != null && port === P._Uri__defaultPort(scheme))
        return;
      return port;
    },
    _Uri__makeHost: function(host, start, end, strictIPv6) {
      var t1, t2, index, zoneIDstart, zoneID, i;
      if (host == null)
        return;
      if (start === end)
        return "";
      if (C.JSString_methods.codeUnitAt$1(host, start) === 91) {
        t1 = end - 1;
        if (C.JSString_methods.codeUnitAt$1(host, t1) !== 93)
          P._Uri__fail(host, start, "Missing end `]` to match `[` in host");
        t2 = start + 1;
        index = P._Uri__checkZoneID(host, t2, t1);
        if (index < t1) {
          zoneIDstart = index + 1;
          zoneID = P._Uri__normalizeZoneID(host, C.JSString_methods.startsWith$2(host, "25", zoneIDstart) ? index + 3 : zoneIDstart, t1, "%25");
        } else
          zoneID = "";
        P.Uri_parseIPv6Address(host, t2, index);
        return C.JSString_methods.substring$2(host, start, index).toLowerCase() + zoneID + "]";
      }
      for (i = start; i < end; ++i)
        if (C.JSString_methods.codeUnitAt$1(host, i) === 58) {
          index = C.JSString_methods.indexOf$2(host, "%", start);
          index = index >= start && index < end ? index : end;
          if (index < end) {
            zoneIDstart = index + 1;
            zoneID = P._Uri__normalizeZoneID(host, C.JSString_methods.startsWith$2(host, "25", zoneIDstart) ? index + 3 : zoneIDstart, end, "%25");
          } else
            zoneID = "";
          P.Uri_parseIPv6Address(host, start, index);
          return "[" + C.JSString_methods.substring$2(host, start, index) + zoneID + "]";
        }
      return P._Uri__normalizeRegName(host, start, end);
    },
    _Uri__checkZoneID: function(host, start, end) {
      var index = C.JSString_methods.indexOf$2(host, "%", start);
      return index >= start && index < end ? index : end;
    },
    _Uri__normalizeZoneID: function(host, start, end, prefix) {
      var index, sectionStart, isNormalized, char, replacement, t1, t2, tail, sourceLength,
        buffer = prefix !== "" ? new P.StringBuffer(prefix) : null;
      for (index = start, sectionStart = index, isNormalized = true; index < end;) {
        char = C.JSString_methods.codeUnitAt$1(host, index);
        if (char === 37) {
          replacement = P._Uri__normalizeEscape(host, index, true);
          t1 = replacement == null;
          if (t1 && isNormalized) {
            index += 3;
            continue;
          }
          if (buffer == null)
            buffer = new P.StringBuffer("");
          t2 = buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
          if (t1)
            replacement = C.JSString_methods.substring$2(host, index, index + 3);
          else if (replacement === "%")
            P._Uri__fail(host, index, "ZoneID should not contain % anymore");
          buffer._contents = t2 + replacement;
          index += 3;
          sectionStart = index;
          isNormalized = true;
        } else if (char < 127 && (C.List_nxB[char >>> 4] & 1 << (char & 15)) !== 0) {
          if (isNormalized && 65 <= char && 90 >= char) {
            if (buffer == null)
              buffer = new P.StringBuffer("");
            if (sectionStart < index) {
              buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
              sectionStart = index;
            }
            isNormalized = false;
          }
          ++index;
        } else {
          if ((char & 64512) === 55296 && index + 1 < end) {
            tail = C.JSString_methods.codeUnitAt$1(host, index + 1);
            if ((tail & 64512) === 56320) {
              char = 65536 | (char & 1023) << 10 | tail & 1023;
              sourceLength = 2;
            } else
              sourceLength = 1;
          } else
            sourceLength = 1;
          if (buffer == null)
            buffer = new P.StringBuffer("");
          buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
          buffer._contents += P._Uri__escapeChar(char);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return C.JSString_methods.substring$2(host, start, end);
      if (sectionStart < end)
        buffer._contents += C.JSString_methods.substring$2(host, sectionStart, end);
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__normalizeRegName: function(host, start, end) {
      var index, sectionStart, buffer, isNormalized, char, replacement, t1, slice, t2, sourceLength, tail;
      for (index = start, sectionStart = index, buffer = null, isNormalized = true; index < end;) {
        char = C.JSString_methods.codeUnitAt$1(host, index);
        if (char === 37) {
          replacement = P._Uri__normalizeEscape(host, index, true);
          t1 = replacement == null;
          if (t1 && isNormalized) {
            index += 3;
            continue;
          }
          if (buffer == null)
            buffer = new P.StringBuffer("");
          slice = C.JSString_methods.substring$2(host, sectionStart, index);
          t2 = buffer._contents += !isNormalized ? slice.toLowerCase() : slice;
          if (t1) {
            replacement = C.JSString_methods.substring$2(host, index, index + 3);
            sourceLength = 3;
          } else if (replacement === "%") {
            replacement = "%25";
            sourceLength = 1;
          } else
            sourceLength = 3;
          buffer._contents = t2 + replacement;
          index += sourceLength;
          sectionStart = index;
          isNormalized = true;
        } else if (char < 127 && (C.List_qNA[char >>> 4] & 1 << (char & 15)) !== 0) {
          if (isNormalized && 65 <= char && 90 >= char) {
            if (buffer == null)
              buffer = new P.StringBuffer("");
            if (sectionStart < index) {
              buffer._contents += C.JSString_methods.substring$2(host, sectionStart, index);
              sectionStart = index;
            }
            isNormalized = false;
          }
          ++index;
        } else if (char <= 93 && (C.List_2Vk[char >>> 4] & 1 << (char & 15)) !== 0)
          P._Uri__fail(host, index, "Invalid character");
        else {
          if ((char & 64512) === 55296 && index + 1 < end) {
            tail = C.JSString_methods.codeUnitAt$1(host, index + 1);
            if ((tail & 64512) === 56320) {
              char = 65536 | (char & 1023) << 10 | tail & 1023;
              sourceLength = 2;
            } else
              sourceLength = 1;
          } else
            sourceLength = 1;
          if (buffer == null)
            buffer = new P.StringBuffer("");
          slice = C.JSString_methods.substring$2(host, sectionStart, index);
          buffer._contents += !isNormalized ? slice.toLowerCase() : slice;
          buffer._contents += P._Uri__escapeChar(char);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return C.JSString_methods.substring$2(host, start, end);
      if (sectionStart < end) {
        slice = C.JSString_methods.substring$2(host, sectionStart, end);
        buffer._contents += !isNormalized ? slice.toLowerCase() : slice;
      }
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__makeScheme: function(scheme, start, end) {
      var i, containsUpperCase, codeUnit;
      if (start === end)
        return "";
      if (!P._Uri__isAlphabeticCharacter(J.getInterceptor$s(scheme)._codeUnitAt$1(scheme, start)))
        P._Uri__fail(scheme, start, "Scheme not starting with alphabetic character");
      for (i = start, containsUpperCase = false; i < end; ++i) {
        codeUnit = C.JSString_methods._codeUnitAt$1(scheme, i);
        if (!(codeUnit < 128 && (C.List_JYB[codeUnit >>> 4] & 1 << (codeUnit & 15)) !== 0))
          P._Uri__fail(scheme, i, "Illegal scheme character");
        if (65 <= codeUnit && codeUnit <= 90)
          containsUpperCase = true;
      }
      scheme = C.JSString_methods.substring$2(scheme, start, end);
      return P._Uri__canonicalizeScheme(containsUpperCase ? scheme.toLowerCase() : scheme);
    },
    _Uri__canonicalizeScheme: function(scheme) {
      if (scheme === "http")
        return "http";
      if (scheme === "file")
        return "file";
      if (scheme === "https")
        return "https";
      if (scheme === "package")
        return "package";
      return scheme;
    },
    _Uri__makeUserInfo: function(userInfo, start, end) {
      if (userInfo == null)
        return "";
      return P._Uri__normalizeOrSubstring(userInfo, start, end, C.List_gRj, false);
    },
    _Uri__makePath: function(path, start, end, pathSegments, scheme, hasAuthority) {
      var result,
        isFile = scheme === "file",
        ensureLeadingSlash = isFile || hasAuthority,
        t1 = path == null;
      if (t1 && pathSegments == null)
        return isFile ? "/" : "";
      t1 = !t1;
      if (t1 && pathSegments != null)
        throw H.wrapException(P.ArgumentError$("Both path and pathSegments specified"));
      if (t1)
        result = P._Uri__normalizeOrSubstring(path, start, end, C.List_qg4, true);
      else {
        pathSegments.toString;
        result = new H.MappedListIterable(pathSegments, new P._Uri__makePath_closure(), [H.getTypeArgumentByIndex(pathSegments, 0), P.String]).join$1(0, "/");
      }
      if (result.length === 0) {
        if (isFile)
          return "/";
      } else if (ensureLeadingSlash && !C.JSString_methods.startsWith$1(result, "/"))
        result = "/" + result;
      return P._Uri__normalizePath(result, scheme, hasAuthority);
    },
    _Uri__normalizePath: function(path, scheme, hasAuthority) {
      var t1 = scheme.length === 0;
      if (t1 && !hasAuthority && !C.JSString_methods.startsWith$1(path, "/"))
        return P._Uri__normalizeRelativePath(path, !t1 || hasAuthority);
      return P._Uri__removeDotSegments(path);
    },
    _Uri__makeQuery: function(query, start, end, queryParameters) {
      if (query != null)
        return P._Uri__normalizeOrSubstring(query, start, end, C.List_CVk, true);
      return;
    },
    _Uri__makeFragment: function(fragment, start, end) {
      if (fragment == null)
        return;
      return P._Uri__normalizeOrSubstring(fragment, start, end, C.List_CVk, true);
    },
    _Uri__normalizeEscape: function(source, index, lowerCase) {
      var firstDigit, secondDigit, firstDigitValue, secondDigitValue, value,
        t1 = index + 2;
      if (t1 >= source.length)
        return "%";
      firstDigit = C.JSString_methods.codeUnitAt$1(source, index + 1);
      secondDigit = C.JSString_methods.codeUnitAt$1(source, t1);
      firstDigitValue = H.hexDigitValue(firstDigit);
      secondDigitValue = H.hexDigitValue(secondDigit);
      if (firstDigitValue < 0 || secondDigitValue < 0)
        return "%";
      value = firstDigitValue * 16 + secondDigitValue;
      if (value < 127 && (C.List_nxB[C.JSInt_methods._shrOtherPositive$1(value, 4)] & 1 << (value & 15)) !== 0)
        return H.Primitives_stringFromCharCode(lowerCase && 65 <= value && 90 >= value ? (value | 32) >>> 0 : value);
      if (firstDigit >= 97 || secondDigit >= 97)
        return C.JSString_methods.substring$2(source, index, index + 3).toUpperCase();
      return;
    },
    _Uri__escapeChar: function(char) {
      var t1, codeUnits, flag, encodedBytes, index, byte,
        _s16_ = "0123456789ABCDEF";
      if (char < 128) {
        t1 = new Array(3);
        t1.fixed$length = Array;
        codeUnits = H.setRuntimeTypeInfo(t1, [P.int]);
        codeUnits[0] = 37;
        codeUnits[1] = C.JSString_methods._codeUnitAt$1(_s16_, char >>> 4);
        codeUnits[2] = C.JSString_methods._codeUnitAt$1(_s16_, char & 15);
      } else {
        if (char > 2047)
          if (char > 65535) {
            flag = 240;
            encodedBytes = 4;
          } else {
            flag = 224;
            encodedBytes = 3;
          }
        else {
          flag = 192;
          encodedBytes = 2;
        }
        t1 = new Array(3 * encodedBytes);
        t1.fixed$length = Array;
        codeUnits = H.setRuntimeTypeInfo(t1, [P.int]);
        for (index = 0; --encodedBytes, encodedBytes >= 0; flag = 128) {
          byte = C.JSInt_methods._shrReceiverPositive$1(char, 6 * encodedBytes) & 63 | flag;
          codeUnits[index] = 37;
          codeUnits[index + 1] = C.JSString_methods._codeUnitAt$1(_s16_, byte >>> 4);
          codeUnits[index + 2] = C.JSString_methods._codeUnitAt$1(_s16_, byte & 15);
          index += 3;
        }
      }
      return P.String_String$fromCharCodes(codeUnits, 0, null);
    },
    _Uri__normalizeOrSubstring: function(component, start, end, charTable, escapeDelimiters) {
      var t1 = P._Uri__normalize(component, start, end, charTable, escapeDelimiters);
      return t1 == null ? C.JSString_methods.substring$2(component, start, end) : t1;
    },
    _Uri__normalize: function(component, start, end, charTable, escapeDelimiters) {
      var t1, index, sectionStart, buffer, char, replacement, sourceLength, t2, tail;
      for (t1 = !escapeDelimiters, index = start, sectionStart = index, buffer = null; index < end;) {
        char = C.JSString_methods.codeUnitAt$1(component, index);
        if (char < 127 && (charTable[char >>> 4] & 1 << (char & 15)) !== 0)
          ++index;
        else {
          if (char === 37) {
            replacement = P._Uri__normalizeEscape(component, index, false);
            if (replacement == null) {
              index += 3;
              continue;
            }
            if ("%" === replacement) {
              replacement = "%25";
              sourceLength = 1;
            } else
              sourceLength = 3;
          } else if (t1 && char <= 93 && (C.List_2Vk[char >>> 4] & 1 << (char & 15)) !== 0) {
            P._Uri__fail(component, index, "Invalid character");
            replacement = null;
            sourceLength = null;
          } else {
            if ((char & 64512) === 55296) {
              t2 = index + 1;
              if (t2 < end) {
                tail = C.JSString_methods.codeUnitAt$1(component, t2);
                if ((tail & 64512) === 56320) {
                  char = 65536 | (char & 1023) << 10 | tail & 1023;
                  sourceLength = 2;
                } else
                  sourceLength = 1;
              } else
                sourceLength = 1;
            } else
              sourceLength = 1;
            replacement = P._Uri__escapeChar(char);
          }
          if (buffer == null)
            buffer = new P.StringBuffer("");
          buffer._contents += C.JSString_methods.substring$2(component, sectionStart, index);
          buffer._contents += H.S(replacement);
          index += sourceLength;
          sectionStart = index;
        }
      }
      if (buffer == null)
        return;
      if (sectionStart < end)
        buffer._contents += C.JSString_methods.substring$2(component, sectionStart, end);
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__mayContainDotSegments: function(path) {
      if (C.JSString_methods.startsWith$1(path, "."))
        return true;
      return C.JSString_methods.indexOf$1(path, "/.") !== -1;
    },
    _Uri__removeDotSegments: function(path) {
      var output, t1, t2, appendSlash, _i, segment;
      if (!P._Uri__mayContainDotSegments(path))
        return path;
      output = H.setRuntimeTypeInfo([], [P.String]);
      for (t1 = path.split("/"), t2 = t1.length, appendSlash = false, _i = 0; _i < t2; ++_i) {
        segment = t1[_i];
        if (J.$eq$(segment, "..")) {
          if (output.length !== 0) {
            output.pop();
            if (output.length === 0)
              output.push("");
          }
          appendSlash = true;
        } else if ("." === segment)
          appendSlash = true;
        else {
          output.push(segment);
          appendSlash = false;
        }
      }
      if (appendSlash)
        output.push("");
      return C.JSArray_methods.join$1(output, "/");
    },
    _Uri__normalizeRelativePath: function(path, allowScheme) {
      var output, t1, t2, appendSlash, _i, segment;
      if (!P._Uri__mayContainDotSegments(path))
        return !allowScheme ? P._Uri__escapeScheme(path) : path;
      output = H.setRuntimeTypeInfo([], [P.String]);
      for (t1 = path.split("/"), t2 = t1.length, appendSlash = false, _i = 0; _i < t2; ++_i) {
        segment = t1[_i];
        if (".." === segment)
          if (output.length !== 0 && C.JSArray_methods.get$last(output) !== "..") {
            output.pop();
            appendSlash = true;
          } else {
            output.push("..");
            appendSlash = false;
          }
        else if ("." === segment)
          appendSlash = true;
        else {
          output.push(segment);
          appendSlash = false;
        }
      }
      t1 = output.length;
      if (t1 !== 0)
        t1 = t1 === 1 && output[0].length === 0;
      else
        t1 = true;
      if (t1)
        return "./";
      if (appendSlash || C.JSArray_methods.get$last(output) === "..")
        output.push("");
      if (!allowScheme)
        output[0] = P._Uri__escapeScheme(output[0]);
      return C.JSArray_methods.join$1(output, "/");
    },
    _Uri__escapeScheme: function(path) {
      var i, char,
        t1 = path.length;
      if (t1 >= 2 && P._Uri__isAlphabeticCharacter(J._codeUnitAt$1$s(path, 0)))
        for (i = 1; i < t1; ++i) {
          char = C.JSString_methods._codeUnitAt$1(path, i);
          if (char === 58)
            return C.JSString_methods.substring$2(path, 0, i) + "%3A" + C.JSString_methods.substring$1(path, i + 1);
          if (char > 127 || (C.List_JYB[char >>> 4] & 1 << (char & 15)) === 0)
            break;
        }
      return path;
    },
    _Uri__toWindowsFilePath: function(uri) {
      var hasDriveLetter, t2, host,
        segments = uri.get$pathSegments(),
        t1 = segments.length;
      if (t1 > 0 && J.get$length$asx(segments[0]) === 2 && J.codeUnitAt$1$s(segments[0], 1) === 58) {
        P._Uri__checkWindowsDriveLetter(J.codeUnitAt$1$s(segments[0], 0), false);
        P._Uri__checkWindowsPathReservedCharacters(segments, false, 1);
        hasDriveLetter = true;
      } else {
        P._Uri__checkWindowsPathReservedCharacters(segments, false, 0);
        hasDriveLetter = false;
      }
      t2 = uri.get$hasAbsolutePath() && !hasDriveLetter ? "\\" : "";
      if (uri.get$hasAuthority()) {
        host = uri.get$host();
        if (host.length !== 0)
          t2 = t2 + "\\" + H.S(host) + "\\";
      }
      t2 = P.StringBuffer__writeAll(t2, segments, "\\");
      t1 = hasDriveLetter && t1 === 1 ? t2 + "\\" : t2;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _Uri__hexCharPairToByte: function(s, pos) {
      var byte, i, charCode;
      for (byte = 0, i = 0; i < 2; ++i) {
        charCode = C.JSString_methods._codeUnitAt$1(s, pos + i);
        if (48 <= charCode && charCode <= 57)
          byte = byte * 16 + charCode - 48;
        else {
          charCode |= 32;
          if (97 <= charCode && charCode <= 102)
            byte = byte * 16 + charCode - 87;
          else
            throw H.wrapException(P.ArgumentError$("Invalid URL encoding"));
        }
      }
      return byte;
    },
    _Uri__uriDecode: function(text, start, end, encoding, plusToSpace) {
      var simple, codeUnit, t2, bytes,
        t1 = J.getInterceptor$s(text),
        i = start;
      while (true) {
        if (!(i < end)) {
          simple = true;
          break;
        }
        codeUnit = t1._codeUnitAt$1(text, i);
        if (codeUnit <= 127)
          if (codeUnit !== 37)
            t2 = false;
          else
            t2 = true;
        else
          t2 = true;
        if (t2) {
          simple = false;
          break;
        }
        ++i;
      }
      if (simple) {
        if (C.C_Utf8Codec !== encoding)
          t2 = false;
        else
          t2 = true;
        if (t2)
          return t1.substring$2(text, start, end);
        else
          bytes = new H.CodeUnits(t1.substring$2(text, start, end));
      } else {
        bytes = H.setRuntimeTypeInfo([], [P.int]);
        for (i = start; i < end; ++i) {
          codeUnit = t1._codeUnitAt$1(text, i);
          if (codeUnit > 127)
            throw H.wrapException(P.ArgumentError$("Illegal percent encoding in URI"));
          if (codeUnit === 37) {
            if (i + 3 > text.length)
              throw H.wrapException(P.ArgumentError$("Truncated URI"));
            bytes.push(P._Uri__hexCharPairToByte(text, i + 1));
            i += 2;
          } else
            bytes.push(codeUnit);
        }
      }
      return new P.Utf8Decoder(false).convert$1(bytes);
    },
    _Uri__isAlphabeticCharacter: function(codeUnit) {
      var lowerCase = codeUnit | 32;
      return 97 <= lowerCase && lowerCase <= 122;
    },
    UriData__writeUri: function(mimeType, charsetName, parameters, buffer, indices) {
      var t1, slashIndex;
      if (mimeType == null || mimeType === "text/plain")
        mimeType = "";
      if (mimeType.length === 0 || mimeType === "application/octet-stream")
        t1 = buffer._contents += mimeType;
      else {
        slashIndex = P.UriData__validateMimeType(mimeType);
        if (slashIndex < 0)
          throw H.wrapException(P.ArgumentError$value(mimeType, "mimeType", "Invalid MIME type"));
        t1 = buffer._contents += H.S(P._Uri__uriEncode(C.List_qFt, C.JSString_methods.substring$2(mimeType, 0, slashIndex), C.C_Utf8Codec, false));
        buffer._contents = t1 + "/";
        t1 = buffer._contents += H.S(P._Uri__uriEncode(C.List_qFt, C.JSString_methods.substring$1(mimeType, slashIndex + 1), C.C_Utf8Codec, false));
      }
      if (charsetName != null) {
        indices.push(t1.length);
        indices.push(buffer._contents.length + 8);
        buffer._contents += ";charset=";
        buffer._contents += H.S(P._Uri__uriEncode(C.List_qFt, charsetName, C.C_Utf8Codec, false));
      }
    },
    UriData__validateMimeType: function(mimeType) {
      var t1, slashIndex, i;
      for (t1 = mimeType.length, slashIndex = -1, i = 0; i < t1; ++i) {
        if (C.JSString_methods._codeUnitAt$1(mimeType, i) !== 47)
          continue;
        if (slashIndex < 0) {
          slashIndex = i;
          continue;
        }
        return -1;
      }
      return slashIndex;
    },
    UriData__parse: function(text, start, sourceUri) {
      var t1, i, slashIndex, char, equalsIndex, lastSeparator, t2, data,
        _s17_ = "Invalid MIME type",
        indices = H.setRuntimeTypeInfo([start - 1], [P.int]);
      for (t1 = text.length, i = start, slashIndex = -1, char = null; i < t1; ++i) {
        char = C.JSString_methods._codeUnitAt$1(text, i);
        if (char === 44 || char === 59)
          break;
        if (char === 47) {
          if (slashIndex < 0) {
            slashIndex = i;
            continue;
          }
          throw H.wrapException(P.FormatException$(_s17_, text, i));
        }
      }
      if (slashIndex < 0 && i > start)
        throw H.wrapException(P.FormatException$(_s17_, text, i));
      for (; char !== 44;) {
        indices.push(i);
        ++i;
        for (equalsIndex = -1; i < t1; ++i) {
          char = C.JSString_methods._codeUnitAt$1(text, i);
          if (char === 61) {
            if (equalsIndex < 0)
              equalsIndex = i;
          } else if (char === 59 || char === 44)
            break;
        }
        if (equalsIndex >= 0)
          indices.push(equalsIndex);
        else {
          lastSeparator = C.JSArray_methods.get$last(indices);
          if (char !== 44 || i !== lastSeparator + 7 || !C.JSString_methods.startsWith$2(text, "base64", lastSeparator + 1))
            throw H.wrapException(P.FormatException$("Expecting '='", text, i));
          break;
        }
      }
      indices.push(i);
      t2 = i + 1;
      if ((indices.length & 1) === 1)
        text = C.C_Base64Codec.normalize$3(text, t2, t1);
      else {
        data = P._Uri__normalize(text, t2, t1, C.List_CVk, true);
        if (data != null)
          text = C.JSString_methods.replaceRange$3(text, t2, t1, data);
      }
      return new P.UriData(text, indices, sourceUri);
    },
    UriData__uriEncodeBytes: function(canonicalTable, bytes, buffer) {
      var t1, byteOr, i, byte,
        _s16_ = "0123456789ABCDEF";
      for (t1 = J.getInterceptor$asx(bytes), byteOr = 0, i = 0; i < t1.get$length(bytes); ++i) {
        byte = t1.$index(bytes, i);
        byteOr |= byte;
        if (byte < 128 && (canonicalTable[C.JSInt_methods._shrOtherPositive$1(byte, 4)] & 1 << (byte & 15)) !== 0)
          buffer._contents += H.Primitives_stringFromCharCode(byte);
        else {
          buffer._contents += H.Primitives_stringFromCharCode(37);
          buffer._contents += H.Primitives_stringFromCharCode(C.JSString_methods._codeUnitAt$1(_s16_, C.JSInt_methods._shrOtherPositive$1(byte, 4)));
          buffer._contents += H.Primitives_stringFromCharCode(C.JSString_methods._codeUnitAt$1(_s16_, byte & 15));
        }
      }
      if ((byteOr & 4294967040) >>> 0 !== 0)
        for (i = 0; i < t1.get$length(bytes); ++i) {
          byte = t1.$index(bytes, i);
          if (byte < 0 || byte > 255)
            throw H.wrapException(P.ArgumentError$value(byte, "non-byte value", null));
        }
    },
    _createTables: function() {
      var _s77_ = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~!$&'()*+,;=",
        _s1_ = ".", _s1_0 = ":", _s1_1 = "/", _s1_2 = "?", _s1_3 = "#",
        tables = P.List_List$generate(22, new P._createTables_closure(), true, P.Uint8List),
        t1 = new P._createTables_build(tables),
        t2 = new P._createTables_setChars(),
        t3 = new P._createTables_setRange(),
        b = t1.call$2(0, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_, 14);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 3);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(14, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_, 15);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(15, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, "%", 225);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 9);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(1, 225);
      t2.call$3(b, _s77_, 1);
      t2.call$3(b, _s1_0, 34);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(2, 235);
      t2.call$3(b, _s77_, 139);
      t2.call$3(b, _s1_1, 131);
      t2.call$3(b, _s1_, 146);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(3, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 68);
      t2.call$3(b, _s1_, 18);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(4, 229);
      t2.call$3(b, _s77_, 5);
      t3.call$3(b, "AZ", 229);
      t2.call$3(b, _s1_0, 102);
      t2.call$3(b, "@", 68);
      t2.call$3(b, "[", 232);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(5, 229);
      t2.call$3(b, _s77_, 5);
      t3.call$3(b, "AZ", 229);
      t2.call$3(b, _s1_0, 102);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(6, 231);
      t3.call$3(b, "19", 7);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(7, 231);
      t3.call$3(b, "09", 7);
      t2.call$3(b, "@", 68);
      t2.call$3(b, _s1_1, 138);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      t2.call$3(t1.call$2(8, 8), "]", 5);
      b = t1.call$2(9, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 16);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(16, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 17);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(17, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 9);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(10, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 18);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(18, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_, 19);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(19, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 234);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(11, 235);
      t2.call$3(b, _s77_, 11);
      t2.call$3(b, _s1_1, 10);
      t2.call$3(b, _s1_2, 172);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(12, 236);
      t2.call$3(b, _s77_, 12);
      t2.call$3(b, _s1_2, 12);
      t2.call$3(b, _s1_3, 205);
      b = t1.call$2(13, 237);
      t2.call$3(b, _s77_, 13);
      t2.call$3(b, _s1_2, 13);
      t3.call$3(t1.call$2(20, 245), "az", 21);
      b = t1.call$2(21, 245);
      t3.call$3(b, "az", 21);
      t3.call$3(b, "09", 21);
      t2.call$3(b, "+-.", 21);
      return tables;
    },
    _scan: function(uri, start, end, state, indices) {
      var t1, i, table, char, transition,
        tables = $.$get$_scannerTables();
      for (t1 = J.getInterceptor$s(uri), i = start; i < end; ++i) {
        table = tables[state];
        char = t1._codeUnitAt$1(uri, i) ^ 96;
        transition = table[char > 95 ? 31 : char];
        state = transition & 31;
        indices[transition >>> 5] = i;
      }
      return state;
    },
    NoSuchMethodError_toString_closure: function NoSuchMethodError_toString_closure(t0, t1) {
      this._box_0 = t0;
      this.sb = t1;
    },
    bool: function bool() {
    },
    DateTime: function DateTime(t0, t1) {
      this._value = t0;
      this.isUtc = t1;
    },
    double: function double() {
    },
    Duration: function Duration(t0) {
      this._duration = t0;
    },
    Duration_toString_sixDigits: function Duration_toString_sixDigits() {
    },
    Duration_toString_twoDigits: function Duration_toString_twoDigits() {
    },
    Error: function Error() {
    },
    NullThrownError: function NullThrownError() {
    },
    ArgumentError: function ArgumentError(t0, t1, t2, t3) {
      var _ = this;
      _._hasValue = t0;
      _.invalidValue = t1;
      _.name = t2;
      _.message = t3;
    },
    RangeError: function RangeError(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.start = t0;
      _.end = t1;
      _._hasValue = t2;
      _.invalidValue = t3;
      _.name = t4;
      _.message = t5;
    },
    IndexError: function IndexError(t0, t1, t2, t3, t4) {
      var _ = this;
      _.length = t0;
      _._hasValue = t1;
      _.invalidValue = t2;
      _.name = t3;
      _.message = t4;
    },
    NoSuchMethodError: function NoSuchMethodError(t0, t1, t2, t3) {
      var _ = this;
      _._core$_receiver = t0;
      _._memberName = t1;
      _._core$_arguments = t2;
      _._namedArguments = t3;
    },
    UnsupportedError: function UnsupportedError(t0) {
      this.message = t0;
    },
    UnimplementedError: function UnimplementedError(t0) {
      this.message = t0;
    },
    StateError: function StateError(t0) {
      this.message = t0;
    },
    ConcurrentModificationError: function ConcurrentModificationError(t0) {
      this.modifiedObject = t0;
    },
    OutOfMemoryError: function OutOfMemoryError() {
    },
    StackOverflowError: function StackOverflowError() {
    },
    CyclicInitializationError: function CyclicInitializationError(t0) {
      this.variableName = t0;
    },
    _Exception: function _Exception(t0) {
      this.message = t0;
    },
    FormatException: function FormatException(t0, t1, t2) {
      this.message = t0;
      this.source = t1;
      this.offset = t2;
    },
    Function: function Function() {
    },
    int: function int() {
    },
    Iterable: function Iterable() {
    },
    _GeneratorIterable: function _GeneratorIterable(t0, t1, t2) {
      this.length = t0;
      this._generator = t1;
      this.$ti = t2;
    },
    Iterator: function Iterator() {
    },
    List: function List() {
    },
    Map: function Map() {
    },
    MapEntry: function MapEntry(t0, t1, t2) {
      this.key = t0;
      this.value = t1;
      this.$ti = t2;
    },
    Null: function Null() {
    },
    num: function num() {
    },
    Object: function Object() {
    },
    Match: function Match() {
    },
    RegExpMatch: function RegExpMatch() {
    },
    Set: function Set() {
    },
    StackTrace: function StackTrace() {
    },
    _StringStackTrace: function _StringStackTrace(t0) {
      this._core$_stackTrace = t0;
    },
    String: function String() {
    },
    Runes: function Runes(t0) {
      this.string = t0;
    },
    RuneIterator: function RuneIterator(t0) {
      var _ = this;
      _.string = t0;
      _._nextPosition = _._core$_position = 0;
      _._currentCodePoint = null;
    },
    StringBuffer: function StringBuffer(t0) {
      this._contents = t0;
    },
    StringSink: function StringSink() {
    },
    Symbol0: function Symbol0() {
    },
    Uri: function Uri() {
    },
    Uri__parseIPv4Address_error: function Uri__parseIPv4Address_error(t0) {
      this.host = t0;
    },
    Uri_parseIPv6Address_error: function Uri_parseIPv6Address_error(t0) {
      this.host = t0;
    },
    Uri_parseIPv6Address_parseHex: function Uri_parseIPv6Address_parseHex(t0, t1) {
      this.error = t0;
      this.host = t1;
    },
    _Uri: function _Uri(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.scheme = t0;
      _._userInfo = t1;
      _._host = t2;
      _._port = t3;
      _.path = t4;
      _._query = t5;
      _._fragment = t6;
      _._hashCodeCache = _._text = _._pathSegments = null;
    },
    _Uri__Uri$notSimple_closure: function _Uri__Uri$notSimple_closure(t0, t1) {
      this.uri = t0;
      this.portStart = t1;
    },
    _Uri__checkNonWindowsPathReservedCharacters_closure: function _Uri__checkNonWindowsPathReservedCharacters_closure(t0) {
      this.argumentError = t0;
    },
    _Uri__makePath_closure: function _Uri__makePath_closure() {
    },
    UriData: function UriData(t0, t1, t2) {
      this._text = t0;
      this._separatorIndices = t1;
      this._uriCache = t2;
    },
    _createTables_closure: function _createTables_closure() {
    },
    _createTables_build: function _createTables_build(t0) {
      this.tables = t0;
    },
    _createTables_setChars: function _createTables_setChars() {
    },
    _createTables_setRange: function _createTables_setRange() {
    },
    _SimpleUri: function _SimpleUri(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._uri = t0;
      _._schemeEnd = t1;
      _._hostStart = t2;
      _._portStart = t3;
      _._pathStart = t4;
      _._queryStart = t5;
      _._fragmentStart = t6;
      _._schemeCache = t7;
      _._hashCodeCache = null;
    },
    _DataUri: function _DataUri(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.scheme = t0;
      _._userInfo = t1;
      _._host = t2;
      _._port = t3;
      _.path = t4;
      _._query = t5;
      _._fragment = t6;
      _._hashCodeCache = _._text = _._pathSegments = null;
    },
    max: function(a, b) {
      return Math.max(H.checkNum(a), H.checkNum(b));
    },
    pow: function(x, exponent) {
      return Math.pow(x, exponent);
    },
    Random_Random: function() {
      return C.C__JSRandom;
    },
    _JSRandom: function _JSRandom() {
    },
    Uint8List: function Uint8List() {
    },
    _convertDartFunctionFast: function(f) {
      var ret,
        existing = f.$dart_jsFunction;
      if (existing != null)
        return existing;
      ret = function(_call, f) {
        return function() {
          return _call(f, Array.prototype.slice.apply(arguments));
        };
      }(P._callDartFunctionFast, f);
      ret[$.$get$DART_CLOSURE_PROPERTY_NAME()] = f;
      f.$dart_jsFunction = ret;
      return ret;
    },
    _convertDartFunctionFastCaptureThis: function(f) {
      var ret,
        existing = f._$dart_jsFunctionCaptureThis;
      if (existing != null)
        return existing;
      ret = function(_call, f) {
        return function() {
          return _call(f, this, Array.prototype.slice.apply(arguments));
        };
      }(P._callDartFunctionFastCaptureThis, f);
      ret[$.$get$DART_CLOSURE_PROPERTY_NAME()] = f;
      f._$dart_jsFunctionCaptureThis = ret;
      return ret;
    },
    _callDartFunctionFast: function(callback, $arguments) {
      return P.Function_apply(callback, $arguments);
    },
    _callDartFunctionFastCaptureThis: function(callback, $self, $arguments) {
      var t1 = [$self];
      C.JSArray_methods.addAll$1(t1, $arguments);
      return P.Function_apply(callback, t1);
    },
    allowInterop: function(f) {
      if (typeof f == "function")
        return f;
      else
        return P._convertDartFunctionFast(f);
    },
    allowInteropCaptureThis: function(f) {
      if (typeof f == "function")
        throw H.wrapException(P.ArgumentError$("Function is already a JS function so cannot capture this."));
      else
        return P._convertDartFunctionFastCaptureThis(f);
    },
    callConstructor: function(constr, $arguments) {
      var args, factoryFunction;
      if ($arguments instanceof Array)
        switch ($arguments.length) {
          case 0:
            return new constr();
          case 1:
            return new constr($arguments[0]);
          case 2:
            return new constr($arguments[0], $arguments[1]);
          case 3:
            return new constr($arguments[0], $arguments[1], $arguments[2]);
          case 4:
            return new constr($arguments[0], $arguments[1], $arguments[2], $arguments[3]);
        }
      args = [null];
      C.JSArray_methods.addAll$1(args, $arguments);
      factoryFunction = constr.bind.apply(constr, args);
      String(factoryFunction);
      return new factoryFunction();
    }
  },
  N = {ArgParser: function ArgParser(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._arg_parser$_options = t0;
      _.options = t1;
      _.commands = t2;
      _._optionsAndSeparators = t3;
      _.allowTrailingOptions = t4;
      _.usageLineLength = t5;
    }, ArgParser_findByAbbreviation_closure: function ArgParser_findByAbbreviation_closure(t0) {
      this.abbr = t0;
    }, ArgParser_findByAbbreviation_closure0: function ArgParser_findByAbbreviation_closure0() {
    }, SupportsCondition: function SupportsCondition() {
    }, AttributeSelector: function AttributeSelector(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.op = t1;
      _.value = t2;
      _.modifier = t3;
    }, AttributeOperator: function AttributeOperator(t0) {
      this._attribute$_text = t0;
    }, IDSelector: function IDSelector(t0) {
      this.name = t0;
    }, IDSelector_unify_closure: function IDSelector_unify_closure(t0) {
      this.$this = t0;
    }, PlaceholderSelector: function PlaceholderSelector(t0) {
      this.name = t0;
    }, UniversalSelector: function UniversalSelector(t0) {
      this.namespace = t0;
    }, NoSourceMapBuffer: function NoSourceMapBuffer(t0) {
      this._no_source_map_buffer$_buffer = t0;
    },
    serialize: function(node, charset, indentWidth, inspect, lineFeed, sourceMap, style, useSpaces) {
      var t1, css, t2, prefix, t3,
        visitor = N._SerializeVisitor$(indentWidth == null ? 2 : indentWidth, inspect, lineFeed, true, sourceMap, style, useSpaces);
      node.accept$1(visitor);
      t1 = visitor._serialize$_buffer;
      css = t1.toString$0(0);
      if (charset) {
        t2 = new H.CodeUnits(css);
        t2 = t2.any$1(t2, new N.serialize_closure());
      } else
        t2 = false;
      if (t2)
        prefix = style === C.OutputStyle_compressed ? "\ufeff" : '@charset "UTF-8";\n';
      else
        prefix = "";
      t2 = prefix + css;
      t3 = sourceMap ? t1.buildSourceMap$1$prefix(prefix) : null;
      if (sourceMap)
        t1.get$sourceFiles();
      return new N.SerializeResult(t2, t3);
    },
    serializeValue: function(value, inspect, quote) {
      var visitor = N._SerializeVisitor$(null, inspect, null, quote, false, null, true);
      value.accept$1(visitor);
      return visitor._serialize$_buffer.toString$0(0);
    },
    _SerializeVisitor$: function(indentWidth, inspect, lineFeed, quote, sourceMap, style, useSpaces) {
      var t1 = sourceMap ? new D.SourceMapBuffer(new P.StringBuffer(""), H.setRuntimeTypeInfo([], [L.Entry]), P.LinkedHashMap_LinkedHashMap$_empty(P.Uri, Y.SourceFile)) : new N.NoSourceMapBuffer(new P.StringBuffer("")),
        t2 = style == null ? C.OutputStyle_expanded : style,
        t3 = useSpaces ? 32 : 9,
        t4 = indentWidth == null ? 2 : indentWidth,
        t5 = lineFeed == null ? C.LineFeed_D6m : lineFeed;
      P.RangeError_checkValueInInterval(t4, 0, 10, "indentWidth");
      return new N._SerializeVisitor(t1, t2, inspect, quote, t3, t4, t5);
    },
    serialize_closure: function serialize_closure() {
    },
    _SerializeVisitor: function _SerializeVisitor(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._serialize$_buffer = t0;
      _._indentation = 0;
      _._style = t1;
      _._inspect = t2;
      _._quote = t3;
      _._indentCharacter = t4;
      _._indentWidth = t5;
      _._lineFeed = t6;
    },
    _SerializeVisitor_visitCssComment_closure: function _SerializeVisitor_visitCssComment_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssAtRule_closure: function _SerializeVisitor_visitCssAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssMediaRule_closure: function _SerializeVisitor_visitCssMediaRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport_closure: function _SerializeVisitor_visitCssImport_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssImport__closure: function _SerializeVisitor_visitCssImport__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssKeyframeBlock_closure: function _SerializeVisitor_visitCssKeyframeBlock_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssStyleRule_closure: function _SerializeVisitor_visitCssStyleRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssSupportsRule_closure: function _SerializeVisitor_visitCssSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure: function _SerializeVisitor_visitCssDeclaration_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitCssDeclaration_closure0: function _SerializeVisitor_visitCssDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _SerializeVisitor_visitList_closure: function _SerializeVisitor_visitList_closure() {
    },
    _SerializeVisitor_visitList_closure0: function _SerializeVisitor_visitList_closure0(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor_visitList_closure1: function _SerializeVisitor_visitList_closure1(t0) {
      this.$this = t0;
    },
    _SerializeVisitor_visitMap_closure: function _SerializeVisitor_visitMap_closure(t0, t1) {
      this.$this = t0;
      this.map = t1;
    },
    _SerializeVisitor_visitSelectorList_closure: function _SerializeVisitor_visitSelectorList_closure() {
    },
    _SerializeVisitor__write_closure: function _SerializeVisitor__write_closure(t0, t1) {
      this.$this = t0;
      this.value = t1;
    },
    _SerializeVisitor__visitChildren_closure: function _SerializeVisitor__visitChildren_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.children = t2;
    },
    OutputStyle: function OutputStyle(t0) {
      this._serialize$_name = t0;
    },
    LineFeed: function LineFeed(t0, t1) {
      this.name = t0;
      this.text = t1;
    },
    SerializeResult: function SerializeResult(t0, t1) {
      this.css = t0;
      this.sourceMap = t1;
    },
    warn: function(message, deprecation) {
      var warnDefinition = $.Zone__current.$index(0, C.Symbol__warn);
      if (warnDefinition == null)
        throw H.wrapException(P.ArgumentError$("warn() may only be called within a custom function or importer callback."));
      warnDefinition.call$2(message, deprecation);
    },
    withWarnCallback: function(warn, callback) {
      return P.runZoned(new N.withWarnCallback_closure(callback), P.LinkedHashMap__makeLiteral([C.Symbol__warn, warn]));
    },
    withWarnCallback_closure: function withWarnCallback_closure(t0) {
      this.callback = t0;
    },
    UnparsedFrame: function UnparsedFrame(t0, t1) {
      this.uri = t0;
      this.member = t1;
    }
  },
  Z = {
    ArgParserException$: function(message, commands) {
      return new Z.ArgParserException(commands == null ? C.List_empty : P.List_List$unmodifiable(commands, P.String), message, null, null);
    },
    ArgParserException: function ArgParserException(t0, t1, t2, t3) {
      var _ = this;
      _.commands = t0;
      _.message = t1;
      _.source = t2;
      _.offset = t3;
    },
    Argument: function Argument(t0, t1, t2) {
      this.name = t0;
      this.defaultValue = t1;
      this.span = t2;
    },
    ConfiguredVariable: function ConfiguredVariable(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.expression = t1;
      _.isGuarded = t2;
      _.span = t3;
    },
    BooleanExpression: function BooleanExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    VariableDeclaration$: function($name, expression, span, comment, global, guarded, namespace) {
      if (namespace != null && global)
        H.throwExpression(P.ArgumentError$("Other modules' members can't be defined with !global."));
      return new Z.VariableDeclaration(namespace, $name, expression, guarded, global, span);
    },
    VariableDeclaration: function VariableDeclaration(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.expression = t2;
      _.isGuarded = t3;
      _.isGlobal = t4;
      _.span = t5;
    },
    ConfiguredValue: function ConfiguredValue(t0, t1, t2) {
      this.value = t0;
      this.configurationSpan = t1;
      this.assignmentNode = t2;
    },
    InterpolationBuffer: function InterpolationBuffer(t0, t1) {
      this._interpolation_buffer$_text = t0;
      this._interpolation_buffer$_contents = t1;
    },
    RenderContext: function RenderContext() {
    },
    closure129: function closure129() {
    },
    _closure18: function _closure18() {
    },
    _closure19: function _closure19() {
    },
    MergedMapView$: function(maps, $K, $V) {
      var t1 = new Z.MergedMapView(P.LinkedHashMap_LinkedHashMap$_empty($K, [P.Map, $K, $V]), [$K, $V]);
      t1.MergedMapView$1(maps, $K, $V);
      return t1;
    },
    MergedMapView: function MergedMapView(t0, t1) {
      this._mapsByKey = t0;
      this.$ti = t1;
    },
    SassBoolean: function SassBoolean(t0) {
      this.value = t0;
    },
    LineScanner: function LineScanner(t0, t1) {
      var _ = this;
      _._line_scanner$_column = _._line_scanner$_line = 0;
      _.sourceUrl = t0;
      _.string = t1;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    }
  },
  V = {
    ArgResults$_: function(_parser, _parsed, $name, command, rest, $arguments) {
      return new V.ArgResults(_parser, _parsed, $name, new P.UnmodifiableListView(rest, [P.String]));
    },
    ArgResults: function ArgResults(t0, t1, t2, t3) {
      var _ = this;
      _._parser = t0;
      _._parsed = t1;
      _.name = t2;
      _.rest = t3;
    },
    ErrorResult: function ErrorResult(t0, t1) {
      this.error = t0;
      this.stackTrace = t1;
    },
    ModifiableCssStylesheet: function ModifiableCssStylesheet(t0, t1, t2) {
      var _ = this;
      _.span = t0;
      _.children = t1;
      _._children = t2;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    CssStylesheet: function CssStylesheet(t0, t1) {
      this.children = t0;
      this.span = t1;
    },
    AtRootQuery: function AtRootQuery(t0, t1, t2, t3) {
      var _ = this;
      _.include = t0;
      _.names = t1;
      _._all = t2;
      _._at_root_query$_rule = t3;
    },
    BinaryOperationExpression: function BinaryOperationExpression(t0, t1, t2, t3) {
      var _ = this;
      _.operator = t0;
      _.left = t1;
      _.right = t2;
      _.allowsSlash = t3;
    },
    BinaryOperator: function BinaryOperator(t0, t1, t2) {
      this.name = t0;
      this.operator = t1;
      this.precedence = t2;
    },
    AtRootRule: function AtRootRule(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    EachRule: function EachRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.variables = t0;
      _.list = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    EachRule_toString_closure: function EachRule_toString_closure() {
    },
    IfRule: function IfRule(t0, t1, t2) {
      this.clauses = t0;
      this.lastClause = t1;
      this.span = t2;
    },
    IfRule_toString_closure: function IfRule_toString_closure(t0) {
      this._box_0 = t0;
    },
    IfClause: function IfClause(t0, t1, t2) {
      this.expression = t0;
      this.children = t1;
      this.hasDeclarations = t2;
    },
    IfClause$__closure: function IfClause$__closure() {
    },
    IfClause$___closure: function IfClause$___closure() {
    },
    Stylesheet$: function(children, span, plainCss) {
      var t1 = H.setRuntimeTypeInfo([], [T.UseRule]),
        t2 = H.setRuntimeTypeInfo([], [L.ForwardRule]),
        t3 = P.List_List$unmodifiable(children, O.Statement),
        t4 = C.JSArray_methods.any$1(t3, new M.ParentStatement_closure());
      t1 = new V.Stylesheet(span, plainCss, t1, t2, t3, t4);
      t1.Stylesheet$3$plainCss(children, span, plainCss);
      return t1;
    },
    Stylesheet_Stylesheet$parse: function(contents, syntax, logger, url) {
      var t1, t2, t3, t4;
      switch (syntax) {
        case C.Syntax_Sass:
          contents.toString;
          t1 = new H.CodeUnits(contents);
          t2 = H.setRuntimeTypeInfo([0], [P.int]);
          t3 = typeof url === "string";
          t4 = t3 ? P.Uri_parse(url) : url;
          t2 = new Y.SourceFile(t4, t2, new Uint32Array(H._ensureNativeList(t1.toList$0(t1))));
          t2.SourceFile$decoded$2$url(t1, url);
          t1 = t3 ? P.Uri_parse(url) : H.interceptedTypeCast(url, "$isUri");
          t3 = logger == null ? C.StderrLogger_false : logger;
          return new U.SassParser(P.LinkedHashMap_LinkedHashMap$_empty(P.String, Z.VariableDeclaration), new S.SpanScanner(t2, t1, contents), t3).parse$0();
        case C.Syntax_SCSS:
          t1 = S.SpanScanner$(contents, url);
          t2 = logger == null ? C.StderrLogger_false : logger;
          return new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(P.String, Z.VariableDeclaration), t1, t2).parse$0();
        case C.Syntax_CSS:
          contents.toString;
          t1 = new H.CodeUnits(contents);
          t2 = H.setRuntimeTypeInfo([0], [P.int]);
          t3 = typeof url === "string";
          t4 = t3 ? P.Uri_parse(url) : url;
          t2 = new Y.SourceFile(t4, t2, new Uint32Array(H._ensureNativeList(t1.toList$0(t1))));
          t2.SourceFile$decoded$2$url(t1, url);
          t1 = t3 ? P.Uri_parse(url) : H.interceptedTypeCast(url, "$isUri");
          t3 = logger == null ? C.StderrLogger_false : logger;
          return new Q.CssParser(P.LinkedHashMap_LinkedHashMap$_empty(P.String, Z.VariableDeclaration), new S.SpanScanner(t2, t1, contents), t3).parse$0();
        default:
          throw H.wrapException(P.ArgumentError$("Unknown syntax " + syntax.toString$0(0) + "."));
      }
    },
    Stylesheet: function Stylesheet(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.span = t0;
      _.plainCss = t1;
      _._uses = t2;
      _._forwards = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    JSError: function JSError() {
    },
    AtRootQueryParser: function AtRootQueryParser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    AtRootQueryParser_parse_closure: function AtRootQueryParser_parse_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser: function StylesheetParser() {
    },
    StylesheetParser_parse_closure: function StylesheetParser_parse_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure: function StylesheetParser_parse__closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parse__closure0: function StylesheetParser_parse__closure0() {
    },
    StylesheetParser_parseVariableDeclaration_closure: function StylesheetParser_parseVariableDeclaration_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_parseUseRule_closure: function StylesheetParser_parseUseRule_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__parseSingleProduction_closure: function StylesheetParser__parseSingleProduction_closure(t0, t1) {
      this.$this = t0;
      this.production = t1;
    },
    StylesheetParser_parseSignature_closure: function StylesheetParser_parseSignature_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__statement_closure: function StylesheetParser__statement_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure: function StylesheetParser_variableDeclarationWithoutNamespace_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser_variableDeclarationWithoutNamespace_closure0: function StylesheetParser_variableDeclarationWithoutNamespace_closure0(t0) {
      this.declaration = t0;
    },
    StylesheetParser__declarationOrBuffer_closure: function StylesheetParser__declarationOrBuffer_closure(t0) {
      this.name = t0;
    },
    StylesheetParser__declarationOrBuffer_closure0: function StylesheetParser__declarationOrBuffer_closure0(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser__styleRule_closure: function StylesheetParser__styleRule_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.wasInStyleRule = t2;
    },
    StylesheetParser__propertyOrVariableDeclaration_closure: function StylesheetParser__propertyOrVariableDeclaration_closure(t0) {
      this._box_0 = t0;
    },
    StylesheetParser__propertyOrVariableDeclaration_closure0: function StylesheetParser__propertyOrVariableDeclaration_closure0(t0, t1) {
      this._box_0 = t0;
      this.value = t1;
    },
    StylesheetParser__atRootRule_closure: function StylesheetParser__atRootRule_closure(t0) {
      this.query = t0;
    },
    StylesheetParser__atRootRule_closure0: function StylesheetParser__atRootRule_closure0() {
    },
    StylesheetParser__eachRule_closure: function StylesheetParser__eachRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.wasInControlDirective = t1;
      _.variables = t2;
      _.list = t3;
    },
    StylesheetParser__functionRule_closure: function StylesheetParser__functionRule_closure(t0, t1, t2) {
      this.name = t0;
      this.$arguments = t1;
      this.precedingComment = t2;
    },
    StylesheetParser__forRule_closure: function StylesheetParser__forRule_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser__forRule_closure0: function StylesheetParser__forRule_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.wasInControlDirective = t2;
      _.variable = t3;
      _.from = t4;
      _.to = t5;
    },
    StylesheetParser__memberList_closure: function StylesheetParser__memberList_closure(t0, t1, t2) {
      this.$this = t0;
      this.variables = t1;
      this.identifiers = t2;
    },
    StylesheetParser__includeRule_closure: function StylesheetParser__includeRule_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser_mediaRule_closure: function StylesheetParser_mediaRule_closure(t0) {
      this.query = t0;
    },
    StylesheetParser__mixinRule_closure: function StylesheetParser__mixinRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.name = t1;
      _.$arguments = t2;
      _.precedingComment = t3;
    },
    StylesheetParser_mozDocumentRule_closure: function StylesheetParser_mozDocumentRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.name = t2;
      _.value = t3;
    },
    StylesheetParser_supportsRule_closure: function StylesheetParser_supportsRule_closure(t0) {
      this.condition = t0;
    },
    StylesheetParser__whileRule_closure: function StylesheetParser__whileRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.wasInControlDirective = t1;
      this.condition = t2;
    },
    StylesheetParser_unknownAtRule_closure: function StylesheetParser_unknownAtRule_closure(t0, t1) {
      this._box_0 = t0;
      this.name = t1;
    },
    StylesheetParser_expression_resetState: function StylesheetParser_expression_resetState(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.start = t2;
    },
    StylesheetParser_expression_resolveOneOperation: function StylesheetParser_expression_resolveOneOperation(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    StylesheetParser_expression_resolveOperations: function StylesheetParser_expression_resolveOperations(t0, t1) {
      this._box_0 = t0;
      this.resolveOneOperation = t1;
    },
    StylesheetParser_expression_addSingleExpression: function StylesheetParser_expression_addSingleExpression(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.resetState = t2;
      _.resolveOperations = t3;
    },
    StylesheetParser_expression_addOperator: function StylesheetParser_expression_addOperator(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.resolveOneOperation = t2;
    },
    StylesheetParser_expression_resolveSpaceExpressions: function StylesheetParser_expression_resolveSpaceExpressions(t0, t1) {
      this._box_0 = t0;
      this.resolveOperations = t1;
    },
    StylesheetParser__expressionUntilComma_closure: function StylesheetParser__expressionUntilComma_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__unicodeRange_closure: function StylesheetParser__unicodeRange_closure() {
    },
    StylesheetParser__unicodeRange_closure0: function StylesheetParser__unicodeRange_closure0() {
    },
    StylesheetParser_identifierLike_closure: function StylesheetParser_identifierLike_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    StylesheetParser__expressionUntilComparison_closure: function StylesheetParser__expressionUntilComparison_closure(t0) {
      this.$this = t0;
    },
    StylesheetParser__publicIdentifier_closure: function StylesheetParser__publicIdentifier_closure(t0, t1) {
      this.$this = t0;
      this.start = t1;
    },
    cloneCssStylesheet: function(stylesheet, extender) {
      var result = extender.clone$0(),
        t1 = stylesheet.get$span(),
        t2 = B.ModifiableCssNode,
        t3 = H.setRuntimeTypeInfo([], [t2]);
      return new S.Tuple2(new V._CloneCssVisitor(result.item2)._visitChildren$2(new V.ModifiableCssStylesheet(t1, new P.UnmodifiableListView(t3, [t2]), t3), stylesheet), result.item1, [V.ModifiableCssStylesheet, F.Extender]);
    },
    _CloneCssVisitor: function _CloneCssVisitor(t0) {
      this._oldToNewSelectors = t0;
    },
    SourceLocation$: function(offset, column, line, sourceUrl) {
      var t1 = line == null,
        t2 = t1 ? 0 : line,
        t3 = column == null,
        t4 = t3 ? offset : column;
      if (offset < 0)
        H.throwExpression(P.RangeError$("Offset may not be negative, was " + H.S(offset) + "."));
      else if (!t1 && line < 0)
        H.throwExpression(P.RangeError$("Line may not be negative, was " + H.S(line) + "."));
      else if (!t3 && column < 0)
        H.throwExpression(P.RangeError$("Column may not be negative, was " + H.S(column) + "."));
      return new V.SourceLocation(sourceUrl, offset, t2, t4);
    },
    SourceLocation: function SourceLocation(t0, t1, t2, t3) {
      var _ = this;
      _.sourceUrl = t0;
      _.offset = t1;
      _.line = t2;
      _.column = t3;
    },
    SourceSpan: function SourceSpan() {
    },
    SourceSpanBase: function SourceSpanBase() {
    }
  },
  G = {Option: function Option(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _.name = t0;
      _.abbr = t1;
      _.help = t2;
      _.valueHelp = t3;
      _.allowed = t4;
      _.allowedHelp = t5;
      _.defaultsTo = t6;
      _.negatable = t7;
      _.callback = t8;
      _.type = t9;
      _.splitCommas = t10;
      _.hide = t11;
    }, OptionType: function OptionType(t0) {
      this.name = t0;
    },
    Parser$0: function(commandName, grammar, args, $parent, rest) {
      var t1 = P.String,
        t2 = H.setRuntimeTypeInfo([], [t1]);
      if (rest != null)
        C.JSArray_methods.addAll$1(t2, rest);
      return new G.Parser0(commandName, $parent, grammar, args, t2, P.LinkedHashMap_LinkedHashMap$_empty(t1, null));
    },
    Parser0: function Parser0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.commandName = t0;
      _.parent = t1;
      _.grammar = t2;
      _.args = t3;
      _.rest = t4;
      _.results = t5;
    },
    Parser_parse_closure: function Parser_parse_closure(t0) {
      this.$this = t0;
    },
    Parser_setOption_closure: function Parser_setOption_closure() {
    },
    Usage: function Usage(t0, t1) {
      var _ = this;
      _.optionsAndSeparators = t0;
      _.buffer = null;
      _.currentColumn = 0;
      _.columnWidths = null;
      _.newlinesNeeded = _.numHelpLines = 0;
      _.lineLength = t1;
    },
    Usage_generate_closure: function Usage_generate_closure() {
    },
    Usage_buildAllowedList_closure: function Usage_buildAllowedList_closure(t0) {
      this.option = t0;
    },
    StreamQueue: function StreamQueue(t0, t1, t2, t3) {
      var _ = this;
      _._stream_queue$_source = t0;
      _._stream_queue$_subscription = null;
      _._isDone = false;
      _._eventsReceived = 0;
      _._eventQueue = t1;
      _._requestQueue = t2;
      _.$ti = t3;
    },
    StreamQueue__ensureListening_closure: function StreamQueue__ensureListening_closure(t0) {
      this.$this = t0;
    },
    StreamQueue__ensureListening_closure1: function StreamQueue__ensureListening_closure1(t0) {
      this.$this = t0;
    },
    StreamQueue__ensureListening_closure0: function StreamQueue__ensureListening_closure0(t0) {
      this.$this = t0;
    },
    _EventRequest: function _EventRequest() {
    },
    _NextRequest: function _NextRequest(t0, t1) {
      this._completer = t0;
      this.$ti = t1;
    },
    ModifiableCssMediaRule$: function(queries, span) {
      var t1 = P.List_List$unmodifiable(queries, F.CssMediaQuery),
        t2 = B.ModifiableCssNode,
        t3 = H.setRuntimeTypeInfo([], [t2]);
      if (J.get$isEmpty$asx(queries))
        H.throwExpression(P.ArgumentError$value(queries, "queries", "may not be empty."));
      return new G.ModifiableCssMediaRule(t1, span, new P.UnmodifiableListView(t3, [t2]), t3);
    },
    ModifiableCssMediaRule: function ModifiableCssMediaRule(t0, t1, t2, t3) {
      var _ = this;
      _.queries = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    MediaRule: function MediaRule(t0, t1, t2, t3) {
      var _ = this;
      _.query = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    WhileRule: function WhileRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    Module: function Module() {
    },
    Types: function Types() {
    },
    Parser_isIdentifier: function(text) {
      var exception, logger = null;
      try {
        G.Parser$(text, logger, null)._parseIdentifier$0();
        return true;
      } catch (exception) {
        if (H.unwrapException(exception) instanceof E.SassFormatException)
          return false;
        else
          throw exception;
      }
    },
    Parser$: function(contents, logger, url) {
      var t1, t2, t3, t4;
      contents.toString;
      t1 = new H.CodeUnits(contents);
      t2 = H.setRuntimeTypeInfo([0], [P.int]);
      t3 = typeof url === "string";
      t4 = t3 ? P.Uri_parse(url) : url;
      t2 = new Y.SourceFile(t4, t2, new Uint32Array(H._ensureNativeList(t1.toList$0(t1))));
      t2.SourceFile$decoded$2$url(t1, url);
      t1 = t3 ? P.Uri_parse(url) : H.interceptedTypeCast(url, "$isUri");
      t3 = logger == null ? C.StderrLogger_false : logger;
      return new G.Parser(new S.SpanScanner(t2, t1, contents), t3);
    },
    Parser: function Parser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    Parser__parseIdentifier_closure: function Parser__parseIdentifier_closure(t0) {
      this.$this = t0;
    },
    FixedLengthListBuilder: function FixedLengthListBuilder(t0, t1) {
      this._list = t0;
      this._fixed_length_list_builder$_index = 0;
      this.$ti = t1;
    },
    SourceSpanFormatException$: function(message, span, _source) {
      return new G.SourceSpanFormatException(_source, message, span);
    },
    SourceSpanException: function SourceSpanException() {
    },
    SourceSpanFormatException: function SourceSpanFormatException(t0, t1, t2) {
      this._span_exception$_source = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    }
  },
  E = {Result: function Result() {
    }, PosixStyle: function PosixStyle(t0, t1, t2) {
      this.separatorPattern = t0;
      this.needsSeparatorPattern = t1;
      this.rootPattern = t2;
    }, UserDefinedCallable: function UserDefinedCallable(t0, t1, t2) {
      this.declaration = t0;
      this.environment = t1;
      this.$ti = t2;
    },
    SassException$: function(message, span) {
      return new E.SassException(message, span);
    },
    SassRuntimeException$: function(message, span, trace) {
      return new E.SassRuntimeException(trace, message, span);
    },
    SassFormatException$: function(message, span) {
      return new E.SassFormatException(message, span);
    },
    SassScriptException$: function(message) {
      return new E.SassScriptException(message);
    },
    SassException: function SassException(t0, t1) {
      this._span_exception$_message = t0;
      this._span = t1;
    },
    SassRuntimeException: function SassRuntimeException(t0, t1, t2) {
      this.trace = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    SassFormatException: function SassFormatException(t0, t1) {
      this._span_exception$_message = t0;
      this._span = t1;
    },
    SassScriptException: function SassScriptException(t0) {
      this.message = t0;
    },
    ImporterResult: function ImporterResult(t0, t1, t2) {
      this.contents = t0;
      this._sourceMapUrl = t1;
      this.syntax = t2;
    },
    FiberClass: function FiberClass() {
    },
    Fiber: function Fiber() {
    },
    KeyframeSelectorParser: function KeyframeSelectorParser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    KeyframeSelectorParser_parse_closure: function KeyframeSelectorParser_parse_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor$0: function(functions, importCache, logger, nodeImporter, sourceMap) {
      var t5, t6,
        t1 = P.String,
        t2 = P.Uri,
        t3 = [G.Module, B.AsyncCallable],
        t4 = H.setRuntimeTypeInfo([], [[S.Tuple2, P.String, B.AstNode]]);
      if (nodeImporter == null)
        t5 = importCache == null ? O.AsyncImportCache$none(logger) : importCache;
      else
        t5 = null;
      t6 = logger == null ? C.StderrLogger_false : logger;
      t4 = new E._EvaluateVisitor0(t5, nodeImporter, P.LinkedHashMap_LinkedHashMap$_empty(t1, B.AsyncCallable), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), t6, sourceMap, Q.AsyncEnvironment$(sourceMap), P.LinkedHashSet_LinkedHashSet$_empty(t1), P.LinkedHashSet_LinkedHashSet$_empty(t2), t4, C.Configuration_Map_empty_true);
      t4._EvaluateVisitor$5$functions$importCache$logger$nodeImporter$sourceMap0(functions, importCache, logger, nodeImporter, sourceMap);
      return t4;
    },
    _ArgumentResults$0: function(positional, named, separator, namedNodes, positionalNodes) {
      return new E._ArgumentResults0(positional, positionalNodes, named, namedNodes, separator);
    },
    _EvaluateVisitor0: function _EvaluateVisitor0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _._async_evaluate$_importCache = t0;
      _._async_evaluate$_nodeImporter = t1;
      _._async_evaluate$_builtInFunctions = t2;
      _._async_evaluate$_builtInModules = t3;
      _._async_evaluate$_modules = t4;
      _._async_evaluate$_logger = t5;
      _._async_evaluate$_sourceMap = t6;
      _._async_evaluate$_environment = t7;
      _._async_evaluate$_declarationName = _._async_evaluate$_parent = _._async_evaluate$_mediaQueries = _._async_evaluate$_styleRule = null;
      _._async_evaluate$_member = "root stylesheet";
      _._async_evaluate$_importSpan = _._async_evaluate$_callableNode = null;
      _._async_evaluate$_inKeyframes = _._async_evaluate$_atRootExcludingStyleRule = _._async_evaluate$_inUnknownAtRule = _._async_evaluate$_inFunction = false;
      _._async_evaluate$_includedFiles = t8;
      _._async_evaluate$_activeModules = t9;
      _._async_evaluate$_stack = t10;
      _._async_evaluate$_extender = _._async_evaluate$_outOfOrderImports = _._async_evaluate$_endOfImports = _._async_evaluate$_root = _._async_evaluate$_stylesheet = _._async_evaluate$_importer = null;
      _._async_evaluate$_configuration = t11;
    },
    _EvaluateVisitor_closure9: function _EvaluateVisitor_closure9(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure10: function _EvaluateVisitor_closure10(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure11: function _EvaluateVisitor_closure11(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure12: function _EvaluateVisitor_closure12(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure13: function _EvaluateVisitor_closure13(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure14: function _EvaluateVisitor_closure14(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure15: function _EvaluateVisitor_closure15(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure16: function _EvaluateVisitor_closure16(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure8: function _EvaluateVisitor__closure8(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure17: function _EvaluateVisitor_closure17(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure6: function _EvaluateVisitor__closure6() {
    },
    _EvaluateVisitor__closure7: function _EvaluateVisitor__closure7() {
    },
    _EvaluateVisitor_closure18: function _EvaluateVisitor_closure18(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure4: function _EvaluateVisitor__closure4(t0, t1) {
      this.values = t0;
      this.span = t1;
    },
    _EvaluateVisitor__closure5: function _EvaluateVisitor__closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure0: function _EvaluateVisitor_run_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor__withWarnCallback_closure0: function _EvaluateVisitor__withWarnCallback_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__loadModule_closure0: function _EvaluateVisitor__loadModule_closure0(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeForSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__execute_closure0: function _EvaluateVisitor__execute_closure0(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.importer = t2;
      _.stylesheet = t3;
      _.extender = t4;
      _.configuration = t5;
    },
    _EvaluateVisitor__combineCss_closure2: function _EvaluateVisitor__combineCss_closure2() {
    },
    _EvaluateVisitor__combineCss_closure3: function _EvaluateVisitor__combineCss_closure3(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_closure4: function _EvaluateVisitor__combineCss_closure4() {
    },
    _EvaluateVisitor__extendModules_closure1: function _EvaluateVisitor__extendModules_closure1(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure2: function _EvaluateVisitor__extendModules_closure2() {
    },
    _EvaluateVisitor__topologicalModules_visitModule0: function _EvaluateVisitor__topologicalModules_visitModule0(t0, t1) {
      this.seen = t0;
      this.sorted = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure2: function _EvaluateVisitor_visitAtRootRule_closure2(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure3: function _EvaluateVisitor_visitAtRootRule_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure4: function _EvaluateVisitor_visitAtRootRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure5: function _EvaluateVisitor__scopeForAtRoot_closure5(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure6: function _EvaluateVisitor__scopeForAtRoot_closure6(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure7: function _EvaluateVisitor__scopeForAtRoot_closure7(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure0: function _EvaluateVisitor__scopeForAtRoot__closure0(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure8: function _EvaluateVisitor__scopeForAtRoot_closure8(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure9: function _EvaluateVisitor__scopeForAtRoot_closure9() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure10: function _EvaluateVisitor__scopeForAtRoot_closure10(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure0: function _EvaluateVisitor_visitContentRule_closure0(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure0: function _EvaluateVisitor_visitDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitEachRule_closure2: function _EvaluateVisitor_visitEachRule_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeForSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure3: function _EvaluateVisitor_visitEachRule_closure3(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeForSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure4: function _EvaluateVisitor_visitEachRule_closure4(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure0: function _EvaluateVisitor_visitEachRule__closure0(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure0: function _EvaluateVisitor_visitEachRule___closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitExtendRule_closure0: function _EvaluateVisitor_visitExtendRule_closure0(t0, t1) {
      this.$this = t0;
      this.targetText = t1;
    },
    _EvaluateVisitor_visitAtRule_closure1: function _EvaluateVisitor_visitAtRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRule__closure0: function _EvaluateVisitor_visitAtRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRule_closure2: function _EvaluateVisitor_visitAtRule_closure2() {
    },
    _EvaluateVisitor_visitForRule_closure4: function _EvaluateVisitor_visitForRule_closure4(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure5: function _EvaluateVisitor_visitForRule_closure5(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure6: function _EvaluateVisitor_visitForRule_closure6(t0, t1) {
      this.fromNumber = t0;
      this.toNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure7: function _EvaluateVisitor_visitForRule_closure7(t0) {
      this.toNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure8: function _EvaluateVisitor_visitForRule_closure8(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
    },
    _EvaluateVisitor_visitForRule__closure0: function _EvaluateVisitor_visitForRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure1: function _EvaluateVisitor_visitForwardRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure2: function _EvaluateVisitor_visitForwardRule_closure2(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__assertConfigurationIsEmpty_closure0: function _EvaluateVisitor__assertConfigurationIsEmpty_closure0(t0, t1, t2) {
      this.$this = t0;
      this.only = t1;
      this.nameInError = t2;
    },
    _EvaluateVisitor_visitIfRule_closure0: function _EvaluateVisitor_visitIfRule_closure0(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitIfRule__closure0: function _EvaluateVisitor_visitIfRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure0: function _EvaluateVisitor__visitDynamicImport_closure0(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure0: function _EvaluateVisitor__visitDynamicImport__closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.importer = t2;
      _.stylesheet = t3;
      _.environment = t4;
    },
    _EvaluateVisitor_visitIncludeRule_closure1: function _EvaluateVisitor_visitIncludeRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure2: function _EvaluateVisitor_visitIncludeRule_closure2(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitIncludeRule__closure0: function _EvaluateVisitor_visitIncludeRule__closure0(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitIncludeRule___closure0: function _EvaluateVisitor_visitIncludeRule___closure0(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitIncludeRule____closure0: function _EvaluateVisitor_visitIncludeRule____closure0(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure1: function _EvaluateVisitor_visitMediaRule_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitMediaRule__closure0: function _EvaluateVisitor_visitMediaRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure0: function _EvaluateVisitor_visitMediaRule___closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure2: function _EvaluateVisitor_visitMediaRule_closure2(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor__visitMediaQueries_closure0: function _EvaluateVisitor__visitMediaQueries_closure0(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure6: function _EvaluateVisitor_visitStyleRule_closure6(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure7: function _EvaluateVisitor_visitStyleRule_closure7(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure8: function _EvaluateVisitor_visitStyleRule_closure8() {
    },
    _EvaluateVisitor_visitStyleRule_closure9: function _EvaluateVisitor_visitStyleRule_closure9(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure10: function _EvaluateVisitor_visitStyleRule_closure10(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure11: function _EvaluateVisitor_visitStyleRule_closure11(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure0: function _EvaluateVisitor_visitStyleRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure12: function _EvaluateVisitor_visitStyleRule_closure12() {
    },
    _EvaluateVisitor_visitSupportsRule_closure1: function _EvaluateVisitor_visitSupportsRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure0: function _EvaluateVisitor_visitSupportsRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure2: function _EvaluateVisitor_visitSupportsRule_closure2() {
    },
    _EvaluateVisitor_visitVariableDeclaration_closure2: function _EvaluateVisitor_visitVariableDeclaration_closure2(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.override = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure3: function _EvaluateVisitor_visitVariableDeclaration_closure3(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure4: function _EvaluateVisitor_visitVariableDeclaration_closure4(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure0: function _EvaluateVisitor_visitUseRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure0: function _EvaluateVisitor_visitWarnRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure0: function _EvaluateVisitor_visitWhileRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure0: function _EvaluateVisitor_visitWhileRule__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure0: function _EvaluateVisitor_visitBinaryOperationExpression_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableExpression_closure0: function _EvaluateVisitor_visitVariableExpression_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitListExpression_closure0: function _EvaluateVisitor_visitListExpression_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure1: function _EvaluateVisitor_visitFunctionExpression_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.plainName = t2;
    },
    _EvaluateVisitor_visitFunctionExpression_closure2: function _EvaluateVisitor_visitFunctionExpression_closure2(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure0: function _EvaluateVisitor__runUserDefinedCallable_closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure0: function _EvaluateVisitor__runUserDefinedCallable__closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure0: function _EvaluateVisitor__runUserDefinedCallable___closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure0: function _EvaluateVisitor__runUserDefinedCallable____closure0() {
    },
    _EvaluateVisitor__runFunctionCallable_closure0: function _EvaluateVisitor__runFunctionCallable_closure0(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure1: function _EvaluateVisitor__runBuiltInCallable_closure1(t0, t1, t2) {
      this.overload = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure2: function _EvaluateVisitor__runBuiltInCallable_closure2() {
    },
    _EvaluateVisitor__evaluateArguments_closure2: function _EvaluateVisitor__evaluateArguments_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__evaluateArguments_closure3: function _EvaluateVisitor__evaluateArguments_closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__evaluateArguments_closure4: function _EvaluateVisitor__evaluateArguments_closure4(t0, t1, t2) {
      this.named = t0;
      this.namedNodes = t1;
      this.restNodeForSpan = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure3: function _EvaluateVisitor__evaluateMacroArguments_closure3() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure4: function _EvaluateVisitor__evaluateMacroArguments_closure4() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure5: function _EvaluateVisitor__evaluateMacroArguments_closure5(t0) {
      this.named = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure6: function _EvaluateVisitor__evaluateMacroArguments_closure6() {
    },
    _EvaluateVisitor__addRestMap_closure1: function _EvaluateVisitor__addRestMap_closure1(t0) {
      this.T = t0;
    },
    _EvaluateVisitor__addRestMap_closure2: function _EvaluateVisitor__addRestMap_closure2(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.values = t2;
      _.map = t3;
      _.nodeForSpan = t4;
    },
    _EvaluateVisitor__verifyArguments_closure0: function _EvaluateVisitor__verifyArguments_closure0(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitStringExpression_closure0: function _EvaluateVisitor_visitStringExpression_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitCssAtRule_closure1: function _EvaluateVisitor_visitCssAtRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure2: function _EvaluateVisitor_visitCssAtRule_closure2() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure1: function _EvaluateVisitor_visitCssKeyframeBlock_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure2: function _EvaluateVisitor_visitCssKeyframeBlock_closure2() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure1: function _EvaluateVisitor_visitCssMediaRule_closure1(t0, t1, t2) {
      this.$this = t0;
      this.mergedQueries = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssMediaRule__closure0: function _EvaluateVisitor_visitCssMediaRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure0: function _EvaluateVisitor_visitCssMediaRule___closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure2: function _EvaluateVisitor_visitCssMediaRule_closure2(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure1: function _EvaluateVisitor_visitCssStyleRule_closure1(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure0: function _EvaluateVisitor_visitCssStyleRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure2: function _EvaluateVisitor_visitCssStyleRule_closure2() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure1: function _EvaluateVisitor_visitCssSupportsRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure0: function _EvaluateVisitor_visitCssSupportsRule__closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure2: function _EvaluateVisitor_visitCssSupportsRule_closure2() {
    },
    _EvaluateVisitor__performInterpolation_closure0: function _EvaluateVisitor__performInterpolation_closure0(t0, t1) {
      this.$this = t0;
      this.warnForColor = t1;
    },
    _EvaluateVisitor__serialize_closure0: function _EvaluateVisitor__serialize_closure0(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__stackTrace_closure0: function _EvaluateVisitor__stackTrace_closure0(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor0: function _ImportedCssVisitor0(t0) {
      this._async_evaluate$_visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure0: function _ImportedCssVisitor_visitCssAtRule_closure0() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure0: function _ImportedCssVisitor_visitCssMediaRule_closure0(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure0: function _ImportedCssVisitor_visitCssStyleRule_closure0() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure0: function _ImportedCssVisitor_visitCssSupportsRule_closure0() {
    },
    EvaluateResult: function EvaluateResult(t0, t1) {
      this.stylesheet = t0;
      this.includedFiles = t1;
    },
    _ArgumentResults0: function _ArgumentResults0(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.positionalNodes = t1;
      _.named = t2;
      _.namedNodes = t3;
      _.separator = t4;
    },
    StringScannerException$: function(message, span, source) {
      return new E.StringScannerException(source, message, span);
    },
    StringScannerException: function StringScannerException(t0, t1, t2) {
      this._span_exception$_source = t0;
      this._span_exception$_message = t1;
      this._span = t2;
    },
    WatchEvent: function WatchEvent(t0, t1) {
      this.type = t0;
      this.path = t1;
    },
    ChangeType: function ChangeType(t0) {
      this._watch_event$_name = t0;
    }
  },
  F = {ValueResult: function ValueResult(t0, t1) {
      this.value = t0;
      this.$ti = t1;
    }, UrlStyle: function UrlStyle(t0, t1, t2, t3) {
      var _ = this;
      _.separatorPattern = t0;
      _.needsSeparatorPattern = t1;
      _.rootPattern = t2;
      _.relativeRootPattern = t3;
    },
    CssMediaQuery$: function(type, features, modifier) {
      return new F.CssMediaQuery(modifier, type, features == null ? C.List_empty : P.List_List$unmodifiable(features, P.String));
    },
    CssMediaQuery: function CssMediaQuery(t0, t1, t2) {
      this.modifier = t0;
      this.type = t1;
      this.features = t2;
    },
    _SingletonCssMediaQueryMergeResult: function _SingletonCssMediaQueryMergeResult(t0) {
      this._media_query$_name = t0;
    },
    MediaQuerySuccessfulMergeResult: function MediaQuerySuccessfulMergeResult(t0) {
      this.query = t0;
    },
    ModifiableCssImport$: function(url, span, media, supports) {
      return new F.ModifiableCssImport(url, supports, media == null ? null : P.List_List$unmodifiable(media, F.CssMediaQuery), span);
    },
    ModifiableCssImport: function ModifiableCssImport(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.supports = t1;
      _.media = t2;
      _.span = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ModifiableCssValue: function ModifiableCssValue(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    CssValue: function CssValue(t0, t1, t2) {
      this.value = t0;
      this.span = t1;
      this.$ti = t2;
    },
    FunctionExpression: function FunctionExpression(t0, t1, t2, t3) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.$arguments = t2;
      _.span = t3;
    },
    ValueExpression: function ValueExpression(t0, t1) {
      this.value = t0;
      this.span = t1;
    },
    Import: function Import() {
    },
    TypeSelector: function TypeSelector(t0) {
      this.name = t0;
    },
    main: function(args) {
      return F.main$body(args);
    },
    main$body: function(args) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(-1),
        $async$returnValue, $async$handler = 2, $async$currentError, $async$next = [], printError, graph, source, destination, error, stackTrace, error0, stackTrace0, error1, error2, stackTrace1, buffer, options, t1, t2, t3, t4, exception, _box_0, $async$exception, $async$exception1, $async$temp1;
      var $async$main = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              _box_0 = {};
              _box_0.printedError = false;
              printError = new F.main_printError(_box_0);
              _box_0.options = null;
              $async$handler = 4;
              options = B.ExecutableOptions_ExecutableOptions$parse(args);
              _box_0.options = options;
              t1 = options._options;
              $._glyphs = !(t1.wasParsed$1("unicode") ? H.boolTypeCast(t1.$index(0, "unicode")) : $._glyphs !== C.C_AsciiGlyphSet) ? C.C_AsciiGlyphSet : C.C_UnicodeGlyphSet;
              $async$goto = H.boolTypeCast(_box_0.options._options.$index(0, "version")) ? 7 : 8;
              break;
            case 7:
              // then
              $async$temp1 = P;
              $async$goto = 9;
              return P._asyncAwait(F._loadVersion(), $async$main);
            case 9:
              // returning from await.
              $async$temp1.print($async$result);
              self.process.exitCode = 0;
              // goto return
              $async$goto = 1;
              break;
            case 8:
              // join
              $async$goto = _box_0.options.get$interactive() ? 10 : 11;
              break;
            case 10:
              // then
              $async$goto = 12;
              return P._asyncAwait(Y.repl(_box_0.options), $async$main);
            case 12:
              // returning from await.
              // goto return
              $async$goto = 1;
              break;
            case 11:
              // join
              t1 = H.setRuntimeTypeInfo([], [M.Importer]);
              t2 = H.subtypeCast(_box_0.options._options.$index(0, "load-path"), "$isList", [P.String], "$asList");
              t3 = _box_0.options;
              t4 = P.Uri;
              graph = new M.StylesheetGraph(P.LinkedHashMap_LinkedHashMap$_empty(t4, M.StylesheetNode), R.ImportCache$(t1, t2, H.boolTypeCast(t3._options.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(t3.get$color())), P.LinkedHashMap_LinkedHashMap$_empty(t4, P.DateTime));
              $async$goto = H.boolTypeCast(_box_0.options._options.$index(0, "watch")) ? 13 : 14;
              break;
            case 13:
              // then
              $async$goto = 15;
              return P._asyncAwait(A.watch(_box_0.options, graph), $async$main);
            case 15:
              // returning from await.
              // goto return
              $async$goto = 1;
              break;
            case 14:
              // join
              t1 = _box_0.options, t1._ensureSources$0(), t1 = J.get$iterator$ax(t1._sourcesToDestinations.get$keys());
            case 16:
              // for condition
              if (!t1.moveNext$0()) {
                // goto after for
                $async$goto = 17;
                break;
              }
              source = t1.get$current(t1);
              t2 = _box_0.options;
              t2._ensureSources$0();
              destination = t2._sourcesToDestinations.$index(0, source);
              $async$handler = 19;
              t2 = _box_0.options;
              $async$goto = 22;
              return P._asyncAwait(D.compileStylesheet(t2, graph, source, destination, H.boolTypeCast(t2._options.$index(0, "update"))), $async$main);
            case 22:
              // returning from await.
              $async$handler = 4;
              // goto after finally
              $async$goto = 21;
              break;
            case 19:
              // catch
              $async$handler = 18;
              $async$exception = $async$currentError;
              t2 = H.unwrapException($async$exception);
              t3 = J.getInterceptor$(t2);
              if (!!t3.$isSassException) {
                error = t2;
                stackTrace = H.getTraceFromException($async$exception);
                new F.main_closure0(_box_0, destination).call$0();
                t2 = _box_0.options._options;
                if (t2._parser.options._collection$_map.$index(0, "color") == null)
                  H.throwExpression(P.ArgumentError$('Could not find an option named "color".'));
                if (t2._parsed.containsKey$1("color"))
                  t2 = H.boolTypeCast(t2.$index(0, "color"));
                else {
                  t2 = self.process.stdout.isTTY;
                  if (t2 == null)
                    t2 = false;
                }
                t2 = J.toString$1$color$(error, t2);
                t3 = H.boolTypeCast(_box_0.options._options.$index(0, "trace")) ? stackTrace : null;
                printError.call$2(t2, t3);
                if (!J.$eq$(self.process.exitCode, 66))
                  self.process.exitCode = 65;
                if (H.boolTypeCast(_box_0.options._options.$index(0, "stop-on-error"))) {
                  // goto return
                  $async$goto = 1;
                  break;
                }
              } else if (!!t3.$isFileSystemException) {
                error0 = t2;
                stackTrace0 = H.getTraceFromException($async$exception);
                t2 = error0.path;
                t2 = "Error reading " + H.S($.$get$context().relative$2$from(t2, null)) + ": " + error0.message + ".";
                t3 = H.boolTypeCast(_box_0.options._options.$index(0, "trace")) ? stackTrace0 : null;
                printError.call$2(t2, t3);
                self.process.exitCode = 66;
                if (H.boolTypeCast(_box_0.options._options.$index(0, "stop-on-error"))) {
                  // goto return
                  $async$goto = 1;
                  break;
                }
              } else
                throw $async$exception;
              // goto after finally
              $async$goto = 21;
              break;
            case 18:
              // uncaught
              // goto catch
              $async$goto = 4;
              break;
            case 21:
              // after finally
              // goto for condition
              $async$goto = 16;
              break;
            case 17:
              // after for
              $async$handler = 2;
              // goto after finally
              $async$goto = 6;
              break;
            case 4:
              // catch
              $async$handler = 3;
              $async$exception1 = $async$currentError;
              t1 = H.unwrapException($async$exception1);
              if (t1 instanceof B.UsageException) {
                error1 = t1;
                P.print(H.S(error1.message) + "\n");
                P.print("Usage: sass <input.scss> [output.css]\n       sass <input.scss>:<output.css> <input/>:<output/> <dir/>\n");
                t1 = $.$get$ExecutableOptions__parser();
                P.print(new G.Usage(t1._optionsAndSeparators, t1.usageLineLength).generate$0());
                self.process.exitCode = 64;
              } else {
                error2 = t1;
                stackTrace1 = H.getTraceFromException($async$exception1);
                buffer = new P.StringBuffer("");
                t1 = _box_0.options;
                if (t1 != null && t1.get$color())
                  buffer._contents += "\x1b[31m\x1b[1m";
                buffer._contents += "Unexpected exception:";
                t1 = _box_0.options;
                if (t1 != null && t1.get$color())
                  buffer._contents += "\x1b[0m";
                buffer._contents += "\n";
                buffer._contents += H.S(error2) + "\n";
                t1 = buffer._contents;
                printError.call$2(t1.charCodeAt(0) == 0 ? t1 : t1, stackTrace1);
                self.process.exitCode = 255;
              }
              // goto after finally
              $async$goto = 6;
              break;
            case 3:
              // uncaught
              // goto rethrow
              $async$goto = 2;
              break;
            case 6:
              // after finally
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
            case 2:
              // rethrow
              return P._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return P._asyncStartSync($async$main, $async$completer);
    },
    _loadVersion: function() {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(P.String),
        $async$returnValue;
      var $async$_loadVersion = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$returnValue = "1.24.3 compiled with dart2js 2.7.0";
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_loadVersion, $async$completer);
    },
    main_printError: function main_printError(t0) {
      this._box_0 = t0;
    },
    main_closure0: function main_closure0(t0, t1) {
      this._box_0 = t0;
      this.destination = t1;
    },
    Extender__extendOrReplace: function(selector, source, targets, mode) {
      var t2, t3, t4, _i, complex, t5, t6, t7, _i0, extender, _null = null,
        t1 = source.components,
        map = P.LinkedHashMap_LinkedHashMap(_null, _null, _null, S.ComplexSelector, S.Extension);
      P.MapBase__fillMapWithMappedIterable(map, t1, _null, new F.Extender__extendOrReplace_closure());
      for (t1 = targets.components, t2 = t1.length, t3 = M.SimpleSelector, t4 = [P.Map, S.ComplexSelector, S.Extension], _i = 0; _i < t2; ++_i) {
        complex = t1[_i];
        t5 = complex.components;
        if (t5.length !== 1)
          throw H.wrapException(E.SassScriptException$("Can't extend complex selector " + H.S(complex) + "."));
        t6 = P.LinkedHashMap_LinkedHashMap$_empty(t3, t4);
        for (t5 = H.interceptedTypeCast(C.JSArray_methods.get$first(t5), "$isCompoundSelector").components, t7 = t5.length, _i0 = 0; _i0 < t7; ++_i0)
          t6.$indexSet(0, t5[_i0], map);
        extender = F.Extender$_mode(mode);
        if (!selector.get$isInvisible())
          extender._originals.addAll$1(0, selector.components);
        selector = extender._extendList$3(selector, t6, _null);
      }
      return selector;
    },
    Extender$_mode: function(_mode) {
      var t1 = M.SimpleSelector;
      return new F.Extender(P.LinkedHashMap_LinkedHashMap$_empty(t1, [P.Set, [F.ModifiableCssValue, D.SelectorList]]), P.LinkedHashMap_LinkedHashMap$_empty(t1, [P.Map, S.ComplexSelector, S.Extension]), P.LinkedHashMap_LinkedHashMap$_empty(t1, [P.List, S.Extension]), P.LinkedHashMap_LinkedHashMap$_empty([F.ModifiableCssValue, D.SelectorList], [P.List, F.CssMediaQuery]), P._LinkedIdentityHashMap__LinkedIdentityHashMap$es6(t1, P.int), new P._LinkedIdentityHashSet([S.ComplexSelector]), _mode);
    },
    Extender: function Extender(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._selectors = t0;
      _._extensions = t1;
      _._extensionsByExtender = t2;
      _._mediaContexts = t3;
      _._sourceSpecificity = t4;
      _._originals = t5;
      _._mode = t6;
    },
    Extender__extendOrReplace_closure: function Extender__extendOrReplace_closure() {
    },
    Extender_extensionsWhereTarget_closure: function Extender_extensionsWhereTarget_closure() {
    },
    Extender__registerSelector_closure: function Extender__registerSelector_closure() {
    },
    Extender_addExtension_closure: function Extender_addExtension_closure() {
    },
    Extender_addExtension_closure0: function Extender_addExtension_closure0() {
    },
    Extender_addExtension_closure1: function Extender_addExtension_closure1(t0) {
      this.complex = t0;
    },
    Extender__extendExistingExtensions_closure: function Extender__extendExistingExtensions_closure() {
    },
    Extender__extendExistingExtensions_closure0: function Extender__extendExistingExtensions_closure0() {
    },
    Extender_addExtensions_closure: function Extender_addExtensions_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.extender = t2;
    },
    Extender_addExtensions__closure: function Extender_addExtensions__closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.existingSources = t1;
      _.extensionsForTarget = t2;
      _.selectorsForTarget = t3;
      _.target = t4;
    },
    Extender_addExtensions___closure: function Extender_addExtensions___closure() {
    },
    Extender_addExtensions___closure0: function Extender_addExtensions___closure0(t0) {
      this.extension = t0;
    },
    Extender__extendList_closure: function Extender__extendList_closure() {
    },
    Extender__extendComplex_closure: function Extender__extendComplex_closure(t0) {
      this.complex = t0;
    },
    Extender__extendComplex_closure0: function Extender__extendComplex_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.complex = t2;
    },
    Extender__extendComplex__closure: function Extender__extendComplex__closure() {
    },
    Extender__extendComplex__closure0: function Extender__extendComplex__closure0(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.complex = t2;
      _.path = t3;
    },
    Extender__extendComplex___closure: function Extender__extendComplex___closure() {
    },
    Extender__extendCompound_closure: function Extender__extendCompound_closure(t0) {
      this.mediaQueryContext = t0;
    },
    Extender__extendCompound_closure0: function Extender__extendCompound_closure0(t0, t1) {
      this._box_1 = t0;
      this.mediaQueryContext = t1;
    },
    Extender__extendCompound__closure: function Extender__extendCompound__closure() {
    },
    Extender__extendCompound__closure0: function Extender__extendCompound__closure0(t0) {
      this._box_0 = t0;
    },
    Extender__extendCompound_closure1: function Extender__extendCompound_closure1() {
    },
    Extender__extendCompound_closure2: function Extender__extendCompound_closure2() {
    },
    Extender__extendSimple_withoutPseudo: function Extender__extendSimple_withoutPseudo(t0, t1, t2) {
      this.$this = t0;
      this.extensions = t1;
      this.targetsUsed = t2;
    },
    Extender__extendSimple_closure: function Extender__extendSimple_closure(t0, t1) {
      this.$this = t0;
      this.withoutPseudo = t1;
    },
    Extender__extendPseudo_closure: function Extender__extendPseudo_closure() {
    },
    Extender__extendPseudo_closure0: function Extender__extendPseudo_closure0() {
    },
    Extender__extendPseudo_closure1: function Extender__extendPseudo_closure1() {
    },
    Extender__extendPseudo_closure2: function Extender__extendPseudo_closure2(t0) {
      this.pseudo = t0;
    },
    Extender__extendPseudo_closure3: function Extender__extendPseudo_closure3(t0) {
      this.pseudo = t0;
    },
    Extender__trim_closure: function Extender__trim_closure(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    Extender__trim_closure0: function Extender__trim_closure0(t0, t1) {
      this._box_0 = t0;
      this.complex1 = t1;
    },
    Extender_clone_closure: function Extender_clone_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.newSelectors = t1;
      _.oldToNewSelectors = t2;
      _.newMediaContexts = t3;
    },
    FilesystemImporter: function FilesystemImporter(t0) {
      this._loadPath = t0;
    },
    NodeImporter__addSassPath: function($async$includePaths) {
      return P._makeSyncStarIterable(function() {
        var includePaths = $async$includePaths;
        var $async$goto = 0, $async$handler = 2, $async$currentError, sassPath;
        return function $async$NodeImporter__addSassPath($async$errorCode, $async$result) {
          if ($async$errorCode === 1) {
            $async$currentError = $async$result;
            $async$goto = $async$handler;
          }
          while (true)
            switch ($async$goto) {
              case 0:
                // Function start
                $async$goto = 3;
                return P._IterationMarker_yieldStar(includePaths);
              case 3:
                // after yield
                sassPath = H.stringTypeCast(J.get$env$x(self.process).SASS_PATH);
                if (sassPath == null) {
                  // goto return
                  $async$goto = 1;
                  break;
                }
                $async$goto = 4;
                return P._IterationMarker_yieldStar(H.setRuntimeTypeInfo(sassPath.split(J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":"), [P.String]));
              case 4:
                // after yield
              case 1:
                // return
                return P._IterationMarker_endOfIteration();
              case 2:
                // rethrow
                return P._IterationMarker_uncaughtError($async$currentError);
            }
        };
      }, P.String);
    },
    NodeImporter: function NodeImporter(t0, t1, t2) {
      this._implementation$_context = t0;
      this._includePaths = t1;
      this._implementation$_importers = t2;
    },
    NodeImporter__tryPath_closure: function NodeImporter__tryPath_closure(t0) {
      this.path = t0;
    },
    realCasePath: function(path) {
      var t1, basename, matches;
      if (!(J.$eq$(J.get$platform$x(self.process), "win32") || J.$eq$(J.get$platform$x(self.process), "darwin")))
        return path;
      t1 = $.$get$context();
      basename = X.ParsedPath_ParsedPath$parse(path, t1.style).get$basename();
      matches = J.where$1$ax(B.listDir(t1.dirname$1(path), false), new F.realCasePath_closure(basename)).toList$0(0);
      if (matches.length !== 1)
        return path;
      return C.JSArray_methods.get$first(matches);
    },
    realCasePath_closure: function realCasePath_closure(t0) {
      this.basename = t0;
    },
    _QuietLogger: function _QuietLogger() {
    },
    JSFunction: function JSFunction() {
    },
    NodeImporterResult: function NodeImporterResult() {
    },
    MediaQueryParser: function MediaQueryParser(t0, t1) {
      this.scanner = t0;
      this.logger = t1;
    },
    MediaQueryParser_parse_closure: function MediaQueryParser_parse_closure(t0) {
      this.$this = t0;
    },
    PrefixedMapView: function PrefixedMapView(t0, t1, t2) {
      this._prefixed_map_view$_map = t0;
      this._prefix = t1;
      this.$ti = t2;
    },
    _PrefixedKeys: function _PrefixedKeys(t0) {
      this._view = t0;
    },
    _PrefixedKeys_iterator_closure: function _PrefixedKeys_iterator_closure(t0) {
      this.$this = t0;
    },
    Value: function Value() {
    },
    SassFunction: function SassFunction(t0) {
      this.callable = t0;
    },
    _FindDependenciesVisitor: function _FindDependenciesVisitor(t0, t1) {
      this._usesAndForwards = t0;
      this._imports = t1;
    },
    unwrapValue: function(object) {
      var value;
      if (object != null) {
        if (object instanceof F.Value)
          return object;
        value = object.dartValue;
        if (value != null && value instanceof F.Value)
          return value;
        if (object instanceof self.Error)
          throw H.wrapException(object);
      }
      throw H.wrapException(H.S(object) + " must be a Sass value type.");
    },
    wrapValue: function(value) {
      var t1 = J.getInterceptor$(value);
      if (!!t1.$isSassColor)
        return P.callConstructor($.$get$colorConstructor(), [null, null, null, null, value]);
      if (!!t1.$isSassList)
        return P.callConstructor($.$get$listConstructor(), [null, null, value]);
      if (!!t1.$isSassMap)
        return P.callConstructor($.$get$mapConstructor(), [null, value]);
      if (!!t1.$isSassNumber)
        return P.callConstructor($.$get$numberConstructor(), [null, null, value]);
      if (!!t1.$isSassString)
        return P.callConstructor($.$get$stringConstructor(), [null, value]);
      return value;
    }
  },
  Y = {StreamCompleter: function StreamCompleter(t0, t1) {
      this._stream_completer$_stream = t0;
      this.$ti = t1;
    }, _CompleterStream: function _CompleterStream(t0) {
      this._sourceStream = this._stream_completer$_controller = null;
      this.$ti = t0;
    },
    mapMap: function(map, key, value, K1, V1, K2, V2) {
      var result, t1 = {};
      t1.key = key;
      t1.value = value;
      if (key == null)
        t1.key = new Y.mapMap_closure(K2, K1, V1);
      if (value == null)
        t1.value = new Y.mapMap_closure0(V2, K1, V1);
      result = P.LinkedHashMap_LinkedHashMap$_empty(K2, V2);
      map.forEach$1(0, new Y.mapMap_closure1(t1, result, K1, V1));
      return result;
    },
    minBy: function(values, orderBy, $S, $T) {
      var t1, minValue, minOrderBy, element, elementOrderBy,
        compare = B.defaultCompare($T);
      for (t1 = new H.MappedIterator(J.get$iterator$ax(values.__internal$_iterable), values._f), minValue = null, minOrderBy = null; t1.moveNext$0();) {
        element = t1.__internal$_current;
        elementOrderBy = orderBy.call$1(element);
        if (minOrderBy == null || compare.call$2(elementOrderBy, minOrderBy) < 0) {
          minOrderBy = elementOrderBy;
          minValue = element;
        }
      }
      return minValue;
    },
    mapMap_closure: function mapMap_closure(t0, t1, t2) {
      this.K2 = t0;
      this.K1 = t1;
      this.V1 = t2;
    },
    mapMap_closure0: function mapMap_closure0(t0, t1, t2) {
      this.V2 = t0;
      this.K1 = t1;
      this.V1 = t2;
    },
    mapMap_closure1: function mapMap_closure1(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.result = t1;
      _.K1 = t2;
      _.V1 = t3;
    },
    ContentBlock: function ContentBlock(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    WarnRule: function WarnRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    unifyComplex: function(complexes) {
      var t2, unifiedBase, base, t3, t4, _i, complexesWithoutBases,
        t1 = J.getInterceptor$asx(complexes);
      if (t1.get$length(complexes) === 1)
        return complexes;
      for (t2 = t1.get$iterator(complexes), unifiedBase = null; t2.moveNext$0();) {
        base = J.get$last$ax(t2.get$current(t2));
        if (base instanceof X.CompoundSelector)
          if (unifiedBase == null)
            unifiedBase = base.components;
          else
            for (t3 = base.components, t4 = t3.length, _i = 0; _i < t4; ++_i) {
              unifiedBase = t3[_i].unify$1(unifiedBase);
              if (unifiedBase == null)
                return;
            }
        else
          return;
      }
      complexesWithoutBases = t1.map$1$1(complexes, new Y.unifyComplex_closure(), [P.List, S.ComplexSelectorComponent]).toList$0(0);
      J.add$1$ax(C.JSArray_methods.get$last(complexesWithoutBases), X.CompoundSelector$(unifiedBase));
      return Y.weave(complexesWithoutBases);
    },
    unifyCompound: function(compound1, compound2) {
      var t1, result, _i;
      for (t1 = compound1.length, result = compound2, _i = 0; _i < t1; ++_i) {
        result = compound1[_i].unify$1(result);
        if (result == null)
          return;
      }
      return X.CompoundSelector$(result);
    },
    unifyUniversalAndElement: function(selector1, selector2) {
      var namespace1, name1, t1, namespace2, name2, namespace, $name,
        _s45_ = "must be a UniversalSelector or a TypeSelector";
      if (!!selector1.$isUniversalSelector) {
        namespace1 = selector1.namespace;
        name1 = null;
      } else if (!!selector1.$isTypeSelector) {
        t1 = selector1.name;
        namespace1 = t1.namespace;
        name1 = t1.name;
      } else
        throw H.wrapException(P.ArgumentError$value(selector1, "selector1", _s45_));
      t1 = J.getInterceptor$(selector2);
      if (!!t1.$isUniversalSelector) {
        namespace2 = selector2.namespace;
        name2 = null;
      } else if (!!t1.$isTypeSelector) {
        t1 = selector2.name;
        namespace2 = t1.namespace;
        name2 = t1.name;
      } else
        throw H.wrapException(P.ArgumentError$value(selector2, "selector2", _s45_));
      if (namespace1 == namespace2 || namespace2 === "*")
        namespace = namespace1;
      else {
        if (namespace1 !== "*")
          return;
        namespace = namespace2;
      }
      if (name1 == name2 || name2 == null)
        $name = name1;
      else {
        if (!(name1 == null || name1 === "*"))
          return;
        $name = name2;
      }
      return $name == null ? new N.UniversalSelector(namespace) : new F.TypeSelector(new D.QualifiedName($name, namespace));
    },
    weave: function(complexes) {
      var t2, t3, t4, target, _i, parents, newPrefixes, parentPrefixes, t5,
        t1 = [[P.List, S.ComplexSelectorComponent]],
        prefixes = H.setRuntimeTypeInfo([J.toList$0$ax(C.JSArray_methods.get$first(complexes))], t1);
      for (t2 = H.SubListIterable$(complexes, 1, null, H.getTypeArgumentByIndex(complexes, 0)), t2 = new H.ListIterator(t2, t2.get$length(t2)); t2.moveNext$0();) {
        t3 = t2.__internal$_current;
        t4 = J.getInterceptor$asx(t3);
        if (t4.get$isEmpty(t3))
          continue;
        target = t4.get$last(t3);
        if (t4.get$length(t3) === 1) {
          for (t3 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t3 || (0, H.throwConcurrentModificationError)(prefixes), ++_i)
            J.add$1$ax(prefixes[_i], target);
          continue;
        }
        parents = t4.take$1(t3, t4.get$length(t3) - 1).toList$0(0);
        newPrefixes = H.setRuntimeTypeInfo([], t1);
        for (t3 = prefixes.length, _i = 0; _i < prefixes.length; prefixes.length === t3 || (0, H.throwConcurrentModificationError)(prefixes), ++_i) {
          parentPrefixes = Y._weaveParents(prefixes[_i], parents);
          if (parentPrefixes == null)
            continue;
          for (t4 = parentPrefixes.get$iterator(parentPrefixes); t4.moveNext$0();) {
            t5 = t4.get$current(t4);
            J.add$1$ax(t5, target);
            newPrefixes.push(t5);
          }
        }
        prefixes = newPrefixes;
      }
      return prefixes;
    },
    _weaveParents: function(parents1, parents2) {
      var finalCombinators, root1, root2, root, groups1, groups2, lcs, t2, t3, choices, t4, _i, group, t5,
        t1 = S.ComplexSelectorComponent,
        queue1 = P.ListQueue_ListQueue$of(parents1, t1),
        queue2 = P.ListQueue_ListQueue$of(parents2, t1),
        initialCombinators = Y._mergeInitialCombinators(queue1, queue2);
      if (initialCombinators == null)
        return;
      finalCombinators = Y._mergeFinalCombinators(queue1, queue2, null);
      if (finalCombinators == null)
        return;
      root1 = Y._firstIfRoot(queue1);
      root2 = Y._firstIfRoot(queue2);
      t1 = root1 != null;
      if (t1 && root2 != null) {
        root = Y.unifyCompound(root1.components, root2.components);
        if (root == null)
          return;
        queue1.addFirst$1(root);
        queue2.addFirst$1(root);
      } else if (t1)
        queue2.addFirst$1(root1);
      else if (root2 != null)
        queue1.addFirst$1(root2);
      groups1 = Y._groupSelectors(queue1);
      groups2 = Y._groupSelectors(queue2);
      t1 = [P.List, S.ComplexSelectorComponent];
      lcs = B.longestCommonSubsequence(groups2, groups1, new Y._weaveParents_closure(), t1);
      t2 = [P.Iterable, S.ComplexSelectorComponent];
      t3 = [t2];
      choices = H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([initialCombinators], t3)], [[P.List, [P.Iterable, S.ComplexSelectorComponent]]]);
      for (t4 = lcs.length, _i = 0; _i < lcs.length; lcs.length === t4 || (0, H.throwConcurrentModificationError)(lcs), ++_i) {
        group = lcs[_i];
        t5 = Y._chunks(groups1, groups2, new Y._weaveParents_closure0(group), t1);
        choices.push(new H.MappedListIterable(t5, new Y._weaveParents_closure1(), [H.getTypeArgumentByIndex(t5, 0), t2]).toList$0(0));
        choices.push(H.setRuntimeTypeInfo([group], t3));
        groups1.removeFirst$0();
        groups2.removeFirst$0();
      }
      t3 = Y._chunks(groups1, groups2, new Y._weaveParents_closure2(), t1);
      choices.push(new H.MappedListIterable(t3, new Y._weaveParents_closure3(), [H.getTypeArgumentByIndex(t3, 0), t2]).toList$0(0));
      C.JSArray_methods.addAll$1(choices, finalCombinators);
      return J.map$1$1$ax(Y.paths(new H.WhereIterable(choices, new Y._weaveParents_closure4(), [H.getTypeArgumentByIndex(choices, 0)]), t2), new Y._weaveParents_closure5(), t1);
    },
    _firstIfRoot: function(queue) {
      var first;
      if (queue._collection$_head === queue._collection$_tail)
        return;
      first = queue.get$first(queue);
      if (first instanceof X.CompoundSelector) {
        if (!Y._hasRoot(first))
          return;
        queue.removeFirst$0();
        return first;
      } else
        return;
    },
    _mergeInitialCombinators: function(components1, components2) {
      var t3, combinators2, lcs,
        t1 = S.Combinator,
        t2 = [t1],
        combinators1 = H.setRuntimeTypeInfo([], t2);
      while (true) {
        if (!components1.get$isEmpty(components1)) {
          t3 = components1._collection$_head;
          if (t3 === components1._collection$_tail)
            H.throwExpression(H.IterableElementError_noElement());
          t3 = components1._collection$_table[t3] instanceof S.Combinator;
        } else
          t3 = false;
        if (!t3)
          break;
        combinators1.push(H.interceptedTypeCast(components1.removeFirst$0(), "$isCombinator"));
      }
      combinators2 = H.setRuntimeTypeInfo([], t2);
      while (true) {
        if (!components2.get$isEmpty(components2)) {
          t2 = components2._collection$_head;
          if (t2 === components2._collection$_tail)
            H.throwExpression(H.IterableElementError_noElement());
          t2 = components2._collection$_table[t2] instanceof S.Combinator;
        } else
          t2 = false;
        if (!t2)
          break;
        combinators2.push(H.interceptedTypeCast(components2.removeFirst$0(), "$isCombinator"));
      }
      lcs = B.longestCommonSubsequence(combinators1, combinators2, null, t1);
      if (C.C_ListEquality.equals$2(lcs, combinators1))
        return combinators2;
      if (C.C_ListEquality.equals$2(lcs, combinators2))
        return combinators1;
      return;
    },
    _mergeFinalCombinators: function(components1, components2, result) {
      var t1, t2, combinators1, combinators2, lcs, combinator1, combinator2, compound1, compound2, choices, unified, followingSiblingSelector, nextSiblingSelector, _null = null;
      if (result == null)
        result = Q.QueueList$(_null, [P.List, [P.List, S.ComplexSelectorComponent]]);
      if (components1._collection$_head === components1._collection$_tail || !(components1.get$last(components1) instanceof S.Combinator))
        t1 = components2._collection$_head === components2._collection$_tail || !(components2.get$last(components2) instanceof S.Combinator);
      else
        t1 = false;
      if (t1)
        return result;
      t1 = S.Combinator;
      t2 = [t1];
      combinators1 = H.setRuntimeTypeInfo([], t2);
      while (true) {
        if (!(!components1.get$isEmpty(components1) && components1.get$last(components1) instanceof S.Combinator))
          break;
        combinators1.push(H.interceptedTypeCast(components1.removeLast$0(0), "$isCombinator"));
      }
      combinators2 = H.setRuntimeTypeInfo([], t2);
      while (true) {
        if (!(!components2.get$isEmpty(components2) && components2.get$last(components2) instanceof S.Combinator))
          break;
        combinators2.push(H.interceptedTypeCast(components2.removeLast$0(0), "$isCombinator"));
      }
      t2 = combinators1.length;
      if (t2 > 1 || combinators2.length > 1) {
        lcs = B.longestCommonSubsequence(combinators1, combinators2, _null, t1);
        if (C.C_ListEquality.equals$2(lcs, combinators1))
          result.addFirst$1(H.setRuntimeTypeInfo([P.List_List$from(new H.ReversedListIterable(combinators2, [H.getTypeArgumentByIndex(combinators2, 0)]), true, S.ComplexSelectorComponent)], [[P.List, S.ComplexSelectorComponent]]));
        else if (C.C_ListEquality.equals$2(lcs, combinators2))
          result.addFirst$1(H.setRuntimeTypeInfo([P.List_List$from(new H.ReversedListIterable(combinators1, [H.getTypeArgumentByIndex(combinators1, 0)]), true, S.ComplexSelectorComponent)], [[P.List, S.ComplexSelectorComponent]]));
        else
          return;
        return result;
      }
      combinator1 = t2 === 0 ? _null : C.JSArray_methods.get$first(combinators1);
      combinator2 = combinators2.length === 0 ? _null : C.JSArray_methods.get$first(combinators2);
      t1 = combinator1 != null;
      if (t1 && combinator2 != null) {
        compound1 = H.interceptedTypeCast(components1.removeLast$0(0), "$isCompoundSelector");
        compound2 = H.interceptedTypeCast(components2.removeLast$0(0), "$isCompoundSelector");
        t1 = combinator1 === C.Combinator_CzM;
        if (t1 && combinator2 === C.Combinator_CzM) {
          compound1.toString;
          if (Y.compoundIsSuperselector(compound1, compound2, _null))
            result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([compound2, C.Combinator_CzM], [S.ComplexSelectorComponent])], [[P.List, S.ComplexSelectorComponent]]));
          else {
            compound2.toString;
            t1 = [S.ComplexSelectorComponent];
            t2 = [[P.List, S.ComplexSelectorComponent]];
            if (Y.compoundIsSuperselector(compound2, compound1, _null))
              result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([compound1, C.Combinator_CzM], t1)], t2));
            else {
              choices = H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([compound1, C.Combinator_CzM, compound2, C.Combinator_CzM], t1), H.setRuntimeTypeInfo([compound2, C.Combinator_CzM, compound1, C.Combinator_CzM], t1)], t2);
              unified = Y.unifyCompound(compound1.components, compound2.components);
              if (unified != null)
                choices.push(H.setRuntimeTypeInfo([unified, C.Combinator_CzM], t1));
              result.addFirst$1(choices);
            }
          }
        } else {
          if (!(t1 && combinator2 === C.Combinator_uzg))
            t2 = combinator1 === C.Combinator_uzg && combinator2 === C.Combinator_CzM;
          else
            t2 = true;
          if (t2) {
            followingSiblingSelector = t1 ? compound1 : compound2;
            nextSiblingSelector = t1 ? compound2 : compound1;
            followingSiblingSelector.toString;
            t1 = [S.ComplexSelectorComponent];
            t2 = [[P.List, S.ComplexSelectorComponent]];
            if (Y.compoundIsSuperselector(followingSiblingSelector, nextSiblingSelector, _null))
              result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([nextSiblingSelector, C.Combinator_uzg], t1)], t2));
            else {
              unified = Y.unifyCompound(compound1.components, compound2.components);
              t2 = H.setRuntimeTypeInfo([], t2);
              t2.push(H.setRuntimeTypeInfo([followingSiblingSelector, C.Combinator_CzM, nextSiblingSelector, C.Combinator_uzg], t1));
              if (unified != null)
                t2.push(H.setRuntimeTypeInfo([unified, C.Combinator_uzg], t1));
              result.addFirst$1(t2);
            }
          } else {
            if (combinator1 === C.Combinator_sgq)
              t2 = combinator2 === C.Combinator_uzg || combinator2 === C.Combinator_CzM;
            else
              t2 = false;
            if (t2) {
              result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([compound2, combinator2], [S.ComplexSelectorComponent])], [[P.List, S.ComplexSelectorComponent]]));
              components1._collection$_add$1(compound1);
              components1._collection$_add$1(C.Combinator_sgq);
            } else {
              if (combinator2 === C.Combinator_sgq)
                t1 = combinator1 === C.Combinator_uzg || t1;
              else
                t1 = false;
              if (t1) {
                result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([compound1, combinator1], [S.ComplexSelectorComponent])], [[P.List, S.ComplexSelectorComponent]]));
                components2._collection$_add$1(compound2);
                components2._collection$_add$1(C.Combinator_sgq);
              } else if (combinator1 === combinator2) {
                unified = Y.unifyCompound(compound1.components, compound2.components);
                if (unified == null)
                  return;
                result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([unified, combinator1], [S.ComplexSelectorComponent])], [[P.List, S.ComplexSelectorComponent]]));
              } else
                return;
            }
          }
        }
        return Y._mergeFinalCombinators(components1, components2, result);
      } else if (t1) {
        if (combinator1 === C.Combinator_sgq)
          if (!components2.get$isEmpty(components2)) {
            t1 = H.interceptedTypeCast(components2.get$last(components2), "$isCompoundSelector");
            t2 = H.interceptedTypeCast(components1.get$last(components1), "$isCompoundSelector");
            t1.toString;
            t2 = Y.compoundIsSuperselector(t1, t2, _null);
            t1 = t2;
          } else
            t1 = false;
        else
          t1 = false;
        if (t1)
          components2.removeLast$0(0);
        result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([components1.removeLast$0(0), combinator1], [S.ComplexSelectorComponent])], [[P.List, S.ComplexSelectorComponent]]));
        return Y._mergeFinalCombinators(components1, components2, result);
      } else {
        if (combinator2 === C.Combinator_sgq)
          if (!components1.get$isEmpty(components1)) {
            t1 = H.interceptedTypeCast(components1.get$last(components1), "$isCompoundSelector");
            t2 = H.interceptedTypeCast(components2.get$last(components2), "$isCompoundSelector");
            t1.toString;
            t2 = Y.compoundIsSuperselector(t1, t2, _null);
            t1 = t2;
          } else
            t1 = false;
        else
          t1 = false;
        if (t1)
          components1.removeLast$0(0);
        result.addFirst$1(H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([components2.removeLast$0(0), combinator2], [S.ComplexSelectorComponent])], [[P.List, S.ComplexSelectorComponent]]));
        return Y._mergeFinalCombinators(components1, components2, result);
      }
    },
    _mustUnify: function(complex1, complex2) {
      var t2, t3, t4,
        t1 = P.LinkedHashSet_LinkedHashSet(M.SimpleSelector);
      for (t2 = J.get$iterator$ax(complex1); t2.moveNext$0();) {
        t3 = t2.get$current(t2);
        if (t3 instanceof X.CompoundSelector)
          for (t3 = C.JSArray_methods.get$iterator(t3.components), t4 = new H.WhereIterator(t3, Y.functions___isUnique$closure()); t4.moveNext$0();)
            t1.add$1(0, t3.get$current(t3));
      }
      if (t1._collection$_length === 0)
        return false;
      return J.any$1$ax(complex2, new Y._mustUnify_closure(t1));
    },
    _isUnique: function(simple) {
      var t1 = J.getInterceptor$(simple);
      if (!t1.$isIDSelector)
        t1 = !!t1.$isPseudoSelector && !simple.isClass;
      else
        t1 = true;
      return t1;
    },
    _chunks: function(queue1, queue2, done, $T) {
      var chunk2, t2, t3, _i,
        t1 = [$T],
        chunk1 = H.setRuntimeTypeInfo([], t1);
      for (; !done.call$1(queue1);)
        chunk1.push(queue1.removeFirst$0());
      chunk2 = H.setRuntimeTypeInfo([], t1);
      for (; !done.call$1(queue2);)
        chunk2.push(queue2.removeFirst$0());
      t2 = chunk1.length === 0;
      if (t2 && chunk2.length === 0)
        return H.setRuntimeTypeInfo([], [[P.List, $T]]);
      if (t2)
        return H.setRuntimeTypeInfo([chunk2], [[P.List, $T]]);
      if (chunk2.length === 0)
        return H.setRuntimeTypeInfo([chunk1], [[P.List, $T]]);
      t2 = H.setRuntimeTypeInfo([], t1);
      for (t3 = chunk1.length, _i = 0; _i < chunk1.length; chunk1.length === t3 || (0, H.throwConcurrentModificationError)(chunk1), ++_i)
        t2.push(chunk1[_i]);
      for (t3 = chunk2.length, _i = 0; _i < chunk2.length; chunk2.length === t3 || (0, H.throwConcurrentModificationError)(chunk2), ++_i)
        t2.push(chunk2[_i]);
      t1 = H.setRuntimeTypeInfo([], t1);
      for (t3 = chunk2.length, _i = 0; _i < chunk2.length; chunk2.length === t3 || (0, H.throwConcurrentModificationError)(chunk2), ++_i)
        t1.push(chunk2[_i]);
      for (t3 = chunk1.length, _i = 0; _i < chunk1.length; chunk1.length === t3 || (0, H.throwConcurrentModificationError)(chunk1), ++_i)
        t1.push(chunk1[_i]);
      return H.setRuntimeTypeInfo([t2, t1], [[P.List, $T]]);
    },
    paths: function(choices, $T) {
      return J.fold$2$ax(choices, H.setRuntimeTypeInfo([H.setRuntimeTypeInfo([], [$T])], [[P.List, $T]]), new Y.paths_closure($T));
    },
    _groupSelectors: function(complex) {
      var t1, group, t2,
        groups = Q.QueueList$(null, [P.List, S.ComplexSelectorComponent]),
        iterator = P._ListQueueIterator$(complex);
      iterator.moveNext$0();
      for (t1 = [S.ComplexSelectorComponent]; iterator._collection$_current != null;) {
        group = H.setRuntimeTypeInfo([], t1);
        do {
          group.push(iterator._collection$_current);
          if (iterator.moveNext$0())
            t2 = iterator._collection$_current instanceof S.Combinator || C.JSArray_methods.get$last(group) instanceof S.Combinator;
          else
            t2 = false;
        } while (t2);
        groups._queue_list$_add$1(group);
      }
      return groups;
    },
    _hasRoot: function(compound) {
      return C.JSArray_methods.any$1(compound.components, new Y._hasRoot_closure());
    },
    listIsSuperslector: function(list1, list2) {
      return C.JSArray_methods.every$1(list2, new Y.listIsSuperslector_closure(list1));
    },
    complexIsParentSuperselector: function(complex1, complex2) {
      var t2, base, t3, t4,
        t1 = J.getInterceptor$ax(complex1);
      if (t1.get$first(complex1) instanceof S.Combinator)
        return false;
      t2 = J.getInterceptor$ax(complex2);
      if (t2.get$first(complex2) instanceof S.Combinator)
        return false;
      if (t1.get$length(complex1) > t2.get$length(complex2))
        return false;
      base = X.CompoundSelector$(H.setRuntimeTypeInfo([new N.PlaceholderSelector("<temp>")], [M.SimpleSelector]));
      t3 = [S.ComplexSelectorComponent];
      t4 = H.setRuntimeTypeInfo([], t3);
      for (t1 = t1.get$iterator(complex1); t1.moveNext$0();)
        t4.push(t1.get$current(t1));
      t4.push(base);
      t1 = H.setRuntimeTypeInfo([], t3);
      for (t2 = t2.get$iterator(complex2); t2.moveNext$0();)
        t1.push(t2.get$current(t2));
      t1.push(base);
      return Y.complexIsSuperselector(t4, t1);
    },
    complexIsSuperselector: function(complex1, complex2) {
      var t1, i1, i2, remaining1, remaining2, t2, afterSuperselector, afterSuperselector0, t3, compound2, i10, combinator1, combinator2;
      if (C.JSArray_methods.get$last(complex1) instanceof S.Combinator)
        return false;
      if (C.JSArray_methods.get$last(complex2) instanceof S.Combinator)
        return false;
      for (t1 = H.getTypeArgumentByIndex(complex2, 0), i1 = 0, i2 = 0; true;) {
        remaining1 = complex1.length - i1;
        remaining2 = complex2.length - i2;
        if (remaining1 === 0 || remaining2 === 0)
          return false;
        if (remaining1 > remaining2)
          return false;
        t2 = complex1[i1];
        if (t2 instanceof S.Combinator)
          return false;
        if (complex2[i2] instanceof S.Combinator)
          return false;
        H.interceptedTypeCast(t2, "$isCompoundSelector");
        if (remaining1 === 1)
          return Y.compoundIsSuperselector(t2, H.interceptedTypeCast(C.JSArray_methods.get$last(complex2), "$isCompoundSelector"), H.SubListIterable$(complex2, 0, complex2.length - 1, t1).skip$1(0, i2));
        afterSuperselector = i2 + 1;
        for (afterSuperselector0 = afterSuperselector; afterSuperselector0 < complex2.length; ++afterSuperselector0) {
          t3 = afterSuperselector0 - 1;
          compound2 = complex2[t3];
          if (compound2 instanceof X.CompoundSelector)
            if (Y.compoundIsSuperselector(t2, compound2, H.SubListIterable$(complex2, 0, t3, t1).skip$1(0, afterSuperselector)))
              break;
        }
        if (afterSuperselector0 === complex2.length)
          return false;
        i10 = i1 + 1;
        combinator1 = complex1[i10];
        combinator2 = complex2[afterSuperselector0];
        if (combinator1 instanceof S.Combinator) {
          if (!(combinator2 instanceof S.Combinator))
            return false;
          if (combinator1 === C.Combinator_CzM) {
            if (combinator2 === C.Combinator_sgq)
              return false;
          } else if (combinator2 !== combinator1)
            return false;
          if (remaining1 === 3 && remaining2 > 3)
            return false;
          i1 += 2;
          i2 = afterSuperselector0 + 1;
        } else {
          if (combinator2 instanceof S.Combinator) {
            if (combinator2 !== C.Combinator_sgq)
              return false;
            i2 = afterSuperselector0 + 1;
          } else
            i2 = afterSuperselector0;
          i1 = i10;
        }
      }
    },
    compoundIsSuperselector: function(compound1, compound2, parents) {
      var t1, t2, _i, simple1, simple2;
      for (t1 = compound1.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        simple1 = t1[_i];
        if (simple1 instanceof D.PseudoSelector && simple1.selector != null) {
          if (!Y._selectorPseudoIsSuperselector(simple1, compound2, parents))
            return false;
        } else if (!Y._simpleIsSuperselectorOfCompound(simple1, compound2))
          return false;
      }
      for (t1 = compound2.components, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        simple2 = t1[_i];
        if (simple2 instanceof D.PseudoSelector && !simple2.isClass && simple2.selector == null && !Y._simpleIsSuperselectorOfCompound(simple2, compound1))
          return false;
      }
      return true;
    },
    _simpleIsSuperselectorOfCompound: function(simple, compound) {
      return C.JSArray_methods.any$1(compound.components, new Y._simpleIsSuperselectorOfCompound_closure(simple));
    },
    _selectorPseudoIsSuperselector: function(pseudo1, compound2, parents) {
      switch (pseudo1.normalizedName) {
        case "matches":
        case "any":
          return Y._selectorPseudosNamed(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure(pseudo1)) || C.JSArray_methods.any$1(pseudo1.selector.components, new Y._selectorPseudoIsSuperselector_closure0(parents, compound2));
        case "has":
        case "host":
        case "host-context":
          return Y._selectorPseudosNamed(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure1(pseudo1));
        case "slotted":
          return Y._selectorPseudosNamed(compound2, pseudo1.name, false).any$1(0, new Y._selectorPseudoIsSuperselector_closure2(pseudo1));
        case "not":
          return C.JSArray_methods.every$1(pseudo1.selector.components, new Y._selectorPseudoIsSuperselector_closure3(compound2, pseudo1));
        case "current":
          return Y._selectorPseudosNamed(compound2, pseudo1.name, true).any$1(0, new Y._selectorPseudoIsSuperselector_closure4(pseudo1));
        case "nth-child":
        case "nth-last-child":
          return C.JSArray_methods.any$1(compound2.components, new Y._selectorPseudoIsSuperselector_closure5(pseudo1));
        default:
          throw H.wrapException("unreachable");
      }
    },
    _selectorPseudosNamed: function(compound, $name, isClass) {
      var t1 = D.PseudoSelector;
      return new H.WhereIterable(new H.WhereTypeIterable(compound.components, [t1]), new Y._selectorPseudosNamed_closure(isClass, $name), [t1]);
    },
    unifyComplex_closure: function unifyComplex_closure() {
    },
    _weaveParents_closure: function _weaveParents_closure() {
    },
    _weaveParents_closure0: function _weaveParents_closure0(t0) {
      this.group = t0;
    },
    _weaveParents_closure1: function _weaveParents_closure1() {
    },
    _weaveParents__closure1: function _weaveParents__closure1() {
    },
    _weaveParents_closure2: function _weaveParents_closure2() {
    },
    _weaveParents_closure3: function _weaveParents_closure3() {
    },
    _weaveParents__closure0: function _weaveParents__closure0() {
    },
    _weaveParents_closure4: function _weaveParents_closure4() {
    },
    _weaveParents_closure5: function _weaveParents_closure5() {
    },
    _weaveParents__closure: function _weaveParents__closure() {
    },
    _mustUnify_closure: function _mustUnify_closure(t0) {
      this.uniqueSelectors = t0;
    },
    _mustUnify__closure: function _mustUnify__closure(t0) {
      this.uniqueSelectors = t0;
    },
    paths_closure: function paths_closure(t0) {
      this.T = t0;
    },
    paths__closure: function paths__closure(t0, t1) {
      this.paths = t0;
      this.T = t1;
    },
    paths___closure: function paths___closure(t0, t1) {
      this.option = t0;
      this.T = t1;
    },
    _hasRoot_closure: function _hasRoot_closure() {
    },
    listIsSuperslector_closure: function listIsSuperslector_closure(t0) {
      this.list1 = t0;
    },
    listIsSuperslector__closure: function listIsSuperslector__closure(t0) {
      this.complex1 = t0;
    },
    _simpleIsSuperselectorOfCompound_closure: function _simpleIsSuperselectorOfCompound_closure(t0) {
      this.simple = t0;
    },
    _simpleIsSuperselectorOfCompound__closure: function _simpleIsSuperselectorOfCompound__closure(t0) {
      this.simple = t0;
    },
    _selectorPseudoIsSuperselector_closure: function _selectorPseudoIsSuperselector_closure(t0) {
      this.pseudo1 = t0;
    },
    _selectorPseudoIsSuperselector_closure0: function _selectorPseudoIsSuperselector_closure0(t0, t1) {
      this.parents = t0;
      this.compound2 = t1;
    },
    _selectorPseudoIsSuperselector_closure1: function _selectorPseudoIsSuperselector_closure1(t0) {
      this.pseudo1 = t0;
    },
    _selectorPseudoIsSuperselector_closure2: function _selectorPseudoIsSuperselector_closure2(t0) {
      this.pseudo1 = t0;
    },
    _selectorPseudoIsSuperselector_closure3: function _selectorPseudoIsSuperselector_closure3(t0, t1) {
      this.compound2 = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector__closure: function _selectorPseudoIsSuperselector__closure(t0, t1) {
      this.complex = t0;
      this.pseudo1 = t1;
    },
    _selectorPseudoIsSuperselector___closure: function _selectorPseudoIsSuperselector___closure(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector___closure0: function _selectorPseudoIsSuperselector___closure0(t0) {
      this.simple2 = t0;
    },
    _selectorPseudoIsSuperselector_closure4: function _selectorPseudoIsSuperselector_closure4(t0) {
      this.pseudo1 = t0;
    },
    _selectorPseudoIsSuperselector_closure5: function _selectorPseudoIsSuperselector_closure5(t0) {
      this.pseudo1 = t0;
    },
    _selectorPseudosNamed_closure: function _selectorPseudosNamed_closure(t0, t1) {
      this.isClass = t0;
      this.name = t1;
    },
    closure: function closure() {
    },
    Chokidar: function Chokidar() {
    },
    ChokidarOptions: function ChokidarOptions() {
    },
    ChokidarWatcher: function ChokidarWatcher() {
    },
    SourceFile$decoded: function(decodedChars, url) {
      var t1 = H.setRuntimeTypeInfo([0], [P.int]),
        t2 = typeof url === "string" ? P.Uri_parse(url) : url;
      t1 = new Y.SourceFile(t2, t1, new Uint32Array(H._ensureNativeList(J.toList$0$ax(decodedChars))));
      t1.SourceFile$decoded$2$url(decodedChars, url);
      return t1;
    },
    FileLocation$_: function(file, offset) {
      if (offset < 0)
        H.throwExpression(P.RangeError$("Offset may not be negative, was " + H.S(offset) + "."));
      else if (offset > file._decodedChars.length)
        H.throwExpression(P.RangeError$("Offset " + H.S(offset) + " must not be greater than the number of characters in the file, " + file.get$length(file) + "."));
      return new Y.FileLocation(file, offset);
    },
    _FileSpan$: function(file, _start, _end) {
      if (_end < _start)
        H.throwExpression(P.ArgumentError$("End " + H.S(_end) + " must come after start " + H.S(_start) + "."));
      else if (_end > file._decodedChars.length)
        H.throwExpression(P.RangeError$("End " + H.S(_end) + " must not be greater than the number of characters in the file, " + file.get$length(file) + "."));
      else if (_start < 0)
        H.throwExpression(P.RangeError$("Start may not be negative, was " + H.S(_start) + "."));
      return new Y._FileSpan(file, _start, _end);
    },
    SourceFile: function SourceFile(t0, t1, t2) {
      var _ = this;
      _.url = t0;
      _._lineStarts = t1;
      _._decodedChars = t2;
      _._cachedLine = null;
    },
    FileLocation: function FileLocation(t0, t1) {
      this.file = t0;
      this.offset = t1;
    },
    FileSpan: function FileSpan() {
    },
    _FileSpan: function _FileSpan(t0, t1, t2) {
      this.file = t0;
      this._start = t1;
      this._file$_end = t2;
    },
    SourceSpanMixin: function SourceSpanMixin() {
    },
    Trace_Trace$from: function(trace) {
      if (trace == null)
        throw H.wrapException(P.ArgumentError$("Cannot create a Trace from null."));
      if (!!trace.$isTrace)
        return trace;
      if (!!trace.$isChain)
        return trace.toTrace$0();
      return new T.LazyTrace(new Y.Trace_Trace$from_closure(trace));
    },
    Trace_Trace$parse: function(trace) {
      var error, t1, exception;
      try {
        if (trace.length === 0) {
          t1 = A.Frame;
          t1 = P.List_List$unmodifiable(H.setRuntimeTypeInfo([], [t1]), t1);
          return new Y.Trace(t1, new P._StringStackTrace(null));
        }
        if (J.getInterceptor$asx(trace).contains$1(trace, $.$get$_v8Trace())) {
          t1 = Y.Trace$parseV8(trace);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, "\tat ")) {
          t1 = Y.Trace$parseJSCore(trace);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, $.$get$_firefoxSafariTrace())) {
          t1 = Y.Trace$parseFirefox(trace);
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, "===== asynchronous gap ===========================\n")) {
          t1 = U.Chain_Chain$parse(trace).toTrace$0();
          return t1;
        }
        if (C.JSString_methods.contains$1(trace, $.$get$_friendlyTrace())) {
          t1 = Y.Trace$parseFriendly(trace);
          return t1;
        }
        t1 = P.List_List$unmodifiable(Y.Trace__parseVM(trace), A.Frame);
        return new Y.Trace(t1, new P._StringStackTrace(trace));
      } catch (exception) {
        t1 = H.unwrapException(exception);
        if (!!J.getInterceptor$(t1).$isFormatException) {
          error = t1;
          throw H.wrapException(P.FormatException$(H.S(J.get$message$x(error)) + "\nStack trace:\n" + H.S(trace), null, null));
        } else
          throw exception;
      }
    },
    Trace__parseVM: function(trace) {
      var $frames,
        t1 = J.trim$0$s(trace),
        lines = H.setRuntimeTypeInfo(H.stringReplaceAllUnchecked(t1, "<asynchronous suspension>\n", "").split("\n"), [P.String]);
      t1 = H.SubListIterable$(lines, 0, lines.length - 1, H.getTypeArgumentByIndex(lines, 0));
      $frames = new H.MappedListIterable(t1, new Y.Trace__parseVM_closure(), [H.getTypeArgumentByIndex(t1, 0), A.Frame]).toList$0(0);
      if (!J.endsWith$1$s(C.JSArray_methods.get$last(lines), ".da"))
        C.JSArray_methods.add$1($frames, A.Frame_Frame$parseVM(C.JSArray_methods.get$last(lines)));
      return $frames;
    },
    Trace$parseV8: function(trace) {
      var t2,
        t1 = H.setRuntimeTypeInfo(trace.split("\n"), [P.String]);
      t1 = H.SubListIterable$(t1, 1, null, H.getTypeArgumentByIndex(t1, 0)).super$Iterable$skipWhile(0, new Y.Trace$parseV8_closure());
      t2 = A.Frame;
      return new Y.Trace(P.List_List$unmodifiable(H.MappedIterable_MappedIterable(t1, new Y.Trace$parseV8_closure0(), H.getTypeArgumentByIndex(t1, 0), t2), t2), new P._StringStackTrace(trace));
    },
    Trace$parseJSCore: function(trace) {
      var t1 = H.setRuntimeTypeInfo(trace.split("\n"), [P.String]),
        t2 = H.getTypeArgumentByIndex(t1, 0),
        t3 = A.Frame;
      return new Y.Trace(P.List_List$unmodifiable(new H.MappedIterable(new H.WhereIterable(t1, new Y.Trace$parseJSCore_closure(), [t2]), new Y.Trace$parseJSCore_closure0(), [t2, t3]), t3), new P._StringStackTrace(trace));
    },
    Trace$parseFirefox: function(trace) {
      var t1 = H.setRuntimeTypeInfo(C.JSString_methods.trim$0(trace).split("\n"), [P.String]),
        t2 = H.getTypeArgumentByIndex(t1, 0),
        t3 = A.Frame;
      return new Y.Trace(P.List_List$unmodifiable(new H.MappedIterable(new H.WhereIterable(t1, new Y.Trace$parseFirefox_closure(), [t2]), new Y.Trace$parseFirefox_closure0(), [t2, t3]), t3), new P._StringStackTrace(trace));
    },
    Trace$parseFriendly: function(trace) {
      var t2, t3,
        t1 = A.Frame;
      if (trace.length === 0)
        t2 = H.setRuntimeTypeInfo([], [t1]);
      else {
        t2 = H.setRuntimeTypeInfo(J.trim$0$s(trace).split("\n"), [P.String]);
        t3 = H.getTypeArgumentByIndex(t2, 0);
        t3 = new H.MappedIterable(new H.WhereIterable(t2, new Y.Trace$parseFriendly_closure(), [t3]), new Y.Trace$parseFriendly_closure0(), [t3, t1]);
        t2 = t3;
      }
      return new Y.Trace(P.List_List$unmodifiable(t2, t1), new P._StringStackTrace(trace));
    },
    Trace: function Trace(t0, t1) {
      this.frames = t0;
      this.original = t1;
    },
    Trace_Trace$from_closure: function Trace_Trace$from_closure(t0) {
      this.trace = t0;
    },
    Trace__parseVM_closure: function Trace__parseVM_closure() {
    },
    Trace$parseV8_closure: function Trace$parseV8_closure() {
    },
    Trace$parseV8_closure0: function Trace$parseV8_closure0() {
    },
    Trace$parseJSCore_closure: function Trace$parseJSCore_closure() {
    },
    Trace$parseJSCore_closure0: function Trace$parseJSCore_closure0() {
    },
    Trace$parseFirefox_closure: function Trace$parseFirefox_closure() {
    },
    Trace$parseFirefox_closure0: function Trace$parseFirefox_closure0() {
    },
    Trace$parseFriendly_closure: function Trace$parseFriendly_closure() {
    },
    Trace$parseFriendly_closure0: function Trace$parseFriendly_closure0() {
    },
    Trace_terse_closure: function Trace_terse_closure() {
    },
    Trace_foldFrames_closure: function Trace_foldFrames_closure(t0) {
      this.oldPredicate = t0;
    },
    Trace_foldFrames_closure0: function Trace_foldFrames_closure0(t0) {
      this._box_0 = t0;
    },
    Trace_toString_closure0: function Trace_toString_closure0() {
    },
    Trace_toString_closure: function Trace_toString_closure(t0) {
      this.longest = t0;
    },
    repl: function(options) {
      return Y.repl$body(options);
    },
    repl$body: function(options) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(-1),
        $async$handler = 1, $async$currentError, $async$next = [], repl, logger, evaluator, line, declaration, error, stackTrace, t6, t7, t8, t9, line0, exception, t1, t2, t3, t4, t5, repl0;
      var $async$repl = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = P.String;
              t2 = [t1];
              t3 = H.setRuntimeTypeInfo([], t2);
              t4 = C.JSString_methods.$mul(" ", 3);
              t5 = $.$get$alwaysValid();
              repl0 = new Q.Repl(">> ", t4, t5, t3);
              repl0._adapter = new B.ReplAdapter(repl0);
              repl = repl0;
              t3 = options._options;
              logger = new T.TrackingLogger(H.boolTypeCast(t3.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color()));
              t4 = D.absolute(".");
              evaluator = new R.Evaluator(R._EvaluateVisitor$(null, R.ImportCache$(C.List_empty10, H.subtypeCast(t3.$index(0, "load-path"), "$isList", t2, "$asList"), logger), logger, null, false), new F.FilesystemImporter(t4));
              t4 = P._StreamIterator$(repl._adapter.runAsync$0());
              $async$handler = 2;
              t2 = Z.VariableDeclaration, t3 = [P.int];
            case 5:
              // for condition
              $async$goto = 7;
              return P._asyncAwait(t4.moveNext$0(), $async$repl);
            case 7:
              // returning from await.
              if (!$async$result) {
                // goto after for
                $async$goto = 6;
                break;
              }
              line = t4.get$current(t4);
              if (J.trim$0$s(line).length === 0) {
                // goto for condition
                $async$goto = 5;
                break;
              }
              try {
                if (J.startsWith$1$s(line, "@")) {
                  t5 = evaluator;
                  t6 = line;
                  t7 = logger;
                  t6.toString;
                  t8 = new H.CodeUnits(t6);
                  t9 = H.setRuntimeTypeInfo([0], t3);
                  t9 = new Y.SourceFile(null, t9, new Uint32Array(H._ensureNativeList(t8.toList$0(t8))));
                  t9.SourceFile$decoded$2$url(t8, null);
                  if (t7 == null)
                    t7 = C.StderrLogger_false;
                  t7 = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), new S.SpanScanner(t9, null, t6), t7).parseUseRule$0();
                  t5._visitor.runStatement$2(t5._importer, t7);
                  // goto for condition
                  $async$goto = 5;
                  break;
                }
                t5 = line;
                t5.toString;
                t6 = new H.CodeUnits(t5);
                t7 = H.setRuntimeTypeInfo([0], t3);
                t7 = new Y.SourceFile(null, t7, new Uint32Array(H._ensureNativeList(t6.toList$0(t6))));
                t7.SourceFile$decoded$2$url(t6, null);
                if (new G.Parser(new S.SpanScanner(t7, null, t5), C.StderrLogger_false)._isVariableDeclarationLike$0()) {
                  t5 = line;
                  t6 = logger;
                  t5.toString;
                  t7 = new H.CodeUnits(t5);
                  t8 = H.setRuntimeTypeInfo([0], t3);
                  t8 = new Y.SourceFile(null, t8, new Uint32Array(H._ensureNativeList(t7.toList$0(t7))));
                  t8.SourceFile$decoded$2$url(t7, null);
                  if (t6 == null)
                    t6 = C.StderrLogger_false;
                  declaration = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), new S.SpanScanner(t8, null, t5), t6).parseVariableDeclaration$0();
                  t6 = evaluator;
                  t6._visitor.runStatement$2(t6._importer, declaration);
                  t6 = evaluator;
                  t5 = declaration.name;
                  t8 = declaration.span;
                  t7 = declaration.namespace;
                  line0 = H.S(t6._visitor.runExpression$2(t6._importer, new S.VariableExpression(t7, t5, t8)));
                  t5 = $.printToZone;
                  if (t5 == null)
                    H.printString(line0);
                  else
                    t5.call$1(line0);
                } else {
                  t5 = evaluator;
                  t6 = line;
                  t7 = logger;
                  t6.toString;
                  t8 = new H.CodeUnits(t6);
                  t9 = H.setRuntimeTypeInfo([0], t3);
                  t9 = new Y.SourceFile(null, t9, new Uint32Array(H._ensureNativeList(t8.toList$0(t8))));
                  t9.SourceFile$decoded$2$url(t8, null);
                  if (t7 == null)
                    t7 = C.StderrLogger_false;
                  t7 = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), new S.SpanScanner(t9, null, t6), t7);
                  t7 = t7._parseSingleProduction$1(t7.get$expression());
                  line0 = H.S(t5._visitor.runExpression$2(t5._importer, t7));
                  t5 = $.printToZone;
                  if (t5 == null)
                    H.printString(line0);
                  else
                    t5.call$1(line0);
                }
              } catch (exception) {
                t5 = H.unwrapException(exception);
                if (t5 instanceof E.SassException) {
                  error = t5;
                  stackTrace = H.getTraceFromException(exception);
                  Y._logError(error, stackTrace, line, repl, options, logger);
                } else
                  throw exception;
              }
              // goto for condition
              $async$goto = 5;
              break;
            case 6:
              // after for
              $async$next.push(4);
              // goto finally
              $async$goto = 3;
              break;
            case 2:
              // uncaught
              $async$next = [1];
            case 3:
              // finally
              $async$handler = 1;
              $async$goto = 8;
              return P._asyncAwait(t4.cancel$0(), $async$repl);
            case 8:
              // returning from await.
              // goto the next finally handler
              $async$goto = $async$next.pop();
              break;
            case 4:
              // after finally
              // implicit return
              return P._asyncReturn(null, $async$completer);
            case 1:
              // rethrow
              return P._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return P._asyncStartSync($async$repl, $async$completer);
    },
    _logError: function(error, stackTrace, line, repl, options, logger) {
      var t1, t2, spacesBeforeError;
      if (G.SourceSpanException.prototype.get$span.call(error).file.url == null)
        if (!H.boolTypeCast(options._options.$index(0, "quiet")))
          t1 = logger._emittedDebug || logger._emittedWarning;
        else
          t1 = false;
      else
        t1 = true;
      if (t1) {
        P.print(error.toString$1$color(0, options.get$color()));
        return;
      }
      t1 = options.get$color() ? "\x1b[31m" : "";
      t2 = G.SourceSpanException.prototype.get$span.call(error);
      t2 = Y.FileLocation$_(t2.file, t2._start);
      spacesBeforeError = repl.prompt.length + t2.file.getColumn$1(t2.offset);
      if (options.get$color()) {
        t2 = G.SourceSpanException.prototype.get$span.call(error);
        t2 = Y.FileLocation$_(t2.file, t2._start);
        t2 = t2.file.getColumn$1(t2.offset) < line.length;
      } else
        t2 = false;
      if (t2) {
        t1 += "\x1b[1F\x1b[" + spacesBeforeError + "C";
        t2 = G.SourceSpanException.prototype.get$span.call(error);
        t2 = t1 + (P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(t2.file._decodedChars, t2._start, t2._file$_end), 0, null) + "\n");
        t1 = t2;
      }
      t1 += C.JSString_methods.$mul(" ", spacesBeforeError);
      t2 = G.SourceSpanException.prototype.get$span.call(error);
      t2 = t1 + (C.JSString_methods.$mul("^", Math.max(1, t2._file$_end - t2._start)) + "\n");
      t1 = options.get$color() ? t2 + "\x1b[0m" : t2;
      t1 += "Error: " + H.S(error._span_exception$_message) + "\n";
      if (H.boolTypeCast(options._options.$index(0, "trace")))
        t1 += Y.Trace_Trace$from(stackTrace).get$terse().toString$0(0);
      P.print(C.JSString_methods.trimRight$0(t1.charCodeAt(0) == 0 ? t1 : t1));
    }
  },
  L = {StreamGroup: function StreamGroup(t0, t1, t2) {
      var _ = this;
      _._controller = null;
      _._closed = false;
      _._stream_group$_state = t0;
      _._subscriptions = t1;
      _.$ti = t2;
    }, StreamGroup_add_closure: function StreamGroup_add_closure() {
    }, StreamGroup_add_closure0: function StreamGroup_add_closure0(t0, t1) {
      this.$this = t0;
      this.stream = t1;
    }, StreamGroup__onListen_closure: function StreamGroup__onListen_closure(t0) {
      this.$this = t0;
    }, StreamGroup__onCancel_closure: function StreamGroup__onCancel_closure() {
    }, StreamGroup__onCancel_closure0: function StreamGroup__onCancel_closure0() {
    }, StreamGroup__listenToStream_closure: function StreamGroup__listenToStream_closure(t0, t1) {
      this.$this = t0;
      this.stream = t1;
    }, _StreamGroupState: function _StreamGroupState(t0) {
      this.name = t0;
    },
    UnmodifiableSetMixin__throw: function() {
      throw H.wrapException(P.UnsupportedError$("Cannot modify an unmodifiable Set"));
    },
    UnmodifiableSetView: function UnmodifiableSetView(t0, t1) {
      this._base = t0;
      this.$ti = t1;
    },
    UnmodifiableSetMixin: function UnmodifiableSetMixin() {
    },
    _UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin: function _UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin() {
    },
    WindowsStyle: function WindowsStyle(t0, t1, t2, t3) {
      var _ = this;
      _.separatorPattern = t0;
      _.needsSeparatorPattern = t1;
      _.rootPattern = t2;
      _.relativeRootPattern = t3;
    },
    WindowsStyle_absolutePathToUri_closure: function WindowsStyle_absolutePathToUri_closure() {
    },
    ModifiableCssDeclaration$: function($name, value, span, valueSpanForMap) {
      return new L.ModifiableCssDeclaration($name, value, valueSpanForMap == null ? span : valueSpanForMap, span);
    },
    ModifiableCssDeclaration: function ModifiableCssDeclaration(t0, t1, t2, t3) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.valueSpanForMap = t2;
      _.span = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    IfExpression: function IfExpression(t0, t1) {
      this.$arguments = t0;
      this.span = t1;
    },
    Declaration$: function($name, span, children, value) {
      var t1;
      children = children == null ? null : P.List_List$unmodifiable(children, O.Statement);
      t1 = children == null ? null : C.JSArray_methods.any$1(children, new M.ParentStatement_closure());
      return new L.Declaration($name, value, span, children, t1 === true);
    },
    Declaration: function Declaration(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    ForwardRule: function ForwardRule(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _.url = t0;
      _.shownMixinsAndFunctions = t1;
      _.shownVariables = t2;
      _.hiddenMixinsAndFunctions = t3;
      _.hiddenVariables = t4;
      _.prefix = t5;
      _.configuration = t6;
      _.span = t7;
    },
    ForwardRule__memberList_closure: function ForwardRule__memberList_closure() {
    },
    LoudComment: function LoudComment(t0) {
      this.text = t0;
    },
    SupportsDeclaration: function SupportsDeclaration(t0, t1, t2) {
      this.name = t0;
      this.value = t1;
      this.span = t2;
    },
    PlainCssCallable: function PlainCssCallable(t0) {
      this.name = t0;
    },
    ExtendMode: function ExtendMode(t0) {
      this.name = t0;
    },
    RenderContextOptions: function RenderContextOptions() {
    },
    ScssParser: function ScssParser(t0, t1, t2) {
      var _ = this;
      _._isUseAllowed = true;
      _._stylesheet$_inMixin = false;
      _._mixinHasContent = null;
      _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    Entry: function Entry(t0, t1, t2) {
      this.source = t0;
      this.target = t1;
      this.identifierName = t2;
    },
    _StreamTransformer__defaultHandleError: function(error, stackTrace, sink) {
      sink.addError$2(error, stackTrace);
    },
    _StreamTransformer: function _StreamTransformer(t0, t1, t2, t3) {
      var _ = this;
      _._from_handlers$_handleData = t0;
      _._from_handlers$_handleDone = t1;
      _._from_handlers$_handleError = t2;
      _.$ti = t3;
    },
    _StreamTransformer_bind_closure: function _StreamTransformer_bind_closure(t0, t1, t2, t3) {
      var _ = this;
      _._box_1 = t0;
      _.$this = t1;
      _.values = t2;
      _.controller = t3;
    },
    _StreamTransformer_bind__closure: function _StreamTransformer_bind__closure(t0, t1) {
      this.$this = t0;
      this.controller = t1;
    },
    _StreamTransformer_bind__closure1: function _StreamTransformer_bind__closure1(t0, t1) {
      this.$this = t0;
      this.controller = t1;
    },
    _StreamTransformer_bind__closure0: function _StreamTransformer_bind__closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.controller = t2;
    },
    _StreamTransformer_bind__closure2: function _StreamTransformer_bind__closure2(t0, t1) {
      this._box_1 = t0;
      this._box_0 = t1;
    },
    encodeVlq: function(value) {
      var res, signBit, digit, t1;
      if (value < $.$get$MIN_INT32() || value > $.$get$MAX_INT32())
        throw H.wrapException(P.ArgumentError$("expected 32 bit int, got: " + value));
      res = H.setRuntimeTypeInfo([], [P.String]);
      if (value < 0) {
        value = -value;
        signBit = 1;
      } else
        signBit = 0;
      value = value << 1 | signBit;
      do {
        digit = value & 31;
        value = value >>> 5;
        t1 = value > 0;
        res.push("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"[t1 ? digit | 32 : digit]);
      } while (t1);
      return res;
    }
  },
  Q = {Repl: function Repl(t0, t1, t2, t3) {
      var _ = this;
      _.prompt = t0;
      _.continuation = t1;
      _.validator = t2;
      _._adapter = null;
      _.history = t3;
    }, closure130: function closure130() {
    },
    QueueList$: function(initialCapacity, $E) {
      var t1 = new Q.QueueList(0, 0, [$E]);
      t1.QueueList$1(initialCapacity, $E);
      return t1;
    },
    QueueList_QueueList$from: function(source, $E) {
      var $length, queue,
        t1 = J.getInterceptor$(source);
      if (!!t1.$isList) {
        $length = t1.get$length(source);
        queue = Q.QueueList$($length + 1, $E);
        J.setRange$4$ax(queue._table, 0, $length, source, 0);
        queue._tail = $length;
        return queue;
      } else {
        t1 = Q.QueueList$(null, $E);
        t1.addAll$1(0, source);
        return t1;
      }
    },
    QueueList__nextPowerOf2: function(number) {
      var nextNumber;
      number = (number << 1 >>> 0) - 1;
      for (; true; number = nextNumber) {
        nextNumber = (number & number - 1) >>> 0;
        if (nextNumber === 0)
          return number;
      }
    },
    QueueList: function QueueList(t0, t1, t2) {
      var _ = this;
      _._table = null;
      _._head = t0;
      _._tail = t1;
      _.$ti = t2;
    },
    _CastQueueList: function _CastQueueList(t0, t1, t2, t3) {
      var _ = this;
      _._queue_list$_delegate = t0;
      _._table = null;
      _._head = t1;
      _._tail = t2;
      _.$ti = t3;
    },
    _QueueList_Object_ListMixin: function _QueueList_Object_ListMixin() {
    },
    StaticImport: function StaticImport(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.supports = t1;
      _.media = t2;
      _.span = t3;
    },
    ContentRule: function ContentRule(t0, t1) {
      this.span = t0;
      this.$arguments = t1;
    },
    DebugRule: function DebugRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    AsyncEnvironment$: function(sourceMap) {
      var _null = null,
        t1 = P.String,
        t2 = [G.Module, B.AsyncCallable],
        t3 = H.setRuntimeTypeInfo([], [t2]),
        t4 = H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, F.Value)], [[P.Map, P.String, F.Value]]),
        t5 = sourceMap ? H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, B.AstNode)], [[P.Map, P.String, B.AstNode]]) : _null,
        t6 = P.int,
        t7 = B.AsyncCallable,
        t8 = [[P.Map, P.String, B.AsyncCallable]];
      return new Q.AsyncEnvironment(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _null, _null, _null, t3, t4, t5, P.LinkedHashMap_LinkedHashMap$_empty(t1, t6), H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, t7)], t8), P.LinkedHashMap_LinkedHashMap$_empty(t1, t6), H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, t7)], t8), P.LinkedHashMap_LinkedHashMap$_empty(t1, t6), _null);
    },
    AsyncEnvironment$_: function(_modules, _globalModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = P.String,
        t2 = P.int;
      return new Q.AsyncEnvironment(_modules, _globalModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule0: function(environment, css, extender, forwarded) {
      var t1, t2, t3, t4, t5, t6;
      if (forwarded == null)
        forwarded = C.List_empty13;
      t1 = Q._EnvironmentModule__makeModulesByVariable0(forwarded);
      t2 = H.getTypeArgumentByIndex(forwarded, 0);
      t3 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_variables), new H.MappedListIterable(forwarded, new Q._EnvironmentModule__EnvironmentModule_closure5(), [t2, [P.Map, P.String, F.Value]]), F.Value);
      t4 = environment._async_environment$_variableNodes;
      t4 = t4 == null ? null : Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(t4), new H.MappedListIterable(forwarded, new Q._EnvironmentModule__EnvironmentModule_closure6(), [t2, [P.Map, P.String, B.AstNode]]), B.AstNode);
      t2 = [t2, [P.Map, P.String, B.AsyncCallable]];
      t5 = B.AsyncCallable;
      t6 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_functions), new H.MappedListIterable(forwarded, new Q._EnvironmentModule__EnvironmentModule_closure7(), t2), t5);
      t5 = Q._EnvironmentModule__memberMap0(C.JSArray_methods.get$first(environment._async_environment$_mixins), new H.MappedListIterable(forwarded, new Q._EnvironmentModule__EnvironmentModule_closure8(), t2), t5);
      t2 = J.get$isNotEmpty$asx(css.get$children()) || C.JSArray_methods.any$1(environment._async_environment$_allModules, new Q._EnvironmentModule__EnvironmentModule_closure9());
      return Q._EnvironmentModule$_0(environment, css, extender, t1, t3, t4, t6, t5, t2, !extender.get$isEmpty(extender) || C.JSArray_methods.any$1(environment._async_environment$_allModules, new Q._EnvironmentModule__EnvironmentModule_closure10()));
    },
    _EnvironmentModule__makeModulesByVariable0: function(forwarded) {
      var modulesByVariable, _i, module, t2, t3,
        t1 = forwarded.length;
      if (t1 === 0)
        return C.Map_empty5;
      modulesByVariable = P.LinkedHashMap_LinkedHashMap$_empty(P.String, [G.Module, B.AsyncCallable]);
      for (_i = 0; _i < forwarded.length; forwarded.length === t1 || (0, H.throwConcurrentModificationError)(forwarded), ++_i) {
        module = forwarded[_i];
        if (module instanceof Q._EnvironmentModule0) {
          for (t2 = module._async_environment$_modulesByVariable.get$values(), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
            t3 = t2.get$current(t2);
            B.setAll(modulesByVariable, t3.get$variables().get$keys(), t3);
          }
          B.setAll(modulesByVariable, C.JSArray_methods.get$first(module._async_environment$_environment._async_environment$_variables).get$keys(), module);
        } else
          B.setAll(modulesByVariable, module.get$variables().get$keys(), module);
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap0: function(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new U.PublicMemberMapView(localMap, [$V]);
      if (otherMaps.get$length(otherMaps) === 0)
        return localMap;
      t1 = H.setRuntimeTypeInfo([], [[P.Map, P.String, $V]]);
      for (t2 = new H.ListIterator(otherMaps, otherMaps.get$length(otherMaps)); t2.moveNext$0();) {
        t3 = t2.__internal$_current;
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return Z.MergedMapView$(t1, P.String, $V);
    },
    _EnvironmentModule$_0: function(_environment, css, extender, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new Q._EnvironmentModule0(_environment._async_environment$_allModules, variables, variableNodes, functions, mixins, extender, css, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    AsyncEnvironment: function AsyncEnvironment(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _._async_environment$_modules = t0;
      _._async_environment$_globalModules = t1;
      _._async_environment$_forwardedModules = t2;
      _._async_environment$_nestedForwardedModules = t3;
      _._async_environment$_allModules = t4;
      _._async_environment$_variables = t5;
      _._async_environment$_variableNodes = t6;
      _._async_environment$_variableIndices = t7;
      _._async_environment$_functions = t8;
      _._async_environment$_functionIndices = t9;
      _._async_environment$_mixins = t10;
      _._async_environment$_mixinIndices = t11;
      _._async_environment$_content = t12;
      _._async_environment$_inMixin = false;
      _._async_environment$_inSemiGlobalScope = true;
      _._async_environment$_lastVariableIndex = _._async_environment$_lastVariableName = null;
    },
    AsyncEnvironment_importForwards_closure: function AsyncEnvironment_importForwards_closure() {
    },
    AsyncEnvironment_importForwards_closure0: function AsyncEnvironment_importForwards_closure0() {
    },
    AsyncEnvironment_importForwards_closure1: function AsyncEnvironment_importForwards_closure1() {
    },
    AsyncEnvironment_importForwards_closure2: function AsyncEnvironment_importForwards_closure2() {
    },
    AsyncEnvironment__getVariableFromGlobalModule_closure: function AsyncEnvironment__getVariableFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure: function AsyncEnvironment_setVariable_closure(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment_setVariable_closure0: function AsyncEnvironment_setVariable_closure0(t0) {
      this.name = t0;
    },
    AsyncEnvironment_setVariable_closure1: function AsyncEnvironment_setVariable_closure1(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    AsyncEnvironment__getFunctionFromGlobalModule_closure: function AsyncEnvironment__getFunctionFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment__getMixinFromGlobalModule_closure: function AsyncEnvironment__getMixinFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    AsyncEnvironment__fromOneModule_closure: function AsyncEnvironment__fromOneModule_closure(t0) {
      this.callback = t0;
    },
    AsyncEnvironment__fromOneModule_closure0: function AsyncEnvironment__fromOneModule_closure0() {
    },
    _EnvironmentModule0: function _EnvironmentModule0(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extender = t5;
      _.css = t6;
      _.transitivelyContainsCss = t7;
      _.transitivelyContainsExtensions = t8;
      _._async_environment$_environment = t9;
      _._async_environment$_modulesByVariable = t10;
    },
    _EnvironmentModule__EnvironmentModule_closure5: function _EnvironmentModule__EnvironmentModule_closure5() {
    },
    _EnvironmentModule__EnvironmentModule_closure6: function _EnvironmentModule__EnvironmentModule_closure6() {
    },
    _EnvironmentModule__EnvironmentModule_closure7: function _EnvironmentModule__EnvironmentModule_closure7() {
    },
    _EnvironmentModule__EnvironmentModule_closure8: function _EnvironmentModule__EnvironmentModule_closure8() {
    },
    _EnvironmentModule__EnvironmentModule_closure9: function _EnvironmentModule__EnvironmentModule_closure9() {
    },
    _EnvironmentModule__EnvironmentModule_closure10: function _EnvironmentModule__EnvironmentModule_closure10() {
    },
    BuiltInCallable$: function($name, $arguments, callback) {
      return new Q.BuiltInCallable($name, H.setRuntimeTypeInfo([new S.Tuple2(B.ArgumentDeclaration_ArgumentDeclaration$parse($arguments), callback, [B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}])], [[S.Tuple2, B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}]]));
    },
    BuiltInCallable$parsed: function($name, $arguments, callback) {
      return new Q.BuiltInCallable($name, H.setRuntimeTypeInfo([new S.Tuple2($arguments, callback, [B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}])], [[S.Tuple2, B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}]]));
    },
    BuiltInCallable$overloaded: function($name, overloads) {
      var t2, t3, t4, t5, t6, t7, t8, t9, t10,
        t1 = H.setRuntimeTypeInfo([], [[S.Tuple2, B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}]]);
      for (t2 = overloads.get$entries(), t2 = t2.get$iterator(t2), t3 = [B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}], t4 = P.String, t5 = Z.VariableDeclaration, t6 = [P.int]; t2.moveNext$0();) {
        t7 = t2.get$current(t2);
        t8 = "(" + H.S(t7.key) + ")";
        t9 = new H.CodeUnits(t8);
        t10 = H.setRuntimeTypeInfo([0], t6);
        t10 = new Y.SourceFile(null, t10, new Uint32Array(H._ensureNativeList(t9.toList$0(t9))));
        t10.SourceFile$decoded$2$url(t9, null);
        t8 = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(t4, t5), new S.SpanScanner(t10, null, t8), C.StderrLogger_false);
        t1.push(new S.Tuple2(t8._parseSingleProduction$1(t8.get$_argumentDeclaration()), t7.value, t3));
      }
      return new Q.BuiltInCallable($name, t1);
    },
    BuiltInCallable: function BuiltInCallable(t0, t1) {
      this.name = t0;
      this._overloads = t1;
    },
    closure89: function closure89() {
    },
    closure90: function closure90() {
    },
    closure91: function closure91() {
    },
    closure92: function closure92() {
    },
    _closure12: function _closure12() {
    },
    BuiltInModule$: function($name, functions, mixins, $T) {
      return new Q.BuiltInModule(P._Uri__Uri(null, $name, null, "sass"), Q.BuiltInModule__callableMap(functions, $T), Q.BuiltInModule__callableMap(mixins, $T), [$T]);
    },
    BuiltInModule__callableMap: function(callables, $T) {
      var t2, t3, _i, callable,
        t1 = P.String;
      if (callables == null)
        t2 = P.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
      else {
        t2 = P.LinkedHashMap_LinkedHashMap$_empty(t1, $T);
        for (t3 = callables.length, _i = 0; _i < callables.length; callables.length === t3 || (0, H.throwConcurrentModificationError)(callables), ++_i) {
          callable = callables[_i];
          t2.$indexSet(0, callable.get$name(), callable);
        }
        t2 = new P.UnmodifiableMapView(t2, [t1, $T]);
      }
      return new P.UnmodifiableMapView(t2, [t1, $T]);
    },
    BuiltInModule: function BuiltInModule(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.functions = t1;
      _.mixins = t2;
      _.$ti = t3;
    },
    closure93: function closure93() {
    },
    CssParser: function CssParser(t0, t1, t2) {
      var _ = this;
      _._isUseAllowed = true;
      _._stylesheet$_inMixin = false;
      _._mixinHasContent = null;
      _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    }
  },
  B = {ReplAdapter: function ReplAdapter(t0) {
      this.repl = t0;
      this.rl = null;
    }, ReplAdapter_runAsync_closure: function ReplAdapter_runAsync_closure(t0) {
      this.controller = t0;
    }, Stdin: function Stdin() {
    }, Stdout: function Stdout() {
    }, ReadlineModule: function ReadlineModule() {
    }, ReadlineOptions: function ReadlineOptions() {
    }, ReadlineInterface: function ReadlineInterface() {
    },
    defaultCompare: function($T) {
      return new B.defaultCompare_closure($T);
    },
    defaultCompare_closure: function defaultCompare_closure(t0) {
      this.T = t0;
    },
    InternalStyle: function InternalStyle() {
    },
    ModifiableCssNode: function ModifiableCssNode() {
    },
    ModifiableCssParentNode: function ModifiableCssParentNode() {
    },
    ModifiableCssSupportsRule: function ModifiableCssSupportsRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    CssNode: function CssNode() {
    },
    CssParentNode: function CssParentNode() {
    },
    AstNode: function AstNode() {
    },
    ArgumentDeclaration_ArgumentDeclaration$parse: function(contents) {
      var t1 = S.SpanScanner$("(" + H.S(contents) + ")", null);
      t1 = new L.ScssParser(P.LinkedHashMap_LinkedHashMap$_empty(P.String, Z.VariableDeclaration), t1, C.StderrLogger_false);
      return t1._parseSingleProduction$1(t1.get$_argumentDeclaration());
    },
    ArgumentDeclaration: function ArgumentDeclaration(t0, t1, t2) {
      this.$arguments = t0;
      this.restArgument = t1;
      this.span = t2;
    },
    ArgumentDeclaration_verify_closure: function ArgumentDeclaration_verify_closure() {
    },
    ArgumentDeclaration_verify_closure0: function ArgumentDeclaration_verify_closure0() {
    },
    DynamicImport: function DynamicImport(t0, t1) {
      this.url = t0;
      this.span = t1;
    },
    SassNode: function SassNode() {
    },
    ForRule: function ForRule(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.variable = t0;
      _.from = t1;
      _.to = t2;
      _.isExclusive = t3;
      _.span = t4;
      _.children = t5;
      _.hasDeclarations = t6;
    },
    ImportRule: function ImportRule(t0, t1) {
      this.imports = t0;
      this.span = t1;
    },
    ReturnRule: function ReturnRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SilentComment: function SilentComment(t0, t1) {
      this.text = t0;
      this.span = t1;
    },
    SupportsRule: function SupportsRule(t0, t1, t2, t3) {
      var _ = this;
      _.condition = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    AsyncCallable: function AsyncCallable() {
    },
    ExecutableOptions__separator: function(text) {
      var t1 = $.$get$ExecutableOptions__separatorBar(),
        t2 = C.JSString_methods.$mul(t1, 3) + " ",
        t3 = self.process.stdout.isTTY;
      t2 = t2 + ((t3 == null ? false : t3) ? "\x1b[1m" : "") + text;
      t3 = self.process.stdout.isTTY;
      return t2 + ((t3 == null ? false : t3) ? "\x1b[0m" : "") + " " + C.JSString_methods.$mul(t1, 35 - text.length);
    },
    ExecutableOptions__fail: function(message) {
      return H.throwExpression(B.UsageException$(message));
    },
    ExecutableOptions_ExecutableOptions$parse: function(args) {
      var options, error, t1, t2, exception;
      try {
        t1 = $.$get$ExecutableOptions__parser();
        t1.toString;
        t2 = H.setRuntimeTypeInfo(args.slice(0), [H.getTypeArgumentByIndex(args, 0)]);
        t1 = G.Parser$0(null, t1, t2, null, null).parse$0();
        if (t1.wasParsed$1("poll") && !H.boolTypeCast(t1.$index(0, "watch")))
          B.ExecutableOptions__fail("--poll may not be passed without --watch.");
        options = new B.ExecutableOptions(t1);
        if (H.boolTypeCast(options._options.$index(0, "help")))
          B.ExecutableOptions__fail("Compile Sass to CSS.");
        return options;
      } catch (exception) {
        t1 = H.unwrapException(exception);
        if (!!J.getInterceptor$(t1).$isFormatException) {
          error = t1;
          B.ExecutableOptions__fail(J.get$message$x(error));
        } else
          throw exception;
      }
    },
    UsageException$: function(message) {
      return new B.UsageException(message);
    },
    ExecutableOptions: function ExecutableOptions(t0) {
      var _ = this;
      _._options = t0;
      _._sourceDirectoriesToDestinations = _._sourcesToDestinations = _._interactive = null;
    },
    ExecutableOptions_closure: function ExecutableOptions_closure() {
    },
    ExecutableOptions_emitErrorCss_closure: function ExecutableOptions_emitErrorCss_closure() {
    },
    UsageException: function UsageException(t0) {
      this.message = t0;
    },
    AsyncImporter: function AsyncImporter() {
    },
    inImportRule: function(callback) {
      var t1,
        wasInImportRule = $._inImportRule;
      $._inImportRule = true;
      try {
        t1 = callback.call$0();
        return t1;
      } finally {
        $._inImportRule = wasInImportRule;
      }
    },
    resolveImportPath: function(path) {
      var t1,
        extension = X.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$0()[1];
      if (extension === ".sass" || extension === ".scss" || extension === ".css") {
        t1 = $._inImportRule ? new B.resolveImportPath_closure(path, extension).call$0() : null;
        return t1 == null ? B._exactlyOne(B._tryPath(path)) : t1;
      }
      t1 = $._inImportRule ? new B.resolveImportPath_closure0(path).call$0() : null;
      if (t1 == null)
        t1 = B._exactlyOne(B._tryPathWithExtensions(path));
      return t1 == null ? B._tryPathAsDirectory(path) : t1;
    },
    _tryPathWithExtensions: function(path) {
      var result = B._tryPath(J.$add$ansx(path, ".sass"));
      C.JSArray_methods.addAll$1(result, B._tryPath(path + ".scss"));
      return result.length !== 0 ? result : B._tryPath(path + ".css");
    },
    _tryPath: function(path) {
      var t1 = $.$get$context(),
        partial = D.join(t1.dirname$1(path), "_" + H.S(X.ParsedPath_ParsedPath$parse(path, t1.style).get$basename()), null);
      t1 = H.setRuntimeTypeInfo([], [P.String]);
      if (B.fileExists(partial))
        t1.push(partial);
      if (B.fileExists(path))
        t1.push(path);
      return t1;
    },
    _tryPathAsDirectory: function(path) {
      var t1;
      if (!B.dirExists(path))
        return;
      t1 = $._inImportRule ? new B._tryPathAsDirectory_closure(path).call$0() : null;
      return t1 == null ? B._exactlyOne(B._tryPathWithExtensions(D.join(path, "index", null))) : t1;
    },
    _exactlyOne: function(paths) {
      var t1 = paths.length;
      if (t1 === 0)
        return;
      if (t1 === 1)
        return C.JSArray_methods.get$first(paths);
      throw H.wrapException("It's not clear which file to import. Found:\n" + C.JSArray_methods.map$1$1(paths, new B._exactlyOne_closure(), P.String).join$1(0, "\n"));
    },
    resolveImportPath_closure: function resolveImportPath_closure(t0, t1) {
      this.path = t0;
      this.extension = t1;
    },
    resolveImportPath_closure0: function resolveImportPath_closure0(t0) {
      this.path = t0;
    },
    _tryPathAsDirectory_closure: function _tryPathAsDirectory_closure(t0) {
      this.path = t0;
    },
    _exactlyOne_closure: function _exactlyOne_closure() {
    },
    readFile: function(path) {
      var t1, t2, t3, sourceFile, i,
        contents = H.stringTypeCast(B._readFile(path, "utf8"));
      if (!J.getInterceptor$asx(contents).contains$1(contents, "\ufffd"))
        return contents;
      t1 = $.$get$context().toUri$1(path);
      t2 = new H.CodeUnits(contents);
      t3 = H.setRuntimeTypeInfo([0], [P.int]);
      sourceFile = new Y.SourceFile(t1, t3, new Uint32Array(H._ensureNativeList(t2.toList$0(t2))));
      sourceFile.SourceFile$decoded$2$url(t2, t1);
      for (t1 = contents.length, i = 0; i < t1; ++i) {
        if (C.JSString_methods._codeUnitAt$1(contents, i) !== 65533)
          continue;
        throw H.wrapException(E.SassException$("Invalid UTF-8.", Y.FileLocation$_(sourceFile, i).pointSpan$0()));
      }
      return contents;
    },
    _readFile: function(path, encoding) {
      return B._systemErrorToFileSystemException(new B._readFile_closure(path, encoding));
    },
    writeFile: function(path, contents) {
      return B._systemErrorToFileSystemException(new B.writeFile_closure(path, contents));
    },
    deleteFile: function(path) {
      return B._systemErrorToFileSystemException(new B.deleteFile_closure(path));
    },
    readStdin: function() {
      return B.readStdin$body();
    },
    readStdin$body: function() {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(P.String),
        $async$returnValue, sink, t1, t2, t3, completer;
      var $async$readStdin = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = {};
              t2 = P.String;
              t3 = new P._Future($.Zone__current, [t2]);
              completer = new P._AsyncCompleter(t3, [t2]);
              t1.contents = null;
              sink = new P.Utf8Decoder(false).startChunkedConversion$1(new P._StringCallbackSink(new B.readStdin_closure(t1, completer), new P.StringBuffer("")));
              J.on$2$x(self.process.stdin, "data", P.allowInterop(new B.readStdin_closure0(sink)));
              J.on$2$x(self.process.stdin, "end", P.allowInterop(new B.readStdin_closure1(sink)));
              J.on$2$x(self.process.stdin, "error", P.allowInterop(new B.readStdin_closure2(completer)));
              $async$returnValue = t3;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$readStdin, $async$completer);
    },
    fileExists: function(path) {
      return B._systemErrorToFileSystemException(new B.fileExists_closure(path));
    },
    dirExists: function(path) {
      return B._systemErrorToFileSystemException(new B.dirExists_closure(path));
    },
    ensureDir: function(path) {
      return B._systemErrorToFileSystemException(new B.ensureDir_closure(path));
    },
    listDir: function(path, recursive) {
      return B._systemErrorToFileSystemException(new B.listDir_closure(recursive, path));
    },
    modificationTime: function(path) {
      return B._systemErrorToFileSystemException(new B.modificationTime_closure(path));
    },
    _systemErrorToFileSystemException: function(callback) {
      var error, systemError, t1, exception, t2;
      try {
        t1 = callback.call$0();
        return t1;
      } catch (exception) {
        error = H.unwrapException(exception);
        systemError = H.interceptedTypeCast(error, "$is_SystemError");
        t1 = systemError;
        t2 = J.getInterceptor$x(t1);
        throw H.wrapException(new B.FileSystemException(J.substring$2$s(t2.get$message(t1), (H.S(t2.get$code(t1)) + ": ").length, J.get$length$asx(t2.get$message(t1)) - (", " + H.S(t2.get$syscall(t1)) + " '" + H.S(t2.get$path(t1)) + "'").length), J.get$path$x(systemError)));
      }
    },
    isWindows: function() {
      return J.$eq$(J.get$platform$x(self.process), "win32");
    },
    watchDir: function(path, poll) {
      var t2, t3, t4, t1 = {},
        watcher = J.watch$2$x(self.chokidar, path, {disableGlobbing: true, usePolling: poll});
      t1.controller = null;
      t2 = J.getInterceptor$x(watcher);
      t2.on$2(watcher, "add", P.allowInterop(new B.watchDir_closure(t1)));
      t2.on$2(watcher, "change", P.allowInterop(new B.watchDir_closure0(t1)));
      t2.on$2(watcher, "unlink", P.allowInterop(new B.watchDir_closure1(t1)));
      t2.on$2(watcher, "error", P.allowInterop(new B.watchDir_closure2(t1)));
      t3 = [P.Stream, E.WatchEvent];
      t4 = new P._Future($.Zone__current, [t3]);
      t2.on$2(watcher, "ready", P.allowInterop(new B.watchDir_closure3(t1, watcher, new P._AsyncCompleter(t4, [t3]))));
      return t4;
    },
    _FS: function _FS() {
    },
    _Stat: function _Stat() {
    },
    _Date: function _Date() {
    },
    _Stderr: function _Stderr() {
    },
    _Stdin: function _Stdin() {
    },
    _SystemError: function _SystemError() {
    },
    _Process: function _Process() {
    },
    FileSystemException: function FileSystemException(t0, t1) {
      this.message = t0;
      this.path = t1;
    },
    Stderr: function Stderr(t0) {
      this._stderr = t0;
    },
    _readFile_closure: function _readFile_closure(t0, t1) {
      this.path = t0;
      this.encoding = t1;
    },
    writeFile_closure: function writeFile_closure(t0, t1) {
      this.path = t0;
      this.contents = t1;
    },
    deleteFile_closure: function deleteFile_closure(t0) {
      this.path = t0;
    },
    readStdin_closure: function readStdin_closure(t0, t1) {
      this._box_0 = t0;
      this.completer = t1;
    },
    readStdin_closure0: function readStdin_closure0(t0) {
      this.sink = t0;
    },
    readStdin_closure1: function readStdin_closure1(t0) {
      this.sink = t0;
    },
    readStdin_closure2: function readStdin_closure2(t0) {
      this.completer = t0;
    },
    fileExists_closure: function fileExists_closure(t0) {
      this.path = t0;
    },
    dirExists_closure: function dirExists_closure(t0) {
      this.path = t0;
    },
    ensureDir_closure: function ensureDir_closure(t0) {
      this.path = t0;
    },
    listDir_closure: function listDir_closure(t0, t1) {
      this.recursive = t0;
      this.path = t1;
    },
    listDir__closure: function listDir__closure(t0) {
      this.path = t0;
    },
    listDir__closure0: function listDir__closure0() {
    },
    listDir_closure_list: function listDir_closure_list() {
    },
    listDir__list_closure: function listDir__list_closure(t0, t1) {
      this.parent = t0;
      this.list = t1;
    },
    modificationTime_closure: function modificationTime_closure(t0) {
      this.path = t0;
    },
    watchDir_closure: function watchDir_closure(t0) {
      this._box_0 = t0;
    },
    watchDir_closure0: function watchDir_closure0(t0) {
      this._box_0 = t0;
    },
    watchDir_closure1: function watchDir_closure1(t0) {
      this._box_0 = t0;
    },
    watchDir_closure2: function watchDir_closure2(t0) {
      this._box_0 = t0;
    },
    watchDir_closure3: function watchDir_closure3(t0, t1, t2) {
      this._box_0 = t0;
      this.watcher = t1;
      this.completer = t2;
    },
    watchDir__closure: function watchDir__closure(t0) {
      this.watcher = t0;
    },
    ShadowedModuleView_ifNecessary: function(inner, functions, mixins, variables, $T) {
      return B.ShadowedModuleView__needsBlacklist(inner.get$variables(), variables) || B.ShadowedModuleView__needsBlacklist(inner.get$functions(inner), functions) || B.ShadowedModuleView__needsBlacklist(inner.get$mixins(), mixins) ? new B.ShadowedModuleView(inner, B.ShadowedModuleView__shadowedMap(inner.get$variables(), variables, F.Value), B.ShadowedModuleView__shadowedMap(inner.get$variableNodes(), variables, B.AstNode), B.ShadowedModuleView__shadowedMap(inner.get$functions(inner), functions, $T), B.ShadowedModuleView__shadowedMap(inner.get$mixins(), mixins, $T), [$T]) : null;
    },
    ShadowedModuleView__shadowedMap: function(map, blocklist, $V) {
      if (map == null || !B.ShadowedModuleView__needsBlacklist(map, blocklist))
        return map;
      return K.LimitedMapView$blocklist(map, blocklist, P.String, $V);
    },
    ShadowedModuleView__needsBlacklist: function(map, blocklist) {
      var t1 = map.get$isNotEmpty(map) && blocklist.any$1(0, map.get$containsKey());
      return t1;
    },
    ShadowedModuleView: function ShadowedModuleView(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._shadowed_view$_inner = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.$ti = t5;
    },
    main0: function() {
      J.set$run_$x(self.exports, P.allowInterop(new B.main_closure()));
      J.set$render$x(self.exports, P.allowInterop(B.node___render$closure()));
      J.set$renderSync$x(self.exports, P.allowInterop(B.node___renderSync$closure()));
      J.set$info$x(self.exports, "dart-sass\t1.24.3\t(Sass Compiler)\t[Dart]\ndart2js\t2.7.0\t(Dart Compiler)\t[Dart]");
      J.set$types$x(self.exports, {Boolean: $.$get$booleanConstructor(), Color: $.$get$colorConstructor(), List: $.$get$listConstructor(), Map: $.$get$mapConstructor(), Null: $.$get$nullConstructor(), Number: $.$get$numberConstructor(), String: $.$get$stringConstructor(), Error: self.Error});
    },
    _render: function(options, callback) {
      var t1 = J.getInterceptor$x(options);
      if (t1.get$fiber(options) != null)
        J.run$0$x(t1.get$fiber(options).call$1(P.allowInterop(new B._render_closure(callback, options))));
      else
        B._renderAsync(options).then$1$2$onError(new B._render_closure0(callback), new B._render_closure1(callback), P.Null);
    },
    _renderAsync: function(options) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(U.RenderResult),
        $async$returnValue, t2, t3, t4, t5, t6, t7, t8, t9, result, start, t1, file;
      var $async$_renderAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              start = new P.DateTime(Date.now(), false);
              t1 = J.getInterceptor$x(options);
              file = t1.get$file(options) == null ? null : D.absolute(t1.get$file(options));
              $async$goto = t1.get$data(options) != null ? 3 : 5;
              break;
            case 3:
              // then
              t2 = t1.get$data(options);
              t3 = B._parseImporter(options, start);
              t4 = B._parseFunctions(options, true);
              t5 = t1.get$indentedSyntax(options);
              t5 = !J.$eq$(t5, false) && t5 != null ? C.Syntax_Sass : null;
              t6 = B._parseOutputStyle(t1.get$outputStyle(options));
              t7 = J.$eq$(t1.get$indentType(options), "tab");
              t8 = B._parseIndentWidth(t1.get$indentWidth(options));
              t9 = B._parseLineFeed(t1.get$linefeed(options));
              t1 = t1.get$file(options) == null ? "stdin" : J.toString$0$($.$get$context().toUri$1(file));
              $async$goto = 6;
              return P._asyncAwait(X.compileStringAsync(t2, true, t4, null, null, t8, t9, null, t3, B._enableSourceMaps(options), t6, t5, t1, !t7), $async$_renderAsync);
            case 6:
              // returning from await.
              result = $async$result;
              // goto join
              $async$goto = 4;
              break;
            case 5:
              // else
              $async$goto = t1.get$file(options) != null ? 7 : 9;
              break;
            case 7:
              // then
              t2 = B._parseImporter(options, start);
              t3 = B._parseFunctions(options, true);
              t4 = t1.get$indentedSyntax(options);
              t4 = !J.$eq$(t4, false) && t4 != null ? C.Syntax_Sass : null;
              t5 = B._parseOutputStyle(t1.get$outputStyle(options));
              t6 = J.$eq$(t1.get$indentType(options), "tab");
              $async$goto = 10;
              return P._asyncAwait(X.compileAsync(file, true, t3, null, B._parseIndentWidth(t1.get$indentWidth(options)), B._parseLineFeed(t1.get$linefeed(options)), null, t2, B._enableSourceMaps(options), t5, t4, !t6), $async$_renderAsync);
            case 10:
              // returning from await.
              result = $async$result;
              // goto join
              $async$goto = 8;
              break;
            case 9:
              // else
              throw H.wrapException(P.ArgumentError$("Either options.data or options.file must be set."));
            case 8:
              // join
            case 4:
              // join
              $async$returnValue = B._newRenderResult(options, result, start);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_renderAsync, $async$completer);
    },
    _renderSync: function(options) {
      var start, file, result, error, error0, t1, t2, t3, t4, t5, t6, t7, t8, t9, exception, _null = null;
      try {
        start = new P.DateTime(Date.now(), false);
        t1 = J.getInterceptor$x(options);
        file = t1.get$file(options) == null ? _null : D.absolute(t1.get$file(options));
        result = null;
        if (t1.get$data(options) != null) {
          t2 = t1.get$data(options);
          t3 = B._parseImporter(options, start);
          t4 = B._parseFunctions(options, false);
          t5 = t1.get$indentedSyntax(options);
          t5 = !J.$eq$(t5, false) && t5 != null ? C.Syntax_Sass : _null;
          t6 = B._parseOutputStyle(t1.get$outputStyle(options));
          t7 = J.$eq$(t1.get$indentType(options), "tab");
          t8 = B._parseIndentWidth(t1.get$indentWidth(options));
          t9 = B._parseLineFeed(t1.get$linefeed(options));
          t1 = t1.get$file(options) == null ? "stdin" : J.toString$0$($.$get$context().toUri$1(file));
          result = U.compileString(t2, true, new H.CastList(t4, [H.getTypeArgumentByIndex(t4, 0), D.Callable]), _null, _null, t8, t9, _null, t3, B._enableSourceMaps(options), t6, t5, t1, !t7);
        } else if (t1.get$file(options) != null) {
          t2 = B._parseImporter(options, start);
          t3 = B._parseFunctions(options, false);
          t4 = t1.get$indentedSyntax(options);
          t4 = !J.$eq$(t4, false) && t4 != null ? C.Syntax_Sass : _null;
          t5 = B._parseOutputStyle(t1.get$outputStyle(options));
          t6 = J.$eq$(t1.get$indentType(options), "tab");
          result = U.compile(file, true, new H.CastList(t3, [H.getTypeArgumentByIndex(t3, 0), D.Callable]), _null, B._parseIndentWidth(t1.get$indentWidth(options)), B._parseLineFeed(t1.get$linefeed(options)), _null, t2, B._enableSourceMaps(options), t5, t4, !t6);
        } else {
          t1 = P.ArgumentError$("Either options.data or options.file must be set.");
          throw H.wrapException(t1);
        }
        t1 = B._newRenderResult(options, result, start);
        return t1;
      } catch (exception) {
        t1 = H.unwrapException(exception);
        if (t1 instanceof E.SassException) {
          error = t1;
          t1 = B._wrapException(error);
          $.$get$_jsThrow().call$1(t1);
        } else {
          error0 = t1;
          t1 = B._newRenderError(J.toString$0$(error0), _null, _null, _null, 3);
          $.$get$_jsThrow().call$1(t1);
        }
      }
      throw H.wrapException("unreachable");
    },
    _wrapException: function(exception) {
      var t3, t4,
        t1 = C.JSString_methods.replaceFirst$2(exception.toString$0(0), "Error: ", ""),
        t2 = G.SourceSpanException.prototype.get$span.call(exception);
      t2 = Y.FileLocation$_(t2.file, t2._start);
      t2 = t2.file.getLine$1(t2.offset);
      t3 = G.SourceSpanException.prototype.get$span.call(exception);
      t3 = Y.FileLocation$_(t3.file, t3._start);
      t3 = t3.file.getColumn$1(t3.offset);
      if (G.SourceSpanException.prototype.get$span.call(exception).file.url == null)
        t4 = "stdin";
      else {
        t4 = G.SourceSpanException.prototype.get$span.call(exception).file;
        t4 = $.$get$context().style.pathFromUri$1(M._parseUri(t4.url));
      }
      return B._newRenderError(t1, t3 + 1, t4, t2 + 1, 1);
    },
    _parseFunctions: function(options, asynch) {
      var result,
        t1 = J.getInterceptor$x(options);
      if (t1.get$functions(options) == null)
        return C.List_empty11;
      result = H.setRuntimeTypeInfo([], [B.AsyncCallable]);
      B.jsForEach(t1.get$functions(options), new B._parseFunctions_closure(options, result, asynch));
      return result;
    },
    _parseImporter: function(options, start) {
      var importers, t2, t3, includePaths, t4, t5, t6, t7, _i, t8, t9, t10, context,
        t1 = J.getInterceptor$x(options);
      if (t1.get$importer(options) == null)
        importers = H.setRuntimeTypeInfo([], [F.JSFunction]);
      else {
        t2 = F.JSFunction;
        importers = !!J.getInterceptor$(t1.get$importer(options)).$isList ? J.cast$1$0$ax(H.subtypeCast(t1.get$importer(options), "$isList", [P.Object], "$asList"), t2) : H.setRuntimeTypeInfo([H.interceptedTypeCast(t1.get$importer(options), "$isJSFunction")], [t2]);
      }
      t2 = t1.get$includePaths(options);
      if (t2 == null)
        t2 = [];
      t3 = P.String;
      includePaths = P.List_List$from(t2, true, t3);
      t2 = J.getInterceptor$asx(importers);
      if (t2.get$isNotEmpty(importers)) {
        t4 = t1.get$file(options);
        t5 = t1.get$data(options);
        t6 = H.setRuntimeTypeInfo([], [t3]);
        t6.push(D.current());
        for (t7 = includePaths.length, _i = 0; _i < includePaths.length; includePaths.length === t7 || (0, H.throwConcurrentModificationError)(includePaths), ++_i)
          t6.push(includePaths[_i]);
        t6 = C.JSArray_methods.join$1(t6, J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":");
        t7 = J.$eq$(t1.get$indentType(options), "tab") ? 1 : 0;
        t8 = B._parseIndentWidth(t1.get$indentWidth(options));
        if (t8 == null)
          t8 = 2;
        t9 = B._parseLineFeed(t1.get$linefeed(options));
        t10 = t1.get$file(options);
        if (t10 == null)
          t10 = "data";
        context = {options: {file: t4, data: t5, includePaths: t6, precision: 10, style: 1, indentType: t7, indentWidth: t8, linefeed: t9.text, result: {stats: {entry: t10, start: start._value}}}};
        J.set$context$x(J.get$options$x(context), context);
      } else
        context = null;
      if (t1.get$fiber(options) != null)
        importers = t2.map$1$1(importers, new B._parseImporter_closure(options), F.JSFunction).toList$0(0);
      return new F.NodeImporter(context, P.List_List$unmodifiable(F.NodeImporter__addSassPath(includePaths), t3), P.List_List$unmodifiable(J.cast$1$0$ax(importers, null), F.JSFunction));
    },
    _parseOutputStyle: function(style) {
      if (style == null || style === "expanded")
        return C.OutputStyle_expanded;
      if (style === "compressed")
        return C.OutputStyle_compressed;
      throw H.wrapException(P.ArgumentError$('Unsupported output style "' + H.S(style) + '".'));
    },
    _parseIndentWidth: function(width) {
      if (width == null)
        return;
      return typeof width === "number" && Math.floor(width) === width ? width : P.int_parse(J.toString$0$(width), null, null);
    },
    _parseLineFeed: function(str) {
      switch (str) {
        case "cr":
          return C.LineFeed_kMT;
        case "crlf":
          return C.LineFeed_Mss;
        case "lfcr":
          return C.LineFeed_a1Y;
        default:
          return C.LineFeed_D6m;
      }
    },
    _newRenderResult: function(options, result, start) {
      var t3, t4, sourceMapPath, sourceMapDir, sourceMapDirUrl, i, source, sourceMapBytes, buffer, indices, url, _null = null,
        t1 = Date.now(),
        t2 = result._serialize,
        css = t2.css;
      if (B._enableSourceMaps(options)) {
        t3 = J.getInterceptor$x(options);
        t4 = t3.get$sourceMap(options);
        sourceMapPath = typeof t4 === "string" ? H.stringTypeCast(t3.get$sourceMap(options)) : J.$add$ansx(t3.get$outFile(options), ".map");
        t4 = $.$get$context();
        sourceMapDir = t4.dirname$1(sourceMapPath);
        t2 = t2.sourceMap;
        t2.sourceRoot = t3.get$sourceMapRoot(options);
        if (t3.get$outFile(options) == null)
          if (t3.get$file(options) == null)
            t2.targetUrl = "stdin.css";
          else
            t2.targetUrl = J.toString$0$(t4.toUri$1(t4.withoutExtension$1(t3.get$file(options)) + ".css"));
        else
          t2.targetUrl = J.toString$0$(t4.toUri$1(t4.relative$2$from(t3.get$outFile(options), sourceMapDir)));
        sourceMapDirUrl = J.toString$0$(t4.toUri$1(sourceMapDir));
        for (t4 = t2.urls, i = 0; i < t4.length; ++i) {
          source = t4[i];
          if (source === "stdin")
            continue;
          t4[i] = $.$get$url().relative$2$from(source, sourceMapDirUrl);
        }
        t4 = t3.get$sourceMapContents(options);
        t2 = C.C_JsonCodec.encode$2$toEncodable(t2.toJson$1$includeSourceContents(!J.$eq$(t4, false) && t4 != null), _null);
        sourceMapBytes = self.Buffer.from(t2, "utf8");
        t2 = t3.get$omitSourceMapUrl(options);
        if (!(!J.$eq$(t2, false) && t2 != null)) {
          t2 = t3.get$sourceMapEmbed(options);
          if (!J.$eq$(t2, false) && t2 != null) {
            buffer = new P.StringBuffer("");
            indices = H.setRuntimeTypeInfo([-1], [P.int]);
            P.UriData__writeUri("application/json", _null, _null, buffer, indices);
            indices.push(buffer._contents.length);
            t2 = buffer._contents += ";base64,";
            indices.push(t2.length - 1);
            C.C_Base64Encoder.startChunkedConversion$1(new P._StringSinkConversionSink(buffer)).addSlice$4(sourceMapBytes, 0, sourceMapBytes.length, true);
            t2 = buffer._contents;
            url = new P.UriData(t2.charCodeAt(0) == 0 ? t2 : t2, indices, _null).get$uri();
          } else {
            if (t3.get$outFile(options) == null)
              t2 = sourceMapPath;
            else {
              t2 = t3.get$outFile(options);
              t3 = $.$get$context();
              t2 = t3.relative$2$from(sourceMapPath, t3.dirname$1(t2));
            }
            url = $.$get$context().toUri$1(t2);
          }
          css += "\n\n/*# sourceMappingURL=" + H.S(url) + " */";
        }
      } else
        sourceMapBytes = _null;
      t2 = self.Buffer.from(css, "utf8");
      t3 = J.get$file$x(options);
      if (t3 == null)
        t3 = "data";
      t4 = start._value;
      t1 = new P.DateTime(t1, false)._value;
      return {css: t2, map: sourceMapBytes, stats: {entry: t3, start: t4, end: t1, duration: C.JSInt_methods._tdivFast$1(P.Duration$(t1 - t4)._duration, 1000), includedFiles: result._evaluate.includedFiles.toList$0(0)}};
    },
    _enableSourceMaps: function(options) {
      var t1 = J.getInterceptor$x(options),
        t2 = t1.get$sourceMap(options);
      if (typeof t2 !== "string") {
        t2 = t1.get$sourceMap(options);
        t1 = !J.$eq$(t2, false) && t2 != null && t1.get$outFile(options) != null;
      } else
        t1 = true;
      return t1;
    },
    _newRenderError: function(message, column, file, line, $status) {
      var error = new self.Error(message);
      error.formatted = "Error: " + H.S(message);
      if (line != null)
        error.line = line;
      if (column != null)
        error.column = column;
      if (file != null)
        error.file = file;
      error.status = $status;
      return error;
    },
    main_closure: function main_closure() {
    },
    _render_closure: function _render_closure(t0, t1) {
      this.callback = t0;
      this.options = t1;
    },
    _render_closure0: function _render_closure0(t0) {
      this.callback = t0;
    },
    _render_closure1: function _render_closure1(t0) {
      this.callback = t0;
    },
    _parseFunctions_closure: function _parseFunctions_closure(t0, t1, t2) {
      this.options = t0;
      this.result = t1;
      this.asynch = t2;
    },
    _parseFunctions__closure: function _parseFunctions__closure(t0, t1) {
      this.options = t0;
      this.callback = t1;
    },
    _parseFunctions___closure0: function _parseFunctions___closure0(t0) {
      this.fiber = t0;
    },
    _parseFunctions____closure: function _parseFunctions____closure(t0, t1) {
      this.fiber = t0;
      this.result = t1;
    },
    _parseFunctions__closure0: function _parseFunctions__closure0(t0) {
      this.callback = t0;
    },
    _parseFunctions__closure1: function _parseFunctions__closure1(t0) {
      this.callback = t0;
    },
    _parseFunctions___closure: function _parseFunctions___closure(t0) {
      this.completer = t0;
    },
    _parseImporter_closure: function _parseImporter_closure(t0) {
      this.options = t0;
    },
    _parseImporter__closure: function _parseImporter__closure(t0, t1) {
      this.options = t0;
      this.importer = t1;
    },
    _parseImporter___closure: function _parseImporter___closure(t0) {
      this.fiber = t0;
    },
    _parseImporter____closure: function _parseImporter____closure(t0, t1) {
      this.fiber = t0;
      this.result = t1;
    },
    forwardToString: function(klass) {
      klass.prototype.toString = P.allowInteropCaptureThis(new B.forwardToString_closure());
    },
    jsForEach: function(object, callback) {
      var t1, t2;
      for (t1 = J.get$iterator$ax(self.Object.keys(object)); t1.moveNext$0();) {
        t2 = t1.get$current(t1);
        callback.call$2(t2, object[t2]);
      }
    },
    createClass: function($constructor, methods) {
      var klass = P.allowInteropCaptureThis($constructor);
      methods.forEach$1(0, new B.createClass_closure(klass.prototype));
      return klass;
    },
    injectSuperclass: function(object, $constructor) {
      var t1,
        $prototype = self.Object.getPrototypeOf(object),
        $parent = self.Object.getPrototypeOf($prototype);
      if ($parent != null) {
        t1 = $constructor.prototype;
        self.Object.setPrototypeOf(t1, $parent);
      }
      t1 = $constructor.prototype;
      t1 = self.Object.create(t1);
      self.Object.setPrototypeOf($prototype, t1);
    },
    forwardToString_closure: function forwardToString_closure() {
    },
    createClass_closure: function createClass_closure(t0) {
      this.$prototype = t0;
    },
    toSentence: function(iter, conjunction) {
      if (iter.get$length(iter) === 1)
        return J.toString$0$(iter.get$first(iter));
      return iter.take$1(0, iter.get$length(iter) - 1).join$1(0, ", ") + (" " + conjunction + " " + H.S(iter.get$last(iter)));
    },
    indent: function(string, indentation) {
      var t1 = P.String,
        t2 = H.setRuntimeTypeInfo(string.split("\n"), [t1]);
      return new H.MappedListIterable(t2, new B.indent_closure(indentation), [H.getTypeArgumentByIndex(t2, 0), t1]).join$1(0, "\n");
    },
    pluralize: function($name, number, plural) {
      if (number === 1)
        return $name;
      if (plural != null)
        return plural;
      return $name + "s";
    },
    bulletedList: function(bullets) {
      return H.MappedIterable_MappedIterable(bullets, new B.bulletedList_closure(), H.getRuntimeTypeArgument(bullets, "Iterable", 0), P.String).join$1(0, "\n");
    },
    trimAscii: function(string, excludeEscape) {
      var start = B._firstNonWhitespace(string);
      return start == null ? "" : J.substring$2$s(string, start, B._lastNonWhitespace(string, true) + 1);
    },
    trimAsciiRight: function(string, excludeEscape) {
      var end = B._lastNonWhitespace(string, excludeEscape);
      return end == null ? "" : J.substring$2$s(string, 0, end + 1);
    },
    _firstNonWhitespace: function(string) {
      var t1, i, t2;
      for (t1 = string.length, i = 0; i < t1; ++i) {
        t2 = C.JSString_methods._codeUnitAt$1(string, i);
        if (!(t2 === 32 || t2 === 9 || t2 === 10 || t2 === 13 || t2 === 12))
          return i;
      }
      return;
    },
    _lastNonWhitespace: function(string, excludeEscape) {
      var t1, i, t2, codeUnit;
      for (t1 = string.length, i = t1 - 1, t2 = J.getInterceptor$s(string); i >= 0; --i) {
        codeUnit = t2.codeUnitAt$1(string, i);
        if (!(codeUnit === 32 || codeUnit === 9 || codeUnit === 10 || codeUnit === 13 || codeUnit === 12))
          if (excludeEscape && i !== 0 && i !== t1 && codeUnit === 92)
            return i + 1;
          else
            return i;
      }
      return;
    },
    isPublic: function(member) {
      var start = J._codeUnitAt$1$s(member, 0);
      return start !== 45 && start !== 95;
    },
    flattenVertically: function(iterable, $T) {
      var result,
        queues = new H.MappedListIterable(iterable, new B.flattenVertically_closure($T), [H.getRuntimeTypeArgument(iterable, "ListIterable", 0), [Q.QueueList, $T]]).toList$0(0);
      if (queues.length === 1)
        return C.JSArray_methods.get$first(queues);
      result = H.setRuntimeTypeInfo([], [$T]);
      for (; queues.length !== 0;) {
        if (!!queues.fixed$length)
          H.throwExpression(P.UnsupportedError$("removeWhere"));
        C.JSArray_methods._removeWhere$2(queues, new B.flattenVertically_closure0(result), true);
      }
      return result;
    },
    firstOrNull: function(iterable) {
      var iterator = J.get$iterator$ax(iterable);
      return iterator.moveNext$0() ? iterator.get$current(iterator) : null;
    },
    codepointIndexToCodeUnitIndex: function(string, codepointIndex) {
      var t1, codeUnitIndex, i, codeUnitIndex0, t2;
      for (t1 = J.getInterceptor$s(string), codeUnitIndex = 0, i = 0; i < codepointIndex; ++i) {
        codeUnitIndex0 = codeUnitIndex + 1;
        t2 = t1._codeUnitAt$1(string, codeUnitIndex);
        codeUnitIndex = t2 >= 55296 && t2 <= 56319 ? codeUnitIndex0 + 1 : codeUnitIndex0;
      }
      return codeUnitIndex;
    },
    codeUnitIndexToCodepointIndex: function(string, codeUnitIndex) {
      var t1, codepointIndex, i, t2;
      for (t1 = J.getInterceptor$s(string), codepointIndex = 0, i = 0; i < codeUnitIndex; i = (t2 >= 55296 && t2 <= 56319 ? i + 1 : i) + 1) {
        ++codepointIndex;
        t2 = t1._codeUnitAt$1(string, i);
      }
      return codepointIndex;
    },
    frameForSpan: function(span, member, url) {
      var t2, t3, t4,
        t1 = url == null ? span.file.url : url;
      if (t1 == null)
        t1 = $.$get$_noSourceUrl();
      t2 = span.file;
      t3 = span._start;
      t4 = Y.FileLocation$_(t2, t3);
      t4 = t4.file.getLine$1(t4.offset);
      t3 = Y.FileLocation$_(t2, t3);
      return new A.Frame(t1, t4 + 1, t3.file.getColumn$1(t3.offset) + 1, member);
    },
    spanForList: function(nodes) {
      var left, right;
      if (nodes.length === 0)
        return;
      left = C.JSArray_methods.get$first(nodes).get$span();
      if (left == null)
        return;
      right = C.JSArray_methods.get$last(nodes).get$span();
      if (right == null)
        return;
      return left.expand$1(0, right);
    },
    declarationName: function(span) {
      var text = P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(span.file._decodedChars, span._start, span._file$_end), 0, null);
      return B.trimAsciiRight(C.JSString_methods.substring$2(text, 0, C.JSString_methods.indexOf$1(text, ":")), false);
    },
    unvendor: function($name) {
      var i,
        t1 = $name.length;
      if (t1 < 2)
        return $name;
      if (J.getInterceptor$s($name)._codeUnitAt$1($name, 0) !== 45)
        return $name;
      if (C.JSString_methods._codeUnitAt$1($name, 1) === 45)
        return $name;
      for (i = 2; i < t1; ++i)
        if (C.JSString_methods._codeUnitAt$1($name, i) === 45)
          return C.JSString_methods.substring$1($name, i + 1);
      return $name;
    },
    equalsIgnoreCase: function(string1, string2) {
      var t1, i;
      if (string1 == string2)
        return true;
      if (string1 == null || string2 == null)
        return false;
      t1 = string1.length;
      if (t1 !== string2.length)
        return false;
      for (i = 0; i < t1; ++i)
        if (!T.characterEqualsIgnoreCase(C.JSString_methods._codeUnitAt$1(string1, i), C.JSString_methods._codeUnitAt$1(string2, i)))
          return false;
      return true;
    },
    startsWithIgnoreCase: function(string, prefix) {
      var t2, i,
        t1 = prefix.length;
      if (string.length < t1)
        return false;
      for (t2 = J.getInterceptor$s(string), i = 0; i < t1; ++i)
        if (!T.characterEqualsIgnoreCase(t2._codeUnitAt$1(string, i), C.JSString_methods._codeUnitAt$1(prefix, i)))
          return false;
      return true;
    },
    mapInPlace: function(list, $function) {
      var i;
      for (i = 0; i < list.length; ++i)
        list[i] = $function.call$1(list[i]);
    },
    longestCommonSubsequence: function(list1, list2, select, $T) {
      var t1, lengths, selections, t2, i, i0, j, selection, t3, j0, t4, t5;
      if (select == null)
        select = new B.longestCommonSubsequence_closure($T);
      t1 = J.getInterceptor$asx(list1);
      lengths = P.List_List$generate(t1.get$length(list1) + 1, new B.longestCommonSubsequence_closure0(list2), false, [P.List, P.int]);
      selections = P.List_List$generate(t1.get$length(list1), new B.longestCommonSubsequence_closure1(list2, $T), false, [P.List, $T]);
      for (t2 = J.getInterceptor$asx(list2), i = 0; i < t1.get$length(list1); i = i0)
        for (i0 = i + 1, j = 0; j < t2.get$length(list2); j = j0) {
          selection = select.call$2(t1.$index(list1, i), t2.$index(list2, j));
          J.$indexSet$ax(selections[i], j, selection);
          t3 = lengths[i0];
          j0 = j + 1;
          if (selection == null) {
            t4 = J.$index$asx(t3, j);
            t5 = J.$index$asx(lengths[i], j0);
            t5 = Math.max(H.checkNum(t4), H.checkNum(t5));
            t4 = t5;
          } else
            t4 = J.$index$asx(lengths[i], j) + 1;
          J.$indexSet$ax(t3, j0, t4);
        }
      return new B.longestCommonSubsequence_backtrack(selections, lengths, $T).call$2(t1.get$length(list1) - 1, t2.get$length(list2) - 1);
    },
    removeFirstWhere: function(list, test, orElse) {
      var toRemove, element,
        t1 = list.length,
        _i = 0;
      while (true) {
        if (!(_i < list.length)) {
          toRemove = null;
          break;
        }
        c$0: {
          element = list[_i];
          if (!test.call$1(element))
            break c$0;
          toRemove = element;
          break;
        }
        list.length === t1 || (0, H.throwConcurrentModificationError)(list);
        ++_i;
      }
      if (toRemove == null)
        return orElse.call$0();
      else {
        C.JSArray_methods.remove$1(list, toRemove);
        return toRemove;
      }
    },
    mapAddAll2: function(destination, source) {
      source.forEach$1(0, new B.mapAddAll2_closure(destination));
    },
    setAll: function(map, keys, value) {
      var t1;
      for (t1 = J.get$iterator$ax(keys); t1.moveNext$0();)
        map.$indexSet(0, t1.get$current(t1), value);
    },
    rotateSlice: function(list, start, end) {
      var i, next,
        element = list.$index(0, end - 1);
      for (i = start; i < end; ++i, element = next) {
        next = list.$index(0, i);
        list.$indexSet(0, i, element);
      }
    },
    mapAsync: function(iterable, callback, $E, $F) {
      return B.mapAsync$body(iterable, callback, $E, $F, [P.Iterable, $F]);
    },
    mapAsync$body: function(iterable, callback, $E, $F, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, t2, _i, t1, $async$temp1;
      var $async$mapAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = H.setRuntimeTypeInfo([], [$F]);
              t2 = iterable.length, _i = 0;
            case 3:
              // for condition
              if (!(_i < t2)) {
                // goto after for
                $async$goto = 5;
                break;
              }
              $async$temp1 = t1;
              $async$goto = 6;
              return P._asyncAwait(callback.call$1(iterable[_i]), $async$mapAsync);
            case 6:
              // returning from await.
              $async$temp1.push($async$result);
            case 4:
              // for update
              ++_i;
              // goto for condition
              $async$goto = 3;
              break;
            case 5:
              // after for
              $async$returnValue = t1;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$mapAsync, $async$completer);
    },
    putIfAbsentAsync: function(map, key, ifAbsent, $K, $V) {
      return B.putIfAbsentAsync$body(map, key, ifAbsent, $K, $V, $V);
    },
    putIfAbsentAsync$body: function(map, key, ifAbsent, $K, $V, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, value;
      var $async$putIfAbsentAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (map.containsKey$1(key)) {
                $async$returnValue = map.$index(0, key);
                // goto return
                $async$goto = 1;
                break;
              }
              $async$goto = 3;
              return P._asyncAwait(ifAbsent.call$0(), $async$putIfAbsentAsync);
            case 3:
              // returning from await.
              value = $async$result;
              map.$indexSet(0, key, value);
              $async$returnValue = value;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$putIfAbsentAsync, $async$completer);
    },
    mapMapAsync: function(map, value, K1, V1, K2, V2) {
      return B.mapMapAsync$body(map, value, K1, V1, K2, V2, [P.Map, K2, V2]);
    },
    mapMapAsync$body: function(map, value, K1, V1, K2, V2, $async$type) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter($async$type),
        $async$returnValue, t1, mapKey, mapValue, key, result, $async$temp1, $async$temp2;
      var $async$mapMapAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              key = new B.mapMapAsync_closure(K2, K1, V1);
              result = P.LinkedHashMap_LinkedHashMap$_empty(K2, V2);
              t1 = J.get$iterator$ax(map.get$keys());
            case 3:
              // for condition
              if (!t1.moveNext$0()) {
                // goto after for
                $async$goto = 4;
                break;
              }
              mapKey = t1.get$current(t1);
              mapValue = map.$index(0, mapKey);
              $async$temp1 = result;
              $async$goto = 5;
              return P._asyncAwait(key.call$2(mapKey, mapValue), $async$mapMapAsync);
            case 5:
              // returning from await.
              $async$temp2 = $async$result;
              $async$goto = 6;
              return P._asyncAwait(value.call$2(mapKey, mapValue), $async$mapMapAsync);
            case 6:
              // returning from await.
              $async$temp1.$indexSet(0, $async$temp2, $async$result);
              // goto for condition
              $async$goto = 3;
              break;
            case 4:
              // after for
              $async$returnValue = result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$mapMapAsync, $async$completer);
    },
    copyMapOfMap: function(map, K1, K2, $V) {
      var t1 = [P.Map, K2, $V];
      return Y.mapMap(map, null, new B.copyMapOfMap_closure(K2, $V), K1, t1, K1, t1);
    },
    copyMapOfList: function(map, $K, $E) {
      var t1 = [P.List, $E];
      return Y.mapMap(map, null, new B.copyMapOfList_closure(), $K, t1, $K, t1);
    },
    indent_closure: function indent_closure(t0) {
      this.indentation = t0;
    },
    bulletedList_closure: function bulletedList_closure() {
    },
    flattenVertically_closure: function flattenVertically_closure(t0) {
      this.T = t0;
    },
    flattenVertically_closure0: function flattenVertically_closure0(t0) {
      this.result = t0;
    },
    longestCommonSubsequence_closure: function longestCommonSubsequence_closure(t0) {
      this.T = t0;
    },
    longestCommonSubsequence_closure0: function longestCommonSubsequence_closure0(t0) {
      this.list2 = t0;
    },
    longestCommonSubsequence_closure1: function longestCommonSubsequence_closure1(t0, t1) {
      this.list2 = t0;
      this.T = t1;
    },
    longestCommonSubsequence_backtrack: function longestCommonSubsequence_backtrack(t0, t1, t2) {
      this.selections = t0;
      this.lengths = t1;
      this.T = t2;
    },
    mapAddAll2_closure: function mapAddAll2_closure(t0) {
      this.destination = t0;
    },
    mapMapAsync_closure: function mapMapAsync_closure(t0, t1, t2) {
      this.K2 = t0;
      this.K1 = t1;
      this.V1 = t2;
    },
    copyMapOfMap_closure: function copyMapOfMap_closure(t0, t1) {
      this.K2 = t0;
      this.V = t1;
    },
    copyMapOfList_closure: function copyMapOfList_closure() {
    },
    isAlphabetic: function(char) {
      var t1;
      if (!(char >= 65 && char <= 90))
        t1 = char >= 97 && char <= 122;
      else
        t1 = true;
      return t1;
    },
    isDriveLetter: function(path, index) {
      var t1 = path.length,
        t2 = index + 2;
      if (t1 < t2)
        return false;
      if (!B.isAlphabetic(C.JSString_methods.codeUnitAt$1(path, index)))
        return false;
      if (C.JSString_methods.codeUnitAt$1(path, index + 1) !== 58)
        return false;
      if (t1 === t2)
        return true;
      return C.JSString_methods.codeUnitAt$1(path, t2) === 47;
    },
    countCodeUnits: function(string, codeUnit) {
      var t1, count;
      for (t1 = new H.CodeUnits(string), t1 = new H.ListIterator(t1, t1.get$length(t1)), count = 0; t1.moveNext$0();)
        if (t1.__internal$_current === codeUnit)
          ++count;
      return count;
    },
    findLineStart: function(context, text, column) {
      var beginningOfLine, index, lineStart;
      if (text.length === 0)
        for (beginningOfLine = 0; true;) {
          index = C.JSString_methods.indexOf$2(context, "\n", beginningOfLine);
          if (index === -1)
            return context.length - beginningOfLine >= column ? beginningOfLine : null;
          if (index - beginningOfLine >= column)
            return beginningOfLine;
          beginningOfLine = index + 1;
        }
      index = C.JSString_methods.indexOf$1(context, text);
      for (; index !== -1;) {
        lineStart = index === 0 ? 0 : C.JSString_methods.lastIndexOf$2(context, "\n", index - 1) + 1;
        if (column === index - lineStart)
          return lineStart;
        index = C.JSString_methods.indexOf$2(context, text, index + 1);
      }
      return;
    },
    validateErrorArgs: function(string, match, position, $length) {
      var t2,
        t1 = position != null;
      if (t1)
        if (position < 0)
          throw H.wrapException(P.RangeError$("position must be greater than or equal to 0."));
        else if (position > string.length)
          throw H.wrapException(P.RangeError$("position must be less than or equal to the string length."));
      t2 = $length != null;
      if (t2 && $length < 0)
        throw H.wrapException(P.RangeError$("length must be greater than or equal to 0."));
      if (t1 && t2 && position + $length > string.length)
        throw H.wrapException(P.RangeError$("position plus length must not go beyond the end of the string."));
    }
  },
  O = {
    EmptyUnmodifiableSet__throw: function() {
      throw H.wrapException(P.UnsupportedError$("Cannot modify an unmodifiable Set"));
    },
    EmptyUnmodifiableSet: function EmptyUnmodifiableSet(t0) {
      this.$ti = t0;
    },
    Style__getPlatformStyle: function() {
      if (P.Uri_base().get$scheme() !== "file")
        return $.$get$Style_url();
      var t1 = P.Uri_base();
      if (!C.JSString_methods.endsWith$1(t1.get$path(t1), "/"))
        return $.$get$Style_url();
      if (P._Uri__Uri(null, "a/b", null, null).toFilePath$0() === "a\\b")
        return $.$get$Style_windows();
      return $.$get$Style_posix();
    },
    Style: function Style() {
    },
    NullExpression: function NullExpression(t0) {
      this.span = t0;
    },
    Statement: function Statement() {
    },
    AsyncImportCache$none: function(logger) {
      var t1 = logger == null ? C.StderrLogger_false : logger,
        t2 = P.Uri;
      return new O.AsyncImportCache(C.List_empty14, t1, P.LinkedHashMap_LinkedHashMap$_empty([S.Tuple2, P.Uri, P.bool], [S.Tuple3, B.AsyncImporter, P.Uri, P.Uri]), P.LinkedHashMap_LinkedHashMap$_empty(t2, V.Stylesheet), P.LinkedHashMap_LinkedHashMap$_empty(t2, E.ImporterResult));
    },
    AsyncImportCache__toImporters: function(importers, loadPaths, packageResolver) {
      var _i, t2, t3, path, _null = null,
        sassPath = H.stringTypeCast(J.get$env$x(self.process).SASS_PATH),
        t1 = H.setRuntimeTypeInfo([], [B.AsyncImporter]);
      for (_i = 0; false; ++_i)
        t1.push(importers[_i]);
      if (loadPaths != null)
        for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
          t3 = t2.get$current(t2);
          t1.push(new F.FilesystemImporter($.$get$context().absolute$7(t3, _null, _null, _null, _null, _null, _null)));
        }
      if (sassPath != null) {
        t2 = sassPath.split(J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":");
        t3 = t2.length;
        _i = 0;
        for (; _i < t3; ++_i) {
          path = t2[_i];
          t1.push(new F.FilesystemImporter($.$get$context().absolute$7(path, _null, _null, _null, _null, _null, _null)));
        }
      }
      return t1;
    },
    AsyncImportCache: function AsyncImportCache(t0, t1, t2, t3, t4) {
      var _ = this;
      _._async_import_cache$_importers = t0;
      _._async_import_cache$_logger = t1;
      _._async_import_cache$_canonicalizeCache = t2;
      _._async_import_cache$_importCache = t3;
      _._async_import_cache$_resultsCache = t4;
    },
    AsyncImportCache_canonicalize_closure: function AsyncImportCache_canonicalize_closure(t0, t1, t2) {
      this.$this = t0;
      this.url = t1;
      this.forImport = t2;
    },
    AsyncImportCache__canonicalize_closure: function AsyncImportCache__canonicalize_closure(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    AsyncImportCache_importCanonical_closure: function AsyncImportCache_importCanonical_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
    },
    AsyncImportCache_humanize_closure: function AsyncImportCache_humanize_closure(t0) {
      this.canonicalUrl = t0;
    },
    AsyncImportCache_humanize_closure0: function AsyncImportCache_humanize_closure0() {
    },
    AsyncImportCache_humanize_closure1: function AsyncImportCache_humanize_closure1() {
    },
    Environment$: function(sourceMap) {
      var _null = null,
        t1 = P.String,
        t2 = [G.Module, D.Callable],
        t3 = H.setRuntimeTypeInfo([], [t2]),
        t4 = H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, F.Value)], [[P.Map, P.String, F.Value]]),
        t5 = sourceMap ? H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, B.AstNode)], [[P.Map, P.String, B.AstNode]]) : _null,
        t6 = P.int,
        t7 = D.Callable,
        t8 = [[P.Map, P.String, D.Callable]];
      return new O.Environment(P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _null, _null, _null, t3, t4, t5, P.LinkedHashMap_LinkedHashMap$_empty(t1, t6), H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, t7)], t8), P.LinkedHashMap_LinkedHashMap$_empty(t1, t6), H.setRuntimeTypeInfo([P.LinkedHashMap_LinkedHashMap$_empty(t1, t7)], t8), P.LinkedHashMap_LinkedHashMap$_empty(t1, t6), _null);
    },
    Environment$_: function(_modules, _globalModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, _functions, _mixins, _content) {
      var t1 = P.String,
        t2 = P.int;
      return new O.Environment(_modules, _globalModules, _forwardedModules, _nestedForwardedModules, _allModules, _variables, _variableNodes, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _functions, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _mixins, P.LinkedHashMap_LinkedHashMap$_empty(t1, t2), _content);
    },
    _EnvironmentModule__EnvironmentModule: function(environment, css, extender, forwarded) {
      var t1, t2, t3, t4, t5, t6;
      if (forwarded == null)
        forwarded = C.List_empty0;
      t1 = O._EnvironmentModule__makeModulesByVariable(forwarded);
      t2 = H.getTypeArgumentByIndex(forwarded, 0);
      t3 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._variables), new H.MappedListIterable(forwarded, new O._EnvironmentModule__EnvironmentModule_closure(), [t2, [P.Map, P.String, F.Value]]), F.Value);
      t4 = environment._variableNodes;
      t4 = t4 == null ? null : O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(t4), new H.MappedListIterable(forwarded, new O._EnvironmentModule__EnvironmentModule_closure0(), [t2, [P.Map, P.String, B.AstNode]]), B.AstNode);
      t2 = [t2, [P.Map, P.String, D.Callable]];
      t5 = D.Callable;
      t6 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._functions), new H.MappedListIterable(forwarded, new O._EnvironmentModule__EnvironmentModule_closure1(), t2), t5);
      t5 = O._EnvironmentModule__memberMap(C.JSArray_methods.get$first(environment._mixins), new H.MappedListIterable(forwarded, new O._EnvironmentModule__EnvironmentModule_closure2(), t2), t5);
      t2 = J.get$isNotEmpty$asx(css.get$children()) || C.JSArray_methods.any$1(environment._allModules, new O._EnvironmentModule__EnvironmentModule_closure3());
      return O._EnvironmentModule$_(environment, css, extender, t1, t3, t4, t6, t5, t2, !extender.get$isEmpty(extender) || C.JSArray_methods.any$1(environment._allModules, new O._EnvironmentModule__EnvironmentModule_closure4()));
    },
    _EnvironmentModule__makeModulesByVariable: function(forwarded) {
      var modulesByVariable, _i, module, t2, t3,
        t1 = forwarded.length;
      if (t1 === 0)
        return C.Map_empty0;
      modulesByVariable = P.LinkedHashMap_LinkedHashMap$_empty(P.String, [G.Module, D.Callable]);
      for (_i = 0; _i < forwarded.length; forwarded.length === t1 || (0, H.throwConcurrentModificationError)(forwarded), ++_i) {
        module = forwarded[_i];
        if (module instanceof O._EnvironmentModule) {
          for (t2 = module._modulesByVariable.get$values(), t2 = t2.get$iterator(t2); t2.moveNext$0();) {
            t3 = t2.get$current(t2);
            B.setAll(modulesByVariable, t3.get$variables().get$keys(), t3);
          }
          B.setAll(modulesByVariable, C.JSArray_methods.get$first(module._environment._variables).get$keys(), module);
        } else
          B.setAll(modulesByVariable, module.get$variables().get$keys(), module);
      }
      return modulesByVariable;
    },
    _EnvironmentModule__memberMap: function(localMap, otherMaps, $V) {
      var t1, t2, t3;
      localMap = new U.PublicMemberMapView(localMap, [$V]);
      if (otherMaps.get$length(otherMaps) === 0)
        return localMap;
      t1 = H.setRuntimeTypeInfo([], [[P.Map, P.String, $V]]);
      for (t2 = new H.ListIterator(otherMaps, otherMaps.get$length(otherMaps)); t2.moveNext$0();) {
        t3 = t2.__internal$_current;
        if (t3.get$isNotEmpty(t3))
          t1.push(t3);
      }
      t1.push(localMap);
      if (t1.length === 1)
        return localMap;
      return Z.MergedMapView$(t1, P.String, $V);
    },
    _EnvironmentModule$_: function(_environment, css, extender, _modulesByVariable, variables, variableNodes, functions, mixins, transitivelyContainsCss, transitivelyContainsExtensions) {
      return new O._EnvironmentModule(_environment._allModules, variables, variableNodes, functions, mixins, extender, css, transitivelyContainsCss, transitivelyContainsExtensions, _environment, _modulesByVariable);
    },
    Environment: function Environment(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12) {
      var _ = this;
      _._environment$_modules = t0;
      _._globalModules = t1;
      _._forwardedModules = t2;
      _._nestedForwardedModules = t3;
      _._allModules = t4;
      _._variables = t5;
      _._variableNodes = t6;
      _._variableIndices = t7;
      _._functions = t8;
      _._functionIndices = t9;
      _._mixins = t10;
      _._mixinIndices = t11;
      _._content = t12;
      _._inMixin = false;
      _._inSemiGlobalScope = true;
      _._lastVariableIndex = _._lastVariableName = null;
    },
    Environment_importForwards_closure: function Environment_importForwards_closure() {
    },
    Environment_importForwards_closure0: function Environment_importForwards_closure0() {
    },
    Environment_importForwards_closure1: function Environment_importForwards_closure1() {
    },
    Environment_importForwards_closure2: function Environment_importForwards_closure2() {
    },
    Environment__getVariableFromGlobalModule_closure: function Environment__getVariableFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure: function Environment_setVariable_closure(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment_setVariable_closure0: function Environment_setVariable_closure0(t0) {
      this.name = t0;
    },
    Environment_setVariable_closure1: function Environment_setVariable_closure1(t0, t1) {
      this.$this = t0;
      this.name = t1;
    },
    Environment__getFunctionFromGlobalModule_closure: function Environment__getFunctionFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment__getMixinFromGlobalModule_closure: function Environment__getMixinFromGlobalModule_closure(t0) {
      this.name = t0;
    },
    Environment__fromOneModule_closure: function Environment__fromOneModule_closure(t0) {
      this.callback = t0;
    },
    Environment__fromOneModule_closure0: function Environment__fromOneModule_closure0() {
    },
    _EnvironmentModule: function _EnvironmentModule(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10) {
      var _ = this;
      _.upstream = t0;
      _.variables = t1;
      _.variableNodes = t2;
      _.functions = t3;
      _.mixins = t4;
      _.extender = t5;
      _.css = t6;
      _.transitivelyContainsCss = t7;
      _.transitivelyContainsExtensions = t8;
      _._environment = t9;
      _._modulesByVariable = t10;
    },
    _EnvironmentModule__EnvironmentModule_closure: function _EnvironmentModule__EnvironmentModule_closure() {
    },
    _EnvironmentModule__EnvironmentModule_closure0: function _EnvironmentModule__EnvironmentModule_closure0() {
    },
    _EnvironmentModule__EnvironmentModule_closure1: function _EnvironmentModule__EnvironmentModule_closure1() {
    },
    _EnvironmentModule__EnvironmentModule_closure2: function _EnvironmentModule__EnvironmentModule_closure2() {
    },
    _EnvironmentModule__EnvironmentModule_closure3: function _EnvironmentModule__EnvironmentModule_closure3() {
    },
    _EnvironmentModule__EnvironmentModule_closure4: function _EnvironmentModule__EnvironmentModule_closure4() {
    },
    closure104: function closure104() {
    },
    _closure13: function _closure13() {
    },
    _closure14: function _closure14() {
    },
    SassNull: function SassNull() {
    }
  },
  U = {DefaultEquality: function DefaultEquality() {
    }, ListEquality: function ListEquality() {
    }, _MapEntry: function _MapEntry(t0, t1, t2) {
      this.equality = t0;
      this.key = t1;
      this.value = t2;
    }, MapEquality: function MapEquality() {
    }, ModifiableCssAtRule: function ModifiableCssAtRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.isChildless = t2;
      _.span = t3;
      _.children = t4;
      _._children = t5;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    }, ModifiableCssKeyframeBlock: function ModifiableCssKeyframeBlock(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _._children = t3;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    AtRule$: function($name, span, children, value) {
      var t1 = children == null ? null : P.List_List$unmodifiable(children, O.Statement),
        t2 = t1 == null ? null : C.JSArray_methods.any$1(t1, new M.ParentStatement_closure());
      return new U.AtRule($name, value, span, t1, t2 === true);
    },
    AtRule: function AtRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.value = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    SupportsOperation: function SupportsOperation(t0, t1, t2, t3) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.operator = t2;
      _.span = t3;
    },
    compile: function(path, charset, functions, importCache, indentWidth, lineFeed, logger, nodeImporter, sourceMap, style, syntax, useSpaces) {
      var t1, t2, stylesheet;
      if (nodeImporter == null)
        t1 = syntax == null || syntax === M.Syntax_forPath(path);
      else
        t1 = false;
      if (t1) {
        if (importCache == null)
          importCache = R.ImportCache$none(logger);
        t1 = D.absolute(".");
        t2 = $.$get$context();
        stylesheet = importCache.importCanonical$3(new F.FilesystemImporter(t1), t2.toUri$1(t2.canonicalize$1(path)), t2.toUri$1(path));
      } else {
        t1 = B.readFile(path);
        t2 = syntax == null ? M.Syntax_forPath(path) : syntax;
        stylesheet = V.Stylesheet_Stylesheet$parse(t1, t2, logger, $.$get$context().toUri$1(path));
      }
      return U._compileStylesheet(stylesheet, logger, importCache, nodeImporter, new F.FilesystemImporter(D.absolute(".")), functions, style, useSpaces, indentWidth, lineFeed, sourceMap, charset);
    },
    compileString: function(source, charset, functions, importCache, importer, indentWidth, lineFeed, logger, nodeImporter, sourceMap, style, syntax, url, useSpaces) {
      var stylesheet = V.Stylesheet_Stylesheet$parse(source, syntax == null ? C.Syntax_SCSS : syntax, logger, url);
      return U._compileStylesheet(stylesheet, logger, importCache, nodeImporter, importer == null ? new F.FilesystemImporter(D.absolute(".")) : importer, functions, style, useSpaces, indentWidth, lineFeed, sourceMap, charset);
    },
    _compileStylesheet: function(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, sourceMap, charset) {
      var evaluateResult = R._EvaluateVisitor$(functions, importCache, logger, nodeImporter, sourceMap).run$2(0, importer, stylesheet),
        serializeResult = N.serialize(evaluateResult.stylesheet, charset, indentWidth, false, lineFeed, sourceMap, style, useSpaces),
        t1 = serializeResult.sourceMap;
      if (t1 != null && importCache != null)
        B.mapInPlace(t1.urls, new U._compileStylesheet_closure(stylesheet, importCache));
      return new X.CompileResult(evaluateResult, serializeResult);
    },
    _compileStylesheet_closure: function _compileStylesheet_closure(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    RenderResult: function RenderResult() {
    },
    RenderResultStats: function RenderResultStats() {
    },
    SassParser: function SassParser(t0, t1, t2) {
      var _ = this;
      _._currentIndentation = 0;
      _._spaces = _._nextIndentationEnd = _._nextIndentation = null;
      _._isUseAllowed = true;
      _._stylesheet$_inMixin = false;
      _._mixinHasContent = null;
      _._inParentheses = _._inStyleRule = _._stylesheet$_inUnknownAtRule = _._inControlDirective = _._inContentBlock = false;
      _._globalVariables = t0;
      _.lastSilentComment = null;
      _.scanner = t1;
      _.logger = t2;
    },
    SassParser_children_closure: function SassParser_children_closure(t0, t1, t2) {
      this.$this = t0;
      this.children = t1;
      this.child = t2;
    },
    MultiDirWatcher: function MultiDirWatcher(t0, t1, t2) {
      this._watchers = t0;
      this._group = t1;
      this._poll = t2;
    },
    PublicMemberMapView: function PublicMemberMapView(t0, t1) {
      this._inner = t0;
      this.$ti = t1;
    },
    Highlighter__normalizeNewlines: function(span) {
      var endOffset, t1, i, t2, t3, t4,
        text = span.get$text();
      if (!C.JSString_methods.contains$1(text, "\r\n"))
        return span;
      endOffset = span.get$end(span).get$offset();
      for (t1 = text.length - 1, i = 0; i < t1; ++i)
        if (C.JSString_methods._codeUnitAt$1(text, i) === 13 && C.JSString_methods._codeUnitAt$1(text, i + 1) === 10)
          --endOffset;
      t1 = span.get$start(span);
      t2 = span.get$sourceUrl();
      t3 = span.get$end(span).get$line();
      t2 = V.SourceLocation$(endOffset, span.get$end(span).get$column(), t3, t2);
      t3 = H.stringReplaceAllUnchecked(text, "\r\n", "\n");
      t4 = span.get$context(span);
      return X.SourceSpanWithContext$(t1, t2, t3, H.stringReplaceAllUnchecked(t4, "\r\n", "\n"));
    },
    Highlighter__normalizeTrailingNewline: function(span) {
      var context, text, start, end, t1, t2, t3;
      if (!C.JSString_methods.endsWith$1(span.get$context(span), "\n"))
        return span;
      if (C.JSString_methods.endsWith$1(span.get$text(), "\n\n"))
        return span;
      context = C.JSString_methods.substring$2(span.get$context(span), 0, span.get$context(span).length - 1);
      text = span.get$text();
      start = span.get$start(span);
      end = span.get$end(span);
      if (C.JSString_methods.endsWith$1(span.get$text(), "\n") && B.findLineStart(span.get$context(span), span.get$text(), span.get$start(span).get$column()) + span.get$start(span).get$column() + span.get$length(span) === span.get$context(span).length) {
        text = C.JSString_methods.substring$2(span.get$text(), 0, span.get$text().length - 1);
        t1 = span.get$end(span).get$offset();
        t2 = span.get$sourceUrl();
        t3 = span.get$end(span).get$line();
        end = V.SourceLocation$(t1 - 1, U.Highlighter__lastLineLength(text), t3 - 1, t2);
        start = span.get$start(span).get$offset() == span.get$end(span).get$offset() ? end : span.get$start(span);
      }
      return X.SourceSpanWithContext$(start, end, text, context);
    },
    Highlighter__normalizeEndOfLine: function(span) {
      var text, t1, t2, t3, t4;
      if (span.get$end(span).get$column() !== 0)
        return span;
      if (span.get$end(span).get$line() == span.get$start(span).get$line())
        return span;
      text = C.JSString_methods.substring$2(span.get$text(), 0, span.get$text().length - 1);
      t1 = span.get$start(span);
      t2 = span.get$end(span).get$offset();
      t3 = span.get$sourceUrl();
      t4 = span.get$end(span).get$line();
      return X.SourceSpanWithContext$(t1, V.SourceLocation$(t2 - 1, U.Highlighter__lastLineLength(text), t4 - 1, t3), text, span.get$context(span));
    },
    Highlighter__lastLineLength: function(text) {
      var t1 = text.length;
      if (t1 === 0)
        return 0;
      if (C.JSString_methods.codeUnitAt$1(text, t1 - 1) === 10)
        return t1 === 1 ? 0 : t1 - C.JSString_methods.lastIndexOf$2(text, "\n", t1 - 2) - 1;
      else
        return t1 - C.JSString_methods.lastIndexOf$1(text, "\n") - 1;
    },
    Highlighter: function Highlighter(t0, t1, t2, t3, t4) {
      var _ = this;
      _._highlighter$_span = t0;
      _._color = t1;
      _._multiline = t2;
      _._paddingBeforeSidebar = t3;
      _._highlighter$_buffer = t4;
    },
    Highlighter__writeFirstLine_closure: function Highlighter__writeFirstLine_closure(t0, t1) {
      this.$this = t0;
      this.line = t1;
    },
    Highlighter__writeFirstLine_closure0: function Highlighter__writeFirstLine_closure0(t0, t1) {
      this.$this = t0;
      this.textInside = t1;
    },
    Highlighter__writeFirstLine_closure1: function Highlighter__writeFirstLine_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Highlighter__writeFirstLine_closure2: function Highlighter__writeFirstLine_closure2(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Highlighter__writeIntermediateLines_closure: function Highlighter__writeIntermediateLines_closure(t0, t1) {
      this.$this = t0;
      this.line = t1;
    },
    Highlighter__writeLastLine_closure: function Highlighter__writeLastLine_closure(t0, t1) {
      this.$this = t0;
      this.line = t1;
    },
    Highlighter__writeLastLine_closure0: function Highlighter__writeLastLine_closure0(t0, t1) {
      this.$this = t0;
      this.textInside = t1;
    },
    Highlighter__writeLastLine_closure1: function Highlighter__writeLastLine_closure1(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    Highlighter__writeSidebar_closure: function Highlighter__writeSidebar_closure(t0, t1, t2) {
      this.$this = t0;
      this.line = t1;
      this.end = t2;
    },
    Chain_Chain$parse: function(chain) {
      var t1, t2,
        _s26_ = "<asynchronous suspension>\n",
        _s51_ = "===== asynchronous gap ===========================\n";
      if (chain.length === 0) {
        t1 = Y.Trace;
        return new U.Chain(P.List_List$unmodifiable(H.setRuntimeTypeInfo([], [t1]), t1));
      }
      if (C.JSString_methods.contains$1(chain, _s26_)) {
        t1 = H.setRuntimeTypeInfo(chain.split(_s26_), [P.String]);
        t2 = Y.Trace;
        return new U.Chain(P.List_List$unmodifiable(new H.MappedListIterable(t1, new U.Chain_Chain$parse_closure(), [H.getTypeArgumentByIndex(t1, 0), t2]), t2));
      }
      if (!C.JSString_methods.contains$1(chain, _s51_)) {
        t1 = Y.Trace;
        return new U.Chain(P.List_List$unmodifiable(H.setRuntimeTypeInfo([Y.Trace_Trace$parse(chain)], [t1]), t1));
      }
      t1 = H.setRuntimeTypeInfo(chain.split(_s51_), [P.String]);
      t2 = Y.Trace;
      return new U.Chain(P.List_List$unmodifiable(new H.MappedListIterable(t1, new U.Chain_Chain$parse_closure0(), [H.getTypeArgumentByIndex(t1, 0), t2]), t2));
    },
    Chain: function Chain(t0) {
      this.traces = t0;
    },
    Chain_Chain$parse_closure: function Chain_Chain$parse_closure() {
    },
    Chain_Chain$parse_closure0: function Chain_Chain$parse_closure0() {
    },
    Chain_toTrace_closure: function Chain_toTrace_closure() {
    },
    Chain_toString_closure0: function Chain_toString_closure0() {
    },
    Chain_toString__closure0: function Chain_toString__closure0() {
    },
    Chain_toString_closure: function Chain_toString_closure(t0) {
      this.longest = t0;
    },
    Chain_toString__closure: function Chain_toString__closure(t0) {
      this.longest = t0;
    }
  },
  M = {_DelegatingIterableBase: function _DelegatingIterableBase() {
    }, DelegatingIterable: function DelegatingIterable() {
    }, DelegatingSet: function DelegatingSet(t0, t1) {
      this._base = t0;
      this.$ti = t1;
    }, MapKeySet: function MapKeySet(t0, t1) {
      this._baseMap = t0;
      this.$ti = t1;
    }, _MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin: function _MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin() {
    },
    Context_Context: function(style) {
      var current = style == null ? D.current() : ".";
      if (style == null)
        style = $.$get$Style_platform();
      return new M.Context(style, current);
    },
    _parseUri: function(uri) {
      if (typeof uri === "string")
        return P.Uri_parse(uri);
      if (!!J.getInterceptor$(uri).$isUri)
        return uri;
      throw H.wrapException(P.ArgumentError$value(uri, "uri", "Value must be a String or a Uri"));
    },
    _validateArgList: function(method, args) {
      var numArgs, i, numArgs0, message, t1, t2;
      for (numArgs = args.length, i = 1; i < numArgs; ++i) {
        if (args[i] == null || args[i - 1] != null)
          continue;
        for (; numArgs >= 1; numArgs = numArgs0) {
          numArgs0 = numArgs - 1;
          if (args[numArgs0] != null)
            break;
        }
        message = new P.StringBuffer("");
        t1 = method + "(";
        message._contents = t1;
        t2 = H.SubListIterable$(args, 0, numArgs, H.getTypeArgumentByIndex(args, 0));
        t2 = t1 + new H.MappedListIterable(t2, new M._validateArgList_closure(), [H.getTypeArgumentByIndex(t2, 0), P.String]).join$1(0, ", ");
        message._contents = t2;
        message._contents = t2 + ("): part " + (i - 1) + " was null, but part " + i + " was not.");
        throw H.wrapException(P.ArgumentError$(message.toString$0(0)));
      }
    },
    Context: function Context(t0, t1) {
      this.style = t0;
      this._context$_current = t1;
    },
    Context_join_closure: function Context_join_closure() {
    },
    Context_joinAll_closure: function Context_joinAll_closure() {
    },
    Context_split_closure: function Context_split_closure() {
    },
    _validateArgList_closure: function _validateArgList_closure() {
    },
    _PathDirection: function _PathDirection(t0) {
      this.name = t0;
    },
    _PathRelation: function _PathRelation(t0) {
      this.name = t0;
    },
    CallableDeclaration: function CallableDeclaration() {
    },
    FunctionRule: function FunctionRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.name = t0;
      _.$arguments = t1;
      _.span = t2;
      _.children = t3;
      _.hasDeclarations = t4;
    },
    ParentStatement: function ParentStatement() {
    },
    ParentStatement_closure: function ParentStatement_closure() {
    },
    ParentStatement__closure: function ParentStatement__closure() {
    },
    SupportsNegation: function SupportsNegation(t0, t1) {
      this.condition = t0;
      this.span = t1;
    },
    ParentSelector: function ParentSelector(t0) {
      this.suffix = t0;
    },
    SimpleSelector: function SimpleSelector() {
    },
    Importer: function Importer() {
    },
    StylesheetNode$_: function(_stylesheet, importer, canonicalUrl, allUpstream) {
      var t1 = new M.StylesheetNode(importer, canonicalUrl, allUpstream.item1, allUpstream.item2, P.LinkedHashSet_LinkedHashSet$_empty(M.StylesheetNode));
      t1.StylesheetNode$_$4(_stylesheet, importer, canonicalUrl, allUpstream);
      return t1;
    },
    StylesheetGraph: function StylesheetGraph(t0, t1, t2) {
      this._nodes = t0;
      this.importCache = t1;
      this._transitiveModificationTimes = t2;
    },
    StylesheetGraph_modifiedSince_transitiveModificationTime: function StylesheetGraph_modifiedSince_transitiveModificationTime(t0) {
      this.$this = t0;
    },
    StylesheetGraph_modifiedSince_transitiveModificationTime_closure: function StylesheetGraph_modifiedSince_transitiveModificationTime_closure(t0, t1) {
      this.node = t0;
      this.transitiveModificationTime = t1;
    },
    StylesheetGraph__add_closure: function StylesheetGraph__add_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.baseImporter = t2;
      _.baseUrl = t3;
    },
    StylesheetGraph_addCanonical_closure: function StylesheetGraph_addCanonical_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
    },
    StylesheetGraph_addCanonical_closure0: function StylesheetGraph_addCanonical_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.stylesheet = t1;
      _.importer = t2;
      _.canonicalUrl = t3;
    },
    StylesheetGraph_reload_closure: function StylesheetGraph_reload_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.canonicalUrl = t2;
    },
    StylesheetGraph__nodeFor_closure: function StylesheetGraph__nodeFor_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.baseImporter = t2;
      _.baseUrl = t3;
      _.forImport = t4;
    },
    StylesheetGraph__nodeFor_closure0: function StylesheetGraph__nodeFor_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.resolvedUrl = t3;
    },
    StylesheetNode: function StylesheetNode(t0, t1, t2, t3, t4) {
      var _ = this;
      _.importer = t0;
      _.canonicalUrl = t1;
      _._upstream = t2;
      _._upstreamImports = t3;
      _._downstream = t4;
    },
    Syntax_forPath: function(path) {
      switch (X.ParsedPath_ParsedPath$parse(path, $.$get$context().style)._splitExtension$0()[1]) {
        case ".sass":
          return C.Syntax_Sass;
        case ".css":
          return C.Syntax_CSS;
        default:
          return C.Syntax_SCSS;
      }
    },
    Syntax: function Syntax(t0) {
      this._name = t0;
    }
  },
  X = {
    ParsedPath_ParsedPath$parse: function(path, style) {
      var t1, parts, separators, start, i,
        root = style.getRoot$1(path),
        isRootRelative = style.isRootRelative$1(path);
      if (root != null)
        path = J.substring$1$s(path, root.length);
      t1 = [P.String];
      parts = H.setRuntimeTypeInfo([], t1);
      separators = H.setRuntimeTypeInfo([], t1);
      t1 = path.length;
      if (t1 !== 0 && style.isSeparator$1(C.JSString_methods._codeUnitAt$1(path, 0))) {
        separators.push(path[0]);
        start = 1;
      } else {
        separators.push("");
        start = 0;
      }
      for (i = start; i < t1; ++i)
        if (style.isSeparator$1(C.JSString_methods._codeUnitAt$1(path, i))) {
          parts.push(C.JSString_methods.substring$2(path, start, i));
          separators.push(path[i]);
          start = i + 1;
        }
      if (start < t1) {
        parts.push(C.JSString_methods.substring$1(path, start));
        separators.push("");
      }
      return new X.ParsedPath(style, root, isRootRelative, parts, separators);
    },
    ParsedPath: function ParsedPath(t0, t1, t2, t3, t4) {
      var _ = this;
      _.style = t0;
      _.root = t1;
      _.isRootRelative = t2;
      _.parts = t3;
      _.separators = t4;
    },
    ParsedPath_normalize_closure: function ParsedPath_normalize_closure(t0) {
      this.$this = t0;
    },
    ParsedPath__splitExtension_closure: function ParsedPath__splitExtension_closure() {
    },
    ParsedPath__splitExtension_closure0: function ParsedPath__splitExtension_closure0() {
    },
    PathException$: function(message) {
      return new X.PathException(message);
    },
    PathException: function PathException(t0) {
      this.message = t0;
    },
    ModifiableCssStyleRule$: function(selector, span, originalSelector) {
      var t1 = originalSelector == null ? selector.value : originalSelector,
        t2 = B.ModifiableCssNode,
        t3 = H.setRuntimeTypeInfo([], [t2]);
      return new X.ModifiableCssStyleRule(selector, t1, span, new P.UnmodifiableListView(t3, [t2]), t3);
    },
    ModifiableCssStyleRule: function ModifiableCssStyleRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.selector = t0;
      _.originalSelector = t1;
      _.span = t2;
      _.children = t3;
      _._children = t4;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ArgumentInvocation$: function(positional, named, span, keywordRest, rest) {
      var t1 = T.Expression;
      return new X.ArgumentInvocation(P.List_List$unmodifiable(positional, t1), H.ConstantMap_ConstantMap$from(named, P.String, t1), rest, keywordRest, span);
    },
    ArgumentInvocation: function ArgumentInvocation(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.named = t1;
      _.rest = t2;
      _.keywordRest = t3;
      _.span = t4;
    },
    UnaryOperationExpression: function UnaryOperationExpression(t0, t1, t2) {
      this.operator = t0;
      this.operand = t1;
      this.span = t2;
    },
    UnaryOperator: function UnaryOperator(t0, t1) {
      this.name = t0;
      this.operator = t1;
    },
    Interpolation$: function(contents, span) {
      var t1 = new X.Interpolation(P.List_List$unmodifiable(contents, P.Object), span);
      t1.Interpolation$2(contents, span);
      return t1;
    },
    Interpolation: function Interpolation(t0, t1) {
      this.contents = t0;
      this.span = t1;
    },
    Interpolation_toString_closure: function Interpolation_toString_closure() {
    },
    ExtendRule: function ExtendRule(t0, t1, t2) {
      this.selector = t0;
      this.isOptional = t1;
      this.span = t2;
    },
    StyleRule: function StyleRule(t0, t1, t2, t3) {
      var _ = this;
      _.selector = t0;
      _.span = t1;
      _.children = t2;
      _.hasDeclarations = t3;
    },
    SupportsInterpolation: function SupportsInterpolation(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    ClassSelector: function ClassSelector(t0) {
      this.name = t0;
    },
    CompoundSelector$: function(components) {
      var t1 = P.List_List$unmodifiable(components, M.SimpleSelector);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty."));
      return new X.CompoundSelector(t1);
    },
    CompoundSelector: function CompoundSelector(t0) {
      this.components = t0;
      this._compound$_maxSpecificity = this._compound$_minSpecificity = null;
    },
    CompoundSelector_isInvisible_closure: function CompoundSelector_isInvisible_closure() {
    },
    compileAsync: function(path, charset, functions, importCache, indentWidth, lineFeed, logger, nodeImporter, sourceMap, style, syntax, useSpaces) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(X.CompileResult),
        $async$returnValue, t1, t2, stylesheet;
      var $async$compileAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              if (nodeImporter == null)
                t1 = syntax == null || syntax === M.Syntax_forPath(path);
              else
                t1 = false;
              $async$goto = t1 ? 3 : 5;
              break;
            case 3:
              // then
              if (importCache == null)
                importCache = O.AsyncImportCache$none(logger);
              t1 = D.absolute(".");
              t2 = $.$get$context();
              $async$goto = 6;
              return P._asyncAwait(importCache.importCanonical$3(new F.FilesystemImporter(t1), t2.toUri$1(t2.canonicalize$1(path)), t2.toUri$1(path)), $async$compileAsync);
            case 6:
              // returning from await.
              stylesheet = $async$result;
              // goto join
              $async$goto = 4;
              break;
            case 5:
              // else
              t1 = B.readFile(path);
              t2 = syntax == null ? M.Syntax_forPath(path) : syntax;
              stylesheet = V.Stylesheet_Stylesheet$parse(t1, t2, logger, $.$get$context().toUri$1(path));
            case 4:
              // join
              $async$goto = 7;
              return P._asyncAwait(X._compileStylesheet0(stylesheet, logger, importCache, nodeImporter, new F.FilesystemImporter(D.absolute(".")), functions, style, useSpaces, indentWidth, lineFeed, sourceMap, charset), $async$compileAsync);
            case 7:
              // returning from await.
              $async$returnValue = $async$result;
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileAsync, $async$completer);
    },
    compileStringAsync: function(source, charset, functions, importCache, importer, indentWidth, lineFeed, logger, nodeImporter, sourceMap, style, syntax, url, useSpaces) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(X.CompileResult),
        $async$returnValue, stylesheet;
      var $async$compileStringAsync = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              stylesheet = V.Stylesheet_Stylesheet$parse(source, syntax == null ? C.Syntax_SCSS : syntax, logger, url);
              $async$returnValue = X._compileStylesheet0(stylesheet, logger, importCache, nodeImporter, importer == null ? new F.FilesystemImporter(D.absolute(".")) : importer, functions, style, useSpaces, indentWidth, lineFeed, sourceMap, charset);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileStringAsync, $async$completer);
    },
    _compileStylesheet0: function(stylesheet, logger, importCache, nodeImporter, importer, functions, style, useSpaces, indentWidth, lineFeed, sourceMap, charset) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(X.CompileResult),
        $async$returnValue, evaluateResult, serializeResult, t1;
      var $async$_compileStylesheet0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              $async$goto = 3;
              return P._asyncAwait(E._EvaluateVisitor$0(functions, importCache, logger, nodeImporter, sourceMap).run$2(0, importer, stylesheet), $async$_compileStylesheet0);
            case 3:
              // returning from await.
              evaluateResult = $async$result;
              serializeResult = N.serialize(evaluateResult.stylesheet, charset, indentWidth, false, lineFeed, sourceMap, style, useSpaces);
              t1 = serializeResult.sourceMap;
              if (t1 != null && importCache != null)
                B.mapInPlace(t1.urls, new X._compileStylesheet_closure0(stylesheet, importCache));
              $async$returnValue = new X.CompileResult(evaluateResult, serializeResult);
              // goto return
              $async$goto = 1;
              break;
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$_compileStylesheet0, $async$completer);
    },
    _compileStylesheet_closure0: function _compileStylesheet_closure0(t0, t1) {
      this.stylesheet = t0;
      this.importCache = t1;
    },
    CompileResult: function CompileResult(t0, t1) {
      this._evaluate = t0;
      this._serialize = t1;
    },
    closure32: function closure32() {
    },
    closure33: function closure33() {
    },
    SourceSpanWithContext$: function(start, end, text, _context) {
      var t1 = new X.SourceSpanWithContext(_context, start, end, text);
      t1.SourceSpanBase$3(start, end, text);
      if (!C.JSString_methods.contains$1(_context, text))
        H.throwExpression(P.ArgumentError$('The context line "' + _context + '" must contain "' + text + '".'));
      if (B.findLineStart(_context, text, start.get$column()) == null)
        H.throwExpression(P.ArgumentError$('The span text "' + text + '" must start at column ' + (start.get$column() + 1) + ' in a line within "' + _context + '".'));
      return t1;
    },
    SourceSpanWithContext: function SourceSpanWithContext(t0, t1, t2, t3) {
      var _ = this;
      _._context = t0;
      _.start = t1;
      _.end = t2;
      _.text = t3;
    },
    StringScanner$: function(string, position, sourceUrl) {
      var t1 = typeof sourceUrl === "string" ? P.Uri_parse(sourceUrl) : H.interceptedTypeCast(sourceUrl, "$isUri");
      return new X.StringScanner(t1, string);
    },
    StringScanner: function StringScanner(t0, t1) {
      var _ = this;
      _.sourceUrl = t0;
      _.string = t1;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    _combine: function(hash, value) {
      hash = 536870911 & hash + value;
      hash = 536870911 & hash + ((524287 & hash) << 10);
      return hash ^ hash >>> 6;
    },
    _finish: function(hash) {
      hash = 536870911 & hash + ((67108863 & hash) << 3);
      hash ^= hash >>> 11;
      return 536870911 & hash + ((16383 & hash) << 15);
    }
  },
  K = {
    PathMap__create: function(context, $V) {
      var t1 = {};
      t1.context = context;
      t1.context = $.$get$context();
      return P.LinkedHashMap_LinkedHashMap(new K.PathMap__create_closure(t1), new K.PathMap__create_closure0(t1), new K.PathMap__create_closure1(), P.String, $V);
    },
    PathMap: function PathMap(t0, t1) {
      this._collection$_map = t0;
      this.$ti = t1;
    },
    PathMap__create_closure: function PathMap__create_closure(t0) {
      this._box_0 = t0;
    },
    PathMap__create_closure0: function PathMap__create_closure0(t0) {
      this._box_0 = t0;
    },
    PathMap__create_closure1: function PathMap__create_closure1() {
    },
    ColorExpression: function ColorExpression(t0) {
      this.value = t0;
    },
    _functionString: function($name, $arguments) {
      return new D.SassString($name + "(" + J.map$1$1$ax($arguments, new K._functionString_closure(), P.String).join$1(0, ", ") + ")", false);
    },
    _removedColorFunction: function($name, argument, negative) {
      return new Q.BuiltInCallable($name, H.setRuntimeTypeInfo([new S.Tuple2(B.ArgumentDeclaration_ArgumentDeclaration$parse("$color, $amount"), new K._removedColorFunction_closure($name, argument, negative), [B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}])], [[S.Tuple2, B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}]]));
    },
    _rgb: function($name, $arguments) {
      var t2, red, green, blue, t3, _null = null,
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : _null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? _null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return K._functionString($name, $arguments);
      red = t1.$index($arguments, 0).assertNumber$1("red");
      green = t1.$index($arguments, 1).assertNumber$1("green");
      blue = t1.$index($arguments, 2).assertNumber$1("blue");
      t1 = T.fuzzyRound(K._percentageOrUnitless(red, 255, "red"));
      t2 = T.fuzzyRound(K._percentageOrUnitless(green, 255, "green"));
      t3 = T.fuzzyRound(K._percentageOrUnitless(blue, 255, "blue"));
      return K.SassColor$rgb(t1, t2, t3, alpha == null ? _null : K._percentageOrUnitless(alpha.assertNumber$1("alpha"), 1, "alpha"), _null);
    },
    _rgbTwoArg: function($name, $arguments) {
      var first, t2, color,
        t1 = J.getInterceptor$asx($arguments);
      if (t1.$index($arguments, 0).get$isVar())
        return K._functionString($name, $arguments);
      else if (t1.$index($arguments, 1).get$isVar()) {
        first = t1.$index($arguments, 0);
        if (first instanceof K.SassColor) {
          t2 = $name + "(" + H.S(first.get$red()) + ", " + H.S(first.get$green()) + ", " + H.S(first.get$blue()) + ", ";
          t1 = t1.$index($arguments, 1);
          t1.toString;
          return new D.SassString(t2 + N.serializeValue(t1, false, true) + ")", false);
        } else
          return K._functionString($name, $arguments);
      } else if (t1.$index($arguments, 1).get$isSpecialNumber()) {
        color = t1.$index($arguments, 0).assertColor$1("color");
        t2 = $name + "(" + H.S(color.get$red()) + ", " + H.S(color.get$green()) + ", " + H.S(color.get$blue()) + ", ";
        t1 = t1.$index($arguments, 1);
        t1.toString;
        return new D.SassString(t2 + N.serializeValue(t1, false, true) + ")", false);
      }
      return t1.$index($arguments, 0).assertColor$1("color").changeAlpha$1(K._percentageOrUnitless(t1.$index($arguments, 1).assertNumber$1("alpha"), 1, "alpha"));
    },
    _hsl: function($name, $arguments) {
      var t2, hue, saturation, lightness, t3,
        t1 = J.getInterceptor$asx($arguments),
        alpha = t1.get$length($arguments) > 3 ? t1.$index($arguments, 3) : null;
      if (!t1.$index($arguments, 0).get$isSpecialNumber())
        if (!t1.$index($arguments, 1).get$isSpecialNumber())
          if (!t1.$index($arguments, 2).get$isSpecialNumber()) {
            t2 = alpha == null ? null : alpha.get$isSpecialNumber();
            t2 = t2 === true;
          } else
            t2 = true;
        else
          t2 = true;
      else
        t2 = true;
      if (t2)
        return K._functionString($name, $arguments);
      hue = t1.$index($arguments, 0).assertNumber$1("hue");
      saturation = t1.$index($arguments, 1).assertNumber$1("saturation");
      lightness = t1.$index($arguments, 2).assertNumber$1("lightness");
      t1 = J.clamp$2$n(saturation.value, 0, 100);
      t2 = J.clamp$2$n(lightness.value, 0, 100);
      t3 = alpha == null ? null : K._percentageOrUnitless(alpha.assertNumber$1("alpha"), 1, "alpha");
      return K.SassColor$hsl(hue.value, t1, t2, t3);
    },
    _parseChannels: function($name, argumentNames, channels) {
      var isCommaSeparated, isBracketed, buffer, t1, list, maybeSlashSeparated, t2, t3,
        _s17_ = "$channels must be",
        _s32_ = "$channels must be an unbracketed";
      if (channels.get$isVar())
        return K._functionString($name, H.setRuntimeTypeInfo([channels], [F.Value]));
      isCommaSeparated = channels.get$separator() === C.ListSeparator_comma;
      isBracketed = channels.get$hasBrackets();
      if (isCommaSeparated || isBracketed) {
        buffer = new P.StringBuffer(_s17_);
        if (isBracketed) {
          buffer._contents = _s32_;
          t1 = _s32_;
        } else
          t1 = _s17_;
        if (isCommaSeparated) {
          t1 += isBracketed ? "," : " a";
          buffer._contents = t1;
          t1 = buffer._contents = t1 + " space-separated";
        }
        buffer._contents = t1 + " list.";
        throw H.wrapException(E.SassScriptException$(buffer.toString$0(0)));
      }
      list = channels.get$asList();
      t1 = list.length;
      if (t1 > 3)
        throw H.wrapException(E.SassScriptException$("Only 3 elements allowed, but " + t1 + " were passed."));
      else if (t1 < 3) {
        if (!C.JSArray_methods.any$1(list, new K._parseChannels_closure()))
          if (list.length !== 0) {
            t1 = C.JSArray_methods.get$last(list);
            if (t1 instanceof D.SassString)
              if (t1.hasQuotes) {
                t1 = t1.text;
                t1 = B.startsWithIgnoreCase(t1, "var(") && J.contains$1$asx(t1, "/");
              } else
                t1 = false;
            else
              t1 = false;
          } else
            t1 = false;
        else
          t1 = true;
        if (t1)
          return K._functionString($name, H.setRuntimeTypeInfo([channels], [F.Value]));
        else
          throw H.wrapException(E.SassScriptException$("Missing element " + argumentNames[list.length] + "."));
      }
      maybeSlashSeparated = list[2];
      t1 = J.getInterceptor$(maybeSlashSeparated);
      if (!!t1.$isSassNumber && maybeSlashSeparated.asSlash != null) {
        t1 = list[0];
        t2 = list[1];
        t3 = maybeSlashSeparated.asSlash;
        return H.setRuntimeTypeInfo([t1, t2, t3.item1, t3.item2], [F.Value]);
      } else if (!!t1.$isSassString && !maybeSlashSeparated.hasQuotes && J.contains$1$asx(maybeSlashSeparated.text, "/"))
        return K._functionString($name, H.setRuntimeTypeInfo([channels], [F.Value]));
      else
        return list;
    },
    _percentageOrUnitless: function(number, max, $name) {
      var value;
      if (!(number.numeratorUnits.length !== 0 || number.denominatorUnits.length !== 0))
        value = number.value;
      else if (number.hasUnit$1("%"))
        value = max * number.value / 100;
      else
        throw H.wrapException(E.SassScriptException$("$" + $name + ": Expected " + number.toString$0(0) + ' to have no units or "%".'));
      return J.clamp$2$n(value, 0, max);
    },
    _mixColors: function(color1, color2, weight) {
      var weightScale = weight.valueInRange$3(0, 100, "weight") / 100,
        normalizedWeight = weightScale * 2 - 1,
        t1 = color1.alpha,
        t2 = color2.alpha,
        alphaDistance = t1 - t2,
        t3 = normalizedWeight * alphaDistance,
        weight1 = ((t3 === -1 ? normalizedWeight : (normalizedWeight + alphaDistance) / (1 + t3)) + 1) / 2,
        weight2 = 1 - weight1;
      return K.SassColor$rgb(T.fuzzyRound(color1.get$red() * weight1 + color2.get$red() * weight2), T.fuzzyRound(color1.get$green() * weight1 + color2.get$green() * weight2), T.fuzzyRound(color1.get$blue() * weight1 + color2.get$blue() * weight2), t1 * weightScale + t2 * (1 - weightScale), null);
    },
    _opacify: function($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(C.JSNumber_methods.clamp$2(color.alpha + t1.$index($arguments, 1).assertNumber$1("amount").valueInRange$3(0, 1, "amount"), 0, 1));
    },
    _transparentize: function($arguments) {
      var t1 = J.getInterceptor$asx($arguments),
        color = t1.$index($arguments, 0).assertColor$1("color");
      return color.changeAlpha$1(C.JSNumber_methods.clamp$2(color.alpha - t1.$index($arguments, 1).assertNumber$1("amount").valueInRange$3(0, 1, "amount"), 0, 1));
    },
    closure45: function closure45() {
    },
    closure46: function closure46() {
    },
    closure47: function closure47() {
    },
    closure48: function closure48() {
    },
    closure49: function closure49() {
    },
    closure50: function closure50() {
    },
    closure51: function closure51() {
    },
    closure52: function closure52() {
    },
    closure53: function closure53() {
    },
    closure54: function closure54() {
    },
    closure55: function closure55() {
    },
    closure56: function closure56() {
    },
    closure57: function closure57() {
    },
    closure58: function closure58() {
    },
    closure59: function closure59() {
    },
    closure60: function closure60() {
    },
    closure61: function closure61() {
    },
    closure62: function closure62() {
    },
    closure63: function closure63() {
    },
    closure64: function closure64() {
    },
    closure65: function closure65() {
    },
    closure66: function closure66() {
    },
    closure67: function closure67() {
    },
    closure68: function closure68() {
    },
    closure69: function closure69() {
    },
    closure70: function closure70() {
    },
    _closure10: function _closure10() {
    },
    closure71: function closure71() {
    },
    closure84: function closure84() {
    },
    closure85: function closure85() {
    },
    closure86: function closure86() {
    },
    closure87: function closure87() {
    },
    _closure11: function _closure11() {
    },
    closure88: function closure88() {
    },
    closure83: function closure83() {
    },
    closure82: function closure82() {
    },
    closure81: function closure81() {
    },
    closure80: function closure80() {
    },
    closure79: function closure79() {
    },
    closure78: function closure78() {
    },
    closure77: function closure77() {
    },
    closure76: function closure76() {
    },
    closure74: function closure74() {
    },
    closure_getInRange0: function closure_getInRange0(t0) {
      this.keywords = t0;
    },
    _closure9: function _closure9() {
    },
    closure73: function closure73() {
    },
    closure_getScale: function closure_getScale(t0) {
      this.keywords = t0;
    },
    closure_scaleValue: function closure_scaleValue() {
    },
    _closure8: function _closure8() {
    },
    closure72: function closure72() {
    },
    closure_getInRange: function closure_getInRange(t0) {
      this.keywords = t0;
    },
    _closure7: function _closure7() {
    },
    closure75: function closure75() {
    },
    closure_hexString: function closure_hexString() {
    },
    _functionString_closure: function _functionString_closure() {
    },
    _removedColorFunction_closure: function _removedColorFunction_closure(t0, t1, t2) {
      this.name = t0;
      this.argument = t1;
      this.negative = t2;
    },
    _parseChannels_closure: function _parseChannels_closure() {
    },
    _numberFunction: function($name, transform) {
      return new Q.BuiltInCallable($name, H.setRuntimeTypeInfo([new S.Tuple2(B.ArgumentDeclaration_ArgumentDeclaration$parse("$number"), new K._numberFunction_closure(transform), [B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}])], [[S.Tuple2, B.ArgumentDeclaration, {func: 1, ret: F.Value, args: [[P.List, F.Value]]}]]));
    },
    closure19: function closure19() {
    },
    closure26: function closure26() {
    },
    closure25: function closure25() {
    },
    closure24: function closure24() {
    },
    closure23: function closure23() {
    },
    closure22: function closure22() {
    },
    closure21: function closure21() {
    },
    closure20: function closure20() {
    },
    closure18: function closure18() {
    },
    closure17: function closure17() {
    },
    _numberFunction_closure: function _numberFunction_closure(t0) {
      this.transform = t0;
    },
    _NodeSassColor: function _NodeSassColor() {
    },
    closure119: function closure119() {
    },
    closure120: function closure120() {
    },
    closure121: function closure121() {
    },
    closure122: function closure122() {
    },
    closure123: function closure123() {
    },
    closure124: function closure124() {
    },
    closure125: function closure125() {
    },
    closure126: function closure126() {
    },
    closure127: function closure127() {
    },
    closure128: function closure128() {
    },
    LimitedMapView$safelist: function(_map, safelist, $K, $V) {
      return new K.LimitedMapView(_map, safelist._base.intersection$1(new M.MapKeySet(_map, [P.Object])), [$K, $V]);
    },
    LimitedMapView$blocklist: function(_map, blocklist, $K, $V) {
      var t2, key,
        t1 = P.LinkedHashSet_LinkedHashSet($K);
      for (t2 = J.get$iterator$ax(_map.get$keys()); t2.moveNext$0();) {
        key = t2.get$current(t2);
        if (!blocklist.contains$1(0, key))
          t1.add$1(0, key);
      }
      return new K.LimitedMapView(_map, t1, [$K, $V]);
    },
    LimitedMapView: function LimitedMapView(t0, t1, t2) {
      this._limited_map_view$_map = t0;
      this._limited_map_view$_keys = t1;
      this.$ti = t2;
    },
    SassColor$rgb: function(_red, _green, _blue, alpha, originalSpan) {
      var t1 = new K.SassColor(_red, _green, _blue, null, null, null, alpha == null ? 1 : T.fuzzyAssertRange(alpha, 0, 1, "alpha"), originalSpan);
      P.RangeError_checkValueInInterval(t1.get$red(), 0, 255, "red");
      P.RangeError_checkValueInInterval(t1.get$green(), 0, 255, "green");
      P.RangeError_checkValueInInterval(t1.get$blue(), 0, 255, "blue");
      return t1;
    },
    SassColor$hsl: function(hue, saturation, lightness, alpha) {
      var _null = null,
        t1 = C.JSNumber_methods.$mod(hue, 360),
        t2 = T.fuzzyAssertRange(saturation, 0, 100, "saturation"),
        t3 = T.fuzzyAssertRange(lightness, 0, 100, "lightness");
      return new K.SassColor(_null, _null, _null, t1, t2, t3, alpha == null ? 1 : T.fuzzyAssertRange(alpha, 0, 1, "alpha"), _null);
    },
    SassColor: function SassColor(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _._red = t0;
      _._green = t1;
      _._blue = t2;
      _._hue = t3;
      _._saturation = t4;
      _._lightness = t5;
      _.alpha = t6;
      _.originalSpan = t7;
    },
    UnicodeGlyphSet: function UnicodeGlyphSet() {
    }
  },
  R = {ModifiableCssComment: function ModifiableCssComment(t0, t1) {
      var _ = this;
      _.text = t0;
      _.span = t1;
      _._indexInParent = _._parent = null;
      _.isGroupEnd = false;
    },
    ImportCache$: function(importers, loadPaths, logger) {
      var t1 = R.ImportCache__toImporters(importers, loadPaths, null),
        t2 = logger == null ? C.StderrLogger_false : logger,
        t3 = P.Uri;
      return new R.ImportCache(t1, t2, P.LinkedHashMap_LinkedHashMap$_empty([S.Tuple2, P.Uri, P.bool], [S.Tuple3, M.Importer, P.Uri, P.Uri]), P.LinkedHashMap_LinkedHashMap$_empty(t3, V.Stylesheet), P.LinkedHashMap_LinkedHashMap$_empty(t3, E.ImporterResult));
    },
    ImportCache$none: function(logger) {
      var t1 = logger == null ? C.StderrLogger_false : logger,
        t2 = P.Uri;
      return new R.ImportCache(C.List_empty10, t1, P.LinkedHashMap_LinkedHashMap$_empty([S.Tuple2, P.Uri, P.bool], [S.Tuple3, M.Importer, P.Uri, P.Uri]), P.LinkedHashMap_LinkedHashMap$_empty(t2, V.Stylesheet), P.LinkedHashMap_LinkedHashMap$_empty(t2, E.ImporterResult));
    },
    ImportCache__toImporters: function(importers, loadPaths, packageResolver) {
      var _i, t2, t3, path, _null = null,
        sassPath = H.stringTypeCast(J.get$env$x(self.process).SASS_PATH),
        t1 = H.setRuntimeTypeInfo([], [M.Importer]);
      for (_i = 0; false; ++_i)
        t1.push(importers[_i]);
      if (loadPaths != null)
        for (t2 = J.get$iterator$ax(loadPaths); t2.moveNext$0();) {
          t3 = t2.get$current(t2);
          t1.push(new F.FilesystemImporter($.$get$context().absolute$7(t3, _null, _null, _null, _null, _null, _null)));
        }
      if (sassPath != null) {
        t2 = sassPath.split(J.$eq$(J.get$platform$x(self.process), "win32") ? ";" : ":");
        t3 = t2.length;
        _i = 0;
        for (; _i < t3; ++_i) {
          path = t2[_i];
          t1.push(new F.FilesystemImporter($.$get$context().absolute$7(path, _null, _null, _null, _null, _null, _null)));
        }
      }
      return t1;
    },
    ImportCache: function ImportCache(t0, t1, t2, t3, t4) {
      var _ = this;
      _._importers = t0;
      _._import_cache$_logger = t1;
      _._canonicalizeCache = t2;
      _._import_cache$_importCache = t3;
      _._resultsCache = t4;
    },
    ImportCache_canonicalize_closure: function ImportCache_canonicalize_closure(t0, t1, t2) {
      this.$this = t0;
      this.url = t1;
      this.forImport = t2;
    },
    ImportCache__canonicalize_closure: function ImportCache__canonicalize_closure(t0, t1) {
      this.importer = t0;
      this.url = t1;
    },
    ImportCache_importCanonical_closure: function ImportCache_importCanonical_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.importer = t1;
      _.canonicalUrl = t2;
      _.originalUrl = t3;
    },
    ImportCache_humanize_closure: function ImportCache_humanize_closure(t0) {
      this.canonicalUrl = t0;
    },
    ImportCache_humanize_closure0: function ImportCache_humanize_closure0() {
    },
    ImportCache_humanize_closure1: function ImportCache_humanize_closure1() {
    },
    ForwardedModuleView$: function(_inner, _rule, $T) {
      var t5,
        t1 = _rule.prefix,
        t2 = _rule.shownVariables,
        t3 = _rule.hiddenVariables,
        t4 = R.ForwardedModuleView__forwardedMap(_inner.get$variables(), t1, t2, t3, F.Value);
      t2 = _inner.get$variableNodes() == null ? null : R.ForwardedModuleView__forwardedMap(_inner.get$variableNodes(), t1, t2, t3, B.AstNode);
      t3 = _rule.shownMixinsAndFunctions;
      t5 = _rule.hiddenMixinsAndFunctions;
      return new R.ForwardedModuleView(_inner, _rule, t4, t2, R.ForwardedModuleView__forwardedMap(_inner.get$functions(_inner), t1, t3, t5, $T), R.ForwardedModuleView__forwardedMap(_inner.get$mixins(), t1, t3, t5, $T), [$T]);
    },
    ForwardedModuleView__forwardedMap: function(map, prefix, safelist, blocklist, $V) {
      var t2,
        t1 = prefix == null;
      if (t1)
        if (safelist == null)
          if (blocklist != null) {
            t2 = blocklist._base;
            t2 = t2.get$isEmpty(t2);
          } else
            t2 = true;
        else
          t2 = false;
      else
        t2 = false;
      if (t2)
        return map;
      if (!t1)
        map = new F.PrefixedMapView(map, prefix, [$V]);
      if (safelist != null)
        map = K.LimitedMapView$safelist(map, safelist, P.String, $V);
      else {
        if (blocklist != null) {
          t1 = blocklist._base;
          t1 = t1.get$isNotEmpty(t1);
        } else
          t1 = false;
        if (t1)
          map = K.LimitedMapView$blocklist(map, blocklist, P.String, $V);
      }
      return map;
    },
    ForwardedModuleView: function ForwardedModuleView(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _._forwarded_view$_inner = t0;
      _._rule = t1;
      _.variables = t2;
      _.variableNodes = t3;
      _.functions = t4;
      _.mixins = t5;
      _.$ti = t6;
    },
    RenderOptions: function RenderOptions() {
    },
    UnprefixedMapView: function UnprefixedMapView(t0, t1, t2) {
      this._unprefixed_map_view$_map = t0;
      this._unprefixed_map_view$_prefix = t1;
      this.$ti = t2;
    },
    _UnprefixedKeys: function _UnprefixedKeys(t0) {
      this._unprefixed_map_view$_view = t0;
    },
    _UnprefixedKeys_iterator_closure: function _UnprefixedKeys_iterator_closure(t0) {
      this.$this = t0;
    },
    _UnprefixedKeys_iterator_closure0: function _UnprefixedKeys_iterator_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor$: function(functions, importCache, logger, nodeImporter, sourceMap) {
      var t5, t6,
        t1 = P.String,
        t2 = P.Uri,
        t3 = [G.Module, D.Callable],
        t4 = H.setRuntimeTypeInfo([], [[S.Tuple2, P.String, B.AstNode]]);
      if (nodeImporter == null)
        t5 = importCache == null ? R.ImportCache$none(logger) : importCache;
      else
        t5 = null;
      t6 = logger == null ? C.StderrLogger_false : logger;
      t4 = new R._EvaluateVisitor(t5, nodeImporter, P.LinkedHashMap_LinkedHashMap$_empty(t1, D.Callable), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), P.LinkedHashMap_LinkedHashMap$_empty(t2, t3), t6, sourceMap, O.Environment$(sourceMap), P.LinkedHashSet_LinkedHashSet$_empty(t1), P.LinkedHashSet_LinkedHashSet$_empty(t2), t4, C.Configuration_Map_empty_true);
      t4._EvaluateVisitor$5$functions$importCache$logger$nodeImporter$sourceMap(functions, importCache, logger, nodeImporter, sourceMap);
      return t4;
    },
    _ArgumentResults$: function(positional, named, separator, namedNodes, positionalNodes) {
      return new R._ArgumentResults(positional, positionalNodes, named, namedNodes, separator);
    },
    Evaluator: function Evaluator(t0, t1) {
      this._visitor = t0;
      this._importer = t1;
    },
    _EvaluateVisitor: function _EvaluateVisitor(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11) {
      var _ = this;
      _._importCache = t0;
      _._nodeImporter = t1;
      _._builtInFunctions = t2;
      _._builtInModules = t3;
      _._modules = t4;
      _._logger = t5;
      _._sourceMap = t6;
      _._evaluate$_environment = t7;
      _._declarationName = _._evaluate$_parent = _._mediaQueries = _._styleRule = null;
      _._member = "root stylesheet";
      _._importSpan = _._callableNode = null;
      _._inKeyframes = _._atRootExcludingStyleRule = _._inUnknownAtRule = _._inFunction = false;
      _._includedFiles = t8;
      _._activeModules = t9;
      _._stack = t10;
      _._extender = _._outOfOrderImports = _._endOfImports = _._root = _._stylesheet = _._importer = null;
      _._configuration = t11;
    },
    _EvaluateVisitor_closure: function _EvaluateVisitor_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure0: function _EvaluateVisitor_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure1: function _EvaluateVisitor_closure1(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure2: function _EvaluateVisitor_closure2(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure3: function _EvaluateVisitor_closure3(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure4: function _EvaluateVisitor_closure4(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure5: function _EvaluateVisitor_closure5(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_closure6: function _EvaluateVisitor_closure6(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure3: function _EvaluateVisitor__closure3(t0, t1, t2) {
      this.$this = t0;
      this.name = t1;
      this.module = t2;
    },
    _EvaluateVisitor_closure7: function _EvaluateVisitor_closure7(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure1: function _EvaluateVisitor__closure1() {
    },
    _EvaluateVisitor__closure2: function _EvaluateVisitor__closure2() {
    },
    _EvaluateVisitor_closure8: function _EvaluateVisitor_closure8(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__closure: function _EvaluateVisitor__closure(t0, t1) {
      this.values = t0;
      this.span = t1;
    },
    _EvaluateVisitor__closure0: function _EvaluateVisitor__closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_run_closure: function _EvaluateVisitor_run_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.importer = t2;
    },
    _EvaluateVisitor_runExpression_closure: function _EvaluateVisitor_runExpression_closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.expression = t2;
    },
    _EvaluateVisitor_runExpression__closure: function _EvaluateVisitor_runExpression__closure(t0, t1) {
      this.$this = t0;
      this.expression = t1;
    },
    _EvaluateVisitor_runStatement_closure: function _EvaluateVisitor_runStatement_closure(t0, t1, t2) {
      this.$this = t0;
      this.importer = t1;
      this.statement = t2;
    },
    _EvaluateVisitor_runStatement__closure: function _EvaluateVisitor_runStatement__closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor__withWarnCallback_closure: function _EvaluateVisitor__withWarnCallback_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__loadModule_closure: function _EvaluateVisitor__loadModule_closure(t0, t1, t2, t3, t4, t5, t6) {
      var _ = this;
      _.$this = t0;
      _.url = t1;
      _.nodeForSpan = t2;
      _.baseUrl = t3;
      _.namesInErrors = t4;
      _.configuration = t5;
      _.callback = t6;
    },
    _EvaluateVisitor__execute_closure: function _EvaluateVisitor__execute_closure(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.importer = t2;
      _.stylesheet = t3;
      _.extender = t4;
      _.configuration = t5;
    },
    _EvaluateVisitor__combineCss_closure: function _EvaluateVisitor__combineCss_closure() {
    },
    _EvaluateVisitor__combineCss_closure0: function _EvaluateVisitor__combineCss_closure0(t0) {
      this.selectors = t0;
    },
    _EvaluateVisitor__combineCss_closure1: function _EvaluateVisitor__combineCss_closure1() {
    },
    _EvaluateVisitor__extendModules_closure: function _EvaluateVisitor__extendModules_closure(t0) {
      this.originalSelectors = t0;
    },
    _EvaluateVisitor__extendModules_closure0: function _EvaluateVisitor__extendModules_closure0() {
    },
    _EvaluateVisitor__topologicalModules_visitModule: function _EvaluateVisitor__topologicalModules_visitModule(t0, t1) {
      this.seen = t0;
      this.sorted = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure: function _EvaluateVisitor_visitAtRootRule_closure(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure0: function _EvaluateVisitor_visitAtRootRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRootRule_closure1: function _EvaluateVisitor_visitAtRootRule_closure1(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure: function _EvaluateVisitor__scopeForAtRoot_closure(t0, t1, t2) {
      this.$this = t0;
      this.newParent = t1;
      this.node = t2;
    },
    _EvaluateVisitor__scopeForAtRoot_closure0: function _EvaluateVisitor__scopeForAtRoot_closure0(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure1: function _EvaluateVisitor__scopeForAtRoot_closure1(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot__closure: function _EvaluateVisitor__scopeForAtRoot__closure(t0, t1) {
      this.innerScope = t0;
      this.callback = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure2: function _EvaluateVisitor__scopeForAtRoot_closure2(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor__scopeForAtRoot_closure3: function _EvaluateVisitor__scopeForAtRoot_closure3() {
    },
    _EvaluateVisitor__scopeForAtRoot_closure4: function _EvaluateVisitor__scopeForAtRoot_closure4(t0, t1) {
      this.$this = t0;
      this.innerScope = t1;
    },
    _EvaluateVisitor_visitContentRule_closure: function _EvaluateVisitor_visitContentRule_closure(t0, t1) {
      this.$this = t0;
      this.content = t1;
    },
    _EvaluateVisitor_visitDeclaration_closure: function _EvaluateVisitor_visitDeclaration_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitEachRule_closure: function _EvaluateVisitor_visitEachRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeForSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure0: function _EvaluateVisitor_visitEachRule_closure0(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.nodeForSpan = t2;
    },
    _EvaluateVisitor_visitEachRule_closure1: function _EvaluateVisitor_visitEachRule_closure1(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.list = t1;
      _.setVariables = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitEachRule__closure: function _EvaluateVisitor_visitEachRule__closure(t0, t1, t2) {
      this.$this = t0;
      this.setVariables = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitEachRule___closure: function _EvaluateVisitor_visitEachRule___closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitExtendRule_closure: function _EvaluateVisitor_visitExtendRule_closure(t0, t1) {
      this.$this = t0;
      this.targetText = t1;
    },
    _EvaluateVisitor_visitAtRule_closure: function _EvaluateVisitor_visitAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRule__closure: function _EvaluateVisitor_visitAtRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitAtRule_closure0: function _EvaluateVisitor_visitAtRule_closure0() {
    },
    _EvaluateVisitor_visitForRule_closure: function _EvaluateVisitor_visitForRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure0: function _EvaluateVisitor_visitForRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForRule_closure1: function _EvaluateVisitor_visitForRule_closure1(t0, t1) {
      this.fromNumber = t0;
      this.toNumber = t1;
    },
    _EvaluateVisitor_visitForRule_closure2: function _EvaluateVisitor_visitForRule_closure2(t0) {
      this.toNumber = t0;
    },
    _EvaluateVisitor_visitForRule_closure3: function _EvaluateVisitor_visitForRule_closure3(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.node = t2;
      _.from = t3;
      _.direction = t4;
    },
    _EvaluateVisitor_visitForRule__closure: function _EvaluateVisitor_visitForRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitForwardRule_closure: function _EvaluateVisitor_visitForwardRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitForwardRule_closure0: function _EvaluateVisitor_visitForwardRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor__assertConfigurationIsEmpty_closure: function _EvaluateVisitor__assertConfigurationIsEmpty_closure(t0, t1, t2) {
      this.$this = t0;
      this.only = t1;
      this.nameInError = t2;
    },
    _EvaluateVisitor_visitIfRule_closure: function _EvaluateVisitor_visitIfRule_closure(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitIfRule__closure: function _EvaluateVisitor_visitIfRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__visitDynamicImport_closure: function _EvaluateVisitor__visitDynamicImport_closure(t0, t1) {
      this.$this = t0;
      this.$import = t1;
    },
    _EvaluateVisitor__visitDynamicImport__closure: function _EvaluateVisitor__visitDynamicImport__closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.importer = t2;
      _.stylesheet = t3;
      _.environment = t4;
    },
    _EvaluateVisitor_visitIncludeRule_closure: function _EvaluateVisitor_visitIncludeRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitIncludeRule_closure0: function _EvaluateVisitor_visitIncludeRule_closure0(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.contentCallable = t1;
      _.mixin = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitIncludeRule__closure: function _EvaluateVisitor_visitIncludeRule__closure(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitIncludeRule___closure: function _EvaluateVisitor_visitIncludeRule___closure(t0, t1, t2) {
      this.$this = t0;
      this.mixin = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitIncludeRule____closure: function _EvaluateVisitor_visitIncludeRule____closure(t0, t1) {
      this.$this = t0;
      this.statement = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure: function _EvaluateVisitor_visitMediaRule_closure(t0, t1, t2, t3) {
      var _ = this;
      _.$this = t0;
      _.mergedQueries = t1;
      _.queries = t2;
      _.node = t3;
    },
    _EvaluateVisitor_visitMediaRule__closure: function _EvaluateVisitor_visitMediaRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule___closure: function _EvaluateVisitor_visitMediaRule___closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitMediaRule_closure0: function _EvaluateVisitor_visitMediaRule_closure0(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor__visitMediaQueries_closure: function _EvaluateVisitor__visitMediaQueries_closure(t0, t1) {
      this.$this = t0;
      this.resolved = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure: function _EvaluateVisitor_visitStyleRule_closure(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure0: function _EvaluateVisitor_visitStyleRule_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure1: function _EvaluateVisitor_visitStyleRule_closure1() {
    },
    _EvaluateVisitor_visitStyleRule_closure2: function _EvaluateVisitor_visitStyleRule_closure2(t0, t1) {
      this.$this = t0;
      this.selectorText = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure3: function _EvaluateVisitor_visitStyleRule_closure3(t0, t1) {
      this._box_0 = t0;
      this.$this = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure4: function _EvaluateVisitor_visitStyleRule_closure4(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitStyleRule__closure: function _EvaluateVisitor_visitStyleRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitStyleRule_closure5: function _EvaluateVisitor_visitStyleRule_closure5() {
    },
    _EvaluateVisitor_visitSupportsRule_closure: function _EvaluateVisitor_visitSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule__closure: function _EvaluateVisitor_visitSupportsRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitSupportsRule_closure0: function _EvaluateVisitor_visitSupportsRule_closure0() {
    },
    _EvaluateVisitor_visitVariableDeclaration_closure: function _EvaluateVisitor_visitVariableDeclaration_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.override = t2;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure0: function _EvaluateVisitor_visitVariableDeclaration_closure0(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableDeclaration_closure1: function _EvaluateVisitor_visitVariableDeclaration_closure1(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.value = t2;
    },
    _EvaluateVisitor_visitUseRule_closure: function _EvaluateVisitor_visitUseRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWarnRule_closure: function _EvaluateVisitor_visitWarnRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule_closure: function _EvaluateVisitor_visitWhileRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitWhileRule__closure: function _EvaluateVisitor_visitWhileRule__closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitBinaryOperationExpression_closure: function _EvaluateVisitor_visitBinaryOperationExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitVariableExpression_closure: function _EvaluateVisitor_visitVariableExpression_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitListExpression_closure: function _EvaluateVisitor_visitListExpression_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitFunctionExpression_closure: function _EvaluateVisitor_visitFunctionExpression_closure(t0, t1, t2) {
      this.$this = t0;
      this.node = t1;
      this.plainName = t2;
    },
    _EvaluateVisitor_visitFunctionExpression_closure0: function _EvaluateVisitor_visitFunctionExpression_closure0(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.node = t2;
    },
    _EvaluateVisitor__runUserDefinedCallable_closure: function _EvaluateVisitor__runUserDefinedCallable_closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.callable = t1;
      _.evaluated = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
    },
    _EvaluateVisitor__runUserDefinedCallable__closure: function _EvaluateVisitor__runUserDefinedCallable__closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
    },
    _EvaluateVisitor__runUserDefinedCallable___closure: function _EvaluateVisitor__runUserDefinedCallable___closure(t0, t1, t2, t3, t4) {
      var _ = this;
      _.$this = t0;
      _.evaluated = t1;
      _.callable = t2;
      _.nodeWithSpan = t3;
      _.run = t4;
    },
    _EvaluateVisitor__runUserDefinedCallable____closure: function _EvaluateVisitor__runUserDefinedCallable____closure() {
    },
    _EvaluateVisitor__runFunctionCallable_closure: function _EvaluateVisitor__runFunctionCallable_closure(t0, t1) {
      this.$this = t0;
      this.callable = t1;
    },
    _EvaluateVisitor__runBuiltInCallable_closure: function _EvaluateVisitor__runBuiltInCallable_closure(t0, t1, t2) {
      this.overload = t0;
      this.evaluated = t1;
      this.namedSet = t2;
    },
    _EvaluateVisitor__runBuiltInCallable_closure0: function _EvaluateVisitor__runBuiltInCallable_closure0() {
    },
    _EvaluateVisitor__evaluateArguments_closure: function _EvaluateVisitor__evaluateArguments_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__evaluateArguments_closure0: function _EvaluateVisitor__evaluateArguments_closure0(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor__evaluateArguments_closure1: function _EvaluateVisitor__evaluateArguments_closure1(t0, t1, t2) {
      this.named = t0;
      this.namedNodes = t1;
      this.restNodeForSpan = t2;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure: function _EvaluateVisitor__evaluateMacroArguments_closure() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure0: function _EvaluateVisitor__evaluateMacroArguments_closure0() {
    },
    _EvaluateVisitor__evaluateMacroArguments_closure1: function _EvaluateVisitor__evaluateMacroArguments_closure1(t0) {
      this.named = t0;
    },
    _EvaluateVisitor__evaluateMacroArguments_closure2: function _EvaluateVisitor__evaluateMacroArguments_closure2() {
    },
    _EvaluateVisitor__addRestMap_closure: function _EvaluateVisitor__addRestMap_closure(t0) {
      this.T = t0;
    },
    _EvaluateVisitor__addRestMap_closure0: function _EvaluateVisitor__addRestMap_closure0(t0, t1, t2, t3, t4) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.values = t2;
      _.map = t3;
      _.nodeForSpan = t4;
    },
    _EvaluateVisitor__verifyArguments_closure: function _EvaluateVisitor__verifyArguments_closure(t0, t1, t2) {
      this.$arguments = t0;
      this.positional = t1;
      this.named = t2;
    },
    _EvaluateVisitor_visitStringExpression_closure: function _EvaluateVisitor_visitStringExpression_closure(t0) {
      this.$this = t0;
    },
    _EvaluateVisitor_visitCssAtRule_closure: function _EvaluateVisitor_visitCssAtRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssAtRule_closure0: function _EvaluateVisitor_visitCssAtRule_closure0() {
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure: function _EvaluateVisitor_visitCssKeyframeBlock_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssKeyframeBlock_closure0: function _EvaluateVisitor_visitCssKeyframeBlock_closure0() {
    },
    _EvaluateVisitor_visitCssMediaRule_closure: function _EvaluateVisitor_visitCssMediaRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.mergedQueries = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssMediaRule__closure: function _EvaluateVisitor_visitCssMediaRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule___closure: function _EvaluateVisitor_visitCssMediaRule___closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssMediaRule_closure0: function _EvaluateVisitor_visitCssMediaRule_closure0(t0) {
      this.mergedQueries = t0;
    },
    _EvaluateVisitor_visitCssStyleRule_closure: function _EvaluateVisitor_visitCssStyleRule_closure(t0, t1, t2) {
      this.$this = t0;
      this.rule = t1;
      this.node = t2;
    },
    _EvaluateVisitor_visitCssStyleRule__closure: function _EvaluateVisitor_visitCssStyleRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssStyleRule_closure0: function _EvaluateVisitor_visitCssStyleRule_closure0() {
    },
    _EvaluateVisitor_visitCssSupportsRule_closure: function _EvaluateVisitor_visitCssSupportsRule_closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule__closure: function _EvaluateVisitor_visitCssSupportsRule__closure(t0, t1) {
      this.$this = t0;
      this.node = t1;
    },
    _EvaluateVisitor_visitCssSupportsRule_closure0: function _EvaluateVisitor_visitCssSupportsRule_closure0() {
    },
    _EvaluateVisitor__performInterpolation_closure: function _EvaluateVisitor__performInterpolation_closure(t0, t1) {
      this.$this = t0;
      this.warnForColor = t1;
    },
    _EvaluateVisitor__serialize_closure: function _EvaluateVisitor__serialize_closure(t0, t1) {
      this.value = t0;
      this.quote = t1;
    },
    _EvaluateVisitor__stackTrace_closure: function _EvaluateVisitor__stackTrace_closure(t0) {
      this.$this = t0;
    },
    _ImportedCssVisitor: function _ImportedCssVisitor(t0) {
      this._visitor = t0;
    },
    _ImportedCssVisitor_visitCssAtRule_closure: function _ImportedCssVisitor_visitCssAtRule_closure() {
    },
    _ImportedCssVisitor_visitCssMediaRule_closure: function _ImportedCssVisitor_visitCssMediaRule_closure(t0) {
      this.hasBeenMerged = t0;
    },
    _ImportedCssVisitor_visitCssStyleRule_closure: function _ImportedCssVisitor_visitCssStyleRule_closure() {
    },
    _ImportedCssVisitor_visitCssSupportsRule_closure: function _ImportedCssVisitor_visitCssSupportsRule_closure() {
    },
    _ArgumentResults: function _ArgumentResults(t0, t1, t2, t3, t4) {
      var _ = this;
      _.positional = t0;
      _.positionalNodes = t1;
      _.named = t2;
      _.namedNodes = t3;
      _.separator = t4;
    },
    _collectToList: function(element, soFar, $T) {
      if (soFar == null)
        soFar = H.setRuntimeTypeInfo([], [$T]);
      J.add$1$ax(soFar, element);
      return soFar;
    },
    _debounceAggregate: function(duration, collect, $T, $R) {
      var t1 = {};
      t1.soFar = t1.timer = null;
      t1.shouldClose = false;
      return new L._StreamTransformer(new R._debounceAggregate_closure(t1, duration, collect), new R._debounceAggregate_closure0(t1), H.instantiate1(L.from_handlers__StreamTransformer__defaultHandleError$closure(), $R), [$T, $R]);
    },
    _debounceAggregate_closure: function _debounceAggregate_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.duration = t1;
      this.collect = t2;
    },
    _debounceAggregate__closure: function _debounceAggregate__closure(t0, t1) {
      this._box_0 = t0;
      this.sink = t1;
    },
    _debounceAggregate_closure0: function _debounceAggregate_closure0(t0) {
      this._box_0 = t0;
    }
  },
  T = {Expression: function Expression() {
    }, NumberExpression: function NumberExpression(t0, t1, t2) {
      this.value = t0;
      this.unit = t1;
      this.span = t2;
    }, ParenthesizedExpression: function ParenthesizedExpression(t0, t1) {
      this.expression = t0;
      this.span = t1;
    }, SelectorExpression: function SelectorExpression(t0) {
      this.span = t0;
    }, MixinRule: function MixinRule(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.hasContent = t0;
      _.name = t1;
      _.$arguments = t2;
      _.span = t3;
      _.children = t4;
      _.hasDeclarations = t5;
    },
    UseRule$: function(url, namespace, span, configuration) {
      var t1 = new T.UseRule(url, namespace, configuration == null ? C.List_empty7 : P.List_List$unmodifiable(configuration, Z.ConfiguredVariable), span);
      t1.UseRule$4$configuration(url, namespace, span, configuration);
      return t1;
    },
    UseRule: function UseRule(t0, t1, t2, t3) {
      var _ = this;
      _.url = t0;
      _.namespace = t1;
      _.configuration = t2;
      _.span = t3;
    },
    Selector: function Selector() {
    },
    EmptyExtender: function EmptyExtender() {
    },
    _prependParent: function(compound) {
      var t3, _i,
        t1 = compound.components,
        first = C.JSArray_methods.get$first(t1),
        t2 = J.getInterceptor$(first);
      if (!!t2.$isUniversalSelector)
        return;
      if (!!t2.$isTypeSelector) {
        t2 = first.name;
        if (t2.namespace != null)
          return;
        t3 = H.setRuntimeTypeInfo([], [M.SimpleSelector]);
        t3.push(new M.ParentSelector(t2.name));
        for (t1 = H.SubListIterable$(t1, 1, null, H.getTypeArgumentByIndex(t1, 0)), t1 = new H.ListIterator(t1, t1.get$length(t1)); t1.moveNext$0();)
          t3.push(t1.__internal$_current);
        return X.CompoundSelector$(t3);
      } else {
        t2 = H.setRuntimeTypeInfo([], [M.SimpleSelector]);
        t2.push(new M.ParentSelector(null));
        for (t3 = t1.length, _i = 0; _i < t3; ++_i)
          t2.push(t1[_i]);
        return X.CompoundSelector$(t2);
      }
    },
    closure13: function closure13() {
    },
    _closure1: function _closure1() {
    },
    _closure2: function _closure2() {
    },
    closure12: function closure12() {
    },
    _closure: function _closure() {
    },
    _closure0: function _closure0() {
    },
    __closure: function __closure(t0) {
      this.parent = t0;
    },
    closure11: function closure11() {
    },
    closure10: function closure10() {
    },
    closure9: function closure9() {
    },
    closure16: function closure16() {
    },
    closure15: function closure15() {
    },
    _closure3: function _closure3() {
    },
    closure14: function closure14() {
    },
    TrackingLogger: function TrackingLogger(t0) {
      this._tracking$_logger = t0;
      this._emittedDebug = this._emittedWarning = false;
    },
    _parseNumber: function(value, unit) {
      var t1, t2, invalidUnit, operands, numerator, denominator, numeratorUnits, denominatorUnits;
      if (unit == null || unit.length === 0)
        return new T.SassNumber(value, C.List_empty, C.List_empty, null);
      if (!J.contains$1$asx(unit, "*") && !C.JSString_methods.contains$1(unit, "/")) {
        t1 = P.String;
        t2 = H.setRuntimeTypeInfo([unit], [t1]);
        t1 = P.List_List$unmodifiable(t2, t1);
        return new T.SassNumber(value, t1, C.List_empty, null);
      }
      invalidUnit = new P.ArgumentError(true, unit, "unit", "is invalid.");
      operands = unit.split("/");
      t1 = operands.length;
      if (t1 > 2)
        throw H.wrapException(invalidUnit);
      numerator = operands[0];
      denominator = t1 === 1 ? null : operands[1];
      t1 = P.String;
      numeratorUnits = numerator.length === 0 ? H.setRuntimeTypeInfo([], [t1]) : H.setRuntimeTypeInfo(numerator.split("*"), [t1]);
      if (C.JSArray_methods.any$1(numeratorUnits, new T._parseNumber_closure()))
        throw H.wrapException(invalidUnit);
      denominatorUnits = denominator == null ? H.setRuntimeTypeInfo([], [t1]) : H.setRuntimeTypeInfo(denominator.split("*"), [t1]);
      if (C.JSArray_methods.any$1(denominatorUnits, new T._parseNumber_closure0()))
        throw H.wrapException(invalidUnit);
      return T.SassNumber$withUnits(value, denominatorUnits, numeratorUnits);
    },
    _NodeSassNumber: function _NodeSassNumber() {
    },
    closure98: function closure98() {
    },
    closure99: function closure99() {
    },
    closure100: function closure100() {
    },
    closure101: function closure101() {
    },
    closure102: function closure102() {
    },
    closure103: function closure103() {
    },
    _parseNumber_closure: function _parseNumber_closure() {
    },
    _parseNumber_closure0: function _parseNumber_closure0() {
    },
    SelectorParser: function SelectorParser(t0, t1, t2, t3) {
      var _ = this;
      _._allowParent = t0;
      _._allowPlaceholder = t1;
      _.scanner = t2;
      _.logger = t3;
    },
    SelectorParser_parse_closure: function SelectorParser_parse_closure(t0) {
      this.$this = t0;
    },
    SelectorParser_parseCompoundSelector_closure: function SelectorParser_parseCompoundSelector_closure(t0) {
      this.$this = t0;
    },
    SassNumber$withUnits: function(value, denominatorUnits, numeratorUnits) {
      var t1 = numeratorUnits == null ? C.List_empty : P.List_List$unmodifiable(numeratorUnits, P.String);
      return new T.SassNumber(value, t1, denominatorUnits == null ? C.List_empty : P.List_List$unmodifiable(denominatorUnits, P.String), null);
    },
    SassNumber: function SassNumber(t0, t1, t2, t3) {
      var _ = this;
      _.value = t0;
      _.numeratorUnits = t1;
      _.denominatorUnits = t2;
      _.asSlash = t3;
    },
    SassNumber_valueInUnits_closure: function SassNumber_valueInUnits_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.newNumerator = t2;
    },
    SassNumber_valueInUnits_closure0: function SassNumber_valueInUnits_closure0(t0, t1, t2) {
      this.$this = t0;
      this.newNumerators = t1;
      this.newDenominators = t2;
    },
    SassNumber_valueInUnits_closure1: function SassNumber_valueInUnits_closure1(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.newDenominator = t2;
    },
    SassNumber_valueInUnits_closure2: function SassNumber_valueInUnits_closure2(t0, t1, t2) {
      this.$this = t0;
      this.newNumerators = t1;
      this.newDenominators = t2;
    },
    SassNumber_modulo_closure: function SassNumber_modulo_closure() {
    },
    SassNumber_plus_closure: function SassNumber_plus_closure() {
    },
    SassNumber_minus_closure: function SassNumber_minus_closure() {
    },
    SassNumber__multiplyUnits_closure: function SassNumber__multiplyUnits_closure(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.numerator = t2;
    },
    SassNumber__multiplyUnits_closure0: function SassNumber__multiplyUnits_closure0(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber__multiplyUnits_closure1: function SassNumber__multiplyUnits_closure1(t0, t1, t2) {
      this._box_0 = t0;
      this.$this = t1;
      this.numerator = t2;
    },
    SassNumber__multiplyUnits_closure2: function SassNumber__multiplyUnits_closure2(t0, t1) {
      this.newNumerators = t0;
      this.numerator = t1;
    },
    SassNumber__areAnyConvertible_closure: function SassNumber__areAnyConvertible_closure(t0, t1) {
      this.$this = t0;
      this.units2 = t1;
    },
    SassNumber__canonicalMultiplier_closure: function SassNumber__canonicalMultiplier_closure() {
    },
    SingleMapping_SingleMapping$fromEntries: function(entries) {
      var lines, t1, t2, urls, t3, files, t4, t5, targetEntries, lineNum, _i, sourceEntry, sourceUrl, t6, urlId, _null = null,
        sourceEntries = P.List_List$from(entries, true, _null);
      C.JSArray_methods.sort$0(sourceEntries);
      lines = H.setRuntimeTypeInfo([], [T.TargetLineEntry]);
      t1 = P.String;
      t2 = P.int;
      urls = P.LinkedHashMap_LinkedHashMap$_empty(t1, t2);
      t3 = Y.SourceFile;
      files = P.LinkedHashMap_LinkedHashMap$_empty(t2, t3);
      for (t4 = sourceEntries.length, t5 = [T.TargetEntry], targetEntries = _null, lineNum = targetEntries, _i = 0; _i < sourceEntries.length; sourceEntries.length === t4 || (0, H.throwConcurrentModificationError)(sourceEntries), ++_i) {
        sourceEntry = sourceEntries[_i];
        if (lineNum == null || sourceEntry.get$target().get$line() > lineNum) {
          lineNum = sourceEntry.get$target().get$line();
          targetEntries = H.setRuntimeTypeInfo([], t5);
          lines.push(new T.TargetLineEntry(lineNum, targetEntries));
        }
        if (sourceEntry.get$source() == null)
          targetEntries.push(new T.TargetEntry(sourceEntry.get$target().get$column(), _null, _null, _null, _null));
        else {
          sourceUrl = sourceEntry.get$source().get$sourceUrl();
          t6 = sourceUrl == null ? "" : sourceUrl.toString$0(0);
          urlId = urls.putIfAbsent$2(t6, new T.SingleMapping_SingleMapping$fromEntries_closure(urls));
          if (sourceEntry.get$source() instanceof Y.FileLocation)
            files.putIfAbsent$2(urlId, new T.SingleMapping_SingleMapping$fromEntries_closure0(sourceEntry));
          sourceEntry.get$identifierName();
          targetEntries.push(new T.TargetEntry(sourceEntry.get$target().get$column(), urlId, sourceEntry.get$source().get$line(), sourceEntry.get$source().get$column(), _null));
        }
      }
      t4 = urls.get$values();
      t3 = H.MappedIterable_MappedIterable(t4, new T.SingleMapping_SingleMapping$fromEntries_closure1(files), H.getRuntimeTypeArgument(t4, "Iterable", 0), t3);
      t3 = P.List_List$from(t3, true, H.getRuntimeTypeArgument(t3, "Iterable", 0));
      t4 = urls.get$keys();
      t4 = P.List_List$from(t4, true, H.getRuntimeTypeArgument(t4, "Iterable", 0));
      t2 = P.LinkedHashMap_LinkedHashMap$_empty(t1, t2).get$keys();
      return new T.SingleMapping(t4, P.List_List$from(t2, true, H.getRuntimeTypeArgument(t2, "Iterable", 0)), t3, lines, _null, P.LinkedHashMap_LinkedHashMap$_empty(t1, _null));
    },
    Mapping: function Mapping() {
    },
    SingleMapping: function SingleMapping(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.urls = t0;
      _.names = t1;
      _.files = t2;
      _.lines = t3;
      _.targetUrl = t4;
      _.sourceRoot = null;
      _.extensions = t5;
    },
    SingleMapping_SingleMapping$fromEntries_closure: function SingleMapping_SingleMapping$fromEntries_closure(t0) {
      this.urls = t0;
    },
    SingleMapping_SingleMapping$fromEntries_closure0: function SingleMapping_SingleMapping$fromEntries_closure0(t0) {
      this.sourceEntry = t0;
    },
    SingleMapping_SingleMapping$fromEntries_closure1: function SingleMapping_SingleMapping$fromEntries_closure1(t0) {
      this.files = t0;
    },
    SingleMapping_toJson_closure: function SingleMapping_toJson_closure() {
    },
    SingleMapping_toJson_closure0: function SingleMapping_toJson_closure0(t0) {
      this.result = t0;
    },
    TargetLineEntry: function TargetLineEntry(t0, t1) {
      this.line = t0;
      this.entries = t1;
    },
    TargetEntry: function TargetEntry(t0, t1, t2, t3, t4) {
      var _ = this;
      _.column = t0;
      _.sourceUrlId = t1;
      _.sourceLine = t2;
      _.sourceColumn = t3;
      _.sourceNameId = t4;
    },
    LazyTrace: function LazyTrace(t0) {
      this._thunk = t0;
      this._lazy_trace$_inner = null;
    },
    LazyTrace_terse_closure: function LazyTrace_terse_closure(t0) {
      this.$this = t0;
    },
    isWhitespace: function(character) {
      return character === 32 || character === 9 || T.isNewline(character);
    },
    isNewline: function(character) {
      return character === 10 || character === 13 || character === 12;
    },
    isAlphabetic0: function(character) {
      var t1;
      if (!(character >= 97 && character <= 122))
        t1 = character >= 65 && character <= 90;
      else
        t1 = true;
      return t1;
    },
    isDigit: function(character) {
      return character != null && character >= 48 && character <= 57;
    },
    isHex: function(character) {
      if (character == null)
        return false;
      if (T.isDigit(character))
        return true;
      if (character >= 97 && character <= 102)
        return true;
      if (character >= 65 && character <= 70)
        return true;
      return false;
    },
    isPrivate: function(identifier) {
      var first = C.JSString_methods._codeUnitAt$1(identifier, 0);
      return first === 45 || first === 95;
    },
    asHex: function(character) {
      if (character <= 57)
        return character - 48;
      if (character <= 70)
        return 10 + character - 65;
      return 10 + character - 97;
    },
    hexCharFor: function(number) {
      return number < 10 ? 48 + number : 87 + number;
    },
    opposite: function(character) {
      switch (character) {
        case 40:
          return 41;
        case 123:
          return 125;
        case 91:
          return 93;
        default:
          return;
      }
    },
    characterEqualsIgnoreCase: function(character1, character2) {
      var upperCase1;
      if (character1 === character2)
        return true;
      if ((character1 ^ character2) !== 32)
        return false;
      upperCase1 = character1 & 4294967263;
      return upperCase1 >= 65 && upperCase1 <= 90;
    },
    fuzzyEquals: function(number1, number2) {
      return Math.abs(number1 - number2) < $.$get$epsilon();
    },
    fuzzyLessThan: function(number1, number2) {
      return number1 < number2 && !(Math.abs(number1 - number2) < $.$get$epsilon());
    },
    fuzzyLessThanOrEquals: function(number1, number2) {
      return number1 < number2 || Math.abs(number1 - number2) < $.$get$epsilon();
    },
    fuzzyGreaterThan: function(number1, number2) {
      return number1 > number2 && !(Math.abs(number1 - number2) < $.$get$epsilon());
    },
    fuzzyGreaterThanOrEquals: function(number1, number2) {
      return number1 > number2 || Math.abs(number1 - number2) < $.$get$epsilon();
    },
    fuzzyIsInt: function(number) {
      if (typeof number === "number" && Math.floor(number) === number)
        return true;
      return Math.abs(C.JSNumber_methods.$mod(Math.abs(number - 0.5), 1) - 0.5) < $.$get$epsilon();
    },
    fuzzyRound: function(number) {
      var t1;
      if (number > 0) {
        t1 = C.JSNumber_methods.$mod(number, 1);
        return t1 < 0.5 && !(Math.abs(t1 - 0.5) < $.$get$epsilon()) ? C.JSNumber_methods.floor$0(number) : C.JSNumber_methods.ceil$0(number);
      } else {
        t1 = C.JSNumber_methods.$mod(number, 1);
        return t1 < 0.5 || Math.abs(t1 - 0.5) < $.$get$epsilon() ? C.JSNumber_methods.floor$0(number) : C.JSNumber_methods.ceil$0(number);
      }
    },
    fuzzyCheckRange: function(number, min, max) {
      var t1 = $.$get$epsilon();
      if (Math.abs(number - min) < t1)
        return min;
      if (Math.abs(number - max) < t1)
        return max;
      if (number > min && number < max)
        return number;
      return;
    },
    fuzzyAssertRange: function(number, min, max, $name) {
      var result = T.fuzzyCheckRange(number, min, max);
      if (result != null)
        return result;
      throw H.wrapException(P.RangeError$value(number, $name, "must be between " + min + " and " + max + "."));
    }
  },
  D = {ListExpression: function ListExpression(t0, t1, t2, t3) {
      var _ = this;
      _.contents = t0;
      _.separator = t1;
      _.hasBrackets = t2;
      _.span = t3;
    }, ListExpression_toString_closure: function ListExpression_toString_closure(t0) {
      this.$this = t0;
    }, StringExpression: function StringExpression(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
    }, ErrorRule: function ErrorRule(t0, t1) {
      this.expression = t0;
      this.span = t1;
    },
    SelectorList$: function(components) {
      var t1 = P.List_List$unmodifiable(components, S.ComplexSelector);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty."));
      return new D.SelectorList(t1);
    },
    SelectorList_SelectorList$parse: function(contents, allowParent, allowPlaceholder, logger) {
      var t1 = S.SpanScanner$(contents, null);
      return new T.SelectorParser(allowParent, allowPlaceholder, t1, logger == null ? C.StderrLogger_false : logger).parse$0();
    },
    SelectorList: function SelectorList(t0) {
      this.components = t0;
    },
    SelectorList_isInvisible_closure: function SelectorList_isInvisible_closure() {
    },
    SelectorList_asSassList_closure: function SelectorList_asSassList_closure() {
    },
    SelectorList_asSassList__closure: function SelectorList_asSassList__closure() {
    },
    SelectorList_unify_closure: function SelectorList_unify_closure(t0) {
      this.other = t0;
    },
    SelectorList_unify__closure: function SelectorList_unify__closure(t0) {
      this.complex1 = t0;
    },
    SelectorList_unify___closure: function SelectorList_unify___closure() {
    },
    SelectorList_resolveParentSelectors_closure: function SelectorList_resolveParentSelectors_closure(t0, t1, t2) {
      this.$this = t0;
      this.implicitParent = t1;
      this.parent = t2;
    },
    SelectorList_resolveParentSelectors__closure: function SelectorList_resolveParentSelectors__closure(t0) {
      this.complex = t0;
    },
    SelectorList_resolveParentSelectors__closure0: function SelectorList_resolveParentSelectors__closure0(t0) {
      this._box_0 = t0;
    },
    SelectorList__complexContainsParentSelector_closure: function SelectorList__complexContainsParentSelector_closure() {
    },
    SelectorList__complexContainsParentSelector__closure: function SelectorList__complexContainsParentSelector__closure() {
    },
    SelectorList__resolveParentSelectorsCompound_closure: function SelectorList__resolveParentSelectorsCompound_closure() {
    },
    SelectorList__resolveParentSelectorsCompound_closure0: function SelectorList__resolveParentSelectorsCompound_closure0(t0) {
      this.parent = t0;
    },
    SelectorList__resolveParentSelectorsCompound_closure1: function SelectorList__resolveParentSelectorsCompound_closure1(t0, t1) {
      this.compound = t0;
      this.resolvedMembers = t1;
    },
    PseudoSelector$: function($name, argument, element, selector) {
      var t1 = !element,
        t2 = t1 && !D.PseudoSelector__isFakePseudoElement($name);
      return new D.PseudoSelector($name, B.unvendor($name), t2, t1, argument, selector);
    },
    PseudoSelector__isFakePseudoElement: function($name) {
      switch (C.JSString_methods._codeUnitAt$1($name, 0)) {
        case 97:
        case 65:
          return B.equalsIgnoreCase($name, "after");
        case 98:
        case 66:
          return B.equalsIgnoreCase($name, "before");
        case 102:
        case 70:
          return B.equalsIgnoreCase($name, "first-line") || B.equalsIgnoreCase($name, "first-letter");
        default:
          return false;
      }
    },
    PseudoSelector: function PseudoSelector(t0, t1, t2, t3, t4, t5) {
      var _ = this;
      _.name = t0;
      _.normalizedName = t1;
      _.isClass = t2;
      _.isSyntacticClass = t3;
      _.argument = t4;
      _.selector = t5;
      _._pseudo$_maxSpecificity = _._pseudo$_minSpecificity = null;
    },
    QualifiedName: function QualifiedName(t0, t1) {
      this.name = t0;
      this.namespace = t1;
    },
    Callable: function Callable() {
    },
    compileStylesheet: function(options, graph, source, destination, ifModified) {
      return D.compileStylesheet$body(options, graph, source, destination, ifModified);
    },
    compileStylesheet$body: function(options, graph, source, destination, ifModified) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(-1),
        $async$returnValue, $async$handler = 2, $async$currentError, $async$next = [], syntax, result, importCache, error, exception, t1, t2, t3, t4, t5, t6, t7, result0, css, buffer, sourceName, destinationName, importer, $async$exception;
      var $async$compileStylesheet = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1) {
          $async$currentError = $async$result;
          $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              importer = new F.FilesystemImporter(D.absolute("."));
              if (ifModified)
                try {
                  if (source != null && destination != null && !graph.modifiedSince$3($.$get$context().toUri$1(source), B.modificationTime(destination), importer)) {
                    // goto return
                    $async$goto = 1;
                    break;
                  }
                } catch (exception) {
                  if (!(H.unwrapException(exception) instanceof B.FileSystemException))
                    throw exception;
                }
              syntax = null;
              if (H.boolTypeCast(options._ifParsed$1("indented")) === true)
                syntax = C.Syntax_Sass;
              else if (source != null)
                syntax = M.Syntax_forPath(source);
              else
                syntax = C.Syntax_SCSS;
              result = null;
              $async$handler = 4;
              t1 = options._options;
              $async$goto = H.boolTypeCast(t1.$index(0, "async")) ? 7 : 9;
              break;
            case 7:
              // then
              t2 = H.setRuntimeTypeInfo([], [B.AsyncImporter]);
              t3 = H.subtypeCast(t1.$index(0, "load-path"), "$isList", [P.String], "$asList");
              t4 = H.boolTypeCast(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t3 = O.AsyncImportCache__toImporters(t2, t3, null);
              t2 = t4 == null ? C.StderrLogger_false : t4;
              t4 = P.Uri;
              importCache = new O.AsyncImportCache(t3, t2, P.LinkedHashMap_LinkedHashMap$_empty([S.Tuple2, P.Uri, P.bool], [S.Tuple3, B.AsyncImporter, P.Uri, P.Uri]), P.LinkedHashMap_LinkedHashMap$_empty(t4, V.Stylesheet), P.LinkedHashMap_LinkedHashMap$_empty(t4, E.ImporterResult));
              $async$goto = source == null ? 10 : 12;
              break;
            case 10:
              // then
              $async$goto = 13;
              return P._asyncAwait(B.readStdin(), $async$compileStylesheet);
            case 13:
              // returning from await.
              t2 = $async$result;
              t3 = syntax;
              t4 = H.boolTypeCast(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t5 = D.absolute(".");
              t6 = J.$eq$(t1.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded;
              t7 = options.get$emitSourceMap();
              $async$goto = 14;
              return P._asyncAwait(X.compileStringAsync(t2, H.boolTypeCast(t1.$index(0, "charset")), null, importCache, new F.FilesystemImporter(t5), null, null, t4, null, t7, t6, t3, null, true), $async$compileStylesheet);
            case 14:
              // returning from await.
              result0 = $async$result;
              // goto join
              $async$goto = 11;
              break;
            case 12:
              // else
              t2 = syntax;
              t3 = H.boolTypeCast(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t4 = J.$eq$(t1.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded;
              t5 = options.get$emitSourceMap();
              $async$goto = 15;
              return P._asyncAwait(X.compileAsync(source, H.boolTypeCast(t1.$index(0, "charset")), null, importCache, null, null, t3, null, t5, t4, t2, true), $async$compileStylesheet);
            case 15:
              // returning from await.
              result0 = $async$result;
            case 11:
              // join
              result = result0;
              // goto join
              $async$goto = 8;
              break;
            case 9:
              // else
              $async$goto = source == null ? 16 : 18;
              break;
            case 16:
              // then
              $async$goto = 19;
              return P._asyncAwait(B.readStdin(), $async$compileStylesheet);
            case 19:
              // returning from await.
              t2 = $async$result;
              t3 = syntax;
              t4 = H.boolTypeCast(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t5 = D.absolute(".");
              t6 = J.$eq$(t1.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded;
              t7 = options.get$emitSourceMap();
              result0 = U.compileString(t2, H.boolTypeCast(t1.$index(0, "charset")), null, graph.importCache, new F.FilesystemImporter(t5), null, null, t4, null, t7, t6, t3, null, true);
              // goto join
              $async$goto = 17;
              break;
            case 18:
              // else
              t2 = syntax;
              t3 = H.boolTypeCast(t1.$index(0, "quiet")) ? $.$get$Logger_quiet() : new S.StderrLogger(options.get$color());
              t4 = J.$eq$(t1.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded;
              t5 = options.get$emitSourceMap();
              result0 = U.compile(source, H.boolTypeCast(t1.$index(0, "charset")), null, graph.importCache, null, null, t3, null, t5, t4, t2, true);
            case 17:
              // join
              result = result0;
            case 8:
              // join
              $async$handler = 2;
              // goto after finally
              $async$goto = 6;
              break;
            case 4:
              // catch
              $async$handler = 3;
              $async$exception = $async$currentError;
              t1 = H.unwrapException($async$exception);
              if (t1 instanceof E.SassException) {
                error = t1;
                if (options.get$emitErrorCss())
                  if (destination == null)
                    P.print(error.toCssString$0());
                  else {
                    B.ensureDir($.$get$context().dirname$1(destination));
                    B.writeFile(destination, error.toCssString$0() + "\n");
                  }
                throw $async$exception;
              } else
                throw $async$exception;
              // goto after finally
              $async$goto = 6;
              break;
            case 3:
              // uncaught
              // goto rethrow
              $async$goto = 2;
              break;
            case 6:
              // after finally
              css = result._serialize.css + D._writeSourceMap(options, result._serialize.sourceMap, destination);
              if (destination == null) {
                if (css.length !== 0)
                  P.print(css);
              } else {
                B.ensureDir($.$get$context().dirname$1(destination));
                B.writeFile(destination, css + "\n");
              }
              t1 = options._options;
              if (!H.boolTypeCast(t1.$index(0, "quiet")))
                t1 = !H.boolTypeCast(t1.$index(0, "update")) && !H.boolTypeCast(t1.$index(0, "watch"));
              else
                t1 = true;
              if (t1) {
                // goto return
                $async$goto = 1;
                break;
              }
              buffer = new P.StringBuffer("");
              t1 = options.get$color() ? buffer._contents = "\x1b[32m" : "";
              if (source == null)
                sourceName = "stdin";
              else {
                t2 = $.$get$context();
                sourceName = t2.prettyUri$1(t2.toUri$1(source));
              }
              t2 = $.$get$context();
              destinationName = t2.prettyUri$1(t2.toUri$1(destination));
              t1 += "Compiled " + H.S(sourceName) + " to " + H.S(destinationName) + ".";
              buffer._contents = t1;
              if (options.get$color())
                buffer._contents = t1 + "\x1b[0m";
              P.print(buffer);
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
            case 2:
              // rethrow
              return P._asyncRethrow($async$currentError, $async$completer);
          }
      });
      return P._asyncStartSync($async$compileStylesheet, $async$completer);
    },
    _writeSourceMap: function(options, sourceMap, destination) {
      var t1, sourceMapText, url, sourceMapPath, t2;
      if (sourceMap == null)
        return "";
      if (destination != null) {
        t1 = $.$get$context();
        sourceMap.targetUrl = J.toString$0$(t1.toUri$1(X.ParsedPath_ParsedPath$parse(destination, t1.style).get$basename()));
      }
      B.mapInPlace(sourceMap.urls, new D._writeSourceMap_closure(options, destination));
      t1 = options._options;
      sourceMapText = C.C_JsonCodec.encode$2$toEncodable(sourceMap.toJson$1$includeSourceContents(H.boolTypeCast(t1.$index(0, "embed-sources"))), null);
      if (H.boolTypeCast(t1.$index(0, "embed-source-map")))
        url = P.Uri_Uri$dataFromString(sourceMapText, C.C_Utf8Codec, "application/json");
      else {
        sourceMapPath = J.$add$ansx(destination, ".map");
        t2 = $.$get$context();
        B.ensureDir(t2.dirname$1(sourceMapPath));
        B.writeFile(sourceMapPath, sourceMapText);
        url = t2.toUri$1(t2.relative$2$from(sourceMapPath, t2.dirname$1(destination)));
      }
      t1 = (J.$eq$(t1.$index(0, "style"), "compressed") ? C.OutputStyle_compressed : C.OutputStyle_expanded) === C.OutputStyle_compressed ? "" : "\n\n";
      return t1 + ("/*# sourceMappingURL=" + H.S(url) + " */");
    },
    _writeSourceMap_closure: function _writeSourceMap_closure(t0, t1) {
      this.options = t0;
      this.destination = t1;
    },
    closure44: function closure44() {
    },
    closure43: function closure43() {
    },
    closure42: function closure42() {
    },
    closure41: function closure41() {
    },
    closure40: function closure40() {
    },
    closure39: function closure39() {
    },
    _closure4: function _closure4() {
    },
    _closure5: function _closure5(t0) {
      this._box_0 = t0;
    },
    _closure6: function _closure6(t0) {
      this._box_0 = t0;
    },
    closure38: function closure38() {
    },
    closure36: function closure36() {
    },
    closure37: function closure37() {
    },
    _codepointForIndex: function(index, lengthInCodepoints, allowNegative) {
      var result;
      if (index === 0)
        return 0;
      if (index > 0)
        return Math.min(index - 1, H.checkNum(lengthInCodepoints));
      result = lengthInCodepoints + index;
      if (result < 0 && !allowNegative)
        return 0;
      return result;
    },
    closure8: function closure8() {
    },
    closure7: function closure7() {
    },
    closure3: function closure3() {
    },
    closure2: function closure2() {
    },
    closure1: function closure1() {
    },
    closure0: function closure0() {
    },
    closure6: function closure6() {
    },
    closure5: function closure5() {
    },
    closure4: function closure4() {
    },
    Exports: function Exports() {
    },
    _NodeSassList: function _NodeSassList() {
    },
    closure112: function closure112() {
    },
    _closure17: function _closure17() {
    },
    closure113: function closure113() {
    },
    closure114: function closure114() {
    },
    closure115: function closure115() {
    },
    closure116: function closure116() {
    },
    closure117: function closure117() {
    },
    closure118: function closure118() {
    },
    _NodeSassString: function _NodeSassString() {
    },
    closure94: function closure94() {
    },
    closure95: function closure95() {
    },
    closure96: function closure96() {
    },
    closure97: function closure97() {
    },
    SourceMapBuffer: function SourceMapBuffer(t0, t1, t2) {
      var _ = this;
      _._source_map_buffer$_buffer = t0;
      _._entries = t1;
      _._sourceFiles = t2;
      _._column = _._line = 0;
      _._inSpan = false;
    },
    SourceMapBuffer_sourceFiles_closure: function SourceMapBuffer_sourceFiles_closure() {
    },
    SourceMapBuffer__addEntry_closure: function SourceMapBuffer__addEntry_closure(t0) {
      this.source = t0;
    },
    SourceMapBuffer_buildSourceMap_closure: function SourceMapBuffer_buildSourceMap_closure(t0, t1) {
      this._box_0 = t0;
      this.prefixLength = t1;
    },
    SassArgumentList: function SassArgumentList(t0, t1, t2, t3) {
      var _ = this;
      _._keywords = t0;
      _._wereKeywordsAccessed = false;
      _._list$_contents = t1;
      _.separator = t2;
      _.hasBrackets = t3;
    },
    SassList$: function(contents, separator, brackets) {
      var t1 = new D.SassList(P.List_List$unmodifiable(contents, F.Value), separator, brackets);
      t1.SassList$3$brackets(contents, separator, brackets);
      return t1;
    },
    SassList: function SassList(t0, t1, t2) {
      this._list$_contents = t0;
      this.separator = t1;
      this.hasBrackets = t2;
    },
    SassList_isBlank_closure: function SassList_isBlank_closure() {
    },
    ListSeparator: function ListSeparator(t0) {
      this._list$_name = t0;
    },
    SassString$: function(text, quotes) {
      return new D.SassString(text, quotes);
    },
    SassString: function SassString(t0, t1) {
      this.text = t0;
      this.hasQuotes = t1;
      this._sassLength = null;
    },
    RecursiveStatementVisitor: function RecursiveStatementVisitor() {
    },
    SourceLocationMixin: function SourceLocationMixin() {
    },
    current: function() {
      var exception, t1, path, lastIndex, uri = null;
      try {
        uri = P.Uri_base();
      } catch (exception) {
        if (!!J.getInterceptor$(H.unwrapException(exception)).$isException) {
          t1 = $._current;
          if (t1 != null)
            return t1;
          throw exception;
        } else
          throw exception;
      }
      if (J.$eq$(uri, $._currentUriBase))
        return $._current;
      $._currentUriBase = uri;
      if ($.$get$Style_platform() == $.$get$Style_url())
        return $._current = uri.resolve$1(".").toString$0(0);
      else {
        path = uri.toFilePath$0();
        lastIndex = path.length - 1;
        return $._current = lastIndex === 0 ? path : C.JSString_methods.substring$2(path, 0, lastIndex);
      }
    },
    absolute: function(part1) {
      var _null = null;
      return $.$get$context().absolute$7(part1, _null, _null, _null, _null, _null, _null);
    },
    dirname: function(path) {
      return $.$get$context().dirname$1(path);
    },
    join: function(part1, part2, part3) {
      var _null = null;
      return $.$get$context().join$8(0, part1, part2, part3, _null, _null, _null, _null, _null);
    },
    prettyUri: function(uri) {
      return $.$get$context().prettyUri$1(uri);
    }
  },
  A = {MapExpression: function MapExpression(t0, t1) {
      this.pairs = t0;
      this.span = t1;
    }, MapExpression_toString_closure: function MapExpression_toString_closure() {
    }, IncludeRule: function IncludeRule(t0, t1, t2, t3, t4) {
      var _ = this;
      _.namespace = t0;
      _.name = t1;
      _.$arguments = t2;
      _.content = t3;
      _.span = t4;
    }, Configuration: function Configuration(t0, t1) {
      this._values = t0;
      this.isImplicit = t1;
    },
    watch: function(options, graph) {
      var $async$goto = 0,
        $async$completer = P._makeAsyncAwaitCompleter(-1),
        $async$returnValue, t4, t5, t6, t7, dirWatcher, watcher, destination, t1, t2, t3;
      var $async$watch = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        if ($async$errorCode === 1)
          return P._asyncRethrow($async$result, $async$completer);
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = P.String;
              t2 = [t1];
              t3 = H.setRuntimeTypeInfo([], t2);
              for (options._ensureSources$0(), t4 = J.get$iterator$ax(options._sourceDirectoriesToDestinations.get$keys()); t4.moveNext$0();)
                t3.push(t4.get$current(t4));
              for (options._ensureSources$0(), t4 = J.map$1$1$ax(options._sourcesToDestinations.get$keys(), D.path__dirname$closure(), t1), t4 = t4.get$iterator(t4); t4.moveNext$0();)
                t3.push(t4.get$current(t4));
              for (t4 = options._options, t2 = J.get$iterator$ax(H.subtypeCast(t4.$index(0, "load-path"), "$isList", t2, "$asList")); t2.moveNext$0();)
                t3.push(t2.get$current(t2));
              t2 = H.boolTypeCast(t4.$index(0, "poll"));
              t5 = [P.Stream, E.WatchEvent];
              t6 = E.WatchEvent;
              t7 = new L.StreamGroup(C._StreamGroupState_dormant, new H.JsLinkedHashMap([t5, [P.StreamSubscription, E.WatchEvent]]), [t6]);
              t7._controller = P.StreamController_StreamController(t7.get$_onCancel(), t7.get$_onListen(), t7.get$_onPause(), t7.get$_onResume(), true, t6);
              dirWatcher = new U.MultiDirWatcher(P.LinkedHashMap_LinkedHashMap$_empty(t1, t5), t7, t2);
              $async$goto = 3;
              return P._asyncAwait(P.Future_wait(new H.MappedListIterable(t3, new A.watch_closure(dirWatcher), [H.getTypeArgumentByIndex(t3, 0), [P.Future, -1]]), -1), $async$watch);
            case 3:
              // returning from await.
              watcher = new A._Watcher(options, graph);
              options._ensureSources$0(), t1 = J.get$iterator$ax(options._sourcesToDestinations.get$keys());
            case 4:
              // for condition
              if (!t1.moveNext$0()) {
                // goto after for
                $async$goto = 5;
                break;
              }
              t2 = t1.get$current(t1);
              options._ensureSources$0();
              destination = options._sourcesToDestinations.$index(0, t2);
              t3 = $.$get$context();
              graph.addCanonical$3(new F.FilesystemImporter(t3.absolute$7(".", null, null, null, null, null, null)), t3.toUri$1(t3.canonicalize$1(t2)), t3.toUri$1(t2));
              $async$goto = 6;
              return P._asyncAwait(watcher.compile$3$ifModified(t2, destination, true), $async$watch);
            case 6:
              // returning from await.
              if (!$async$result && H.boolTypeCast(t4.$index(0, "stop-on-error"))) {
                dirWatcher._group._controller._subscribe$4(null, null, null, false).cancel$0();
                // goto return
                $async$goto = 1;
                break;
              }
              // goto for condition
              $async$goto = 4;
              break;
            case 5:
              // after for
              P.print("Sass is watching for changes. Press Ctrl-C to stop.\n");
              $async$goto = 7;
              return P._asyncAwait(watcher.watch$1(0, dirWatcher), $async$watch);
            case 7:
              // returning from await.
            case 1:
              // return
              return P._asyncReturn($async$returnValue, $async$completer);
          }
      });
      return P._asyncStartSync($async$watch, $async$completer);
    },
    watch_closure: function watch_closure(t0) {
      this.dirWatcher = t0;
    },
    _Watcher: function _Watcher(t0, t1) {
      this._watch$_options = t0;
      this._graph = t1;
    },
    _Watcher__debounceEvents_closure: function _Watcher__debounceEvents_closure() {
    },
    _Watcher__debounceEvents__closure: function _Watcher__debounceEvents__closure(t0) {
      this.typeForPath = t0;
    },
    _Watcher__retryPotentialImports_recanonicalize: function _Watcher__retryPotentialImports_recanonicalize(t0, t1, t2, t3) {
      var _ = this;
      _._box_0 = t0;
      _.$this = t1;
      _.name = t2;
      _.node = t3;
    },
    MergedExtension_merge: function(left, right) {
      var t2, t3, t4,
        t1 = left.extender;
      if (!J.$eq$(t1, right.extender) || !J.$eq$(left.target, right.target))
        throw H.wrapException(P.ArgumentError$(left.toString$0(0) + " and " + right.toString$0(0) + " aren't the same extension."));
      t2 = left.mediaContext;
      t3 = t2 == null;
      if (!t3) {
        t4 = right.mediaContext;
        t4 = t4 != null && !C.C_ListEquality.equals$2(t2, t4);
      } else
        t4 = false;
      if (t4)
        throw H.wrapException(E.SassException$("From " + left.span.message$1(0, "") + "\nYou may not @extend the same selector from within different media queries.", right.span));
      if (right.isOptional && right.mediaContext == null)
        return left;
      if (left.isOptional && t3)
        return right;
      if (t3)
        t2 = right.mediaContext;
      t3 = left.specificity;
      if (t3 == null)
        t3 = t1.get$maxSpecificity();
      return new A.MergedExtension(left, right, t1, left.target, t3, true, false, t2, left.extenderSpan, left.span);
    },
    MergedExtension: function MergedExtension(t0, t1, t2, t3, t4, t5, t6, t7, t8, t9) {
      var _ = this;
      _.left = t0;
      _.right = t1;
      _.extender = t2;
      _.target = t3;
      _.specificity = t4;
      _.isOptional = t5;
      _.isOriginal = t6;
      _.mediaContext = t7;
      _.extenderSpan = t8;
      _.span = t9;
    },
    closure35: function closure35() {
    },
    closure34: function closure34() {
    },
    closure30: function closure30() {
    },
    closure31: function closure31() {
    },
    closure29: function closure29() {
    },
    closure28: function closure28() {
    },
    closure27: function closure27() {
    },
    _NodeSassMap: function _NodeSassMap() {
    },
    closure105: function closure105() {
    },
    _closure15: function _closure15() {
    },
    _closure16: function _closure16() {
    },
    closure106: function closure106() {
    },
    closure107: function closure107() {
    },
    closure108: function closure108() {
    },
    closure109: function closure109() {
    },
    closure110: function closure110() {
    },
    closure111: function closure111() {
    },
    SassMap: function SassMap(t0) {
      this.contents = t0;
    },
    SassMap_asList_closure: function SassMap_asList_closure(t0) {
      this.result = t0;
    },
    Frame_Frame$parseVM: function(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseVM_closure(frame));
    },
    Frame_Frame$parseV8: function(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseV8_closure(frame));
    },
    Frame_Frame$parseFirefox: function(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseFirefox_closure(frame));
    },
    Frame_Frame$parseFriendly: function(frame) {
      return A.Frame__catchFormatException(frame, new A.Frame_Frame$parseFriendly_closure(frame));
    },
    Frame__uriOrPathToUri: function(uriOrPath) {
      if (J.getInterceptor$asx(uriOrPath).contains$1(uriOrPath, $.$get$Frame__uriRegExp()))
        return P.Uri_parse(uriOrPath);
      else if (C.JSString_methods.contains$1(uriOrPath, $.$get$Frame__windowsRegExp()))
        return P._Uri__Uri$file(uriOrPath, true);
      else if (C.JSString_methods.startsWith$1(uriOrPath, "/"))
        return P._Uri__Uri$file(uriOrPath, false);
      if (C.JSString_methods.contains$1(uriOrPath, "\\"))
        return $.$get$windows().toUri$1(uriOrPath);
      return P.Uri_parse(uriOrPath);
    },
    Frame__catchFormatException: function(text, body) {
      var t1, exception;
      try {
        t1 = body.call$0();
        return t1;
      } catch (exception) {
        if (!!J.getInterceptor$(H.unwrapException(exception)).$isFormatException)
          return new N.UnparsedFrame(P._Uri__Uri(null, "unparsed", null, null), text);
        else
          throw exception;
      }
    },
    Frame: function Frame(t0, t1, t2, t3) {
      var _ = this;
      _.uri = t0;
      _.line = t1;
      _.column = t2;
      _.member = t3;
    },
    Frame_Frame$parseVM_closure: function Frame_Frame$parseVM_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseV8_closure: function Frame_Frame$parseV8_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseV8_closure_parseLocation: function Frame_Frame$parseV8_closure_parseLocation(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseFirefox_closure: function Frame_Frame$parseFirefox_closure(t0) {
      this.frame = t0;
    },
    Frame_Frame$parseFriendly_closure: function Frame_Frame$parseFriendly_closure(t0) {
      this.frame = t0;
    },
    AsciiGlyphSet: function AsciiGlyphSet() {
    }
  },
  S = {VariableExpression: function VariableExpression(t0, t1, t2) {
      this.namespace = t0;
      this.name = t1;
      this.span = t2;
    },
    ComplexSelector$: function(components, lineBreak) {
      var t1 = P.List_List$unmodifiable(components, S.ComplexSelectorComponent);
      if (t1.length === 0)
        H.throwExpression(P.ArgumentError$("components may not be empty."));
      return new S.ComplexSelector(t1, lineBreak);
    },
    ComplexSelector: function ComplexSelector(t0, t1) {
      var _ = this;
      _.components = t0;
      _.lineBreak = t1;
      _._complex$_isInvisible = _._maxSpecificity = _._minSpecificity = null;
    },
    ComplexSelector_isInvisible_closure: function ComplexSelector_isInvisible_closure() {
    },
    ComplexSelectorComponent: function ComplexSelectorComponent() {
    },
    Combinator: function Combinator(t0) {
      this._complex$_text = t0;
    },
    AsyncBuiltInCallable$parsed: function($name, $arguments, callback) {
      var t1 = H.setRuntimeTypeInfo([], [[S.Tuple2, B.ArgumentDeclaration, {func: 1, ret: {futureOr: 1, type: F.Value}, args: [[P.List, F.Value]]}]]);
      t1.push(new S.Tuple2($arguments, callback, [B.ArgumentDeclaration, {func: 1, ret: {futureOr: 1, type: F.Value}, args: [[P.List, F.Value]]}]));
      return new S.AsyncBuiltInCallable($name, t1);
    },
    AsyncBuiltInCallable: function AsyncBuiltInCallable(t0, t1) {
      this.name = t0;
      this._async_built_in$_overloads = t1;
    },
    Extension$oneOff: function(extender, isOriginal, specificity) {
      var _null = null;
      return new S.Extension(extender, _null, specificity == null ? extender.get$maxSpecificity() : specificity, true, isOriginal, _null, _null, _null);
    },
    Extension: function Extension(t0, t1, t2, t3, t4, t5, t6, t7) {
      var _ = this;
      _.extender = t0;
      _.target = t1;
      _.specificity = t2;
      _.isOptional = t3;
      _.isOriginal = t4;
      _.mediaContext = t5;
      _.extenderSpan = t6;
      _.span = t7;
    },
    StderrLogger: function StderrLogger(t0) {
      this.color = t0;
    },
    SpanScanner$: function(string, sourceUrl) {
      var t1, t2, t3, t4;
      string.toString;
      t1 = new H.CodeUnits(string);
      t2 = H.setRuntimeTypeInfo([0], [P.int]);
      t3 = typeof sourceUrl === "string";
      t4 = t3 ? P.Uri_parse(sourceUrl) : sourceUrl;
      t2 = new Y.SourceFile(t4, t2, new Uint32Array(H._ensureNativeList(t1.toList$0(t1))));
      t2.SourceFile$decoded$2$url(t1, sourceUrl);
      t1 = t3 ? P.Uri_parse(sourceUrl) : H.interceptedTypeCast(sourceUrl, "$isUri");
      return new S.SpanScanner(t2, t1, string);
    },
    SpanScanner: function SpanScanner(t0, t1, t2) {
      var _ = this;
      _._sourceFile = t0;
      _.sourceUrl = t1;
      _.string = t2;
      _._string_scanner$_position = 0;
      _._lastMatchPosition = _._lastMatch = null;
    },
    _SpanScannerState: function _SpanScannerState(t0, t1) {
      this._scanner = t0;
      this.position = t1;
    },
    Tuple2: function Tuple2(t0, t1, t2) {
      this.item1 = t0;
      this.item2 = t1;
      this.$ti = t2;
    },
    Tuple3: function Tuple3(t0, t1, t2, t3) {
      var _ = this;
      _.item1 = t0;
      _.item2 = t1;
      _.item3 = t2;
      _.$ti = t3;
    }
  };
  var holders = [C, H, J, P, N, Z, V, G, E, F, Y, L, Q, B, O, U, M, X, K, R, T, D, A, S];
  hunkHelpers.setFunctionNamesIfNecessary(holders);
  var $ = {};
  H.JS_CONST.prototype = {};
  J.Interceptor.prototype = {
    $eq: function(receiver, other) {
      return receiver === other;
    },
    get$hashCode: function(receiver) {
      return H.Primitives_objectHashCode(receiver);
    },
    toString$0: function(receiver) {
      return "Instance of '" + H.S(H.Primitives_objectTypeName(receiver)) + "'";
    },
    noSuchMethod$1: function(receiver, invocation) {
      throw H.wrapException(P.NoSuchMethodError$(receiver, invocation.get$memberName(), invocation.get$positionalArguments(), invocation.get$namedArguments()));
    }
  };
  J.JSBool.prototype = {
    toString$0: function(receiver) {
      return String(receiver);
    },
    get$hashCode: function(receiver) {
      return receiver ? 519018 : 218159;
    },
    $isbool: 1
  };
  J.JSNull.prototype = {
    $eq: function(receiver, other) {
      return null == other;
    },
    toString$0: function(receiver) {
      return "null";
    },
    get$hashCode: function(receiver) {
      return 0;
    },
    noSuchMethod$1: function(receiver, invocation) {
      return this.super$Interceptor$noSuchMethod(receiver, invocation);
    },
    $isNull: 1
  };
  J.JavaScriptObject.prototype = {
    get$hashCode: function(receiver) {
      return 0;
    },
    toString$0: function(receiver) {
      return String(receiver);
    },
    $is_SystemError: 1,
    $isJSError: 1,
    $isFunction: 1,
    $isJSFunction: 1,
    $isNodeImporterResult: 1,
    $isRenderOptions: 1,
    $isRenderResult: 1,
    $is_NodeSassColor: 1,
    $is_NodeSassList: 1,
    $is_NodeSassMap: 1,
    $is_NodeSassNumber: 1,
    $is_NodeSassString: 1,
    get$isTTY: function(obj) {
      return obj.isTTY;
    },
    get$write: function(obj) {
      return obj.write;
    },
    write$1: function(receiver, p0) {
      return receiver.write(p0);
    },
    createInterface$1: function(receiver, p0) {
      return receiver.createInterface(p0);
    },
    on$2: function(receiver, p0, p1) {
      return receiver.on(p0, p1);
    },
    get$close: function(obj) {
      return obj.close;
    },
    close$0: function(receiver) {
      return receiver.close();
    },
    setPrompt$1: function(receiver, p0) {
      return receiver.setPrompt(p0);
    },
    readFileSync$2: function(receiver, p0, p1) {
      return receiver.readFileSync(p0, p1);
    },
    writeFileSync$2: function(receiver, p0, p1) {
      return receiver.writeFileSync(p0, p1);
    },
    existsSync$1: function(receiver, p0) {
      return receiver.existsSync(p0);
    },
    mkdirSync$1: function(receiver, p0) {
      return receiver.mkdirSync(p0);
    },
    statSync$1: function(receiver, p0) {
      return receiver.statSync(p0);
    },
    unlinkSync$1: function(receiver, p0) {
      return receiver.unlinkSync(p0);
    },
    readdirSync$1: function(receiver, p0) {
      return receiver.readdirSync(p0);
    },
    isFile$0: function(receiver) {
      return receiver.isFile();
    },
    isDirectory$0: function(receiver) {
      return receiver.isDirectory();
    },
    get$mtime: function(obj) {
      return obj.mtime;
    },
    getTime$0: function(receiver) {
      return receiver.getTime();
    },
    get$message: function(obj) {
      return obj.message;
    },
    message$1: function(receiver, p0) {
      return receiver.message(p0);
    },
    get$code: function(obj) {
      return obj.code;
    },
    get$syscall: function(obj) {
      return obj.syscall;
    },
    get$path: function(obj) {
      return obj.path;
    },
    get$platform: function(obj) {
      return obj.platform;
    },
    get$env: function(obj) {
      return obj.env;
    },
    watch$2: function(receiver, p0, p1) {
      return receiver.watch(p0, p1);
    },
    set$run_: function(obj, v) {
      return obj.run_ = v;
    },
    set$render: function(obj, v) {
      return obj.render = v;
    },
    set$renderSync: function(obj, v) {
      return obj.renderSync = v;
    },
    set$info: function(obj, v) {
      return obj.info = v;
    },
    set$types: function(obj, v) {
      return obj.types = v;
    },
    call$1: function(receiver, p0) {
      return receiver.call(p0);
    },
    call$1$1: function(receiver, p0) {
      return receiver.call(p0);
    },
    get$current: function(obj) {
      return obj.current;
    },
    yield$0: function(receiver) {
      return receiver.yield();
    },
    run$1: function(receiver, p0) {
      return receiver.run(p0);
    },
    run$0: function(receiver) {
      return receiver.run();
    },
    call$0: function(receiver) {
      return receiver.call();
    },
    call$2: function(receiver, p0, p1) {
      return receiver.call(p0, p1);
    },
    call$3: function(receiver, p0, p1, p2) {
      return receiver.call(p0, p1, p2);
    },
    call$1$3: function(receiver, p0, p1, p2) {
      return receiver.call(p0, p1, p2);
    },
    call$2$2: function(receiver, p0, p1) {
      return receiver.call(p0, p1);
    },
    call$1$0: function(receiver) {
      return receiver.call();
    },
    apply$2: function(receiver, p0, p1) {
      return receiver.apply(p0, p1);
    },
    get$file: function(obj) {
      return obj.file;
    },
    get$contents: function(obj) {
      return obj.contents;
    },
    get$options: function(obj) {
      return obj.options;
    },
    get$data: function(obj) {
      return obj.data;
    },
    get$includePaths: function(obj) {
      return obj.includePaths;
    },
    get$indentType: function(obj) {
      return obj.indentType;
    },
    get$indentWidth: function(obj) {
      return obj.indentWidth;
    },
    get$linefeed: function(obj) {
      return obj.linefeed;
    },
    set$context: function(obj, v) {
      return obj.context = v;
    },
    get$importer: function(obj) {
      return obj.importer;
    },
    get$functions: function(obj) {
      return obj.functions;
    },
    get$indentedSyntax: function(obj) {
      return obj.indentedSyntax;
    },
    get$omitSourceMapUrl: function(obj) {
      return obj.omitSourceMapUrl;
    },
    get$outFile: function(obj) {
      return obj.outFile;
    },
    get$outputStyle: function(obj) {
      return obj.outputStyle;
    },
    get$fiber: function(obj) {
      return obj.fiber;
    },
    get$sourceMap: function(obj) {
      return obj.sourceMap;
    },
    get$sourceMapContents: function(obj) {
      return obj.sourceMapContents;
    },
    get$sourceMapEmbed: function(obj) {
      return obj.sourceMapEmbed;
    },
    get$sourceMapRoot: function(obj) {
      return obj.sourceMapRoot;
    },
    map$1$1: function(receiver, p0) {
      return receiver.map(p0);
    },
    map$1: function(receiver, p0) {
      return receiver.map(p0);
    },
    get$start: function(obj) {
      return obj.start;
    },
    get$end: function(obj) {
      return obj.end;
    },
    get$dartValue: function(obj) {
      return obj.dartValue;
    },
    set$dartValue: function(obj, v) {
      return obj.dartValue = v;
    }
  };
  J.PlainJavaScriptObject.prototype = {};
  J.UnknownJavaScriptObject.prototype = {};
  J.JavaScriptFunction.prototype = {
    toString$0: function(receiver) {
      var dartClosure = receiver[$.$get$DART_CLOSURE_PROPERTY_NAME()];
      if (dartClosure == null)
        return this.super$JavaScriptObject$toString(receiver);
      return "JavaScript function for " + H.S(J.toString$0$(dartClosure));
    },
    $signature: function() {
      return {func: 1, opt: [,,,,,,,,,,,,,,,,]};
    },
    $isFunction: 1
  };
  J.JSArray.prototype = {
    cast$1$0: function(receiver, $R) {
      return new H.CastList(receiver, [H.getTypeArgumentByIndex(receiver, 0), $R]);
    },
    add$1: function(receiver, value) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("add"));
      receiver.push(value);
    },
    removeAt$1: function(receiver, index) {
      var t1;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("removeAt"));
      t1 = receiver.length;
      if (index >= t1)
        throw H.wrapException(P.RangeError$value(index, null, null));
      return receiver.splice(index, 1)[0];
    },
    insert$2: function(receiver, index, value) {
      var t1;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("insert"));
      t1 = receiver.length;
      if (index > t1)
        throw H.wrapException(P.RangeError$value(index, null, null));
      receiver.splice(index, 0, value);
    },
    insertAll$2: function(receiver, index, iterable) {
      var t1, insertionLength, end;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("insertAll"));
      P.RangeError_checkValueInInterval(index, 0, receiver.length, "index");
      t1 = J.getInterceptor$(iterable);
      if (!t1.$isEfficientLengthIterable)
        iterable = t1.toList$0(iterable);
      insertionLength = J.get$length$asx(iterable);
      this.set$length(receiver, receiver.length + insertionLength);
      end = index + insertionLength;
      this.setRange$4(receiver, end, receiver.length, receiver, index);
      this.setRange$3(receiver, index, end, iterable);
    },
    setAll$2: function(receiver, index, iterable) {
      var t1, index0;
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("setAll"));
      P.RangeError_checkValueInInterval(index, 0, receiver.length, "index");
      for (t1 = J.get$iterator$ax(iterable); t1.moveNext$0(); index = index0) {
        index0 = index + 1;
        this.$indexSet(receiver, index, t1.get$current(t1));
      }
    },
    removeLast$0: function(receiver) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("removeLast"));
      if (receiver.length === 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, -1));
      return receiver.pop();
    },
    remove$1: function(receiver, element) {
      var i;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("remove"));
      for (i = 0; i < receiver.length; ++i)
        if (J.$eq$(receiver[i], element)) {
          receiver.splice(i, 1);
          return true;
        }
      return false;
    },
    _removeWhere$2: function(receiver, test, removeMatching) {
      var i, element, t1, retained = [],
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        element = receiver[i];
        if (!test.call$1(element))
          retained.push(element);
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      t1 = retained.length;
      if (t1 === end)
        return;
      this.set$length(receiver, t1);
      for (i = 0; i < retained.length; ++i)
        receiver[i] = retained[i];
    },
    where$1: function(receiver, f) {
      return new H.WhereIterable(receiver, f, [H.getTypeArgumentByIndex(receiver, 0)]);
    },
    expand$1$1: function(receiver, f, $T) {
      return new H.ExpandIterable(receiver, f, [H.getTypeArgumentByIndex(receiver, 0), $T]);
    },
    addAll$1: function(receiver, collection) {
      var t1;
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("addAll"));
      for (t1 = J.get$iterator$ax(collection); t1.moveNext$0();)
        receiver.push(t1.get$current(t1));
    },
    forEach$1: function(receiver, f) {
      var i,
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        f.call$1(receiver[i]);
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
    },
    map$1$1: function(receiver, f, $T) {
      return new H.MappedListIterable(receiver, f, [H.getTypeArgumentByIndex(receiver, 0), $T]);
    },
    map$1: function($receiver, f) {
      return this.map$1$1($receiver, f, null);
    },
    join$1: function(receiver, separator) {
      var i,
        list = new Array(receiver.length);
      list.fixed$length = Array;
      for (i = 0; i < receiver.length; ++i)
        list[i] = H.S(receiver[i]);
      return list.join(separator);
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    take$1: function(receiver, n) {
      return H.SubListIterable$(receiver, 0, n, H.getTypeArgumentByIndex(receiver, 0));
    },
    skip$1: function(receiver, n) {
      return H.SubListIterable$(receiver, n, null, H.getTypeArgumentByIndex(receiver, 0));
    },
    fold$1$2: function(receiver, initialValue, combine) {
      var value, i,
        $length = receiver.length;
      for (value = initialValue, i = 0; i < $length; ++i) {
        value = combine.call$2(value, receiver[i]);
        if (receiver.length !== $length)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return value;
    },
    fold$2: function($receiver, initialValue, combine) {
      return this.fold$1$2($receiver, initialValue, combine, null);
    },
    lastWhere$2$orElse: function(receiver, test, orElse) {
      var i, element,
        $length = receiver.length;
      for (i = $length - 1; i >= 0; --i) {
        element = receiver[i];
        if (test.call$1(element))
          return element;
        if ($length !== receiver.length)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      if (orElse != null)
        return orElse.call$0();
      throw H.wrapException(H.IterableElementError_noElement());
    },
    elementAt$1: function(receiver, index) {
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      if (start < 0 || start > receiver.length)
        throw H.wrapException(P.RangeError$range(start, 0, receiver.length, "start", null));
      if (end == null)
        end = receiver.length;
      else if (end < start || end > receiver.length)
        throw H.wrapException(P.RangeError$range(end, start, receiver.length, "end", null));
      if (start === end)
        return H.setRuntimeTypeInfo([], [H.getTypeArgumentByIndex(receiver, 0)]);
      return H.setRuntimeTypeInfo(receiver.slice(start, end), [H.getTypeArgumentByIndex(receiver, 0)]);
    },
    sublist$1: function($receiver, start) {
      return this.sublist$2($receiver, start, null);
    },
    getRange$2: function(receiver, start, end) {
      P.RangeError_checkValidRange(start, end, receiver.length);
      return H.SubListIterable$(receiver, start, end, H.getTypeArgumentByIndex(receiver, 0));
    },
    get$first: function(receiver) {
      if (receiver.length > 0)
        return receiver[0];
      throw H.wrapException(H.IterableElementError_noElement());
    },
    get$last: function(receiver) {
      var t1 = receiver.length;
      if (t1 > 0)
        return receiver[t1 - 1];
      throw H.wrapException(H.IterableElementError_noElement());
    },
    get$single: function(receiver) {
      var t1 = receiver.length;
      if (t1 === 1)
        return receiver[0];
      if (t1 === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      throw H.wrapException(H.IterableElementError_tooMany());
    },
    removeRange$2: function(receiver, start, end) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("removeRange"));
      P.RangeError_checkValidRange(start, end, receiver.length);
      receiver.splice(start, end - start);
    },
    setRange$4: function(receiver, start, end, iterable, skipCount) {
      var $length, t1, otherStart, otherList, i;
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("setRange"));
      P.RangeError_checkValidRange(start, end, receiver.length);
      $length = end - start;
      if ($length === 0)
        return;
      P.RangeError_checkNotNegative(skipCount, "skipCount");
      t1 = J.getInterceptor$(iterable);
      if (!!t1.$isList) {
        otherStart = skipCount;
        otherList = iterable;
      } else {
        otherList = t1.skip$1(iterable, skipCount).toList$1$growable(0, false);
        otherStart = 0;
      }
      t1 = J.getInterceptor$asx(otherList);
      if (otherStart + $length > t1.get$length(otherList))
        throw H.wrapException(H.IterableElementError_tooFew());
      if (otherStart < start)
        for (i = $length - 1; i >= 0; --i)
          receiver[start + i] = t1.$index(otherList, otherStart + i);
      else
        for (i = 0; i < $length; ++i)
          receiver[start + i] = t1.$index(otherList, otherStart + i);
    },
    setRange$3: function($receiver, start, end, iterable) {
      return this.setRange$4($receiver, start, end, iterable, 0);
    },
    fillRange$3: function(receiver, start, end, fillValue) {
      var i;
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("fill range"));
      P.RangeError_checkValidRange(start, end, receiver.length);
      for (i = start; i < end; ++i)
        receiver[i] = fillValue;
    },
    any$1: function(receiver, test) {
      var i,
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        if (test.call$1(receiver[i]))
          return true;
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return false;
    },
    every$1: function(receiver, test) {
      var i,
        end = receiver.length;
      for (i = 0; i < end; ++i) {
        if (!test.call$1(receiver[i]))
          return false;
        if (receiver.length !== end)
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return true;
    },
    get$reversed: function(receiver) {
      return new H.ReversedListIterable(receiver, [H.getTypeArgumentByIndex(receiver, 0)]);
    },
    sort$1: function(receiver, compare) {
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("sort"));
      H.Sort_sort(receiver, compare == null ? J._interceptors_JSArray__compareAny$closure() : compare);
    },
    sort$0: function($receiver) {
      return this.sort$1($receiver, null);
    },
    indexOf$1: function(receiver, element) {
      var i;
      if (0 >= receiver.length)
        return -1;
      for (i = 0; i < receiver.length; ++i)
        if (J.$eq$(receiver[i], element))
          return i;
      return -1;
    },
    contains$1: function(receiver, other) {
      var i;
      for (i = 0; i < receiver.length; ++i)
        if (J.$eq$(receiver[i], other))
          return true;
      return false;
    },
    get$isEmpty: function(receiver) {
      return receiver.length === 0;
    },
    get$isNotEmpty: function(receiver) {
      return receiver.length !== 0;
    },
    toString$0: function(receiver) {
      return P.IterableBase_iterableToFullString(receiver, "[", "]");
    },
    toList$1$growable: function(receiver, growable) {
      var t1 = H.getTypeArgumentByIndex(receiver, 0);
      return growable ? H.setRuntimeTypeInfo(receiver.slice(0), [t1]) : J.JSArray_JSArray$markFixed(receiver.slice(0), t1);
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0: function(receiver) {
      return P.LinkedHashSet_LinkedHashSet$from(receiver, H.getTypeArgumentByIndex(receiver, 0));
    },
    get$iterator: function(receiver) {
      return new J.ArrayIterator(receiver, receiver.length);
    },
    get$hashCode: function(receiver) {
      return H.Primitives_objectHashCode(receiver);
    },
    get$length: function(receiver) {
      return receiver.length;
    },
    set$length: function(receiver, newLength) {
      if (!!receiver.fixed$length)
        H.throwExpression(P.UnsupportedError$("set length"));
      if (newLength < 0)
        throw H.wrapException(P.RangeError$range(newLength, 0, null, "newLength", null));
      receiver.length = newLength;
    },
    $index: function(receiver, index) {
      if (typeof index !== "number" || Math.floor(index) !== index)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      if (index >= receiver.length || index < 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      return receiver[index];
    },
    $indexSet: function(receiver, index, value) {
      if (!!receiver.immutable$list)
        H.throwExpression(P.UnsupportedError$("indexed set"));
      if (typeof index !== "number" || Math.floor(index) !== index)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      if (index >= receiver.length || index < 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      receiver[index] = value;
    },
    $add: function(receiver, other) {
      var totalLength = receiver.length + other.length,
        t1 = H.setRuntimeTypeInfo([], [H.getTypeArgumentByIndex(receiver, 0)]);
      this.set$length(t1, totalLength);
      this.setRange$3(t1, 0, receiver.length, receiver);
      this.setRange$3(t1, receiver.length, totalLength, other);
      return t1;
    },
    $isEfficientLengthIterable: 1,
    $isIterable: 1,
    $isList: 1
  };
  J.JSUnmodifiableArray.prototype = {};
  J.ArrayIterator.prototype = {
    get$current: function(_) {
      return this._current;
    },
    moveNext$0: function() {
      var t2, _this = this,
        t1 = _this._iterable,
        $length = t1.length;
      if (_this._length !== $length)
        throw H.wrapException(H.throwConcurrentModificationError(t1));
      t2 = _this._index;
      if (t2 >= $length) {
        _this._current = null;
        return false;
      }
      _this._current = t1[t2];
      _this._index = t2 + 1;
      return true;
    }
  };
  J.JSNumber.prototype = {
    compareTo$1: function(receiver, b) {
      var bIsNegative;
      if (typeof b !== "number")
        throw H.wrapException(H.argumentErrorValue(b));
      if (receiver < b)
        return -1;
      else if (receiver > b)
        return 1;
      else if (receiver === b) {
        if (receiver === 0) {
          bIsNegative = this.get$isNegative(b);
          if (this.get$isNegative(receiver) === bIsNegative)
            return 0;
          if (this.get$isNegative(receiver))
            return -1;
          return 1;
        }
        return 0;
      } else if (isNaN(receiver)) {
        if (isNaN(b))
          return 0;
        return 1;
      } else
        return -1;
    },
    get$isNegative: function(receiver) {
      return receiver === 0 ? 1 / receiver < 0 : receiver < 0;
    },
    ceil$0: function(receiver) {
      var truncated, d;
      if (receiver >= 0) {
        if (receiver <= 2147483647) {
          truncated = receiver | 0;
          return receiver === truncated ? truncated : truncated + 1;
        }
      } else if (receiver >= -2147483648)
        return receiver | 0;
      d = Math.ceil(receiver);
      if (isFinite(d))
        return d;
      throw H.wrapException(P.UnsupportedError$("" + receiver + ".ceil()"));
    },
    floor$0: function(receiver) {
      var truncated, d;
      if (receiver >= 0) {
        if (receiver <= 2147483647)
          return receiver | 0;
      } else if (receiver >= -2147483648) {
        truncated = receiver | 0;
        return receiver === truncated ? truncated : truncated - 1;
      }
      d = Math.floor(receiver);
      if (isFinite(d))
        return d;
      throw H.wrapException(P.UnsupportedError$("" + receiver + ".floor()"));
    },
    round$0: function(receiver) {
      if (receiver > 0) {
        if (receiver !== 1 / 0)
          return Math.round(receiver);
      } else if (receiver > -1 / 0)
        return 0 - Math.round(0 - receiver);
      throw H.wrapException(P.UnsupportedError$("" + receiver + ".round()"));
    },
    clamp$2: function(receiver, lowerLimit, upperLimit) {
      if (C.JSInt_methods.compareTo$1(lowerLimit, upperLimit) > 0)
        throw H.wrapException(H.argumentErrorValue(lowerLimit));
      if (this.compareTo$1(receiver, lowerLimit) < 0)
        return lowerLimit;
      if (this.compareTo$1(receiver, upperLimit) > 0)
        return upperLimit;
      return receiver;
    },
    toRadixString$1: function(receiver, radix) {
      var result, match, exponent, t1;
      if (radix < 2 || radix > 36)
        throw H.wrapException(P.RangeError$range(radix, 2, 36, "radix", null));
      result = receiver.toString(radix);
      if (C.JSString_methods.codeUnitAt$1(result, result.length - 1) !== 41)
        return result;
      match = /^([\da-z]+)(?:\.([\da-z]+))?\(e\+(\d+)\)$/.exec(result);
      if (match == null)
        H.throwExpression(P.UnsupportedError$("Unexpected toString result: " + result));
      result = match[1];
      exponent = +match[3];
      t1 = match[2];
      if (t1 != null) {
        result += t1;
        exponent -= t1.length;
      }
      return result + C.JSString_methods.$mul("0", exponent);
    },
    toString$0: function(receiver) {
      if (receiver === 0 && 1 / receiver < 0)
        return "-0.0";
      else
        return "" + receiver;
    },
    get$hashCode: function(receiver) {
      var absolute, floorLog2, factor, scaled,
        intValue = receiver | 0;
      if (receiver === intValue)
        return 536870911 & intValue;
      absolute = Math.abs(receiver);
      floorLog2 = Math.log(absolute) / 0.6931471805599453 | 0;
      factor = Math.pow(2, floorLog2);
      scaled = absolute < 1 ? absolute / factor : factor / absolute;
      return 536870911 & ((scaled * 9007199254740992 | 0) + (scaled * 3542243181176521 | 0)) * 599197 + floorLog2 * 1259;
    },
    $add: function(receiver, other) {
      if (typeof other !== "number")
        throw H.wrapException(H.argumentErrorValue(other));
      return receiver + other;
    },
    $mod: function(receiver, other) {
      var result = receiver % other;
      if (result === 0)
        return 0;
      if (result > 0)
        return result;
      if (other < 0)
        return result - other;
      else
        return result + other;
    },
    $tdiv: function(receiver, other) {
      if ((receiver | 0) === receiver)
        if (other >= 1 || other < -1)
          return receiver / other | 0;
      return this._tdivSlow$1(receiver, other);
    },
    _tdivFast$1: function(receiver, other) {
      return (receiver | 0) === receiver ? receiver / other | 0 : this._tdivSlow$1(receiver, other);
    },
    _tdivSlow$1: function(receiver, other) {
      var quotient = receiver / other;
      if (quotient >= -2147483648 && quotient <= 2147483647)
        return quotient | 0;
      if (quotient > 0) {
        if (quotient !== 1 / 0)
          return Math.floor(quotient);
      } else if (quotient > -1 / 0)
        return Math.ceil(quotient);
      throw H.wrapException(P.UnsupportedError$("Result of truncating division is " + H.S(quotient) + ": " + H.S(receiver) + " ~/ " + other));
    },
    _shrOtherPositive$1: function(receiver, other) {
      var t1;
      if (receiver > 0)
        t1 = this._shrBothPositive$1(receiver, other);
      else {
        t1 = other > 31 ? 31 : other;
        t1 = receiver >> t1 >>> 0;
      }
      return t1;
    },
    _shrReceiverPositive$1: function(receiver, other) {
      if (other < 0)
        throw H.wrapException(H.argumentErrorValue(other));
      return this._shrBothPositive$1(receiver, other);
    },
    _shrBothPositive$1: function(receiver, other) {
      return other > 31 ? 0 : receiver >>> other;
    },
    $isComparable: 1,
    $asComparable: function() {
      return [P.num];
    },
    $isdouble: 1,
    $isnum: 1
  };
  J.JSInt.prototype = {$isint: 1};
  J.JSDouble.prototype = {};
  J.JSString.prototype = {
    codeUnitAt$1: function(receiver, index) {
      if (typeof index !== "number" || Math.floor(index) !== index)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      if (index < 0)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      if (index >= receiver.length)
        H.throwExpression(H.diagnoseIndexError(receiver, index));
      return receiver.charCodeAt(index);
    },
    _codeUnitAt$1: function(receiver, index) {
      if (index >= receiver.length)
        throw H.wrapException(H.diagnoseIndexError(receiver, index));
      return receiver.charCodeAt(index);
    },
    allMatches$2: function(receiver, string, start) {
      var t1;
      if (typeof string !== "string")
        H.throwExpression(H.argumentErrorValue(string));
      t1 = string.length;
      if (start > t1)
        throw H.wrapException(P.RangeError$range(start, 0, t1, null, null));
      return new H._StringAllMatchesIterable(string, receiver, start);
    },
    allMatches$1: function($receiver, string) {
      return this.allMatches$2($receiver, string, 0);
    },
    matchAsPrefix$2: function(receiver, string, start) {
      var t1, t2, i;
      if (start < 0 || start > string.length)
        throw H.wrapException(P.RangeError$range(start, 0, string.length, null, null));
      t1 = receiver.length;
      if (start + t1 > string.length)
        return;
      for (t2 = J.getInterceptor$s(string), i = 0; i < t1; ++i)
        if (t2.codeUnitAt$1(string, start + i) !== this._codeUnitAt$1(receiver, i))
          return;
      return new H.StringMatch(start, receiver);
    },
    $add: function(receiver, other) {
      if (typeof other !== "string")
        throw H.wrapException(P.ArgumentError$value(other, null, null));
      return receiver + other;
    },
    endsWith$1: function(receiver, other) {
      var otherLength = other.length,
        t1 = receiver.length;
      if (otherLength > t1)
        return false;
      return other === this.substring$1(receiver, t1 - otherLength);
    },
    replaceFirst$2: function(receiver, from, to) {
      P.RangeError_checkValueInInterval(0, 0, receiver.length, "startIndex");
      return H.stringReplaceFirstUnchecked(receiver, from, to, 0);
    },
    replaceRange$3: function(receiver, start, end, replacement) {
      if (typeof replacement !== "string")
        H.throwExpression(H.argumentErrorValue(replacement));
      if (typeof start !== "number" || Math.floor(start) !== start)
        H.throwExpression(H.argumentErrorValue(start));
      end = P.RangeError_checkValidRange(start, end, receiver.length);
      return H.stringReplaceRangeUnchecked(receiver, start, end, replacement);
    },
    startsWith$2: function(receiver, pattern, index) {
      var endIndex;
      if (typeof index !== "number" || Math.floor(index) !== index)
        H.throwExpression(H.argumentErrorValue(index));
      if (index < 0 || index > receiver.length)
        throw H.wrapException(P.RangeError$range(index, 0, receiver.length, null, null));
      if (typeof pattern === "string") {
        endIndex = index + pattern.length;
        if (endIndex > receiver.length)
          return false;
        return pattern === receiver.substring(index, endIndex);
      }
      return J.matchAsPrefix$2$s(pattern, receiver, index) != null;
    },
    startsWith$1: function($receiver, pattern) {
      return this.startsWith$2($receiver, pattern, 0);
    },
    substring$2: function(receiver, startIndex, endIndex) {
      var _null = null;
      if (typeof startIndex !== "number" || Math.floor(startIndex) !== startIndex)
        H.throwExpression(H.argumentErrorValue(startIndex));
      if (endIndex == null)
        endIndex = receiver.length;
      if (startIndex < 0)
        throw H.wrapException(P.RangeError$value(startIndex, _null, _null));
      if (startIndex > endIndex)
        throw H.wrapException(P.RangeError$value(startIndex, _null, _null));
      if (endIndex > receiver.length)
        throw H.wrapException(P.RangeError$value(endIndex, _null, _null));
      return receiver.substring(startIndex, endIndex);
    },
    substring$1: function($receiver, startIndex) {
      return this.substring$2($receiver, startIndex, null);
    },
    trim$0: function(receiver) {
      var startIndex, t1, endIndex0,
        result = receiver.trim(),
        endIndex = result.length;
      if (endIndex === 0)
        return result;
      if (this._codeUnitAt$1(result, 0) === 133) {
        startIndex = J.JSString__skipLeadingWhitespace(result, 1);
        if (startIndex === endIndex)
          return "";
      } else
        startIndex = 0;
      t1 = endIndex - 1;
      endIndex0 = this.codeUnitAt$1(result, t1) === 133 ? J.JSString__skipTrailingWhitespace(result, t1) : endIndex;
      if (startIndex === 0 && endIndex0 === endIndex)
        return result;
      return result.substring(startIndex, endIndex0);
    },
    trimRight$0: function(receiver) {
      var result, endIndex, t1;
      if (typeof receiver.trimRight != "undefined") {
        result = receiver.trimRight();
        endIndex = result.length;
        if (endIndex === 0)
          return result;
        t1 = endIndex - 1;
        if (this.codeUnitAt$1(result, t1) === 133)
          endIndex = J.JSString__skipTrailingWhitespace(result, t1);
      } else {
        endIndex = J.JSString__skipTrailingWhitespace(receiver, receiver.length);
        result = receiver;
      }
      if (endIndex === result.length)
        return result;
      if (endIndex === 0)
        return "";
      return result.substring(0, endIndex);
    },
    $mul: function(receiver, times) {
      var s, result;
      if (0 >= times)
        return "";
      if (times === 1 || receiver.length === 0)
        return receiver;
      if (times !== times >>> 0)
        throw H.wrapException(C.C_OutOfMemoryError);
      for (s = receiver, result = ""; true;) {
        if ((times & 1) === 1)
          result = s + result;
        times = times >>> 1;
        if (times === 0)
          break;
        s += s;
      }
      return result;
    },
    padLeft$2: function(receiver, width, padding) {
      var delta = width - receiver.length;
      if (delta <= 0)
        return receiver;
      return this.$mul(padding, delta) + receiver;
    },
    padRight$1: function(receiver, width) {
      var delta = width - receiver.length;
      if (delta <= 0)
        return receiver;
      return receiver + this.$mul(" ", delta);
    },
    indexOf$2: function(receiver, pattern, start) {
      var t1, t2, i;
      if (pattern == null)
        H.throwExpression(H.argumentErrorValue(pattern));
      if (start < 0 || start > receiver.length)
        throw H.wrapException(P.RangeError$range(start, 0, receiver.length, null, null));
      if (typeof pattern === "string")
        return receiver.indexOf(pattern, start);
      for (t1 = receiver.length, t2 = J.getInterceptor$s(pattern), i = start; i <= t1; ++i)
        if (t2.matchAsPrefix$2(pattern, receiver, i) != null)
          return i;
      return -1;
    },
    indexOf$1: function($receiver, pattern) {
      return this.indexOf$2($receiver, pattern, 0);
    },
    lastIndexOf$2: function(receiver, pattern, start) {
      var t1, t2, i;
      if (pattern == null)
        H.throwExpression(H.argumentErrorValue(pattern));
      if (start == null)
        start = receiver.length;
      else if (start < 0 || start > receiver.length)
        throw H.wrapException(P.RangeError$range(start, 0, receiver.length, null, null));
      if (typeof pattern === "string") {
        t1 = pattern.length;
        t2 = receiver.length;
        if (start + t1 > t2)
          start = t2 - t1;
        return receiver.lastIndexOf(pattern, start);
      }
      for (t1 = J.getInterceptor$s(pattern), i = start; i >= 0; --i)
        if (t1.matchAsPrefix$2(pattern, receiver, i) != null)
          return i;
      return -1;
    },
    lastIndexOf$1: function($receiver, pattern) {
      return this.lastIndexOf$2($receiver, pattern, null);
    },
    contains$2: function(receiver, other, startIndex) {
      var t1;
      if (other == null)
        H.throwExpression(H.argumentErrorValue(other));
      t1 = receiver.length;
      if (startIndex > t1)
        throw H.wrapException(P.RangeError$range(startIndex, 0, t1, null, null));
      return H.stringContainsUnchecked(receiver, other, startIndex);
    },
    contains$1: function($receiver, other) {
      return this.contains$2($receiver, other, 0);
    },
    get$isNotEmpty: function(receiver) {
      return receiver.length !== 0;
    },
    compareTo$1: function(receiver, other) {
      var t1;
      if (typeof other !== "string")
        throw H.wrapException(H.argumentErrorValue(other));
      if (receiver === other)
        t1 = 0;
      else
        t1 = receiver < other ? -1 : 1;
      return t1;
    },
    toString$0: function(receiver) {
      return receiver;
    },
    get$hashCode: function(receiver) {
      var t1, hash, i;
      for (t1 = receiver.length, hash = 0, i = 0; i < t1; ++i) {
        hash = 536870911 & hash + receiver.charCodeAt(i);
        hash = 536870911 & hash + ((524287 & hash) << 10);
        hash ^= hash >> 6;
      }
      hash = 536870911 & hash + ((67108863 & hash) << 3);
      hash ^= hash >> 11;
      return 536870911 & hash + ((16383 & hash) << 15);
    },
    get$length: function(receiver) {
      return receiver.length;
    },
    $isComparable: 1,
    $asComparable: function() {
      return [P.String];
    },
    $isString: 1
  };
  H._CastIterableBase.prototype = {
    get$iterator: function(_) {
      return new H.CastIterator(J.get$iterator$ax(this.get$_source()), this.$ti);
    },
    get$length: function(_) {
      return J.get$length$asx(this.get$_source());
    },
    get$isEmpty: function(_) {
      return J.get$isEmpty$asx(this.get$_source());
    },
    get$isNotEmpty: function(_) {
      return J.get$isNotEmpty$asx(this.get$_source());
    },
    skip$1: function(_, count) {
      return H.CastIterable_CastIterable(J.skip$1$ax(this.get$_source(), count), H.getTypeArgumentByIndex(this, 0), H.getTypeArgumentByIndex(this, 1));
    },
    take$1: function(_, count) {
      return H.CastIterable_CastIterable(J.take$1$ax(this.get$_source(), count), H.getTypeArgumentByIndex(this, 0), H.getTypeArgumentByIndex(this, 1));
    },
    elementAt$1: function(_, index) {
      return H.subtypeOfRuntimeTypeCast(J.elementAt$1$ax(this.get$_source(), index), H.getTypeArgumentByIndex(this, 1));
    },
    get$first: function(_) {
      return H.subtypeOfRuntimeTypeCast(J.get$first$ax(this.get$_source()), H.getTypeArgumentByIndex(this, 1));
    },
    get$last: function(_) {
      return H.subtypeOfRuntimeTypeCast(J.get$last$ax(this.get$_source()), H.getTypeArgumentByIndex(this, 1));
    },
    get$single: function(_) {
      return H.subtypeOfRuntimeTypeCast(J.get$single$ax(this.get$_source()), H.getTypeArgumentByIndex(this, 1));
    },
    contains$1: function(_, other) {
      return J.contains$1$asx(this.get$_source(), other);
    },
    toString$0: function(_) {
      return J.toString$0$(this.get$_source());
    },
    $asIterable: function($S, $T) {
      return [$T];
    }
  };
  H.CastIterator.prototype = {
    moveNext$0: function() {
      return this._source.moveNext$0();
    },
    get$current: function(_) {
      var t1 = this._source;
      return H.subtypeOfRuntimeTypeCast(t1.get$current(t1), H.getTypeArgumentByIndex(this, 1));
    }
  };
  H.CastIterable.prototype = {
    cast$1$0: function(_, $R) {
      return H.CastIterable_CastIterable(this._source, H.getTypeArgumentByIndex(this, 0), $R);
    },
    get$_source: function() {
      return this._source;
    }
  };
  H._EfficientLengthCastIterable.prototype = {$isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    }
  };
  H._CastListBase.prototype = {
    $index: function(_, index) {
      return H.subtypeOfRuntimeTypeCast(J.$index$asx(this._source, index), H.getTypeArgumentByIndex(this, 1));
    },
    $indexSet: function(_, index, value) {
      J.$indexSet$ax(this._source, index, H.subtypeOfRuntimeTypeCast(value, H.getTypeArgumentByIndex(this, 0)));
    },
    set$length: function(_, $length) {
      J.set$length$asx(this._source, $length);
    },
    add$1: function(_, value) {
      J.add$1$ax(this._source, H.subtypeOfRuntimeTypeCast(value, H.getTypeArgumentByIndex(this, 0)));
    },
    addAll$1: function(_, values) {
      J.addAll$1$ax(this._source, H.CastIterable_CastIterable(values, H.getTypeArgumentByIndex(this, 1), H.getTypeArgumentByIndex(this, 0)));
    },
    setRange$4: function(_, start, end, iterable, skipCount) {
      J.setRange$4$ax(this._source, start, end, H.CastIterable_CastIterable(iterable, H.getTypeArgumentByIndex(this, 1), H.getTypeArgumentByIndex(this, 0)), skipCount);
    },
    fillRange$3: function(_, start, end, fillValue) {
      J.fillRange$3$ax(this._source, start, end, H.subtypeOfRuntimeTypeCast(fillValue, H.getTypeArgumentByIndex(this, 0)));
    },
    $isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    },
    $asListMixin: function($S, $T) {
      return [$T];
    },
    $isList: 1,
    $asList: function($S, $T) {
      return [$T];
    }
  };
  H.CastList.prototype = {
    cast$1$0: function(_, $R) {
      return new H.CastList(this._source, [H.getTypeArgumentByIndex(this, 0), $R]);
    },
    get$_source: function() {
      return this._source;
    }
  };
  H.CastSet.prototype = {
    cast$1$0: function(_, $R) {
      return new H.CastSet(this._source, this._emptySet, [H.getTypeArgumentByIndex(this, 0), $R]);
    },
    add$1: function(_, value) {
      return this._source.add$1(0, H.subtypeOfRuntimeTypeCast(value, H.getTypeArgumentByIndex(this, 0)));
    },
    addAll$1: function(_, elements) {
      this._source.addAll$1(0, H.CastIterable_CastIterable(elements, H.getTypeArgumentByIndex(this, 1), H.getTypeArgumentByIndex(this, 0)));
    },
    toSet$0: function(_) {
      var t1 = this._emptySet,
        result = t1 == null ? P.LinkedHashSet_LinkedHashSet(H.getTypeArgumentByIndex(this, 1)) : t1.call$0();
      result.addAll$1(0, this);
      return result;
    },
    $isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    },
    $isSet: 1,
    $asSet: function($S, $T) {
      return [$T];
    },
    get$_source: function() {
      return this._source;
    }
  };
  H.CastQueue.prototype = {
    cast$1$0: function(_, $R) {
      return new H.CastQueue(this._source, [H.getTypeArgumentByIndex(this, 0), $R]);
    },
    add$1: function(_, value) {
      this._source._collection$_add$1(H.subtypeOfRuntimeTypeCast(value, H.getTypeArgumentByIndex(this, 0)));
    },
    $isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    },
    $isQueue: 1,
    $asQueue: function($S, $T) {
      return [$T];
    },
    get$_source: function() {
      return this._source;
    }
  };
  H.CodeUnits.prototype = {
    get$length: function(_) {
      return this.__internal$_string.length;
    },
    $index: function(_, i) {
      return C.JSString_methods.codeUnitAt$1(this.__internal$_string, i);
    },
    $asEfficientLengthIterable: function() {
      return [P.int];
    },
    $asListMixin: function() {
      return [P.int];
    },
    $asIterable: function() {
      return [P.int];
    },
    $asList: function() {
      return [P.int];
    }
  };
  H.EfficientLengthIterable.prototype = {};
  H.ListIterable.prototype = {
    get$iterator: function(_) {
      return new H.ListIterator(this, this.get$length(this));
    },
    get$isEmpty: function(_) {
      return this.get$length(this) === 0;
    },
    get$first: function(_) {
      if (this.get$length(this) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      return this.elementAt$1(0, 0);
    },
    get$last: function(_) {
      var _this = this;
      if (_this.get$length(_this) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      return _this.elementAt$1(0, _this.get$length(_this) - 1);
    },
    get$single: function(_) {
      var _this = this;
      if (_this.get$length(_this) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      if (_this.get$length(_this) > 1)
        throw H.wrapException(H.IterableElementError_tooMany());
      return _this.elementAt$1(0, 0);
    },
    contains$1: function(_, element) {
      var i, _this = this,
        $length = _this.get$length(_this);
      for (i = 0; i < $length; ++i) {
        if (J.$eq$(_this.elementAt$1(0, i), element))
          return true;
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return false;
    },
    any$1: function(_, test) {
      var i, _this = this,
        $length = _this.get$length(_this);
      for (i = 0; i < $length; ++i) {
        if (test.call$1(_this.elementAt$1(0, i)))
          return true;
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return false;
    },
    join$1: function(_, separator) {
      var first, t1, i, _this = this,
        $length = _this.get$length(_this);
      if (separator.length !== 0) {
        if ($length === 0)
          return "";
        first = H.S(_this.elementAt$1(0, 0));
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
        for (t1 = first, i = 1; i < $length; ++i) {
          t1 = t1 + separator + H.S(_this.elementAt$1(0, i));
          if ($length !== _this.get$length(_this))
            throw H.wrapException(P.ConcurrentModificationError$(_this));
        }
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      } else {
        for (i = 0, t1 = ""; i < $length; ++i) {
          t1 += H.S(_this.elementAt$1(0, i));
          if ($length !== _this.get$length(_this))
            throw H.wrapException(P.ConcurrentModificationError$(_this));
        }
        return t1.charCodeAt(0) == 0 ? t1 : t1;
      }
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    where$1: function(_, test) {
      return this.super$Iterable$where(0, test);
    },
    map$1$1: function(_, f, $T) {
      return new H.MappedListIterable(this, f, [H.getRuntimeTypeArgument(this, "ListIterable", 0), $T]);
    },
    reduce$1: function(_, combine) {
      var value, i, _this = this,
        $length = _this.get$length(_this);
      if ($length === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      value = _this.elementAt$1(0, 0);
      for (i = 1; i < $length; ++i) {
        value = combine.call$2(value, _this.elementAt$1(0, i));
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return value;
    },
    fold$1$2: function(_, initialValue, combine) {
      var value, i, _this = this,
        $length = _this.get$length(_this);
      for (value = initialValue, i = 0; i < $length; ++i) {
        value = combine.call$2(value, _this.elementAt$1(0, i));
        if ($length !== _this.get$length(_this))
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return value;
    },
    fold$2: function($receiver, initialValue, combine) {
      return this.fold$1$2($receiver, initialValue, combine, null);
    },
    skip$1: function(_, count) {
      return H.SubListIterable$(this, count, null, H.getRuntimeTypeArgument(this, "ListIterable", 0));
    },
    take$1: function(_, count) {
      return H.SubListIterable$(this, 0, count, H.getRuntimeTypeArgument(this, "ListIterable", 0));
    },
    toList$1$growable: function(_, growable) {
      var result, t2, i, _this = this,
        t1 = H.getRuntimeTypeArgument(_this, "ListIterable", 0);
      if (growable) {
        result = H.setRuntimeTypeInfo([], [t1]);
        C.JSArray_methods.set$length(result, _this.get$length(_this));
      } else {
        t2 = new Array(_this.get$length(_this));
        t2.fixed$length = Array;
        result = H.setRuntimeTypeInfo(t2, [t1]);
      }
      for (i = 0; i < _this.get$length(_this); ++i)
        result[i] = _this.elementAt$1(0, i);
      return result;
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0: function(_) {
      var i, _this = this,
        result = P.LinkedHashSet_LinkedHashSet(H.getRuntimeTypeArgument(_this, "ListIterable", 0));
      for (i = 0; i < _this.get$length(_this); ++i)
        result.add$1(0, _this.elementAt$1(0, i));
      return result;
    }
  };
  H.SubListIterable.prototype = {
    get$_endIndex: function() {
      var $length = J.get$length$asx(this.__internal$_iterable),
        t1 = this._endOrLength;
      if (t1 == null || t1 > $length)
        return $length;
      return t1;
    },
    get$_startIndex: function() {
      var $length = J.get$length$asx(this.__internal$_iterable),
        t1 = this.__internal$_start;
      if (t1 > $length)
        return $length;
      return t1;
    },
    get$length: function(_) {
      var t2,
        $length = J.get$length$asx(this.__internal$_iterable),
        t1 = this.__internal$_start;
      if (t1 >= $length)
        return 0;
      t2 = this._endOrLength;
      if (t2 == null || t2 >= $length)
        return $length - t1;
      return t2 - t1;
    },
    elementAt$1: function(_, index) {
      var _this = this,
        realIndex = _this.get$_startIndex() + index;
      if (index < 0 || realIndex >= _this.get$_endIndex())
        throw H.wrapException(P.IndexError$(index, _this, "index", null, null));
      return J.elementAt$1$ax(_this.__internal$_iterable, realIndex);
    },
    skip$1: function(_, count) {
      var newStart, t1, _this = this;
      P.RangeError_checkNotNegative(count, "count");
      newStart = _this.__internal$_start + count;
      t1 = _this._endOrLength;
      if (t1 != null && newStart >= t1)
        return new H.EmptyIterable(_this.$ti);
      return H.SubListIterable$(_this.__internal$_iterable, newStart, t1, H.getTypeArgumentByIndex(_this, 0));
    },
    take$1: function(_, count) {
      var t1, t2, newEnd, _this = this;
      P.RangeError_checkNotNegative(count, "count");
      t1 = _this._endOrLength;
      t2 = _this.__internal$_start;
      if (t1 == null)
        return H.SubListIterable$(_this.__internal$_iterable, t2, t2 + count, H.getTypeArgumentByIndex(_this, 0));
      else {
        newEnd = t2 + count;
        if (t1 < newEnd)
          return _this;
        return H.SubListIterable$(_this.__internal$_iterable, t2, newEnd, H.getTypeArgumentByIndex(_this, 0));
      }
    },
    toList$1$growable: function(_, growable) {
      var $length, t3, result, t4, i, _this = this,
        start = _this.__internal$_start,
        t1 = _this.__internal$_iterable,
        t2 = J.getInterceptor$asx(t1),
        end = t2.get$length(t1),
        end0 = _this._endOrLength;
      if (end0 != null && end0 < end)
        end = end0;
      $length = end - start;
      if ($length < 0)
        $length = 0;
      t3 = _this.$ti;
      if (growable) {
        result = H.setRuntimeTypeInfo([], t3);
        C.JSArray_methods.set$length(result, $length);
      } else {
        t4 = new Array($length);
        t4.fixed$length = Array;
        result = H.setRuntimeTypeInfo(t4, t3);
      }
      for (i = 0; i < $length; ++i) {
        result[i] = t2.elementAt$1(t1, start + i);
        if (t2.get$length(t1) < end)
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
      return result;
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    }
  };
  H.ListIterator.prototype = {
    get$current: function(_) {
      return this.__internal$_current;
    },
    moveNext$0: function() {
      var t3, _this = this,
        t1 = _this.__internal$_iterable,
        t2 = J.getInterceptor$asx(t1),
        $length = t2.get$length(t1);
      if (_this.__internal$_length !== $length)
        throw H.wrapException(P.ConcurrentModificationError$(t1));
      t3 = _this.__internal$_index;
      if (t3 >= $length) {
        _this.__internal$_current = null;
        return false;
      }
      _this.__internal$_current = t2.elementAt$1(t1, t3);
      ++_this.__internal$_index;
      return true;
    }
  };
  H.MappedIterable.prototype = {
    get$iterator: function(_) {
      return new H.MappedIterator(J.get$iterator$ax(this.__internal$_iterable), this._f);
    },
    get$length: function(_) {
      return J.get$length$asx(this.__internal$_iterable);
    },
    get$isEmpty: function(_) {
      return J.get$isEmpty$asx(this.__internal$_iterable);
    },
    get$first: function(_) {
      return this._f.call$1(J.get$first$ax(this.__internal$_iterable));
    },
    get$last: function(_) {
      return this._f.call$1(J.get$last$ax(this.__internal$_iterable));
    },
    get$single: function(_) {
      return this._f.call$1(J.get$single$ax(this.__internal$_iterable));
    },
    elementAt$1: function(_, index) {
      return this._f.call$1(J.elementAt$1$ax(this.__internal$_iterable, index));
    },
    $asIterable: function($S, $T) {
      return [$T];
    }
  };
  H.EfficientLengthMappedIterable.prototype = {$isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    }
  };
  H.MappedIterator.prototype = {
    moveNext$0: function() {
      var _this = this,
        t1 = _this._iterator;
      if (t1.moveNext$0()) {
        _this.__internal$_current = _this._f.call$1(t1.get$current(t1));
        return true;
      }
      _this.__internal$_current = null;
      return false;
    },
    get$current: function(_) {
      return this.__internal$_current;
    }
  };
  H.MappedListIterable.prototype = {
    get$length: function(_) {
      return J.get$length$asx(this._source);
    },
    elementAt$1: function(_, index) {
      return this._f.call$1(J.elementAt$1$ax(this._source, index));
    },
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    },
    $asListIterable: function($S, $T) {
      return [$T];
    },
    $asIterable: function($S, $T) {
      return [$T];
    }
  };
  H.WhereIterable.prototype = {
    get$iterator: function(_) {
      return new H.WhereIterator(J.get$iterator$ax(this.__internal$_iterable), this._f);
    },
    map$1$1: function(_, f, $T) {
      return new H.MappedIterable(this, f, [H.getTypeArgumentByIndex(this, 0), $T]);
    }
  };
  H.WhereIterator.prototype = {
    moveNext$0: function() {
      var t1, t2;
      for (t1 = this._iterator, t2 = this._f; t1.moveNext$0();)
        if (t2.call$1(t1.get$current(t1)))
          return true;
      return false;
    },
    get$current: function(_) {
      var t1 = this._iterator;
      return t1.get$current(t1);
    }
  };
  H.ExpandIterable.prototype = {
    get$iterator: function(_) {
      return new H.ExpandIterator(J.get$iterator$ax(this.__internal$_iterable), this._f, C.C_EmptyIterator);
    },
    $asIterable: function($S, $T) {
      return [$T];
    }
  };
  H.ExpandIterator.prototype = {
    get$current: function(_) {
      return this.__internal$_current;
    },
    moveNext$0: function() {
      var t2, t3, _this = this,
        t1 = _this._currentExpansion;
      if (t1 == null)
        return false;
      for (t2 = _this._iterator, t3 = _this._f; !t1.moveNext$0();) {
        _this.__internal$_current = null;
        if (t2.moveNext$0()) {
          _this._currentExpansion = null;
          t1 = J.get$iterator$ax(t3.call$1(t2.get$current(t2)));
          _this._currentExpansion = t1;
        } else
          return false;
      }
      t1 = _this._currentExpansion;
      _this.__internal$_current = t1.get$current(t1);
      return true;
    }
  };
  H.TakeIterable.prototype = {
    get$iterator: function(_) {
      return new H.TakeIterator(J.get$iterator$ax(this.__internal$_iterable), this._takeCount);
    }
  };
  H.EfficientLengthTakeIterable.prototype = {
    get$length: function(_) {
      var iterableLength = J.get$length$asx(this.__internal$_iterable),
        t1 = this._takeCount;
      if (iterableLength > t1)
        return t1;
      return iterableLength;
    },
    $isEfficientLengthIterable: 1
  };
  H.TakeIterator.prototype = {
    moveNext$0: function() {
      if (--this._remaining >= 0)
        return this._iterator.moveNext$0();
      this._remaining = -1;
      return false;
    },
    get$current: function(_) {
      var t1;
      if (this._remaining < 0)
        return;
      t1 = this._iterator;
      return t1.get$current(t1);
    }
  };
  H.SkipIterable.prototype = {
    skip$1: function(_, count) {
      if (count == null)
        H.throwExpression(P.ArgumentError$notNull("count"));
      P.RangeError_checkNotNegative(count, "count");
      return new H.SkipIterable(this.__internal$_iterable, this._skipCount + count, this.$ti);
    },
    get$iterator: function(_) {
      return new H.SkipIterator(J.get$iterator$ax(this.__internal$_iterable), this._skipCount);
    }
  };
  H.EfficientLengthSkipIterable.prototype = {
    get$length: function(_) {
      var $length = J.get$length$asx(this.__internal$_iterable) - this._skipCount;
      if ($length >= 0)
        return $length;
      return 0;
    },
    skip$1: function(_, count) {
      if (count == null)
        H.throwExpression(P.ArgumentError$notNull("count"));
      P.RangeError_checkNotNegative(count, "count");
      return new H.EfficientLengthSkipIterable(this.__internal$_iterable, this._skipCount + count, this.$ti);
    },
    $isEfficientLengthIterable: 1
  };
  H.SkipIterator.prototype = {
    moveNext$0: function() {
      var t1, i;
      for (t1 = this._iterator, i = 0; i < this._skipCount; ++i)
        t1.moveNext$0();
      this._skipCount = 0;
      return t1.moveNext$0();
    },
    get$current: function(_) {
      var t1 = this._iterator;
      return t1.get$current(t1);
    }
  };
  H.SkipWhileIterable.prototype = {
    get$iterator: function(_) {
      return new H.SkipWhileIterator(J.get$iterator$ax(this.__internal$_iterable), this._f);
    }
  };
  H.SkipWhileIterator.prototype = {
    moveNext$0: function() {
      var t1, t2, _this = this;
      if (!_this._hasSkipped) {
        _this._hasSkipped = true;
        for (t1 = _this._iterator, t2 = _this._f; t1.moveNext$0();)
          if (!t2.call$1(t1.get$current(t1)))
            return true;
      }
      return _this._iterator.moveNext$0();
    },
    get$current: function(_) {
      var t1 = this._iterator;
      return t1.get$current(t1);
    }
  };
  H.EmptyIterable.prototype = {
    get$iterator: function(_) {
      return C.C_EmptyIterator;
    },
    get$isEmpty: function(_) {
      return true;
    },
    get$length: function(_) {
      return 0;
    },
    get$first: function(_) {
      throw H.wrapException(H.IterableElementError_noElement());
    },
    get$last: function(_) {
      throw H.wrapException(H.IterableElementError_noElement());
    },
    get$single: function(_) {
      throw H.wrapException(H.IterableElementError_noElement());
    },
    elementAt$1: function(_, index) {
      throw H.wrapException(P.RangeError$range(index, 0, 0, "index", null));
    },
    contains$1: function(_, element) {
      return false;
    },
    join$1: function(_, separator) {
      return "";
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    where$1: function(_, test) {
      return this;
    },
    map$1$1: function(_, f, $T) {
      return new H.EmptyIterable([$T]);
    },
    skip$1: function(_, count) {
      P.RangeError_checkNotNegative(count, "count");
      return this;
    },
    take$1: function(_, count) {
      P.RangeError_checkNotNegative(count, "count");
      return this;
    },
    toList$1$growable: function(_, growable) {
      var t2,
        t1 = this.$ti;
      if (growable)
        t1 = H.setRuntimeTypeInfo([], t1);
      else {
        t2 = new Array(0);
        t2.fixed$length = Array;
        t1 = H.setRuntimeTypeInfo(t2, t1);
      }
      return t1;
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0: function(_) {
      return P.LinkedHashSet_LinkedHashSet(H.getTypeArgumentByIndex(this, 0));
    }
  };
  H.EmptyIterator.prototype = {
    moveNext$0: function() {
      return false;
    },
    get$current: function(_) {
      return;
    }
  };
  H.FollowedByIterable.prototype = {
    get$iterator: function(_) {
      return new H.FollowedByIterator(J.get$iterator$ax(this.__internal$_first), this._second);
    },
    get$length: function(_) {
      var t1 = this._second;
      return J.get$length$asx(this.__internal$_first) + t1.get$length(t1);
    },
    get$isEmpty: function(_) {
      var t1;
      if (J.get$isEmpty$asx(this.__internal$_first)) {
        t1 = this._second;
        t1 = t1.get$isEmpty(t1);
      } else
        t1 = false;
      return t1;
    },
    get$isNotEmpty: function(_) {
      var t1;
      if (!J.get$isNotEmpty$asx(this.__internal$_first)) {
        t1 = this._second;
        t1 = t1.get$isNotEmpty(t1);
      } else
        t1 = true;
      return t1;
    },
    contains$1: function(_, value) {
      var t1;
      if (!J.contains$1$asx(this.__internal$_first, value)) {
        t1 = this._second;
        t1 = t1.contains$1(t1, value);
      } else
        t1 = true;
      return t1;
    },
    get$first: function(_) {
      var t1,
        iterator = J.get$iterator$ax(this.__internal$_first);
      if (iterator.moveNext$0())
        return iterator.get$current(iterator);
      t1 = this._second;
      return t1.get$first(t1);
    },
    get$last: function(_) {
      var last,
        t1 = this._second,
        iterator = t1.get$iterator(t1);
      if (iterator.moveNext$0()) {
        last = iterator.get$current(iterator);
        for (; iterator.moveNext$0();)
          last = iterator.get$current(iterator);
        return last;
      }
      return J.get$last$ax(this.__internal$_first);
    }
  };
  H.EfficientLengthFollowedByIterable.prototype = {
    skip$1: function(_, count) {
      var _this = this,
        t1 = _this.__internal$_first,
        t2 = J.getInterceptor$asx(t1),
        firstLength = t2.get$length(t1);
      if (count >= firstLength) {
        t1 = _this._second;
        return t1.skip$1(t1, count - firstLength);
      }
      return new H.EfficientLengthFollowedByIterable(t2.skip$1(t1, count), _this._second, _this.$ti);
    },
    take$1: function(_, count) {
      var t1 = this.__internal$_first,
        t2 = J.getInterceptor$asx(t1),
        firstLength = t2.get$length(t1);
      if (count <= firstLength)
        return t2.take$1(t1, count);
      t2 = this._second;
      return new H.EfficientLengthFollowedByIterable(t1, t2.take$1(t2, count - firstLength), this.$ti);
    },
    elementAt$1: function(_, index) {
      var t1 = this.__internal$_first,
        t2 = J.getInterceptor$asx(t1),
        firstLength = t2.get$length(t1);
      if (index < firstLength)
        return t2.elementAt$1(t1, index);
      t1 = this._second;
      return t1.elementAt$1(t1, index - firstLength);
    },
    get$first: function(_) {
      var t1 = this.__internal$_first,
        t2 = J.getInterceptor$asx(t1);
      if (t2.get$isNotEmpty(t1))
        return t2.get$first(t1);
      t1 = this._second;
      return t1.get$first(t1);
    },
    get$last: function(_) {
      var t1 = this._second;
      if (t1.get$isNotEmpty(t1))
        return t1.get$last(t1);
      return J.get$last$ax(this.__internal$_first);
    },
    $isEfficientLengthIterable: 1
  };
  H.FollowedByIterator.prototype = {
    moveNext$0: function() {
      var t1, _this = this;
      if (_this._currentIterator.moveNext$0())
        return true;
      t1 = _this._nextIterable;
      if (t1 != null) {
        t1 = t1.get$iterator(t1);
        _this._currentIterator = t1;
        _this._nextIterable = null;
        return t1.moveNext$0();
      }
      return false;
    },
    get$current: function(_) {
      var t1 = this._currentIterator;
      return t1.get$current(t1);
    }
  };
  H.WhereTypeIterable.prototype = {
    get$iterator: function(_) {
      return new H.WhereTypeIterator(J.get$iterator$ax(this._source), this.$ti);
    }
  };
  H.WhereTypeIterator.prototype = {
    moveNext$0: function() {
      var t1, t2, t3;
      for (t1 = this._source, t2 = H.getTypeArgumentByIndex(this, 0); t1.moveNext$0();) {
        t3 = t1.get$current(t1);
        if (H.checkSubtypeOfRuntimeType(t3, t2))
          return true;
      }
      return false;
    },
    get$current: function(_) {
      var t1 = this._source;
      return t1.get$current(t1);
    }
  };
  H.FixedLengthListMixin.prototype = {
    set$length: function(receiver, newLength) {
      throw H.wrapException(P.UnsupportedError$("Cannot change the length of a fixed-length list"));
    },
    add$1: function(receiver, value) {
      throw H.wrapException(P.UnsupportedError$("Cannot add to a fixed-length list"));
    },
    addAll$1: function(receiver, iterable) {
      throw H.wrapException(P.UnsupportedError$("Cannot add to a fixed-length list"));
    }
  };
  H.UnmodifiableListMixin.prototype = {
    $indexSet: function(_, index, value) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify an unmodifiable list"));
    },
    set$length: function(_, newLength) {
      throw H.wrapException(P.UnsupportedError$("Cannot change the length of an unmodifiable list"));
    },
    add$1: function(_, value) {
      throw H.wrapException(P.UnsupportedError$("Cannot add to an unmodifiable list"));
    },
    addAll$1: function(_, iterable) {
      throw H.wrapException(P.UnsupportedError$("Cannot add to an unmodifiable list"));
    },
    setRange$4: function(_, start, end, iterable, skipCount) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify an unmodifiable list"));
    },
    fillRange$3: function(_, start, end, fillValue) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify an unmodifiable list"));
    }
  };
  H.UnmodifiableListBase.prototype = {};
  H.ReversedListIterable.prototype = {
    get$length: function(_) {
      return J.get$length$asx(this._source);
    },
    elementAt$1: function(_, index) {
      var t1 = this._source,
        t2 = J.getInterceptor$asx(t1);
      return t2.elementAt$1(t1, t2.get$length(t1) - 1 - index);
    }
  };
  H.Symbol.prototype = {
    get$hashCode: function(_) {
      var hash = this._hashCode;
      if (hash != null)
        return hash;
      hash = 536870911 & 664597 * J.get$hashCode$(this.__internal$_name);
      this._hashCode = hash;
      return hash;
    },
    toString$0: function(_) {
      return 'Symbol("' + H.S(this.__internal$_name) + '")';
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof H.Symbol && this.__internal$_name == other.__internal$_name;
    },
    $isSymbol0: 1
  };
  H.__CastListBase__CastIterableBase_ListMixin.prototype = {};
  H.ConstantMapView.prototype = {};
  H.ConstantMap.prototype = {
    get$isEmpty: function(_) {
      return this.get$length(this) === 0;
    },
    get$isNotEmpty: function(_) {
      return this.get$length(this) !== 0;
    },
    toString$0: function(_) {
      return P.MapBase_mapToString(this);
    },
    $indexSet: function(_, key, val) {
      return H.ConstantMap__throwUnmodifiable();
    },
    putIfAbsent$2: function(key, ifAbsent) {
      return H.ConstantMap__throwUnmodifiable();
    },
    remove$1: function(_, key) {
      return H.ConstantMap__throwUnmodifiable();
    },
    addAll$1: function(_, other) {
      return H.ConstantMap__throwUnmodifiable();
    },
    get$entries: function() {
      return this.entries$body$ConstantMap([P.MapEntry, H.getTypeArgumentByIndex(this, 0), H.getTypeArgumentByIndex(this, 1)]);
    },
    entries$body$ConstantMap: function($async$type) {
      var $async$self = this;
      return P._makeSyncStarIterable(function() {
        var $async$goto = 0, $async$handler = 1, $async$currentError, t1, t2, key;
        return function $async$get$entries($async$errorCode, $async$result) {
          if ($async$errorCode === 1) {
            $async$currentError = $async$result;
            $async$goto = $async$handler;
          }
          while (true)
            switch ($async$goto) {
              case 0:
                // Function start
                t1 = $async$self.get$keys(), t1 = t1.get$iterator(t1), t2 = $async$self.$ti;
              case 2:
                // for condition
                if (!t1.moveNext$0()) {
                  // goto after for
                  $async$goto = 3;
                  break;
                }
                key = t1.get$current(t1);
                $async$goto = 4;
                return new P.MapEntry(key, $async$self.$index(0, key), t2);
              case 4:
                // after yield
                // goto for condition
                $async$goto = 2;
                break;
              case 3:
                // after for
                // implicit return
                return P._IterationMarker_endOfIteration();
              case 1:
                // rethrow
                return P._IterationMarker_uncaughtError($async$currentError);
            }
        };
      }, $async$type);
    },
    $isMap: 1
  };
  H.ConstantStringMap.prototype = {
    get$length: function(_) {
      return this.__js_helper$_length;
    },
    containsKey$1: function(key) {
      if (typeof key !== "string")
        return false;
      if ("__proto__" === key)
        return false;
      return this._jsObject.hasOwnProperty(key);
    },
    $index: function(_, key) {
      if (!this.containsKey$1(key))
        return;
      return this._fetch$1(key);
    },
    _fetch$1: function(key) {
      return this._jsObject[key];
    },
    forEach$1: function(_, f) {
      var t1, i, key,
        keys = this._keys;
      for (t1 = keys.length, i = 0; i < t1; ++i) {
        key = keys[i];
        f.call$2(key, this._fetch$1(key));
      }
    },
    get$keys: function() {
      return new H._ConstantMapKeyIterable(this, [H.getTypeArgumentByIndex(this, 0)]);
    },
    get$values: function() {
      var _this = this;
      return H.MappedIterable_MappedIterable(_this._keys, new H.ConstantStringMap_values_closure(_this), H.getTypeArgumentByIndex(_this, 0), H.getTypeArgumentByIndex(_this, 1));
    }
  };
  H.ConstantStringMap_values_closure.prototype = {
    call$1: function(key) {
      return this.$this._fetch$1(key);
    },
    $signature: function() {
      var t1 = this.$this;
      return {func: 1, ret: H.getTypeArgumentByIndex(t1, 1), args: [H.getTypeArgumentByIndex(t1, 0)]};
    }
  };
  H.ConstantProtoMap.prototype = {
    containsKey$1: function(key) {
      if (typeof key !== "string")
        return false;
      if ("__proto__" === key)
        return true;
      return this._jsObject.hasOwnProperty(key);
    },
    _fetch$1: function(key) {
      return "__proto__" === key ? this._protoValue : this._jsObject[key];
    }
  };
  H._ConstantMapKeyIterable.prototype = {
    get$iterator: function(_) {
      var t1 = this._map._keys;
      return new J.ArrayIterator(t1, t1.length);
    },
    get$length: function(_) {
      return this._map._keys.length;
    }
  };
  H.Instantiation.prototype = {
    Instantiation$1: function(_genericClosure) {
      if (false)
        H.instantiatedGenericFunctionType(0, 0);
    },
    toString$0: function(_) {
      var types = "<" + C.JSArray_methods.join$1(this.get$_types(), ", ") + ">";
      return H.S(this._genericClosure) + " with " + types;
    }
  };
  H.Instantiation1.prototype = {
    get$_types: function() {
      return [new H.TypeImpl(H.getTypeArgumentByIndex(this, 0))];
    },
    call$0: function() {
      return this._genericClosure.call$1$0(this.$ti[0]);
    },
    call$2: function(a0, a1) {
      return this._genericClosure.call$1$2(a0, a1, this.$ti[0]);
    },
    call$3: function(a0, a1, a2) {
      return this._genericClosure.call$1$3(a0, a1, a2, this.$ti[0]);
    },
    call$4: function(a0, a1, a2, a3) {
      return this._genericClosure.call$1$4(a0, a1, a2, a3, this.$ti[0]);
    },
    $signature: function() {
      return H.instantiatedGenericFunctionType(H.extractFunctionTypeObjectFromInternal(this._genericClosure), this.$ti);
    }
  };
  H.JSInvocationMirror.prototype = {
    get$memberName: function() {
      var t1 = this.__js_helper$_memberName;
      return t1;
    },
    get$positionalArguments: function() {
      var t1, argumentCount, list, index, _this = this;
      if (_this._kind === 1)
        return C.List_empty12;
      t1 = _this._arguments;
      argumentCount = t1.length - _this._namedArgumentNames.length - _this._typeArgumentCount;
      if (argumentCount === 0)
        return C.List_empty12;
      list = [];
      for (index = 0; index < argumentCount; ++index)
        list.push(t1[index]);
      return J.JSArray_markUnmodifiableList(list);
    },
    get$namedArguments: function() {
      var t1, namedArgumentCount, t2, namedArgumentsStartIndex, t3, map, i, _this = this;
      if (_this._kind !== 0)
        return C.Map_empty4;
      t1 = _this._namedArgumentNames;
      namedArgumentCount = t1.length;
      t2 = _this._arguments;
      namedArgumentsStartIndex = t2.length - namedArgumentCount - _this._typeArgumentCount;
      if (namedArgumentCount === 0)
        return C.Map_empty4;
      t3 = P.Symbol0;
      map = new H.JsLinkedHashMap([t3, null]);
      for (i = 0; i < namedArgumentCount; ++i)
        map.$indexSet(0, new H.Symbol(t1[i]), t2[namedArgumentsStartIndex + i]);
      return new H.ConstantMapView(map, [t3, null]);
    }
  };
  H.Primitives_functionNoSuchMethod_closure.prototype = {
    call$2: function($name, argument) {
      var t1 = this._box_0;
      t1.names = t1.names + "$" + H.S($name);
      this.namedArgumentList.push($name);
      this.$arguments.push(argument);
      ++t1.argumentCount;
    }
  };
  H.TypeErrorDecoder.prototype = {
    matchTypeError$1: function(message) {
      var result, t1, _this = this,
        match = new RegExp(_this._pattern).exec(message);
      if (match == null)
        return;
      result = Object.create(null);
      t1 = _this._arguments;
      if (t1 !== -1)
        result.arguments = match[t1 + 1];
      t1 = _this._argumentsExpr;
      if (t1 !== -1)
        result.argumentsExpr = match[t1 + 1];
      t1 = _this._expr;
      if (t1 !== -1)
        result.expr = match[t1 + 1];
      t1 = _this._method;
      if (t1 !== -1)
        result.method = match[t1 + 1];
      t1 = _this._receiver;
      if (t1 !== -1)
        result.receiver = match[t1 + 1];
      return result;
    }
  };
  H.NullError.prototype = {
    toString$0: function(_) {
      var t1 = this._method;
      if (t1 == null)
        return "NoSuchMethodError: " + H.S(this._message);
      return "NoSuchMethodError: method not found: '" + t1 + "' on null";
    }
  };
  H.JsNoSuchMethodError.prototype = {
    toString$0: function(_) {
      var t2, _this = this,
        _s38_ = "NoSuchMethodError: method not found: '",
        t1 = _this._method;
      if (t1 == null)
        return "NoSuchMethodError: " + H.S(_this._message);
      t2 = _this._receiver;
      if (t2 == null)
        return _s38_ + t1 + "' (" + H.S(_this._message) + ")";
      return _s38_ + t1 + "' on '" + t2 + "' (" + H.S(_this._message) + ")";
    }
  };
  H.UnknownJsTypeError.prototype = {
    toString$0: function(_) {
      var t1 = this._message;
      return t1.length === 0 ? "Error" : "Error: " + t1;
    }
  };
  H.ExceptionAndStackTrace.prototype = {};
  H.unwrapException_saveStackTrace.prototype = {
    call$1: function(error) {
      if (!!J.getInterceptor$(error).$isError)
        if (error.$thrownJsError == null)
          error.$thrownJsError = this.ex;
      return error;
    },
    $signature: 11
  };
  H._StackTrace.prototype = {
    toString$0: function(_) {
      var trace,
        t1 = this._trace;
      if (t1 != null)
        return t1;
      t1 = this._exception;
      trace = t1 !== null && typeof t1 === "object" ? t1.stack : null;
      return this._trace = trace == null ? "" : trace;
    },
    $isStackTrace: 1
  };
  H.Closure.prototype = {
    toString$0: function(_) {
      var $constructor = this.constructor,
        $name = $constructor == null ? null : $constructor.name;
      return "Closure '" + H.unminifyOrTag($name == null ? "unknown" : $name) + "'";
    },
    $isFunction: 1,
    get$$call: function() {
      return this;
    },
    "call*": "call$1",
    $requiredArgCount: 1,
    $defaultValues: null
  };
  H.TearOffClosure.prototype = {};
  H.StaticClosure.prototype = {
    toString$0: function(_) {
      var $name = this.$static_name;
      if ($name == null)
        return "Closure of unknown static method";
      return "Closure '" + H.unminifyOrTag($name) + "'";
    }
  };
  H.BoundClosure.prototype = {
    $eq: function(_, other) {
      var _this = this;
      if (other == null)
        return false;
      if (_this === other)
        return true;
      if (!(other instanceof H.BoundClosure))
        return false;
      return _this._self === other._self && _this._target === other._target && _this._receiver === other._receiver;
    },
    get$hashCode: function(_) {
      var receiverHashCode,
        t1 = this._receiver;
      if (t1 == null)
        receiverHashCode = H.Primitives_objectHashCode(this._self);
      else
        receiverHashCode = typeof t1 !== "object" ? J.get$hashCode$(t1) : H.Primitives_objectHashCode(t1);
      return (receiverHashCode ^ H.Primitives_objectHashCode(this._target)) >>> 0;
    },
    toString$0: function(_) {
      var receiver = this._receiver;
      if (receiver == null)
        receiver = this._self;
      return "Closure '" + H.S(this.__js_helper$_name) + "' of " + ("Instance of '" + H.S(H.Primitives_objectTypeName(receiver)) + "'");
    }
  };
  H.CastErrorImplementation.prototype = {
    toString$0: function(_) {
      return this.message;
    },
    get$message: function(receiver) {
      return this.message;
    }
  };
  H.RuntimeError.prototype = {
    toString$0: function(_) {
      return "RuntimeError: " + H.S(this.message);
    },
    get$message: function(receiver) {
      return this.message;
    }
  };
  H.TypeImpl.prototype = {
    get$_typeName: function() {
      var t1 = this.__typeName;
      return t1 == null ? this.__typeName = H.runtimeTypeToString(this._rti) : t1;
    },
    toString$0: function(_) {
      return this.get$_typeName();
    },
    get$hashCode: function(_) {
      var t1 = this._hashCode;
      return t1 == null ? this._hashCode = C.JSString_methods.get$hashCode(this.get$_typeName()) : t1;
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof H.TypeImpl && this.get$_typeName() === other.get$_typeName();
    }
  };
  H.JsLinkedHashMap.prototype = {
    get$length: function(_) {
      return this.__js_helper$_length;
    },
    get$isEmpty: function(_) {
      return this.__js_helper$_length === 0;
    },
    get$isNotEmpty: function(_) {
      return !this.get$isEmpty(this);
    },
    get$keys: function() {
      return new H.LinkedHashMapKeyIterable(this, [H.getTypeArgumentByIndex(this, 0)]);
    },
    get$values: function() {
      var _this = this;
      return H.MappedIterable_MappedIterable(_this.get$keys(), new H.JsLinkedHashMap_values_closure(_this), H.getTypeArgumentByIndex(_this, 0), H.getTypeArgumentByIndex(_this, 1));
    },
    containsKey$1: function(key) {
      var strings, nums, _this = this;
      if (typeof key === "string") {
        strings = _this._strings;
        if (strings == null)
          return false;
        return _this._containsTableEntry$2(strings, key);
      } else if (typeof key === "number" && (key & 0x3ffffff) === key) {
        nums = _this._nums;
        if (nums == null)
          return false;
        return _this._containsTableEntry$2(nums, key);
      } else
        return _this.internalContainsKey$1(key);
    },
    internalContainsKey$1: function(key) {
      var _this = this,
        rest = _this._rest;
      if (rest == null)
        return false;
      return _this.internalFindBucketIndex$2(_this._getTableBucket$2(rest, _this.internalComputeHashCode$1(key)), key) >= 0;
    },
    addAll$1: function(_, other) {
      other.forEach$1(0, new H.JsLinkedHashMap_addAll_closure(this));
    },
    $index: function(_, key) {
      var strings, cell, t1, nums, _this = this;
      if (typeof key === "string") {
        strings = _this._strings;
        if (strings == null)
          return;
        cell = _this._getTableCell$2(strings, key);
        t1 = cell == null ? null : cell.hashMapCellValue;
        return t1;
      } else if (typeof key === "number" && (key & 0x3ffffff) === key) {
        nums = _this._nums;
        if (nums == null)
          return;
        cell = _this._getTableCell$2(nums, key);
        t1 = cell == null ? null : cell.hashMapCellValue;
        return t1;
      } else
        return _this.internalGet$1(key);
    },
    internalGet$1: function(key) {
      var bucket, index, _this = this,
        rest = _this._rest;
      if (rest == null)
        return;
      bucket = _this._getTableBucket$2(rest, _this.internalComputeHashCode$1(key));
      index = _this.internalFindBucketIndex$2(bucket, key);
      if (index < 0)
        return;
      return bucket[index].hashMapCellValue;
    },
    $indexSet: function(_, key, value) {
      var strings, nums, _this = this;
      if (typeof key === "string") {
        strings = _this._strings;
        _this._addHashTableEntry$3(strings == null ? _this._strings = _this._newHashTable$0() : strings, key, value);
      } else if (typeof key === "number" && (key & 0x3ffffff) === key) {
        nums = _this._nums;
        _this._addHashTableEntry$3(nums == null ? _this._nums = _this._newHashTable$0() : nums, key, value);
      } else
        _this.internalSet$2(key, value);
    },
    internalSet$2: function(key, value) {
      var hash, bucket, index, _this = this,
        rest = _this._rest;
      if (rest == null)
        rest = _this._rest = _this._newHashTable$0();
      hash = _this.internalComputeHashCode$1(key);
      bucket = _this._getTableBucket$2(rest, hash);
      if (bucket == null)
        _this._setTableEntry$3(rest, hash, [_this._newLinkedCell$2(key, value)]);
      else {
        index = _this.internalFindBucketIndex$2(bucket, key);
        if (index >= 0)
          bucket[index].hashMapCellValue = value;
        else
          bucket.push(_this._newLinkedCell$2(key, value));
      }
    },
    putIfAbsent$2: function(key, ifAbsent) {
      var value;
      if (this.containsKey$1(key))
        return this.$index(0, key);
      value = ifAbsent.call$0();
      this.$indexSet(0, key, value);
      return value;
    },
    remove$1: function(_, key) {
      var _this = this;
      if (typeof key === "string")
        return _this.__js_helper$_removeHashTableEntry$2(_this._strings, key);
      else if (typeof key === "number" && (key & 0x3ffffff) === key)
        return _this.__js_helper$_removeHashTableEntry$2(_this._nums, key);
      else
        return _this.internalRemove$1(key);
    },
    internalRemove$1: function(key) {
      var hash, bucket, index, cell, _this = this,
        rest = _this._rest;
      if (rest == null)
        return;
      hash = _this.internalComputeHashCode$1(key);
      bucket = _this._getTableBucket$2(rest, hash);
      index = _this.internalFindBucketIndex$2(bucket, key);
      if (index < 0)
        return;
      cell = bucket.splice(index, 1)[0];
      _this.__js_helper$_unlinkCell$1(cell);
      if (bucket.length === 0)
        _this._deleteTableEntry$2(rest, hash);
      return cell.hashMapCellValue;
    },
    clear$0: function(_) {
      var _this = this;
      if (_this.__js_helper$_length > 0) {
        _this._strings = _this._nums = _this._rest = _this._first = _this._last = null;
        _this.__js_helper$_length = 0;
        _this._modified$0();
      }
    },
    forEach$1: function(_, action) {
      var _this = this,
        cell = _this._first,
        modifications = _this._modifications;
      for (; cell != null;) {
        action.call$2(cell.hashMapCellKey, cell.hashMapCellValue);
        if (modifications !== _this._modifications)
          throw H.wrapException(P.ConcurrentModificationError$(_this));
        cell = cell._next;
      }
    },
    _addHashTableEntry$3: function(table, key, value) {
      var cell = this._getTableCell$2(table, key);
      if (cell == null)
        this._setTableEntry$3(table, key, this._newLinkedCell$2(key, value));
      else
        cell.hashMapCellValue = value;
    },
    __js_helper$_removeHashTableEntry$2: function(table, key) {
      var cell;
      if (table == null)
        return;
      cell = this._getTableCell$2(table, key);
      if (cell == null)
        return;
      this.__js_helper$_unlinkCell$1(cell);
      this._deleteTableEntry$2(table, key);
      return cell.hashMapCellValue;
    },
    _modified$0: function() {
      this._modifications = this._modifications + 1 & 67108863;
    },
    _newLinkedCell$2: function(key, value) {
      var last, _this = this,
        cell = new H.LinkedHashMapCell(key, value);
      if (_this._first == null)
        _this._first = _this._last = cell;
      else {
        last = _this._last;
        cell._previous = last;
        _this._last = last._next = cell;
      }
      ++_this.__js_helper$_length;
      _this._modified$0();
      return cell;
    },
    __js_helper$_unlinkCell$1: function(cell) {
      var _this = this,
        previous = cell._previous,
        next = cell._next;
      if (previous == null)
        _this._first = next;
      else
        previous._next = next;
      if (next == null)
        _this._last = previous;
      else
        next._previous = previous;
      --_this.__js_helper$_length;
      _this._modified$0();
    },
    internalComputeHashCode$1: function(key) {
      return J.get$hashCode$(key) & 0x3ffffff;
    },
    internalFindBucketIndex$2: function(bucket, key) {
      var $length, i;
      if (bucket == null)
        return -1;
      $length = bucket.length;
      for (i = 0; i < $length; ++i)
        if (J.$eq$(bucket[i].hashMapCellKey, key))
          return i;
      return -1;
    },
    toString$0: function(_) {
      return P.MapBase_mapToString(this);
    },
    _getTableCell$2: function(table, key) {
      return table[key];
    },
    _getTableBucket$2: function(table, key) {
      return table[key];
    },
    _setTableEntry$3: function(table, key, value) {
      table[key] = value;
    },
    _deleteTableEntry$2: function(table, key) {
      delete table[key];
    },
    _containsTableEntry$2: function(table, key) {
      return this._getTableCell$2(table, key) != null;
    },
    _newHashTable$0: function() {
      var _s20_ = "<non-identifier-key>",
        table = Object.create(null);
      this._setTableEntry$3(table, _s20_, table);
      this._deleteTableEntry$2(table, _s20_);
      return table;
    }
  };
  H.JsLinkedHashMap_values_closure.prototype = {
    call$1: function(each) {
      return this.$this.$index(0, each);
    },
    $signature: function() {
      var t1 = this.$this;
      return {func: 1, ret: H.getTypeArgumentByIndex(t1, 1), args: [H.getTypeArgumentByIndex(t1, 0)]};
    }
  };
  H.JsLinkedHashMap_addAll_closure.prototype = {
    call$2: function(key, value) {
      this.$this.$indexSet(0, key, value);
    },
    $signature: function() {
      var t1 = this.$this;
      return {func: 1, ret: P.Null, args: [H.getTypeArgumentByIndex(t1, 0), H.getTypeArgumentByIndex(t1, 1)]};
    }
  };
  H.LinkedHashMapCell.prototype = {};
  H.LinkedHashMapKeyIterable.prototype = {
    get$length: function(_) {
      return this._map.__js_helper$_length;
    },
    get$isEmpty: function(_) {
      return this._map.__js_helper$_length === 0;
    },
    get$iterator: function(_) {
      var t1 = this._map,
        t2 = new H.LinkedHashMapKeyIterator(t1, t1._modifications);
      t2._cell = t1._first;
      return t2;
    },
    contains$1: function(_, element) {
      return this._map.containsKey$1(element);
    }
  };
  H.LinkedHashMapKeyIterator.prototype = {
    get$current: function(_) {
      return this.__js_helper$_current;
    },
    moveNext$0: function() {
      var _this = this,
        t1 = _this._map;
      if (_this._modifications !== t1._modifications)
        throw H.wrapException(P.ConcurrentModificationError$(t1));
      else {
        t1 = _this._cell;
        if (t1 == null) {
          _this.__js_helper$_current = null;
          return false;
        } else {
          _this.__js_helper$_current = t1.hashMapCellKey;
          _this._cell = t1._next;
          return true;
        }
      }
    }
  };
  H.initHooks_closure.prototype = {
    call$1: function(o) {
      return this.getTag(o);
    },
    $signature: 11
  };
  H.initHooks_closure0.prototype = {
    call$2: function(o, tag) {
      return this.getUnknownTag(o, tag);
    }
  };
  H.initHooks_closure1.prototype = {
    call$1: function(tag) {
      return this.prototypeForTag(tag);
    }
  };
  H.JSSyntaxRegExp.prototype = {
    toString$0: function(_) {
      return "RegExp/" + this.pattern + "/" + this._nativeRegExp.flags;
    },
    get$_nativeGlobalVersion: function() {
      var _this = this,
        t1 = _this._nativeGlobalRegExp;
      if (t1 != null)
        return t1;
      t1 = _this._nativeRegExp;
      return _this._nativeGlobalRegExp = H.JSSyntaxRegExp_makeNative(_this.pattern, t1.multiline, !t1.ignoreCase, t1.unicode, t1.dotAll, true);
    },
    get$_nativeAnchoredVersion: function() {
      var _this = this,
        t1 = _this._nativeAnchoredRegExp;
      if (t1 != null)
        return t1;
      t1 = _this._nativeRegExp;
      return _this._nativeAnchoredRegExp = H.JSSyntaxRegExp_makeNative(_this.pattern + "|()", t1.multiline, !t1.ignoreCase, t1.unicode, t1.dotAll, true);
    },
    firstMatch$1: function(string) {
      var m;
      if (typeof string !== "string")
        H.throwExpression(H.argumentErrorValue(string));
      m = this._nativeRegExp.exec(string);
      if (m == null)
        return;
      return new H._MatchImplementation(m);
    },
    allMatches$2: function(_, string, start) {
      var t1 = string.length;
      if (start > t1)
        throw H.wrapException(P.RangeError$range(start, 0, t1, null, null));
      return new H._AllMatchesIterable(this, string, start);
    },
    allMatches$1: function($receiver, string) {
      return this.allMatches$2($receiver, string, 0);
    },
    _execGlobal$2: function(string, start) {
      var match,
        regexp = this.get$_nativeGlobalVersion();
      regexp.lastIndex = start;
      match = regexp.exec(string);
      if (match == null)
        return;
      return new H._MatchImplementation(match);
    },
    _execAnchored$2: function(string, start) {
      var match,
        regexp = this.get$_nativeAnchoredVersion();
      regexp.lastIndex = start;
      match = regexp.exec(string);
      if (match == null)
        return;
      if (match.pop() != null)
        return;
      return new H._MatchImplementation(match);
    },
    matchAsPrefix$2: function(_, string, start) {
      if (start < 0 || start > string.length)
        throw H.wrapException(P.RangeError$range(start, 0, string.length, null, null));
      return this._execAnchored$2(string, start);
    }
  };
  H._MatchImplementation.prototype = {
    get$start: function(_) {
      return this._match.index;
    },
    get$end: function(_) {
      var t1 = this._match;
      return t1.index + t1[0].length;
    },
    $isMatch: 1,
    $isRegExpMatch: 1
  };
  H._AllMatchesIterable.prototype = {
    get$iterator: function(_) {
      return new H._AllMatchesIterator(this._re, this._string, this.__js_helper$_start);
    },
    $asIterable: function() {
      return [P.RegExpMatch];
    }
  };
  H._AllMatchesIterator.prototype = {
    get$current: function(_) {
      return this.__js_helper$_current;
    },
    moveNext$0: function() {
      var t2, t3, match, nextIndex, _this = this,
        t1 = _this._string;
      if (t1 == null)
        return false;
      t2 = _this._nextIndex;
      if (t2 <= t1.length) {
        t3 = _this._regExp;
        match = t3._execGlobal$2(t1, t2);
        if (match != null) {
          _this.__js_helper$_current = match;
          nextIndex = match.get$end(match);
          if (match._match.index === nextIndex) {
            if (t3._nativeRegExp.unicode) {
              t1 = _this._nextIndex;
              t2 = t1 + 1;
              t3 = _this._string;
              if (t2 < t3.length) {
                t1 = J.getInterceptor$s(t3).codeUnitAt$1(t3, t1);
                if (t1 >= 55296 && t1 <= 56319) {
                  t1 = C.JSString_methods.codeUnitAt$1(t3, t2);
                  t1 = t1 >= 56320 && t1 <= 57343;
                } else
                  t1 = false;
              } else
                t1 = false;
            } else
              t1 = false;
            nextIndex = (t1 ? nextIndex + 1 : nextIndex) + 1;
          }
          _this._nextIndex = nextIndex;
          return true;
        }
      }
      _this._string = _this.__js_helper$_current = null;
      return false;
    }
  };
  H.StringMatch.prototype = {
    get$end: function(_) {
      return this.start + this.pattern.length;
    },
    group$1: function(group_) {
      if (group_ !== 0)
        throw H.wrapException(P.RangeError$value(group_, null, null));
      return this.pattern;
    },
    $isMatch: 1,
    get$start: function(receiver) {
      return this.start;
    }
  };
  H._StringAllMatchesIterable.prototype = {
    get$iterator: function(_) {
      return new H._StringAllMatchesIterator(this._input, this._pattern, this.__js_helper$_index);
    },
    get$first: function(_) {
      var t1 = this._pattern,
        index = this._input.indexOf(t1, this.__js_helper$_index);
      if (index >= 0)
        return new H.StringMatch(index, t1);
      throw H.wrapException(H.IterableElementError_noElement());
    },
    $asIterable: function() {
      return [P.Match];
    }
  };
  H._StringAllMatchesIterator.prototype = {
    moveNext$0: function() {
      var index, end, _this = this,
        t1 = _this.__js_helper$_index,
        t2 = _this._pattern,
        t3 = t2.length,
        t4 = _this._input,
        t5 = t4.length;
      if (t1 + t3 > t5) {
        _this.__js_helper$_current = null;
        return false;
      }
      index = t4.indexOf(t2, t1);
      if (index < 0) {
        _this.__js_helper$_index = t5 + 1;
        _this.__js_helper$_current = null;
        return false;
      }
      end = index + t3;
      _this.__js_helper$_current = new H.StringMatch(index, t2);
      _this.__js_helper$_index = end === _this.__js_helper$_index ? end + 1 : end;
      return true;
    },
    get$current: function(_) {
      return this.__js_helper$_current;
    }
  };
  H.NativeTypedData.prototype = {
    _invalidPosition$3: function(receiver, position, $length, $name) {
      if (typeof position !== "number" || Math.floor(position) !== position)
        throw H.wrapException(P.ArgumentError$value(position, $name, "Invalid list position"));
      else
        throw H.wrapException(P.RangeError$range(position, 0, $length, $name, null));
    },
    _checkPosition$3: function(receiver, position, $length, $name) {
      if (position >>> 0 !== position || position > $length)
        this._invalidPosition$3(receiver, position, $length, $name);
    }
  };
  H.NativeTypedArray.prototype = {
    get$length: function(receiver) {
      return receiver.length;
    },
    _setRangeFast$4: function(receiver, start, end, source, skipCount) {
      var count, sourceLength,
        targetLength = receiver.length;
      this._checkPosition$3(receiver, start, targetLength, "start");
      this._checkPosition$3(receiver, end, targetLength, "end");
      if (start > end)
        throw H.wrapException(P.RangeError$range(start, 0, end, null, null));
      count = end - start;
      if (skipCount < 0)
        throw H.wrapException(P.ArgumentError$(skipCount));
      sourceLength = source.length;
      if (sourceLength - skipCount < count)
        throw H.wrapException(P.StateError$("Not enough elements"));
      if (skipCount !== 0 || sourceLength !== count)
        source = source.subarray(skipCount, skipCount + count);
      receiver.set(source, start);
    },
    $isJavaScriptIndexingBehavior: 1,
    $asJavaScriptIndexingBehavior: function() {
    }
  };
  H.NativeTypedArrayOfDouble.prototype = {
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    $indexSet: function(receiver, index, value) {
      H._checkValidIndex(index, receiver, receiver.length);
      receiver[index] = value;
    },
    setRange$4: function(receiver, start, end, iterable, skipCount) {
      if (!!J.getInterceptor$(iterable).$isNativeTypedArrayOfDouble) {
        this._setRangeFast$4(receiver, start, end, iterable, skipCount);
        return;
      }
      this.super$ListMixin$setRange(receiver, start, end, iterable, skipCount);
    },
    $isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function() {
      return [P.double];
    },
    $asListMixin: function() {
      return [P.double];
    },
    $isIterable: 1,
    $asIterable: function() {
      return [P.double];
    },
    $isList: 1,
    $asList: function() {
      return [P.double];
    }
  };
  H.NativeTypedArrayOfInt.prototype = {
    $indexSet: function(receiver, index, value) {
      H._checkValidIndex(index, receiver, receiver.length);
      receiver[index] = value;
    },
    setRange$4: function(receiver, start, end, iterable, skipCount) {
      if (!!J.getInterceptor$(iterable).$isNativeTypedArrayOfInt) {
        this._setRangeFast$4(receiver, start, end, iterable, skipCount);
        return;
      }
      this.super$ListMixin$setRange(receiver, start, end, iterable, skipCount);
    },
    $isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function() {
      return [P.int];
    },
    $asListMixin: function() {
      return [P.int];
    },
    $isIterable: 1,
    $asIterable: function() {
      return [P.int];
    },
    $isList: 1,
    $asList: function() {
      return [P.int];
    }
  };
  H.NativeFloat32List.prototype = {
    sublist$2: function(receiver, start, end) {
      return new Float32Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeFloat64List.prototype = {
    sublist$2: function(receiver, start, end) {
      return new Float64Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeInt16List.prototype = {
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Int16Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeInt32List.prototype = {
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Int32Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeInt8List.prototype = {
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Int8Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeUint16List.prototype = {
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Uint16Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeUint32List.prototype = {
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Uint32Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeUint8ClampedList.prototype = {
    get$length: function(receiver) {
      return receiver.length;
    },
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Uint8ClampedArray(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    }
  };
  H.NativeUint8List.prototype = {
    get$length: function(receiver) {
      return receiver.length;
    },
    $index: function(receiver, index) {
      H._checkValidIndex(index, receiver, receiver.length);
      return receiver[index];
    },
    sublist$2: function(receiver, start, end) {
      return new Uint8Array(receiver.subarray(start, H._checkValidRange(start, end, receiver.length)));
    },
    $isNativeUint8List: 1,
    $isUint8List: 1
  };
  H._NativeTypedArrayOfDouble_NativeTypedArray_ListMixin.prototype = {};
  H._NativeTypedArrayOfDouble_NativeTypedArray_ListMixin_FixedLengthListMixin.prototype = {};
  H._NativeTypedArrayOfInt_NativeTypedArray_ListMixin.prototype = {};
  H._NativeTypedArrayOfInt_NativeTypedArray_ListMixin_FixedLengthListMixin.prototype = {};
  P._AsyncRun__initializeScheduleImmediate_internalCallback.prototype = {
    call$1: function(_) {
      var t1 = this._box_0,
        f = t1.storedCallback;
      t1.storedCallback = null;
      f.call$0();
    },
    $signature: 20
  };
  P._AsyncRun__initializeScheduleImmediate_closure.prototype = {
    call$1: function(callback) {
      var t1, t2;
      this._box_0.storedCallback = callback;
      t1 = this.div;
      t2 = this.span;
      t1.firstChild ? t1.removeChild(t2) : t1.appendChild(t2);
    }
  };
  P._AsyncRun__scheduleImmediateJsOverride_internalCallback.prototype = {
    call$0: function() {
      this.callback.call$0();
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._AsyncRun__scheduleImmediateWithSetImmediate_internalCallback.prototype = {
    call$0: function() {
      this.callback.call$0();
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._TimerImpl.prototype = {
    _TimerImpl$2: function(milliseconds, callback) {
      if (self.setTimeout != null)
        this._handle = self.setTimeout(H.convertDartClosureToJS(new P._TimerImpl_internalCallback(this, callback), 0), milliseconds);
      else
        throw H.wrapException(P.UnsupportedError$("`setTimeout()` not found."));
    },
    _TimerImpl$periodic$2: function(milliseconds, callback) {
      if (self.setTimeout != null)
        this._handle = self.setInterval(H.convertDartClosureToJS(new P._TimerImpl$periodic_closure(this, milliseconds, Date.now(), callback), 0), milliseconds);
      else
        throw H.wrapException(P.UnsupportedError$("Periodic timer."));
    },
    cancel$0: function() {
      if (self.setTimeout != null) {
        var t1 = this._handle;
        if (t1 == null)
          return;
        if (this._once)
          self.clearTimeout(t1);
        else
          self.clearInterval(t1);
        this._handle = null;
      } else
        throw H.wrapException(P.UnsupportedError$("Canceling a timer."));
    }
  };
  P._TimerImpl_internalCallback.prototype = {
    call$0: function() {
      var t1 = this.$this;
      t1._handle = null;
      t1._tick = 1;
      this.callback.call$0();
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._TimerImpl$periodic_closure.prototype = {
    call$0: function() {
      var duration, _this = this,
        t1 = _this.$this,
        tick = t1._tick + 1,
        t2 = _this.milliseconds;
      if (t2 > 0) {
        duration = Date.now() - _this.start;
        if (duration > (tick + 1) * t2)
          tick = C.JSInt_methods.$tdiv(duration, t2);
      }
      t1._tick = tick;
      _this.callback.call$1(t1);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._AsyncAwaitCompleter.prototype = {
    complete$1: function(value) {
      var t1 = !this.isSync || H.checkSubtype(value, "$isFuture", this.$ti, "$asFuture"),
        t2 = this._future;
      if (t1)
        t2._asyncComplete$1(value);
      else
        t2._completeWithValue$1(value);
    },
    completeError$2: function(e, st) {
      var t1 = this._future;
      if (this.isSync)
        t1._completeError$2(e, st);
      else
        t1._asyncCompleteError$2(e, st);
    }
  };
  P._awaitOnObject_closure.prototype = {
    call$1: function(result) {
      return this.bodyFunction.call$2(0, result);
    },
    $signature: 54
  };
  P._awaitOnObject_closure0.prototype = {
    call$2: function(error, stackTrace) {
      this.bodyFunction.call$2(1, new H.ExceptionAndStackTrace(error, stackTrace));
    },
    "call*": "call$2",
    $requiredArgCount: 2,
    $signature: 15
  };
  P._wrapJsFunctionForAsync_closure.prototype = {
    call$2: function(errorCode, result) {
      this.$protected(errorCode, result);
    },
    "call*": "call$2",
    $requiredArgCount: 2
  };
  P._asyncStarHelper_closure.prototype = {
    call$0: function() {
      var t1 = this.controller,
        t2 = t1.controller,
        t3 = t2._async$_state;
      if ((t3 & 1) !== 0 ? (t2.get$_subscription()._async$_state & 4) !== 0 : (t3 & 2) === 0) {
        t1.isSuspended = true;
        return;
      }
      this.bodyFunctionOrErrorCode.call$2(null, 0);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._asyncStarHelper_closure0.prototype = {
    call$1: function(_) {
      var errorCode = this.controller.cancelationFuture != null ? 2 : 0;
      this.bodyFunctionOrErrorCode.call$2(errorCode, null);
    },
    $signature: 20
  };
  P._AsyncStarStreamController.prototype = {
    add$1: function(_, $event) {
      return this.controller.add$1(0, $event);
    },
    _AsyncStarStreamController$1: function(body, $T) {
      var t1 = new P._AsyncStarStreamController__resumeBody(body);
      this.controller = P.StreamController_StreamController(new P._AsyncStarStreamController_closure(this, body), new P._AsyncStarStreamController_closure0(t1), null, new P._AsyncStarStreamController_closure1(this, t1), false, $T);
    }
  };
  P._AsyncStarStreamController__resumeBody.prototype = {
    call$0: function() {
      P.scheduleMicrotask(new P._AsyncStarStreamController__resumeBody_closure(this.body));
    }
  };
  P._AsyncStarStreamController__resumeBody_closure.prototype = {
    call$0: function() {
      this.body.call$2(0, null);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._AsyncStarStreamController_closure0.prototype = {
    call$0: function() {
      this._resumeBody.call$0();
    }
  };
  P._AsyncStarStreamController_closure1.prototype = {
    call$0: function() {
      var t1 = this.$this;
      if (t1.isSuspended) {
        t1.isSuspended = false;
        this._resumeBody.call$0();
      }
    }
  };
  P._AsyncStarStreamController_closure.prototype = {
    call$0: function() {
      var t1 = this.$this;
      if ((t1.controller._async$_state & 4) === 0) {
        t1.cancelationFuture = new P._Future($.Zone__current, [null]);
        if (t1.isSuspended) {
          t1.isSuspended = false;
          P.scheduleMicrotask(new P._AsyncStarStreamController__closure(this.body));
        }
        return t1.cancelationFuture;
      }
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._AsyncStarStreamController__closure.prototype = {
    call$0: function() {
      this.body.call$2(2, null);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._IterationMarker.prototype = {
    toString$0: function(_) {
      return "IterationMarker(" + this.state + ", " + H.S(this.value) + ")";
    }
  };
  P._SyncStarIterator.prototype = {
    get$current: function(_) {
      var t1 = this._nestedIterator;
      if (t1 == null)
        return this._async$_current;
      return t1.get$current(t1);
    },
    moveNext$0: function() {
      var t1, value, state, inner, _this = this;
      for (; true;) {
        t1 = _this._nestedIterator;
        if (t1 != null)
          if (t1.moveNext$0())
            return true;
          else
            _this._nestedIterator = null;
        value = function(body, SUCCESS, ERROR) {
          var errorValue,
            errorCode = SUCCESS;
          while (true)
            try {
              return body(errorCode, errorValue);
            } catch (error) {
              errorValue = error;
              errorCode = ERROR;
            }
        }(_this._body, 0, 1);
        if (value instanceof P._IterationMarker) {
          state = value.state;
          if (state === 2) {
            t1 = _this._suspendedBodies;
            if (t1 == null || t1.length === 0) {
              _this._async$_current = null;
              return false;
            }
            _this._body = t1.pop();
            continue;
          } else {
            t1 = value.value;
            if (state === 3)
              throw t1;
            else {
              inner = J.get$iterator$ax(t1);
              if (!!inner.$is_SyncStarIterator) {
                t1 = _this._suspendedBodies;
                if (t1 == null)
                  t1 = _this._suspendedBodies = [];
                t1.push(_this._body);
                _this._body = inner._body;
                continue;
              } else {
                _this._nestedIterator = inner;
                continue;
              }
            }
          }
        } else {
          _this._async$_current = value;
          return true;
        }
      }
      return false;
    }
  };
  P._SyncStarIterable.prototype = {
    get$iterator: function(_) {
      return new P._SyncStarIterator(this._outerHelper());
    }
  };
  P._BroadcastStream.prototype = {
    get$isBroadcast: function() {
      return true;
    }
  };
  P._BroadcastSubscription.prototype = {
    _async$_onPause$0: function() {
    },
    _async$_onResume$0: function() {
    }
  };
  P._BroadcastStreamController.prototype = {
    set$onPause: function(onPauseHandler) {
      throw H.wrapException(P.UnsupportedError$("Broadcast stream controllers do not support pause callbacks"));
    },
    set$onResume: function(onResumeHandler) {
      throw H.wrapException(P.UnsupportedError$("Broadcast stream controllers do not support pause callbacks"));
    },
    get$stream: function() {
      return new P._BroadcastStream(this, this.$ti);
    },
    get$_mayAddEvent: function() {
      return this._async$_state < 4;
    },
    _ensureDoneFuture$0: function() {
      var t1 = this._doneFuture;
      if (t1 != null)
        return t1;
      return this._doneFuture = new P._Future($.Zone__current, [null]);
    },
    _removeListener$1: function(subscription) {
      var previous = subscription._async$_previous,
        next = subscription._async$_next;
      if (previous == null)
        this._firstSubscription = next;
      else
        previous._async$_next = next;
      if (next == null)
        this._lastSubscription = previous;
      else
        next._async$_previous = previous;
      subscription._async$_previous = subscription;
      subscription._async$_next = subscription;
    },
    _subscribe$4: function(onData, onError, onDone, cancelOnError) {
      var t1, t2, subscription, oldLast, _this = this;
      if ((_this._async$_state & 4) !== 0) {
        if (onDone == null)
          onDone = P.async___nullDoneHandler$closure();
        t1 = new P._DoneStreamSubscription($.Zone__current, onDone, _this.$ti);
        t1._schedule$0();
        return t1;
      }
      t1 = $.Zone__current;
      t2 = cancelOnError ? 1 : 0;
      subscription = new P._BroadcastSubscription(_this, t1, t2, _this.$ti);
      subscription._BufferingStreamSubscription$4(onData, onError, onDone, cancelOnError, H.getTypeArgumentByIndex(_this, 0));
      subscription._async$_previous = subscription;
      subscription._async$_next = subscription;
      subscription._eventState = _this._async$_state & 1;
      oldLast = _this._lastSubscription;
      _this._lastSubscription = subscription;
      subscription._async$_next = null;
      subscription._async$_previous = oldLast;
      if (oldLast == null)
        _this._firstSubscription = subscription;
      else
        oldLast._async$_next = subscription;
      if (_this._firstSubscription === subscription)
        P._runGuarded(_this.onListen);
      return subscription;
    },
    _recordCancel$1: function(sub) {
      var t1, _this = this;
      if (sub._async$_next === sub)
        return;
      t1 = sub._eventState;
      if ((t1 & 2) !== 0)
        sub._eventState = t1 | 4;
      else {
        _this._removeListener$1(sub);
        if ((_this._async$_state & 2) === 0 && _this._firstSubscription == null)
          _this._callOnCancel$0();
      }
      return;
    },
    _recordPause$1: function(subscription) {
    },
    _recordResume$1: function(subscription) {
    },
    _addEventError$0: function() {
      if ((this._async$_state & 4) !== 0)
        return new P.StateError("Cannot add new events after calling close");
      return new P.StateError("Cannot add new events while doing an addStream");
    },
    add$1: function(_, data) {
      if (!this.get$_mayAddEvent())
        throw H.wrapException(this._addEventError$0());
      this._sendData$1(data);
    },
    addError$2: function(error, stackTrace) {
      var replacement;
      if (error == null)
        error = new P.NullThrownError();
      if (!this.get$_mayAddEvent())
        throw H.wrapException(this._addEventError$0());
      replacement = $.Zone__current.errorCallback$2(error, stackTrace);
      if (replacement != null) {
        error = replacement.error;
        if (error == null)
          error = new P.NullThrownError();
        stackTrace = replacement.stackTrace;
      }
      this._sendError$2(error, stackTrace);
    },
    close$0: function(_) {
      var doneFuture, _this = this;
      if ((_this._async$_state & 4) !== 0)
        return _this._doneFuture;
      if (!_this.get$_mayAddEvent())
        throw H.wrapException(_this._addEventError$0());
      _this._async$_state |= 4;
      doneFuture = _this._ensureDoneFuture$0();
      _this._sendDone$0();
      return doneFuture;
    },
    _forEachListener$1: function(action) {
      var subscription, id, next, _this = this,
        t1 = _this._async$_state;
      if ((t1 & 2) !== 0)
        throw H.wrapException(P.StateError$("Cannot fire new event. Controller is already firing an event"));
      subscription = _this._firstSubscription;
      if (subscription == null)
        return;
      id = t1 & 1;
      _this._async$_state = t1 ^ 3;
      for (; subscription != null;) {
        t1 = subscription._eventState;
        if ((t1 & 1) === id) {
          subscription._eventState = t1 | 2;
          action.call$1(subscription);
          t1 = subscription._eventState ^= 1;
          next = subscription._async$_next;
          if ((t1 & 4) !== 0)
            _this._removeListener$1(subscription);
          subscription._eventState &= 4294967293;
          subscription = next;
        } else
          subscription = subscription._async$_next;
      }
      _this._async$_state &= 4294967293;
      if (_this._firstSubscription == null)
        _this._callOnCancel$0();
    },
    _callOnCancel$0: function() {
      var _this = this;
      if ((_this._async$_state & 4) !== 0 && _this._doneFuture._async$_state === 0)
        _this._doneFuture._asyncComplete$1(null);
      P._runGuarded(_this.onCancel);
    },
    $isEventSink: 1,
    set$onListen: function(val) {
      return this.onListen = val;
    },
    set$onCancel: function(val) {
      return this.onCancel = val;
    }
  };
  P._SyncBroadcastStreamController.prototype = {
    get$_mayAddEvent: function() {
      return P._BroadcastStreamController.prototype.get$_mayAddEvent.call(this) && (this._async$_state & 2) === 0;
    },
    _addEventError$0: function() {
      if ((this._async$_state & 2) !== 0)
        return new P.StateError("Cannot fire new event. Controller is already firing an event");
      return this.super$_BroadcastStreamController$_addEventError();
    },
    _sendData$1: function(data) {
      var _this = this,
        t1 = _this._firstSubscription;
      if (t1 == null)
        return;
      if (t1 === _this._lastSubscription) {
        _this._async$_state |= 2;
        t1._async$_add$1(data);
        _this._async$_state &= 4294967293;
        if (_this._firstSubscription == null)
          _this._callOnCancel$0();
        return;
      }
      _this._forEachListener$1(new P._SyncBroadcastStreamController__sendData_closure(data));
    },
    _sendError$2: function(error, stackTrace) {
      if (this._firstSubscription == null)
        return;
      this._forEachListener$1(new P._SyncBroadcastStreamController__sendError_closure(error, stackTrace));
    },
    _sendDone$0: function() {
      if (this._firstSubscription != null)
        this._forEachListener$1(new P._SyncBroadcastStreamController__sendDone_closure());
      else
        this._doneFuture._asyncComplete$1(null);
    }
  };
  P._SyncBroadcastStreamController__sendData_closure.prototype = {
    call$1: function(subscription) {
      subscription._async$_add$1(this.data);
    }
  };
  P._SyncBroadcastStreamController__sendError_closure.prototype = {
    call$1: function(subscription) {
      subscription._addError$2(this.error, this.stackTrace);
    }
  };
  P._SyncBroadcastStreamController__sendDone_closure.prototype = {
    call$1: function(subscription) {
      subscription._close$0();
    }
  };
  P.Future.prototype = {};
  P.Future_wait_handleError.prototype = {
    call$2: function(theError, theStackTrace) {
      var _this = this,
        t1 = _this._box_0,
        t2 = --t1.remaining;
      if (t1.values != null) {
        t1.values = null;
        if (t1.remaining === 0 || _this.eagerError)
          _this.result._completeError$2(theError, theStackTrace);
        else {
          t1.error = theError;
          t1.stackTrace = theStackTrace;
        }
      } else if (t2 === 0 && !_this.eagerError)
        _this.result._completeError$2(t1.error, t1.stackTrace);
    },
    "call*": "call$2",
    $requiredArgCount: 2,
    $signature: 15
  };
  P.Future_wait_closure.prototype = {
    call$1: function(value) {
      var _this = this,
        t1 = _this._box_0,
        t2 = --t1.remaining,
        t3 = t1.values;
      if (t3 != null) {
        t3[_this.pos] = value;
        if (t2 === 0)
          _this.result._completeWithValue$1(t3);
      } else if (t1.remaining === 0 && !_this.eagerError)
        _this.result._completeError$2(t1.error, t1.stackTrace);
    },
    $signature: function() {
      return {func: 1, ret: P.Null, args: [this.T]};
    }
  };
  P._Completer.prototype = {
    completeError$2: function(error, stackTrace) {
      var t1, replacement;
      if (error == null)
        error = new P.NullThrownError();
      t1 = this.future;
      if (t1._async$_state !== 0)
        throw H.wrapException(P.StateError$("Future already completed"));
      replacement = $.Zone__current.errorCallback$2(error, stackTrace);
      if (replacement != null) {
        error = replacement.error;
        if (error == null)
          error = new P.NullThrownError();
        stackTrace = replacement.stackTrace;
      }
      t1._asyncCompleteError$2(error, stackTrace);
    },
    completeError$1: function(error) {
      return this.completeError$2(error, null);
    }
  };
  P._AsyncCompleter.prototype = {
    complete$1: function(value) {
      var t1 = this.future;
      if (t1._async$_state !== 0)
        throw H.wrapException(P.StateError$("Future already completed"));
      t1._asyncComplete$1(value);
    },
    complete$0: function() {
      return this.complete$1(null);
    }
  };
  P._FutureListener.prototype = {
    matchesErrorTest$1: function(asyncError) {
      if ((this.state & 15) !== 6)
        return true;
      return this.result._zone.runUnary$2(this.callback, asyncError.error);
    },
    handleError$1: function(asyncError) {
      var errorCallback = this.errorCallback,
        t1 = this.result._zone;
      if (H.functionTypeTest(errorCallback, {func: 1, args: [P.Object, P.StackTrace]}))
        return t1.runBinary$3(errorCallback, asyncError.error, asyncError.stackTrace);
      else
        return t1.runUnary$2(errorCallback, asyncError.error);
    }
  };
  P._Future.prototype = {
    then$1$2$onError: function(f, onError, $R) {
      var result,
        currentZone = $.Zone__current;
      if (currentZone !== C.C__RootZone) {
        f = currentZone.registerUnaryCallback$1(f);
        if (onError != null)
          onError = P._registerErrorHandler(onError, currentZone);
      }
      result = new P._Future($.Zone__current, [$R]);
      this._addListener$1(new P._FutureListener(result, onError == null ? 1 : 3, f, onError));
      return result;
    },
    then$1$1: function(f, $R) {
      return this.then$1$2$onError(f, null, $R);
    },
    then$1: function(f) {
      return this.then$1$2$onError(f, null, null);
    },
    _thenAwait$1$2: function(f, onError, $E) {
      var result = new P._Future($.Zone__current, [$E]);
      this._addListener$1(new P._FutureListener(result, (onError == null ? 1 : 3) | 16, f, onError));
      return result;
    },
    whenComplete$1: function(action) {
      var t1 = $.Zone__current,
        result = new P._Future(t1, this.$ti);
      this._addListener$1(new P._FutureListener(result, 8, t1 !== C.C__RootZone ? t1.registerCallback$1(action) : action, null));
      return result;
    },
    _addListener$1: function(listener) {
      var t2, _this = this,
        t1 = _this._async$_state;
      if (t1 <= 1) {
        listener._nextListener = _this._resultOrListeners;
        _this._resultOrListeners = listener;
      } else {
        if (t1 === 2) {
          t1 = _this._resultOrListeners;
          t2 = t1._async$_state;
          if (t2 < 4) {
            t1._addListener$1(listener);
            return;
          }
          _this._async$_state = t2;
          _this._resultOrListeners = t1._resultOrListeners;
        }
        _this._zone.scheduleMicrotask$1(new P._Future__addListener_closure(_this, listener));
      }
    },
    _prependListeners$1: function(listeners) {
      var t1, existingListeners, cursor, cursor0, t2, _this = this, _box_0 = {};
      _box_0.listeners = listeners;
      if (listeners == null)
        return;
      t1 = _this._async$_state;
      if (t1 <= 1) {
        existingListeners = _this._resultOrListeners;
        cursor = _this._resultOrListeners = listeners;
        if (existingListeners != null) {
          for (; cursor0 = cursor._nextListener, cursor0 != null; cursor = cursor0)
            ;
          cursor._nextListener = existingListeners;
        }
      } else {
        if (t1 === 2) {
          t1 = _this._resultOrListeners;
          t2 = t1._async$_state;
          if (t2 < 4) {
            t1._prependListeners$1(listeners);
            return;
          }
          _this._async$_state = t2;
          _this._resultOrListeners = t1._resultOrListeners;
        }
        _box_0.listeners = _this._reverseListeners$1(listeners);
        _this._zone.scheduleMicrotask$1(new P._Future__prependListeners_closure(_box_0, _this));
      }
    },
    _removeListeners$0: function() {
      var current = this._resultOrListeners;
      this._resultOrListeners = null;
      return this._reverseListeners$1(current);
    },
    _reverseListeners$1: function(listeners) {
      var current, prev, next;
      for (current = listeners, prev = null; current != null; prev = current, current = next) {
        next = current._nextListener;
        current._nextListener = prev;
      }
      return prev;
    },
    _complete$1: function(value) {
      var listeners, _this = this,
        t1 = _this.$ti;
      if (H.checkSubtype(value, "$isFuture", t1, "$asFuture"))
        if (H.checkSubtype(value, "$is_Future", t1, null))
          P._Future__chainCoreFuture(value, _this);
        else
          P._Future__chainForeignFuture(value, _this);
      else {
        listeners = _this._removeListeners$0();
        _this._async$_state = 4;
        _this._resultOrListeners = value;
        P._Future__propagateToListeners(_this, listeners);
      }
    },
    _completeWithValue$1: function(value) {
      var _this = this,
        listeners = _this._removeListeners$0();
      _this._async$_state = 4;
      _this._resultOrListeners = value;
      P._Future__propagateToListeners(_this, listeners);
    },
    _completeError$2: function(error, stackTrace) {
      var _this = this,
        listeners = _this._removeListeners$0();
      _this._async$_state = 8;
      _this._resultOrListeners = new P.AsyncError(error, stackTrace);
      P._Future__propagateToListeners(_this, listeners);
    },
    _completeError$1: function(error) {
      return this._completeError$2(error, null);
    },
    _asyncComplete$1: function(value) {
      var _this = this;
      if (H.checkSubtype(value, "$isFuture", _this.$ti, "$asFuture")) {
        _this._chainFuture$1(value);
        return;
      }
      _this._async$_state = 1;
      _this._zone.scheduleMicrotask$1(new P._Future__asyncComplete_closure(_this, value));
    },
    _chainFuture$1: function(value) {
      var _this = this;
      if (H.checkSubtype(value, "$is_Future", _this.$ti, null)) {
        if (value._async$_state === 8) {
          _this._async$_state = 1;
          _this._zone.scheduleMicrotask$1(new P._Future__chainFuture_closure(_this, value));
        } else
          P._Future__chainCoreFuture(value, _this);
        return;
      }
      P._Future__chainForeignFuture(value, _this);
    },
    _asyncCompleteError$2: function(error, stackTrace) {
      this._async$_state = 1;
      this._zone.scheduleMicrotask$1(new P._Future__asyncCompleteError_closure(this, error, stackTrace));
    },
    $isFuture: 1
  };
  P._Future__addListener_closure.prototype = {
    call$0: function() {
      P._Future__propagateToListeners(this.$this, this.listener);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._Future__prependListeners_closure.prototype = {
    call$0: function() {
      P._Future__propagateToListeners(this.$this, this._box_0.listeners);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._Future__chainForeignFuture_closure.prototype = {
    call$1: function(value) {
      var t1 = this.target;
      t1._async$_state = 0;
      t1._complete$1(value);
    },
    $signature: 20
  };
  P._Future__chainForeignFuture_closure0.prototype = {
    call$2: function(error, stackTrace) {
      this.target._completeError$2(error, stackTrace);
    },
    call$1: function(error) {
      return this.call$2(error, null);
    },
    "call*": "call$2",
    $defaultValues: function() {
      return [null];
    },
    $signature: 57
  };
  P._Future__chainForeignFuture_closure1.prototype = {
    call$0: function() {
      this.target._completeError$2(this.e, this.s);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._Future__asyncComplete_closure.prototype = {
    call$0: function() {
      this.$this._completeWithValue$1(this.value);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._Future__chainFuture_closure.prototype = {
    call$0: function() {
      P._Future__chainCoreFuture(this.value, this.$this);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._Future__asyncCompleteError_closure.prototype = {
    call$0: function() {
      this.$this._completeError$2(this.error, this.stackTrace);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._Future__propagateToListeners_handleWhenCompleteCallback.prototype = {
    call$0: function() {
      var e, s, t1, exception, t2, originalSource, _this = this, completeResult = null;
      try {
        t1 = _this.listener;
        completeResult = t1.result._zone.run$1(0, t1.callback);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        if (_this.hasError) {
          t1 = _this._box_1.source._resultOrListeners.error;
          t2 = e;
          t2 = t1 == null ? t2 == null : t1 === t2;
          t1 = t2;
        } else
          t1 = false;
        t2 = _this._box_0;
        if (t1)
          t2.listenerValueOrError = _this._box_1.source._resultOrListeners;
        else
          t2.listenerValueOrError = new P.AsyncError(e, s);
        t2.listenerHasError = true;
        return;
      }
      if (!!J.getInterceptor$(completeResult).$isFuture) {
        if (completeResult instanceof P._Future && completeResult._async$_state >= 4) {
          if (completeResult._async$_state === 8) {
            t1 = _this._box_0;
            t1.listenerValueOrError = completeResult._resultOrListeners;
            t1.listenerHasError = true;
          }
          return;
        }
        originalSource = _this._box_1.source;
        t1 = _this._box_0;
        t1.listenerValueOrError = completeResult.then$1$1(new P._Future__propagateToListeners_handleWhenCompleteCallback_closure(originalSource), null);
        t1.listenerHasError = false;
      }
    }
  };
  P._Future__propagateToListeners_handleWhenCompleteCallback_closure.prototype = {
    call$1: function(_) {
      return this.originalSource;
    },
    $signature: 61
  };
  P._Future__propagateToListeners_handleValueCallback.prototype = {
    call$0: function() {
      var e, s, t1, exception, _this = this;
      try {
        t1 = _this.listener;
        _this._box_0.listenerValueOrError = t1.result._zone.runUnary$2(t1.callback, _this.sourceResult);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        t1 = _this._box_0;
        t1.listenerValueOrError = new P.AsyncError(e, s);
        t1.listenerHasError = true;
      }
    }
  };
  P._Future__propagateToListeners_handleError.prototype = {
    call$0: function() {
      var asyncError, e, s, t1, t2, exception, t3, t4, _this = this;
      try {
        asyncError = _this._box_1.source._resultOrListeners;
        t1 = _this.listener;
        if (t1.matchesErrorTest$1(asyncError) && t1.errorCallback != null) {
          t2 = _this._box_0;
          t2.listenerValueOrError = t1.handleError$1(asyncError);
          t2.listenerHasError = false;
        }
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        t1 = _this._box_1.source._resultOrListeners;
        t2 = t1.error;
        t3 = e;
        t4 = _this._box_0;
        if (t2 == null ? t3 == null : t2 === t3)
          t4.listenerValueOrError = t1;
        else
          t4.listenerValueOrError = new P.AsyncError(e, s);
        t4.listenerHasError = true;
      }
    }
  };
  P._AsyncCallbackEntry.prototype = {};
  P.Stream.prototype = {
    get$isBroadcast: function() {
      return false;
    },
    get$length: function(_) {
      var t1 = {},
        future = new P._Future($.Zone__current, [P.int]);
      t1.count = 0;
      this.listen$4$cancelOnError$onDone$onError(new P.Stream_length_closure(t1, this), true, new P.Stream_length_closure0(t1, future), future.get$_completeError());
      return future;
    }
  };
  P.Stream_Stream$fromFuture_closure.prototype = {
    call$1: function(value) {
      var t1 = this.controller;
      t1._async$_add$1(value);
      t1._closeUnchecked$0();
    },
    $signature: function() {
      return {func: 1, ret: P.Null, args: [this.T]};
    }
  };
  P.Stream_Stream$fromFuture_closure0.prototype = {
    call$2: function(error, stackTrace) {
      var t1 = this.controller;
      t1._addError$2(error, stackTrace);
      t1._closeUnchecked$0();
    },
    "call*": "call$2",
    $requiredArgCount: 2,
    $signature: 12
  };
  P.Stream_length_closure.prototype = {
    call$1: function(_) {
      ++this._box_0.count;
    },
    $signature: function() {
      return {func: 1, ret: P.Null, args: [H.getRuntimeTypeArgument(this.$this, "Stream", 0)]};
    }
  };
  P.Stream_length_closure0.prototype = {
    call$0: function() {
      this.future._complete$1(this._box_0.count);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P.StreamSubscription.prototype = {};
  P.EventSink.prototype = {};
  P.StreamTransformerBase.prototype = {};
  P._StreamController.prototype = {
    get$stream: function() {
      return new P._ControllerStream(this, this.$ti);
    },
    get$_pendingEvents: function() {
      if ((this._async$_state & 8) === 0)
        return this._varData;
      return this._varData.varData;
    },
    _ensurePendingEvents$0: function() {
      var t1, state, _this = this;
      if ((_this._async$_state & 8) === 0) {
        t1 = _this._varData;
        return t1 == null ? _this._varData = new P._StreamImplEvents() : t1;
      }
      state = _this._varData;
      t1 = state.varData;
      return t1 == null ? state.varData = new P._StreamImplEvents() : t1;
    },
    get$_subscription: function() {
      if ((this._async$_state & 8) !== 0)
        return this._varData.varData;
      return this._varData;
    },
    _badEventState$0: function() {
      if ((this._async$_state & 4) !== 0)
        return new P.StateError("Cannot add event after closing");
      return new P.StateError("Cannot add event while adding a stream");
    },
    addStream$2$cancelOnError: function(source, cancelOnError) {
      var t2, t3, t4, _this = this,
        t1 = _this._async$_state;
      if (t1 >= 4)
        throw H.wrapException(_this._badEventState$0());
      if ((t1 & 2) !== 0) {
        t1 = new P._Future($.Zone__current, [null]);
        t1._asyncComplete$1(null);
        return t1;
      }
      t1 = _this._varData;
      t2 = new P._Future($.Zone__current, [null]);
      t3 = source.listen$4$cancelOnError$onDone$onError(_this.get$_async$_add(), false, _this.get$_close(), _this.get$_addError());
      t4 = _this._async$_state;
      if ((t4 & 1) !== 0 ? (_this.get$_subscription()._async$_state & 4) !== 0 : (t4 & 2) === 0)
        t3.pause$0(0);
      _this._varData = new P._StreamControllerAddStreamState(t1, t2, t3);
      _this._async$_state |= 8;
      return t2;
    },
    _ensureDoneFuture$0: function() {
      var t1 = this._doneFuture;
      if (t1 == null)
        t1 = this._doneFuture = (this._async$_state & 2) !== 0 ? $.$get$Future__nullFuture() : new P._Future($.Zone__current, [null]);
      return t1;
    },
    add$1: function(_, value) {
      if (this._async$_state >= 4)
        throw H.wrapException(this._badEventState$0());
      this._async$_add$1(value);
    },
    addError$2: function(error, stackTrace) {
      var replacement;
      if (this._async$_state >= 4)
        throw H.wrapException(this._badEventState$0());
      if (error == null)
        error = new P.NullThrownError();
      replacement = $.Zone__current.errorCallback$2(error, stackTrace);
      if (replacement != null) {
        error = replacement.error;
        if (error == null)
          error = new P.NullThrownError();
        stackTrace = replacement.stackTrace;
      }
      this._addError$2(error, stackTrace);
    },
    addError$1: function(error) {
      return this.addError$2(error, null);
    },
    close$0: function(_) {
      var _this = this,
        t1 = _this._async$_state;
      if ((t1 & 4) !== 0)
        return _this._ensureDoneFuture$0();
      if (t1 >= 4)
        throw H.wrapException(_this._badEventState$0());
      _this._closeUnchecked$0();
      return _this._ensureDoneFuture$0();
    },
    _closeUnchecked$0: function() {
      var t1 = this._async$_state |= 4;
      if ((t1 & 1) !== 0)
        this._sendDone$0();
      else if ((t1 & 3) === 0)
        this._ensurePendingEvents$0().add$1(0, C.C__DelayedDone);
    },
    _async$_add$1: function(value) {
      var t1 = this._async$_state;
      if ((t1 & 1) !== 0)
        this._sendData$1(value);
      else if ((t1 & 3) === 0)
        this._ensurePendingEvents$0().add$1(0, new P._DelayedData(value));
    },
    _addError$2: function(error, stackTrace) {
      var t1 = this._async$_state;
      if ((t1 & 1) !== 0)
        this._sendError$2(error, stackTrace);
      else if ((t1 & 3) === 0)
        this._ensurePendingEvents$0().add$1(0, new P._DelayedError(error, stackTrace));
    },
    _close$0: function() {
      var addState = this._varData;
      this._varData = addState.varData;
      this._async$_state &= 4294967287;
      addState.addStreamFuture._asyncComplete$1(null);
    },
    _subscribe$4: function(onData, onError, onDone, cancelOnError) {
      var t1, t2, subscription, pendingEvents, addState, _this = this;
      if ((_this._async$_state & 3) !== 0)
        throw H.wrapException(P.StateError$("Stream has already been listened to."));
      t1 = $.Zone__current;
      t2 = cancelOnError ? 1 : 0;
      subscription = new P._ControllerSubscription(_this, t1, t2, _this.$ti);
      subscription._BufferingStreamSubscription$4(onData, onError, onDone, cancelOnError, H.getTypeArgumentByIndex(_this, 0));
      pendingEvents = _this.get$_pendingEvents();
      t2 = _this._async$_state |= 1;
      if ((t2 & 8) !== 0) {
        addState = _this._varData;
        addState.varData = subscription;
        addState.addSubscription.resume$0();
      } else
        _this._varData = subscription;
      subscription._setPendingEvents$1(pendingEvents);
      subscription._guardCallback$1(new P._StreamController__subscribe_closure(_this));
      return subscription;
    },
    _recordCancel$1: function(subscription) {
      var e, s, t1, exception, result0, _this = this, result = null;
      if ((_this._async$_state & 8) !== 0)
        result = _this._varData.cancel$0();
      _this._varData = null;
      _this._async$_state = _this._async$_state & 4294967286 | 2;
      t1 = _this.onCancel;
      if (t1 != null)
        if (result == null)
          try {
            result = t1.call$0();
          } catch (exception) {
            e = H.unwrapException(exception);
            s = H.getTraceFromException(exception);
            result0 = new P._Future($.Zone__current, [null]);
            result0._asyncCompleteError$2(e, s);
            result = result0;
          }
        else
          result = result.whenComplete$1(t1);
      t1 = new P._StreamController__recordCancel_complete(_this);
      if (result != null)
        result = result.whenComplete$1(t1);
      else
        t1.call$0();
      return result;
    },
    _recordPause$1: function(subscription) {
      if ((this._async$_state & 8) !== 0)
        this._varData.addSubscription.pause$0(0);
      P._runGuarded(this.onPause);
    },
    _recordResume$1: function(subscription) {
      if ((this._async$_state & 8) !== 0)
        this._varData.addSubscription.resume$0();
      P._runGuarded(this.onResume);
    },
    $isEventSink: 1,
    set$onListen: function(val) {
      return this.onListen = val;
    },
    set$onPause: function(val) {
      return this.onPause = val;
    },
    set$onResume: function(val) {
      return this.onResume = val;
    },
    set$onCancel: function(val) {
      return this.onCancel = val;
    }
  };
  P._StreamController__subscribe_closure.prototype = {
    call$0: function() {
      P._runGuarded(this.$this.onListen);
    }
  };
  P._StreamController__recordCancel_complete.prototype = {
    call$0: function() {
      var t1 = this.$this._doneFuture;
      if (t1 != null && t1._async$_state === 0)
        t1._asyncComplete$1(null);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._SyncStreamControllerDispatch.prototype = {
    _sendData$1: function(data) {
      this.get$_subscription()._async$_add$1(data);
    },
    _sendError$2: function(error, stackTrace) {
      this.get$_subscription()._addError$2(error, stackTrace);
    },
    _sendDone$0: function() {
      this.get$_subscription()._close$0();
    }
  };
  P._AsyncStreamControllerDispatch.prototype = {
    _sendData$1: function(data) {
      this.get$_subscription()._addPending$1(new P._DelayedData(data));
    },
    _sendError$2: function(error, stackTrace) {
      this.get$_subscription()._addPending$1(new P._DelayedError(error, stackTrace));
    },
    _sendDone$0: function() {
      this.get$_subscription()._addPending$1(C.C__DelayedDone);
    }
  };
  P._AsyncStreamController.prototype = {};
  P._SyncStreamController.prototype = {};
  P._ControllerStream.prototype = {
    get$hashCode: function(_) {
      return (H.Primitives_objectHashCode(this._async$_controller) ^ 892482866) >>> 0;
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      if (this === other)
        return true;
      return other instanceof P._ControllerStream && other._async$_controller === this._async$_controller;
    }
  };
  P._ControllerSubscription.prototype = {
    _async$_onCancel$0: function() {
      return this._async$_controller._recordCancel$1(this);
    },
    _async$_onPause$0: function() {
      this._async$_controller._recordPause$1(this);
    },
    _async$_onResume$0: function() {
      this._async$_controller._recordResume$1(this);
    }
  };
  P._AddStreamState.prototype = {
    cancel$0: function() {
      var cancel = this.addSubscription.cancel$0();
      if (cancel == null) {
        this.addStreamFuture._asyncComplete$1(null);
        return;
      }
      return cancel.whenComplete$1(new P._AddStreamState_cancel_closure(this));
    }
  };
  P._AddStreamState_cancel_closure.prototype = {
    call$0: function() {
      this.$this.addStreamFuture._asyncComplete$1(null);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._StreamControllerAddStreamState.prototype = {};
  P._BufferingStreamSubscription.prototype = {
    _BufferingStreamSubscription$4: function(onData, onError, onDone, cancelOnError, $T) {
      var handleError, _this = this,
        handleData = onData == null ? P.async___nullDataHandler$closure() : onData,
        t1 = _this._zone;
      _this._onData = t1.registerUnaryCallback$1(handleData);
      handleError = onError == null ? P.async___nullErrorHandler$closure() : onError;
      if (H.functionTypeTest(handleError, {func: 1, ret: -1, args: [P.Object, P.StackTrace]}))
        _this._onError = t1.registerBinaryCallback$1(handleError);
      else if (H.functionTypeTest(handleError, {func: 1, ret: -1, args: [P.Object]}))
        _this._onError = t1.registerUnaryCallback$1(handleError);
      else
        H.throwExpression(P.ArgumentError$("handleError callback must take either an Object (the error), or both an Object (the error) and a StackTrace."));
      _this._onDone = t1.registerCallback$1(onDone == null ? P.async___nullDoneHandler$closure() : onDone);
    },
    _setPendingEvents$1: function(pendingEvents) {
      var _this = this;
      if (pendingEvents == null)
        return;
      _this._pending = pendingEvents;
      if (pendingEvents.lastPendingEvent != null) {
        _this._async$_state = (_this._async$_state | 64) >>> 0;
        pendingEvents.schedule$1(_this);
      }
    },
    pause$1: function(_, resumeSignal) {
      var t2, t3, _this = this,
        t1 = _this._async$_state;
      if ((t1 & 8) !== 0)
        return;
      t2 = (t1 + 128 | 4) >>> 0;
      _this._async$_state = t2;
      if (t1 < 128 && _this._pending != null) {
        t3 = _this._pending;
        if (t3._async$_state === 1)
          t3._async$_state = 3;
      }
      if ((t1 & 4) === 0 && (t2 & 32) === 0)
        _this._guardCallback$1(_this.get$_async$_onPause());
    },
    pause$0: function($receiver) {
      return this.pause$1($receiver, null);
    },
    resume$0: function() {
      var _this = this,
        t1 = _this._async$_state;
      if ((t1 & 8) !== 0)
        return;
      if (t1 >= 128) {
        t1 = _this._async$_state = t1 - 128;
        if (t1 < 128)
          if ((t1 & 64) !== 0 && _this._pending.lastPendingEvent != null)
            _this._pending.schedule$1(_this);
          else {
            t1 = (t1 & 4294967291) >>> 0;
            _this._async$_state = t1;
            if ((t1 & 32) === 0)
              _this._guardCallback$1(_this.get$_async$_onResume());
          }
      }
    },
    cancel$0: function() {
      var _this = this,
        t1 = (_this._async$_state & 4294967279) >>> 0;
      _this._async$_state = t1;
      if ((t1 & 8) === 0)
        _this._cancel$0();
      t1 = _this._cancelFuture;
      return t1 == null ? $.$get$Future__nullFuture() : t1;
    },
    _cancel$0: function() {
      var t2, _this = this,
        t1 = _this._async$_state = (_this._async$_state | 8) >>> 0;
      if ((t1 & 64) !== 0) {
        t2 = _this._pending;
        if (t2._async$_state === 1)
          t2._async$_state = 3;
      }
      if ((t1 & 32) === 0)
        _this._pending = null;
      _this._cancelFuture = _this._async$_onCancel$0();
    },
    _async$_add$1: function(data) {
      var t1 = this._async$_state;
      if ((t1 & 8) !== 0)
        return;
      if (t1 < 32)
        this._sendData$1(data);
      else
        this._addPending$1(new P._DelayedData(data));
    },
    _addError$2: function(error, stackTrace) {
      var t1 = this._async$_state;
      if ((t1 & 8) !== 0)
        return;
      if (t1 < 32)
        this._sendError$2(error, stackTrace);
      else
        this._addPending$1(new P._DelayedError(error, stackTrace));
    },
    _close$0: function() {
      var _this = this,
        t1 = _this._async$_state;
      if ((t1 & 8) !== 0)
        return;
      t1 = (t1 | 2) >>> 0;
      _this._async$_state = t1;
      if (t1 < 32)
        _this._sendDone$0();
      else
        _this._addPending$1(C.C__DelayedDone);
    },
    _async$_onPause$0: function() {
    },
    _async$_onResume$0: function() {
    },
    _async$_onCancel$0: function() {
      return;
    },
    _addPending$1: function($event) {
      var t1, _this = this,
        pending = _this._pending;
      (pending == null ? _this._pending = new P._StreamImplEvents() : pending).add$1(0, $event);
      t1 = _this._async$_state;
      if ((t1 & 64) === 0) {
        t1 = (t1 | 64) >>> 0;
        _this._async$_state = t1;
        if (t1 < 128)
          _this._pending.schedule$1(_this);
      }
    },
    _sendData$1: function(data) {
      var _this = this,
        t1 = _this._async$_state;
      _this._async$_state = (t1 | 32) >>> 0;
      _this._zone.runUnaryGuarded$2(_this._onData, data);
      _this._async$_state = (_this._async$_state & 4294967263) >>> 0;
      _this._checkState$1((t1 & 4) !== 0);
    },
    _sendError$2: function(error, stackTrace) {
      var _this = this,
        t1 = _this._async$_state,
        t2 = new P._BufferingStreamSubscription__sendError_sendError(_this, error, stackTrace);
      if ((t1 & 1) !== 0) {
        _this._async$_state = (t1 | 16) >>> 0;
        _this._cancel$0();
        t1 = _this._cancelFuture;
        if (t1 != null && t1 !== $.$get$Future__nullFuture())
          t1.whenComplete$1(t2);
        else
          t2.call$0();
      } else {
        t2.call$0();
        _this._checkState$1((t1 & 4) !== 0);
      }
    },
    _sendDone$0: function() {
      var t2, _this = this,
        t1 = new P._BufferingStreamSubscription__sendDone_sendDone(_this);
      _this._cancel$0();
      _this._async$_state = (_this._async$_state | 16) >>> 0;
      t2 = _this._cancelFuture;
      if (t2 != null && t2 !== $.$get$Future__nullFuture())
        t2.whenComplete$1(t1);
      else
        t1.call$0();
    },
    _guardCallback$1: function(callback) {
      var _this = this,
        t1 = _this._async$_state;
      _this._async$_state = (t1 | 32) >>> 0;
      callback.call$0();
      _this._async$_state = (_this._async$_state & 4294967263) >>> 0;
      _this._checkState$1((t1 & 4) !== 0);
    },
    _checkState$1: function(wasInputPaused) {
      var t2, isInputPaused, _this = this,
        t1 = _this._async$_state;
      if ((t1 & 64) !== 0 && _this._pending.lastPendingEvent == null) {
        t1 = _this._async$_state = (t1 & 4294967231) >>> 0;
        if ((t1 & 4) !== 0)
          if (t1 < 128) {
            t2 = _this._pending;
            t2 = t2 == null || t2.lastPendingEvent == null;
          } else
            t2 = false;
        else
          t2 = false;
        if (t2) {
          t1 = (t1 & 4294967291) >>> 0;
          _this._async$_state = t1;
        }
      }
      for (; true; wasInputPaused = isInputPaused) {
        if ((t1 & 8) !== 0)
          return _this._pending = null;
        isInputPaused = (t1 & 4) !== 0;
        if (wasInputPaused === isInputPaused)
          break;
        _this._async$_state = (t1 ^ 32) >>> 0;
        if (isInputPaused)
          _this._async$_onPause$0();
        else
          _this._async$_onResume$0();
        t1 = (_this._async$_state & 4294967263) >>> 0;
        _this._async$_state = t1;
      }
      if ((t1 & 64) !== 0 && t1 < 128)
        _this._pending.schedule$1(_this);
    },
    $isStreamSubscription: 1
  };
  P._BufferingStreamSubscription__sendError_sendError.prototype = {
    call$0: function() {
      var onError, t3,
        t1 = this.$this,
        t2 = t1._async$_state;
      if ((t2 & 8) !== 0 && (t2 & 16) === 0)
        return;
      t1._async$_state = (t2 | 32) >>> 0;
      onError = t1._onError;
      t2 = this.error;
      t3 = t1._zone;
      if (H.functionTypeTest(onError, {func: 1, ret: -1, args: [P.Object, P.StackTrace]}))
        t3.runBinaryGuarded$3(onError, t2, this.stackTrace);
      else
        t3.runUnaryGuarded$2(t1._onError, t2);
      t1._async$_state = (t1._async$_state & 4294967263) >>> 0;
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._BufferingStreamSubscription__sendDone_sendDone.prototype = {
    call$0: function() {
      var t1 = this.$this,
        t2 = t1._async$_state;
      if ((t2 & 16) === 0)
        return;
      t1._async$_state = (t2 | 42) >>> 0;
      t1._zone.runGuarded$1(t1._onDone);
      t1._async$_state = (t1._async$_state & 4294967263) >>> 0;
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._StreamImpl.prototype = {
    listen$4$cancelOnError$onDone$onError: function(onData, cancelOnError, onDone, onError) {
      return this._async$_controller._subscribe$4(onData, onError, onDone, true === cancelOnError);
    },
    listen$3$onDone$onError: function(onData, onDone, onError) {
      return this.listen$4$cancelOnError$onDone$onError(onData, null, onDone, onError);
    }
  };
  P._DelayedEvent.prototype = {
    get$next: function() {
      return this.next;
    },
    set$next: function(val) {
      return this.next = val;
    }
  };
  P._DelayedData.prototype = {
    perform$1: function(dispatch) {
      dispatch._sendData$1(this.value);
    }
  };
  P._DelayedError.prototype = {
    perform$1: function(dispatch) {
      dispatch._sendError$2(this.error, this.stackTrace);
    }
  };
  P._DelayedDone.prototype = {
    perform$1: function(dispatch) {
      dispatch._sendDone$0();
    },
    get$next: function() {
      return;
    },
    set$next: function(_) {
      throw H.wrapException(P.StateError$("No events after a done."));
    }
  };
  P._PendingEvents.prototype = {
    schedule$1: function(dispatch) {
      var _this = this,
        t1 = _this._async$_state;
      if (t1 === 1)
        return;
      if (t1 >= 1) {
        _this._async$_state = 1;
        return;
      }
      P.scheduleMicrotask(new P._PendingEvents_schedule_closure(_this, dispatch));
      _this._async$_state = 1;
    }
  };
  P._PendingEvents_schedule_closure.prototype = {
    call$0: function() {
      var $event, t2,
        t1 = this.$this,
        oldState = t1._async$_state;
      t1._async$_state = 0;
      if (oldState === 3)
        return;
      $event = t1.firstPendingEvent;
      t2 = $event.get$next();
      t1.firstPendingEvent = t2;
      if (t2 == null)
        t1.lastPendingEvent = null;
      $event.perform$1(this.dispatch);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._StreamImplEvents.prototype = {
    add$1: function(_, $event) {
      var _this = this,
        t1 = _this.lastPendingEvent;
      if (t1 == null)
        _this.firstPendingEvent = _this.lastPendingEvent = $event;
      else {
        t1.set$next($event);
        _this.lastPendingEvent = $event;
      }
    }
  };
  P._DoneStreamSubscription.prototype = {
    _schedule$0: function() {
      var _this = this;
      if ((_this._async$_state & 2) !== 0)
        return;
      _this._zone.scheduleMicrotask$1(_this.get$_sendDone());
      _this._async$_state = (_this._async$_state | 2) >>> 0;
    },
    pause$1: function(_, resumeSignal) {
      this._async$_state += 4;
    },
    pause$0: function($receiver) {
      return this.pause$1($receiver, null);
    },
    resume$0: function() {
      var t1 = this._async$_state;
      if (t1 >= 4) {
        t1 = this._async$_state = t1 - 4;
        if (t1 < 4 && (t1 & 1) === 0)
          this._schedule$0();
      }
    },
    cancel$0: function() {
      return $.$get$Future__nullFuture();
    },
    _sendDone$0: function() {
      var _this = this,
        t1 = _this._async$_state = (_this._async$_state & 4294967293) >>> 0;
      if (t1 >= 4)
        return;
      _this._async$_state = (t1 | 1) >>> 0;
      _this._zone.runGuarded$1(_this._onDone);
    },
    $isStreamSubscription: 1
  };
  P._StreamIterator.prototype = {
    get$current: function(_) {
      if (this._subscription != null && this._isPaused)
        return this._stateData;
      return;
    },
    moveNext$0: function() {
      var future, _this = this,
        t1 = _this._subscription;
      if (t1 != null) {
        if (_this._isPaused) {
          future = new P._Future($.Zone__current, [P.bool]);
          _this._stateData = future;
          _this._isPaused = false;
          t1.resume$0();
          return future;
        }
        throw H.wrapException(P.StateError$("Already waiting for next."));
      }
      return _this._initializeOrDone$0();
    },
    _initializeOrDone$0: function() {
      var _this = this,
        stateData = _this._stateData;
      if (stateData != null) {
        _this._subscription = stateData.listen$4$cancelOnError$onDone$onError(_this.get$_onData(), true, _this.get$_onDone(), _this.get$_onError());
        return _this._stateData = new P._Future($.Zone__current, [P.bool]);
      }
      return $.$get$Future__falseFuture();
    },
    cancel$0: function() {
      var _this = this,
        subscription = _this._subscription,
        stateData = _this._stateData;
      _this._stateData = null;
      if (subscription != null) {
        _this._subscription = null;
        if (!_this._isPaused)
          stateData._asyncComplete$1(false);
        return subscription.cancel$0();
      }
      return $.$get$Future__nullFuture();
    },
    _onData$1: function(data) {
      var t1, _this = this,
        moveNextFuture = _this._stateData;
      _this._stateData = data;
      _this._isPaused = true;
      moveNextFuture._complete$1(true);
      t1 = _this._subscription;
      if (t1 != null && _this._isPaused)
        t1.pause$0(0);
    },
    _onError$2: function(error, stackTrace) {
      var moveNextFuture = this._stateData;
      this._stateData = this._subscription = null;
      moveNextFuture._completeError$2(error, stackTrace);
    },
    _onError$1: function(error) {
      return this._onError$2(error, null);
    },
    _onDone$0: function() {
      var moveNextFuture = this._stateData;
      this._stateData = this._subscription = null;
      moveNextFuture._complete$1(false);
    }
  };
  P._ForwardingStream.prototype = {
    get$isBroadcast: function() {
      return this._async$_source.get$isBroadcast();
    },
    listen$4$cancelOnError$onDone$onError: function(onData, cancelOnError, onDone, onError) {
      var t1, t2, _this = this;
      cancelOnError = true === cancelOnError;
      t1 = $.Zone__current;
      t2 = cancelOnError ? 1 : 0;
      t2 = new P._ForwardingStreamSubscription(_this, t1, t2, _this.$ti);
      t2._BufferingStreamSubscription$4(onData, onError, onDone, cancelOnError, H.getTypeArgumentByIndex(_this, 1));
      t2._subscription = _this._async$_source.listen$3$onDone$onError(t2.get$_handleData(), t2.get$_handleDone(), t2.get$_handleError());
      return t2;
    },
    listen$3$onDone$onError: function(onData, onDone, onError) {
      return this.listen$4$cancelOnError$onDone$onError(onData, null, onDone, onError);
    },
    _handleData$2: function(data, sink) {
      sink._async$_add$1(data);
    },
    $asStream: function($S, $T) {
      return [$T];
    }
  };
  P._ForwardingStreamSubscription.prototype = {
    _async$_add$1: function(data) {
      if ((this._async$_state & 2) !== 0)
        return;
      this.super$_BufferingStreamSubscription$_add(data);
    },
    _addError$2: function(error, stackTrace) {
      if ((this._async$_state & 2) !== 0)
        return;
      this.super$_BufferingStreamSubscription$_addError(error, stackTrace);
    },
    _async$_onPause$0: function() {
      var t1 = this._subscription;
      if (t1 == null)
        return;
      t1.pause$0(0);
    },
    _async$_onResume$0: function() {
      var t1 = this._subscription;
      if (t1 == null)
        return;
      t1.resume$0();
    },
    _async$_onCancel$0: function() {
      var t1 = this._subscription;
      if (t1 != null) {
        this._subscription = null;
        return t1.cancel$0();
      }
      return;
    },
    _handleData$1: function(data) {
      this._stream._handleData$2(data, this);
    },
    _handleError$2: function(error, stackTrace) {
      this._addError$2(error, stackTrace);
    },
    _handleDone$0: function() {
      this._close$0();
    },
    $asStreamSubscription: function($S, $T) {
      return [$T];
    },
    $as_BufferingStreamSubscription: function($S, $T) {
      return [$T];
    }
  };
  P._ExpandStream.prototype = {
    _handleData$2: function(inputEvent, sink) {
      var value, e, s, t1, exception;
      try {
        for (t1 = J.get$iterator$ax(this._expand.call$1(inputEvent)); t1.moveNext$0();) {
          value = t1.get$current(t1);
          sink._async$_add$1(value);
        }
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        P._addErrorWithReplacement(sink, e, s);
      }
    }
  };
  P.Timer.prototype = {};
  P.AsyncError.prototype = {
    toString$0: function(_) {
      return H.S(this.error);
    },
    $isError: 1
  };
  P._ZoneFunction.prototype = {};
  P.ZoneSpecification.prototype = {};
  P._ZoneSpecification.prototype = {$isZoneSpecification: 1};
  P.ZoneDelegate.prototype = {};
  P.Zone.prototype = {};
  P._ZoneDelegate.prototype = {$isZoneDelegate: 1};
  P._Zone.prototype = {$isZone: 1};
  P._CustomZone.prototype = {
    get$_delegate: function() {
      var t1 = this._delegateCache;
      if (t1 != null)
        return t1;
      return this._delegateCache = new P._ZoneDelegate(this);
    },
    get$errorZone: function() {
      return this._handleUncaughtError.zone;
    },
    runGuarded$1: function(f) {
      var e, s, exception;
      try {
        this.run$1(0, f);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        this.handleUncaughtError$2(e, s);
      }
    },
    runUnaryGuarded$1$2: function(f, arg) {
      var e, s, exception;
      try {
        this.runUnary$2(f, arg);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        this.handleUncaughtError$2(e, s);
      }
    },
    runUnaryGuarded$2: function(f, arg) {
      return this.runUnaryGuarded$1$2(f, arg, null);
    },
    runBinaryGuarded$2$3: function(f, arg1, arg2) {
      var e, s, exception;
      try {
        this.runBinary$3(f, arg1, arg2);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        this.handleUncaughtError$2(e, s);
      }
    },
    runBinaryGuarded$3: function(f, arg1, arg2) {
      return this.runBinaryGuarded$2$3(f, arg1, arg2, null, null);
    },
    bindCallback$1$1: function(f) {
      return new P._CustomZone_bindCallback_closure(this, this.registerCallback$1(f));
    },
    bindCallback$1: function(f) {
      return this.bindCallback$1$1(f, null);
    },
    bindUnaryCallback$2$1: function(f, $R, $T) {
      return new P._CustomZone_bindUnaryCallback_closure(this, this.registerUnaryCallback$1(f), $T, $R);
    },
    bindCallbackGuarded$1: function(f) {
      return new P._CustomZone_bindCallbackGuarded_closure(this, this.registerCallback$1(f));
    },
    $index: function(_, key) {
      var value,
        t1 = this._async$_map,
        result = t1.$index(0, key);
      if (result != null || t1.containsKey$1(key))
        return result;
      value = this.parent.$index(0, key);
      if (value != null)
        t1.$indexSet(0, key, value);
      return value;
    },
    handleUncaughtError$2: function(error, stackTrace) {
      var implementation = this._handleUncaughtError,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$5(t1, parentDelegate, this, error, stackTrace);
    },
    fork$2$specification$zoneValues: function(specification, zoneValues) {
      var implementation = this._fork,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$5(t1, parentDelegate, this, specification, zoneValues);
    },
    run$1$1: function(_, f) {
      var implementation = this._run,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$4(t1, parentDelegate, this, f);
    },
    run$1: function($receiver, f) {
      return this.run$1$1($receiver, f, null);
    },
    runUnary$2$2: function(f, arg) {
      var implementation = this._runUnary,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$5(t1, parentDelegate, this, f, arg);
    },
    runUnary$2: function(f, arg) {
      return this.runUnary$2$2(f, arg, null, null);
    },
    runBinary$3$3: function(f, arg1, arg2) {
      var implementation = this._runBinary,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$6(t1, parentDelegate, this, f, arg1, arg2);
    },
    runBinary$3: function(f, arg1, arg2) {
      return this.runBinary$3$3(f, arg1, arg2, null, null, null);
    },
    registerCallback$1$1: function(callback) {
      var implementation = this._registerCallback,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$4(t1, parentDelegate, this, callback);
    },
    registerCallback$1: function(callback) {
      return this.registerCallback$1$1(callback, null);
    },
    registerUnaryCallback$2$1: function(callback) {
      var implementation = this._registerUnaryCallback,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$4(t1, parentDelegate, this, callback);
    },
    registerUnaryCallback$1: function(callback) {
      return this.registerUnaryCallback$2$1(callback, null, null);
    },
    registerBinaryCallback$3$1: function(callback) {
      var implementation = this._registerBinaryCallback,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$4(t1, parentDelegate, this, callback);
    },
    registerBinaryCallback$1: function(callback) {
      return this.registerBinaryCallback$3$1(callback, null, null, null);
    },
    errorCallback$2: function(error, stackTrace) {
      var parentDelegate,
        implementation = this._errorCallback,
        implementationZone = implementation.zone;
      if (implementationZone === C.C__RootZone)
        return;
      parentDelegate = P._parentDelegate(implementationZone);
      return implementation.$function.call$5(implementationZone, parentDelegate, this, error, stackTrace);
    },
    scheduleMicrotask$1: function(f) {
      var implementation = this._scheduleMicrotask,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$4(t1, parentDelegate, this, f);
    },
    createTimer$2: function(duration, f) {
      var implementation = this._createTimer,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$5(t1, parentDelegate, this, duration, f);
    },
    print$1: function(line) {
      var implementation = this._print,
        t1 = implementation.zone,
        parentDelegate = P._parentDelegate(t1);
      return implementation.$function.call$4(t1, parentDelegate, this, line);
    },
    get$_run: function() {
      return this._run;
    },
    get$_runUnary: function() {
      return this._runUnary;
    },
    get$_runBinary: function() {
      return this._runBinary;
    },
    get$_registerCallback: function() {
      return this._registerCallback;
    },
    get$_registerUnaryCallback: function() {
      return this._registerUnaryCallback;
    },
    get$_registerBinaryCallback: function() {
      return this._registerBinaryCallback;
    },
    get$_errorCallback: function() {
      return this._errorCallback;
    },
    get$_scheduleMicrotask: function() {
      return this._scheduleMicrotask;
    },
    get$_createTimer: function() {
      return this._createTimer;
    },
    get$_createPeriodicTimer: function() {
      return this._createPeriodicTimer;
    },
    get$_print: function() {
      return this._print;
    },
    get$_fork: function() {
      return this._fork;
    },
    get$_handleUncaughtError: function() {
      return this._handleUncaughtError;
    },
    get$parent: function() {
      return this.parent;
    },
    get$_async$_map: function() {
      return this._async$_map;
    }
  };
  P._CustomZone_bindCallback_closure.prototype = {
    call$0: function() {
      return this.$this.run$1(0, this.registered);
    }
  };
  P._CustomZone_bindUnaryCallback_closure.prototype = {
    call$1: function(arg) {
      return this.$this.runUnary$2(this.registered, arg);
    },
    $signature: function() {
      return {func: 1, ret: this.R, args: [this.T]};
    }
  };
  P._CustomZone_bindCallbackGuarded_closure.prototype = {
    call$0: function() {
      return this.$this.runGuarded$1(this.registered);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._rootHandleUncaughtError_closure.prototype = {
    call$0: function() {
      var error,
        t1 = this._box_0,
        t2 = t1.error;
      t1 = t2 == null ? t1.error = new P.NullThrownError() : t2;
      t2 = this.stackTrace;
      if (t2 == null)
        throw H.wrapException(t1);
      error = H.wrapException(t1);
      error.stack = t2.toString$0(0);
      throw error;
    }
  };
  P._RootZone.prototype = {
    get$_run: function() {
      return C._ZoneFunction__RootZone__rootRun;
    },
    get$_runUnary: function() {
      return C._ZoneFunction__RootZone__rootRunUnary;
    },
    get$_runBinary: function() {
      return C._ZoneFunction__RootZone__rootRunBinary;
    },
    get$_registerCallback: function() {
      return C._ZoneFunction__RootZone__rootRegisterCallback;
    },
    get$_registerUnaryCallback: function() {
      return C._ZoneFunction_Eeh;
    },
    get$_registerBinaryCallback: function() {
      return C._ZoneFunction_7G2;
    },
    get$_errorCallback: function() {
      return C._ZoneFunction__RootZone__rootErrorCallback;
    },
    get$_scheduleMicrotask: function() {
      return C._ZoneFunction__RootZone__rootScheduleMicrotask;
    },
    get$_createTimer: function() {
      return C._ZoneFunction__RootZone__rootCreateTimer;
    },
    get$_createPeriodicTimer: function() {
      return C._ZoneFunction_3bB;
    },
    get$_print: function() {
      return C._ZoneFunction__RootZone__rootPrint;
    },
    get$_fork: function() {
      return C._ZoneFunction__RootZone__rootFork;
    },
    get$_handleUncaughtError: function() {
      return C._ZoneFunction_NMc;
    },
    get$parent: function() {
      return;
    },
    get$_async$_map: function() {
      return $.$get$_RootZone__rootMap();
    },
    get$_delegate: function() {
      var t1 = $._RootZone__rootDelegate;
      if (t1 != null)
        return t1;
      return $._RootZone__rootDelegate = new P._ZoneDelegate(this);
    },
    get$errorZone: function() {
      return this;
    },
    runGuarded$1: function(f) {
      var e, s, exception, _null = null;
      try {
        if (C.C__RootZone === $.Zone__current) {
          f.call$0();
          return;
        }
        P._rootRun(_null, _null, this, f);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        P._rootHandleUncaughtError(_null, _null, this, e, s);
      }
    },
    runUnaryGuarded$1$2: function(f, arg) {
      var e, s, exception, _null = null;
      try {
        if (C.C__RootZone === $.Zone__current) {
          f.call$1(arg);
          return;
        }
        P._rootRunUnary(_null, _null, this, f, arg);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        P._rootHandleUncaughtError(_null, _null, this, e, s);
      }
    },
    runUnaryGuarded$2: function(f, arg) {
      return this.runUnaryGuarded$1$2(f, arg, null);
    },
    runBinaryGuarded$2$3: function(f, arg1, arg2) {
      var e, s, exception, _null = null;
      try {
        if (C.C__RootZone === $.Zone__current) {
          f.call$2(arg1, arg2);
          return;
        }
        P._rootRunBinary(_null, _null, this, f, arg1, arg2);
      } catch (exception) {
        e = H.unwrapException(exception);
        s = H.getTraceFromException(exception);
        P._rootHandleUncaughtError(_null, _null, this, e, s);
      }
    },
    runBinaryGuarded$3: function(f, arg1, arg2) {
      return this.runBinaryGuarded$2$3(f, arg1, arg2, null, null);
    },
    bindCallback$1$1: function(f) {
      return new P._RootZone_bindCallback_closure(this, f);
    },
    bindCallback$1: function(f) {
      return this.bindCallback$1$1(f, null);
    },
    bindCallbackGuarded$1: function(f) {
      return new P._RootZone_bindCallbackGuarded_closure(this, f);
    },
    $index: function(_, key) {
      return;
    },
    handleUncaughtError$2: function(error, stackTrace) {
      P._rootHandleUncaughtError(null, null, this, error, stackTrace);
    },
    fork$2$specification$zoneValues: function(specification, zoneValues) {
      return P._rootFork(null, null, this, specification, zoneValues);
    },
    run$1$1: function(_, f) {
      if ($.Zone__current === C.C__RootZone)
        return f.call$0();
      return P._rootRun(null, null, this, f);
    },
    run$1: function($receiver, f) {
      return this.run$1$1($receiver, f, null);
    },
    runUnary$2$2: function(f, arg) {
      if ($.Zone__current === C.C__RootZone)
        return f.call$1(arg);
      return P._rootRunUnary(null, null, this, f, arg);
    },
    runUnary$2: function(f, arg) {
      return this.runUnary$2$2(f, arg, null, null);
    },
    runBinary$3$3: function(f, arg1, arg2) {
      if ($.Zone__current === C.C__RootZone)
        return f.call$2(arg1, arg2);
      return P._rootRunBinary(null, null, this, f, arg1, arg2);
    },
    runBinary$3: function(f, arg1, arg2) {
      return this.runBinary$3$3(f, arg1, arg2, null, null, null);
    },
    registerCallback$1$1: function(f) {
      return f;
    },
    registerCallback$1: function(f) {
      return this.registerCallback$1$1(f, null);
    },
    registerUnaryCallback$2$1: function(f) {
      return f;
    },
    registerUnaryCallback$1: function(f) {
      return this.registerUnaryCallback$2$1(f, null, null);
    },
    registerBinaryCallback$3$1: function(f) {
      return f;
    },
    registerBinaryCallback$1: function(f) {
      return this.registerBinaryCallback$3$1(f, null, null, null);
    },
    errorCallback$2: function(error, stackTrace) {
      return;
    },
    scheduleMicrotask$1: function(f) {
      P._rootScheduleMicrotask(null, null, this, f);
    },
    createTimer$2: function(duration, f) {
      return P.Timer__createTimer(duration, f);
    },
    print$1: function(line) {
      H.printString(line);
    }
  };
  P._RootZone_bindCallback_closure.prototype = {
    call$0: function() {
      return this.$this.run$1(0, this.f);
    }
  };
  P._RootZone_bindCallbackGuarded_closure.prototype = {
    call$0: function() {
      return this.$this.runGuarded$1(this.f);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  P._HashMap.prototype = {
    get$length: function(_) {
      return this._collection$_length;
    },
    get$isEmpty: function(_) {
      return this._collection$_length === 0;
    },
    get$isNotEmpty: function(_) {
      return this._collection$_length !== 0;
    },
    get$keys: function() {
      return new P._HashMapKeyIterable(this, [H.getTypeArgumentByIndex(this, 0)]);
    },
    get$values: function() {
      var _this = this,
        t1 = H.getTypeArgumentByIndex(_this, 0);
      return H.MappedIterable_MappedIterable(new P._HashMapKeyIterable(_this, [t1]), new P._HashMap_values_closure(_this), t1, H.getTypeArgumentByIndex(_this, 1));
    },
    containsKey$1: function(key) {
      var strings, nums;
      if (typeof key === "string" && key !== "__proto__") {
        strings = this._collection$_strings;
        return strings == null ? false : strings[key] != null;
      } else if (typeof key === "number" && (key & 1073741823) === key) {
        nums = this._collection$_nums;
        return nums == null ? false : nums[key] != null;
      } else
        return this._containsKey$1(key);
    },
    _containsKey$1: function(key) {
      var rest = this._collection$_rest;
      if (rest == null)
        return false;
      return this._findBucketIndex$2(this._getBucket$2(rest, key), key) >= 0;
    },
    addAll$1: function(_, other) {
      other.forEach$1(0, new P._HashMap_addAll_closure(this));
    },
    $index: function(_, key) {
      var strings, t1, nums;
      if (typeof key === "string" && key !== "__proto__") {
        strings = this._collection$_strings;
        t1 = strings == null ? null : P._HashMap__getTableEntry(strings, key);
        return t1;
      } else if (typeof key === "number" && (key & 1073741823) === key) {
        nums = this._collection$_nums;
        t1 = nums == null ? null : P._HashMap__getTableEntry(nums, key);
        return t1;
      } else
        return this._get$1(key);
    },
    _get$1: function(key) {
      var bucket, index,
        rest = this._collection$_rest;
      if (rest == null)
        return;
      bucket = this._getBucket$2(rest, key);
      index = this._findBucketIndex$2(bucket, key);
      return index < 0 ? null : bucket[index + 1];
    },
    $indexSet: function(_, key, value) {
      var strings, nums, _this = this;
      if (typeof key === "string" && key !== "__proto__") {
        strings = _this._collection$_strings;
        _this._collection$_addHashTableEntry$3(strings == null ? _this._collection$_strings = P._HashMap__newHashTable() : strings, key, value);
      } else if (typeof key === "number" && (key & 1073741823) === key) {
        nums = _this._collection$_nums;
        _this._collection$_addHashTableEntry$3(nums == null ? _this._collection$_nums = P._HashMap__newHashTable() : nums, key, value);
      } else
        _this._set$2(key, value);
    },
    _set$2: function(key, value) {
      var hash, bucket, index, _this = this,
        rest = _this._collection$_rest;
      if (rest == null)
        rest = _this._collection$_rest = P._HashMap__newHashTable();
      hash = _this._computeHashCode$1(key);
      bucket = rest[hash];
      if (bucket == null) {
        P._HashMap__setTableEntry(rest, hash, [key, value]);
        ++_this._collection$_length;
        _this._collection$_keys = null;
      } else {
        index = _this._findBucketIndex$2(bucket, key);
        if (index >= 0)
          bucket[index + 1] = value;
        else {
          bucket.push(key, value);
          ++_this._collection$_length;
          _this._collection$_keys = null;
        }
      }
    },
    putIfAbsent$2: function(key, ifAbsent) {
      var value;
      if (this.containsKey$1(key))
        return this.$index(0, key);
      value = ifAbsent.call$0();
      this.$indexSet(0, key, value);
      return value;
    },
    remove$1: function(_, key) {
      var t1;
      if (typeof key === "string" && key !== "__proto__")
        return this._removeHashTableEntry$2(this._collection$_strings, key);
      else {
        t1 = this._remove$1(key);
        return t1;
      }
    },
    _remove$1: function(key) {
      var bucket, index, _this = this,
        rest = _this._collection$_rest;
      if (rest == null)
        return;
      bucket = _this._getBucket$2(rest, key);
      index = _this._findBucketIndex$2(bucket, key);
      if (index < 0)
        return;
      --_this._collection$_length;
      _this._collection$_keys = null;
      return bucket.splice(index, 2)[1];
    },
    forEach$1: function(_, action) {
      var $length, i, key, _this = this,
        keys = _this._computeKeys$0();
      for ($length = keys.length, i = 0; i < $length; ++i) {
        key = keys[i];
        action.call$2(key, _this.$index(0, key));
        if (keys !== _this._collection$_keys)
          throw H.wrapException(P.ConcurrentModificationError$(_this));
      }
    },
    _computeKeys$0: function() {
      var result, strings, names, entries, index, i, nums, rest, bucket, $length, i0, _this = this,
        t1 = _this._collection$_keys;
      if (t1 != null)
        return t1;
      result = new Array(_this._collection$_length);
      result.fixed$length = Array;
      strings = _this._collection$_strings;
      if (strings != null) {
        names = Object.getOwnPropertyNames(strings);
        entries = names.length;
        for (index = 0, i = 0; i < entries; ++i) {
          result[index] = names[i];
          ++index;
        }
      } else
        index = 0;
      nums = _this._collection$_nums;
      if (nums != null) {
        names = Object.getOwnPropertyNames(nums);
        entries = names.length;
        for (i = 0; i < entries; ++i) {
          result[index] = +names[i];
          ++index;
        }
      }
      rest = _this._collection$_rest;
      if (rest != null) {
        names = Object.getOwnPropertyNames(rest);
        entries = names.length;
        for (i = 0; i < entries; ++i) {
          bucket = rest[names[i]];
          $length = bucket.length;
          for (i0 = 0; i0 < $length; i0 += 2) {
            result[index] = bucket[i0];
            ++index;
          }
        }
      }
      return _this._collection$_keys = result;
    },
    _collection$_addHashTableEntry$3: function(table, key, value) {
      if (table[key] == null) {
        ++this._collection$_length;
        this._collection$_keys = null;
      }
      P._HashMap__setTableEntry(table, key, value);
    },
    _removeHashTableEntry$2: function(table, key) {
      var value;
      if (table != null && table[key] != null) {
        value = P._HashMap__getTableEntry(table, key);
        delete table[key];
        --this._collection$_length;
        this._collection$_keys = null;
        return value;
      } else
        return;
    },
    _computeHashCode$1: function(key) {
      return J.get$hashCode$(key) & 1073741823;
    },
    _getBucket$2: function(table, key) {
      return table[this._computeHashCode$1(key)];
    },
    _findBucketIndex$2: function(bucket, key) {
      var $length, i;
      if (bucket == null)
        return -1;
      $length = bucket.length;
      for (i = 0; i < $length; i += 2)
        if (J.$eq$(bucket[i], key))
          return i;
      return -1;
    }
  };
  P._HashMap_values_closure.prototype = {
    call$1: function(each) {
      return this.$this.$index(0, each);
    },
    $signature: function() {
      var t1 = this.$this;
      return {func: 1, ret: H.getTypeArgumentByIndex(t1, 1), args: [H.getTypeArgumentByIndex(t1, 0)]};
    }
  };
  P._HashMap_addAll_closure.prototype = {
    call$2: function(key, value) {
      this.$this.$indexSet(0, key, value);
    },
    $signature: function() {
      var t1 = this.$this;
      return {func: 1, ret: P.Null, args: [H.getTypeArgumentByIndex(t1, 0), H.getTypeArgumentByIndex(t1, 1)]};
    }
  };
  P._HashMapKeyIterable.prototype = {
    get$length: function(_) {
      return this._collection$_map._collection$_length;
    },
    get$isEmpty: function(_) {
      return this._collection$_map._collection$_length === 0;
    },
    get$iterator: function(_) {
      var t1 = this._collection$_map;
      return new P._HashMapKeyIterator(t1, t1._computeKeys$0());
    },
    contains$1: function(_, element) {
      return this._collection$_map.containsKey$1(element);
    }
  };
  P._HashMapKeyIterator.prototype = {
    get$current: function(_) {
      return this._collection$_current;
    },
    moveNext$0: function() {
      var _this = this,
        keys = _this._collection$_keys,
        offset = _this._offset,
        t1 = _this._collection$_map;
      if (keys !== t1._collection$_keys)
        throw H.wrapException(P.ConcurrentModificationError$(t1));
      else if (offset >= keys.length) {
        _this._collection$_current = null;
        return false;
      } else {
        _this._collection$_current = keys[offset];
        _this._offset = offset + 1;
        return true;
      }
    }
  };
  P._LinkedIdentityHashMap.prototype = {
    internalComputeHashCode$1: function(key) {
      return H.objectHashCode(key) & 1073741823;
    },
    internalFindBucketIndex$2: function(bucket, key) {
      var $length, i, t1;
      if (bucket == null)
        return -1;
      $length = bucket.length;
      for (i = 0; i < $length; ++i) {
        t1 = bucket[i].hashMapCellKey;
        if (t1 == null ? key == null : t1 === key)
          return i;
      }
      return -1;
    }
  };
  P._LinkedCustomHashMap.prototype = {
    $index: function(_, key) {
      if (!this._validKey.call$1(key))
        return;
      return this.super$JsLinkedHashMap$internalGet(key);
    },
    $indexSet: function(_, key, value) {
      this.super$JsLinkedHashMap$internalSet(key, value);
    },
    containsKey$1: function(key) {
      if (!this._validKey.call$1(key))
        return false;
      return this.super$JsLinkedHashMap$internalContainsKey(key);
    },
    remove$1: function(_, key) {
      if (!this._validKey.call$1(key))
        return;
      return this.super$JsLinkedHashMap$internalRemove(key);
    },
    internalComputeHashCode$1: function(key) {
      return this._collection$_hashCode.call$1(key) & 1073741823;
    },
    internalFindBucketIndex$2: function(bucket, key) {
      var $length, t1, i;
      if (bucket == null)
        return -1;
      $length = bucket.length;
      for (t1 = this._equals, i = 0; i < $length; ++i)
        if (t1.call$2(bucket[i].hashMapCellKey, key))
          return i;
      return -1;
    }
  };
  P._LinkedCustomHashMap_closure.prototype = {
    call$1: function(v) {
      return H.checkSubtypeOfRuntimeType(v, this.K);
    },
    $signature: 21
  };
  P._LinkedHashSet.prototype = {
    _newSet$0: function() {
      return new P._LinkedHashSet(this.$ti);
    },
    _newSimilarSet$1$0: function($R) {
      return new P._LinkedHashSet([$R]);
    },
    _newSimilarSet$0: function() {
      return this._newSimilarSet$1$0(null);
    },
    get$iterator: function(_) {
      var t1 = new P._LinkedHashSetIterator(this, this._collection$_modifications);
      t1._collection$_cell = this._collection$_first;
      return t1;
    },
    get$length: function(_) {
      return this._collection$_length;
    },
    get$isEmpty: function(_) {
      return this._collection$_length === 0;
    },
    get$isNotEmpty: function(_) {
      return this._collection$_length !== 0;
    },
    contains$1: function(_, object) {
      var strings, nums;
      if (typeof object === "string" && object !== "__proto__") {
        strings = this._collection$_strings;
        if (strings == null)
          return false;
        return strings[object] != null;
      } else if (typeof object === "number" && (object & 1073741823) === object) {
        nums = this._collection$_nums;
        if (nums == null)
          return false;
        return nums[object] != null;
      } else
        return this._contains$1(object);
    },
    _contains$1: function(object) {
      var rest = this._collection$_rest;
      if (rest == null)
        return false;
      return this._findBucketIndex$2(this._getBucket$2(rest, object), object) >= 0;
    },
    get$first: function(_) {
      var t1 = this._collection$_first;
      if (t1 == null)
        throw H.wrapException(P.StateError$("No elements"));
      return t1._element;
    },
    get$last: function(_) {
      var t1 = this._collection$_last;
      if (t1 == null)
        throw H.wrapException(P.StateError$("No elements"));
      return t1._element;
    },
    add$1: function(_, element) {
      var strings, nums, _this = this;
      if (typeof element === "string" && element !== "__proto__") {
        strings = _this._collection$_strings;
        return _this._collection$_addHashTableEntry$2(strings == null ? _this._collection$_strings = P._LinkedHashSet__newHashTable() : strings, element);
      } else if (typeof element === "number" && (element & 1073741823) === element) {
        nums = _this._collection$_nums;
        return _this._collection$_addHashTableEntry$2(nums == null ? _this._collection$_nums = P._LinkedHashSet__newHashTable() : nums, element);
      } else
        return _this._collection$_add$1(element);
    },
    _collection$_add$1: function(element) {
      var hash, bucket, _this = this,
        rest = _this._collection$_rest;
      if (rest == null)
        rest = _this._collection$_rest = P._LinkedHashSet__newHashTable();
      hash = _this._computeHashCode$1(element);
      bucket = rest[hash];
      if (bucket == null)
        rest[hash] = [_this._collection$_newLinkedCell$1(element)];
      else {
        if (_this._findBucketIndex$2(bucket, element) >= 0)
          return false;
        bucket.push(_this._collection$_newLinkedCell$1(element));
      }
      return true;
    },
    remove$1: function(_, object) {
      var _this = this;
      if (typeof object === "string" && object !== "__proto__")
        return _this._removeHashTableEntry$2(_this._collection$_strings, object);
      else if (typeof object === "number" && (object & 1073741823) === object)
        return _this._removeHashTableEntry$2(_this._collection$_nums, object);
      else
        return _this._remove$1(object);
    },
    _remove$1: function(object) {
      var bucket, index, _this = this,
        rest = _this._collection$_rest;
      if (rest == null)
        return false;
      bucket = _this._getBucket$2(rest, object);
      index = _this._findBucketIndex$2(bucket, object);
      if (index < 0)
        return false;
      _this._unlinkCell$1(bucket.splice(index, 1)[0]);
      return true;
    },
    _collection$_addHashTableEntry$2: function(table, element) {
      if (table[element] != null)
        return false;
      table[element] = this._collection$_newLinkedCell$1(element);
      return true;
    },
    _removeHashTableEntry$2: function(table, element) {
      var cell;
      if (table == null)
        return false;
      cell = table[element];
      if (cell == null)
        return false;
      this._unlinkCell$1(cell);
      delete table[element];
      return true;
    },
    _collection$_modified$0: function() {
      this._collection$_modifications = 1073741823 & this._collection$_modifications + 1;
    },
    _collection$_newLinkedCell$1: function(element) {
      var last, _this = this,
        cell = new P._LinkedHashSetCell(element);
      if (_this._collection$_first == null)
        _this._collection$_first = _this._collection$_last = cell;
      else {
        last = _this._collection$_last;
        cell._collection$_previous = last;
        _this._collection$_last = last._collection$_next = cell;
      }
      ++_this._collection$_length;
      _this._collection$_modified$0();
      return cell;
    },
    _unlinkCell$1: function(cell) {
      var _this = this,
        previous = cell._collection$_previous,
        next = cell._collection$_next;
      if (previous == null)
        _this._collection$_first = next;
      else
        previous._collection$_next = next;
      if (next == null)
        _this._collection$_last = previous;
      else
        next._collection$_previous = previous;
      --_this._collection$_length;
      _this._collection$_modified$0();
    },
    _computeHashCode$1: function(element) {
      return J.get$hashCode$(element) & 1073741823;
    },
    _getBucket$2: function(table, element) {
      return table[this._computeHashCode$1(element)];
    },
    _findBucketIndex$2: function(bucket, element) {
      var $length, i;
      if (bucket == null)
        return -1;
      $length = bucket.length;
      for (i = 0; i < $length; ++i)
        if (J.$eq$(bucket[i]._element, element))
          return i;
      return -1;
    }
  };
  P._LinkedIdentityHashSet.prototype = {
    _newSet$0: function() {
      return new P._LinkedIdentityHashSet(this.$ti);
    },
    _newSimilarSet$1$0: function($R) {
      return new P._LinkedIdentityHashSet([$R]);
    },
    _newSimilarSet$0: function() {
      return this._newSimilarSet$1$0(null);
    },
    _computeHashCode$1: function(key) {
      return H.objectHashCode(key) & 1073741823;
    },
    _findBucketIndex$2: function(bucket, element) {
      var $length, i, t1;
      if (bucket == null)
        return -1;
      $length = bucket.length;
      for (i = 0; i < $length; ++i) {
        t1 = bucket[i]._element;
        if (t1 == null ? element == null : t1 === element)
          return i;
      }
      return -1;
    }
  };
  P._LinkedHashSetCell.prototype = {};
  P._LinkedHashSetIterator.prototype = {
    get$current: function(_) {
      return this._collection$_current;
    },
    moveNext$0: function() {
      var _this = this,
        t1 = _this._set;
      if (_this._collection$_modifications !== t1._collection$_modifications)
        throw H.wrapException(P.ConcurrentModificationError$(t1));
      else {
        t1 = _this._collection$_cell;
        if (t1 == null) {
          _this._collection$_current = null;
          return false;
        } else {
          _this._collection$_current = t1._element;
          _this._collection$_cell = t1._collection$_next;
          return true;
        }
      }
    }
  };
  P.UnmodifiableListView.prototype = {
    cast$1$0: function(_, $R) {
      return new P.UnmodifiableListView(J.cast$1$0$ax(this._collection$_source, $R), [$R]);
    },
    get$length: function(_) {
      return J.get$length$asx(this._collection$_source);
    },
    $index: function(_, index) {
      return J.elementAt$1$ax(this._collection$_source, index);
    }
  };
  P.HashMap_HashMap$from_closure.prototype = {
    call$2: function(k, v) {
      this.result.$indexSet(0, k, v);
    },
    $signature: 12
  };
  P.IterableBase.prototype = {};
  P.LinkedHashMap_LinkedHashMap$from_closure.prototype = {
    call$2: function(k, v) {
      this.result.$indexSet(0, k, v);
    },
    $signature: 12
  };
  P.ListBase.prototype = {$isEfficientLengthIterable: 1, $isIterable: 1, $isList: 1};
  P.ListMixin.prototype = {
    get$iterator: function(receiver) {
      return new H.ListIterator(receiver, this.get$length(receiver));
    },
    elementAt$1: function(receiver, index) {
      return this.$index(receiver, index);
    },
    get$isEmpty: function(receiver) {
      return this.get$length(receiver) === 0;
    },
    get$isNotEmpty: function(receiver) {
      return !this.get$isEmpty(receiver);
    },
    get$first: function(receiver) {
      if (this.get$length(receiver) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      return this.$index(receiver, 0);
    },
    get$last: function(receiver) {
      if (this.get$length(receiver) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      return this.$index(receiver, this.get$length(receiver) - 1);
    },
    get$single: function(receiver) {
      if (this.get$length(receiver) === 0)
        throw H.wrapException(H.IterableElementError_noElement());
      if (this.get$length(receiver) > 1)
        throw H.wrapException(H.IterableElementError_tooMany());
      return this.$index(receiver, 0);
    },
    contains$1: function(receiver, element) {
      var i,
        $length = this.get$length(receiver);
      for (i = 0; i < $length; ++i) {
        if (J.$eq$(this.$index(receiver, i), element))
          return true;
        if ($length !== this.get$length(receiver))
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return false;
    },
    every$1: function(receiver, test) {
      var i,
        $length = this.get$length(receiver);
      for (i = 0; i < $length; ++i) {
        if (!test.call$1(this.$index(receiver, i)))
          return false;
        if ($length !== this.get$length(receiver))
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return true;
    },
    any$1: function(receiver, test) {
      var i,
        $length = this.get$length(receiver);
      for (i = 0; i < $length; ++i) {
        if (test.call$1(this.$index(receiver, i)))
          return true;
        if ($length !== this.get$length(receiver))
          throw H.wrapException(P.ConcurrentModificationError$(receiver));
      }
      return false;
    },
    join$1: function(receiver, separator) {
      var t1;
      if (this.get$length(receiver) === 0)
        return "";
      t1 = P.StringBuffer__writeAll("", receiver, separator);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    where$1: function(receiver, test) {
      return new H.WhereIterable(receiver, test, [H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0)]);
    },
    map$1$1: function(receiver, f, $T) {
      return new H.MappedListIterable(receiver, f, [H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0), $T]);
    },
    expand$1$1: function(receiver, f, $T) {
      return new H.ExpandIterable(receiver, f, [H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0), $T]);
    },
    skip$1: function(receiver, count) {
      return H.SubListIterable$(receiver, count, null, H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0));
    },
    take$1: function(receiver, count) {
      return H.SubListIterable$(receiver, 0, count, H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0));
    },
    toList$1$growable: function(receiver, growable) {
      var result, t2, i, _this = this,
        t1 = H.getRuntimeTypeArgumentIntercepted(_this, receiver, "ListMixin", 0);
      if (growable) {
        result = H.setRuntimeTypeInfo([], [t1]);
        C.JSArray_methods.set$length(result, _this.get$length(receiver));
      } else {
        t2 = new Array(_this.get$length(receiver));
        t2.fixed$length = Array;
        result = H.setRuntimeTypeInfo(t2, [t1]);
      }
      for (i = 0; i < _this.get$length(receiver); ++i)
        result[i] = _this.$index(receiver, i);
      return result;
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0: function(receiver) {
      var i,
        result = P.LinkedHashSet_LinkedHashSet(H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0));
      for (i = 0; i < this.get$length(receiver); ++i)
        result.add$1(0, this.$index(receiver, i));
      return result;
    },
    add$1: function(receiver, element) {
      var t1 = this.get$length(receiver);
      this.set$length(receiver, t1 + 1);
      this.$indexSet(receiver, t1, element);
    },
    addAll$1: function(receiver, iterable) {
      var t1, element, i0,
        i = this.get$length(receiver);
      for (t1 = J.get$iterator$ax(iterable); t1.moveNext$0(); i = i0) {
        element = t1.get$current(t1);
        i0 = i + 1;
        this.set$length(receiver, i0);
        this.$indexSet(receiver, i, element);
      }
    },
    cast$1$0: function(receiver, $R) {
      return new H.CastList(receiver, [H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0), $R]);
    },
    sublist$2: function(receiver, start, end) {
      var $length, result, i,
        listLength = this.get$length(receiver);
      P.RangeError_checkValidRange(start, end, listLength);
      $length = end - start;
      result = H.setRuntimeTypeInfo([], [H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0)]);
      C.JSArray_methods.set$length(result, $length);
      for (i = 0; i < $length; ++i)
        result[i] = this.$index(receiver, start + i);
      return result;
    },
    getRange$2: function(receiver, start, end) {
      P.RangeError_checkValidRange(start, end, this.get$length(receiver));
      return H.SubListIterable$(receiver, start, end, H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0));
    },
    fillRange$3: function(receiver, start, end, fill) {
      var i;
      P.RangeError_checkValidRange(start, end, this.get$length(receiver));
      for (i = start; i < end; ++i)
        this.$indexSet(receiver, i, fill);
    },
    setRange$4: function(receiver, start, end, iterable, skipCount) {
      var $length, otherStart, otherList, t1, i, _this = this;
      P.RangeError_checkValidRange(start, end, _this.get$length(receiver));
      $length = end - start;
      if ($length === 0)
        return;
      P.RangeError_checkNotNegative(skipCount, "skipCount");
      if (H.checkSubtype(iterable, "$isList", [H.getRuntimeTypeArgumentIntercepted(_this, receiver, "ListMixin", 0)], "$asList")) {
        otherStart = skipCount;
        otherList = iterable;
      } else {
        otherList = J.skip$1$ax(iterable, skipCount).toList$1$growable(0, false);
        otherStart = 0;
      }
      t1 = J.getInterceptor$asx(otherList);
      if (otherStart + $length > t1.get$length(otherList))
        throw H.wrapException(H.IterableElementError_tooFew());
      if (otherStart < start)
        for (i = $length - 1; i >= 0; --i)
          _this.$indexSet(receiver, start + i, t1.$index(otherList, otherStart + i));
      else
        for (i = 0; i < $length; ++i)
          _this.$indexSet(receiver, start + i, t1.$index(otherList, otherStart + i));
    },
    get$reversed: function(receiver) {
      return new H.ReversedListIterable(receiver, [H.getRuntimeTypeArgumentIntercepted(this, receiver, "ListMixin", 0)]);
    },
    toString$0: function(receiver) {
      return P.IterableBase_iterableToFullString(receiver, "[", "]");
    }
  };
  P.MapBase.prototype = {};
  P.MapBase_mapToString_closure.prototype = {
    call$2: function(k, v) {
      var t2,
        t1 = this._box_0;
      if (!t1.first)
        this.result._contents += ", ";
      t1.first = false;
      t1 = this.result;
      t2 = t1._contents += H.S(k);
      t1._contents = t2 + ": ";
      t1._contents += H.S(v);
    },
    $signature: 12
  };
  P.MapMixin.prototype = {
    forEach$1: function(_, action) {
      var t1, key;
      for (t1 = J.get$iterator$ax(this.get$keys()); t1.moveNext$0();) {
        key = t1.get$current(t1);
        action.call$2(key, this.$index(0, key));
      }
    },
    addAll$1: function(_, other) {
      var t1, key;
      for (t1 = J.get$iterator$ax(other.get$keys()); t1.moveNext$0();) {
        key = t1.get$current(t1);
        this.$indexSet(0, key, other.$index(0, key));
      }
    },
    putIfAbsent$2: function(key, ifAbsent) {
      var t1;
      if (this.containsKey$1(key))
        return this.$index(0, key);
      t1 = ifAbsent.call$0();
      this.$indexSet(0, key, t1);
      return t1;
    },
    get$entries: function() {
      var _this = this;
      return J.map$1$1$ax(_this.get$keys(), new P.MapMixin_entries_closure(_this), [P.MapEntry, H.getRuntimeTypeArgument(_this, "MapMixin", 0), H.getRuntimeTypeArgument(_this, "MapMixin", 1)]);
    },
    containsKey$1: function(key) {
      return J.contains$1$asx(this.get$keys(), key);
    },
    get$length: function(_) {
      return J.get$length$asx(this.get$keys());
    },
    get$isEmpty: function(_) {
      return J.get$isEmpty$asx(this.get$keys());
    },
    get$isNotEmpty: function(_) {
      return J.get$isNotEmpty$asx(this.get$keys());
    },
    get$values: function() {
      return new P._MapBaseValueIterable(this, [H.getRuntimeTypeArgument(this, "MapMixin", 0), H.getRuntimeTypeArgument(this, "MapMixin", 1)]);
    },
    toString$0: function(_) {
      return P.MapBase_mapToString(this);
    },
    $isMap: 1
  };
  P.MapMixin_entries_closure.prototype = {
    call$1: function(key) {
      var t1 = this.$this;
      return new P.MapEntry(key, t1.$index(0, key), [H.getRuntimeTypeArgument(t1, "MapMixin", 0), H.getRuntimeTypeArgument(t1, "MapMixin", 1)]);
    },
    $signature: function() {
      var t1 = this.$this,
        t2 = H.getRuntimeTypeArgument(t1, "MapMixin", 0);
      return {func: 1, ret: [P.MapEntry, t2, H.getRuntimeTypeArgument(t1, "MapMixin", 1)], args: [t2]};
    }
  };
  P.UnmodifiableMapBase.prototype = {};
  P._MapBaseValueIterable.prototype = {
    get$length: function(_) {
      var t1 = this._collection$_map;
      return t1.get$length(t1);
    },
    get$isEmpty: function(_) {
      var t1 = this._collection$_map;
      return t1.get$isEmpty(t1);
    },
    get$isNotEmpty: function(_) {
      var t1 = this._collection$_map;
      return t1.get$isNotEmpty(t1);
    },
    get$first: function(_) {
      var t1 = this._collection$_map;
      return t1.$index(0, J.get$first$ax(t1.get$keys()));
    },
    get$single: function(_) {
      var t1 = this._collection$_map;
      return t1.$index(0, J.get$single$ax(t1.get$keys()));
    },
    get$last: function(_) {
      var t1 = this._collection$_map;
      return t1.$index(0, J.get$last$ax(t1.get$keys()));
    },
    get$iterator: function(_) {
      var t1 = this._collection$_map;
      return new P._MapBaseValueIterator(J.get$iterator$ax(t1.get$keys()), t1);
    },
    $asEfficientLengthIterable: function($K, $V) {
      return [$V];
    },
    $asIterable: function($K, $V) {
      return [$V];
    }
  };
  P._MapBaseValueIterator.prototype = {
    moveNext$0: function() {
      var _this = this,
        t1 = _this._collection$_keys;
      if (t1.moveNext$0()) {
        _this._collection$_current = _this._collection$_map.$index(0, t1.get$current(t1));
        return true;
      }
      _this._collection$_current = null;
      return false;
    },
    get$current: function(_) {
      return this._collection$_current;
    }
  };
  P._UnmodifiableMapMixin.prototype = {
    $indexSet: function(_, key, value) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify unmodifiable map"));
    },
    addAll$1: function(_, other) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify unmodifiable map"));
    },
    remove$1: function(_, key) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify unmodifiable map"));
    },
    putIfAbsent$2: function(key, ifAbsent) {
      throw H.wrapException(P.UnsupportedError$("Cannot modify unmodifiable map"));
    }
  };
  P.MapView.prototype = {
    $index: function(_, key) {
      return this._collection$_map.$index(0, key);
    },
    $indexSet: function(_, key, value) {
      this._collection$_map.$indexSet(0, key, value);
    },
    addAll$1: function(_, other) {
      this._collection$_map.addAll$1(0, other);
    },
    putIfAbsent$2: function(key, ifAbsent) {
      return this._collection$_map.putIfAbsent$2(key, ifAbsent);
    },
    containsKey$1: function(key) {
      return this._collection$_map.containsKey$1(key);
    },
    forEach$1: function(_, action) {
      this._collection$_map.forEach$1(0, action);
    },
    get$isEmpty: function(_) {
      var t1 = this._collection$_map;
      return t1.get$isEmpty(t1);
    },
    get$isNotEmpty: function(_) {
      var t1 = this._collection$_map;
      return t1.get$isNotEmpty(t1);
    },
    get$length: function(_) {
      var t1 = this._collection$_map;
      return t1.get$length(t1);
    },
    get$keys: function() {
      return this._collection$_map.get$keys();
    },
    remove$1: function(_, key) {
      return this._collection$_map.remove$1(0, key);
    },
    toString$0: function(_) {
      return J.toString$0$(this._collection$_map);
    },
    get$values: function() {
      return this._collection$_map.get$values();
    },
    get$entries: function() {
      return this._collection$_map.get$entries();
    },
    $isMap: 1
  };
  P.UnmodifiableMapView.prototype = {};
  P.Queue.prototype = {$isEfficientLengthIterable: 1, $isIterable: 1};
  P.ListQueue.prototype = {
    cast$1$0: function(_, $R) {
      return new H.CastQueue(this, [H.getTypeArgumentByIndex(this, 0), $R]);
    },
    get$iterator: function(_) {
      var _this = this;
      return new P._ListQueueIterator(_this, _this._collection$_tail, _this._modificationCount, _this._collection$_head);
    },
    get$isEmpty: function(_) {
      return this._collection$_head === this._collection$_tail;
    },
    get$length: function(_) {
      return (this._collection$_tail - this._collection$_head & this._collection$_table.length - 1) >>> 0;
    },
    get$first: function(_) {
      var t1 = this._collection$_head;
      if (t1 === this._collection$_tail)
        throw H.wrapException(H.IterableElementError_noElement());
      return this._collection$_table[t1];
    },
    get$last: function(_) {
      var t1 = this._collection$_head,
        t2 = this._collection$_tail;
      if (t1 === t2)
        throw H.wrapException(H.IterableElementError_noElement());
      t1 = this._collection$_table;
      return t1[(t2 - 1 & t1.length - 1) >>> 0];
    },
    get$single: function(_) {
      var _this = this;
      if (_this._collection$_head === _this._collection$_tail)
        throw H.wrapException(H.IterableElementError_noElement());
      if (_this.get$length(_this) > 1)
        throw H.wrapException(H.IterableElementError_tooMany());
      return _this._collection$_table[_this._collection$_head];
    },
    elementAt$1: function(_, index) {
      var t1;
      P.RangeError_checkValidIndex(index, this, null);
      t1 = this._collection$_table;
      return t1[(this._collection$_head + index & t1.length - 1) >>> 0];
    },
    toList$1$growable: function(_, growable) {
      var list, t2, _this = this,
        t1 = _this.$ti;
      if (growable) {
        list = H.setRuntimeTypeInfo([], t1);
        C.JSArray_methods.set$length(list, _this.get$length(_this));
      } else {
        t2 = new Array(_this.get$length(_this));
        t2.fixed$length = Array;
        list = H.setRuntimeTypeInfo(t2, t1);
      }
      _this._collection$_writeToList$1(list);
      return list;
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    add$1: function(_, value) {
      this._collection$_add$1(value);
    },
    addAll$1: function(_, elements) {
      var addCount, $length, t2, t3, t4, newTable, endSpace, preSpace, _this = this,
        t1 = _this.$ti;
      if (H.checkSubtype(elements, "$isList", t1, "$asList")) {
        addCount = J.get$length$asx(elements);
        $length = _this.get$length(_this);
        t2 = $length + addCount;
        t3 = _this._collection$_table;
        t4 = t3.length;
        if (t2 >= t4) {
          t3 = new Array(P.ListQueue__nextPowerOf2(t2 + C.JSInt_methods._shrOtherPositive$1(t2, 1)));
          t3.fixed$length = Array;
          newTable = H.setRuntimeTypeInfo(t3, t1);
          _this._collection$_tail = _this._collection$_writeToList$1(newTable);
          _this._collection$_table = newTable;
          _this._collection$_head = 0;
          C.JSArray_methods.setRange$4(newTable, $length, t2, elements, 0);
          _this._collection$_tail += addCount;
        } else {
          t1 = _this._collection$_tail;
          endSpace = t4 - t1;
          if (addCount < endSpace) {
            C.JSArray_methods.setRange$4(t3, t1, t1 + addCount, elements, 0);
            _this._collection$_tail += addCount;
          } else {
            preSpace = addCount - endSpace;
            C.JSArray_methods.setRange$4(t3, t1, t1 + endSpace, elements, 0);
            C.JSArray_methods.setRange$4(_this._collection$_table, 0, preSpace, elements, endSpace);
            _this._collection$_tail = preSpace;
          }
        }
        ++_this._modificationCount;
      } else
        for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
          _this._collection$_add$1(t1.get$current(t1));
    },
    toString$0: function(_) {
      return P.IterableBase_iterableToFullString(this, "{", "}");
    },
    addFirst$1: function(value) {
      var _this = this,
        t1 = _this._collection$_head,
        t2 = _this._collection$_table;
      t1 = _this._collection$_head = (t1 - 1 & t2.length - 1) >>> 0;
      t2[t1] = value;
      if (t1 === _this._collection$_tail)
        _this._collection$_grow$0();
      ++_this._modificationCount;
    },
    removeFirst$0: function() {
      var t2, result, _this = this,
        t1 = _this._collection$_head;
      if (t1 === _this._collection$_tail)
        throw H.wrapException(H.IterableElementError_noElement());
      ++_this._modificationCount;
      t2 = _this._collection$_table;
      result = t2[t1];
      t2[t1] = null;
      _this._collection$_head = (t1 + 1 & t2.length - 1) >>> 0;
      return result;
    },
    removeLast$0: function(_) {
      var result, _this = this,
        t1 = _this._collection$_head,
        t2 = _this._collection$_tail;
      if (t1 === t2)
        throw H.wrapException(H.IterableElementError_noElement());
      ++_this._modificationCount;
      t1 = _this._collection$_table;
      t2 = _this._collection$_tail = (t2 - 1 & t1.length - 1) >>> 0;
      result = t1[t2];
      t1[t2] = null;
      return result;
    },
    _collection$_add$1: function(element) {
      var _this = this,
        t1 = _this._collection$_table,
        t2 = _this._collection$_tail;
      t1[t2] = element;
      t1 = (t2 + 1 & t1.length - 1) >>> 0;
      _this._collection$_tail = t1;
      if (_this._collection$_head === t1)
        _this._collection$_grow$0();
      ++_this._modificationCount;
    },
    _collection$_grow$0: function() {
      var newTable, t2, split, _this = this,
        t1 = new Array(_this._collection$_table.length * 2);
      t1.fixed$length = Array;
      newTable = H.setRuntimeTypeInfo(t1, _this.$ti);
      t1 = _this._collection$_table;
      t2 = _this._collection$_head;
      split = t1.length - t2;
      C.JSArray_methods.setRange$4(newTable, 0, split, t1, t2);
      C.JSArray_methods.setRange$4(newTable, split, split + _this._collection$_head, _this._collection$_table, 0);
      _this._collection$_head = 0;
      _this._collection$_tail = _this._collection$_table.length;
      _this._collection$_table = newTable;
    },
    _collection$_writeToList$1: function(target) {
      var $length, firstPartSize, _this = this,
        t1 = _this._collection$_head,
        t2 = _this._collection$_tail,
        t3 = _this._collection$_table;
      if (t1 <= t2) {
        $length = t2 - t1;
        C.JSArray_methods.setRange$4(target, 0, $length, t3, t1);
        return $length;
      } else {
        firstPartSize = t3.length - t1;
        C.JSArray_methods.setRange$4(target, 0, firstPartSize, t3, t1);
        C.JSArray_methods.setRange$4(target, firstPartSize, firstPartSize + _this._collection$_tail, _this._collection$_table, 0);
        return _this._collection$_tail + firstPartSize;
      }
    },
    $isQueue: 1
  };
  P._ListQueueIterator.prototype = {
    get$current: function(_) {
      return this._collection$_current;
    },
    moveNext$0: function() {
      var t2, _this = this,
        t1 = _this._queue;
      if (_this._modificationCount !== t1._modificationCount)
        H.throwExpression(P.ConcurrentModificationError$(t1));
      t2 = _this._position;
      if (t2 === _this._end) {
        _this._collection$_current = null;
        return false;
      }
      t1 = t1._collection$_table;
      _this._collection$_current = t1[t2];
      _this._position = (t2 + 1 & t1.length - 1) >>> 0;
      return true;
    }
  };
  P._SetBase.prototype = {
    cast$1$0: function(_, $R) {
      return P.Set_castFrom(this, this.get$_newSimilarSet(), H.getTypeArgumentByIndex(this, 0), $R);
    },
    difference$1: function(other) {
      var t1, element,
        result = this._newSet$0();
      for (t1 = this.get$iterator(this); t1.moveNext$0();) {
        element = t1.get$current(t1);
        if (!other.contains$1(0, element))
          result.add$1(0, element);
      }
      return result;
    },
    intersection$1: function(other) {
      var t1, t2, element,
        result = this._newSet$0();
      for (t1 = this.get$iterator(this), t2 = other._baseMap; t1.moveNext$0();) {
        element = t1.get$current(t1);
        if (t2.containsKey$1(element))
          result.add$1(0, element);
      }
      return result;
    },
    toSet$0: function(_) {
      var t1 = this._newSet$0();
      t1.addAll$1(0, this);
      return t1;
    },
    get$isEmpty: function(_) {
      return this.get$length(this) === 0;
    },
    get$isNotEmpty: function(_) {
      return this.get$length(this) !== 0;
    },
    followedBy$1: function(_, other) {
      return H.FollowedByIterable_FollowedByIterable$firstEfficient(this, other, H.getTypeArgumentByIndex(this, 0));
    },
    addAll$1: function(_, elements) {
      var t1;
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        this.add$1(0, t1.get$current(t1));
    },
    removeAll$1: function(elements) {
      var t1;
      for (t1 = J.get$iterator$ax(elements); t1.moveNext$0();)
        this.remove$1(0, t1.get$current(t1));
    },
    toList$1$growable: function(_, growable) {
      var result, t2, i, i0, _this = this,
        t1 = _this.$ti;
      if (growable) {
        result = H.setRuntimeTypeInfo([], t1);
        C.JSArray_methods.set$length(result, _this.get$length(_this));
      } else {
        t2 = new Array(_this.get$length(_this));
        t2.fixed$length = Array;
        result = H.setRuntimeTypeInfo(t2, t1);
      }
      for (t1 = _this.get$iterator(_this), i = 0; t1.moveNext$0(); i = i0) {
        i0 = i + 1;
        result[i] = t1.get$current(t1);
      }
      return result;
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    map$1$1: function(_, f, $T) {
      return new H.EfficientLengthMappedIterable(this, f, [H.getTypeArgumentByIndex(this, 0), $T]);
    },
    get$single: function(_) {
      var it, _this = this;
      if (_this.get$length(_this) > 1)
        throw H.wrapException(H.IterableElementError_tooMany());
      it = _this.get$iterator(_this);
      if (!it.moveNext$0())
        throw H.wrapException(H.IterableElementError_noElement());
      return it.get$current(it);
    },
    toString$0: function(_) {
      return P.IterableBase_iterableToFullString(this, "{", "}");
    },
    where$1: function(_, f) {
      return new H.WhereIterable(this, f, this.$ti);
    },
    join$1: function(_, separator) {
      var t1,
        iterator = this.get$iterator(this);
      if (!iterator.moveNext$0())
        return "";
      if (separator === "") {
        t1 = "";
        do
          t1 += H.S(iterator.get$current(iterator));
        while (iterator.moveNext$0());
      } else {
        t1 = H.S(iterator.get$current(iterator));
        for (; iterator.moveNext$0();)
          t1 = t1 + separator + H.S(iterator.get$current(iterator));
      }
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    any$1: function(_, test) {
      var t1;
      for (t1 = this.get$iterator(this); t1.moveNext$0();)
        if (test.call$1(t1.get$current(t1)))
          return true;
      return false;
    },
    take$1: function(_, n) {
      return H.TakeIterable_TakeIterable(this, n, H.getTypeArgumentByIndex(this, 0));
    },
    skip$1: function(_, n) {
      return H.SkipIterable_SkipIterable(this, n, H.getTypeArgumentByIndex(this, 0));
    },
    get$first: function(_) {
      var it = this.get$iterator(this);
      if (!it.moveNext$0())
        throw H.wrapException(H.IterableElementError_noElement());
      return it.get$current(it);
    },
    get$last: function(_) {
      var result,
        it = this.get$iterator(this);
      if (!it.moveNext$0())
        throw H.wrapException(H.IterableElementError_noElement());
      do
        result = it.get$current(it);
      while (it.moveNext$0());
      return result;
    },
    elementAt$1: function(_, index) {
      var t1, elementIndex, element, _s5_ = "index";
      if (index == null)
        H.throwExpression(P.ArgumentError$notNull(_s5_));
      P.RangeError_checkNotNegative(index, _s5_);
      for (t1 = this.get$iterator(this), elementIndex = 0; t1.moveNext$0();) {
        element = t1.get$current(t1);
        if (index === elementIndex)
          return element;
        ++elementIndex;
      }
      throw H.wrapException(P.IndexError$(index, this, _s5_, null, elementIndex));
    },
    $isEfficientLengthIterable: 1,
    $isIterable: 1,
    $isSet: 1
  };
  P._ListBase_Object_ListMixin.prototype = {};
  P._UnmodifiableMapView_MapView__UnmodifiableMapMixin.prototype = {};
  P.AsciiCodec.prototype = {
    encode$1: function(source) {
      return C.AsciiEncoder_127.convert$1(source);
    },
    get$encoder: function() {
      return C.AsciiEncoder_127;
    }
  };
  P._UnicodeSubsetEncoder.prototype = {
    convert$1: function(string) {
      var t1, t2, i, codeUnit,
        $length = P.RangeError_checkValidRange(0, null, string.length) - 0,
        result = new Uint8Array($length);
      for (t1 = ~this._subsetMask, t2 = J.getInterceptor$s(string), i = 0; i < $length; ++i) {
        codeUnit = t2._codeUnitAt$1(string, i);
        if ((codeUnit & t1) !== 0)
          throw H.wrapException(P.ArgumentError$value(string, "string", "Contains invalid characters."));
        result[i] = codeUnit;
      }
      return result;
    },
    $asConverter: function() {
      return [P.String, [P.List, P.int]];
    }
  };
  P.AsciiEncoder.prototype = {};
  P.Base64Codec.prototype = {
    get$encoder: function() {
      return C.C_Base64Encoder;
    },
    normalize$3: function(source, start, end) {
      var inverseAlphabet, i, sliceStart, buffer, firstPadding, firstPaddingSourceIndex, paddingCount, i0, char, i1, digit1, digit2, char0, value, t1, t2, endLength, $length,
        _s31_ = "Invalid base64 encoding length ";
      end = P.RangeError_checkValidRange(start, end, source.length);
      inverseAlphabet = $.$get$_Base64Decoder__inverseAlphabet();
      for (i = start, sliceStart = i, buffer = null, firstPadding = -1, firstPaddingSourceIndex = -1, paddingCount = 0; i < end; i = i0) {
        i0 = i + 1;
        char = C.JSString_methods._codeUnitAt$1(source, i);
        if (char === 37) {
          i1 = i0 + 2;
          if (i1 <= end) {
            digit1 = H.hexDigitValue(C.JSString_methods._codeUnitAt$1(source, i0));
            digit2 = H.hexDigitValue(C.JSString_methods._codeUnitAt$1(source, i0 + 1));
            char0 = digit1 * 16 + digit2 - (digit2 & 256);
            if (char0 === 37)
              char0 = -1;
            i0 = i1;
          } else
            char0 = -1;
        } else
          char0 = char;
        if (0 <= char0 && char0 <= 127) {
          value = inverseAlphabet[char0];
          if (value >= 0) {
            char0 = C.JSString_methods.codeUnitAt$1("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", value);
            if (char0 === char)
              continue;
            char = char0;
          } else {
            if (value === -1) {
              if (firstPadding < 0) {
                t1 = buffer == null ? null : buffer._contents.length;
                if (t1 == null)
                  t1 = 0;
                firstPadding = t1 + (i - sliceStart);
                firstPaddingSourceIndex = i;
              }
              ++paddingCount;
              if (char === 61)
                continue;
            }
            char = char0;
          }
          if (value !== -2) {
            if (buffer == null)
              buffer = new P.StringBuffer("");
            buffer._contents += C.JSString_methods.substring$2(source, sliceStart, i);
            buffer._contents += H.Primitives_stringFromCharCode(char);
            sliceStart = i0;
            continue;
          }
        }
        throw H.wrapException(P.FormatException$("Invalid base64 data", source, i));
      }
      if (buffer != null) {
        t1 = buffer._contents += C.JSString_methods.substring$2(source, sliceStart, end);
        t2 = t1.length;
        if (firstPadding >= 0)
          P.Base64Codec__checkPadding(source, firstPaddingSourceIndex, end, firstPadding, paddingCount, t2);
        else {
          endLength = C.JSInt_methods.$mod(t2 - 1, 4) + 1;
          if (endLength === 1)
            throw H.wrapException(P.FormatException$(_s31_, source, end));
          for (; endLength < 4;) {
            t1 += "=";
            buffer._contents = t1;
            ++endLength;
          }
        }
        t1 = buffer._contents;
        return C.JSString_methods.replaceRange$3(source, start, end, t1.charCodeAt(0) == 0 ? t1 : t1);
      }
      $length = end - start;
      if (firstPadding >= 0)
        P.Base64Codec__checkPadding(source, firstPaddingSourceIndex, end, firstPadding, paddingCount, $length);
      else {
        endLength = C.JSInt_methods.$mod($length, 4);
        if (endLength === 1)
          throw H.wrapException(P.FormatException$(_s31_, source, end));
        if (endLength > 1)
          source = C.JSString_methods.replaceRange$3(source, end, end, endLength === 2 ? "==" : "=");
      }
      return source;
    },
    $asCodec: function() {
      return [[P.List, P.int], P.String];
    }
  };
  P.Base64Encoder.prototype = {
    convert$1: function(input) {
      var t1 = J.getInterceptor$asx(input);
      if (t1.get$isEmpty(input))
        return "";
      return P.String_String$fromCharCodes(new P._Base64Encoder("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/").encode$4(input, 0, t1.get$length(input), true), 0, null);
    },
    startChunkedConversion$1: function(sink) {
      var t1,
        _s64_ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      if (!!sink.$isStringConversionSink) {
        t1 = sink.asUtf8Sink$1(false);
        return new P._Utf8Base64EncoderSink(t1, new P._Base64Encoder(_s64_));
      }
      return new P._AsciiBase64EncoderSink(sink, new P._BufferCachingBase64Encoder(_s64_));
    },
    $asConverter: function() {
      return [[P.List, P.int], P.String];
    }
  };
  P._Base64Encoder.prototype = {
    createBuffer$1: function(bufferLength) {
      return new Uint8Array(bufferLength);
    },
    encode$4: function(bytes, start, end, isLast) {
      var output, _this = this,
        byteCount = (_this._state & 3) + (end - start),
        fullChunks = C.JSInt_methods._tdivFast$1(byteCount, 3),
        bufferLength = fullChunks * 4;
      if (isLast && byteCount - fullChunks * 3 > 0)
        bufferLength += 4;
      output = _this.createBuffer$1(bufferLength);
      _this._state = P._Base64Encoder_encodeChunk(_this._alphabet, bytes, start, end, isLast, output, 0, _this._state);
      if (bufferLength > 0)
        return output;
      return;
    }
  };
  P._BufferCachingBase64Encoder.prototype = {
    createBuffer$1: function(bufferLength) {
      var t1 = this.bufferCache;
      if (t1 == null || t1.length < bufferLength)
        t1 = this.bufferCache = new Uint8Array(bufferLength);
      t1 = t1.buffer;
      t1.toString;
      return H.NativeUint8List_NativeUint8List$view(t1, 0, bufferLength);
    }
  };
  P._Base64EncoderSink.prototype = {
    add$1: function(_, source) {
      this._add$4(source, 0, J.get$length$asx(source), false);
    },
    close$0: function(_) {
      this._add$4(null, 0, 0, true);
    },
    addSlice$4: function(source, start, end, isLast) {
      P.RangeError_checkValidRange(start, end, source.length);
      this._add$4(source, start, end, isLast);
    }
  };
  P._AsciiBase64EncoderSink.prototype = {
    _add$4: function(source, start, end, isLast) {
      var buffer = this._encoder.encode$4(source, start, end, isLast);
      if (buffer != null)
        this._sink.add$1(0, P.String_String$fromCharCodes(buffer, 0, null));
      if (isLast)
        this._sink.close$0(0);
    }
  };
  P._Utf8Base64EncoderSink.prototype = {
    _add$4: function(source, start, end, isLast) {
      var buffer = this._encoder.encode$4(source, start, end, isLast);
      if (buffer != null)
        this._sink.addSlice$4(buffer, 0, buffer.length, isLast);
    }
  };
  P.ByteConversionSink.prototype = {};
  P.ByteConversionSinkBase.prototype = {};
  P.ChunkedConversionSink.prototype = {};
  P.Codec.prototype = {
    encode$1: function(input) {
      return this.get$encoder().convert$1(input);
    }
  };
  P.Converter.prototype = {};
  P.Encoding.prototype = {
    $asCodec: function() {
      return [P.String, [P.List, P.int]];
    }
  };
  P.JsonUnsupportedObjectError.prototype = {
    toString$0: function(_) {
      var safeString = P.Error_safeToString(this.unsupportedObject);
      return (this.cause != null ? "Converting object to an encodable object failed:" : "Converting object did not return an encodable object:") + " " + safeString;
    }
  };
  P.JsonCyclicError.prototype = {
    toString$0: function(_) {
      return "Cyclic error in JSON stringify";
    }
  };
  P.JsonCodec.prototype = {
    encode$2$toEncodable: function(value, toEncodable) {
      var t1 = P._JsonStringStringifier_stringify(value, this.get$encoder()._toEncodable, null);
      return t1;
    },
    get$encoder: function() {
      return C.JsonEncoder_null;
    },
    $asCodec: function() {
      return [P.Object, P.String];
    }
  };
  P.JsonEncoder.prototype = {
    convert$1: function(object) {
      var t1,
        output = new P.StringBuffer("");
      P._JsonStringStringifier_printOn(object, output, this._toEncodable, null);
      t1 = output._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    $asConverter: function() {
      return [P.Object, P.String];
    }
  };
  P._JsonStringifier.prototype = {
    writeStringContent$1: function(s) {
      var t1, offset, i, charCode, t2, _this = this,
        $length = s.length;
      for (t1 = J.getInterceptor$s(s), offset = 0, i = 0; i < $length; ++i) {
        charCode = t1._codeUnitAt$1(s, i);
        if (charCode > 92)
          continue;
        if (charCode < 32) {
          if (i > offset)
            _this.writeStringSlice$3(s, offset, i);
          offset = i + 1;
          _this.writeCharCode$1(92);
          switch (charCode) {
            case 8:
              _this.writeCharCode$1(98);
              break;
            case 9:
              _this.writeCharCode$1(116);
              break;
            case 10:
              _this.writeCharCode$1(110);
              break;
            case 12:
              _this.writeCharCode$1(102);
              break;
            case 13:
              _this.writeCharCode$1(114);
              break;
            default:
              _this.writeCharCode$1(117);
              _this.writeCharCode$1(48);
              _this.writeCharCode$1(48);
              t2 = charCode >>> 4 & 15;
              _this.writeCharCode$1(t2 < 10 ? 48 + t2 : 87 + t2);
              t2 = charCode & 15;
              _this.writeCharCode$1(t2 < 10 ? 48 + t2 : 87 + t2);
              break;
          }
        } else if (charCode === 34 || charCode === 92) {
          if (i > offset)
            _this.writeStringSlice$3(s, offset, i);
          offset = i + 1;
          _this.writeCharCode$1(92);
          _this.writeCharCode$1(charCode);
        }
      }
      if (offset === 0)
        _this.writeString$1(s);
      else if (offset < $length)
        _this.writeStringSlice$3(s, offset, $length);
    },
    _checkCycle$1: function(object) {
      var t1, t2, i, t3;
      for (t1 = this._seen, t2 = t1.length, i = 0; i < t2; ++i) {
        t3 = t1[i];
        if (object == null ? t3 == null : object === t3)
          throw H.wrapException(new P.JsonCyclicError(object, null));
      }
      t1.push(object);
    },
    writeObject$1: function(object) {
      var customJson, e, t1, exception, _this = this;
      if (_this.writeJsonValue$1(object))
        return;
      _this._checkCycle$1(object);
      try {
        customJson = _this._toEncodable.call$1(object);
        if (!_this.writeJsonValue$1(customJson)) {
          t1 = P.JsonUnsupportedObjectError$(object, null, _this.get$_partialResult());
          throw H.wrapException(t1);
        }
        _this._seen.pop();
      } catch (exception) {
        e = H.unwrapException(exception);
        t1 = P.JsonUnsupportedObjectError$(object, e, _this.get$_partialResult());
        throw H.wrapException(t1);
      }
    },
    writeJsonValue$1: function(object) {
      var t1, success, _this = this;
      if (typeof object === "number") {
        if (!isFinite(object))
          return false;
        _this.writeNumber$1(object);
        return true;
      } else if (object === true) {
        _this.writeString$1("true");
        return true;
      } else if (object === false) {
        _this.writeString$1("false");
        return true;
      } else if (object == null) {
        _this.writeString$1("null");
        return true;
      } else if (typeof object === "string") {
        _this.writeString$1('"');
        _this.writeStringContent$1(object);
        _this.writeString$1('"');
        return true;
      } else {
        t1 = J.getInterceptor$(object);
        if (!!t1.$isList) {
          _this._checkCycle$1(object);
          _this.writeList$1(object);
          _this._seen.pop();
          return true;
        } else if (!!t1.$isMap) {
          _this._checkCycle$1(object);
          success = _this.writeMap$1(object);
          _this._seen.pop();
          return success;
        } else
          return false;
      }
    },
    writeList$1: function(list) {
      var t1, i, _this = this;
      _this.writeString$1("[");
      t1 = J.getInterceptor$asx(list);
      if (t1.get$isNotEmpty(list)) {
        _this.writeObject$1(t1.$index(list, 0));
        for (i = 1; i < t1.get$length(list); ++i) {
          _this.writeString$1(",");
          _this.writeObject$1(t1.$index(list, i));
        }
      }
      _this.writeString$1("]");
    },
    writeMap$1: function(map) {
      var t1, keyValueList, i, separator, _this = this, _box_0 = {};
      if (map.get$isEmpty(map)) {
        _this.writeString$1("{}");
        return true;
      }
      t1 = map.get$length(map) * 2;
      keyValueList = new Array(t1);
      keyValueList.fixed$length = Array;
      i = _box_0.i = 0;
      _box_0.allStringKeys = true;
      map.forEach$1(0, new P._JsonStringifier_writeMap_closure(_box_0, keyValueList));
      if (!_box_0.allStringKeys)
        return false;
      _this.writeString$1("{");
      for (separator = '"'; i < t1; i += 2, separator = ',"') {
        _this.writeString$1(separator);
        _this.writeStringContent$1(keyValueList[i]);
        _this.writeString$1('":');
        _this.writeObject$1(keyValueList[i + 1]);
      }
      _this.writeString$1("}");
      return true;
    }
  };
  P._JsonStringifier_writeMap_closure.prototype = {
    call$2: function(key, value) {
      var t1, t2, t3, i;
      if (typeof key !== "string")
        this._box_0.allStringKeys = false;
      t1 = this.keyValueList;
      t2 = this._box_0;
      t3 = t2.i;
      i = t2.i = t3 + 1;
      t1[t3] = key;
      t2.i = i + 1;
      t1[i] = value;
    },
    $signature: 12
  };
  P._JsonStringStringifier.prototype = {
    get$_partialResult: function() {
      var t1 = this._sink;
      return !!t1.$isStringBuffer ? t1.toString$0(0) : null;
    },
    writeNumber$1: function(number) {
      this._sink.write$1(0, C.JSNumber_methods.toString$0(number));
    },
    writeString$1: function(string) {
      this._sink.write$1(0, string);
    },
    writeStringSlice$3: function(string, start, end) {
      this._sink.write$1(0, C.JSString_methods.substring$2(string, start, end));
    },
    writeCharCode$1: function(charCode) {
      this._sink.writeCharCode$1(charCode);
    }
  };
  P.StringConversionSinkBase.prototype = {};
  P.StringConversionSinkMixin.prototype = {
    add$1: function(_, str) {
      this.addSlice$4(str, 0, str.length, false);
    },
    asUtf8Sink$1: function(allowMalformed) {
      var t1 = new P.StringBuffer("");
      return new P._Utf8ConversionSink(new P._Utf8Decoder(false, t1), this, t1);
    },
    $isStringConversionSink: 1
  };
  P._StringSinkConversionSink.prototype = {
    close$0: function(_) {
    },
    addSlice$4: function(str, start, end, isLast) {
      var t1, t2, i;
      if (start !== 0 || end !== str.length)
        for (t1 = this._stringSink, t2 = J.getInterceptor$s(str), i = start; i < end; ++i)
          t1._contents += H.Primitives_stringFromCharCode(t2._codeUnitAt$1(str, i));
      else
        this._stringSink._contents += H.S(str);
      if (isLast)
        this.close$0(0);
    },
    add$1: function(_, str) {
      this._stringSink._contents += H.S(str);
    },
    asUtf8Sink$1: function(allowMalformed) {
      return new P._Utf8StringSinkAdapter(new P._Utf8Decoder(false, this._stringSink), this);
    }
  };
  P._StringCallbackSink.prototype = {
    close$0: function(_) {
      var t1 = this._stringSink,
        t2 = t1._contents;
      t1._contents = "";
      this._callback.call$1(t2.charCodeAt(0) == 0 ? t2 : t2);
    },
    asUtf8Sink$1: function(allowMalformed) {
      return new P._Utf8StringSinkAdapter(new P._Utf8Decoder(false, this._stringSink), this);
    }
  };
  P._StringAdapterSink.prototype = {
    add$1: function(_, str) {
      this._sink.add$1(0, str);
    },
    addSlice$4: function(str, start, end, isLast) {
      var t1 = start === 0 && end === str.length,
        t2 = this._sink;
      if (t1)
        t2.add$1(0, str);
      else
        t2.add$1(0, J.substring$2$s(str, start, end));
      if (isLast)
        t2.close$0(0);
    },
    close$0: function(_) {
      this._sink.close$0(0);
    }
  };
  P._Utf8StringSinkAdapter.prototype = {
    close$0: function(_) {
      this._decoder.flush$0();
      this._sink.close$0(0);
    },
    add$1: function(_, chunk) {
      this._decoder.convert$3(chunk, 0, J.get$length$asx(chunk));
    },
    addSlice$4: function(codeUnits, startIndex, endIndex, isLast) {
      this._decoder.convert$3(codeUnits, startIndex, endIndex);
      if (isLast)
        this.close$0(0);
    }
  };
  P._Utf8ConversionSink.prototype = {
    close$0: function(_) {
      var t1, t2, t3, accumulated;
      this._decoder.flush$0();
      t1 = this._buffer;
      t2 = t1._contents;
      t3 = this._chunkedSink;
      if (t2.length !== 0) {
        accumulated = t2.charCodeAt(0) == 0 ? t2 : t2;
        t1._contents = "";
        t3.addSlice$4(accumulated, 0, accumulated.length, true);
      } else
        t3.close$0(0);
    },
    add$1: function(_, chunk) {
      this.addSlice$4(chunk, 0, J.get$length$asx(chunk), false);
    },
    addSlice$4: function(chunk, startIndex, endIndex, isLast) {
      var t1, t2, accumulated, _this = this;
      _this._decoder.convert$3(chunk, startIndex, endIndex);
      t1 = _this._buffer;
      t2 = t1._contents;
      if (t2.length !== 0) {
        accumulated = t2.charCodeAt(0) == 0 ? t2 : t2;
        _this._chunkedSink.addSlice$4(accumulated, 0, accumulated.length, isLast);
        t1._contents = "";
        return;
      }
      if (isLast)
        _this.close$0(0);
    }
  };
  P.Utf8Codec.prototype = {
    get$encoder: function() {
      return C.C_Utf8Encoder;
    }
  };
  P.Utf8Encoder.prototype = {
    convert$1: function(string) {
      var t1, encoder,
        end = P.RangeError_checkValidRange(0, null, string.length),
        $length = end - 0;
      if ($length === 0)
        return new Uint8Array(0);
      t1 = new Uint8Array($length * 3);
      encoder = new P._Utf8Encoder(t1);
      if (encoder._fillBuffer$3(string, 0, end) !== end)
        encoder._writeSurrogate$2(J.codeUnitAt$1$s(string, end - 1), 0);
      return C.NativeUint8List_methods.sublist$2(t1, 0, encoder._bufferIndex);
    },
    $asConverter: function() {
      return [P.String, [P.List, P.int]];
    }
  };
  P._Utf8Encoder.prototype = {
    _writeSurrogate$2: function(leadingSurrogate, nextCodeUnit) {
      var rune, _this = this,
        t1 = _this._buffer,
        t2 = _this._bufferIndex,
        t3 = t2 + 1;
      if ((nextCodeUnit & 64512) === 56320) {
        rune = 65536 + ((leadingSurrogate & 1023) << 10) | nextCodeUnit & 1023;
        _this._bufferIndex = t3;
        t1[t2] = 240 | rune >>> 18;
        t2 = _this._bufferIndex = t3 + 1;
        t1[t3] = 128 | rune >>> 12 & 63;
        t3 = _this._bufferIndex = t2 + 1;
        t1[t2] = 128 | rune >>> 6 & 63;
        _this._bufferIndex = t3 + 1;
        t1[t3] = 128 | rune & 63;
        return true;
      } else {
        _this._bufferIndex = t3;
        t1[t2] = 224 | leadingSurrogate >>> 12;
        t2 = _this._bufferIndex = t3 + 1;
        t1[t3] = 128 | leadingSurrogate >>> 6 & 63;
        _this._bufferIndex = t2 + 1;
        t1[t2] = 128 | leadingSurrogate & 63;
        return false;
      }
    },
    _fillBuffer$3: function(str, start, end) {
      var t1, t2, t3, stringIndex, codeUnit, t4, stringIndex0, t5, _this = this;
      if (start !== end && (J.codeUnitAt$1$s(str, end - 1) & 64512) === 55296)
        --end;
      for (t1 = _this._buffer, t2 = t1.length, t3 = J.getInterceptor$s(str), stringIndex = start; stringIndex < end; ++stringIndex) {
        codeUnit = t3._codeUnitAt$1(str, stringIndex);
        if (codeUnit <= 127) {
          t4 = _this._bufferIndex;
          if (t4 >= t2)
            break;
          _this._bufferIndex = t4 + 1;
          t1[t4] = codeUnit;
        } else if ((codeUnit & 64512) === 55296) {
          if (_this._bufferIndex + 3 >= t2)
            break;
          stringIndex0 = stringIndex + 1;
          if (_this._writeSurrogate$2(codeUnit, C.JSString_methods._codeUnitAt$1(str, stringIndex0)))
            stringIndex = stringIndex0;
        } else if (codeUnit <= 2047) {
          t4 = _this._bufferIndex;
          t5 = t4 + 1;
          if (t5 >= t2)
            break;
          _this._bufferIndex = t5;
          t1[t4] = 192 | codeUnit >>> 6;
          _this._bufferIndex = t5 + 1;
          t1[t5] = 128 | codeUnit & 63;
        } else {
          t4 = _this._bufferIndex;
          if (t4 + 2 >= t2)
            break;
          t5 = _this._bufferIndex = t4 + 1;
          t1[t4] = 224 | codeUnit >>> 12;
          t4 = _this._bufferIndex = t5 + 1;
          t1[t5] = 128 | codeUnit >>> 6 & 63;
          _this._bufferIndex = t4 + 1;
          t1[t4] = 128 | codeUnit & 63;
        }
      }
      return stringIndex;
    }
  };
  P.Utf8Decoder.prototype = {
    convert$1: function(codeUnits) {
      var end, oneBytes, firstPart, buffer, start, isFirstCharacter, decoder, t1,
        result = P.Utf8Decoder__convertIntercepted(false, codeUnits, 0, null);
      if (result != null)
        return result;
      end = P.RangeError_checkValidRange(0, null, J.get$length$asx(codeUnits));
      oneBytes = P._scanOneByteCharacters(codeUnits, 0, end);
      if (oneBytes > 0) {
        firstPart = P.String_String$fromCharCodes(codeUnits, 0, oneBytes);
        if (oneBytes === end)
          return firstPart;
        buffer = new P.StringBuffer(firstPart);
        start = oneBytes;
        isFirstCharacter = false;
      } else {
        start = 0;
        buffer = null;
        isFirstCharacter = true;
      }
      if (buffer == null)
        buffer = new P.StringBuffer("");
      decoder = new P._Utf8Decoder(false, buffer);
      decoder._isFirstCharacter = isFirstCharacter;
      decoder.convert$3(codeUnits, start, end);
      decoder.flush$2(codeUnits, end);
      t1 = buffer._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    startChunkedConversion$1: function(sink) {
      return (!!sink.$isStringConversionSink ? sink : new P._StringAdapterSink(sink)).asUtf8Sink$1(false);
    },
    $asConverter: function() {
      return [[P.List, P.int], P.String];
    }
  };
  P._Utf8Decoder.prototype = {
    flush$2: function(source, offset) {
      var t1;
      if (this._expectedUnits > 0) {
        t1 = P.FormatException$("Unfinished UTF-8 octet sequence", source, offset);
        throw H.wrapException(t1);
      }
    },
    flush$0: function() {
      return this.flush$2(null, null);
    },
    convert$3: function(codeUnits, startIndex, endIndex) {
      var t1, t2, i, unit, t3, oneBytes, i0, i1, t4, _this = this,
        _s21_ = "Bad UTF-8 encoding 0x",
        value = _this._convert$_value,
        expectedUnits = _this._expectedUnits,
        extraUnits = _this._extraUnits;
      _this._extraUnits = _this._expectedUnits = _this._convert$_value = 0;
      $label0$0:
        for (t1 = J.getInterceptor$asx(codeUnits), t2 = _this._stringSink, i = startIndex; true; i = i1) {
          $label1$1:
            if (expectedUnits > 0) {
              do {
                if (i === endIndex)
                  break $label0$0;
                unit = t1.$index(codeUnits, i);
                if ((unit & 192) !== 128) {
                  t3 = P.FormatException$(_s21_ + C.JSInt_methods.toRadixString$1(unit, 16), codeUnits, i);
                  throw H.wrapException(t3);
                } else {
                  value = (value << 6 | unit & 63) >>> 0;
                  --expectedUnits;
                  ++i;
                }
              } while (expectedUnits > 0);
              if (value <= C.List_127_2047_65535_1114111[extraUnits - 1]) {
                t3 = P.FormatException$("Overlong encoding of 0x" + C.JSInt_methods.toRadixString$1(value, 16), codeUnits, i - extraUnits - 1);
                throw H.wrapException(t3);
              }
              if (value > 1114111) {
                t3 = P.FormatException$("Character outside valid Unicode range: 0x" + C.JSInt_methods.toRadixString$1(value, 16), codeUnits, i - extraUnits - 1);
                throw H.wrapException(t3);
              }
              if (!_this._isFirstCharacter || value !== 65279)
                t2._contents += H.Primitives_stringFromCharCode(value);
              _this._isFirstCharacter = false;
            }
          for (t3 = i < endIndex; t3;) {
            oneBytes = P._scanOneByteCharacters(codeUnits, i, endIndex);
            if (oneBytes > 0) {
              _this._isFirstCharacter = false;
              i0 = i + oneBytes;
              t2._contents += P.String_String$fromCharCodes(codeUnits, i, i0);
              if (i0 === endIndex)
                break;
            } else
              i0 = i;
            i1 = i0 + 1;
            unit = t1.$index(codeUnits, i0);
            if (unit < 0) {
              t4 = P.FormatException$("Negative UTF-8 code unit: -0x" + C.JSInt_methods.toRadixString$1(-unit, 16), codeUnits, i1 - 1);
              throw H.wrapException(t4);
            } else {
              if ((unit & 224) === 192) {
                value = unit & 31;
                expectedUnits = 1;
                extraUnits = 1;
                continue $label0$0;
              }
              if ((unit & 240) === 224) {
                value = unit & 15;
                expectedUnits = 2;
                extraUnits = 2;
                continue $label0$0;
              }
              if ((unit & 248) === 240 && unit < 245) {
                value = unit & 7;
                expectedUnits = 3;
                extraUnits = 3;
                continue $label0$0;
              }
              t4 = P.FormatException$(_s21_ + C.JSInt_methods.toRadixString$1(unit, 16), codeUnits, i1 - 1);
              throw H.wrapException(t4);
            }
          }
          break $label0$0;
        }
      if (expectedUnits > 0) {
        _this._convert$_value = value;
        _this._expectedUnits = expectedUnits;
        _this._extraUnits = extraUnits;
      }
    }
  };
  P.NoSuchMethodError_toString_closure.prototype = {
    call$2: function(key, value) {
      var t3,
        t1 = this.sb,
        t2 = this._box_0;
      t1._contents += t2.comma;
      t3 = t1._contents += H.S(key.__internal$_name);
      t1._contents = t3 + ": ";
      t1._contents += P.Error_safeToString(value);
      t2.comma = ", ";
    }
  };
  P.bool.prototype = {};
  P.DateTime.prototype = {
    add$1: function(_, duration) {
      return P.DateTime$_withValue(C.JSInt_methods.$add(this._value, duration.get$inMilliseconds()), false);
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof P.DateTime && this._value === other._value && true;
    },
    compareTo$1: function(_, other) {
      return C.JSInt_methods.compareTo$1(this._value, other._value);
    },
    get$hashCode: function(_) {
      var t1 = this._value;
      return (t1 ^ C.JSInt_methods._shrOtherPositive$1(t1, 30)) & 1073741823;
    },
    toString$0: function(_) {
      var _this = this,
        y = P.DateTime__fourDigits(H.Primitives_getYear(_this)),
        m = P.DateTime__twoDigits(H.Primitives_getMonth(_this)),
        d = P.DateTime__twoDigits(H.Primitives_getDay(_this)),
        h = P.DateTime__twoDigits(H.Primitives_getHours(_this)),
        min = P.DateTime__twoDigits(H.Primitives_getMinutes(_this)),
        sec = P.DateTime__twoDigits(H.Primitives_getSeconds(_this)),
        ms = P.DateTime__threeDigits(H.Primitives_getMilliseconds(_this)),
        t1 = y + "-" + m + "-" + d + " " + h + ":" + min + ":" + sec + "." + ms;
      return t1;
    },
    $isComparable: 1,
    $asComparable: function() {
      return [P.DateTime];
    }
  };
  P.double.prototype = {};
  P.Duration.prototype = {
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof P.Duration && this._duration === other._duration;
    },
    get$hashCode: function(_) {
      return C.JSInt_methods.get$hashCode(this._duration);
    },
    compareTo$1: function(_, other) {
      return C.JSInt_methods.compareTo$1(this._duration, other._duration);
    },
    toString$0: function(_) {
      var twoDigitMinutes, twoDigitSeconds, sixDigitUs,
        t1 = new P.Duration_toString_twoDigits(),
        t2 = this._duration;
      if (t2 < 0)
        return "-" + new P.Duration(0 - t2).toString$0(0);
      twoDigitMinutes = t1.call$1(C.JSInt_methods._tdivFast$1(t2, 60000000) % 60);
      twoDigitSeconds = t1.call$1(C.JSInt_methods._tdivFast$1(t2, 1000000) % 60);
      sixDigitUs = new P.Duration_toString_sixDigits().call$1(t2 % 1000000);
      return "" + C.JSInt_methods._tdivFast$1(t2, 3600000000) + ":" + H.S(twoDigitMinutes) + ":" + H.S(twoDigitSeconds) + "." + H.S(sixDigitUs);
    },
    $isComparable: 1,
    $asComparable: function() {
      return [P.Duration];
    }
  };
  P.Duration_toString_sixDigits.prototype = {
    call$1: function(n) {
      if (n >= 100000)
        return "" + n;
      if (n >= 10000)
        return "0" + n;
      if (n >= 1000)
        return "00" + n;
      if (n >= 100)
        return "000" + n;
      if (n >= 10)
        return "0000" + n;
      return "00000" + n;
    },
    $signature: 17
  };
  P.Duration_toString_twoDigits.prototype = {
    call$1: function(n) {
      if (n >= 10)
        return "" + n;
      return "0" + n;
    },
    $signature: 17
  };
  P.Error.prototype = {};
  P.NullThrownError.prototype = {
    toString$0: function(_) {
      return "Throw of null.";
    }
  };
  P.ArgumentError.prototype = {
    get$_errorName: function() {
      return "Invalid argument" + (!this._hasValue ? "(s)" : "");
    },
    get$_errorExplanation: function() {
      return "";
    },
    toString$0: function(_) {
      var message, prefix, explanation, errorValue, _this = this,
        t1 = _this.name,
        nameString = t1 != null ? " (" + t1 + ")" : "";
      t1 = _this.message;
      message = t1 == null ? "" : ": " + H.S(t1);
      prefix = _this.get$_errorName() + nameString + message;
      if (!_this._hasValue)
        return prefix;
      explanation = _this.get$_errorExplanation();
      errorValue = P.Error_safeToString(_this.invalidValue);
      return prefix + explanation + ": " + errorValue;
    },
    get$message: function(receiver) {
      return this.message;
    }
  };
  P.RangeError.prototype = {
    get$_errorName: function() {
      return "RangeError";
    },
    get$_errorExplanation: function() {
      var explanation, t2,
        t1 = this.start;
      if (t1 == null) {
        t1 = this.end;
        explanation = t1 != null ? ": Not less than or equal to " + H.S(t1) : "";
      } else {
        t2 = this.end;
        if (t2 == null)
          explanation = ": Not greater than or equal to " + H.S(t1);
        else if (t2 > t1)
          explanation = ": Not in range " + H.S(t1) + ".." + H.S(t2) + ", inclusive";
        else
          explanation = t2 < t1 ? ": Valid value range is empty" : ": Only valid value is " + H.S(t1);
      }
      return explanation;
    }
  };
  P.IndexError.prototype = {
    get$_errorName: function() {
      return "RangeError";
    },
    get$_errorExplanation: function() {
      if (this.invalidValue < 0)
        return ": index must not be negative";
      var t1 = this.length;
      if (t1 === 0)
        return ": no indices are valid";
      return ": index should be less than " + t1;
    },
    get$length: function(receiver) {
      return this.length;
    }
  };
  P.NoSuchMethodError.prototype = {
    toString$0: function(_) {
      var t1, t2, _i, t3, t4, argument, receiverText, actualParameters, _this = this, _box_0 = {},
        sb = new P.StringBuffer("");
      _box_0.comma = "";
      for (t1 = _this._core$_arguments, t2 = t1.length, _i = 0, t3 = "", t4 = ""; _i < t2; ++_i, t4 = ", ") {
        argument = t1[_i];
        sb._contents = t3 + t4;
        t3 = sb._contents += P.Error_safeToString(argument);
        _box_0.comma = ", ";
      }
      _this._namedArguments.forEach$1(0, new P.NoSuchMethodError_toString_closure(_box_0, sb));
      receiverText = P.Error_safeToString(_this._core$_receiver);
      actualParameters = sb.toString$0(0);
      t1 = "NoSuchMethodError: method not found: '" + H.S(_this._memberName.__internal$_name) + "'\nReceiver: " + receiverText + "\nArguments: [" + actualParameters + "]";
      return t1;
    }
  };
  P.UnsupportedError.prototype = {
    toString$0: function(_) {
      return "Unsupported operation: " + this.message;
    },
    get$message: function(receiver) {
      return this.message;
    }
  };
  P.UnimplementedError.prototype = {
    toString$0: function(_) {
      var t1 = this.message;
      return t1 != null ? "UnimplementedError: " + t1 : "UnimplementedError";
    },
    get$message: function(receiver) {
      return this.message;
    }
  };
  P.StateError.prototype = {
    toString$0: function(_) {
      return "Bad state: " + this.message;
    },
    get$message: function(receiver) {
      return this.message;
    }
  };
  P.ConcurrentModificationError.prototype = {
    toString$0: function(_) {
      var t1 = this.modifiedObject;
      if (t1 == null)
        return "Concurrent modification during iteration.";
      return "Concurrent modification during iteration: " + P.Error_safeToString(t1) + ".";
    }
  };
  P.OutOfMemoryError.prototype = {
    toString$0: function(_) {
      return "Out of Memory";
    },
    $isError: 1
  };
  P.StackOverflowError.prototype = {
    toString$0: function(_) {
      return "Stack Overflow";
    },
    $isError: 1
  };
  P.CyclicInitializationError.prototype = {
    toString$0: function(_) {
      var t1 = this.variableName;
      return t1 == null ? "Reading static variable during its initialization" : "Reading static variable '" + t1 + "' during its initialization";
    }
  };
  P._Exception.prototype = {
    toString$0: function(_) {
      return "Exception: " + this.message;
    },
    $isException: 1,
    get$message: function(receiver) {
      return this.message;
    }
  };
  P.FormatException.prototype = {
    toString$0: function(_) {
      var source, lineNum, lineStart, previousCharWasCR, i, char, lineEnd, end, start, prefix, postfix, slice,
        t1 = this.message,
        report = t1 != null && "" !== t1 ? "FormatException: " + H.S(t1) : "FormatException",
        offset = this.offset,
        objectSource = this.source;
      if (typeof objectSource === "string") {
        if (offset != null)
          t1 = offset < 0 || offset > objectSource.length;
        else
          t1 = false;
        if (t1)
          offset = null;
        if (offset == null) {
          source = objectSource.length > 78 ? C.JSString_methods.substring$2(objectSource, 0, 75) + "..." : objectSource;
          return report + "\n" + source;
        }
        for (lineNum = 1, lineStart = 0, previousCharWasCR = false, i = 0; i < offset; ++i) {
          char = C.JSString_methods._codeUnitAt$1(objectSource, i);
          if (char === 10) {
            if (lineStart !== i || !previousCharWasCR)
              ++lineNum;
            lineStart = i + 1;
            previousCharWasCR = false;
          } else if (char === 13) {
            ++lineNum;
            lineStart = i + 1;
            previousCharWasCR = true;
          }
        }
        report = lineNum > 1 ? report + (" (at line " + lineNum + ", character " + (offset - lineStart + 1) + ")\n") : report + (" (at character " + (offset + 1) + ")\n");
        lineEnd = objectSource.length;
        for (i = offset; i < lineEnd; ++i) {
          char = C.JSString_methods.codeUnitAt$1(objectSource, i);
          if (char === 10 || char === 13) {
            lineEnd = i;
            break;
          }
        }
        if (lineEnd - lineStart > 78)
          if (offset - lineStart < 75) {
            end = lineStart + 75;
            start = lineStart;
            prefix = "";
            postfix = "...";
          } else {
            if (lineEnd - offset < 75) {
              start = lineEnd - 75;
              end = lineEnd;
              postfix = "";
            } else {
              start = offset - 36;
              end = offset + 36;
              postfix = "...";
            }
            prefix = "...";
          }
        else {
          end = lineEnd;
          start = lineStart;
          prefix = "";
          postfix = "";
        }
        slice = C.JSString_methods.substring$2(objectSource, start, end);
        return report + prefix + slice + postfix + "\n" + C.JSString_methods.$mul(" ", offset - start + prefix.length) + "^\n";
      } else
        return offset != null ? report + (" (at offset " + H.S(offset) + ")") : report;
    },
    $isException: 1,
    get$message: function(receiver) {
      return this.message;
    },
    get$source: function() {
      return this.source;
    }
  };
  P.Function.prototype = {};
  P.int.prototype = {};
  P.Iterable.prototype = {
    cast$1$0: function(_, $R) {
      return H.CastIterable_CastIterable(this, H.getRuntimeTypeArgument(this, "Iterable", 0), $R);
    },
    followedBy$1: function(_, other) {
      var _this = this,
        t1 = H.getRuntimeTypeArgument(_this, "Iterable", 0);
      if (H.checkSubtype(_this, "$isEfficientLengthIterable", [t1], "$asEfficientLengthIterable"))
        return H.FollowedByIterable_FollowedByIterable$firstEfficient(_this, other, t1);
      return new H.FollowedByIterable(_this, other, [t1]);
    },
    map$1$1: function(_, f, $T) {
      return H.MappedIterable_MappedIterable(this, f, H.getRuntimeTypeArgument(this, "Iterable", 0), $T);
    },
    where$1: function(_, test) {
      return new H.WhereIterable(this, test, [H.getRuntimeTypeArgument(this, "Iterable", 0)]);
    },
    expand$1$1: function(_, f, $T) {
      return new H.ExpandIterable(this, f, [H.getRuntimeTypeArgument(this, "Iterable", 0), $T]);
    },
    contains$1: function(_, element) {
      var t1;
      for (t1 = this.get$iterator(this); t1.moveNext$0();)
        if (J.$eq$(t1.get$current(t1), element))
          return true;
      return false;
    },
    fold$1$2: function(_, initialValue, combine) {
      var t1, value;
      for (t1 = this.get$iterator(this), value = initialValue; t1.moveNext$0();)
        value = combine.call$2(value, t1.get$current(t1));
      return value;
    },
    fold$2: function($receiver, initialValue, combine) {
      return this.fold$1$2($receiver, initialValue, combine, null);
    },
    join$1: function(_, separator) {
      var t1,
        iterator = this.get$iterator(this);
      if (!iterator.moveNext$0())
        return "";
      if (separator === "") {
        t1 = "";
        do
          t1 += H.S(iterator.get$current(iterator));
        while (iterator.moveNext$0());
      } else {
        t1 = H.S(iterator.get$current(iterator));
        for (; iterator.moveNext$0();)
          t1 = t1 + separator + H.S(iterator.get$current(iterator));
      }
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    any$1: function(_, test) {
      var t1;
      for (t1 = this.get$iterator(this); t1.moveNext$0();)
        if (test.call$1(t1.get$current(t1)))
          return true;
      return false;
    },
    toList$1$growable: function(_, growable) {
      return P.List_List$from(this, growable, H.getRuntimeTypeArgument(this, "Iterable", 0));
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0: function(_) {
      return P.LinkedHashSet_LinkedHashSet$from(this, H.getRuntimeTypeArgument(this, "Iterable", 0));
    },
    get$length: function(_) {
      var count,
        it = this.get$iterator(this);
      for (count = 0; it.moveNext$0();)
        ++count;
      return count;
    },
    get$isEmpty: function(_) {
      return !this.get$iterator(this).moveNext$0();
    },
    get$isNotEmpty: function(_) {
      return !this.get$isEmpty(this);
    },
    take$1: function(_, count) {
      return H.TakeIterable_TakeIterable(this, count, H.getRuntimeTypeArgument(this, "Iterable", 0));
    },
    skip$1: function(_, count) {
      return H.SkipIterable_SkipIterable(this, count, H.getRuntimeTypeArgument(this, "Iterable", 0));
    },
    skipWhile$1: function(_, test) {
      return new H.SkipWhileIterable(this, test, [H.getRuntimeTypeArgument(this, "Iterable", 0)]);
    },
    get$first: function(_) {
      var it = this.get$iterator(this);
      if (!it.moveNext$0())
        throw H.wrapException(H.IterableElementError_noElement());
      return it.get$current(it);
    },
    get$last: function(_) {
      var result,
        it = this.get$iterator(this);
      if (!it.moveNext$0())
        throw H.wrapException(H.IterableElementError_noElement());
      do
        result = it.get$current(it);
      while (it.moveNext$0());
      return result;
    },
    get$single: function(_) {
      var result,
        it = this.get$iterator(this);
      if (!it.moveNext$0())
        throw H.wrapException(H.IterableElementError_noElement());
      result = it.get$current(it);
      if (it.moveNext$0())
        throw H.wrapException(H.IterableElementError_tooMany());
      return result;
    },
    firstWhere$2$orElse: function(_, test, orElse) {
      var t1, element;
      for (t1 = this.get$iterator(this); t1.moveNext$0();) {
        element = t1.get$current(t1);
        if (test.call$1(element))
          return element;
      }
      return orElse.call$0();
    },
    elementAt$1: function(_, index) {
      var t1, elementIndex, element, _s5_ = "index";
      if (index == null)
        H.throwExpression(P.ArgumentError$notNull(_s5_));
      P.RangeError_checkNotNegative(index, _s5_);
      for (t1 = this.get$iterator(this), elementIndex = 0; t1.moveNext$0();) {
        element = t1.get$current(t1);
        if (index === elementIndex)
          return element;
        ++elementIndex;
      }
      throw H.wrapException(P.IndexError$(index, this, _s5_, null, elementIndex));
    },
    toString$0: function(_) {
      return P.IterableBase_iterableToShortString(this, "(", ")");
    }
  };
  P._GeneratorIterable.prototype = {
    elementAt$1: function(_, index) {
      P.RangeError_checkValidIndex(index, this, null);
      return this._generator.call$1(index);
    },
    get$length: function(receiver) {
      return this.length;
    }
  };
  P.Iterator.prototype = {};
  P.List.prototype = {$isEfficientLengthIterable: 1, $isIterable: 1};
  P.Map.prototype = {};
  P.MapEntry.prototype = {
    toString$0: function(_) {
      return "MapEntry(" + H.S(this.key) + ": " + H.S(this.value) + ")";
    }
  };
  P.Null.prototype = {
    get$hashCode: function(_) {
      return P.Object.prototype.get$hashCode.call(this, this);
    },
    toString$0: function(_) {
      return "null";
    }
  };
  P.num.prototype = {$isComparable: 1,
    $asComparable: function() {
      return [P.num];
    }
  };
  P.Object.prototype = {constructor: P.Object, $isObject: 1,
    $eq: function(_, other) {
      return this === other;
    },
    get$hashCode: function(_) {
      return H.Primitives_objectHashCode(this);
    },
    toString$0: function(_) {
      return "Instance of '" + H.S(H.Primitives_objectTypeName(this)) + "'";
    },
    noSuchMethod$1: function(_, invocation) {
      throw H.wrapException(P.NoSuchMethodError$(this, invocation.get$memberName(), invocation.get$positionalArguments(), invocation.get$namedArguments()));
    },
    toString: function() {
      return this.toString$0(this);
    }
  };
  P.Match.prototype = {};
  P.RegExpMatch.prototype = {$isMatch: 1};
  P.Set.prototype = {};
  P.StackTrace.prototype = {};
  P._StringStackTrace.prototype = {
    toString$0: function(_) {
      return this._core$_stackTrace;
    },
    $isStackTrace: 1
  };
  P.String.prototype = {$isComparable: 1,
    $asComparable: function() {
      return [P.String];
    }
  };
  P.Runes.prototype = {
    get$iterator: function(_) {
      return new P.RuneIterator(this.string);
    },
    get$last: function(_) {
      var code, previousCode,
        t1 = this.string,
        t2 = t1.length;
      if (t2 === 0)
        throw H.wrapException(P.StateError$("No elements."));
      code = C.JSString_methods.codeUnitAt$1(t1, t2 - 1);
      if ((code & 64512) === 56320 && t2 > 1) {
        previousCode = C.JSString_methods.codeUnitAt$1(t1, t2 - 2);
        if ((previousCode & 64512) === 55296)
          return P._combineSurrogatePair(previousCode, code);
      }
      return code;
    },
    $asIterable: function() {
      return [P.int];
    }
  };
  P.RuneIterator.prototype = {
    get$current: function(_) {
      return this._currentCodePoint;
    },
    moveNext$0: function() {
      var codeUnit, nextPosition, nextCodeUnit, _this = this,
        t1 = _this._core$_position = _this._nextPosition,
        t2 = _this.string,
        t3 = t2.length;
      if (t1 === t3) {
        _this._currentCodePoint = null;
        return false;
      }
      codeUnit = C.JSString_methods._codeUnitAt$1(t2, t1);
      nextPosition = t1 + 1;
      if ((codeUnit & 64512) === 55296 && nextPosition < t3) {
        nextCodeUnit = C.JSString_methods._codeUnitAt$1(t2, nextPosition);
        if ((nextCodeUnit & 64512) === 56320) {
          _this._nextPosition = nextPosition + 1;
          _this._currentCodePoint = P._combineSurrogatePair(codeUnit, nextCodeUnit);
          return true;
        }
      }
      _this._nextPosition = nextPosition;
      _this._currentCodePoint = codeUnit;
      return true;
    }
  };
  P.StringBuffer.prototype = {
    get$length: function(_) {
      return this._contents.length;
    },
    write$1: function(_, obj) {
      this._contents += H.S(obj);
    },
    writeCharCode$1: function(charCode) {
      this._contents += H.Primitives_stringFromCharCode(charCode);
    },
    toString$0: function(_) {
      var t1 = this._contents;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    }
  };
  P.StringSink.prototype = {};
  P.Symbol0.prototype = {};
  P.Uri.prototype = {};
  P.Uri__parseIPv4Address_error.prototype = {
    call$2: function(msg, position) {
      throw H.wrapException(P.FormatException$("Illegal IPv4 address, " + msg, this.host, position));
    }
  };
  P.Uri_parseIPv6Address_error.prototype = {
    call$2: function(msg, position) {
      throw H.wrapException(P.FormatException$("Illegal IPv6 address, " + msg, this.host, position));
    },
    call$1: function(msg) {
      return this.call$2(msg, null);
    }
  };
  P.Uri_parseIPv6Address_parseHex.prototype = {
    call$2: function(start, end) {
      var value;
      if (end - start > 4)
        this.error.call$2("an IPv6 part can only contain a maximum of 4 hex digits", start);
      value = P.int_parse(C.JSString_methods.substring$2(this.host, start, end), null, 16);
      if (value < 0 || value > 65535)
        this.error.call$2("each part must be in the range of `0x0..0xFFFF`", start);
      return value;
    }
  };
  P._Uri.prototype = {
    get$userInfo: function() {
      return this._userInfo;
    },
    get$host: function() {
      var t1 = this._host;
      if (t1 == null)
        return "";
      if (C.JSString_methods.startsWith$1(t1, "["))
        return C.JSString_methods.substring$2(t1, 1, t1.length - 1);
      return t1;
    },
    get$port: function() {
      var t1 = this._port;
      if (t1 == null)
        return P._Uri__defaultPort(this.scheme);
      return t1;
    },
    get$query: function() {
      var t1 = this._query;
      return t1 == null ? "" : t1;
    },
    get$fragment: function() {
      var t1 = this._fragment;
      return t1 == null ? "" : t1;
    },
    get$pathSegments: function() {
      var pathToSplit, t1, t2,
        result = this._pathSegments;
      if (result != null)
        return result;
      pathToSplit = this.path;
      if (pathToSplit.length !== 0 && C.JSString_methods._codeUnitAt$1(pathToSplit, 0) === 47)
        pathToSplit = C.JSString_methods.substring$1(pathToSplit, 1);
      if (pathToSplit === "")
        result = C.List_empty;
      else {
        t1 = P.String;
        t2 = H.setRuntimeTypeInfo(pathToSplit.split("/"), [t1]);
        result = P.List_List$unmodifiable(new H.MappedListIterable(t2, P.core_Uri_decodeComponent$closure(), [H.getTypeArgumentByIndex(t2, 0), null]), t1);
      }
      return this._pathSegments = result;
    },
    _mergePaths$2: function(base, reference) {
      var backCount, refStart, baseEnd, newEnd, delta, t1;
      for (backCount = 0, refStart = 0; C.JSString_methods.startsWith$2(reference, "../", refStart);) {
        refStart += 3;
        ++backCount;
      }
      baseEnd = C.JSString_methods.lastIndexOf$1(base, "/");
      while (true) {
        if (!(baseEnd > 0 && backCount > 0))
          break;
        newEnd = C.JSString_methods.lastIndexOf$2(base, "/", baseEnd - 1);
        if (newEnd < 0)
          break;
        delta = baseEnd - newEnd;
        t1 = delta !== 2;
        if (!t1 || delta === 3)
          if (C.JSString_methods.codeUnitAt$1(base, newEnd + 1) === 46)
            t1 = !t1 || C.JSString_methods.codeUnitAt$1(base, newEnd + 2) === 46;
          else
            t1 = false;
        else
          t1 = false;
        if (t1)
          break;
        --backCount;
        baseEnd = newEnd;
      }
      return C.JSString_methods.replaceRange$3(base, baseEnd + 1, null, C.JSString_methods.substring$1(reference, refStart - 3 * backCount));
    },
    resolve$1: function(reference) {
      return this.resolveUri$1(P.Uri_parse(reference));
    },
    resolveUri$1: function(reference) {
      var targetScheme, targetUserInfo, targetHost, targetPort, targetPath, targetQuery, t1, mergedPath, t2, _this = this, _null = null;
      if (reference.get$scheme().length !== 0) {
        targetScheme = reference.get$scheme();
        if (reference.get$hasAuthority()) {
          targetUserInfo = reference.get$userInfo();
          targetHost = reference.get$host();
          targetPort = reference.get$hasPort() ? reference.get$port() : _null;
        } else {
          targetPort = _null;
          targetHost = targetPort;
          targetUserInfo = "";
        }
        targetPath = P._Uri__removeDotSegments(reference.get$path(reference));
        targetQuery = reference.get$hasQuery() ? reference.get$query() : _null;
      } else {
        targetScheme = _this.scheme;
        if (reference.get$hasAuthority()) {
          targetUserInfo = reference.get$userInfo();
          targetHost = reference.get$host();
          targetPort = P._Uri__makePort(reference.get$hasPort() ? reference.get$port() : _null, targetScheme);
          targetPath = P._Uri__removeDotSegments(reference.get$path(reference));
          targetQuery = reference.get$hasQuery() ? reference.get$query() : _null;
        } else {
          targetUserInfo = _this._userInfo;
          targetHost = _this._host;
          targetPort = _this._port;
          if (reference.get$path(reference) === "") {
            targetPath = _this.path;
            targetQuery = reference.get$hasQuery() ? reference.get$query() : _this._query;
          } else {
            if (reference.get$hasAbsolutePath())
              targetPath = P._Uri__removeDotSegments(reference.get$path(reference));
            else {
              t1 = _this.path;
              if (t1.length === 0)
                if (targetHost == null)
                  targetPath = targetScheme.length === 0 ? reference.get$path(reference) : P._Uri__removeDotSegments(reference.get$path(reference));
                else
                  targetPath = P._Uri__removeDotSegments("/" + reference.get$path(reference));
              else {
                mergedPath = _this._mergePaths$2(t1, reference.get$path(reference));
                t2 = targetScheme.length === 0;
                if (!t2 || targetHost != null || C.JSString_methods.startsWith$1(t1, "/"))
                  targetPath = P._Uri__removeDotSegments(mergedPath);
                else
                  targetPath = P._Uri__normalizeRelativePath(mergedPath, !t2 || targetHost != null);
              }
            }
            targetQuery = reference.get$hasQuery() ? reference.get$query() : _null;
          }
        }
      }
      return new P._Uri(targetScheme, targetUserInfo, targetHost, targetPort, targetPath, targetQuery, reference.get$hasFragment() ? reference.get$fragment() : _null);
    },
    get$hasAuthority: function() {
      return this._host != null;
    },
    get$hasPort: function() {
      return this._port != null;
    },
    get$hasQuery: function() {
      return this._query != null;
    },
    get$hasFragment: function() {
      return this._fragment != null;
    },
    get$hasAbsolutePath: function() {
      return C.JSString_methods.startsWith$1(this.path, "/");
    },
    toFilePath$0: function() {
      var windows, pathSegments, _this = this,
        t1 = _this.scheme;
      if (t1 !== "" && t1 !== "file")
        throw H.wrapException(P.UnsupportedError$("Cannot extract a file path from a " + H.S(t1) + " URI"));
      t1 = _this._query;
      if ((t1 == null ? "" : t1) !== "")
        throw H.wrapException(P.UnsupportedError$("Cannot extract a file path from a URI with a query component"));
      t1 = _this._fragment;
      if ((t1 == null ? "" : t1) !== "")
        throw H.wrapException(P.UnsupportedError$("Cannot extract a file path from a URI with a fragment component"));
      windows = $.$get$_Uri__isWindowsCached();
      if (windows)
        t1 = P._Uri__toWindowsFilePath(_this);
      else {
        if (_this._host != null && _this.get$host() !== "")
          H.throwExpression(P.UnsupportedError$("Cannot extract a non-Windows file path from a file URI with an authority"));
        pathSegments = _this.get$pathSegments();
        P._Uri__checkNonWindowsPathReservedCharacters(pathSegments, false);
        t1 = P.StringBuffer__writeAll(C.JSString_methods.startsWith$1(_this.path, "/") ? "/" : "", pathSegments, "/");
        t1 = t1.charCodeAt(0) == 0 ? t1 : t1;
      }
      return t1;
    },
    toString$0: function(_) {
      var t2, t3, t4, _this = this,
        t1 = _this._text;
      if (t1 == null) {
        t1 = _this.scheme;
        t2 = t1.length !== 0 ? H.S(t1) + ":" : "";
        t3 = _this._host;
        t4 = t3 == null;
        if (!t4 || t1 === "file") {
          t1 = t2 + "//";
          t2 = _this._userInfo;
          if (t2.length !== 0)
            t1 = t1 + H.S(t2) + "@";
          if (!t4)
            t1 += t3;
          t2 = _this._port;
          if (t2 != null)
            t1 = t1 + ":" + H.S(t2);
        } else
          t1 = t2;
        t1 += _this.path;
        t2 = _this._query;
        if (t2 != null)
          t1 = t1 + "?" + t2;
        t2 = _this._fragment;
        if (t2 != null)
          t1 = t1 + "#" + t2;
        t1 = _this._text = t1.charCodeAt(0) == 0 ? t1 : t1;
      }
      return t1;
    },
    $eq: function(_, other) {
      var t1, t2, _this = this;
      if (other == null)
        return false;
      if (_this === other)
        return true;
      if (!!J.getInterceptor$(other).$isUri)
        if (_this.scheme == other.get$scheme())
          if (_this._host != null === other.get$hasAuthority())
            if (_this._userInfo == other.get$userInfo())
              if (_this.get$host() == other.get$host())
                if (_this.get$port() == other.get$port())
                  if (_this.path === other.get$path(other)) {
                    t1 = _this._query;
                    t2 = t1 == null;
                    if (!t2 === other.get$hasQuery()) {
                      if (t2)
                        t1 = "";
                      if (t1 === other.get$query()) {
                        t1 = _this._fragment;
                        t2 = t1 == null;
                        if (!t2 === other.get$hasFragment()) {
                          if (t2)
                            t1 = "";
                          t1 = t1 === other.get$fragment();
                        } else
                          t1 = false;
                      } else
                        t1 = false;
                    } else
                      t1 = false;
                  } else
                    t1 = false;
                else
                  t1 = false;
              else
                t1 = false;
            else
              t1 = false;
          else
            t1 = false;
        else
          t1 = false;
      else
        t1 = false;
      return t1;
    },
    get$hashCode: function(_) {
      var t1 = this._hashCodeCache;
      return t1 == null ? this._hashCodeCache = C.JSString_methods.get$hashCode(this.toString$0(0)) : t1;
    },
    $isUri: 1,
    get$scheme: function() {
      return this.scheme;
    },
    get$path: function(receiver) {
      return this.path;
    }
  };
  P._Uri__Uri$notSimple_closure.prototype = {
    call$1: function(_) {
      throw H.wrapException(P.FormatException$("Invalid port", this.uri, this.portStart + 1));
    }
  };
  P._Uri__checkNonWindowsPathReservedCharacters_closure.prototype = {
    call$1: function(segment) {
      var _s23_ = "Illegal path character ";
      if (J.contains$1$asx(segment, "/"))
        if (this.argumentError)
          throw H.wrapException(P.ArgumentError$(_s23_ + segment));
        else
          throw H.wrapException(P.UnsupportedError$(_s23_ + segment));
    }
  };
  P._Uri__makePath_closure.prototype = {
    call$1: function(s) {
      return P._Uri__uriEncode(C.List_qg40, s, C.C_Utf8Codec, false);
    }
  };
  P.UriData.prototype = {
    get$uri: function() {
      var t2, queryIndex, end, query, _this = this, _null = null,
        t1 = _this._uriCache;
      if (t1 != null)
        return t1;
      t1 = _this._text;
      t2 = _this._separatorIndices[0] + 1;
      queryIndex = C.JSString_methods.indexOf$2(t1, "?", t2);
      end = t1.length;
      if (queryIndex >= 0) {
        query = P._Uri__normalizeOrSubstring(t1, queryIndex + 1, end, C.List_CVk, false);
        end = queryIndex;
      } else
        query = _null;
      return _this._uriCache = new P._DataUri("data", _null, _null, _null, P._Uri__normalizeOrSubstring(t1, t2, end, C.List_qg4, false), query, _null);
    },
    toString$0: function(_) {
      var t1 = this._text;
      return this._separatorIndices[0] === -1 ? "data:" + t1 : t1;
    }
  };
  P._createTables_closure.prototype = {
    call$1: function(_) {
      return new Uint8Array(96);
    },
    $signature: 58
  };
  P._createTables_build.prototype = {
    call$2: function(state, defaultTransition) {
      var t1 = this.tables[state];
      J.fillRange$3$ax(t1, 0, 96, defaultTransition);
      return t1;
    },
    $signature: 38
  };
  P._createTables_setChars.prototype = {
    call$3: function(target, chars, transition) {
      var t1, i;
      for (t1 = chars.length, i = 0; i < t1; ++i)
        target[C.JSString_methods._codeUnitAt$1(chars, i) ^ 96] = transition;
    }
  };
  P._createTables_setRange.prototype = {
    call$3: function(target, range, transition) {
      var i, n;
      for (i = C.JSString_methods._codeUnitAt$1(range, 0), n = C.JSString_methods._codeUnitAt$1(range, 1); i <= n; ++i)
        target[(i ^ 96) >>> 0] = transition;
    }
  };
  P._SimpleUri.prototype = {
    get$hasAuthority: function() {
      return this._hostStart > 0;
    },
    get$hasPort: function() {
      return this._hostStart > 0 && this._portStart + 1 < this._pathStart;
    },
    get$hasQuery: function() {
      return this._queryStart < this._fragmentStart;
    },
    get$hasFragment: function() {
      return this._fragmentStart < this._uri.length;
    },
    get$_isFile: function() {
      return this._schemeEnd === 4 && C.JSString_methods.startsWith$1(this._uri, "file");
    },
    get$_isHttp: function() {
      return this._schemeEnd === 4 && C.JSString_methods.startsWith$1(this._uri, "http");
    },
    get$_isHttps: function() {
      return this._schemeEnd === 5 && C.JSString_methods.startsWith$1(this._uri, "https");
    },
    get$hasAbsolutePath: function() {
      return C.JSString_methods.startsWith$2(this._uri, "/", this._pathStart);
    },
    get$scheme: function() {
      var t2, _this = this,
        _s7_ = "package",
        t1 = _this._schemeEnd;
      if (t1 <= 0)
        return "";
      t2 = _this._schemeCache;
      if (t2 != null)
        return t2;
      if (_this.get$_isHttp())
        t1 = _this._schemeCache = "http";
      else if (_this.get$_isHttps()) {
        _this._schemeCache = "https";
        t1 = "https";
      } else if (_this.get$_isFile()) {
        _this._schemeCache = "file";
        t1 = "file";
      } else if (t1 === 7 && C.JSString_methods.startsWith$1(_this._uri, _s7_)) {
        _this._schemeCache = _s7_;
        t1 = _s7_;
      } else {
        t1 = C.JSString_methods.substring$2(_this._uri, 0, t1);
        _this._schemeCache = t1;
      }
      return t1;
    },
    get$userInfo: function() {
      var t1 = this._hostStart,
        t2 = this._schemeEnd + 3;
      return t1 > t2 ? C.JSString_methods.substring$2(this._uri, t2, t1 - 1) : "";
    },
    get$host: function() {
      var t1 = this._hostStart;
      return t1 > 0 ? C.JSString_methods.substring$2(this._uri, t1, this._portStart) : "";
    },
    get$port: function() {
      var _this = this;
      if (_this.get$hasPort())
        return P.int_parse(C.JSString_methods.substring$2(_this._uri, _this._portStart + 1, _this._pathStart), null, null);
      if (_this.get$_isHttp())
        return 80;
      if (_this.get$_isHttps())
        return 443;
      return 0;
    },
    get$path: function(_) {
      return C.JSString_methods.substring$2(this._uri, this._pathStart, this._queryStart);
    },
    get$query: function() {
      var t1 = this._queryStart,
        t2 = this._fragmentStart;
      return t1 < t2 ? C.JSString_methods.substring$2(this._uri, t1 + 1, t2) : "";
    },
    get$fragment: function() {
      var t1 = this._fragmentStart,
        t2 = this._uri;
      return t1 < t2.length ? C.JSString_methods.substring$1(t2, t1 + 1) : "";
    },
    get$pathSegments: function() {
      var t2, parts, i,
        start = this._pathStart,
        end = this._queryStart,
        t1 = this._uri;
      if (C.JSString_methods.startsWith$2(t1, "/", start))
        ++start;
      if (start == end)
        return C.List_empty;
      t2 = P.String;
      parts = H.setRuntimeTypeInfo([], [t2]);
      for (i = start; i < end; ++i)
        if (C.JSString_methods.codeUnitAt$1(t1, i) === 47) {
          parts.push(C.JSString_methods.substring$2(t1, start, i));
          start = i + 1;
        }
      parts.push(C.JSString_methods.substring$2(t1, start, end));
      return P.List_List$unmodifiable(parts, t2);
    },
    _isPort$1: function(port) {
      var portDigitStart = this._portStart + 1;
      return portDigitStart + port.length === this._pathStart && C.JSString_methods.startsWith$2(this._uri, port, portDigitStart);
    },
    removeFragment$0: function() {
      var _this = this,
        t1 = _this._fragmentStart,
        t2 = _this._uri;
      if (t1 >= t2.length)
        return _this;
      return new P._SimpleUri(C.JSString_methods.substring$2(t2, 0, t1), _this._schemeEnd, _this._hostStart, _this._portStart, _this._pathStart, _this._queryStart, t1, _this._schemeCache);
    },
    resolve$1: function(reference) {
      return this.resolveUri$1(P.Uri_parse(reference));
    },
    resolveUri$1: function(reference) {
      if (reference instanceof P._SimpleUri)
        return this._simpleMerge$2(this, reference);
      return this._toNonSimple$0().resolveUri$1(reference);
    },
    _simpleMerge$2: function(base, ref) {
      var t2, t3, isSimple, delta, refStart, baseStart, baseEnd, baseUri, baseStart0, backCount, refStart0, insert,
        t1 = ref._schemeEnd;
      if (t1 > 0)
        return ref;
      t2 = ref._hostStart;
      if (t2 > 0) {
        t3 = base._schemeEnd;
        if (t3 <= 0)
          return ref;
        if (base.get$_isFile())
          isSimple = ref._pathStart != ref._queryStart;
        else if (base.get$_isHttp())
          isSimple = !ref._isPort$1("80");
        else
          isSimple = !base.get$_isHttps() || !ref._isPort$1("443");
        if (isSimple) {
          delta = t3 + 1;
          return new P._SimpleUri(C.JSString_methods.substring$2(base._uri, 0, delta) + C.JSString_methods.substring$1(ref._uri, t1 + 1), t3, t2 + delta, ref._portStart + delta, ref._pathStart + delta, ref._queryStart + delta, ref._fragmentStart + delta, base._schemeCache);
        } else
          return this._toNonSimple$0().resolveUri$1(ref);
      }
      refStart = ref._pathStart;
      t1 = ref._queryStart;
      if (refStart == t1) {
        t2 = ref._fragmentStart;
        if (t1 < t2) {
          t3 = base._queryStart;
          delta = t3 - t1;
          return new P._SimpleUri(C.JSString_methods.substring$2(base._uri, 0, t3) + C.JSString_methods.substring$1(ref._uri, t1), base._schemeEnd, base._hostStart, base._portStart, base._pathStart, t1 + delta, t2 + delta, base._schemeCache);
        }
        t1 = ref._uri;
        if (t2 < t1.length) {
          t3 = base._fragmentStart;
          return new P._SimpleUri(C.JSString_methods.substring$2(base._uri, 0, t3) + C.JSString_methods.substring$1(t1, t2), base._schemeEnd, base._hostStart, base._portStart, base._pathStart, base._queryStart, t2 + (t3 - t2), base._schemeCache);
        }
        return base.removeFragment$0();
      }
      t2 = ref._uri;
      if (C.JSString_methods.startsWith$2(t2, "/", refStart)) {
        t3 = base._pathStart;
        delta = t3 - refStart;
        return new P._SimpleUri(C.JSString_methods.substring$2(base._uri, 0, t3) + C.JSString_methods.substring$1(t2, refStart), base._schemeEnd, base._hostStart, base._portStart, t3, t1 + delta, ref._fragmentStart + delta, base._schemeCache);
      }
      baseStart = base._pathStart;
      baseEnd = base._queryStart;
      if (baseStart == baseEnd && base._hostStart > 0) {
        for (; C.JSString_methods.startsWith$2(t2, "../", refStart);)
          refStart += 3;
        delta = baseStart - refStart + 1;
        return new P._SimpleUri(C.JSString_methods.substring$2(base._uri, 0, baseStart) + "/" + C.JSString_methods.substring$1(t2, refStart), base._schemeEnd, base._hostStart, base._portStart, baseStart, t1 + delta, ref._fragmentStart + delta, base._schemeCache);
      }
      baseUri = base._uri;
      for (baseStart0 = baseStart; C.JSString_methods.startsWith$2(baseUri, "../", baseStart0);)
        baseStart0 += 3;
      backCount = 0;
      while (true) {
        refStart0 = refStart + 3;
        if (!(refStart0 <= t1 && C.JSString_methods.startsWith$2(t2, "../", refStart)))
          break;
        ++backCount;
        refStart = refStart0;
      }
      for (insert = ""; baseEnd > baseStart0;) {
        --baseEnd;
        if (C.JSString_methods.codeUnitAt$1(baseUri, baseEnd) === 47) {
          if (backCount === 0) {
            insert = "/";
            break;
          }
          --backCount;
          insert = "/";
        }
      }
      if (baseEnd === baseStart0 && base._schemeEnd <= 0 && !C.JSString_methods.startsWith$2(baseUri, "/", baseStart)) {
        refStart -= backCount * 3;
        insert = "";
      }
      delta = baseEnd - refStart + insert.length;
      return new P._SimpleUri(C.JSString_methods.substring$2(baseUri, 0, baseEnd) + insert + C.JSString_methods.substring$1(t2, refStart), base._schemeEnd, base._hostStart, base._portStart, baseStart, t1 + delta, ref._fragmentStart + delta, base._schemeCache);
    },
    toFilePath$0: function() {
      var t1, t2, windows, _this = this;
      if (_this._schemeEnd >= 0 && !_this.get$_isFile())
        throw H.wrapException(P.UnsupportedError$("Cannot extract a file path from a " + H.S(_this.get$scheme()) + " URI"));
      t1 = _this._queryStart;
      t2 = _this._uri;
      if (t1 < t2.length) {
        if (t1 < _this._fragmentStart)
          throw H.wrapException(P.UnsupportedError$("Cannot extract a file path from a URI with a query component"));
        throw H.wrapException(P.UnsupportedError$("Cannot extract a file path from a URI with a fragment component"));
      }
      windows = $.$get$_Uri__isWindowsCached();
      if (windows)
        t1 = P._Uri__toWindowsFilePath(_this);
      else {
        if (_this._hostStart < _this._portStart)
          H.throwExpression(P.UnsupportedError$("Cannot extract a non-Windows file path from a file URI with an authority"));
        t1 = C.JSString_methods.substring$2(t2, _this._pathStart, t1);
      }
      return t1;
    },
    get$hashCode: function(_) {
      var t1 = this._hashCodeCache;
      return t1 == null ? this._hashCodeCache = C.JSString_methods.get$hashCode(this._uri) : t1;
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      if (this === other)
        return true;
      return !!J.getInterceptor$(other).$isUri && this._uri === other.toString$0(0);
    },
    _toNonSimple$0: function() {
      var _this = this, _null = null,
        t1 = _this.get$scheme(),
        t2 = _this.get$userInfo(),
        t3 = _this._hostStart > 0 ? _this.get$host() : _null,
        t4 = _this.get$hasPort() ? _this.get$port() : _null,
        t5 = _this._uri,
        t6 = _this._queryStart,
        t7 = C.JSString_methods.substring$2(t5, _this._pathStart, t6),
        t8 = _this._fragmentStart;
      t6 = t6 < t8 ? _this.get$query() : _null;
      return new P._Uri(t1, t2, t3, t4, t7, t6, t8 < t5.length ? _this.get$fragment() : _null);
    },
    toString$0: function(_) {
      return this._uri;
    },
    $isUri: 1
  };
  P._DataUri.prototype = {};
  P._JSRandom.prototype = {
    nextInt$1: function(max) {
      if (max <= 0 || max > 4294967296)
        throw H.wrapException(P.RangeError$("max must be in range 0 < max \u2264 2^32, was " + max));
      return Math.random() * max >>> 0;
    },
    nextDouble$0: function() {
      return Math.random();
    }
  };
  P.Uint8List.prototype = {$isEfficientLengthIterable: 1,
    $asEfficientLengthIterable: function() {
      return [P.int];
    },
    $isIterable: 1,
    $asIterable: function() {
      return [P.int];
    },
    $isList: 1,
    $asList: function() {
      return [P.int];
    }
  };
  N.ArgParser.prototype = {
    addFlag$6$abbr$defaultsTo$help$hide$negatable: function($name, abbr, defaultsTo, help, hide, negatable) {
      var _null = null;
      this._addOption$11$hide$negatable($name, abbr, help, _null, _null, _null, defaultsTo, _null, C.OptionType_nMZ, hide, negatable);
    },
    addFlag$2$hide: function($name, hide) {
      return this.addFlag$6$abbr$defaultsTo$help$hide$negatable($name, null, false, null, hide, true);
    },
    addFlag$2$help: function($name, help) {
      return this.addFlag$6$abbr$defaultsTo$help$hide$negatable($name, null, false, help, false, true);
    },
    addFlag$3$defaultsTo$help: function($name, defaultsTo, help) {
      return this.addFlag$6$abbr$defaultsTo$help$hide$negatable($name, null, defaultsTo, help, false, true);
    },
    addFlag$3$help$negatable: function($name, help, negatable) {
      return this.addFlag$6$abbr$defaultsTo$help$hide$negatable($name, null, false, help, false, negatable);
    },
    addFlag$4$abbr$help$negatable: function($name, abbr, help, negatable) {
      return this.addFlag$6$abbr$defaultsTo$help$hide$negatable($name, abbr, false, help, false, negatable);
    },
    addFlag$3$abbr$help: function($name, abbr, help) {
      return this.addFlag$6$abbr$defaultsTo$help$hide$negatable($name, abbr, false, help, false, true);
    },
    addOption$7$abbr$allowed$defaultsTo$help$hide$valueHelp: function($name, abbr, allowed, defaultsTo, help, hide, valueHelp) {
      this._addOption$11$hide$splitCommas($name, abbr, help, valueHelp, allowed, null, defaultsTo, null, C.OptionType_YwU, hide, null);
    },
    addOption$2$hide: function($name, hide) {
      return this.addOption$7$abbr$allowed$defaultsTo$help$hide$valueHelp($name, null, null, null, null, hide, null);
    },
    addOption$6$abbr$allowed$defaultsTo$help$valueHelp: function($name, abbr, allowed, defaultsTo, help, valueHelp) {
      return this.addOption$7$abbr$allowed$defaultsTo$help$hide$valueHelp($name, abbr, allowed, defaultsTo, help, false, valueHelp);
    },
    addOption$4$allowed$defaultsTo$help: function($name, allowed, defaultsTo, help) {
      return this.addOption$7$abbr$allowed$defaultsTo$help$hide$valueHelp($name, null, allowed, defaultsTo, help, false, null);
    },
    addMultiOption$5$abbr$help$splitCommas$valueHelp: function($name, abbr, help, splitCommas, valueHelp) {
      var t1 = H.setRuntimeTypeInfo([], [P.String]);
      this._addOption$11$hide$splitCommas($name, abbr, help, valueHelp, null, null, t1, null, C.OptionType_qyr, false, false);
    },
    _addOption$12$hide$negatable$splitCommas: function($name, abbr, help, valueHelp, allowed, allowedHelp, defaultsTo, callback, type, hide, negatable, splitCommas) {
      var t2, existing, t3, option,
        t1 = this._arg_parser$_options;
      if (t1.containsKey$1($name))
        throw H.wrapException(P.ArgumentError$('Duplicate option "' + $name + '".'));
      t2 = abbr != null;
      if (t2) {
        existing = this.findByAbbreviation$1(abbr);
        if (existing != null)
          throw H.wrapException(P.ArgumentError$('Abbreviation "' + abbr + '" is already used by "' + existing.name + '".'));
      }
      t3 = allowed == null ? null : P.List_List$unmodifiable(allowed, P.String);
      option = new G.Option($name, abbr, help, valueHelp, t3, null, defaultsTo, negatable, callback, type, splitCommas == null ? type === C.OptionType_qyr : splitCommas, hide);
      if ($name.length === 0)
        H.throwExpression(P.ArgumentError$("Name cannot be empty."));
      else if (C.JSString_methods.startsWith$1($name, "-"))
        H.throwExpression(P.ArgumentError$("Name " + $name + ' cannot start with "-".'));
      t3 = $.$get$Option__invalidChars()._nativeRegExp;
      if (t3.test($name))
        H.throwExpression(P.ArgumentError$('Name "' + $name + '" contains invalid characters.'));
      if (t2) {
        if (abbr.length !== 1)
          H.throwExpression(P.ArgumentError$("Abbreviation must be null or have length 1."));
        else if (abbr === "-")
          H.throwExpression(P.ArgumentError$('Abbreviation cannot be "-".'));
        if (t3.test(abbr))
          H.throwExpression(P.ArgumentError$("Abbreviation is an invalid character."));
      }
      t1.$indexSet(0, $name, option);
      this._optionsAndSeparators.push(option);
    },
    _addOption$11$hide$splitCommas: function($name, abbr, help, valueHelp, allowed, allowedHelp, defaultsTo, callback, type, hide, splitCommas) {
      return this._addOption$12$hide$negatable$splitCommas($name, abbr, help, valueHelp, allowed, allowedHelp, defaultsTo, callback, type, hide, false, splitCommas);
    },
    _addOption$11$hide$negatable: function($name, abbr, help, valueHelp, allowed, allowedHelp, defaultsTo, callback, type, hide, negatable) {
      return this._addOption$12$hide$negatable$splitCommas($name, abbr, help, valueHelp, allowed, allowedHelp, defaultsTo, callback, type, hide, negatable, null);
    },
    findByAbbreviation$1: function(abbr) {
      return this.options._collection$_map.get$values().firstWhere$2$orElse(0, new N.ArgParser_findByAbbreviation_closure(abbr), new N.ArgParser_findByAbbreviation_closure0());
    }
  };
  N.ArgParser_findByAbbreviation_closure.prototype = {
    call$1: function(option) {
      return option.abbr == this.abbr;
    }
  };
  N.ArgParser_findByAbbreviation_closure0.prototype = {
    call$0: function() {
      return;
    }
  };
  Z.ArgParserException.prototype = {};
  V.ArgResults.prototype = {
    $index: function(_, $name) {
      var t1 = this._parser.options._collection$_map;
      if (!t1.containsKey$1($name))
        throw H.wrapException(P.ArgumentError$('Could not find an option named "' + $name + '".'));
      return t1.$index(0, $name).getOrDefault$1(this._parsed.$index(0, $name));
    },
    wasParsed$1: function($name) {
      if (this._parser.options._collection$_map.$index(0, $name) == null)
        throw H.wrapException(P.ArgumentError$('Could not find an option named "' + H.S($name) + '".'));
      return this._parsed.containsKey$1($name);
    }
  };
  G.Option.prototype = {
    getOrDefault$1: function(value) {
      var t1;
      if (value != null)
        return value;
      if (this.type === C.OptionType_qyr) {
        t1 = this.defaultsTo;
        return t1 == null ? H.setRuntimeTypeInfo([], [P.String]) : t1;
      }
      return this.defaultsTo;
    }
  };
  G.OptionType.prototype = {};
  G.Parser0.prototype = {
    parse$0: function() {
      var commandName, commandParser, error, t3, t4, t5, t6, t7, command, exception, _this = this,
        t1 = _this.args,
        t2 = H.setRuntimeTypeInfo(t1.slice(0), [H.getTypeArgumentByIndex(t1, 0)]),
        commandResults = null;
      for (t3 = _this.rest, t4 = _this.grammar, t5 = !t4.allowTrailingOptions, t6 = t4.commands._collection$_map; t1.length !== 0;) {
        t7 = t1[0];
        if (t7 === "--") {
          C.JSArray_methods.removeAt$1(t1, 0);
          break;
        }
        command = t6.$index(0, t7);
        if (command != null) {
          if (t3.length !== 0)
            H.throwExpression(Z.ArgParserException$("Cannot specify arguments before a command.", null));
          commandName = C.JSArray_methods.removeAt$1(t1, 0);
          t5 = P.String;
          t6 = [t5];
          t7 = H.setRuntimeTypeInfo([], t6);
          C.JSArray_methods.addAll$1(t7, t3);
          commandParser = new G.Parser0(commandName, _this, command, t1, t7, P.LinkedHashMap_LinkedHashMap$_empty(t5, null));
          try {
            commandResults = commandParser.parse$0();
          } catch (exception) {
            t1 = H.unwrapException(exception);
            if (t1 instanceof Z.ArgParserException) {
              error = t1;
              if (commandName == null)
                throw exception;
              t1 = error.message;
              t6 = H.setRuntimeTypeInfo([commandName], t6);
              C.JSArray_methods.addAll$1(t6, error.commands);
              throw H.wrapException(Z.ArgParserException$(t1, t6));
            } else
              throw exception;
          }
          C.JSArray_methods.set$length(t3, 0);
          break;
        }
        if (_this.parseSoloOption$0())
          continue;
        if (_this.parseAbbreviation$1(_this))
          continue;
        if (_this.parseLongOption$0())
          continue;
        if (t5)
          break;
        t3.push(C.JSArray_methods.removeAt$1(t1, 0));
      }
      t4.options._collection$_map.forEach$1(0, new G.Parser_parse_closure(_this));
      C.JSArray_methods.addAll$1(t3, t1);
      C.JSArray_methods.set$length(t1, 0);
      return V.ArgResults$_(t4, _this.results, _this.commandName, commandResults, t3, t2);
    },
    readNextArgAsValue$1: function(option) {
      var t1 = this.args,
        t2 = t1.length,
        t3 = 'Missing argument for "' + option.name + '".';
      if (t2 === 0)
        H.throwExpression(Z.ArgParserException$(t3, null));
      this.setOption$3(this.results, option, t1[0]);
      C.JSArray_methods.removeAt$1(t1, 0);
    },
    parseSoloOption$0: function() {
      var t2, option, _this = this,
        t1 = _this.args,
        soloOpt = $.$get$_soloOpt().firstMatch$1(t1[0]);
      if (soloOpt == null)
        return false;
      t2 = soloOpt._match;
      option = _this.grammar.findByAbbreviation$1(t2[1]);
      if (option == null) {
        t1 = _this.parent;
        t2 = 'Could not find an option or flag "-' + H.S(t2[1]) + '".';
        if (t1 == null)
          H.throwExpression(Z.ArgParserException$(t2, null));
        return t1.parseSoloOption$0();
      }
      C.JSArray_methods.removeAt$1(t1, 0);
      if (option.type === C.OptionType_nMZ)
        _this.results.$indexSet(0, option.name, true);
      else
        _this.readNextArgAsValue$1(option);
      return true;
    },
    parseAbbreviation$1: function(innermostCommand) {
      var t2, c, first, t3, t4, i, i0, _this = this,
        t1 = _this.args,
        abbrOpt = $.$get$_abbrOpt().firstMatch$1(t1[0]);
      if (abbrOpt == null)
        return false;
      t2 = abbrOpt._match;
      c = J.substring$2$s(t2[1], 0, 1);
      first = _this.grammar.findByAbbreviation$1(c);
      if (first == null) {
        t1 = _this.parent;
        t2 = 'Could not find an option with short name "-' + c + '".';
        if (t1 == null)
          H.throwExpression(Z.ArgParserException$(t2, null));
        return t1.parseAbbreviation$1(innermostCommand);
      } else if (first.type !== C.OptionType_nMZ)
        _this.setOption$3(_this.results, first, J.substring$1$s(t2[1], 1) + H.S(t2[2]));
      else {
        t3 = t2[2];
        t4 = 'Option "-' + c + '" is a flag and cannot handle value "' + J.substring$1$s(t2[1], 1) + H.S(t3) + '".';
        if (t3 !== "")
          H.throwExpression(Z.ArgParserException$(t4, null));
        for (i = 0; t3 = t2[1], i < t3.length; i = i0) {
          i0 = i + 1;
          innermostCommand.parseShortFlag$1(J.substring$2$s(t3, i, i0));
        }
      }
      C.JSArray_methods.removeAt$1(t1, 0);
      return true;
    },
    parseShortFlag$1: function(c) {
      var t1, t2,
        option = this.grammar.findByAbbreviation$1(c);
      if (option == null) {
        t1 = this.parent;
        t2 = 'Could not find an option with short name "-' + c + '".';
        if (t1 == null)
          H.throwExpression(Z.ArgParserException$(t2, null));
        t1.parseShortFlag$1(c);
        return;
      }
      t1 = option.type;
      t2 = 'Option "-' + c + '" must be a flag to be in a collapsed "-".';
      if (t1 !== C.OptionType_nMZ)
        H.throwExpression(Z.ArgParserException$(t2, null));
      this.results.$indexSet(0, option.name, true);
    },
    parseLongOption$0: function() {
      var t2, $name, t3, option, _this = this, _null = null,
        _s32_ = 'Could not find an option named "',
        t1 = _this.args,
        longOpt = $.$get$_longOpt().firstMatch$1(t1[0]);
      if (longOpt == null)
        return false;
      t2 = longOpt._match;
      $name = t2[1];
      t3 = _this.grammar.options._collection$_map;
      option = t3.$index(0, $name);
      if (option != null) {
        C.JSArray_methods.removeAt$1(t1, 0);
        if (option.type === C.OptionType_nMZ) {
          t1 = t2[3];
          t2 = 'Flag option "' + H.S($name) + '" should not be given a value.';
          if (t1 != null)
            H.throwExpression(Z.ArgParserException$(t2, _null));
          _this.results.$indexSet(0, option.name, true);
        } else {
          t1 = t2[3];
          if (t1 != null)
            _this.setOption$3(_this.results, option, t1);
          else
            _this.readNextArgAsValue$1(option);
        }
      } else if (J.getInterceptor$s($name).startsWith$1($name, "no-")) {
        $name = C.JSString_methods.substring$1($name, 3);
        option = t3.$index(0, $name);
        if (option == null) {
          t1 = _this.parent;
          t2 = _s32_ + $name + '".';
          if (t1 == null)
            H.throwExpression(Z.ArgParserException$(t2, _null));
          return t1.parseLongOption$0();
        }
        C.JSArray_methods.removeAt$1(t1, 0);
        t1 = option.type;
        t2 = 'Cannot negate non-flag option "' + $name + '".';
        if (t1 !== C.OptionType_nMZ)
          H.throwExpression(Z.ArgParserException$(t2, _null));
        t1 = option.negatable;
        t2 = 'Cannot negate option "' + $name + '".';
        if (!t1)
          H.throwExpression(Z.ArgParserException$(t2, _null));
        _this.results.$indexSet(0, option.name, false);
      } else {
        t1 = _this.parent;
        t2 = _s32_ + $name + '".';
        if (t1 == null)
          H.throwExpression(Z.ArgParserException$(t2, _null));
        return t1.parseLongOption$0();
      }
      return true;
    },
    setOption$3: function(results, option, value) {
      var list, t1, t2, t3, _i, element;
      if (option.type !== C.OptionType_qyr) {
        this._validateAllowed$2(option, value);
        results.$indexSet(0, option.name, value);
        return;
      }
      list = results.putIfAbsent$2(option.name, new G.Parser_setOption_closure());
      if (option.splitCommas)
        for (t1 = value.split(","), t2 = t1.length, t3 = J.getInterceptor$ax(list), _i = 0; _i < t2; ++_i) {
          element = t1[_i];
          this._validateAllowed$2(option, element);
          t3.add$1(list, element);
        }
      else {
        this._validateAllowed$2(option, value);
        J.add$1$ax(list, value);
      }
    },
    _validateAllowed$2: function(option, value) {
      var t2,
        t1 = option.allowed;
      if (t1 == null)
        return;
      t1 = C.JSArray_methods.contains$1(t1, value);
      t2 = '"' + H.S(value) + '" is not an allowed value for option "' + option.name + '".';
      if (!t1)
        H.throwExpression(Z.ArgParserException$(t2, null));
    }
  };
  G.Parser_parse_closure.prototype = {
    call$2: function($name, option) {
      var t1 = option.callback;
      if (t1 == null)
        return;
      t1.call$1(option.getOrDefault$1(this.$this.results.$index(0, $name)));
    }
  };
  G.Parser_setOption_closure.prototype = {
    call$0: function() {
      return H.setRuntimeTypeInfo([], [P.String]);
    }
  };
  G.Usage.prototype = {
    generate$0: function() {
      var t1, t2, _i, optionOrSeparator, t3, t4, allowedNames, t5, t6, _i0, $name, isDefault, t7, _this = this;
      _this.buffer = new P.StringBuffer("");
      _this.calculateColumnWidths$0();
      for (t1 = _this.optionsAndSeparators, t2 = t1.length, _i = 0; _i < t1.length; t1.length === t2 || (0, H.throwConcurrentModificationError)(t1), ++_i) {
        optionOrSeparator = t1[_i];
        if (typeof optionOrSeparator === "string") {
          t3 = _this.buffer;
          t4 = t3._contents;
          t3._contents = (t4.length !== 0 ? t3._contents = t4 + "\n\n" : t4) + optionOrSeparator;
          _this.newlinesNeeded = 1;
          continue;
        }
        H.interceptedTypeCast(optionOrSeparator, "$isOption");
        if (optionOrSeparator.hide)
          continue;
        t3 = optionOrSeparator.abbr;
        _this.write$2(0, 0, t3 == null ? "" : "-" + t3 + ", ");
        _this.write$2(0, 1, _this.getLongOption$1(optionOrSeparator));
        t3 = optionOrSeparator.help;
        if (t3 != null)
          _this.write$2(0, 2, t3);
        t3 = optionOrSeparator.allowedHelp;
        if (t3 != null) {
          allowedNames = J.toList$1$growable$ax(t3.get$keys(), false);
          if (!!allowedNames.immutable$list)
            H.throwExpression(P.UnsupportedError$("sort"));
          t4 = allowedNames.length - 1;
          if (t4 - 0 <= 32)
            H.Sort__insertionSort(allowedNames, 0, t4, J._interceptors_JSArray__compareAny$closure());
          else
            H.Sort__dualPivotQuicksort(allowedNames, 0, t4, J._interceptors_JSArray__compareAny$closure());
          ++_this.newlinesNeeded;
          _this.numHelpLines = _this.currentColumn = 0;
          for (t4 = allowedNames.length, t5 = optionOrSeparator.defaultsTo, t6 = !!J.getInterceptor$(t5).$isList, _i0 = 0; _i0 < allowedNames.length; allowedNames.length === t4 || (0, H.throwConcurrentModificationError)(allowedNames), ++_i0) {
            $name = allowedNames[_i0];
            isDefault = t6 ? C.JSArray_methods.contains$1(t5, $name) : t5 == null ? $name == null : t5 === $name;
            t7 = "      [" + H.S($name) + "]";
            _this.write$2(0, 1, t7 + (isDefault ? " (default)" : ""));
            _this.write$2(0, 2, t3.$index(0, $name));
          }
          ++_this.newlinesNeeded;
          _this.numHelpLines = _this.currentColumn = 0;
        } else if (optionOrSeparator.allowed != null)
          _this.write$2(0, 2, _this.buildAllowedList$1(optionOrSeparator));
        else {
          t3 = optionOrSeparator.type;
          if (t3 === C.OptionType_nMZ) {
            if (optionOrSeparator.defaultsTo === true)
              _this.write$2(0, 2, "(defaults to on)");
          } else if (t3 === C.OptionType_qyr) {
            t3 = optionOrSeparator.defaultsTo;
            if (t3 != null && J.get$isNotEmpty$asx(t3))
              _this.write$2(0, 2, "(defaults to " + J.map$1$ax(t3, new G.Usage_generate_closure()).join$1(0, ", ") + ")");
          } else {
            t3 = optionOrSeparator.defaultsTo;
            if (t3 != null)
              _this.write$2(0, 2, '(defaults to "' + H.S(t3) + '")');
          }
        }
        if (_this.numHelpLines > 1) {
          ++_this.newlinesNeeded;
          _this.numHelpLines = _this.currentColumn = 0;
        }
      }
      return J.toString$0$(_this.buffer);
    },
    getLongOption$1: function(option) {
      var t1 = option.name,
        result = option.negatable ? "--[no-]" + t1 : "--" + t1;
      t1 = option.valueHelp;
      return t1 != null ? result + ("=<" + t1 + ">") : result;
    },
    calculateColumnWidths$0: function() {
      var t1, t2, abbr, title, _i, option, t3, t4, t5, allowed, isDefault, t6;
      for (t1 = this.optionsAndSeparators, t2 = t1.length, abbr = 0, title = 0, _i = 0; _i < t1.length; t1.length === t2 || (0, H.throwConcurrentModificationError)(t1), ++_i) {
        option = t1[_i];
        if (!(option instanceof G.Option))
          continue;
        if (option.hide)
          continue;
        t3 = option.abbr;
        abbr = Math.max(abbr, (t3 == null ? "" : "-" + t3 + ", ").length);
        title = Math.max(title, this.getLongOption$1(option).length);
        t3 = option.allowedHelp;
        if (t3 != null)
          for (t3 = J.get$iterator$ax(t3.get$keys()), t4 = option.defaultsTo, t5 = !!J.getInterceptor$(t4).$isList; t3.moveNext$0();) {
            allowed = t3.get$current(t3);
            isDefault = t5 ? C.JSArray_methods.contains$1(t4, allowed) : t4 == null ? allowed == null : t4 === allowed;
            t6 = "      [" + H.S(allowed) + "]";
            title = Math.max(title, (t6 + (isDefault ? " (default)" : "")).length);
          }
      }
      this.columnWidths = H.setRuntimeTypeInfo([abbr, title + 4], [P.int]);
    },
    write$2: function(_, column, text) {
      var t1, _i,
        lines = H.setRuntimeTypeInfo(text.split("\n"), [P.String]);
      this.columnWidths.length;
      while (true) {
        if (!(lines.length !== 0 && J.trim$0$s(lines[0]) === ""))
          break;
        if (!!lines.fixed$length)
          H.throwExpression(P.UnsupportedError$("removeRange"));
        P.RangeError_checkValidRange(0, 1, lines.length);
        lines.splice(0, 1);
      }
      while (true) {
        t1 = lines.length;
        if (!(t1 !== 0 && J.trim$0$s(lines[t1 - 1]) === ""))
          break;
        lines.pop();
      }
      for (t1 = lines.length, _i = 0; _i < lines.length; lines.length === t1 || (0, H.throwConcurrentModificationError)(lines), ++_i)
        this.writeLine$2(column, lines[_i]);
    },
    writeLine$2: function(column, text) {
      var t1, t2, _this = this;
      for (; t1 = _this.newlinesNeeded, t1 > 0;) {
        _this.buffer._contents += "\n";
        _this.newlinesNeeded = t1 - 1;
      }
      for (; t1 = _this.currentColumn, t1 !== column;) {
        t2 = _this.buffer;
        if (t1 < 2)
          t2._contents += C.JSString_methods.$mul(" ", _this.columnWidths[t1]);
        else
          t2._contents += "\n";
        _this.currentColumn = (_this.currentColumn + 1) % 3;
      }
      t1 = _this.columnWidths;
      t1.length;
      t2 = _this.buffer;
      if (column < 2)
        t2._contents += J.padRight$1$s(text, t1[column]);
      else {
        t2.toString;
        t2._contents += H.S(text);
      }
      _this.currentColumn = (_this.currentColumn + 1) % 3;
      t1 = column === 2;
      if (t1)
        ++_this.newlinesNeeded;
      if (t1)
        ++_this.numHelpLines;
      else
        _this.numHelpLines = 0;
    },
    buildAllowedList$1: function(option) {
      var t2, first, _i, t3, allowed,
        t1 = option.defaultsTo,
        isDefault = !!J.getInterceptor$(t1).$isList ? C.JSArray_methods.get$contains(t1) : new G.Usage_buildAllowedList_closure(option);
      for (t1 = option.allowed, t2 = t1.length, first = true, _i = 0, t3 = "["; _i < t2; ++_i, first = false) {
        allowed = t1[_i];
        if (!first)
          t3 += ", ";
        t3 += H.S(allowed);
        if (isDefault.call$1(allowed))
          t3 += " (default)";
      }
      t1 = t3 + "]";
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    }
  };
  G.Usage_generate_closure.prototype = {
    call$1: function(value) {
      return '"' + H.S(value) + '"';
    },
    $signature: 40
  };
  G.Usage_buildAllowedList_closure.prototype = {
    call$1: function(value) {
      var t1 = this.option.defaultsTo;
      return value == null ? t1 == null : value === t1;
    },
    $signature: 21
  };
  V.ErrorResult.prototype = {
    complete$1: function(completer) {
      completer.completeError$2(this.error, this.stackTrace);
    },
    get$hashCode: function(_) {
      return (J.get$hashCode$(this.error) ^ J.get$hashCode$(this.stackTrace) ^ 492929599) >>> 0;
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof V.ErrorResult && J.$eq$(this.error, other.error) && this.stackTrace == other.stackTrace;
    },
    $isResult: 1,
    $asResult: function() {
      return [P.Null];
    }
  };
  E.Result.prototype = {};
  F.ValueResult.prototype = {
    complete$1: function(completer) {
      completer.complete$1(this.value);
    },
    get$hashCode: function(_) {
      return (J.get$hashCode$(this.value) ^ 842997089) >>> 0;
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof F.ValueResult && J.$eq$(this.value, other.value);
    },
    $isResult: 1
  };
  Y.StreamCompleter.prototype = {
    setSourceStream$1: function(sourceStream) {
      var t1 = this._stream_completer$_stream;
      if (t1._sourceStream != null)
        throw H.wrapException(P.StateError$("Source stream already set"));
      t1._sourceStream = sourceStream;
      if (t1._stream_completer$_controller != null)
        t1._linkStreamToController$0();
    },
    setError$2: function(error, stackTrace) {
      var t1 = H.getTypeArgumentByIndex(this, 0);
      this.setSourceStream$1(P.Stream_Stream$fromFuture(P.Future_Future$error(error, stackTrace, t1), t1));
    },
    setError$1: function(error) {
      return this.setError$2(error, null);
    }
  };
  Y._CompleterStream.prototype = {
    listen$4$cancelOnError$onDone$onError: function(onData, cancelOnError, onDone, onError) {
      var t1, _this = this, _null = null;
      if (_this._stream_completer$_controller == null) {
        t1 = _this._sourceStream;
        if (t1 != null && !t1.get$isBroadcast())
          return _this._sourceStream.listen$4$cancelOnError$onDone$onError(onData, cancelOnError, onDone, onError);
        _this._stream_completer$_controller = P.StreamController_StreamController(_null, _null, _null, _null, true, H.getTypeArgumentByIndex(_this, 0));
        if (_this._sourceStream != null)
          _this._linkStreamToController$0();
      }
      t1 = _this._stream_completer$_controller;
      t1.toString;
      return new P._ControllerStream(t1, [H.getTypeArgumentByIndex(t1, 0)]).listen$4$cancelOnError$onDone$onError(onData, cancelOnError, onDone, onError);
    },
    listen$3$onDone$onError: function(onData, onDone, onError) {
      return this.listen$4$cancelOnError$onDone$onError(onData, null, onDone, onError);
    },
    listen$1: function(onData) {
      return this.listen$4$cancelOnError$onDone$onError(onData, null, null, null);
    },
    _linkStreamToController$0: function() {
      var t1 = this._stream_completer$_controller.addStream$2$cancelOnError(this._sourceStream, false),
        t2 = this._stream_completer$_controller;
      t1.whenComplete$1(t2.get$close(t2));
    }
  };
  L.StreamGroup.prototype = {
    add$1: function(_, stream) {
      var t1, _this = this;
      if (_this._closed)
        throw H.wrapException(P.StateError$("Can't add a Stream to a closed StreamGroup."));
      t1 = _this._stream_group$_state;
      if (t1 === C._StreamGroupState_dormant)
        _this._subscriptions.putIfAbsent$2(stream, new L.StreamGroup_add_closure());
      else if (t1 === C._StreamGroupState_canceled)
        return stream.listen$1(null).cancel$0();
      else
        _this._subscriptions.putIfAbsent$2(stream, new L.StreamGroup_add_closure0(_this, stream));
      return;
    },
    remove$1: function(_, stream) {
      var t1 = this._subscriptions,
        subscription = t1.remove$1(0, stream),
        future = subscription == null ? null : subscription.cancel$0();
      if (this._closed && t1.get$isEmpty(t1))
        this._controller.close$0(0);
      return future;
    },
    _onListen$0: function() {
      this._stream_group$_state = C._StreamGroupState_listening;
      this._subscriptions.forEach$1(0, new L.StreamGroup__onListen_closure(this));
    },
    _onPause$0: function() {
      this._stream_group$_state = C._StreamGroupState_paused;
      for (var t1 = this._subscriptions.get$values(), t1 = t1.get$iterator(t1); t1.moveNext$0();)
        t1.get$current(t1).pause$0(0);
    },
    _onResume$0: function() {
      this._stream_group$_state = C._StreamGroupState_listening;
      for (var t1 = this._subscriptions.get$values(), t1 = t1.get$iterator(t1); t1.moveNext$0();)
        t1.get$current(t1).resume$0();
    },
    _onCancel$0: function() {
      var t1, t2, t3, futures;
      this._stream_group$_state = C._StreamGroupState_canceled;
      t1 = this._subscriptions;
      t2 = t1.get$values();
      t2 = H.MappedIterable_MappedIterable(t2, new L.StreamGroup__onCancel_closure(), H.getRuntimeTypeArgument(t2, "Iterable", 0), [P.Future,,]);
      t3 = H.getRuntimeTypeArgument(t2, "Iterable", 0);
      futures = P.List_List$from(new H.WhereIterable(t2, new L.StreamGroup__onCancel_closure0(), [t3]), true, t3);
      t1.clear$0(0);
      return futures.length === 0 ? null : P.Future_wait(futures, null);
    },
    _listenToStream$1: function(stream) {
      var t1 = this._controller,
        subscription = stream.listen$3$onDone$onError(t1.get$add(t1), new L.StreamGroup__listenToStream_closure(this, stream), t1.get$addError());
      if (this._stream_group$_state === C._StreamGroupState_paused)
        subscription.pause$0(0);
      return subscription;
    }
  };
  L.StreamGroup_add_closure.prototype = {
    call$0: function() {
      return;
    }
  };
  L.StreamGroup_add_closure0.prototype = {
    call$0: function() {
      return this.$this._listenToStream$1(this.stream);
    }
  };
  L.StreamGroup__onListen_closure.prototype = {
    call$2: function(stream, subscription) {
      var t1;
      if (subscription != null)
        return;
      t1 = this.$this;
      t1._subscriptions.$indexSet(0, stream, t1._listenToStream$1(stream));
    }
  };
  L.StreamGroup__onCancel_closure.prototype = {
    call$1: function(subscription) {
      return subscription.cancel$0();
    }
  };
  L.StreamGroup__onCancel_closure0.prototype = {
    call$1: function(future) {
      return future != null;
    }
  };
  L.StreamGroup__listenToStream_closure.prototype = {
    call$0: function() {
      return this.$this.remove$1(0, this.stream);
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  L._StreamGroupState.prototype = {
    toString$0: function(_) {
      return this.name;
    }
  };
  G.StreamQueue.prototype = {
    get$next: function() {
      var t1 = this.$ti,
        t2 = new P._Future($.Zone__current, t1);
      this._addRequest$1(new G._NextRequest(new P._AsyncCompleter(t2, t1), t1));
      return t2;
    },
    _updateRequests$0: function() {
      var t1, t2, t3, _this = this;
      for (t1 = _this._requestQueue, t2 = _this._eventQueue; !t1.get$isEmpty(t1);) {
        t3 = t1._collection$_head;
        if (t3 === t1._collection$_tail)
          H.throwExpression(H.IterableElementError_noElement());
        if (t1._collection$_table[t3].update$2(t2, _this._isDone))
          t1.removeFirst$0();
        else
          return;
      }
      if (!_this._isDone)
        _this._stream_queue$_subscription.pause$0(0);
    },
    _ensureListening$0: function() {
      var t1, _this = this;
      if (_this._isDone)
        return;
      t1 = _this._stream_queue$_subscription;
      if (t1 == null)
        _this._stream_queue$_subscription = _this._stream_queue$_source.listen$3$onDone$onError(new G.StreamQueue__ensureListening_closure(_this), new G.StreamQueue__ensureListening_closure0(_this), new G.StreamQueue__ensureListening_closure1(_this));
      else
        t1.resume$0();
    },
    _addResult$1: function(result) {
      ++this._eventsReceived;
      this._eventQueue._queue_list$_add$1(result);
      this._updateRequests$0();
    },
    _addRequest$1: function(request) {
      var _this = this,
        t1 = _this._requestQueue;
      if (t1._collection$_head === t1._collection$_tail) {
        if (request.update$2(_this._eventQueue, _this._isDone))
          return;
        _this._ensureListening$0();
      }
      t1._collection$_add$1(request);
    }
  };
  G.StreamQueue__ensureListening_closure.prototype = {
    call$1: function(data) {
      var t1 = this.$this;
      t1._addResult$1(new F.ValueResult(data, [H.getTypeArgumentByIndex(t1, 0)]));
    },
    $signature: function() {
      return {func: 1, ret: P.Null, args: [H.getTypeArgumentByIndex(this.$this, 0)]};
    }
  };
  G.StreamQueue__ensureListening_closure1.prototype = {
    call$2: function(error, stackTrace) {
      this.$this._addResult$1(new V.ErrorResult(error, stackTrace));
    },
    "call*": "call$2",
    $requiredArgCount: 2,
    $signature: 15
  };
  G.StreamQueue__ensureListening_closure0.prototype = {
    call$0: function() {
      var t1 = this.$this;
      t1._stream_queue$_subscription = null;
      t1._isDone = true;
      t1._updateRequests$0();
    },
    "call*": "call$0",
    $requiredArgCount: 0
  };
  G._EventRequest.prototype = {};
  G._NextRequest.prototype = {
    update$2: function(events, isDone) {
      if (!events.get$isEmpty(events)) {
        events.removeFirst$0().complete$1(this._completer);
        return true;
      }
      if (isDone) {
        this._completer.completeError$2(new P.StateError("No elements"), P.StackTrace_current());
        return true;
      }
      return false;
    },
    $is_EventRequest: 1
  };
  Q.Repl.prototype = {};
  Q.closure130.prototype = {
    call$1: function(text) {
      return true;
    }
  };
  B.ReplAdapter.prototype = {
    runAsync$0: function() {
      var $async$runAsync$0 = P._wrapJsFunctionForAsync(function($async$errorCode, $async$result) {
        switch ($async$errorCode) {
          case 2:
            $async$next = $async$nextWhenCanceled;
            $async$goto = $async$next.pop();
            break;
          case 1:
            $async$currentError = $async$result;
            $async$goto = $async$handler;
        }
        while (true)
          switch ($async$goto) {
            case 0:
              // Function start
              t1 = J.get$isTTY$x(self.process.stdin);
              output = (t1 == null ? false : t1) ? self.process.stdout : null;
              t1 = $async$self.repl;
              $prompt = t1.prompt;
              $async$self.rl = J.createInterface$1$x($.$get$readline(), {input: self.process.stdin, output: output, prompt: $prompt});
              t2 = P.String;
              controller = P.StreamController_StreamController(null, null, null, null, false, t2);
              queue = new G.StreamQueue(new P._ControllerStream(controller, [H.getTypeArgumentByIndex(controller, 0)]), Q.QueueList$(null, [E.Result, t2]), P.ListQueue$([G._EventRequest,,]), [t2]);
              J.on$2$x($async$self.rl, "line", P.allowInterop(new B.ReplAdapter_runAsync_closure(controller)));
              prompt0 = t1.continuation, prompt1 = $prompt, statement = "";
            case 3:
              // for condition
              // trivial condition
              t2 = J.get$isTTY$x(self.process.stdin);
              if (t2 == null ? false : t2)
                J.write$1$x(self.process.stdout, prompt1);
              $async$goto = 5;
              return P._asyncStarHelper(queue.get$next(), $async$runAsync$0, $async$controller);
            case 5:
              // returning from await.
              line = $async$result;
              t2 = J.get$isTTY$x(self.process.stdin);
              if (!(t2 == null ? false : t2)) {
                line0 = prompt1 + H.S(line);
                t2 = $.printToZone;
                if (t2 == null)
                  H.printString(line0);
                else
                  t2.call$1(line0);
              }
              statement = C.JSString_methods.$add(statement, line);
              $async$goto = t1.validator.call$1(statement) ? 6 : 8;
              break;
            case 6:
              // then
              $async$goto = 9;
              $async$nextWhenCanceled = [1];
              return P._asyncStarHelper(P._IterationMarker_yieldSingle(statement), $async$runAsync$0, $async$controller);
            case 9:
              // after yield
              J.setPrompt$1$x($async$self.rl, $prompt);
              prompt1 = $prompt;
              statement = "";
              // goto join
              $async$goto = 7;
              break;
            case 8:
              // else
              statement += "\n";
              J.setPrompt$1$x($async$self.rl, prompt0);
              prompt1 = prompt0;
            case 7:
              // join
              // goto for condition
              $async$goto = 3;
              break;
            case 4:
              // after for
            case 1:
              // return
              return P._asyncStarHelper(null, 0, $async$controller);
            case 2:
              // rethrow
              return P._asyncStarHelper($async$currentError, 1, $async$controller);
          }
      });
      var $async$goto = 0,
        $async$controller = P._makeAsyncStarStreamController($async$runAsync$0, P.String),
        $async$nextWhenCanceled, $async$handler = 2, $async$currentError, $async$next = [], $async$self = this, $prompt, t2, controller, queue, prompt0, prompt1, statement, line, line0, t1, output;
      return P._streamOfController($async$controller);
    }
  };
  B.ReplAdapter_runAsync_closure.prototype = {
    call$1: function(value) {
      this.controller.add$1(0, value);
    },
    call$0: function() {
      return this.call$1(null);
    },
    "call*": "call$1",
    $requiredArgCount: 0,
    $defaultValues: function() {
      return [null];
    },
    $signature: 22
  };
  B.Stdin.prototype = {};
  B.Stdout.prototype = {};
  B.ReadlineModule.prototype = {};
  B.ReadlineOptions.prototype = {};
  B.ReadlineInterface.prototype = {};
  O.EmptyUnmodifiableSet.prototype = {
    get$iterator: function(_) {
      return C.C_EmptyIterator;
    },
    get$length: function(_) {
      return 0;
    },
    cast$1$0: function(_, $T) {
      return new O.EmptyUnmodifiableSet([$T]);
    },
    contains$1: function(_, element) {
      return false;
    },
    toSet$0: function(_) {
      return P.LinkedHashSet_LinkedHashSet(H.getTypeArgumentByIndex(this, 0));
    },
    add$1: function(_, value) {
      return O.EmptyUnmodifiableSet__throw();
    },
    addAll$1: function(_, elements) {
      return O.EmptyUnmodifiableSet__throw();
    },
    $isEfficientLengthIterable: 1,
    $isSet: 1
  };
  U.DefaultEquality.prototype = {};
  U.ListEquality.prototype = {
    equals$2: function(list1, list2) {
      var t1, $length, t2, i;
      if (list1 == null ? list2 == null : list1 === list2)
        return true;
      if (list1 == null || list2 == null)
        return false;
      t1 = J.getInterceptor$asx(list1);
      $length = t1.get$length(list1);
      t2 = J.getInterceptor$asx(list2);
      if ($length !== t2.get$length(list2))
        return false;
      for (i = 0; i < $length; ++i)
        if (!J.$eq$(t1.$index(list1, i), t2.$index(list2, i)))
          return false;
      return true;
    },
    hash$1: function(list) {
      var t1, hash, i;
      for (t1 = list.length, hash = 0, i = 0; i < t1; ++i) {
        hash = hash + J.get$hashCode$(list[i]) & 2147483647;
        hash = hash + (hash << 10 >>> 0) & 2147483647;
        hash ^= hash >>> 6;
      }
      hash = hash + (hash << 3 >>> 0) & 2147483647;
      hash ^= hash >>> 11;
      return hash + (hash << 15 >>> 0) & 2147483647;
    }
  };
  U._MapEntry.prototype = {
    get$hashCode: function(_) {
      return 3 * J.get$hashCode$(this.key) + 7 * J.get$hashCode$(this.value) & 2147483647;
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof U._MapEntry && J.$eq$(this.key, other.key) && J.$eq$(this.value, other.value);
    }
  };
  U.MapEquality.prototype = {
    equals$2: function(map1, map2) {
      var equalElementCounts, t1, key, entry, count;
      if (map1 === map2)
        return true;
      if (map1.get$length(map1) !== map2.get$length(map2))
        return false;
      equalElementCounts = P.HashMap_HashMap(U._MapEntry, P.int);
      for (t1 = J.get$iterator$ax(map1.get$keys()); t1.moveNext$0();) {
        key = t1.get$current(t1);
        entry = new U._MapEntry(this, key, map1.$index(0, key));
        count = equalElementCounts.$index(0, entry);
        equalElementCounts.$indexSet(0, entry, (count == null ? 0 : count) + 1);
      }
      for (t1 = J.get$iterator$ax(map2.get$keys()); t1.moveNext$0();) {
        key = t1.get$current(t1);
        entry = new U._MapEntry(this, key, map2.$index(0, key));
        count = equalElementCounts.$index(0, entry);
        if (count == null || count === 0)
          return false;
        equalElementCounts.$indexSet(0, entry, count - 1);
      }
      return true;
    },
    hash$1: function(map) {
      var t1, hash, key;
      for (t1 = J.get$iterator$ax(map.get$keys()), hash = 0; t1.moveNext$0();) {
        key = t1.get$current(t1);
        hash = hash + 3 * J.get$hashCode$(key) + 7 * J.get$hashCode$(map.$index(0, key)) & 2147483647;
      }
      hash = hash + (hash << 3 >>> 0) & 2147483647;
      hash ^= hash >>> 11;
      return hash + (hash << 15 >>> 0) & 2147483647;
    }
  };
  Y.mapMap_closure.prototype = {
    call$2: function(mapKey, _) {
      return H.subtypeOfRuntimeTypeCast(mapKey, this.K2);
    },
    $signature: function() {
      return {func: 1, ret: this.K2, args: [this.K1, this.V1]};
    }
  };
  Y.mapMap_closure0.prototype = {
    call$2: function(_, mapValue) {
      return H.subtypeOfRuntimeTypeCast(mapValue, this.V2);
    },
    $signature: function() {
      return {func: 1, ret: this.V2, args: [this.K1, this.V1]};
    }
  };
  Y.mapMap_closure1.prototype = {
    call$2: function(mapKey, mapValue) {
      var t1 = this._box_0;
      this.result.$indexSet(0, t1.key.call$2(mapKey, mapValue), t1.value.call$2(mapKey, mapValue));
    },
    $signature: function() {
      return {func: 1, ret: P.Null, args: [this.K1, this.V1]};
    }
  };
  Q.QueueList.prototype = {
    QueueList$1: function(initialCapacity, $E) {
      var t1;
      if (initialCapacity == null || initialCapacity < 8)
        initialCapacity = 8;
      else if ((initialCapacity & initialCapacity - 1) >>> 0 !== 0)
        initialCapacity = Q.QueueList__nextPowerOf2(initialCapacity);
      t1 = new Array(initialCapacity);
      t1.fixed$length = Array;
      this._table = H.setRuntimeTypeInfo(t1, [$E]);
    },
    add$1: function(_, element) {
      this._queue_list$_add$1(element);
    },
    addAll$1: function(_, iterable) {
      var addCount, $length, endSpace, preSpace, _this = this,
        t1 = J.getInterceptor$(iterable);
      if (!!t1.$isList) {
        addCount = t1.get$length(iterable);
        $length = _this.get$length(_this);
        t1 = $length + addCount;
        if (t1 >= J.get$length$asx(_this._table)) {
          _this._preGrow$1(t1);
          J.setRange$4$ax(_this._table, $length, t1, iterable, 0);
          _this.set$_tail(_this.get$_tail() + addCount);
        } else {
          endSpace = J.get$length$asx(_this._table) - _this.get$_tail();
          t1 = _this._table;
          if (addCount < endSpace) {
            J.setRange$4$ax(t1, _this.get$_tail(), _this.get$_tail() + addCount, iterable, 0);
            _this.set$_tail(_this.get$_tail() + addCount);
          } else {
            preSpace = addCount - endSpace;
            J.setRange$4$ax(t1, _this.get$_tail(), _this.get$_tail() + endSpace, iterable, 0);
            J.setRange$4$ax(_this._table, 0, preSpace, iterable, endSpace);
            _this.set$_tail(preSpace);
          }
        }
      } else
        for (t1 = t1.get$iterator(iterable); t1.moveNext$0();)
          _this._queue_list$_add$1(t1.get$current(t1));
    },
    cast$1$0: function(_, $T) {
      var t1 = new Q._CastQueueList(this, null, null, [H.getRuntimeTypeArgument(this, "QueueList", 0), $T]);
      t1._table = J.cast$1$0$ax(this._table, $T);
      return t1;
    },
    toString$0: function(_) {
      return P.IterableBase_iterableToFullString(this, "{", "}");
    },
    addFirst$1: function(element) {
      var _this = this;
      _this.set$_head((_this.get$_head() - 1 & J.get$length$asx(_this._table) - 1) >>> 0);
      J.$indexSet$ax(_this._table, _this.get$_head(), element);
      if (_this.get$_head() == _this.get$_tail())
        _this._grow$0();
    },
    removeFirst$0: function() {
      var result, _this = this;
      if (_this.get$_head() == _this.get$_tail())
        throw H.wrapException(P.StateError$("No element"));
      result = J.$index$asx(_this._table, _this.get$_head());
      J.$indexSet$ax(_this._table, _this.get$_head(), null);
      _this.set$_head((_this.get$_head() + 1 & J.get$length$asx(_this._table) - 1) >>> 0);
      return result;
    },
    get$length: function(_) {
      return (this.get$_tail() - this.get$_head() & J.get$length$asx(this._table) - 1) >>> 0;
    },
    set$length: function(_, value) {
      var delta, newTail, t1, t2, _this = this;
      if (value < 0)
        throw H.wrapException(P.RangeError$("Length " + value + " may not be negative."));
      delta = value - _this.get$length(_this);
      if (delta >= 0) {
        if (J.get$length$asx(_this._table) <= value)
          _this._preGrow$1(value);
        _this.set$_tail((_this.get$_tail() + delta & J.get$length$asx(_this._table) - 1) >>> 0);
        return;
      }
      newTail = _this.get$_tail() + delta;
      t1 = _this._table;
      if (newTail >= 0)
        J.fillRange$3$ax(t1, newTail, _this.get$_tail(), null);
      else {
        newTail += J.get$length$asx(t1);
        J.fillRange$3$ax(_this._table, 0, _this.get$_tail(), null);
        t1 = _this._table;
        t2 = J.getInterceptor$asx(t1);
        t2.fillRange$3(t1, newTail, t2.get$length(t1), null);
      }
      _this.set$_tail(newTail);
    },
    $index: function(_, index) {
      var _this = this;
      if (index < 0 || index >= _this.get$length(_this))
        throw H.wrapException(P.RangeError$("Index " + H.S(index) + " must be in the range [0.." + _this.get$length(_this) + ")."));
      return J.$index$asx(_this._table, (_this.get$_head() + index & J.get$length$asx(_this._table) - 1) >>> 0);
    },
    $indexSet: function(_, index, value) {
      var _this = this;
      if (index < 0 || index >= _this.get$length(_this))
        throw H.wrapException(P.RangeError$("Index " + H.S(index) + " must be in the range [0.." + _this.get$length(_this) + ")."));
      J.$indexSet$ax(_this._table, (_this.get$_head() + index & J.get$length$asx(_this._table) - 1) >>> 0, value);
    },
    _queue_list$_add$1: function(element) {
      var _this = this;
      J.$indexSet$ax(_this._table, _this.get$_tail(), element);
      _this.set$_tail((_this.get$_tail() + 1 & J.get$length$asx(_this._table) - 1) >>> 0);
      if (_this.get$_head() == _this.get$_tail())
        _this._grow$0();
    },
    _grow$0: function() {
      var newTable, split, _this = this,
        t1 = new Array(J.get$length$asx(_this._table) * 2);
      t1.fixed$length = Array;
      newTable = H.setRuntimeTypeInfo(t1, [H.getRuntimeTypeArgument(_this, "QueueList", 0)]);
      split = J.get$length$asx(_this._table) - _this.get$_head();
      C.JSArray_methods.setRange$4(newTable, 0, split, _this._table, _this.get$_head());
      C.JSArray_methods.setRange$4(newTable, split, split + _this.get$_head(), _this._table, 0);
      _this.set$_head(0);
      _this.set$_tail(J.get$length$asx(_this._table));
      _this._table = newTable;
    },
    _writeToList$1: function(target) {
      var $length, firstPartSize, _this = this;
      if (_this.get$_head() <= _this.get$_tail()) {
        $length = _this.get$_tail() - _this.get$_head();
        C.JSArray_methods.setRange$4(target, 0, $length, _this._table, _this.get$_head());
        return $length;
      } else {
        firstPartSize = J.get$length$asx(_this._table) - _this.get$_head();
        C.JSArray_methods.setRange$4(target, 0, firstPartSize, _this._table, _this.get$_head());
        C.JSArray_methods.setRange$4(target, firstPartSize, firstPartSize + _this.get$_tail(), _this._table, 0);
        return _this.get$_tail() + firstPartSize;
      }
    },
    _preGrow$1: function(newElementCount) {
      var newTable, _this = this,
        t1 = new Array(Q.QueueList__nextPowerOf2(newElementCount + C.JSInt_methods._shrOtherPositive$1(newElementCount, 1)));
      t1.fixed$length = Array;
      newTable = H.setRuntimeTypeInfo(t1, [H.getRuntimeTypeArgument(_this, "QueueList", 0)]);
      _this.set$_tail(_this._writeToList$1(newTable));
      _this._table = newTable;
      _this.set$_head(0);
    },
    $isEfficientLengthIterable: 1,
    $isQueue: 1,
    $isIterable: 1,
    $isList: 1,
    get$_head: function() {
      return this._head;
    },
    get$_tail: function() {
      return this._tail;
    },
    set$_head: function(val) {
      return this._head = val;
    },
    set$_tail: function(val) {
      return this._tail = val;
    }
  };
  Q._CastQueueList.prototype = {
    get$_head: function() {
      return this._queue_list$_delegate.get$_head();
    },
    set$_head: function(value) {
      this._queue_list$_delegate.set$_head(value);
    },
    get$_tail: function() {
      return this._queue_list$_delegate.get$_tail();
    },
    set$_tail: function(value) {
      this._queue_list$_delegate.set$_tail(value);
    },
    $asEfficientLengthIterable: function($S, $T) {
      return [$T];
    },
    $asListMixin: function($S, $T) {
      return [$T];
    },
    $asQueue: function($S, $T) {
      return [$T];
    },
    $asIterable: function($S, $T) {
      return [$T];
    },
    $asList: function($S, $T) {
      return [$T];
    },
    $asQueueList: function($S, $T) {
      return [$T];
    }
  };
  Q._QueueList_Object_ListMixin.prototype = {};
  L.UnmodifiableSetView.prototype = {};
  L.UnmodifiableSetMixin.prototype = {
    add$1: function(_, value) {
      return L.UnmodifiableSetMixin__throw();
    },
    addAll$1: function(_, elements) {
      return L.UnmodifiableSetMixin__throw();
    }
  };
  L._UnmodifiableSetView_DelegatingSet_UnmodifiableSetMixin.prototype = {};
  B.defaultCompare_closure.prototype = {
    call$2: function(value1, value2) {
      return J.compareTo$1$ns(H.numberOrStringSuperNativeTypeCast(value1, "$isComparable"), value2);
    },
    $signature: function() {
      var t1 = this.T;
      return {func: 1, ret: P.int, args: [t1, t1]};
    }
  };
  M._DelegatingIterableBase.prototype = {
    cast$1$0: function(_, $T) {
      return J.cast$1$0$ax(this.get$_base(), $T);
    },
    contains$1: function(_, element) {
      return J.contains$1$asx(this.get$_base(), element);
    },
    elementAt$1: function(_, index) {
      return J.elementAt$1$ax(this.get$_base(), index);
    },
    get$first: function(_) {
      return J.get$first$ax(this.get$_base());
    },
    get$isEmpty: function(_) {
      return J.get$isEmpty$asx(this.get$_base());
    },
    get$isNotEmpty: function(_) {
      return J.get$isNotEmpty$asx(this.get$_base());
    },
    get$iterator: function(_) {
      return J.get$iterator$ax(this.get$_base());
    },
    join$1: function(_, separator) {
      return J.join$1$ax(this.get$_base(), separator);
    },
    join$0: function($receiver) {
      return this.join$1($receiver, "");
    },
    get$last: function(_) {
      return J.get$last$ax(this.get$_base());
    },
    get$length: function(_) {
      return J.get$length$asx(this.get$_base());
    },
    map$1$1: function(_, f, $T) {
      return J.map$1$1$ax(this.get$_base(), f, $T);
    },
    get$single: function(_) {
      return J.get$single$ax(this.get$_base());
    },
    skip$1: function(_, n) {
      return J.skip$1$ax(this.get$_base(), n);
    },
    take$1: function(_, n) {
      return J.take$1$ax(this.get$_base(), n);
    },
    toList$1$growable: function(_, growable) {
      return J.toList$1$growable$ax(this.get$_base(), growable);
    },
    toList$0: function($receiver) {
      return this.toList$1$growable($receiver, true);
    },
    toSet$0: function(_) {
      return J.toSet$0$ax(this.get$_base());
    },
    where$1: function(_, test) {
      return J.where$1$ax(this.get$_base(), test);
    },
    toString$0: function(_) {
      return J.toString$0$(this.get$_base());
    },
    $isIterable: 1
  };
  M.DelegatingIterable.prototype = {
    get$_base: function() {
      return this._base;
    }
  };
  M.DelegatingSet.prototype = {
    add$1: function(_, value) {
      return this._base.add$1(0, value);
    },
    addAll$1: function(_, elements) {
      this._base.addAll$1(0, elements);
    },
    cast$1$0: function(_, $T) {
      var t1 = this._base;
      return P.Set_castFrom(t1, t1.get$_newSimilarSet(), H.getTypeArgumentByIndex(t1, 0), $T);
    },
    toSet$0: function(_) {
      return new M.DelegatingSet(this._base.toSet$0(0), this.$ti);
    },
    $isEfficientLengthIterable: 1,
    $isSet: 1
  };
  M.MapKeySet.prototype = {
    get$_base: function() {
      return this._baseMap.get$keys();
    },
    cast$1$0: function(_, $T) {
      var _this = this,
        t1 = [$T];
      if (H.checkSubtype(_this, "$isMapKeySet", t1, null))
        return H.subtypeCast(_this, "$isMapKeySet", t1, "$asMapKeySet");
      return P.Set_castFrom(_this, null, H.getTypeArgumentByIndex(_this, 0), $T);
    },
    contains$1: function(_, element) {
      return this._baseMap.containsKey$1(element);
    },
    get$isEmpty: function(_) {
      var t1 = this._baseMap;
      return t1.get$isEmpty(t1);
    },
    get$isNotEmpty: function(_) {
      var t1 = this._baseMap;
      return t1.get$isNotEmpty(t1);
    },
    get$length: function(_) {
      var t1 = this._baseMap;
      return t1.get$length(t1);
    },
    toString$0: function(_) {
      return "{" + J.join$1$ax(this._baseMap.get$keys(), ", ") + "}";
    },
    $isEfficientLengthIterable: 1,
    $isSet: 1
  };
  M._MapKeySet__DelegatingIterableBase_UnmodifiableSetMixin.prototype = {};
  M.Context.prototype = {
    absolute$7: function(part1, part2, part3, part4, part5, part6, part7) {
      var t1;
      M._validateArgList("absolute", H.setRuntimeTypeInfo([part1, part2, part3, part4, part5, part6, part7], [P.String]));
      t1 = this.style;
      t1 = t1.rootLength$1(part1) > 0 && !t1.isRootRelative$1(part1);
      if (t1)
        return part1;
      t1 = this._context$_current;
      return this.join$8(0, t1 != null ? t1 : D.current(), part1, part2, part3, part4, part5, part6, part7);
    },
    absolute$1: function(part1) {
      return this.absolute$7(part1, null, null, null, null, null, null);
    },
    dirname$1: function(path) {
      var t1, t2,
        parsed = X.ParsedPath_ParsedPath$parse(path, this.style);
      parsed.removeTrailingSeparators$0();
      t1 = parsed.parts;
      t2 = t1.length;
      if (t2 === 0) {
        t1 = parsed.root;
        return t1 == null ? "." : t1;
      }
      if (t2 === 1) {
        t1 = parsed.root;
        return t1 == null ? "." : t1;
      }
      C.JSArray_methods.removeLast$0(t1);
      C.JSArray_methods.removeLast$0(parsed.separators);
      parsed.removeTrailingSeparators$0();
      return parsed.toString$0(0);
    },
    join$8: function(_, part1, part2, part3, part4, part5, part6, part7, part8) {
      var parts = H.setRuntimeTypeInfo([part1, part2, part3, part4, part5, part6, part7, part8], [P.String]);
      M._validateArgList("join", parts);
      return this.joinAll$1(new H.WhereIterable(parts, new M.Context_join_closure(), [H.getTypeArgumentByIndex(parts, 0)]));
    },
    join$2: function($receiver, part1, part2) {
      return this.join$8($receiver, part1, part2, null, null, null, null, null, null);
    },
    joinAll$1: function(parts) {
      var t1, t2, t3, needsSeparator, isAbsoluteAndNotRootRelative, t4, t5, parsed, path;
      for (t1 = parts.get$iterator(parts), t2 = new H.WhereIterator(t1, new M.Context_joinAll_closure()), t3 = this.style, needsSeparator = false, isAbsoluteAndNotRootRelative = false, t4 = ""; t2.moveNext$0();) {
        t5 = t1.get$current(t1);
        if (t3.isRootRelative$1(t5) && isAbsoluteAndNotRootRelative) {
          parsed = X.ParsedPath_ParsedPath$parse(t5, t3);
          path = t4.charCodeAt(0) == 0 ? t4 : t4;
          t4 = C.JSString_methods.substring$2(path, 0, t3.rootLength$2$withDrive(path, true));
          parsed.root = t4;
          if (t3.needsSeparator$1(t4))
            parsed.separators[0] = t3.get$separator();
          t4 = parsed.toString$0(0);
        } else if (t3.rootLength$1(t5) > 0) {
          isAbsoluteAndNotRootRelative = !t3.isRootRelative$1(t5);
          t4 = H.S(t5);
        } else {
          if (!(t5.length !== 0 && t3.containsSeparator$1(t5[0])))
            if (needsSeparator)
              t4 += t3.get$separator();
          t4 += H.S(t5);
        }
        needsSeparator = t3.needsSeparator$1(t5);
      }
      return t4.charCodeAt(0) == 0 ? t4 : t4;
    },
    split$1: function(_, path) {
      var parsed = X.ParsedPath_ParsedPath$parse(path, this.style),
        t1 = parsed.parts,
        t2 = H.getTypeArgumentByIndex(t1, 0);
      t2 = P.List_List$from(new H.WhereIterable(t1, new M.Context_split_closure(), [t2]), true, t2);
      parsed.parts = t2;
      t1 = parsed.root;
      if (t1 != null)
        C.JSArray_methods.insert$2(t2, 0, t1);
      return parsed.parts;
    },
    canonicalize$1: function(path) {
      var t1, parsed;
      path = this.absolute$1(path);
      t1 = this.style;
      if (t1 != $.$get$Style_windows() && !this._needsNormalization$1(path))
        return path;
      parsed = X.ParsedPath_ParsedPath$parse(path, t1);
      parsed.normalize$1$canonicalize(true);
      return parsed.toString$0(0);
    },
    normalize$1: function(path) {
      var parsed;
      if (!this._needsNormalization$1(path))
        return path;
      parsed = X.ParsedPath_ParsedPath$parse(path, this.style);
      parsed.normalize$0();
      return parsed.toString$0(0);
    },
    _needsNormalization$1: function(path) {
      var t1, root, t2, i, start, previous, t3, previousPrevious, codeUnit, t4;
      path.toString;
      t1 = this.style;
      root = t1.rootLength$1(path);
      if (root !== 0) {
        if (t1 === $.$get$Style_windows())
          for (t2 = J.getInterceptor$s(path), i = 0; i < root; ++i)
            if (t2._codeUnitAt$1(path, i) === 47)
              return true;
        start = root;
        previous = 47;
      } else {
        start = 0;
        previous = null;
      }
      for (t2 = new H.CodeUnits(path).__internal$_string, t3 = t2.length, i = start, previousPrevious = null; i < t3; ++i, previousPrevious = previous, previous = codeUnit) {
        codeUnit = C.JSString_methods.codeUnitAt$1(t2, i);
        if (t1.isSeparator$1(codeUnit)) {
          if (t1 === $.$get$Style_windows() && codeUnit === 47)
            return true;
          if (previous != null && t1.isSeparator$1(previous))
            return true;
          if (previous === 46)
            t4 = previousPrevious == null || previousPrevious === 46 || t1.isSeparator$1(previousPrevious);
          else
            t4 = false;
          if (t4)
            return true;
        }
      }
      if (previous == null)
        return true;
      if (t1.isSeparator$1(previous))
        return true;
      if (previous === 46)
        t1 = previousPrevious == null || t1.isSeparator$1(previousPrevious) || previousPrevious === 46;
      else
        t1 = false;
      if (t1)
        return true;
      return false;
    },
    relative$2$from: function(path, from) {
      var fromParsed, pathParsed, t2, t3, _this = this,
        _s26_ = 'Unable to find a path to "',
        t1 = from == null;
      if (t1 && _this.style.rootLength$1(path) <= 0)
        return _this.normalize$1(path);
      if (t1) {
        t1 = _this._context$_current;
        from = t1 != null ? t1 : D.current();
      } else
        from = _this.absolute$1(from);
      t1 = _this.style;
      if (t1.rootLength$1(from) <= 0 && t1.rootLength$1(path) > 0)
        return _this.normalize$1(path);
      if (t1.rootLength$1(path) <= 0 || t1.isRootRelative$1(path))
        path = _this.absolute$1(path);
      if (t1.rootLength$1(path) <= 0 && t1.rootLength$1(from) > 0)
        throw H.wrapException(X.PathException$(_s26_ + H.S(path) + '" from "' + H.S(from) + '".'));
      fromParsed = X.ParsedPath_ParsedPath$parse(from, t1);
      fromParsed.normalize$0();
      pathParsed = X.ParsedPath_ParsedPath$parse(path, t1);
      pathParsed.normalize$0();
      t2 = fromParsed.parts;
      if (t2.length !== 0 && J.$eq$(t2[0], "."))
        return pathParsed.toString$0(0);
      t2 = fromParsed.root;
      t3 = pathParsed.root;
      if (t2 != t3)
        t2 = t2 == null || t3 == null || !t1.pathsEqual$2(t2, t3);
      else
        t2 = false;
      if (t2)
        return pathParsed.toString$0(0);
      while (true) {
        t2 = fromParsed.parts;
        if (t2.length !== 0) {
          t3 = pathParsed.parts;
          t2 = t3.length !== 0 && t1.pathsEqual$2(t2[0], t3[0]);
        } else
          t2 = false;
        if (!t2)
          break;
        C.JSArray_methods.removeAt$1(fromParsed.parts, 0);
        C.JSArray_methods.removeAt$1(fromParsed.separators, 1);
        C.JSArray_methods.removeAt$1(pathParsed.parts, 0);
        C.JSArray_methods.removeAt$1(pathParsed.separators, 1);
      }
      t2 = fromParsed.parts;
      if (t2.length !== 0 && J.$eq$(t2[0], ".."))
        throw H.wrapException(X.PathException$(_s26_ + H.S(path) + '" from "' + H.S(from) + '".'));
      t2 = P.String;
      C.JSArray_methods.insertAll$2(pathParsed.parts, 0, P.List_List$filled(fromParsed.parts.length, "..", t2));
      t3 = pathParsed.separators;
      t3[0] = "";
      C.JSArray_methods.insertAll$2(t3, 1, P.List_List$filled(fromParsed.parts.length, t1.get$separator(), t2));
      t1 = pathParsed.parts;
      t2 = t1.length;
      if (t2 === 0)
        return ".";
      if (t2 > 1 && J.$eq$(C.JSArray_methods.get$last(t1), ".")) {
        C.JSArray_methods.removeLast$0(pathParsed.parts);
        t1 = pathParsed.separators;
        C.JSArray_methods.removeLast$0(t1);
        C.JSArray_methods.removeLast$0(t1);
        C.JSArray_methods.add$1(t1, "");
      }
      pathParsed.root = "";
      pathParsed.removeTrailingSeparators$0();
      return pathParsed.toString$0(0);
    },
    relative$1: function(path) {
      return this.relative$2$from(path, null);
    },
    _isWithinOrEquals$2: function($parent, child) {
      var relative, childIsRootRelative, parentIsRootRelative, result, exception, _this = this,
        t1 = _this.style,
        parentIsAbsolute = t1.rootLength$1($parent) > 0,
        childIsAbsolute = t1.rootLength$1(child) > 0;
      if (parentIsAbsolute && !childIsAbsolute) {
        child = _this.absolute$1(child);
        if (t1.isRootRelative$1($parent))
          $parent = _this.absolute$1($parent);
      } else if (childIsAbsolute && !parentIsAbsolute) {
        $parent = _this.absolute$1($parent);
        if (t1.isRootRelative$1(child))
          child = _this.absolute$1(child);
      } else if (childIsAbsolute && parentIsAbsolute) {
        childIsRootRelative = t1.isRootRelative$1(child);
        parentIsRootRelative = t1.isRootRelative$1($parent);
        if (childIsRootRelative && !parentIsRootRelative)
          child = _this.absolute$1(child);
        else if (parentIsRootRelative && !childIsRootRelative)
          $parent = _this.absolute$1($parent);
      }
      result = _this._isWithinOrEqualsFast$2($parent, child);
      if (result !== C._PathRelation_inconclusive)
        return result;
      relative = null;
      try {
        relative = _this.relative$2$from(child, $parent);
      } catch (exception) {
        if (H.unwrapException(exception) instanceof X.PathException)
          return C._PathRelation_different;
        else
          throw exception;
      }
      if (t1.rootLength$1(relative) > 0)
        return C._PathRelation_different;
      if (J.$eq$(relative, "."))
        return C._PathRelation_equal;
      if (J.$eq$(relative, ".."))
        return C._PathRelation_different;
      return J.get$length$asx(relative) >= 3 && J.startsWith$1$s(relative, "..") && t1.isSeparator$1(J.codeUnitAt$1$s(relative, 2)) ? C._PathRelation_different : C._PathRelation_within;
    },
    _isWithinOrEqualsFast$2: function($parent, child) {
      var t1, parentRootLength, childRootLength, t2, t3, i, childIndex, parentIndex, lastCodeUnit, lastParentSeparator, parentCodeUnit, childCodeUnit, parentIndex0, t4, direction, _this = this;
      if ($parent === ".")
        $parent = "";
      t1 = _this.style;
      parentRootLength = t1.rootLength$1($parent);
      childRootLength = t1.rootLength$1(child);
      if (parentRootLength !== childRootLength)
        return C._PathRelation_different;
      for (t2 = J.getInterceptor$s($parent), t3 = J.getInterceptor$s(child), i = 0; i < parentRootLength; ++i)
        if (!t1.codeUnitsEqual$2(t2._codeUnitAt$1($parent, i), t3._codeUnitAt$1(child, i)))
          return C._PathRelation_different;
      t2 = $parent.length;
      childIndex = childRootLength;
      parentIndex = parentRootLength;
      lastCodeUnit = 47;
      lastParentSeparator = null;
      while (true) {
        if (!(parentIndex < t2 && childIndex < child.length))
          break;
        c$0: {
          parentCodeUnit = C.JSString_methods.codeUnitAt$1($parent, parentIndex);
          childCodeUnit = t3.codeUnitAt$1(child, childIndex);
          if (t1.codeUnitsEqual$2(parentCodeUnit, childCodeUnit)) {
            if (t1.isSeparator$1(parentCodeUnit))
              lastParentSeparator = parentIndex;
            ++parentIndex;
            ++childIndex;
            lastCodeUnit = parentCodeUnit;
            break c$0;
          }
          if (t1.isSeparator$1(parentCodeUnit) && t1.isSeparator$1(lastCodeUnit)) {
            parentIndex0 = parentIndex + 1;
            lastParentSeparator = parentIndex;
            parentIndex = parentIndex0;
            break c$0;
          } else if (t1.isSeparator$1(childCodeUnit) && t1.isSeparator$1(lastCodeUnit)) {
            ++childIndex;
            break c$0;
          }
          if (parentCodeUnit === 46 && t1.isSeparator$1(lastCodeUnit)) {
            ++parentIndex;
            if (parentIndex === t2)
              break;
            parentCodeUnit = C.JSString_methods.codeUnitAt$1($parent, parentIndex);
            if (t1.isSeparator$1(parentCodeUnit)) {
              parentIndex0 = parentIndex + 1;
              lastParentSeparator = parentIndex;
              parentIndex = parentIndex0;
              break c$0;
            }
            if (parentCodeUnit === 46) {
              ++parentIndex;
              if (parentIndex === t2 || t1.isSeparator$1(C.JSString_methods.codeUnitAt$1($parent, parentIndex)))
                return C._PathRelation_inconclusive;
            }
          }
          if (childCodeUnit === 46 && t1.isSeparator$1(lastCodeUnit)) {
            ++childIndex;
            t4 = child.length;
            if (childIndex === t4)
              break;
            childCodeUnit = C.JSString_methods.codeUnitAt$1(child, childIndex);
            if (t1.isSeparator$1(childCodeUnit)) {
              ++childIndex;
              break c$0;
            }
            if (childCodeUnit === 46) {
              ++childIndex;
              if (childIndex === t4 || t1.isSeparator$1(C.JSString_methods.codeUnitAt$1(child, childIndex)))
                return C._PathRelation_inconclusive;
            }
          }
          if (_this._pathDirection$2(child, childIndex) !== C._PathDirection_988)
            return C._PathRelation_inconclusive;
          if (_this._pathDirection$2($parent, parentIndex) !== C._PathDirection_988)
            return C._PathRelation_inconclusive;
          return C._PathRelation_different;
        }
      }
      if (childIndex === child.length) {
        if (parentIndex === t2 || t1.isSeparator$1(C.JSString_methods.codeUnitAt$1($parent, parentIndex)))
          lastParentSeparator = parentIndex;
        else if (lastParentSeparator == null)
          lastParentSeparator = Math.max(0, parentRootLength - 1);
        direction = _this._pathDirection$2($parent, lastParentSeparator);
        if (direction === C._PathDirection_8Gl)
          return C._PathRelation_equal;
        return direction === C._PathDirection_ZGD ? C._PathRelation_inconclusive : C._PathRelation_different;
      }
      direction = _this._pathDirection$2(child, childIndex);
      if (direction === C._PathDirection_8Gl)
        return C._PathRelation_equal;
      if (direction === C._PathDirection_ZGD)
        return C._PathRelation_inconclusive;
      return t1.isSeparator$1(C.JSString_methods.codeUnitAt$1(child, childIndex)) || t1.isSeparator$1(lastCodeUnit) ? C._PathRelation_within : C._PathRelation_different;
    },
    _pathDirection$2: function(path, index) {
      var t1, t2, i, depth, reachedRoot, i0, t3;
      for (t1 = path.length, t2 = this.style, i = index, depth = 0, reachedRoot = false; i < t1;) {
        while (true) {
          if (!(i < t1 && t2.isSeparator$1(C.JSString_methods.codeUnitAt$1(path, i))))
            break;
          ++i;
        }
        if (i === t1)
          break;
        i0 = i;
        while (true) {
          if (!(i0 < t1 && !t2.isSeparator$1(C.JSString_methods.codeUnitAt$1(path, i0))))
            break;
          ++i0;
        }
        t3 = i0 - i;
        if (!(t3 === 1 && C.JSString_methods.codeUnitAt$1(path, i) === 46))
          if (t3 === 2 && C.JSString_methods.codeUnitAt$1(path, i) === 46 && C.JSString_methods.codeUnitAt$1(path, i + 1) === 46) {
            --depth;
            if (depth < 0)
              break;
            if (depth === 0)
              reachedRoot = true;
          } else
            ++depth;
        if (i0 === t1)
          break;
        i = i0 + 1;
      }
      if (depth < 0)
        return C._PathDirection_ZGD;
      if (depth === 0)
        return C._PathDirection_8Gl;
      if (reachedRoot)
        return C._PathDirection_FIw;
      return C._PathDirection_988;
    },
    hash$1: function(path) {
      var result, parsed, _this = this;
      path = _this.absolute$1(path);
      result = _this._hashFast$1(path);
      if (result != null)
        return result;
      parsed = X.ParsedPath_ParsedPath$parse(path, _this.style);
      parsed.normalize$0();
      return _this._hashFast$1(parsed.toString$0(0));
    },
    _hashFast$1: function(path) {
      var t1, t2, hash, beginning, wasSeparator, i, codeUnit, t3, next;
      for (t1 = path.length, t2 = this.style, hash = 4603, beginning = true, wasSeparator = true, i = 0; i < t1; ++i) {
        codeUnit = t2.canonicalizeCodeUnit$1(C.JSString_methods._codeUnitAt$1(path, i));
        if (t2.isSeparator$1(codeUnit)) {
          wasSeparator = true;
          continue;
        }
        if (codeUnit === 46 && wasSeparator) {
          t3 = i + 1;
          if (t3 === t1)
            break;
          next = C.JSString_methods._codeUnitAt$1(path, t3);
          if (t2.isSeparator$1(next))
            continue;
          if (!beginning)
            if (next === 46) {
              t3 = i + 2;
              t3 = t3 === t1 || t2.isSeparator$1(C.JSString_methods._codeUnitAt$1(path, t3));
            } else
              t3 = false;
          else
            t3 = false;
          if (t3)
            return;
        }
        hash = ((hash & 67108863) * 33 ^ codeUnit) >>> 0;
        beginning = false;
        wasSeparator = false;
      }
      return hash;
    },
    withoutExtension$1: function(path) {
      var i,
        parsed = X.ParsedPath_ParsedPath$parse(path, this.style);
      for (i = parsed.parts.length - 1; i >= 0; --i)
        if (J.get$length$asx(parsed.parts[i]) !== 0) {
          parsed.parts[i] = parsed._splitExtension$0()[0];
          break;
        }
      return parsed.toString$0(0);
    },
    toUri$1: function(path) {
      var t2,
        t1 = this.style;
      if (t1.rootLength$1(path) <= 0)
        return t1.relativePathToUri$1(path);
      else {
        t2 = this._context$_current;
        return t1.absolutePathToUri$1(this.join$2(0, t2 != null ? t2 : D.current(), path));
      }
    },
    prettyUri$1: function(uri) {
      var path, rel, _this = this,
        typedUri = M._parseUri(uri);
      if (typedUri.get$scheme() === "file" && _this.style == $.$get$Style_url())
        return typedUri.toString$0(0);
      else if (typedUri.get$scheme() !== "file" && typedUri.get$scheme() !== "" && _this.style != $.$get$Style_url())
        return typedUri.toString$0(0);
      path = _this.normalize$1(_this.style.pathFromUri$1(M._parseUri(typedUri)));
      rel = _this.relative$1(path);
      return _this.split$1(0, rel).length > _this.split$1(0, path).length ? path : rel;
    }
  };
  M.Context_join_closure.prototype = {
    call$1: function(part) {
      return part != null;
    }
  };
  M.Context_joinAll_closure.prototype = {
    call$1: function(part) {
      return part !== "";
    }
  };
  M.Context_split_closure.prototype = {
    call$1: function(part) {
      return part.length !== 0;
    }
  };
  M._validateArgList_closure.prototype = {
    call$1: function(arg) {
      return arg == null ? "null" : '"' + arg + '"';
    }
  };
  M._PathDirection.prototype = {
    toString$0: function(_) {
      return this.name;
    }
  };
  M._PathRelation.prototype = {
    toString$0: function(_) {
      return this.name;
    }
  };
  B.InternalStyle.prototype = {
    getRoot$1: function(path) {
      var $length = this.rootLength$1(path);
      if ($length > 0)
        return J.substring$2$s(path, 0, $length);
      return this.isRootRelative$1(path) ? path[0] : null;
    },
    relativePathToUri$1: function(path) {
      var segments = M.Context_Context(this).split$1(0, path);
      if (this.isSeparator$1(J.codeUnitAt$1$s(path, path.length - 1)))
        C.JSArray_methods.add$1(segments, "");
      return P._Uri__Uri(null, null, segments, null);
    },
    codeUnitsEqual$2: function(codeUnit1, codeUnit2) {
      return codeUnit1 === codeUnit2;
    },
    pathsEqual$2: function(path1, path2) {
      return path1 == path2;
    },
    canonicalizeCodeUnit$1: function(codeUnit) {
      return codeUnit;
    },
    canonicalizePart$1: function(part) {
      return part;
    }
  };
  X.ParsedPath.prototype = {
    get$basename: function() {
      var _this = this,
        t1 = P.String,
        copy = new X.ParsedPath(_this.style, _this.root, _this.isRootRelative, P.List_List$from(_this.parts, true, t1), P.List_List$from(_this.separators, true, t1));
      copy.removeTrailingSeparators$0();
      t1 = copy.parts;
      if (t1.length === 0) {
        t1 = _this.root;
        return t1 == null ? "" : t1;
      }
      return C.JSArray_methods.get$last(t1);
    },
    get$hasTrailingSeparator: function() {
      var t1 = this.parts;
      if (t1.length !== 0)
        t1 = J.$eq$(C.JSArray_methods.get$last(t1), "") || !J.$eq$(C.JSArray_methods.get$last(this.separators), "");
      else
        t1 = false;
      return t1;
    },
    removeTrailingSeparators$0: function() {
      var t1, t2, _this = this;
      while (true) {
        t1 = _this.parts;
        if (!(t1.length !== 0 && J.$eq$(C.JSArray_methods.get$last(t1), "")))
          break;
        C.JSArray_methods.removeLast$0(_this.parts);
        C.JSArray_methods.removeLast$0(_this.separators);
      }
      t1 = _this.separators;
      t2 = t1.length;
      if (t2 !== 0)
        t1[t2 - 1] = "";
    },
    normalize$1$canonicalize: function(canonicalize) {
      var t2, t3, t4, leadingDoubles, _i, part, t5, newSeparators, _this = this,
        t1 = P.String,
        newParts = H.setRuntimeTypeInfo([], [t1]);
      for (t2 = _this.parts, t3 = t2.length, t4 = _this.style, leadingDoubles = 0, _i = 0; _i < t2.length; t2.length === t3 || (0, H.throwConcurrentModificationError)(t2), ++_i) {
        part = t2[_i];
        t5 = J.getInterceptor$(part);
        if (!(t5.$eq(part, ".") || t5.$eq(part, "")))
          if (t5.$eq(part, ".."))
            if (newParts.length !== 0)
              newParts.pop();
            else
              ++leadingDoubles;
          else
            newParts.push(canonicalize ? t4.canonicalizePart$1(part) : part);
      }
      if (_this.root == null)
        C.JSArray_methods.insertAll$2(newParts, 0, P.List_List$filled(leadingDoubles, "..", t1));
      if (newParts.length === 0 && _this.root == null)
        newParts.push(".");
      newSeparators = P.List_List$generate(newParts.length, new X.ParsedPath_normalize_closure(_this), true, t1);
      t1 = _this.root;
      C.JSArray_methods.insert$2(newSeparators, 0, t1 != null && newParts.length !== 0 && t4.needsSeparator$1(t1) ? t4.get$separator() : "");
      _this.parts = newParts;
      _this.separators = newSeparators;
      t1 = _this.root;
      if (t1 != null && t4 === $.$get$Style_windows()) {
        if (canonicalize)
          t1 = _this.root = t1.toLowerCase();
        t1.toString;
        _this.root = H.stringReplaceAllUnchecked(t1, "/", "\\");
      }
      _this.removeTrailingSeparators$0();
    },
    normalize$0: function() {
      return this.normalize$1$canonicalize(false);
    },
    toString$0: function(_) {
      var i, _this = this,
        t1 = _this.root;
      t1 = t1 != null ? t1 : "";
      for (i = 0; i < _this.parts.length; ++i)
        t1 = t1 + H.S(_this.separators[i]) + H.S(_this.parts[i]);
      t1 += H.S(C.JSArray_methods.get$last(_this.separators));
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _splitExtension$0: function() {
      var lastDot,
        file = C.JSArray_methods.lastWhere$2$orElse(this.parts, new X.ParsedPath__splitExtension_closure(), new X.ParsedPath__splitExtension_closure0());
      if (file == null)
        return H.setRuntimeTypeInfo(["", ""], [P.String]);
      if (file === "..")
        return H.setRuntimeTypeInfo(["..", ""], [P.String]);
      lastDot = C.JSString_methods.lastIndexOf$1(file, ".");
      if (lastDot <= 0)
        return H.setRuntimeTypeInfo([file, ""], [P.String]);
      return H.setRuntimeTypeInfo([C.JSString_methods.substring$2(file, 0, lastDot), C.JSString_methods.substring$1(file, lastDot)], [P.String]);
    }
  };
  X.ParsedPath_normalize_closure.prototype = {
    call$1: function(_) {
      return this.$this.style.get$separator();
    },
    $signature: 17
  };
  X.ParsedPath__splitExtension_closure.prototype = {
    call$1: function(p) {
      return p !== "";
    }
  };
  X.ParsedPath__splitExtension_closure0.prototype = {
    call$0: function() {
      return;
    }
  };
  X.PathException.prototype = {
    toString$0: function(_) {
      return "PathException: " + this.message;
    },
    $isException: 1,
    get$message: function(receiver) {
      return this.message;
    }
  };
  K.PathMap.prototype = {
    $asMap: function($V) {
      return [P.String, $V];
    }
  };
  K.PathMap__create_closure.prototype = {
    call$2: function(path1, path2) {
      if (path1 == null)
        return path2 == null;
      if (path2 == null)
        return false;
      return this._box_0.context._isWithinOrEquals$2(path1, path2) === C._PathRelation_equal;
    },
    "call*": "call$2",
    $requiredArgCount: 2
  };
  K.PathMap__create_closure0.prototype = {
    call$1: function(path) {
      return path == null ? 0 : this._box_0.context.hash$1(path);
    }
  };
  K.PathMap__create_closure1.prototype = {
    call$1: function(path) {
      return typeof path === "string" || path == null;
    },
    $signature: 21
  };
  O.Style.prototype = {
    toString$0: function(_) {
      return this.get$name();
    }
  };
  E.PosixStyle.prototype = {
    containsSeparator$1: function(path) {
      return C.JSString_methods.contains$1(path, "/");
    },
    isSeparator$1: function(codeUnit) {
      return codeUnit === 47;
    },
    needsSeparator$1: function(path) {
      var t1 = path.length;
      return t1 !== 0 && J.codeUnitAt$1$s(path, t1 - 1) !== 47;
    },
    rootLength$2$withDrive: function(path, withDrive) {
      if (path.length !== 0 && J._codeUnitAt$1$s(path, 0) === 47)
        return 1;
      return 0;
    },
    rootLength$1: function(path) {
      return this.rootLength$2$withDrive(path, false);
    },
    isRootRelative$1: function(path) {
      return false;
    },
    pathFromUri$1: function(uri) {
      var t1;
      if (uri.get$scheme() === "" || uri.get$scheme() === "file") {
        t1 = uri.get$path(uri);
        return P._Uri__uriDecode(t1, 0, t1.length, C.C_Utf8Codec, false);
      }
      throw H.wrapException(P.ArgumentError$("Uri " + uri.toString$0(0) + " must have scheme 'file:'."));
    },
    absolutePathToUri$1: function(path) {
      var parsed = X.ParsedPath_ParsedPath$parse(path, this),
        t1 = parsed.parts;
      if (t1.length === 0)
        C.JSArray_methods.addAll$1(t1, H.setRuntimeTypeInfo(["", ""], [P.String]));
      else if (parsed.get$hasTrailingSeparator())
        C.JSArray_methods.add$1(parsed.parts, "");
      return P._Uri__Uri(null, null, parsed.parts, "file");
    },
    get$name: function() {
      return "posix";
    },
    get$separator: function() {
      return "/";
    }
  };
  F.UrlStyle.prototype = {
    containsSeparator$1: function(path) {
      return C.JSString_methods.contains$1(path, "/");
    },
    isSeparator$1: function(codeUnit) {
      return codeUnit === 47;
    },
    needsSeparator$1: function(path) {
      var t1 = path.length;
      if (t1 === 0)
        return false;
      if (J.getInterceptor$s(path).codeUnitAt$1(path, t1 - 1) !== 47)
        return true;
      return C.JSString_methods.endsWith$1(path, "://") && this.rootLength$1(path) === t1;
    },
    rootLength$2$withDrive: function(path, withDrive) {
      var i, codeUnit, index, t2,
        t1 = path.length;
      if (t1 === 0)
        return 0;
      if (J.getInterceptor$s(path)._codeUnitAt$1(path, 0) === 47)
        return 1;
      for (i = 0; i < t1; ++i) {
        codeUnit = C.JSString_methods._codeUnitAt$1(path, i);
        if (codeUnit === 47)
          return 0;
        if (codeUnit === 58) {
          if (i === 0)
            return 0;
          index = C.JSString_methods.indexOf$2(path, "/", C.JSString_methods.startsWith$2(path, "//", i + 1) ? i + 3 : i);
          if (index <= 0)
            return t1;
          if (!withDrive || t1 < index + 3)
            return index;
          if (!C.JSString_methods.startsWith$1(path, "file://"))
            return index;
          if (!B.isDriveLetter(path, index + 1))
            return index;
          t2 = index + 3;
          return t1 === t2 ? t2 : index + 4;
        }
      }
      return 0;
    },
    rootLength$1: function(path) {
      return this.rootLength$2$withDrive(path, false);
    },
    isRootRelative$1: function(path) {
      return path.length !== 0 && J._codeUnitAt$1$s(path, 0) === 47;
    },
    pathFromUri$1: function(uri) {
      return J.toString$0$(uri);
    },
    relativePathToUri$1: function(path) {
      return P.Uri_parse(path);
    },
    absolutePathToUri$1: function(path) {
      return P.Uri_parse(path);
    },
    get$name: function() {
      return "url";
    },
    get$separator: function() {
      return "/";
    }
  };
  L.WindowsStyle.prototype = {
    containsSeparator$1: function(path) {
      return C.JSString_methods.contains$1(path, "/");
    },
    isSeparator$1: function(codeUnit) {
      return codeUnit === 47 || codeUnit === 92;
    },
    needsSeparator$1: function(path) {
      var t1 = path.length;
      if (t1 === 0)
        return false;
      t1 = J.codeUnitAt$1$s(path, t1 - 1);
      return !(t1 === 47 || t1 === 92);
    },
    rootLength$2$withDrive: function(path, withDrive) {
      var t2, index,
        t1 = path.length;
      if (t1 === 0)
        return 0;
      t2 = J.getInterceptor$s(path)._codeUnitAt$1(path, 0);
      if (t2 === 47)
        return 1;
      if (t2 === 92) {
        if (t1 < 2 || C.JSString_methods._codeUnitAt$1(path, 1) !== 92)
          return 1;
        index = C.JSString_methods.indexOf$2(path, "\\", 2);
        if (index > 0) {
          index = C.JSString_methods.indexOf$2(path, "\\", index + 1);
          if (index > 0)
            return index;
        }
        return t1;
      }
      if (t1 < 3)
        return 0;
      if (!B.isAlphabetic(t2))
        return 0;
      if (C.JSString_methods._codeUnitAt$1(path, 1) !== 58)
        return 0;
      t1 = C.JSString_methods._codeUnitAt$1(path, 2);
      if (!(t1 === 47 || t1 === 92))
        return 0;
      return 3;
    },
    rootLength$1: function(path) {
      return this.rootLength$2$withDrive(path, false);
    },
    isRootRelative$1: function(path) {
      return this.rootLength$1(path) === 1;
    },
    pathFromUri$1: function(uri) {
      var path, t1;
      if (uri.get$scheme() !== "" && uri.get$scheme() !== "file")
        throw H.wrapException(P.ArgumentError$("Uri " + uri.toString$0(0) + " must have scheme 'file:'."));
      path = uri.get$path(uri);
      if (uri.get$host() === "") {
        if (path.length >= 3 && C.JSString_methods.startsWith$1(path, "/") && B.isDriveLetter(path, 1))
          path = C.JSString_methods.replaceFirst$2(path, "/", "");
      } else
        path = "\\\\" + H.S(uri.get$host()) + path;
      t1 = H.stringReplaceAllUnchecked(path, "/", "\\");
      return P._Uri__uriDecode(t1, 0, t1.length, C.C_Utf8Codec, false);
    },
    absolutePathToUri$1: function(path) {
      var rootParts, t2,
        parsed = X.ParsedPath_ParsedPath$parse(path, this),
        t1 = parsed.root;
      if (J.startsWith$1$s(t1, "\\\\")) {
        t1 = H.setRuntimeTypeInfo(t1.split("\\"), [P.String]);
        rootParts = new H.WhereIterable(t1, new L.WindowsStyle_absolutePathToUri_closure(), [H.getTypeArgumentByIndex(t1, 0)]);
        C.JSArray_methods.insert$2(parsed.parts, 0, rootParts.get$last(rootParts));
        if (parsed.get$hasTrailingSeparator())
          C.JSArray_methods.add$1(parsed.parts, "");
        return P._Uri__Uri(rootParts.get$first(rootParts), null, parsed.parts, "file");
      } else {
        if (parsed.parts.length === 0 || parsed.get$hasTrailingSeparator())
          C.JSArray_methods.add$1(parsed.parts, "");
        t1 = parsed.parts;
        t2 = parsed.root;
        t2.toString;
        t2 = H.stringReplaceAllUnchecked(t2, "/", "");
        C.JSArray_methods.insert$2(t1, 0, H.stringReplaceAllUnchecked(t2, "\\", ""));
        return P._Uri__Uri(null, null, parsed.parts, "file");
      }
    },
    codeUnitsEqual$2: function(codeUnit1, codeUnit2) {
      var upperCase1;
      if (codeUnit1 === codeUnit2)
        return true;
      if (codeUnit1 === 47)
        return codeUnit2 === 92;
      if (codeUnit1 === 92)
        return codeUnit2 === 47;
      if ((codeUnit1 ^ codeUnit2) !== 32)
        return false;
      upperCase1 = codeUnit1 | 32;
      return upperCase1 >= 97 && upperCase1 <= 122;
    },
    pathsEqual$2: function(path1, path2) {
      var t1, t2, i;
      if (path1 == path2)
        return true;
      t1 = path1.length;
      if (t1 !== path2.length)
        return false;
      for (t2 = J.getInterceptor$s(path2), i = 0; i < t1; ++i)
        if (!this.codeUnitsEqual$2(C.JSString_methods._codeUnitAt$1(path1, i), t2._codeUnitAt$1(path2, i)))
          return false;
      return true;
    },
    canonicalizeCodeUnit$1: function(codeUnit) {
      if (codeUnit === 47)
        return 92;
      if (codeUnit < 65)
        return codeUnit;
      if (codeUnit > 90)
        return codeUnit;
      return codeUnit | 32;
    },
    canonicalizePart$1: function(part) {
      return part.toLowerCase();
    },
    get$name: function() {
      return "windows";
    },
    get$separator: function() {
      return "\\";
    }
  };
  L.WindowsStyle_absolutePathToUri_closure.prototype = {
    call$1: function(part) {
      return part !== "";
    }
  };
  F.CssMediaQuery.prototype = {
    merge$1: function(other) {
      var _i, t8, negativeFeatures, features, type, modifier, fewerFeatures, fewerFeatures0, moreFeatures, _this = this, _null = null, _s3_ = "all",
        t1 = _this.modifier,
        ourModifier = t1 == null ? _null : t1.toLowerCase(),
        t2 = _this.type,
        t3 = t2 == null,
        ourType = t3 ? _null : t2.toLowerCase(),
        t4 = other.modifier,
        theirModifier = t4 == null ? _null : t4.toLowerCase(),
        t5 = other.type,
        t6 = t5 == null,
        theirType = t6 ? _null : t5.toLowerCase(),
        t7 = ourType == null;
      if (t7 && theirType == null) {
        t1 = P.String;
        t2 = H.setRuntimeTypeInfo([], [t1]);
        for (t3 = _this.features, t4 = t3.length, _i = 0; _i < t4; ++_i)
          t2.push(t3[_i]);
        for (t3 = other.features, t4 = t3.length, _i = 0; _i < t4; ++_i)
          t2.push(t3[_i]);
        return new F.MediaQuerySuccessfulMergeResult(new F.CssMediaQuery(_null, _null, P.List_List$unmodifiable(t2, t1)));
      }
      t8 = ourModifier === "not";
      if (t8 !== (theirModifier === "not")) {
        if (ourType == theirType) {
          negativeFeatures = t8 ? _this.features : other.features;
          if (C.JSArray_methods.every$1(negativeFeatures, C.JSArray_methods.get$contains(t8 ? other.features : _this.features)))
            return C._SingletonCssMediaQueryMergeResult_empty;
          else
            return C._SingletonCssMediaQueryMergeResult_unrepresentable;
        } else if (t3 || B.equalsIgnoreCase(t2, _s3_) || t6 || B.equalsIgnoreCase(t5, _s3_))
          return C._SingletonCssMediaQueryMergeResult_unrepresentable;
        if (t8) {
          features = other.features;
          type = theirType;
          modifier = theirModifier;
        } else {
          features = _this.features;
          type = ourType;
          modifier = ourModifier;
        }
      } else if (t8) {
        if (ourType != theirType)
          return C._SingletonCssMediaQueryMergeResult_unrepresentable;
        fewerFeatures = _this.features;
        fewerFeatures0 = other.features;
        t3 = fewerFeatures.length > fewerFeatures0.length;
        moreFeatures = t3 ? fewerFeatures : fewerFeatures0;
        if (t3)
          fewerFeatures = fewerFeatures0;
        if (!C.JSArray_methods.every$1(fewerFeatures, C.JSArray_methods.get$contains(moreFeatures)))
          return C._SingletonCssMediaQueryMergeResult_unrepresentable;
        features = moreFeatures;
        type = ourType;
        modifier = ourModifier;
      } else if (t3 || B.equalsIgnoreCase(t2, _s3_)) {
        type = (t6 || B.equalsIgnoreCase(t5, _s3_)) && t7 ? _null : theirType;
        t3 = H.setRuntimeTypeInfo([], [P.String]);
        for (t6 = _this.features, t7 = t6.length, _i = 0; _i < t7; ++_i)
          t3.push(t6[_i]);
        for (t6 = other.features, t7 = t6.length, _i = 0; _i < t7; ++_i)
          t3.push(t6[_i]);
        features = t3;
        modifier = theirModifier;
      } else {
        if (t6 || B.equalsIgnoreCase(t5, _s3_)) {
          t3 = H.setRuntimeTypeInfo([], [P.String]);
          for (t6 = _this.features, t7 = t6.length, _i = 0; _i < t7; ++_i)
            t3.push(t6[_i]);
          for (t6 = other.features, t7 = t6.length, _i = 0; _i < t7; ++_i)
            t3.push(t6[_i]);
          features = t3;
          modifier = ourModifier;
        } else {
          if (ourType != theirType)
            return C._SingletonCssMediaQueryMergeResult_empty;
          else {
            modifier = ourModifier == null ? theirModifier : ourModifier;
            t3 = H.setRuntimeTypeInfo([], [P.String]);
            for (t6 = _this.features, t7 = t6.length, _i = 0; _i < t7; ++_i)
              t3.push(t6[_i]);
            for (t6 = other.features, t7 = t6.length, _i = 0; _i < t7; ++_i)
              t3.push(t6[_i]);
          }
          features = t3;
        }
        type = ourType;
      }
      t2 = type == ourType ? t2 : t5;
      return new F.MediaQuerySuccessfulMergeResult(F.CssMediaQuery$(t2, features, modifier == ourModifier ? t1 : t4));
    },
    $eq: function(_, other) {
      if (other == null)
        return false;
      return other instanceof F.CssMediaQuery && other.modifier == this.modifier && other.type == this.type && C.C_ListEquality.equals$2(other.features, this.features);
    },
    get$hashCode: function(_) {
      return J.get$hashCode$(this.modifier) ^ J.get$hashCode$(this.type) ^ C.C_ListEquality.hash$1(this.features);
    },
    toString$0: function(_) {
      var t2, _this = this,
        t1 = _this.modifier;
      t1 = t1 != null ? t1 + " " : "";
      t2 = _this.type;
      if (t2 != null) {
        t1 += t2;
        if (_this.features.length !== 0)
          t1 += " and ";
      }
      t1 += C.JSArray_methods.join$1(_this.features, " and ");
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    }
  };
  F._SingletonCssMediaQueryMergeResult.prototype = {
    toString$0: function(_) {
      return this._media_query$_name;
    }
  };
  F.MediaQuerySuccessfulMergeResult.prototype = {};
  U.ModifiableCssAtRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssAtRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    copyWithoutChildren$0: function() {
      var _this = this,
        t1 = B.ModifiableCssNode,
        t2 = H.setRuntimeTypeInfo([], [t1]);
      return new U.ModifiableCssAtRule(_this.name, _this.value, _this.isChildless, _this.span, new P.UnmodifiableListView(t2, [t1]), t2);
    },
    addChild$1: function(child) {
      this.super$ModifiableCssParentNode$addChild(child);
    },
    $isCssAtRule: 1,
    get$isChildless: function() {
      return this.isChildless;
    },
    get$span: function() {
      return this.span;
    }
  };
  R.ModifiableCssComment.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssComment$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    $isCssComment: 1,
    get$span: function() {
      return this.span;
    }
  };
  L.ModifiableCssDeclaration.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssDeclaration$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    get$span: function() {
      return this.span;
    }
  };
  F.ModifiableCssImport.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssImport$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    $isCssImport: 1,
    get$span: function() {
      return this.span;
    }
  };
  U.ModifiableCssKeyframeBlock.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssKeyframeBlock$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    copyWithoutChildren$0: function() {
      var t1 = B.ModifiableCssNode,
        t2 = H.setRuntimeTypeInfo([], [t1]);
      return new U.ModifiableCssKeyframeBlock(this.selector, this.span, new P.UnmodifiableListView(t2, [t1]), t2);
    },
    get$span: function() {
      return this.span;
    }
  };
  G.ModifiableCssMediaRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssMediaRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    copyWithoutChildren$0: function() {
      return G.ModifiableCssMediaRule$(this.queries, this.span);
    },
    $isCssMediaRule: 1,
    get$span: function() {
      return this.span;
    }
  };
  B.ModifiableCssNode.prototype = {
    get$hasFollowingSibling: function() {
      var siblings, i, t2,
        t1 = this._parent;
      if (t1 == null)
        return false;
      siblings = t1.children;
      for (i = this._indexInParent + 1, t1 = siblings._collection$_source, t2 = J.getInterceptor$asx(t1); i < t2.get$length(t1); ++i)
        if (!this._node0$_isInvisible$1(t2.elementAt$1(t1, i)))
          return true;
      return false;
    },
    _node0$_isInvisible$1: function(node) {
      if (!!J.getInterceptor$(node).$isCssParentNode) {
        if (!!node.$isCssAtRule)
          return false;
        if (!!node.$isCssStyleRule && node.selector.value.get$isInvisible())
          return true;
        return J.every$1$ax(node.get$children(), this.get$_node0$_isInvisible());
      } else
        return false;
    },
    get$isGroupEnd: function() {
      return this.isGroupEnd;
    }
  };
  B.ModifiableCssParentNode.prototype = {
    get$isChildless: function() {
      return false;
    },
    addChild$1: function(child) {
      var t1;
      child._parent = this;
      t1 = this._children;
      child._indexInParent = t1.length;
      t1.push(child);
    },
    $isCssParentNode: 1,
    get$children: function() {
      return this.children;
    }
  };
  X.ModifiableCssStyleRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssStyleRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    copyWithoutChildren$0: function() {
      return X.ModifiableCssStyleRule$(this.selector, this.span, this.originalSelector);
    },
    $isCssStyleRule: 1,
    get$span: function() {
      return this.span;
    }
  };
  V.ModifiableCssStylesheet.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssStylesheet$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    copyWithoutChildren$0: function() {
      var t1 = B.ModifiableCssNode,
        t2 = H.setRuntimeTypeInfo([], [t1]);
      return new V.ModifiableCssStylesheet(this.span, new P.UnmodifiableListView(t2, [t1]), t2);
    },
    $isCssStylesheet: 1,
    get$span: function() {
      return this.span;
    }
  };
  B.ModifiableCssSupportsRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitCssSupportsRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    copyWithoutChildren$0: function() {
      var t1 = B.ModifiableCssNode,
        t2 = H.setRuntimeTypeInfo([], [t1]);
      return new B.ModifiableCssSupportsRule(this.condition, this.span, new P.UnmodifiableListView(t2, [t1]), t2);
    },
    $isCssSupportsRule: 1,
    get$span: function() {
      return this.span;
    }
  };
  F.ModifiableCssValue.prototype = {
    toString$0: function(_) {
      return J.toString$0$(this.value);
    },
    $isCssValue: 1,
    $isAstNode: 1,
    get$value: function() {
      return this.value;
    },
    get$span: function() {
      return this.span;
    }
  };
  B.CssNode.prototype = {
    toString$0: function(_) {
      return N.serialize(this, true, null, true, null, false, null, true).css;
    }
  };
  B.CssParentNode.prototype = {};
  V.CssStylesheet.prototype = {
    get$isGroupEnd: function() {
      return false;
    },
    get$isChildless: function() {
      return false;
    },
    accept$1$1: function(visitor) {
      return visitor.visitCssStylesheet$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    get$children: function() {
      return this.children;
    },
    get$span: function() {
      return this.span;
    }
  };
  F.CssValue.prototype = {
    toString$0: function(_) {
      return J.toString$0$(this.value);
    },
    $isAstNode: 1,
    get$value: function() {
      return this.value;
    },
    get$span: function() {
      return this.span;
    }
  };
  B.AstNode.prototype = {};
  Z.Argument.prototype = {
    toString$0: function(_) {
      var t1 = this.defaultValue,
        t2 = this.name;
      return t1 == null ? t2 : t2 + ": " + t1.toString$0(0);
    },
    $isAstNode: 1,
    get$span: function() {
      return this.span;
    }
  };
  B.ArgumentDeclaration.prototype = {
    get$originalRestArgument: function() {
      var t1, text;
      if (this.restArgument == null)
        return;
      t1 = this.span;
      text = P.String_String$fromCharCodes(C.NativeUint32List_methods.sublist$2(t1.file._decodedChars, t1._start, t1._file$_end), 0, null);
      return C.JSString_methods.substring$2(C.JSString_methods.substring$1(text, C.JSString_methods.lastIndexOf$1(text, "$")), 0, C.JSString_methods.indexOf$1(text, "."));
    },
    verify$2: function(positional, names) {
      var t1, t2, t3, namedUsed, i, argument, t4, unknownNames, _this = this,
        _s8_ = "argument";
      for (t1 = _this.$arguments, t2 = t1.length, t3 = names._baseMap, namedUsed = 0, i = 0; i < t2; ++i) {
        argument = t1[i];
        if (i < positional) {
          t4 = argument.name;
          if (t3.containsKey$1(t4))
            throw H.wrapException(E.SassScriptException$("Argument " + H.S(_this._originalArgumentName$1(t4)) + " was passed both by position and by name."));
        } else {
          t4 = argument.name;
          if (t3.containsKey$1(t4))
            ++namedUsed;
          else if (argument.defaultValue == null)
            throw H.wrapException(E.SassScriptException$("Missing argument " + H.S(_this._originalArgumentName$1(t4)) + "."));
        }
      }
      if (_this.restArgument != null)
        return;
      if (positional > t2) {
        t1 = "Only " + t2 + " ";
        throw H.wrapException(E.SassScriptException$(t1 + (names.get$isEmpty(names) ? "" : "positional ") + B.pluralize(_s8_, t2, null) + " allowed, but " + positional + " " + B.pluralize("was", positional, "were") + " passed."));
      }
      if (namedUsed < t3.get$length(t3)) {
        unknownNames = P.LinkedHashSet_LinkedHashSet$of(names, P.String);
        t2 = P.Object;
        unknownNames.removeAll$1(new H.MappedListIterable(t1, new B.ArgumentDeclaration_verify_closure(), [H.getTypeArgumentByIndex(t1, 0), t2]));
        throw H.wrapException(E.SassScriptException$("No " + B.pluralize(_s8_, unknownNames._collection$_length, null) + " named " + H.S(B.toSentence(unknownNames.map$1$1(0, new B.ArgumentDeclaration_verify_closure0(), t2), "or")) + "."));
      }
    },
    _originalArgumentName$1: function($name) {
      var t1, t2, _i, argument, t3, text, end;
      if ($name === this.restArgument)
        return this.get$originalRestArgument();
      for (t1 = this.$arguments, t2 = t1.length, _i = 0; _i < t2; ++_i) {
        argument = t1[_i];
        if (argument.name === $name) {
          if (argument.defaultValue == null) {
            t1 = argument.span;
            t2 = t1._start;
            t3 = t1.file._decodedChars;
            t3 = P.String_String$fromCharCodes(new Uint32Array(t3.subarray(t2, H._checkValidRange(t2, t1._file$_end, t3.length))), 0, null);
            t1 = t3;
          } else {
            t1 = argument.span;
            t2 = t1._start;
            t3 = t1.file._decodedChars;
            text = P.String_String$fromCharCodes(new Uint32Array(t3.subarray(t2, H._checkValidRange(t2, t1._file$_end, t3.length))), 0, null);
            t3 = C.JSString_methods.substring$2(text, 0, C.JSString_methods.indexOf$1(text, ":"));
            end = B._lastNonWhitespace(t3, false);
            t1 = end == null ? "" : C.JSString_methods.substring$2(t3, 0, end + 1);
          }
          return t1;
        }
      }
      throw H.wrapException(P.ArgumentError$('This declaration has no argument named "$' + $name + '".'));
    },
    matches$2: function(positional, names) {
      var t1, t2, t3, namedUsed, i, argument;
      for (t1 = this.$arguments, t2 = t1.length, t3 = names._baseMap, namedUsed = 0, i = 0; i < t2; ++i) {
        argument = t1[i];
        if (i < positional) {
          if (t3.containsKey$1(argument.name))
            return false;
        } else if (t3.containsKey$1(argument.name))
          ++namedUsed;
        else if (argument.defaultValue == null)
          return false;
      }
      if (this.restArgument != null)
        return true;
      if (positional > t2)
        return false;
      if (namedUsed < t3.get$length(t3))
        return false;
      return true;
    },
    toString$0: function(_) {
      var t2, t3, _i,
        t1 = H.setRuntimeTypeInfo([], [P.String]);
      for (t2 = this.$arguments, t3 = t2.length, _i = 0; _i < t3; ++_i)
        t1.push(J.toString$0$(t2[_i]));
      t2 = this.restArgument;
      if (t2 != null)
        t1.push(t2 + "...");
      return C.JSArray_methods.join$1(t1, ", ");
    },
    $isAstNode: 1,
    get$span: function() {
      return this.span;
    }
  };
  B.ArgumentDeclaration_verify_closure.prototype = {
    call$1: function(argument) {
      return argument.name;
    }
  };
  B.ArgumentDeclaration_verify_closure0.prototype = {
    call$1: function($name) {
      return "$" + H.S($name);
    }
  };
  X.ArgumentInvocation.prototype = {
    get$isEmpty: function(_) {
      var t1;
      if (this.positional.length === 0) {
        t1 = this.named;
        t1 = t1.get$isEmpty(t1) && this.rest == null;
      } else
        t1 = false;
      return t1;
    },
    toString$0: function(_) {
      var t2, t3, _i, t4, _this = this,
        t1 = H.setRuntimeTypeInfo([], [P.Object]);
      for (t2 = _this.positional, t3 = t2.length, _i = 0; _i < t3; ++_i)
        t1.push(t2[_i]);
      for (t2 = _this.named, t3 = J.get$iterator$ax(t2.get$keys()); t3.moveNext$0();) {
        t4 = t3.get$current(t3);
        t1.push(H.S(t4) + ": " + H.S(t2.$index(0, t4)));
      }
      t2 = _this.rest;
      if (t2 != null)
        t1.push(t2.toString$0(0) + "...");
      t2 = _this.keywordRest;
      if (t2 != null)
        t1.push(t2.toString$0(0) + "...");
      return "(" + C.JSArray_methods.join$1(t1, ", ") + ")";
    },
    $isAstNode: 1,
    get$span: function() {
      return this.span;
    }
  };
  V.AtRootQuery.prototype = {
    excludes$1: function(node) {
      var _this = this;
      if (_this._all)
        return !_this.include;
      if (_this._at_root_query$_rule && !!J.getInterceptor$(node).$isCssStyleRule)
        return !_this.include;
      return _this.names.contains$1(0, _this._nameFor$1(node)) !== _this.include;
    },
    _nameFor$1: function(node) {
      var t1 = J.getInterceptor$(node);
      if (!!t1.$isCssMediaRule)
        return "media";
      if (!!t1.$isCssSupportsRule)
        return "supports";
      if (!!t1.$isCssAtRule)
        return node.name.get$value().toLowerCase();
      return;
    }
  };
  Z.ConfiguredVariable.prototype = {
    toString$0: function(_) {
      var t1 = "$" + this.name + ": " + H.S(this.expression);
      return t1 + (this.isGuarded ? " !default" : "");
    },
    $isAstNode: 1,
    get$span: function() {
      return this.span;
    }
  };
  T.Expression.prototype = {$isAstNode: 1};
  V.BinaryOperationExpression.prototype = {
    get$span: function() {
      var right,
        left = this.left;
      for (; left instanceof V.BinaryOperationExpression;)
        left = left.left;
      right = this.right;
      for (; right instanceof V.BinaryOperationExpression;)
        right = right.right;
      return B.spanForList(H.setRuntimeTypeInfo([left, right], [B.AstNode]));
    },
    accept$1$1: function(visitor) {
      return visitor.visitBinaryOperationExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t2, right, rightNeedsParens, _this = this,
        left = _this.left,
        leftNeedsParens = left instanceof V.BinaryOperationExpression && left.operator.precedence < _this.operator.precedence,
        t1 = leftNeedsParens ? H.Primitives_stringFromCharCode(40) : "";
      t1 += H.S(left);
      if (leftNeedsParens)
        t1 += H.Primitives_stringFromCharCode(41);
      t2 = _this.operator;
      t1 = t1 + H.Primitives_stringFromCharCode(32) + t2.operator + H.Primitives_stringFromCharCode(32);
      right = _this.right;
      rightNeedsParens = right instanceof V.BinaryOperationExpression && right.operator.precedence <= t2.precedence;
      if (rightNeedsParens)
        t1 += H.Primitives_stringFromCharCode(40);
      t1 += H.S(right);
      if (rightNeedsParens)
        t1 += H.Primitives_stringFromCharCode(41);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    $isAstNode: 1,
    $isExpression: 1
  };
  V.BinaryOperator.prototype = {
    toString$0: function(_) {
      return this.name;
    }
  };
  Z.BooleanExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitBooleanExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return String(this.value);
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  K.ColorExpression.prototype = {
    get$span: function() {
      return this.value.originalSpan;
    },
    accept$1$1: function(visitor) {
      return visitor.visitColorExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return N.serializeValue(this.value, true, true);
    },
    $isAstNode: 1,
    $isExpression: 1
  };
  F.FunctionExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitFunctionExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = this.namespace;
      t1 = t1 != null ? t1 + "." : "";
      t1 += this.name.toString$0(0) + this.$arguments.toString$0(0);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  L.IfExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitIfExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return "if" + this.$arguments.toString$0(0);
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  D.ListExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitListExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var _this = this,
        t1 = _this.hasBrackets,
        t2 = t1 ? H.Primitives_stringFromCharCode(91) : "",
        t3 = _this.contents,
        t4 = _this.separator === C.ListSeparator_comma ? ", " : " ";
      t4 = t2 + new H.MappedListIterable(t3, new D.ListExpression_toString_closure(_this), [H.getTypeArgumentByIndex(t3, 0), P.String]).join$1(0, t4);
      t1 = t1 ? t4 + H.Primitives_stringFromCharCode(93) : t4;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    _list0$_elementNeedsParens$1: function(expression) {
      var t2,
        t1 = J.getInterceptor$(expression);
      if (!!t1.$isListExpression) {
        if (expression.contents.length < 2)
          return false;
        if (expression.hasBrackets)
          return false;
        t1 = this.separator;
        t2 = t1 === C.ListSeparator_comma;
        return t2 ? t2 : t1 !== C.ListSeparator_undecided;
      }
      if (this.separator !== C.ListSeparator_space)
        return false;
      if (!!t1.$isUnaryOperationExpression) {
        t1 = expression.operator;
        return t1 === C.UnaryOperator_j2w || t1 === C.UnaryOperator_U4G;
      }
      return false;
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  D.ListExpression_toString_closure.prototype = {
    call$1: function(element) {
      return this.$this._list0$_elementNeedsParens$1(element) ? "(" + H.S(element) + ")" : J.toString$0$(element);
    }
  };
  A.MapExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitMapExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = this.pairs;
      return "(" + new H.MappedListIterable(t1, new A.MapExpression_toString_closure(), [H.getTypeArgumentByIndex(t1, 0), P.String]).join$1(0, ", ") + ")";
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  A.MapExpression_toString_closure.prototype = {
    call$1: function(pair) {
      return H.S(pair.item1) + ": " + H.S(pair.item2);
    }
  };
  O.NullExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitNullExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return "null";
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  T.NumberExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitNumberExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = H.S(this.value),
        t2 = this.unit;
      return t1 + (t2 == null ? "" : t2);
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  T.ParenthesizedExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitParenthesizedExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return J.toString$0$(this.expression);
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  T.SelectorExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitSelectorExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return "&";
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  D.StringExpression.prototype = {
    get$span: function() {
      return this.text.span;
    },
    accept$1$1: function(visitor) {
      return visitor.visitStringExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    asInterpolation$1$static: function($static) {
      var quote, t1, t2, buffer, t3, t4, t5, _i, value, t6, t7, i, codeUnit, next, t8, _this = this;
      if (!_this.hasQuotes)
        return _this.text;
      quote = _this._bestQuote$0();
      t1 = new P.StringBuffer("");
      t2 = [];
      buffer = new Z.InterpolationBuffer(t1, t2);
      t1._contents += H.Primitives_stringFromCharCode(quote);
      for (t3 = _this.text, t4 = t3.contents, t5 = t4.length, _i = 0; _i < t5; ++_i) {
        value = t4[_i];
        if (!!J.getInterceptor$(value).$isExpression) {
          buffer._flushText$0();
          t2.push(value);
        } else if (typeof value === "string")
          for (t6 = value.length, t7 = t6 - 1, i = 0; i < t6; ++i) {
            codeUnit = C.JSString_methods._codeUnitAt$1(value, i);
            if (codeUnit === 10 || codeUnit === 13 || codeUnit === 12) {
              t1._contents += H.Primitives_stringFromCharCode(92);
              t1._contents += H.Primitives_stringFromCharCode(97);
              if (i !== t7) {
                next = C.JSString_methods._codeUnitAt$1(value, i + 1);
                if (next === 32 || next === 9 || next === 10 || next === 13 || next === 12 || T.isHex(next))
                  t1._contents += H.Primitives_stringFromCharCode(32);
              }
            } else {
              if (codeUnit !== quote)
                if (codeUnit !== 92)
                  t8 = $static && codeUnit === 35 && i < t7 && C.JSString_methods._codeUnitAt$1(value, i + 1) === 123;
                else
                  t8 = true;
              else
                t8 = true;
              if (t8)
                t1._contents += H.Primitives_stringFromCharCode(92);
              t1._contents += H.Primitives_stringFromCharCode(codeUnit);
            }
          }
      }
      t1._contents += H.Primitives_stringFromCharCode(quote);
      return buffer.interpolation$1(t3.span);
    },
    asInterpolation$0: function() {
      return this.asInterpolation$1$static(false);
    },
    _bestQuote$0: function() {
      var t1, t2, containsDoubleQuote, _i, value, t3, i, codeUnit;
      for (t1 = this.text.contents, t2 = t1.length, containsDoubleQuote = false, _i = 0; _i < t2; ++_i) {
        value = t1[_i];
        if (typeof value === "string")
          for (t3 = value.length, i = 0; i < t3; ++i) {
            codeUnit = C.JSString_methods._codeUnitAt$1(value, i);
            if (codeUnit === 39)
              return 34;
            if (codeUnit === 34)
              containsDoubleQuote = true;
          }
      }
      return containsDoubleQuote ? 39 : 34;
    },
    toString$0: function(_) {
      return this.asInterpolation$0().toString$0(0);
    },
    $isAstNode: 1,
    $isExpression: 1
  };
  X.UnaryOperationExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitUnaryOperationExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = this.operator,
        t2 = t1.operator;
      t1 = t1 === C.UnaryOperator_not_not ? t2 + H.Primitives_stringFromCharCode(32) : t2;
      t1 += H.S(this.operand);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  X.UnaryOperator.prototype = {
    toString$0: function(_) {
      return this.name;
    }
  };
  F.ValueExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitValueExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      return J.toString$0$(this.value);
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  S.VariableExpression.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitVariableExpression$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = this.namespace;
      t1 = t1 != null ? "$" + (t1 + ".") : "$";
      t1 += this.name;
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    $isAstNode: 1,
    $isExpression: 1,
    get$span: function() {
      return this.span;
    }
  };
  F.Import.prototype = {$isAstNode: 1};
  B.DynamicImport.prototype = {
    toString$0: function(_) {
      return new D.StringExpression(X.Interpolation$(H.setRuntimeTypeInfo([this.url], [P.Object]), null), true).asInterpolation$1$static(true).get$asPlain();
    },
    $isAstNode: 1,
    $isImport: 1,
    get$span: function() {
      return this.span;
    }
  };
  Q.StaticImport.prototype = {
    toString$0: function(_) {
      var t1 = this.url.toString$0(0),
        t2 = this.supports;
      if (t2 != null)
        t1 += " supports(" + t2.toString$0(0) + ")";
      t2 = this.media;
      if (t2 != null)
        t1 += " " + t2.toString$0(0);
      t1 += H.Primitives_stringFromCharCode(59);
      return t1.charCodeAt(0) == 0 ? t1 : t1;
    },
    $isAstNode: 1,
    $isImport: 1,
    get$span: function() {
      return this.span;
    }
  };
  X.Interpolation.prototype = {
    get$asPlain: function() {
      var first,
        t1 = this.contents,
        t2 = t1.length;
      if (t2 === 0)
        return "";
      if (t2 > 1)
        return;
      first = C.JSArray_methods.get$first(t1);
      return typeof first === "string" ? first : null;
    },
    Interpolation$2: function(contents, span) {
      var t1, t2, i, t3, t4,
        _s8_ = "contents";
      for (t1 = this.contents, t2 = t1.length, i = 0; i < t2; ++i) {
        t3 = t1[i];
        t4 = typeof t3 === "string";
        if (!t4 && !J.getInterceptor$(t3).$isExpression)
          throw H.wrapException(P.ArgumentError$value(t1, _s8_, "May only contains Strings or Expressions."));
        if (i !== 0) {
          t3 = t1[i - 1];
          t3 = typeof t3 === "string" && t4;
        } else
          t3 = false;
        if (t3)
          throw H.wrapException(P.ArgumentError$value(t1, _s8_, "May not contain adjacent Strings."));
      }
    },
    toString$0: function(_) {
      var t1 = this.contents;
      return new H.MappedListIterable(t1, new X.Interpolation_toString_closure(), [H.getTypeArgumentByIndex(t1, 0), P.String]).join$0(0);
    },
    $isAstNode: 1,
    get$span: function() {
      return this.span;
    }
  };
  X.Interpolation_toString_closure.prototype = {
    call$1: function(value) {
      return typeof value === "string" ? value : "#{" + H.S(value) + "}";
    },
    $signature: 13
  };
  B.SassNode.prototype = {};
  O.Statement.prototype = {$isAstNode: 1};
  V.AtRootRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitAtRootRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var buffer = new P.StringBuffer("@at-root "),
        t1 = this.query;
      if (t1 != null)
        buffer._contents = "@at-root " + (t1.toString$0(0) + " ");
      t1 = this.children;
      return buffer.toString$0(0) + " {" + (t1 && C.JSArray_methods).join$1(t1, " ") + "}";
    },
    get$span: function() {
      return this.span;
    }
  };
  U.AtRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitAtRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = "@" + this.name.toString$0(0),
        buffer = new P.StringBuffer(t1),
        t2 = this.value;
      if (t2 != null)
        buffer._contents = t1 + (" " + t2.toString$0(0));
      t1 = this.children;
      return t1 == null ? buffer.toString$0(0) + ";" : buffer.toString$0(0) + " {" + C.JSArray_methods.join$1(t1, " ") + "}";
    },
    get$span: function() {
      return this.span;
    }
  };
  M.CallableDeclaration.prototype = {
    get$span: function() {
      return this.span;
    }
  };
  Y.ContentBlock.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitContentBlock$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t2,
        t1 = this.$arguments;
      t1 = t1.$arguments.length === 0 && t1.restArgument == null ? "" : " using (" + t1.toString$0(0) + ")";
      t2 = this.children;
      return t1 + (" {" + (t2 && C.JSArray_methods).join$1(t2, " ") + "}");
    }
  };
  Q.ContentRule.prototype = {
    accept$1$1: function(visitor) {
      return visitor.visitContentRule$1(this);
    },
    accept$1: function(visitor) {
      return this.accept$1$1(visitor, null);
    },
    toString$0: function(_) {
      var t1 = this.$arguments;
      return t1.get$isEmpty(t1) ? "@content;" : "@content(" + t1.toString$0(0) + ");";
    },
    $isAstNode: 1,
    $isStatement: 1,
    get$span: function() {
      return this.span;
    }
  };
  Q.DebugRule.prototype