#!/usr/bin/env node
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { join, dirname } from 'path';
import * as colors from 'colors/safe';
import { exec } from 'child_process';
import { copy, pathExists, mkdir, mkdirp, writeFile } from 'fs-extra';
const creating = (what, how = 'creating') => {
    console.log(colors.green('✓') + ` ${how} ${what}`);
};
const notCreating = (what) => {
    console.log(colors.dim('-') + ' not creating ' + what);
};
const tsconfig = {
    extends: './node_modules/@kui-shell/builder/tsconfig-base.json',
    references: [{ path: 'plugins/plugin-sample' }]
};
const copyDirectory = (breadcrumb, target, force) => __awaiter(void 0, void 0, void 0, function* () {
    const targetExists = yield pathExists(target);
    if (!targetExists || force) {
        if (!targetExists) {
            yield mkdir(target);
        }
        const source = dirname(require.resolve(breadcrumb));
        yield copy(source, target, {
            preserveTimestamps: true
        });
        creating(target);
    }
    else {
        notCreating(target);
    }
});
export const main = (argv) => __awaiter(void 0, void 0, void 0, function* () {
    const force = !!argv.find(_ => _ === '-f' || _ === '--force');
    if (!(yield pathExists('plugins'))) {
        yield mkdir('plugins');
        creating('plugins directory');
    }
    else {
        notCreating('plugins directory');
    }
    if (!(yield pathExists('packages/app/src'))) {
        yield mkdirp('packages/app/src');
        creating('packages/app/src directory');
    }
    else {
        notCreating('packages/app/src directory');
    }
    if (!(yield pathExists('packages/app/src/main.ts'))) {
        yield writeFile('packages/app/src/main.ts', '// intentionally blank');
        creating('packages/app/src directory');
    }
    else {
        notCreating('packages/app/src directory');
    }
    if (!(yield pathExists('tsconfig.json'))) {
        yield writeFile('tsconfig.json', JSON.stringify(tsconfig, undefined, 2));
        creating('tsconfig.json');
    }
    else {
        notCreating('tsconfig.json');
    }
    copyDirectory('@kui-shell/builder/examples/plugin-sample/package.json', 'plugins/plugin-sample', force);
    creating('reconfiguring package.json');
    const pjson = require(join(__dirname, '../../../../package.json'));
    pjson.main = 'node_modules/@kui-shell/core/dist/main/main.js';
    if (!pjson.devDependencies) {
        pjson.devDependencies = {};
    }
    pjson.devDependencies.mocha = '6.1.4';
    pjson.devDependencies['@types/mocha'] = '5.2.7';
    pjson.devDependencies['@types/node'] = '12.0.10';
    pjson.devDependencies.electron = '6.0.8';
    pjson.devDependencies.spectron = '8.0.0';
    pjson.devDependencies.typescript = '3.6.3';
    if (!pjson.dependencies) {
        pjson.dependencies = {};
    }
    pjson.dependencies['@kui-shell/plugin-sample'] = 'file:./plugins/plugin-sample';
    if (!pjson.scripts) {
        pjson.scripts = {};
    }
    pjson.scripts.init = 'if [ ! -e node_modules/@kui-shell/prescan.json ]; then kui-compile; fi';
    pjson.scripts.compile = 'kui-compile';
    pjson.scripts.watch = 'tsc --build . --watch';
    pjson.scripts['watch:webpack'] = 'kui-watch-webpack';
    pjson.scripts['pty:rebuild'] = 'cd node_modules/node-pty-prebuilt-multiarch && npm run install';
    pjson.scripts['pty:electron'] =
        'if [ ! -e node_modules/node-pty-prebuilt-multiarch/.npmrc ]; then cp node_modules/@kui-shell/builder/npmrc node_modules/node-pty-prebuilt-multiarch/.npmrc && npm run pty:rebuild; fi';
    pjson.scripts['pty:nodejs'] =
        'if [ -e node_modules/node-pty-prebuilt-multiarch/.npmrc ]; then rm -f node_modules/node-pty-prebuilt-multiarch/.npmrc; npm run pty:rebuild; fi';
    pjson.scripts.start = 'npm run -s init && npm run -s pty:electron && electron . shell';
    yield writeFile('package.json', JSON.stringify(pjson, undefined, 2));
    creating('npm install', 'running');
    yield new Promise((resolve, reject) => {
        exec('npm install', (err, stdout, stderr) => {
            if (err) {
                console.error(err);
                reject(stderr);
            }
            else {
                resolve();
            }
        });
    });
});
main(process.argv);
//# sourceMappingURL=kui-dist-init.js.map