"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('core/fuzz-testing');
debug('loading');
const nope = (filepath) => {
    return filepath.toString().indexOf('.wskprops') >= 0 || filepath.toString().indexOf('.cf/config.json') >= 0;
};
const fuzzies = {
    noAuth: () => __awaiter(void 0, void 0, void 0, function* () {
        const fs = require('fs');
        const rf = fs.readFile;
        const rfs = fs.readFileSync;
        fs.readFile = function (filepath, options, cb) {
            if (nope(filepath)) {
                debug('fs.readFile blocked', filepath);
                rf('fjdioafjadisofjadsoifasfsdfjadisfjadisofjasifas', options ? cb : options);
            }
            else {
                if (!cb) {
                    rf(filepath, options);
                }
                else {
                    rf(filepath, options, cb);
                }
            }
        };
        fs.readFileSync = function (filepath, options) {
            if (nope(filepath)) {
                console.error(`fs.readFileSync blocked ${filepath}`);
                return rfs('fjdioafjadisofjadsoifasfsdfjadisfjadisofjasifas');
            }
            else {
                return rfs(filepath, options);
            }
        };
    })
};
exports.default = (_fuzz) => __awaiter(void 0, void 0, void 0, function* () {
    const fuzz = JSON.parse(_fuzz);
    yield Promise.all((fuzz.rules || []).map((rule) => __awaiter(void 0, void 0, void 0, function* () {
        debug('rule', rule);
        yield fuzzies[rule]();
    })));
    return fuzz.prefs;
});
//# sourceMappingURL=fuzz-testing.js.map