"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function isErrorWithResultField(error) {
    const err = error;
    return !!(err.error && err.error.response && err.error.response.result && err.error.response.result.error);
}
function isErrorWithNestedResultField(error) {
    const err = error;
    return !!(err.error &&
        err.error.response &&
        err.error.response.result &&
        err.error.response.result.error &&
        err.error.response.result.error.error);
}
function isErrorWithNestedErrorField(error) {
    const err = error;
    return !!(err.error && err.error.error);
}
function isErrorWithErrorField(error) {
    const err = error;
    return !!(err.error && !err.message);
}
exports.oopsMessage = (err) => {
    try {
        if (typeof err === 'string') {
            return err;
        }
        else if (isErrorWithNestedResultField(err)) {
            return err.error.response.result.error.error;
        }
        else if (isErrorWithResultField(err)) {
            return err.error.response.result.error;
        }
        else if (isErrorWithNestedErrorField(err)) {
            return err.error.error;
        }
        else if (isErrorWithErrorField(err)) {
            return err.error;
        }
        else {
            return err.message || 'Internal Error';
        }
    }
    catch (err) {
        console.error(err);
        return 'Internal Error';
    }
};
//# sourceMappingURL=oops.js.map