"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('main/main');
debug('loading');
exports.main = (argv, env = process.env, execOptions) => __awaiter(void 0, void 0, void 0, function* () {
    const forceUI = !!argv.find(arg => arg === '--ui') || !!env.KUI_POPUP;
    const isShell = !!argv.find(arg => arg === 'shell');
    const kuiShell = forceUI || isShell;
    const isRunningHeadless = !!env.KUI_HEADLESS && !kuiShell;
    if (!isRunningHeadless) {
        debug('shortcut to graphics');
        const { getCommand, initElectron } = yield Promise.resolve().then(() => require('./spawn-electron'));
        const { argv: strippedArgv, subwindowPlease, subwindowPrefs } = getCommand(argv);
        initElectron(strippedArgv, { isRunningHeadless }, !!(env.subwindowPlease || subwindowPlease), env.subwindowPrefs
            ? typeof env.subwindowPrefs === 'string'
                ? JSON.parse(env.subwindowPrefs)
                : env.subwindowPrefs
            : subwindowPrefs);
    }
    else {
        const { initHeadless } = yield Promise.resolve().then(() => require('./headless'));
        const result = yield initHeadless(argv, false, isRunningHeadless, execOptions).catch(err => {
            if (env.KUI_REPL_MODE) {
                const errResponse = Object.assign({
                    code: err.code,
                    statusCode: err.statusCode,
                    message: err.message
                }, err);
                return errResponse;
            }
            else {
                throw err;
            }
        });
        if (env.KUI_REPL_MODE) {
            if (env.KUI_REPL_MODE === 'stdout') {
                debug('emitting repl mode result');
                console.log(JSON.stringify({
                    type: typeof result,
                    response: result
                }));
            }
            else {
                debug('returning repl mode result', env.KUI_REPL_MODE);
                return result;
            }
        }
    }
    debug('isRunningHeadless %s', isRunningHeadless);
    debug('all done here, the rest is async');
});
if (require.main === module) {
    debug('it looks like this is the main entry point, rather than a require');
    exports.main(process.argv, process.env, process.env.KUI_EXEC_OPTIONS && JSON.parse(process.env.KUI_EXEC_OPTIONS));
}
//# sourceMappingURL=main.js.map