import REPL from './repl';
import { Entity } from './entity';
import { CodedError } from './errors';
import { ExecOptions } from './execOptions';
import { UsageModel } from '../core/usage-error';
import { Tab } from '../webapp/cli';
import { Block } from '../webapp/models/block';
import { StreamableFactory } from './streamable';
import * as Yargs from 'yargs-parser';
export declare type KResponse<Content extends any = any> = Entity<Content>;
export declare enum ExecType {
    TopLevel = 0,
    ClickHandler = 1,
    Nested = 2
}
export interface CommandOptions extends CapabilityRequirements {
    noArgs?: boolean;
    usage?: UsageModel;
    flags?: YargsParserFlags;
    hidden?: boolean;
    incognito?: 'popup'[];
    viewName?: string;
    width?: number;
    height?: number;
    clearREPLOnLoad?: boolean;
    placeholder?: string;
    isDirectory?: boolean;
    listen?: CommandListener;
    docs?: string;
    synonymFor?: Command<KResponse, ParsedOptions>;
    hide?: boolean;
    override?: CommandHandler<KResponse, ParsedOptions>;
    plugin?: string;
    okOptions?: string[];
    isIntention?: boolean;
    requiresFullyQualifiedRoute?: boolean;
}
export interface Event {
    tab?: Tab;
    command?: string;
    route?: string;
    plugin?: string;
    isIntention?: boolean;
    error?: string;
    options?: string[];
    execType?: ExecType;
    isDrilldown?: boolean;
}
export interface ParsedOptions {
    _?: string[];
    [key: string]: string | boolean | number | string[];
}
export interface CommandLine<Options = ParsedOptions> {
    command: string;
    argv: string[];
    argvNoOptions: string[];
    parsedOptions: Options;
}
export interface EvaluatorArgs<Options = ParsedOptions> extends CommandLine<Options> {
    tab: Tab;
    REPL: REPL;
    execOptions: ExecOptions;
    createOutputStream: StreamableFactory;
    block: Block | boolean;
    nextBlock: HTMLElement;
}
export declare type CommandHandler<T extends KResponse, O extends ParsedOptions> = (args: EvaluatorArgs<O>) => T | Promise<T>;
export declare type CommandOverrideHandler<T extends KResponse, O extends ParsedOptions> = (args: EvaluatorArgs<O>, underlyingHandler: CommandHandler<T, O>) => T | Promise<T>;
export interface Evaluator<T extends KResponse, O extends ParsedOptions> {
    eval: CommandHandler<T, O>;
}
export interface CommandBase {
    route: string;
    plugin?: string;
    options?: CommandOptions;
}
declare type CommandKey = string;
interface CommandKeyMap {
    [key: string]: Command<KResponse, ParsedOptions>;
}
export interface Disambiguator {
    [key: string]: CommandBase[];
}
export interface Command<T extends KResponse, O extends ParsedOptions> extends CommandBase {
    $: CommandHandler<T, O>;
    key: CommandKey;
    parent: Command<KResponse, ParsedOptions>;
    children?: CommandKeyMap;
    synonyms?: CommandKeyMap;
}
export declare type CommandTree = Command<KResponse, ParsedOptions>;
export interface CapabilityRequirements {
    needsUI?: boolean;
    inBrowserOk?: boolean;
    requiresLocal?: boolean;
    noAuthOk?: boolean | string[];
    fullscreen?: boolean;
}
export declare type OnSuccess = (args: {
    tab: Tab;
    type: ExecType;
    command: string;
    isDrilldown: boolean;
    parsedOptions: ParsedOptions;
}) => void;
export declare type OnError = (command: string, tab: Tab, type: ExecType, err: CodedError) => CodedError;
export interface CommandHandlerWithEvents<T extends KResponse, O extends ParsedOptions> extends Evaluator<T, O> {
    subtree: Command<T, O>;
    route: string;
    options: CommandOptions;
    success: OnSuccess;
    error: OnError;
}
export declare function isCommandHandlerWithEvents<T extends KResponse, O extends ParsedOptions>(evaluator: Evaluator<T, O>): evaluator is CommandHandlerWithEvents<T, O>;
export declare type CommandTreeResolution<T extends KResponse, O extends ParsedOptions> = boolean | CommandHandlerWithEvents<T, O> | CodedError;
export interface YargsParserFlags {
    configuration?: Partial<Yargs.Configuration>;
    boolean?: string[];
    narg?: Record<string, number>;
    alias?: Record<string, string[]>;
}
export declare type CatchAllOffer = (argv: string[]) => boolean;
export interface CatchAllHandler<T extends KResponse, O extends ParsedOptions> extends Command<T, O> {
    prio: number;
    plugin: string;
    offer: CatchAllOffer;
    eval: CommandHandler<T, O>;
}
declare type CommandListener = <T extends KResponse, O extends ParsedOptions>(route: string, handler: CommandHandler<T, O>, options?: CommandOptions) => Command<T, O>;
export interface CommandRegistrar {
    find: <T extends KResponse, O extends ParsedOptions>(route: string, fromPlugin?: string, noOverride?: boolean) => Promise<Command<T, O>>;
    listen: CommandListener;
    override: <T extends KResponse, O extends ParsedOptions>(route: string, fromPlugin: string, handler: CommandOverrideHandler<T, O>, options?: CommandOptions) => Promise<Command<T, O>>;
    synonym: <T extends KResponse, O extends ParsedOptions>(route: string, handler: CommandHandler<T, O>, master: Command<T, O>, options?: CommandOptions) => void;
    subtree: <T extends KResponse, O extends ParsedOptions>(route: string, options: CommandOptions) => Command<T, O>;
    subtreeSynonym: <T extends KResponse, O extends ParsedOptions>(route: string, masterTree: Command<T, O>, options?: CommandOptions) => void;
    catchall: <T extends KResponse, O extends ParsedOptions>(offer: CatchAllOffer, handler: CommandHandler<T, O>, prio: number, options: CommandOptions) => void;
}
export {};
