"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const table_1 = require("../webapp/models/table");
function isMessageBearingEntity(entity) {
    return entity.message !== undefined;
}
exports.isMessageBearingEntity = isMessageBearingEntity;
function isMetadataBearing(spec) {
    const meta = spec;
    return meta !== undefined && meta.metadata !== undefined && meta.metadata.name !== undefined;
}
exports.isMetadataBearing = isMetadataBearing;
function hasDisplayName(resource) {
    const res = resource;
    return isMetadataBearing(resource) && res.spec !== undefined && typeof res.spec.displayName === 'string';
}
exports.hasDisplayName = hasDisplayName;
function isMetadataBearingByReference(spec) {
    const ref = spec;
    return ref !== undefined && ref.resource !== undefined && isMetadataBearing(ref.resource);
}
exports.isMetadataBearingByReference = isMetadataBearingByReference;
function isMixedResponse(response) {
    return (Array.isArray(response) &&
        response.length > 0 &&
        (typeof response[0] === 'string' || table_1.isTable(response[0])));
}
exports.isMixedResponse = isMixedResponse;
function isLowLevelLoop(entity) {
    const looper = entity;
    return looper.mode === 'prompt';
}
exports.isLowLevelLoop = isLowLevelLoop;
function isResourceModification(entity) {
    const mod = entity;
    return (mod !== undefined && mod.verb === 'delete' && typeof mod.kind === 'string' && typeof mod.metadata.name === 'string');
}
exports.isResourceModification = isResourceModification;
function isRawResponse(entity) {
    const raw = entity;
    return raw.mode === 'raw' && raw.content !== undefined;
}
exports.isRawResponse = isRawResponse;
//# sourceMappingURL=entity.js.map