declare type FilterFunction = (line: HistoryLine) => boolean;
export interface HistoryLine {
    entityType?: string;
    verb?: string;
    response?: any;
    raw?: string;
}
export declare class HistoryModel {
    private _lines;
    private _cursor;
    constructor();
    line(idx: number): HistoryLine;
    slice(start: number, end: number): HistoryLine[];
    get cursor(): number;
    private guardedChange;
    wipe(): boolean;
    add(line: HistoryLine): number;
    update(cursor: number, updateFn: (line: HistoryLine) => void): void;
    lineByIncr(incr: number): HistoryLine;
    previous(): HistoryLine;
    next(): HistoryLine;
    first(): HistoryLine;
    last(): HistoryLine;
    findIndex(filter: string | RegExp | FilterFunction, startIdx?: number): number;
    find(filter: FilterFunction): HistoryLine;
}
export declare const History: HistoryModel;
export default History;
