"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
function getCommand(tab, resource, button, args) {
    if (types_1.isViewButton(button)) {
        return button.command;
    }
    else {
        const cmd = typeof button.command === 'string' ? button.command : button.command(tab, resource, args);
        if (button.confirm) {
            return `confirm "${cmd}"`;
        }
        else {
            return cmd;
        }
    }
}
function onclick(tab, resource, button, args) {
    const cmd = getCommand(tab, resource, button, args);
    if (typeof cmd === 'string') {
        if (types_1.isViewButton(button) || button.confirm) {
            return tab.REPL.qexec(cmd, undefined, undefined, { rethrowErrors: true });
        }
        else {
            return tab.REPL.pexec(cmd);
        }
    }
    else {
        cmd(tab, resource, args);
    }
}
exports.onclick = onclick;
//# sourceMappingURL=button.js.map