"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const plugins = require("./plugins");
const scanner_1 = require("./scanner");
const events_1 = require("../core/events");
const tree_1 = require("../commands/tree");
const debug = debug_1.default('core/plugins/assembler');
const prescanned = () => require.resolve('@kui-shell/prescan');
const writePrescanned = (modules, destFile = prescanned()) => __awaiter(void 0, void 0, void 0, function* () {
    debug('writePrescanned', process.cwd(), destFile, modules);
    const str = JSON.stringify(modules);
    yield fs_extra_1.ensureFile(destFile);
    yield fs_extra_1.writeFile(destFile, str);
});
const makeTree = (map, docs) => {
    const keys = Object.keys(map);
    if (keys.length === 0) {
        debug('interesting, not a single command registered a usage model');
        console.error('Warning: none of your commands registered a usage model');
        return {};
    }
    keys.sort();
    const newLeaf = (route) => ({ route });
    const newNode = (route) => Object.assign(newLeaf(route), { children: {} });
    const getOrCreate = (tree, pathPrefix) => {
        if (!tree.children) {
            tree.children = {};
        }
        const entry = tree.children[pathPrefix];
        if (!entry) {
            tree.children[pathPrefix] = newNode(pathPrefix);
            return tree.children[pathPrefix];
        }
        else {
            return entry;
        }
    };
    const tree = keys.reduce((tree, route) => {
        const split = route.split(/\//);
        let subtree = tree;
        for (let idx = 0; idx < split.length; idx++) {
            const pathPrefix = split.slice(0, idx).join('/');
            subtree = getOrCreate(subtree, pathPrefix);
        }
        if (!subtree.children)
            subtree.children = {};
        const leaf = (subtree.children[route] = newLeaf(route));
        leaf.usage = map[route];
        leaf.docs = (leaf.usage && leaf.usage.header) || docs[route];
        return tree;
    }, newNode('/'));
    return tree.children[''].children[''].children;
};
const amendWithUsageModels = (modules) => {
    modules.docs = {};
    modules.usage = {};
    tree_1.getModel().forEachNode(({ route, options, synonyms }) => {
        if (options && options.usage) {
            modules.usage[route] = Object.assign({ route }, options.usage);
            if (options.needsUI)
                modules.usage[route].needsUI = true;
            if (options.requiresLocal)
                modules.usage[route].requiresLocal = true;
            if (options.synonymFor)
                modules.usage[route].synonymFor = options.synonymFor.route;
            if (synonyms)
                modules.usage[route].synonyms = Object.keys(synonyms).map(route => synonyms[route].key);
            if (options.usage.docs) {
                modules.docs[route] = options.usage.docs;
            }
        }
        if (options && options.docs) {
            modules.docs[route] = options.docs;
        }
    });
    modules.usage = makeTree(modules.usage, modules.docs);
    return modules;
};
exports.compile = (pluginRoot = process.env.PLUGIN_ROOT || path_1.join(__dirname, plugins.pluginRoot), externalOnly = false) => __awaiter(void 0, void 0, void 0, function* () {
    debug('pluginRoot is %s', pluginRoot);
    debug('externalOnly is %s', externalOnly);
    tree_1.initIfNeeded();
    const modules = yield scanner_1.assemble(plugins.registrar, { externalOnly, pluginRoot });
    debug('modules', modules);
    const fixupOnePath = (filepath) => {
        const pattern = new RegExp(`^(.*\\${path_1.sep})(plugin-.*)$`);
        const fixed = externalOnly ? filepath : path_1.relative(pluginRoot, filepath).replace(pattern, '$2');
        return fixed;
    };
    const fixupPaths = (pluginList) => pluginList.map(plugin => Object.assign(plugin, {
        path: fixupOnePath(plugin.path)
    }));
    const model = Object.assign(modules, {
        preloads: fixupPaths(modules.preloads),
        flat: fixupPaths(modules.flat)
    });
    const modelWithUsage = amendWithUsageModels(model);
    const destFile = externalOnly ? path_1.join(pluginRoot, '@kui-shell/prescan.json') : prescanned();
    yield Promise.all([writePrescanned(modelWithUsage, destFile)]);
    if (externalOnly) {
        plugins._useUpdatedUserPrescan(modelWithUsage);
    }
});
function compileUserInstalled(pluginToBeRemoved) {
    return __awaiter(this, void 0, void 0, function* () {
        debug('compileUserInstalled', pluginToBeRemoved);
        const home = yield plugins.userInstalledHome();
        const pluginRoot = path_1.join(home, 'node_modules');
        yield exports.compile(pluginRoot, true);
        events_1.default.emit('/plugin/compile/done');
    });
}
exports.compileUserInstalled = compileUserInstalled;
exports.default = exports.compile;
debug('loading done');
//# sourceMappingURL=assembler.js.map