"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('core/plugins/preloader');
debug('loading');
const path_1 = require("./path");
const capabilities_1 = require("../core/capabilities");
const command_tree_1 = require("../core/command-tree");
const badges_1 = require("../webapp/views/registrar/badges");
const modes_1 = require("../webapp/views/registrar/modes");
class PreloaderRegistrarImpl extends command_tree_1.ImplForPlugins {
    constructor(plugin) {
        super(plugin);
    }
    registerMode(registration) {
        modes_1.registerSidecarMode(registration);
    }
    registerModes(...registrations) {
        registrations.forEach(_ => this.registerMode(_));
    }
    registerBadge(registration) {
        badges_1.registerSidecarBadge(registration);
    }
    registerBadges(...registrations) {
        registrations.forEach(_ => this.registerBadge(_));
    }
    registerStatusStripeContribution({ fragment, listener }, position) {
        return __awaiter(this, void 0, void 0, function* () {
            const { default: StatusStripe } = yield Promise.resolve().then(() => require('../webapp/status-stripe'));
            const controller = StatusStripe.addTo(position, fragment);
            Promise.all([Promise.resolve().then(() => require('../core/events')), Promise.resolve().then(() => require('../webapp/tab'))]).then(([{ default: eventBus }, { getCurrentTab }]) => {
                const doRegister = (tab) => {
                    if (!tab._kui_session) {
                        console.error('bug in plugin: you probably registered your status stripe contribution in the registerCapability phase, rather than preload phase');
                    }
                    else {
                        tab._kui_session.then(() => {
                            listener(tab, controller, fragment);
                            controller.listen(listener);
                        });
                    }
                };
                const tab = getCurrentTab();
                if (!tab._kui_session) {
                    eventBus.once('/tab/new', doRegister);
                }
                else {
                    doRegister(tab);
                }
            });
        });
    }
    registerContext(contrib) {
        return this.registerStatusStripeContribution(contrib, 'context');
    }
    registerMeter(contrib) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.registerStatusStripeContribution(contrib, 'meter');
        });
    }
}
exports.default = (prescan) => __awaiter(void 0, void 0, void 0, function* () {
    debug('init');
    const jobs = Promise.all(prescan.preloads.map((module) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            debug('preloading capabilities.1 %s', module.path);
            const registrationRef = module.path.charAt(0) === '/'
                ? yield Promise.resolve().then(() => require(module.path))
                : capabilities_1.isHeadless()
                    ? yield Promise.resolve().then(() => require(path_1.mainPath(module.path)))
                    : yield Promise.resolve().then(() => require('@kui-shell/plugin-' + path_1.webpackPath(module.route) + '/mdist/preload'));
            debug('preloading capabilities.2 %s', module.path);
            const registration = registrationRef.registerCapability;
            if (registration && typeof registration === 'function') {
                yield registration(new PreloaderRegistrarImpl(module.route));
                debug('registered capabilities %s', module.path);
            }
            else {
                debug('no registered capabilities %s', module.path);
            }
        }
        catch (err) {
            debug('error registering capabilities', module.path, err);
            console.error(err);
        }
    })))
        .then(() => __awaiter(void 0, void 0, void 0, function* () {
        yield Promise.resolve().then(() => require('../core/events')).then(({ default: eventBus }) => {
            eventBus.once('/tab/new', (tab) => {
                if (tab._kui_session === undefined) {
                    tab._kui_session = Promise.resolve();
                }
            });
        });
    }))
        .then(() => Promise.all(prescan.preloads.map((module) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            debug('preloading misc %s', module.path);
            const registrationRef = module.path.charAt(0) === '/'
                ? yield Promise.resolve().then(() => require(module.path))
                : capabilities_1.isHeadless()
                    ? yield Promise.resolve().then(() => require(path_1.mainPath(module.path)))
                    : yield Promise.resolve().then(() => require('@kui-shell/plugin-' + path_1.webpackPath(module.route) + '/mdist/preload'));
            const registration = registrationRef.default || registrationRef;
            if (registration && typeof registration === 'function') {
                yield registration(new PreloaderRegistrarImpl(module.route));
            }
            debug('done preloading %s', module.path);
        }
        catch (err) {
            debug('error invoking preload', module.path, err);
            console.error(err);
        }
    }))));
    try {
        yield jobs;
    }
    catch (err) {
        console.error(err);
    }
    debug('done');
});
//# sourceMappingURL=preloader.js.map