"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.patterns = {
    commentLine: /\s+#.*$/,
    dash: /-([^\s]*)/,
    whitespace: /\s/
};
const escape = (str) => str.replace(exports.patterns.dash, "'-$1'");
const resolveEnvVar = (variable) => {
    const envValue = process.env[variable.substring(1)];
    return envValue ? escape(envValue) : variable;
};
exports._split = (str, removeOuterQuotes = true, returnIndices = false, removeInlineOuterQuotes = false) => {
    const A = [];
    const endIndices = [];
    const stack = [];
    let cur = '';
    const endsWithQuoteSpace = (idx, lookFor) => {
        for (let ii = idx + 1; ii < str.length; ii++) {
            if (str.charAt(ii) === lookFor) {
                return ii === str.length - 1 || /\s/.test(str.charAt(ii + 1));
            }
        }
        return false;
    };
    const removedLastOpenQuote = [];
    let escapeActive = false;
    for (let idx = 0; idx < str.length; idx++) {
        const char = str.charAt(idx);
        if (char === '\\') {
            if (!escapeActive) {
                escapeActive = true;
            }
            else {
                escapeActive = false;
                cur += '\\';
            }
            continue;
        }
        else if (!escapeActive) {
            escapeActive = false;
        }
        if (stack.length === 0 && !escapeActive && exports.patterns.whitespace.test(char)) {
            if (cur.length > 0) {
                A.push(resolveEnvVar(cur));
                endIndices.push(idx);
                cur = '';
            }
            continue;
        }
        const last = stack.length > 0 && stack[stack.length - 1];
        if (char === '{') {
            stack.push(char);
        }
        else if (char === '}' && last === '{') {
            stack.pop();
        }
        if (!escapeActive && (char === "'" || char === '"')) {
            if (char === last) {
                stack.pop();
                const removedLast = removedLastOpenQuote.pop();
                if (stack.length > 0 || !removedLast) {
                    cur += char;
                }
            }
            else {
                const removeQuote = removeOuterQuotes &&
                    endsWithQuoteSpace(idx, char) &&
                    (idx === 0 ||
                        (stack.length === 0 && (removeInlineOuterQuotes || exports.patterns.whitespace.test(str.charAt(idx - 1)))));
                removedLastOpenQuote.push(removeQuote);
                if (stack.length > 0 || !removeQuote) {
                    cur += char;
                }
                stack.push(char);
            }
        }
        else {
            cur += char;
        }
    }
    if (cur.length > 0) {
        A.push(resolveEnvVar(cur));
        endIndices.push(str.length);
    }
    if (returnIndices) {
        return { A, endIndices };
    }
    else {
        return A;
    }
};
exports.split = (str, removeOuterQuotes = true, removeInlineOuterQuotes = false) => {
    return exports._split(str, removeOuterQuotes, undefined, removeInlineOuterQuotes);
};
//# sourceMappingURL=split.js.map