"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function clone(instance) {
    const copy = new instance.constructor();
    Object.assign(copy, instance);
    return copy;
}
class ClassList {
    constructor() {
        this.classList = [];
    }
    get length() {
        return this.classList.length;
    }
    forEach(fn) {
        this.classList.forEach(fn);
    }
    add(_) {
        return this.classList.push(_);
    }
    contains(_) {
        return this.classList.indexOf(_) >= 0;
    }
    remove(_) {
        const idx = this.classList.findIndex((x) => x === _);
        if (idx >= 0) {
            this.classList.splice(idx, 1);
        }
    }
}
class ElementMimic {
    constructor() {
        this._isFakeDom = true;
        this.value = '';
        this.innerText = '';
        this.innerHTML = '';
        this.className = '';
        this.classList = new ClassList();
        this.nodeType = '';
        this.style = {};
        this.children = [];
        this.cells = [];
        this.rows = [];
        this._attrs = {};
    }
    focus() {
    }
    appendChild(c) {
        return this.children.push(c);
    }
    getAttribute(k) {
        return this._attrs[k] || '';
    }
    setAttribute(k, v) {
        this._attrs[k] = v;
        return v;
    }
    remove() {
    }
    removeAttribute(k) {
        const attr = this._attrs[k];
        delete this._attrs[k];
        return attr;
    }
    cloneNode() {
        return clone(this);
    }
    querySelectorAll(selector) {
        return [];
    }
    querySelector() {
        return new ElementMimic();
    }
    addEventListener() {
        return true;
    }
    hasStyle(style, desiredValue) {
        const actualValue = this.style && this.style[style];
        if (desiredValue)
            return desiredValue == actualValue;
        else
            return actualValue;
    }
    recursiveInnerTextLength() {
        return (this.innerText.length + this.children.reduce((sum, child) => sum + child.recursiveInnerTextLength(), 0));
    }
    insertRow(idx) {
        const row = new ElementMimic();
        row.nodeType = 'tr';
        row.cells = [];
        if (idx === -1)
            this.rows.push(row);
        else
            this.rows.splice(idx, 0, row);
        return row;
    }
    insertCell(idx) {
        const cell = new ElementMimic();
        cell.nodeType = 'td';
        if (idx === -1)
            this.cells.push(cell);
        else
            this.cells.splice(idx, 0, cell);
        return cell;
    }
    static isFakeDom(dom) {
        return dom && dom._isFakeDom;
    }
}
exports.default = ElementMimic;
//# sourceMappingURL=element-mimic.js.map