"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const os_1 = require("os");
const homedir = os_1.homedir();
exports.expandHomeDir = function (path) {
    if (!path) {
        return path;
    }
    else if (path === '~') {
        return homedir;
    }
    else if (path.slice(0, 2) !== '~/' && path.slice(0, 2) !== '~\\') {
        return path;
    }
    else {
        return path_1.join(homedir, path.slice(2));
    }
};
exports.default = exports.expandHomeDir;
//# sourceMappingURL=home.js.map