"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const defaultLocale = 'en_US';
function getLocale() {
    return process.env.LOCALE || (typeof navigator !== 'undefined' && navigator.language);
}
function getLocale2() {
    const locale = getLocale();
    return locale && locale.replace(/-/, '_');
}
function fromMap(map) {
    return map[getLocale()] || map[getLocale2()] || map[defaultLocale];
}
exports.fromMap = fromMap;
exports.default = (plugin, namespace = 'resources') => {
    const defaultStrings = require(`@kui-shell/${plugin}/i18n/${namespace}_en_US.json`);
    const locale = getLocale();
    const i18n = (locale) => {
        try {
            return locale && require(`@kui-shell/${plugin}/i18n/${namespace}_${locale.replace(/-/, '_')}.json`);
        }
        catch (err) {
            try {
                return ((locale && require(`@kui-shell/${plugin}/i18n/${namespace}_${locale.replace(/-.*$/, '')}.json`)) ||
                    defaultStrings);
            }
            catch (err) {
                console.error('Could not find translation for given locale', plugin, locale);
                return defaultStrings;
            }
        }
    };
    const _strings = i18n(locale);
    return function (key, ...parameters) {
        const str = _strings[key] || defaultStrings[key] || key;
        if (!parameters)
            return str;
        else
            return parameters
                .map(_ => _.toString())
                .reduce((str, param, idx) => {
                return str.replace(new RegExp(`\\{${idx}\\}`, 'g'), param.toString());
            }, str);
    };
};
//# sourceMappingURL=i18n.js.map