"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const listen_1 = require("./listen");
const scroll_1 = require("./scroll");
const queueing_1 = require("./queueing");
const prompt_1 = require("./prompt");
const tab_1 = require("./tab");
const events_1 = require("../core/events");
exports.getInitialBlock = (tab) => {
    return tab.querySelector('.repl .repl-block.repl-initial');
};
exports.getCurrentBlock = (tab = tab_1.getCurrentTab()) => {
    return tab.querySelector('.repl .repl-active');
};
exports.getCurrentProcessingBlock = (tab = tab_1.getCurrentTab()) => {
    return tab.querySelector('.repl .repl-block.processing');
};
exports.removeAnyTemps = (block, fullClean = false) => {
    const temps = block.querySelectorAll('.repl-temporary');
    for (let idx = 0; idx < temps.length; idx++) {
        const temp = temps[idx];
        if (temp.parentNode) {
            temp.parentNode.removeChild(temp);
        }
    }
    if (fullClean) {
        const streamingOutput = block.querySelector('[data-stream="data-stream"]');
        if (streamingOutput) {
            if (streamingOutput.parentNode) {
                streamingOutput.parentNode.removeChild(streamingOutput);
            }
        }
    }
    block.classList.remove('using-custom-prompt');
    return block;
};
exports.installBlock = (parentNode, currentBlock, nextBlock) => () => __awaiter(void 0, void 0, void 0, function* () {
    if (!nextBlock)
        return;
    parentNode.appendChild(nextBlock);
    listen_1.listen(prompt_1.getPrompt(nextBlock));
    if (!document.activeElement.classList.contains('grab-focus')) {
        nextBlock.querySelector('input').focus();
    }
    const currentIndex = currentBlock.parentNode ? parseInt(currentBlock.getAttribute('data-input-count'), 10) : -1;
    nextBlock.setAttribute('data-input-count', (currentIndex + 1).toString());
    prompt_1.installContext(nextBlock);
    scroll_1.scrollIntoView({ when: 100 });
    events_1.default.emit('/core/cli/install-block', tab_1.getTabFromTarget(currentBlock));
    yield queueing_1.handleQueuedInput(nextBlock);
});
function subblock() {
    const block = document.createElement('div');
    const blockResult = document.createElement('div');
    blockResult.classList.add('repl-result');
    block.classList.add('processing');
    block.classList.add('kui--repl-subblock');
    block.appendChild(blockResult);
    return block;
}
exports.subblock = subblock;
function getCount(block) {
    return parseInt(block.getAttribute('data-input-count'));
}
exports.resetCount = (block) => {
    block.setAttribute('data-input-count', '0');
};
exports.setCustomCaret = (block) => {
    block.classList.add('custom-caret');
};
function isMostRecentBlock(tab, block) {
    const lastBlock = tab.querySelector('.repl .repl-block:last-child');
    const lastCount = getCount(lastBlock);
    const ourCount = getCount(block);
    return lastCount === ourCount || (lastBlock.classList.contains('repl-active') && lastCount === ourCount + 1);
}
exports.isMostRecentBlock = isMostRecentBlock;
//# sourceMappingURL=block.js.map