"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
function catastrophe(err) {
    console.error('restart needed');
    console.error(err);
    document.body.classList.add('oops-total-catastrophe');
}
function initCommandRegistrar() {
    return __awaiter(this, void 0, void 0, function* () {
        const { init } = yield Promise.resolve().then(() => require('../../commands/tree'));
        yield init();
    });
}
const domReady = () => () => __awaiter(void 0, void 0, void 0, function* () {
    const initializer = Promise.resolve().then(() => require('./init'));
    const plugins = Promise.resolve().then(() => require('../../plugins/plugins'));
    const cli = Promise.resolve().then(() => require('../../webapp/cli-init'));
    const sidecarInit = Promise.resolve().then(() => require('../views/sidecar-init'));
    const events = Promise.resolve().then(() => require('../../core/events'));
    try {
        const waitForThese = [];
        const commands = initCommandRegistrar();
        waitForThese.push(plugins.then((_) => __awaiter(void 0, void 0, void 0, function* () {
            yield _.init();
            yield commands;
            yield _.preload();
        })));
        waitForThese.push((document.body.classList.contains('in-electron')
            ? Promise.resolve().then(() => require('../electron-events')).then(_ => _.init())
            : Promise.resolve())
            .then(() => cli)
            .then(_ => _.default()));
        sidecarInit.then(_ => _.default());
        waitForThese.push(waitForThese[1].then(() => initializer).then(_ => _.init()));
        yield Promise.all(waitForThese);
        document.body.classList.remove('still-loading');
        events.then(eventBus => eventBus.default.emit('/init/done'));
    }
    catch (err) {
        catastrophe(err);
    }
});
exports.default = () => __awaiter(void 0, void 0, void 0, function* () {
    Promise.resolve().then(() => require('./init')).then(_ => _.preinit());
    window.addEventListener('load', domReady(), { once: true });
});
//# sourceMappingURL=boot.js.map