"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const keys_1 = require("./keys");
const paste_1 = require("./paste");
const listen_1 = require("./listen");
const tab_1 = require("./tab");
const popup_core_1 = require("./popup-core");
const block_1 = require("./block");
const prompt_1 = require("./prompt");
const capabilities_1 = require("../core/capabilities");
const settings_1 = require("../core/settings");
exports.default = () => __awaiter(void 0, void 0, void 0, function* () {
    const tab = tab_1.getCurrentTab();
    prompt_1.installContext(block_1.getInitialBlock(tab));
    listen_1.listen(prompt_1.getInitialPrompt(tab));
    if (popup_core_1.isPopup()) {
        document.body.addEventListener('keydown', (event) => __awaiter(void 0, void 0, void 0, function* () {
            const char = event.keyCode;
            if (char === keys_1.keys.L && (event.ctrlKey || (capabilities_1.inElectron() && event.metaKey))) {
                const { getSidecar } = yield Promise.resolve().then(() => require('./views/sidecar'));
                const input = getSidecar(tab_1.getCurrentTab()).querySelector('.repl-input input');
                input.focus();
                input.setSelectionRange(0, input.value.length);
            }
        }));
    }
    if (settings_1.inBottomInputMode) {
        prompt_1.getCurrentPrompt(tab).onpaste = paste_1.paste;
    }
});
//# sourceMappingURL=cli-init.js.map