"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/cli/print');
debug('loading');
const status_1 = require("./status");
const listen_1 = require("./listen");
const popup_core_1 = require("./popup-core");
const scroll_1 = require("./scroll");
const popup_1 = require("./popup");
const custom_content_1 = require("./views/custom-content");
const presentation_1 = require("./views/presentation");
const sidecar_present_1 = require("./views/sidecar-present");
const types_1 = require("../util/types");
const async_1 = require("../util/async");
const watchable_1 = require("../core/jobs/watchable");
const command_1 = require("../models/command");
const table_1 = require("./models/table");
const is_1 = require("../models/mmr/is");
const entity_1 = require("../models/entity");
const usage_error_1 = require("../core/usage-error");
const printTable = (tab, response, resultDom, block, args) => __awaiter(void 0, void 0, void 0, function* () {
    ;
    resultDom.parentNode.classList.add('result-as-table', 'result-as-vertical');
    if (response.noEntityColors) {
        resultDom.classList.add('result-table-with-custom-entity-colors');
    }
    const { formatTable } = yield Promise.resolve().then(() => require('./views/table'));
    formatTable(tab, response, resultDom, args, { block });
});
exports.streamTo = (tab, block, argvNoOptions, parsedOptions) => {
    const container = block.querySelector('.repl-output');
    const resultDom = container ? document.createElement('div') : block.querySelector('.repl-result');
    if (container) {
        container.classList.add('repl-result-has-content');
        container.insertBefore(resultDom, container.childNodes[0]);
    }
    let previousLine;
    return (response, killLine = false) => {
        resultDom.setAttribute('data-stream', 'data-stream');
        resultDom.parentNode.classList.add('result-vertical');
        if (killLine && previousLine) {
            previousLine.parentNode.removeChild(previousLine);
            previousLine = undefined;
        }
        const formatPart = (response, resultDom) => __awaiter(void 0, void 0, void 0, function* () {
            if (usage_error_1.default.isUsageError(response)) {
                previousLine = yield usage_error_1.default.getFormattedMessage(response);
                resultDom.appendChild(previousLine);
                resultDom.classList.add('oops');
                resultDom.setAttribute('data-status-code', response.code.toString());
            }
            else if (entity_1.isMixedResponse(response)) {
                async_1.promiseEach(response, _ => {
                    const para = document.createElement('p');
                    para.classList.add('kui--mixed-response--text');
                    resultDom.appendChild(para);
                    return formatPart(_, para);
                });
            }
            else if (types_1.isHTML(response)) {
                response.classList.add('repl-result-like');
                previousLine = response;
                resultDom.appendChild(previousLine);
            }
            else if (table_1.isTable(response)) {
                const wrapper = document.createElement('div');
                wrapper.classList.add('repl-result');
                resultDom.appendChild(wrapper);
                yield printTable(tab, response, wrapper, block, { argvNoOptions, parsedOptions });
            }
            else if (custom_content_1.isCustomSpec(response)) {
                const { showCustom } = yield Promise.resolve().then(() => require('./views/sidecar'));
                showCustom(tab, response, {}, argvNoOptions, parsedOptions);
            }
            else {
                previousLine = document.createElement('pre');
                previousLine.classList.add('streaming-output', 'repl-result-like');
                previousLine.innerText = entity_1.isMessageBearingEntity(response) ? response.message : response.toString();
                resultDom.appendChild(previousLine);
            }
        });
        return formatPart(response, resultDom).then(() => {
            scroll_1.scrollIntoView({ element: resultDom, when: 0 });
        });
    };
};
exports.ok = (parentNode, suffix, css) => {
    const okLine = document.createElement('div');
    okLine.classList.add('ok-line');
    const replResultBlock = parentNode.parentNode.querySelector('.repl-result');
    const resultHasContent = replResultBlock.children.length > 0;
    if (resultHasContent) {
        ;
        replResultBlock.parentNode.classList.add('repl-result-has-content');
    }
    const ok = document.createElement('span');
    okLine.appendChild(ok);
    ok.classList.add('ok');
    ok.appendChild(document.createTextNode(suffix ? 'ok:' : 'ok'));
    if (suffix) {
        ok.classList.add('inline-ok');
        okLine.appendChild(typeof suffix === 'string' ? document.createTextNode(` ${suffix}`) : suffix);
    }
    if (css) {
        okLine.classList.add(css);
    }
    parentNode.appendChild(okLine);
    return okLine;
};
function renderResult(response, tab, resultDom, block, echo = true, attach = echo, args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (table_1.isTable(response)) {
            yield printTable(tab, response, resultDom, block, args);
            return true;
        }
        else if (types_1.isHTML(response)) {
            if (attach) {
                resultDom.appendChild(response);
            }
            if (echo) {
                ;
                resultDom.parentNode.classList.add('result-vertical');
                exports.ok(resultDom.parentElement).classList.add('ok-for-list');
            }
            return true;
        }
        else {
            return false;
        }
    });
}
function replResult() {
    const resultContainer = document.createElement('div');
    const resultDom = document.createElement('div');
    resultDom.classList.add('repl-result');
    resultContainer.appendChild(resultDom);
    return resultDom;
}
exports.replResult = replResult;
exports.printResults = (block, nextBlock, tab, resultDom, echo = true, argvNoOptions, parsedOptions, execOptions, command, evaluator) => (response) => __awaiter(void 0, void 0, void 0, function* () {
    debug('printResults', response);
    const incognitoHint = evaluator && evaluator.options && evaluator.options.incognito && evaluator.options.incognito;
    const incognito = incognitoHint && popup_core_1.isPopup() && incognitoHint.indexOf('popup') >= 0;
    const presentation = custom_content_1.isCustomSpec(response) && response.presentation;
    let customContainer;
    if (popup_core_1.isPopup() && !incognito) {
        resultDom = customContainer = popup_1.createPopupContentContainer(['valid-response'], presentation || (!Array.isArray(response) && presentation_1.default.SidecarFullscreenForPopups));
    }
    if (process.env.KUI_TEE_TO_FILE) {
        debug('teeing output to file', process.env.KUI_TEE_TO_FILE);
        Promise.resolve().then(() => require('../util/tee')).then(_ => _.default(response));
    }
    if (echo) {
        status_1.setStatus(block, response === false ? "error" : "valid-response");
    }
    const render = (response, { echo, resultDom }) => __awaiter(void 0, void 0, void 0, function* () {
        if (response && response !== true) {
            if (yield renderResult(response, tab, resultDom, block, echo, undefined, { argvNoOptions, parsedOptions })) {
            }
            else if (typeof response === 'number' ||
                typeof response === 'string' ||
                (entity_1.isMessageBearingEntity(response) && !is_1.isMultiModalResponse(response))) {
                if (echo) {
                    const span = document.createElement('pre');
                    span.innerText = entity_1.isMessageBearingEntity(response) ? response.message : response.toString();
                    resultDom.appendChild(span);
                    resultDom.parentNode.classList.add('result-vertical');
                    exports.ok(resultDom.parentElement).classList.add('ok-for-list');
                }
            }
            else if (custom_content_1.isCustomSpec(response)) {
                const echoOk = echo || (execOptions && execOptions.replSilence);
                if (echoOk || (execOptions && execOptions.type === command_1.ExecType.ClickHandler)) {
                    const { showCustom } = yield Promise.resolve().then(() => require('./views/sidecar'));
                    yield showCustom(tab, response, popup_core_1.isPopup() ? Object.assign({}, execOptions, { leaveBottomStripeAlone: true }) : execOptions, argvNoOptions, parsedOptions, customContainer);
                    if (echoOk && !popup_core_1.isPopup()) {
                        exports.ok(resultDom.parentElement);
                    }
                    return !customContainer || customContainer.children.length === 0;
                }
            }
            else if (entity_1.isResourceModification(response) && response.verb === 'delete') {
                if (echo) {
                    if (response.kind) {
                        exports.ok(resultDom, `deleted ${response.kind.replace(/s$/, '')} ${response.metadata.name}`, 'show-in-popup');
                    }
                    else {
                        exports.ok(resultDom);
                    }
                }
            }
            else if (is_1.isMultiModalResponse(response)) {
                const echoOk = echo || (execOptions && execOptions.replSilence);
                const { show: showMultiModalResponse } = yield Promise.resolve().then(() => require('../models/mmr/show'));
                yield showMultiModalResponse(tab, response, { argvNoOptions, parsedOptions });
                if (echoOk && !popup_core_1.isPopup()) {
                    exports.ok(resultDom.parentElement);
                }
            }
            else if (entity_1.isMixedResponse(response)) {
                debug('mixed response');
                const paragraph = (part) => {
                    if (typeof part === 'string') {
                        const para = document.createElement('p');
                        para.classList.add('kui--mixed-response--text');
                        para.innerText = part;
                        return para;
                    }
                    else {
                        return part;
                    }
                };
                response.forEach(part => {
                    exports.printResults(block, nextBlock, tab, resultDom, echo, argvNoOptions, parsedOptions, execOptions, command, evaluator)(paragraph(part));
                });
            }
            else if (typeof response === 'object') {
                const code = document.createElement('code');
                code.appendChild(document.createTextNode(JSON.stringify(response, undefined, 4)));
                resultDom.appendChild(code);
                code.classList.add('hljs', 'json');
                resultDom.parentNode.classList.add('result-vertical');
                exports.ok(resultDom.parentElement).classList.add('ok-for-list');
            }
        }
        else if (response) {
            if (echo)
                exports.ok(resultDom.parentElement);
        }
    });
    if (!watchable_1.isWatchable(response) && table_1.isTable(response) && response.body.length === 0) {
        response = true;
    }
    const promise = render(response, { echo, resultDom });
    if (table_1.isTable(response)) {
        if (popup_core_1.isPopup()) {
            sidecar_present_1.default(tab, presentation_1.default.FixedSize);
        }
        if (echo) {
            promise.then(() => {
                exports.ok(resultDom.parentNode).classList.add('ok-for-list');
            });
        }
    }
    yield promise.then((alreadyRendered) => __awaiter(void 0, void 0, void 0, function* () {
        if (popup_core_1.isPopup() &&
            (Array.isArray(response) ||
                (customContainer && customContainer.children.length > 0) ||
                (custom_content_1.isCustomSpec(response) && response.presentation === presentation_1.default.FixedSize))) {
            if (!incognito) {
                const modes = custom_content_1.isCustomSpec(response) && response.modes;
                const prettyType = (table_1.isTable(response) && response.title) ||
                    (table_1.isTable(response) &&
                        response.body[0] &&
                        (response.body[0].prettyType ||
                            response.body[0].prettyKind ||
                            response.body[0].type ||
                            response.body[0].kind)) ||
                    (entity_1.isMetadataBearing(response) && response.kind) ||
                    false;
                const presentation = (custom_content_1.isCustomSpec(response) && response.presentation) ||
                    (prettyType && Array.isArray(response) && presentation_1.default.FixedSize) ||
                    presentation_1.default.SidecarFullscreenForPopups;
                yield popup_1.renderPopupContent(command, alreadyRendered !== true && resultDom, execOptions, Object.assign({}, response, {
                    modes: modes || undefined,
                    prettyType: prettyType === false ? undefined : prettyType,
                    badges: custom_content_1.isCustomSpec(response) && response.badges,
                    presentation
                }));
            }
            if (!incognito) {
                listen_1.popupListen(undefined, command);
            }
        }
    }));
    return !custom_content_1.isCustomSpec(response);
});
//# sourceMappingURL=print.js.map